
/* -------------------------------------------------------------------

   -----  g05dcf.c  -----

  Seiwi's 1st tiny example for using NAG Fortran-Lib with gcc 2.7.x

  Comments from NAG:
    G05CBF Initialise random number generating routines to give 
           repeatable sequence
    G05DCF Pseudo-random real numbers, logistic distribution


  This demo is the same as d02cbfe.f

  To compile with:
                   f90 g05dcf.c -o g05dcf -lnag -lm

  Tested with: NAG fllux19d9 and NAGWare_f90

  You should get the following output after running g05dcf:

    3.034140
    -0.848981
    0.209907
    -0.854842
    3.970896

 ------------------------------------------------------------------ */


#include <f90.h>
#include <stdio.h>

static int c__0 = 0;
static double c_b6 = 1.;
static double c_b7 = 1.5;

extern int g05cbf_();
extern double g05dcf_();


int main(void)
{
  int i;
  double x;

  printf("G05DCF Example Program Results\n");

  g05cbf_(&c__0);
  for(i = 0; i < 5; i++) {
    x = g05dcf_(&c_b6, &c_b7);
    printf("%lf\n", x);
  }

  return(0);
}




