
#include "server.h"



void usage(void)
{
  fprintf(stderr,"Usage:server  Port"); 
  exit(-1);
}

int clear_order(char *order, long int size)
{
  long int i;
  for(i=0;i<size;i++)
    order[i] ='\0';
  return(0);
}

/*
  the main for our demo
 */
#ifdef DEBUG
int main(void)

{ 
  int argc;
#else
int main(int argc,char *argv[])

{
#endif 
  char c;
  char order[256];

#ifdef DEBUG  
  argc = 2;
  PORT_A = 7683;
#else
   if (argc !=2 )
     usage();
   PORT_A = atoi(argv[1]); 
#endif 
   
   fprintf(stderr,"\nOpening server on Port = %d \n",PORT_A );
   serveropen();

  for(;;){           /* waits for a command by client  */
#ifndef QUIET
    fprintf(stderr,"in mainloop of serverdemo\n");
#endif
    clear_order(order,256);
    get_mes(order, 256);
    c = order[0];    /* decode type of command         */
#ifndef QUIET
    fprintf(stderr,"in mainloop of serverdemo order= %c\n",c);
#endif
    switch(c) {
      case EVAL_STRING: {
	if(server_eval(&order[1]) == 0)
	  send_mes(SUCCESS);
	else 
	  send_mes(NO_SUCCESS);
        break; 
      }

      case SERVER_SEND_ARRAY: {
	if( server_send_array(&order[2]) == 0 )
	  send_mes(SUCCESS);
	else 
	  send_mes(NO_SUCCESS);
        break; 
      }

      case SERVER_GET_ARRAY: {
	server_get_array(&order[2]); break;
	/*
	if()
	  send_mes(SUCCESS);
	else 
	  send_mes(NO_SUCCESS);
        break;
	*/ 
      }
      
    case OUT_BUF:{
	if(output_buffer(&order[1]) == 0)
	  send_mes(SUCCESS);
	else 
	  send_mes(NO_SUCCESS);
        break; 
       
    }
      case  ESCAPE: { 
	serverclose(); 
	return(0); 
      }	
      default : { fprintf(stderr,"%s%s%s\n", 
			"Recieved unkown command ->",order
			  ,"<- press return to continue");
                  fprintf(stderr,"first element of order  = %d\n",order[0] );
                 getchar();
      }
    }
  }

  return(-1);
}



