#include "server.h"

/*
 opens the connection to Port and waits for a client
 passes the name of the server-machine

 sends a SUCCESS to client, if successfull

 global: j ... socket-handler

 return: value = 0 ... success
         else exit program
 */

int serveropen(void)
{
  char hostname[128], hostname2[128];


  /* Fetch our hostname. */
  if (gethostname(hostname, 128) < 0) {
    perror("gethostname");
    exit(-1);
  }

  /* Convert that to an IP address. */
  if ((hp = gethostbyname(hostname)) == (struct hostent *)NULL) {
    perror("gethostbyname");
    exit(-1);
  }

  memcpy((char *) &her.sin_addr, hp->h_addr_list[0], hp->h_length);
  strcpy(hostname, hp->h_name);
  her.sin_family = AF_INET;
  her.sin_port = htons(PORT_A);

  /* Create a socket. */
  if ((s = socket(her.sin_family, SOCK_STREAM, 0)) < 0) {
    perror("socket");
    exit(-1);
  }

  /* All done.  Bind it to our address. */
  if (bind(s, (struct sockaddr *) &her, sizeof(her)) < 0) {
    perror("bind");
    (void) close(s);
    exit(-1);
  }

  /* Bind was OK.  Now post a listen... */
  if (listen(s, 1) < 0) {
    perror("listen");
    (void) close(s);
    exit(-1);
  }

  /* Done.  Await a connection! */
  serveri = sizeof(him);
  if ((j = accept(s, (struct sockaddr *) &him, &serveri)) < 0) {
    perror("accept");
    (void) close(s);
    exit(-1);
  }

  /* recieve clientname */
  get_mes(hostname2, 128);
  fprintf(stderr, "Hostname = %s \n", hostname2);
  /*  setenv("PATH", "/usr/X11R6/bin"); */
  /* setenv("DISPLAY", hostname2,1); */
 
  /*Creating a stream on the socket*/
  fprintf(stderr,"Trying to create a Matlabfile for writing on the socket\n");  
  fpw = fdopen(j,"w");
  if ((mfpw = matCreateMATFile ("test", fpw, "w")) == NULL ){
    fprintf(stderr,"Can't create matfile  \n ");
    exit (-1);
  }
  fprintf(stderr,"Managed to create a Matlabfile on the socket\n");
  
  /*get_mes(buffer ,128);*/
  
  fprintf(stderr,"Trying to create a Matlabfile for reading on the socket\n");  
  fpr = fdopen(j,"r+");
  if ((mfpr = matCreateMATFile ("test", fpr, "r+")) == NULL ){
    fprintf(stderr,"Can't create matfile  \n ");
    exit (-1);
  }
  fprintf(stderr,"Managed to create a Matlabfile on the socket\n");
  
 
  fprintf(stderr,"Trying to open Matlabengine \n");
 
  if (!(ep = engOpen("\0"))) {
    fprintf(stderr, "\nCan't start MATLAB engine\n");
    getchar();
    send_mes(MATLAB_N_O);
    exit( -1);
  }else{

    send_mes(MATLAB_O);
    return(0);
  }
}





