#include "net.h"
#include "user.h"
/*#include "llist_threads.h"*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>

/*some stuff needed by both threads*/
#define FIFO_LENGTH       128
/*#define POINTER_LENGTH      4*/

/*Struct to pass the thread the Portnumber and the name of the server */
typedef struct{
  char *name;
  int port;
}server;



pthread_t thread_machine;

/*place here all your global data you need */


int work(net_engine *, int , int );
void  client_machine(net_engine *);


/* execute the functions specified on the fifo, the return value 
is placed into the place of the first argument, executes each call from the begin 
till to the last but one function.*/

int work(net_engine *net, /* pointer to the net*/
	 int begin,       /*the beginindex of the functions to call */ 
	 int end          /*and the end*/)
{
  int i;

  my_error(" in work: begin = %d, end = %d",begin, end);
 
  assert( begin >= 0 || end < FIFO_LENGTH - 1);

     for(i=begin; i<end; i++){

       my_error("in work: i=%d",i);
       /*Call the specified function by pointer*/
       assert(net->fifo[i].f_ptr == (union par(*)(union par, union par, union par)) (&clientevalstring)   ||
	      net->fifo[i].f_ptr == (union par(*)(union par, union par, union par)) (&clientoutputbuffer) ||
	      net->fifo[i].f_ptr == (union par(*)(union par, union par, union par)) (&client_get_array)   ||
	      net->fifo[i].f_ptr == (union par(*)(union par, union par, union par)) (&client_send_array)  ||
	      net->fifo[i].f_ptr == (union par(*)(union par, union par, union par)) (&clientclose) ); 

        my_error("string = %s :",net->fifo[i].arg2);
       net->fifo[i].arg1 =net-> fifo[i].f_ptr(net->fifo[i].arg1, 
					      net->fifo[i].arg2, 
					      net->fifo[i].arg3);
       
     } 
     return(0);
}

/* 
 * main function of machine_thread
 * calls the function work, with the indices, indicating,
 * where are legal functioncalls
 */
void  client_machine(net_engine *net)
{
  int j;
  int first_order;
  int last_order;


  my_error("in task machine\n");
 
  /*
   * obtain lock, to make sure, that the user_function does not start
   * before connnection to server is established
   */
  pthread_mutex_lock(&net->my_wait);

  /* open server*/
  my_error("Hostname = %s, port = %d\n",net->Hostname,net->Port);
  net->s = clientopen(net->Hostname, net->Port);
  pthread_mutex_unlock(&net->my_wait);

  /*
   *asserts, that main_thread obtains first lock to fifo-indices
   */
  sleep(5);

  /*
   * main loop, calls routine work, will be canceled 
   * by user-thread
   */
  last_order = 0;
  for(;;){
    
    my_error("machine: in main loop\n");

    /*the last read is the new start*/
    first_order = last_order;
 
    my_error("machine: obtain lock\n");
    pthread_mutex_lock(&net->re_wri);
    {
      my_error("machine: got  lock\n");
      /*read and write to shared memory == FIFO*/

      my_error("last_read =%d, last_written = %d, next_needed = %d",net->last_read,
	       net->last_written,net->next_needed);
      my_error("first_order= %d, last_order= %d",first_order, last_order);

      assert(net->last_read >= 0 || net-> last_read< FIFO_LENGTH );
      assert(net->last_written >= 0 || net-> last_written< FIFO_LENGTH );
      
      /*send a signal that the a part of the FIFO has been  processed*/
      pthread_cond_signal(&net->cond_fifo_full);

      /*
       *check for next_needed, in the area between last_read 
       *last_written. next_needed not pointing into FIFO => no results needed
       */
      net->last_read = first_order;
      if ( (net->next_needed >= 0) && (net->next_needed < FIFO_LENGTH) &&
	   ( ( (net->last_read < net->last_written) && 
	       ( (net->next_needed < net->last_written) && (net->next_needed >= net->last_read) ) ) ||       
	     ( (net->last_read > net->last_written) && 
	    !( (!(net->next_needed < net->last_written)) && (!(net->next_needed > net->last_read)) )  ) )  ){
	last_order =net->next_needed + 1; 
	my_error("machine: working till next_needed"); 
      }else{
	last_order =net-> last_written;
	my_error("machine: working till last_written");
      }

      /*send a signal, that the needed function has been executed*/
      if(first_order == (net->next_needed + 1) ){
	my_error("machine: sending signal for condition"); 
	pthread_cond_signal(&net->cond_next_needed);
      }

      /*wait for a signal, that something has been written onto the FIFO*/
      if(first_order == last_order){
	my_error("FIFO empty, waiting for something to happen");
	pthread_cond_wait(&net->cond_fifo_empty,&net->re_wri);
      }



      
      /*last_order = last_written;*/

      my_error("last_read =%d, last_written = %d, next_needed = %d",net->last_read,
	       net->last_written,net->next_needed);
      my_error("first_order= %d, last_order= %d",first_order, last_order);
      my_error("machine: freeing lock re_wri");
    }
    pthread_mutex_unlock(&net->re_wri);


    if (last_order < first_order){
      for(j=0; j <= 1; j++){
	if( j == 0 ){
	  work(net, first_order,FIFO_LENGTH   );
       	}else{
	  work(net, 0,last_order);
	}
      }
    }else if(last_order > first_order) {
      work(net, first_order,last_order);
    }
    
  }
  /* server closed by main thread*/

}

/* 
 *  compare the positon if the two pointers of the FIFO, 
 *   if there is still space return 1
 *  else return 0
 */
int cmp_last_written(net_engine *net)
{
  if(net->last_written == net->next_needed)
    return(0);
  if(net->last_written == FIFO_LENGTH - 1)
    if(net->last_read == 0)
      return(0); 
  if(net->last_written ==  net->last_read - 1)
    return(0);  
  return (1);
}
/* counting for FIFO for user
 * when called returns index of the next free place
 * in FIFO
 */
int fifopointer(net_engine *net)
 { /*last_written, last_read, next_needed*/
   int actual_pointer;

   while ( cmp_last_written(net) == 0 ){
     my_error(" FIFO full we have to wait,last_written = %d, next_needed =%d, last_read =%d\n", 
	      net->last_written, net->next_needed, net->last_read);
     pthread_cond_wait(&net->cond_fifo_full, &net->re_wri);
   }  

   /*signal, that it has been written to fifo,(perhaps a racing condition?)*/
   pthread_cond_signal(&net->cond_fifo_empty);
   actual_pointer = net->last_written;
   if( ++(net->last_written) == FIFO_LENGTH )
       net->last_written = 0;

   assert(actual_pointer >=0 && actual_pointer < FIFO_LENGTH);
   my_error(" actual pointer for FIFO  ,last_written = %d, next_needed =%d, last_read =%d\n", 
	    net->last_written, net->next_needed, net->last_read);
   my_error("actual_pointer for FIFO is : %d", actual_pointer);
   return (actual_pointer);
 }



/*returns the appropiate value from the called function*/
union par getreturn(net_engine *net, int fifo_pointer)
{
  my_error("user: in get return pointer =%d", fifo_pointer);
  pthread_mutex_lock(&net->re_wri);
  if(net->next_needed < net->last_read + FIFO_LENGTH - 1 ){
    my_error(" we are waiting for the result ");
    pthread_cond_wait(&net->cond_next_needed, &net->re_wri);
     my_error(" Got the result");
  }
  pthread_mutex_unlock(&net->re_wri);

  return  net->fifo[fifo_pointer].arg1;  
}

/*
 * Functions to get the appropiate return value. 
 */
mxArray *return_get_array(net_engine *net, int fifopointer)
{
  union par help;
  help = getreturn(net, fifopointer);
  return ( (mxArray *) help.arg_ptr );
}

int return_send_array(net_engine *net,int fifopointer)
{
  union par help;
  help = getreturn(net, fifopointer);
  return (  help.arg_int ); 
}

int return_clientevalstring(net_engine *net,int fifopointer)
{
  union par help;
  help = getreturn(net, fifopointer);
  return (  help.arg_int ); 
}

int return_outputbuffer(net_engine *net,int fifopointer)
{
  union par help;
  help = getreturn(net, fifopointer);
  return ( help.arg_int ); 
}

int return_close(net_engine *net,int fifopointer)
{
  union par help;
  help = getreturn(net, fifopointer);
  return (  help.arg_int ); 
}


/*tell the machine_thread, which returnvalue is the next yon need*/
void set_next_needed(net_engine *net, int next)
{
  pthread_mutex_lock(&net->re_wri);
  net->next_needed = next; 
  pthread_mutex_unlock(&net->re_wri); 
}

/* 
 *functions to be called by the user, puts the parameters 
 * on the FIFO, and sets the FIFO-indices to the appropiate value
 */

int user_eval_string(net_engine *net, char *string)
{
  int help;

  my_error("in user_eval string string = %s%",  string);
  /*ask for fifopointer*/

  pthread_mutex_lock(&net->re_wri);
  {
    help = fifopointer(net);
    net->fifo[help].f_ptr = (union par(*)(union par, union par, union par)) (&clientevalstring);
    net->fifo[help].arg2.arg_ptr  = (void *)    string; 
    net->fifo[help].arg1.arg_ptr  = (void *)    net->s;
  }
  pthread_mutex_unlock(&net->re_wri);
  
  my_error("finished filling fifo with comm eval string");
  
 
 
  return help;
}

/*
 *int signal_to_machine(void)
 *{
 *pthread_mutex_unlock(&my_wait);
 *sleep(1);
 *my_error("waiting for lock");
 *pthread_mutex_lock(&my_wait);
 *my_error("got lock back");
 *
 *return (0);
 *}
*/

int user_output_buffer(net_engine *net, char *string, int buf_length)
{
  int help;
  my_error("in user_output-buffer stringlength = %d", buf_length);

  pthread_mutex_lock(&net->re_wri);
  {
  /*ask for fifopointer*/
   help = fifopointer(net);
   net->fifo[help].f_ptr = (union par(*)(union par, union par, union par)) (&clientoutputbuffer);
   net->fifo[help].arg2.arg_ptr  = (void *)    string;
   net->fifo[help].arg3.arg_int  = (int   )    buf_length;
   net->fifo[help].arg1.arg_ptr  = (void *)    net->s;   
  }
  pthread_mutex_unlock(&net->re_wri);

  my_error("finished filling fifo with Com outputbuffer");  

 

  return help;
} 



int user_send_array(net_engine *net, mxArray *array)
{
  int help;

  pthread_mutex_lock(&net->re_wri);
  {
  /*ask for fifopointer*/
   help = fifopointer(net);
   net->fifo[help].f_ptr = (union par(*)(union par, union par, union par)) (&client_send_array);
   net->fifo[help].arg2.arg_ptr  = (void *)    array;
   net->fifo[help].arg1.arg_ptr  = (void *)    net->s;
   }
  pthread_mutex_unlock(&net->re_wri);
  my_error("finished filling fifo with Com mxsendarray");  

 

   return help;
  
}

int user_get_array(net_engine *net, char *mxarrayname)
{
  int help;
 
  pthread_mutex_lock(&net->re_wri);
  {
    /*ask for fifopointer*/
    help = fifopointer(net);
    net->fifo[help].f_ptr = (union par(*)(union par, union par, union par)) (&client_get_array);
    net->fifo[help].arg2.arg_ptr  = (void *)    mxarrayname;
    net->fifo[help].arg1.arg_ptr  = (void *)    net->s;
  }
  pthread_mutex_unlock(&net->re_wri);
  my_error("finished filling fifo with Com mygetarray");  

 
   return help;  
}

/*
 *Function Called at the end of the userfunction
 */
int user_close(net_engine *net)
{
  int help;
  
  help = fifopointer(net);  
  net->fifo[help].f_ptr = (union par(*)(union par, union par, union par)) (&clientclose);
  net->fifo[help].arg1.arg_ptr  = (void *)    net->s;
  
  set_next_needed(net, help);
  getreturn(net, help);
  my_error(" END of userclose");
 
  return help;
}

/*
 *Called after the intializing of user_thread
 */
int user_init(net_engine *net)
{
  /*locking the wait
   *ensures that the connection to server is established
   *before user_function starts
   */
  sleep(10);
  pthread_mutex_lock(&net->my_wait);
  /*sleep(5);*/
  return (0);
}

/*
 * main routine for the user_thread
 * does the initalising, and calls the user_function,
 * afterwards waits for the finishing of the Functions on the
 * FIFO, closes the connection to the server, and cancels the thread_user 
 */
/*void *client_user(int *ret)
{
  user_init();
  my_error("in task user\n");


  user_function();
  sleep(10);
  user_close();
  my_error("user : going back to main");
  pthread_cancel(thread_user);
  return NULL;
}
*/
void usage(void)
{
  fprintf(stderr,"Usage: clientt servername Port \n");
  exit(-1);
}

net_engine *net_engine_open(char *Hostname1, int Port)
{
  int help;

  int HostnameLength; 
  net_engine *net;

  /*we need the Hostname to be on the heap so we have to copy it*/
  HostnameLength = strlen(Hostname1);

  /*allocate the structure containing all data related to the fifo*/  
  net = (net_engine *) malloc(sizeof(net_engine));
  net->fifo = (callback *) calloc(FIFO_LENGTH, sizeof(callback)); 
  net->Hostname = (char *) calloc(HostnameLength + 1, sizeof(char));
  strcpy(net->Hostname, Hostname1);
  net->Port = Port;
  fprintf(stderr, "Hostname = %s, Port = %d\n", net->Hostname, net->Port);
  net->last_written = 0; net->last_read = 0; net-> next_needed = FIFO_LENGTH + 1;

  
    my_error("Hostname = %s, Port = %d", net->Hostname, net->Port);
    my_error("in function clientopen: creating mutices\n");
  
    
    help = pthread_mutex_init(&net->re_wri, NULL);
    my_error("init pthread_lock re_wri, return =%d",help);
    

    help = pthread_mutex_init(&net->my_wait, NULL);
    my_error("init  pthread_lock my_wait, return =%d",help);
    my_error("in function main: created\n");


    help = pthread_cond_init(&net->cond_next_needed, NULL);
    my_error("init  pthread_lock cond_next_needed, return =%d",help);
    my_error("in function main: created\n");

    help = pthread_cond_init(&net->cond_fifo_empty, NULL);
    my_error("init  pthread_lock cond_fifo-empty, return =%d",help);
    my_error("in function main: created\n");

    help = pthread_cond_init(&net->cond_fifo_full, NULL);
    my_error("init  pthread_lock cond_fifo_full, return =%d",help);
    my_error("in function main: created\n");
    
/*
    pthread_create(&thread_user, 
		   NULL,
		   (void *(*)(void *)) client_machine,
		   (void *) server1); 
    perror("init pthreat-create-user");
*/     
    pthread_create(&thread_machine, 
		   NULL,
		   (void *(*)(void *)) client_machine,
		   (void *) net); 
    perror(" pthread_create machine");	   


    my_error("Before user init");
    user_init(net);
    my_error("After useer init");
    /*
     * wait for the end of the thread user
     */    
    /*   pthread_join(thread_user,NULL);
    my_error("in main, killing thread machine");

    pthread_cancel(thread_machine);
    free(server1);
  */
    return net ;
}

int net_engine_close(net_engine *net)
{
     user_close(net);
     free(net->fifo);
     free(net);
     /*pthread_join(thread_machine,NULL);*/
     my_error("in main, killing thread machine");
     pthread_cancel(thread_machine);
     return 0;
}











