#include "user.h"

void main(int argc, char **argv)
{
  int Port,z,l,counter, save;
  net_engine *net;
  char *order;
  char *name;
  /*Don't forget to initalize matlab-array-pointers to zero.*/
  mxArray *T = NULL;
  mxArray *D = NULL;
  mxArray *J = NULL;
  double time[200];
  double time1[200];

  if(argc!=3){
    fprintf(stderr,"usage: %s Hostname Port", argv[0]);
    exit(0);
  }    

  Port = atoi(argv[2]);

  /*open our connection to the remote Matlabengine*/
  net = net_engine_open(argv[1], Port);
  
  order = calloc(20, sizeof(char));
  strcpy(order,"plot(T,D)");
  name = malloc(4 * sizeof(char));
  strcpy(name,"T");
  T = mxCreateDoubleMatrix(1, sizeof(time)/sizeof(double), mxREAL);
  D = mxCreateDoubleMatrix(1, sizeof(time)/sizeof(double), mxREAL);
  mxSetName(T, "T");
  mxSetName(D, "D");

  fprintf(stderr,"Calculation of vektor\n");
  for (z=0; z < sizeof(time)/sizeof(double); z++){
    time[z]= z * (2 * 3.14159 / 200) ;
    time1[z]= sin( time[z] );
  }
  for(counter=0; counter<200; counter++){

    fprintf(stderr, "counter =%d\n", counter);
    memcpy((void *)mxGetPr(T), (void *)time, sizeof(time));
    memcpy((void *)mxGetPr(D), (void *)time1, sizeof(time));  
    
    l=0;

    /*now we send an array*/
    save = user_send_array(net, T);
    /*
     *we tell the the machinethread that we 
     *are waiting for the finish of that order
     */
    set_next_needed(net, save);
    /*and now we wait*/
    return_send_array(net,save);
    user_send_array(net, D);

    /*You must supply a pointer to a string, don't write a string with " " there. 
     The  string must lay on the heap*/
    user_eval_string(net, order);

    /*Tells the machine thread to get us array D from matlab*/
    save = user_get_array(net,name);
    /* Tell thread we are waiting for it*/
    set_next_needed(net, save);   
    J = return_get_array(net, save);
    /* You must free J yourself! */
    free(J);
  }

  
  net_engine_close(net);
}
