(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1346836,      43707]*)
(*NotebookOutlinePosition[   1347561,      43732]*)
(*  CellTagsIndexPosition[   1347517,      43728]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Das Freie Teilchnen - Gau\[SZ]sches Wellenpaket"], "Section"],

Cell["\<\
Das Gau\[SZ]'sche Wellenpaket f\[UDoubleDot]r das freie Teilchen kann \
analytisch behandelt werden.
Im k-Raum ergibt sich folgende Funktion, die auf 1 normiert ist.\
\>", "Text"],

Cell[BoxData[
    \(\(g[k_] = 
      \(\((a\^2\/\(2\ \[Pi]\))\)\^\(1\/4\)\) 
        Exp[\(-\(a\^2\/4\)\) \((k - k0)\)\^2]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\_\(-\[Infinity]\)\%\(+\[Infinity]\)\(g[k]\^2\) 
        \[DifferentialD]k\)], "Input"],

Cell[BoxData[
    RowBox[{"If", "[", 
      RowBox[{\(Re[a\^2] > 0 && Re[a\^2\ k0] < 0\), ",", "1", ",", 
        RowBox[{
          SubsuperscriptBox["\[Integral]", 
            InterpretationBox[\(-\[Infinity]\),
              DirectedInfinity[ -1]], 
            InterpretationBox["\[Infinity]",
              DirectedInfinity[ 1]]], 
          \(\(\(\@a\^2\ 
                  E\^\(\(-\(1\/2\)\)\ a\^2\ \((k - k0)\)\^2\)\)\/\@\(2\ 
                    \[Pi]\)\) \[DifferentialD]k\)}]}], "]"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Mit der Dispersionsrelation ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega] = k\^2\/2\)]],
  "(in a.u.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\[Omega][k_] = k\^2\/2\), 
    \(\[CurlyPhi][k_, t_] = g[k] Exp[\(-\[ImaginaryI]\)\ \[Omega][k] t]\)}], 
  "Input"],

Cell[BoxData[
    \(k\^2\/2\)], "Output"],

Cell[BoxData[
    \(\(\((a\^2)\)\^\(1/4\)\ 
        E\^\(\(-\(1\/4\)\)\ a\^2\ \((k - k0)\)\^2 - 1\/2\ I\ k\^2\ t\)\)\/\((
          2\ \[Pi])\)\^\(1/4\)\)], "Output"]
}, Open  ]],

Cell["\<\
ergibt sich f\[UDoubleDot]r das Wellenpaket im Ortsraum folgendes Integral, \
das analytisch ausgewertet werden kann :\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi][x_, t_] = 
      \[Integral]\_\(-\[Infinity]\)\%\(+\[Infinity]\)\(1\/\@\(2\ \[Pi]\)\) 
          \[CurlyPhi][k, t] Exp[\[ImaginaryI]\ k\ x] \[DifferentialD]k\)], 
  "Input"],

Cell[BoxData[
    RowBox[{"If", "[", 
      RowBox[{
      \(Im[x] - 1\/2\ Re[a\^2\ k0] > 0 && Im[t]\/2 - Re[a\^2]\/4 < 0\), ",", 
        \(\((a\^2)\)\^\(1/4\)\ 
          E\^\(-\(\(I\ a\^2\ k0\ \((k0\ t - 2\ x)\) + 2\ x\^2\)\/\(2\ 
                    \((a\^2 + 2\ I\ t)\)\)\)\)\ \((2\/\[Pi])\)\^\(1/4\)\ 
          \@\(1\/\(a\^2 + 2\ I\ t\)\)\), ",", 
        RowBox[{
          SubsuperscriptBox["\[Integral]", 
            InterpretationBox[\(-\[Infinity]\),
              DirectedInfinity[ -1]], 
            InterpretationBox["\[Infinity]",
              DirectedInfinity[ 1]]], 
          \(\(\(\((a\^2)\)\^\(1/4\)\ 
                  E\^\(\(-\(1\/4\)\)\ a\^2\ \((k - k0)\)\^2 - 
                      1\/2\ I\ k\^2\ t + I\ k\ x\)\)\/\((2\ \[Pi])\)\^\(3/4
                    \)\) \[DifferentialD]k\)}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Psi][x_, t_] = \(\[Psi][x, t]\)\ [\([2]\)]\)], "Input"],

Cell[BoxData[
    \(\((a\^2)\)\^\(1/4\)\ 
      E\^\(-\(\(I\ a\^2\ k0\ \((k0\ t - 2\ x)\) + 2\ x\^2\)\/\(2\ 
                \((a\^2 + 2\ I\ t)\)\)\)\)\ \((2\/\[Pi])\)\^\(1/4\)\ 
      \@\(1\/\(a\^2 + 2\ I\ t\)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Daraus erh\[ADoubleDot]lt man die Aufenthaltwahrscheinlichkeitsdichte ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Psi]\[Psi]\^*\)\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(psi[x_, t_] = 
      \(ComplexExpand[Re[\[Psi][x, t]]]\^2 + 
            ComplexExpand[Im[\[Psi][x, t]]]\^2\  // Expand\)\  // TrigReduce
        \)], "Input"],

Cell[BoxData[
    \(\(\@a\^2\ 
        E\^\(\(-\(\(2\ a\^2\ k0\ t\ \((k0\ t - 2\ x)
                    \)\)\/Abs[a\^2 + 2\ I\ t]\^2\)\) - 
            \(2\ a\^2\ x\^2\)\/Abs[a\^2 + 2\ I\ t]\^2\)\ 
        \@\(2\/\[Pi]\)\)\/Abs[a\^2 + 2\ I\ t]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(repl = Abs[a\^2 + 2\ I\ t]; \np = Position[psi[x, t], repl]; \n
    psi[x_, t_] = ReplacePart[psi[x, t], \((a\^4 + 4\ t\^2)\), p]\)], "Input"],

Cell[BoxData[
    \(\(\@a\^2\ 
        E\^\(\(-\(\(2\ a\^2\ k0\ t\ \((k0\ t - 2\ x)
                    \)\)\/\((a\^4 + 4\ t\^2)\)\^2\)\) - 
            \(2\ a\^2\ x\^2\)\/\((a\^4 + 4\ t\^2)\)\^2\)\ 
        \@\(2\/\[Pi]\)\)\/\(a\^4 + 4\ t\^2\)\)], "Output"]
}, Open  ]],

Cell["die, wie man sich \[UDoubleDot]berzeugen kann, auf eins normiert ist.", 
  "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((\[Integral]\_\(-\[Infinity]\)\%\(+\[Infinity]\)psi[x, t] 
              \[DifferentialD]x\ )\)[\([2]\)]\  // PowerExpand\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Open  ]],

Cell["\<\
Aus der graphischen Darstellung des zeitlichen Verlaufs erkennt man sehr sch\
\[ODoubleDot]n das Zerflie\[SZ]en des Wellenpakets\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(const = {a -> 1.3, k0 -> 5}; \n
    Plot[Evaluate[Table[psi[x, t] /. const, {t, 0, 2, 0.2}]], {x, \(-3\), 
        20}, PlotRange -> {0, 0.5}]; \)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.148033 0.0414079 0 1.23607 [
[.35507 -0.0125 -3 -9 ]
[.35507 -0.0125 3 0 ]
[.56211 -0.0125 -6 -9 ]
[.56211 -0.0125 6 0 ]
[.76915 -0.0125 -6 -9 ]
[.76915 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.13553 .12361 -18 -4.5 ]
[.13553 .12361 0 4.5 ]
[.13553 .24721 -18 -4.5 ]
[.13553 .24721 0 4.5 ]
[.13553 .37082 -18 -4.5 ]
[.13553 .37082 0 4.5 ]
[.13553 .49443 -18 -4.5 ]
[.13553 .49443 0 4.5 ]
[.13553 .61803 -18 -4.5 ]
[.13553 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.35507 0 m
.35507 .00625 L
s
[(5)] .35507 -0.0125 0 1 Mshowa
.56211 0 m
.56211 .00625 L
s
[(10)] .56211 -0.0125 0 1 Mshowa
.76915 0 m
.76915 .00625 L
s
[(15)] .76915 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(20)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.18944 0 m
.18944 .00375 L
s
.23085 0 m
.23085 .00375 L
s
.27226 0 m
.27226 .00375 L
s
.31366 0 m
.31366 .00375 L
s
.39648 0 m
.39648 .00375 L
s
.43789 0 m
.43789 .00375 L
s
.4793 0 m
.4793 .00375 L
s
.5207 0 m
.5207 .00375 L
s
.60352 0 m
.60352 .00375 L
s
.64493 0 m
.64493 .00375 L
s
.68634 0 m
.68634 .00375 L
s
.72774 0 m
.72774 .00375 L
s
.81056 0 m
.81056 .00375 L
s
.85197 0 m
.85197 .00375 L
s
.89337 0 m
.89337 .00375 L
s
.93478 0 m
.93478 .00375 L
s
.10663 0 m
.10663 .00375 L
s
.06522 0 m
.06522 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.14803 .12361 m
.15428 .12361 L
s
[(0.1)] .13553 .12361 1 0 Mshowa
.14803 .24721 m
.15428 .24721 L
s
[(0.2)] .13553 .24721 1 0 Mshowa
.14803 .37082 m
.15428 .37082 L
s
[(0.3)] .13553 .37082 1 0 Mshowa
.14803 .49443 m
.15428 .49443 L
s
[(0.4)] .13553 .49443 1 0 Mshowa
.14803 .61803 m
.15428 .61803 L
s
[(0.5)] .13553 .61803 1 0 Mshowa
.125 Mabswid
.14803 .02472 m
.15178 .02472 L
s
.14803 .04944 m
.15178 .04944 L
s
.14803 .07416 m
.15178 .07416 L
s
.14803 .09889 m
.15178 .09889 L
s
.14803 .14833 m
.15178 .14833 L
s
.14803 .17305 m
.15178 .17305 L
s
.14803 .19777 m
.15178 .19777 L
s
.14803 .22249 m
.15178 .22249 L
s
.14803 .27193 m
.15178 .27193 L
s
.14803 .29666 m
.15178 .29666 L
s
.14803 .32138 m
.15178 .32138 L
s
.14803 .3461 m
.15178 .3461 L
s
.14803 .39554 m
.15178 .39554 L
s
.14803 .42026 m
.15178 .42026 L
s
.14803 .44498 m
.15178 .44498 L
s
.14803 .46971 m
.15178 .46971 L
s
.14803 .51915 m
.15178 .51915 L
s
.14803 .54387 m
.15178 .54387 L
s
.14803 .56859 m
.15178 .56859 L
s
.14803 .59331 m
.15178 .59331 L
s
.25 Mabswid
.14803 0 m
.14803 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01078 m
.02846 .01417 L
.03279 .01812 L
.03793 .02399 L
.04262 .03061 L
.0522 .04878 L
.05746 .06184 L
.06244 .07644 L
.08265 .15976 L
.10458 .28444 L
.11395 .33902 L
.12403 .39054 L
.1298 .41426 L
.13509 .43108 L
.13763 .4373 L
.1404 .44262 L
.14166 .44452 L
.14302 .44618 L
.14429 .44739 L
.14545 .44818 L
.14662 .44869 L
.14791 .4489 L
.14856 .44887 L
.14926 .44874 L
.15052 .44823 L
.15177 .44739 L
.15296 .44628 L
.15518 .4434 L
.1578 .43867 L
.16022 .43307 L
.16571 .41626 L
.17496 .37673 L
.1848 .32382 L
.20449 .20779 L
.22255 .11733 L
.23197 .08179 L
.24189 .0534 L
.25186 .03318 L
.2575 .0248 L
.26275 .01866 L
.2678 .01402 L
.27327 .01014 L
.27844 .00737 L
.28321 .00543 L
.28751 .00408 L
.29224 .00295 L
.29718 .00208 L
.3018 .00148 L
.30678 .00102 L
.30959 .00082 L
Mistroke
.3122 .00067 L
.31699 .00045 L
.31966 .00036 L
.32208 .0003 L
.32667 .0002 L
.32926 .00016 L
.33163 .00013 L
.33601 9e-005 L
.33821 7e-005 L
.34062 6e-005 L
.34314 5e-005 L
.34588 4e-005 L
.34829 3e-005 L
.35085 2e-005 L
.35316 2e-005 L
.35569 1e-005 L
.35788 1e-005 L
.36017 1e-005 L
.36288 1e-005 L
.36537 0 L
.36805 0 L
.37097 0 L
.37351 0 L
.37622 0 L
.37878 0 L
.3811 0 L
.38341 0 L
.38596 0 L
.38862 0 L
.3911 0 L
.39343 0 L
.39555 0 L
.398 0 L
.40032 0 L
.40283 0 L
.40549 0 L
.40777 0 L
.41028 0 L
.41297 0 L
.41439 0 L
.41588 0 L
.41862 0 L
.42113 0 L
.4237 0 L
.42612 0 L
.4283 0 L
.43066 0 L
.43323 0 L
.43453 0 L
.43596 0 L
Mistroke
.43848 0 L
.44085 0 L
.44322 0 L
.44547 0 L
.44749 0 L
.44969 0 L
.45208 0 L
.45342 0 L
.45463 0 L
.45699 0 L
.45921 0 L
.46162 0 L
.46387 0 L
.46516 0 L
.46634 0 L
.46771 0 L
.46898 0 L
.47152 0 L
.47286 0 L
.47428 0 L
.47667 0 L
.47803 0 L
.4793 0 L
.48156 0 L
.4827 0 L
.48394 0 L
.48615 0 L
.48819 0 L
.48944 0 L
.49062 0 L
.49283 0 L
.49407 0 L
.4952 0 L
.49652 0 L
.49778 0 L
.49895 0 L
.50022 0 L
.50246 0 L
.50372 0 L
.50506 0 L
.50748 0 L
.50866 0 L
.50994 0 L
.51106 0 L
.51224 0 L
.51332 0 L
.51449 0 L
.51656 0 L
.51794 0 L
.51926 0 L
Mistroke
.52172 0 L
.52309 0 L
.52437 0 L
.52576 0 L
.52724 0 L
.52842 0 L
.52969 0 L
.53198 0 L
.53338 0 L
.53471 0 L
.53601 0 L
.5372 0 L
.53844 0 L
.53979 0 L
.54095 0 L
.54222 0 L
.54444 0 L
.54565 0 L
.54678 0 L
.5481 0 L
.54936 0 L
.5505 0 L
.55171 0 L
.55303 0 L
.55424 0 L
.55555 0 L
.557 0 L
.55816 0 L
.55938 0 L
.56156 0 L
.56278 0 L
.56391 0 L
.56515 0 L
.56648 0 L
.56763 0 L
.56888 0 L
.56998 0 L
.57114 0 L
.57219 0 L
.57335 0 L
.57538 0 L
.57667 0 L
.57787 0 L
.57919 0 L
.58059 0 L
.58193 0 L
.58319 0 L
.58432 0 L
.58554 0 L
.58666 0 L
Mistroke
.58789 0 L
.58918 0 L
.59037 0 L
.59148 0 L
.59252 0 L
.59372 0 L
.59482 0 L
.59602 0 L
.59734 0 L
.59873 0 L
.60002 0 L
.60123 0 L
.60234 0 L
.60355 0 L
.60483 0 L
.60613 0 L
.60752 0 L
.60884 0 L
.61003 0 L
.61143 0 L
.61295 0 L
.61439 0 L
.61571 0 L
.61697 0 L
.61816 0 L
.61923 0 L
.62039 0 L
.62166 0 L
.623 0 L
.62415 0 L
.62542 0 L
.6266 0 L
.62767 0 L
.62886 0 L
.6301 0 L
.63119 0 L
.6322 0 L
.63331 0 L
.6345 0 L
.63589 0 L
.63717 0 L
.63857 0 L
.64006 0 L
.64135 0 L
.64256 0 L
.64389 0 L
.64531 0 L
.64657 0 L
.64795 0 L
.64925 0 L
Mistroke
.65045 0 L
.65165 0 L
.65273 0 L
.65398 0 L
.65515 0 L
.65631 0 L
.65756 0 L
.65874 0 L
.65981 0 L
.66107 0 L
.66243 0 L
.66372 0 L
.66492 0 L
.66615 0 L
.6673 0 L
.66856 0 L
.66992 0 L
.67127 0 L
.67269 0 L
.67391 0 L
.67524 0 L
.67648 0 L
.67766 0 L
.67872 0 L
.67986 0 L
.68111 0 L
.68244 0 L
.68356 0 L
.68481 0 L
.68597 0 L
.68702 0 L
.68825 0 L
.68941 0 L
.69048 0 L
.69147 0 L
.69255 0 L
.69371 0 L
.69496 0 L
.69633 0 L
.69702 0 L
.69776 0 L
.69839 0 L
.69909 0 L
.70042 0 L
.70167 0 L
.7029 0 L
.70403 0 L
.70535 0 L
.7066 0 L
.70796 0 L
Mistroke
.70873 0 L
.70943 0 L
.71084 0 L
.71163 0 L
.71237 0 L
.71372 0 L
.71448 0 L
.71517 0 L
.71643 0 L
.71707 0 L
.71777 0 L
.719 0 L
.72016 0 L
.72086 0 L
.72152 0 L
.72276 0 L
.72346 0 L
.7241 0 L
.7248 0 L
.72556 0 L
.72672 0 L
.72781 0 L
.72911 0 L
.73031 0 L
.73148 0 L
.73276 0 L
.73341 0 L
.7341 0 L
.73535 0 L
.73658 0 L
.73728 0 L
.73794 0 L
.73926 0 L
.74 0 L
.74067 0 L
.74188 0 L
.74319 0 L
.74443 0 L
.74558 0 L
.74628 0 L
.74703 0 L
.7477 0 L
.7484 0 L
.74904 0 L
.74973 0 L
.75096 0 L
.7517 0 L
.75238 0 L
.75312 0 L
.75392 0 L
Mistroke
.75465 0 L
.75534 0 L
.75604 0 L
.75668 0 L
.75783 0 L
.75908 0 L
.76017 0 L
.76133 0 L
.76259 0 L
.76377 0 L
.76507 0 L
.76579 0 L
.76645 0 L
.7671 0 L
.76778 0 L
.76901 0 L
.77034 0 L
.77109 0 L
.77179 0 L
.77306 0 L
.77422 0 L
.77486 0 L
.77556 0 L
.77683 0 L
.77748 0 L
.77816 0 L
.77939 0 L
.78072 0 L
.78147 0 L
.78216 0 L
.78343 0 L
.78459 0 L
.78523 0 L
.78592 0 L
.78718 0 L
.78831 0 L
.78955 0 L
.79084 0 L
.79206 0 L
.79319 0 L
.79423 0 L
.79542 0 L
.79656 0 L
.79788 0 L
.79908 0 L
.79974 0 L
.80046 0 L
.80176 0 L
.80299 0 L
.80428 0 L
Mistroke
.80538 0 L
.80659 0 L
.80733 0 L
.80802 0 L
.80933 0 L
.81006 0 L
.81073 0 L
.81152 0 L
.81226 0 L
.81348 0 L
.81413 0 L
.81482 0 L
.81552 0 L
.81625 0 L
.81755 0 L
.81878 0 L
.81948 0 L
.82012 0 L
.8213 0 L
.82255 0 L
.82367 0 L
.82471 0 L
.82586 0 L
.82709 0 L
.8284 0 L
.82914 0 L
.82983 0 L
.83108 0 L
.83178 0 L
.83242 0 L
.83363 0 L
.83493 0 L
.83616 0 L
.83729 0 L
.83835 0 L
.83949 0 L
.84057 0 L
.84155 0 L
.8427 0 L
.84395 0 L
.84513 0 L
.84622 0 L
.84735 0 L
.8484 0 L
.84956 0 L
.8508 0 L
.85203 0 L
.85333 0 L
.85444 0 L
.85565 0 L
Mistroke
.8563 0 L
.85698 0 L
.8582 0 L
.85951 0 L
.86026 0 L
.86095 0 L
.86222 0 L
.86337 0 L
.864 0 L
.86469 0 L
.86595 0 L
.86707 0 L
.8683 0 L
.86959 0 L
.87081 0 L
.87193 0 L
.87297 0 L
.8741 0 L
.8753 0 L
.87661 0 L
.8778 0 L
.87846 0 L
.87918 0 L
.88048 0 L
.8817 0 L
.88299 0 L
.88409 0 L
.88531 0 L
.88604 0 L
.88673 0 L
.88803 0 L
.88876 0 L
.88943 0 L
.89018 0 L
.89096 0 L
.89165 0 L
.8924 0 L
.8931 0 L
.89374 0 L
.89497 0 L
.89626 0 L
.89748 0 L
.89817 0 L
.89881 0 L
.89998 0 L
.90122 0 L
.90233 0 L
.90338 0 L
.90452 0 L
.90575 0 L
Mistroke
.90698 0 L
.90768 0 L
.90833 0 L
.90965 0 L
.91038 0 L
.91105 0 L
.91225 0 L
.91355 0 L
.91478 0 L
.91591 0 L
.91697 0 L
.9181 0 L
.91918 0 L
.92016 0 L
.9213 0 L
.92255 0 L
.92373 0 L
.92482 0 L
.92606 0 L
.92722 0 L
.92826 0 L
.92939 0 L
.93062 0 L
.93192 0 L
.93303 0 L
.93425 0 L
.93556 0 L
.93677 0 L
.9374 0 L
.9381 0 L
.93883 0 L
.93951 0 L
.94076 0 L
.94191 0 L
.94323 0 L
.94449 0 L
.94561 0 L
.9468 0 L
.94792 0 L
.94894 0 L
.95015 0 L
.95145 0 L
.95268 0 L
.95381 0 L
.95502 0 L
.95632 0 L
.95754 0 L
.95866 0 L
.95997 0 L
.96071 0 L
Mistroke
.96139 0 L
.96265 0 L
.96328 0 L
.96399 0 L
.96466 0 L
.96538 0 L
.96665 0 L
.96737 0 L
.96803 0 L
.96876 0 L
.96953 0 L
.97021 0 L
.97094 0 L
.97162 0 L
.97226 0 L
.97347 0 L
.97474 0 L
.97549 0 L
.97619 0 L
Mfstroke
.02381 .00111 m
.02846 .00155 L
.03279 .00208 L
.03754 .00286 L
.04262 .00398 L
.04795 .00555 L
.053 .00752 L
.05753 .00979 L
.06244 .0129 L
.06751 .01695 L
.07308 .0226 L
.07851 .02954 L
.08435 .03883 L
.0948 .06102 L
.10458 .08928 L
.11468 .12663 L
.12571 .17631 L
.1458 .28137 L
.15593 .33329 L
.16548 .37535 L
.17076 .39413 L
.17354 .40243 L
.17648 .40989 L
.17895 .41508 L
.18167 .41956 L
.18286 .42112 L
.18414 .42251 L
.18535 .42355 L
.18645 .42427 L
.18763 .42479 L
.18873 .42504 L
.18995 .42507 L
.19126 .42479 L
.19255 .4242 L
.19321 .42379 L
.19392 .42324 L
.19636 .4207 L
.19866 .41733 L
.20111 .41272 L
.20553 .40189 L
.21113 .38389 L
.21641 .3631 L
.22629 .31671 L
.24461 .21979 L
.25502 .16739 L
.26476 .12433 L
.27515 .08653 L
.28464 .05965 L
.29478 .03838 L
.30037 .02954 L
Mistroke
.30568 .02275 L
.31529 .01374 L
.32066 .01019 L
.32553 .00768 L
.33008 .00585 L
.33501 .00431 L
.33965 .0032 L
.34393 .00241 L
.34864 .00175 L
.35369 .00123 L
.35845 .00087 L
.36279 .00063 L
.36788 .00043 L
.37076 .00034 L
.37341 .00028 L
.37829 .00019 L
.38075 .00015 L
.38346 .00012 L
.3884 8e-005 L
.39088 6e-005 L
.39358 5e-005 L
.39591 4e-005 L
.39839 3e-005 L
.40285 2e-005 L
.40555 2e-005 L
.40848 1e-005 L
.41125 1e-005 L
.41379 1e-005 L
.41862 0 L
.42105 0 L
.42372 0 L
.42622 0 L
.42895 0 L
.43152 0 L
.43391 0 L
.43623 0 L
.43841 0 L
.44069 0 L
.44321 0 L
.44576 0 L
.44845 0 L
.45075 0 L
.45326 0 L
.45598 0 L
.45888 0 L
.46162 0 L
.46411 0 L
.46642 0 L
.46895 0 L
.4716 0 L
Mistroke
.47408 0 L
.47639 0 L
.47851 0 L
.48095 0 L
.48327 0 L
.48577 0 L
.48843 0 L
.49094 0 L
.49322 0 L
.4959 0 L
.49741 0 L
.4988 0 L
.50136 0 L
.50406 0 L
.50661 0 L
.50903 0 L
.51119 0 L
.51355 0 L
.51611 0 L
.5174 0 L
.51883 0 L
.52135 0 L
.52371 0 L
.52596 0 L
.52832 0 L
.53034 0 L
.53254 0 L
.53493 0 L
.53626 0 L
.53747 0 L
.53983 0 L
.54205 0 L
.54445 0 L
.54669 0 L
.54797 0 L
.54915 0 L
.55052 0 L
.55178 0 L
.55431 0 L
.55565 0 L
.55707 0 L
.55842 0 L
.5597 0 L
.56084 0 L
.56208 0 L
.56433 0 L
.56556 0 L
.56671 0 L
.56876 0 L
.57096 0 L
Mistroke
.57219 0 L
.57354 0 L
.57472 0 L
.57597 0 L
.5771 0 L
.57835 0 L
.58054 0 L
.58183 0 L
.58302 0 L
.58444 0 L
.58573 0 L
.58812 0 L
.58943 0 L
.59067 0 L
.5918 0 L
.59299 0 L
.59512 0 L
.59631 0 L
.59742 0 L
.59994 0 L
.60124 0 L
.60264 0 L
.60389 0 L
.60521 0 L
.60639 0 L
.6077 0 L
.61001 0 L
.61141 0 L
.61269 0 L
.6141 0 L
.61558 0 L
.61688 0 L
.61808 0 L
.6194 0 L
.62082 0 L
.62205 0 L
.6234 0 L
.62482 0 L
.62614 0 L
.62735 0 L
.62851 0 L
.62984 0 L
.63105 0 L
.63239 0 L
.63381 0 L
.63515 0 L
.63636 0 L
.63779 0 L
.63934 0 L
.64081 0 L
Mistroke
.64215 0 L
.64332 0 L
.64457 0 L
.64565 0 L
.64683 0 L
.64821 0 L
.64951 0 L
.65078 0 L
.65195 0 L
.6531 0 L
.65434 0 L
.6557 0 L
.65697 0 L
.65833 0 L
.65975 0 L
.66097 0 L
.6623 0 L
.66362 0 L
.66484 0 L
.66618 0 L
.6676 0 L
.66883 0 L
.66998 0 L
.67124 0 L
.6726 0 L
.6738 0 L
.6751 0 L
.67634 0 L
.67748 0 L
.67964 0 L
.68073 0 L
.68194 0 L
.68326 0 L
.68465 0 L
.68584 0 L
.68714 0 L
.68854 0 L
.69004 0 L
.69146 0 L
.69275 0 L
.69405 0 L
.69525 0 L
.69657 0 L
.69797 0 L
.69918 0 L
.70032 0 L
.70156 0 L
.7029 0 L
.70423 0 L
.70544 0 L
Mistroke
.70683 0 L
.70814 0 L
.70936 0 L
.71048 0 L
.71171 0 L
.71301 0 L
.71432 0 L
.71573 0 L
.71706 0 L
.71827 0 L
.71969 0 L
.72123 0 L
.72269 0 L
.72404 0 L
.72519 0 L
.72643 0 L
.7276 0 L
.72867 0 L
.72986 0 L
.73116 0 L
.73252 0 L
.73378 0 L
.73513 0 L
.73641 0 L
.73755 0 L
.73879 0 L
.74014 0 L
.74157 0 L
.74279 0 L
.74413 0 L
.74543 0 L
.74663 0 L
.74795 0 L
.74935 0 L
.75069 0 L
.75195 0 L
.75308 0 L
.7543 0 L
.75542 0 L
.75665 0 L
.75794 0 L
.75914 0 L
.76026 0 L
.76129 0 L
.76247 0 L
.76359 0 L
.76479 0 L
.76611 0 L
.7675 0 L
.76879 0 L
Mistroke
.77 0 L
.77111 0 L
.77239 0 L
.7736 0 L
.77491 0 L
.7763 0 L
.77761 0 L
.7788 0 L
.78021 0 L
.781 0 L
.78173 0 L
.78306 0 L
.78374 0 L
.78448 0 L
.78578 0 L
.78699 0 L
.78831 0 L
.78898 0 L
.78971 0 L
.79094 0 L
.79227 0 L
.79352 0 L
.79467 0 L
.79579 0 L
.79684 0 L
.79798 0 L
.7992 0 L
.80049 0 L
.8017 0 L
.80279 0 L
.80397 0 L
.80527 0 L
.80649 0 L
.80782 0 L
.80857 0 L
.80925 0 L
.81063 0 L
.8114 0 L
.81212 0 L
.81344 0 L
.81418 0 L
.81485 0 L
.81614 0 L
.81733 0 L
.81864 0 L
.81929 0 L
.82002 0 L
.82123 0 L
.82253 0 L
.82376 0 L
Mistroke
.82488 0 L
.82606 0 L
.82717 0 L
.82839 0 L
.8297 0 L
.831 0 L
.83165 0 L
.83236 0 L
.83363 0 L
.83481 0 L
.836 0 L
.83713 0 L
.83815 0 L
.83925 0 L
.84044 0 L
.84171 0 L
.8428 0 L
.84399 0 L
.84465 0 L
.84537 0 L
.84669 0 L
.84797 0 L
.84916 0 L
.84989 0 L
.85058 0 L
.85185 0 L
.85257 0 L
.85323 0 L
.85395 0 L
.85472 0 L
.85593 0 L
.85705 0 L
.85774 0 L
.85839 0 L
.8596 0 L
.86089 0 L
.86207 0 L
.86337 0 L
.86403 0 L
.86475 0 L
.86604 0 L
.86724 0 L
.86855 0 L
.86928 0 L
.86995 0 L
.87117 0 L
.87249 0 L
.87374 0 L
.87489 0 L
.876 0 L
Mistroke
.87704 0 L
.87817 0 L
.8794 0 L
.88067 0 L
.88189 0 L
.88297 0 L
.88416 0 L
.88545 0 L
.88666 0 L
.88735 0 L
.88799 0 L
.88873 0 L
.88942 0 L
.89072 0 L
.8914 0 L
.89214 0 L
.89291 0 L
.89364 0 L
.89429 0 L
.895 0 L
.89622 0 L
.89751 0 L
.8987 0 L
.89982 0 L
.90113 0 L
.90233 0 L
.903 0 L
.90372 0 L
.90504 0 L
.90569 0 L
.90637 0 L
.9076 0 L
.90892 0 L
.90967 0 L
.91036 0 L
.91163 0 L
.91279 0 L
.91342 0 L
.91412 0 L
.91538 0 L
.9165 0 L
.91774 0 L
.91903 0 L
.92025 0 L
.92138 0 L
.92241 0 L
.92355 0 L
.92474 0 L
.92606 0 L
.92726 0 L
Mistroke
.92792 0 L
.92864 0 L
.92994 0 L
.93116 0 L
.93246 0 L
.93356 0 L
.93477 0 L
.93551 0 L
.9362 0 L
.9375 0 L
.93823 0 L
.93891 0 L
.9397 0 L
.94044 0 L
.94166 0 L
.9423 0 L
.943 0 L
.94369 0 L
.94442 0 L
.94573 0 L
.94671 0 L
.94778 0 L
.94879 0 L
.94972 0 L
.95056 0 L
.95148 0 L
.95245 0 L
.95335 0 L
.9544 0 L
.9554 0 L
.9563 0 L
.95728 0 L
.95834 0 L
.95947 0 L
.96054 0 L
.9615 0 L
.96242 0 L
.9634 0 L
.96423 0 L
.96514 0 L
.96612 0 L
.96717 0 L
.96816 0 L
.96907 0 L
.96998 0 L
.97082 0 L
.97174 0 L
.97273 0 L
.97358 0 L
.97437 0 L
Mistroke
.97525 0 L
.97619 0 L
Mfstroke
.02381 .00036 m
.02846 .0005 L
.03279 .00066 L
.03754 .00088 L
.04262 .00121 L
.04795 .00166 L
.053 .00223 L
.05753 .00289 L
.06244 .00378 L
.06751 .00496 L
.07308 .00662 L
.0789 .00885 L
.08435 .01151 L
.0941 .01797 L
.09957 .02276 L
.10458 .02803 L
.11442 .0412 L
.12357 .0573 L
.1336 .07977 L
.14429 .10953 L
.16426 .17939 L
.18587 .26463 L
.19602 .30155 L
.20674 .33391 L
.21116 .34449 L
.21589 .35373 L
.21861 .35797 L
.22109 .36113 L
.22358 .36361 L
.22594 .3653 L
.22708 .36589 L
.2283 .36634 L
.22946 .36661 L
.23053 .36672 L
.2317 .36668 L
.23299 .36645 L
.23364 .36626 L
.23434 .36601 L
.23559 .3654 L
.23692 .36455 L
.23835 .36341 L
.24096 .36072 L
.24585 .35366 L
.2505 .34458 L
.25543 .33267 L
.26427 .30628 L
.30215 .16151 L
.31297 .1236 L
.32323 .09258 L
.33323 .06764 L
Mistroke
.34249 .04912 L
.35149 .03507 L
.36107 .0238 L
.36654 .01882 L
.3717 .01496 L
.38132 .00952 L
.38599 .00756 L
.39111 .00583 L
.3961 .00448 L
.40144 .00336 L
.40644 .00254 L
.411 .00195 L
.41524 .00152 L
.41992 .00115 L
.42474 .00085 L
.42986 .00062 L
.4346 .00045 L
.43904 .00034 L
.44427 .00024 L
.44905 .00017 L
.4543 .00012 L
.45694 .0001 L
.45982 8e-005 L
.46236 6e-005 L
.46512 5e-005 L
.46755 4e-005 L
.47012 4e-005 L
.47499 2e-005 L
.47947 2e-005 L
.48196 1e-005 L
.48463 1e-005 L
.48946 1e-005 L
.4924 1e-005 L
.4952 0 L
.49789 0 L
.50043 0 L
.50501 0 L
.50744 0 L
.51007 0 L
.51267 0 L
.51541 0 L
.51778 0 L
.52032 0 L
.5227 0 L
.52487 0 L
.52911 0 L
.53148 0 L
.53405 0 L
.53873 0 L
.54108 0 L
Mistroke
.54361 0 L
.54579 0 L
.54818 0 L
.55096 0 L
.55361 0 L
.55619 0 L
.55858 0 L
.56133 0 L
.56392 0 L
.56625 0 L
.56876 0 L
.57151 0 L
.57442 0 L
.5769 0 L
.57962 0 L
.58213 0 L
.58486 0 L
.58744 0 L
.58983 0 L
.59198 0 L
.59435 0 L
.59682 0 L
.59914 0 L
.6017 0 L
.60439 0 L
.60669 0 L
.60921 0 L
.61193 0 L
.61483 0 L
.61757 0 L
.62006 0 L
.62237 0 L
.62491 0 L
.62757 0 L
.63005 0 L
.63237 0 L
.63449 0 L
.63694 0 L
.63926 0 L
.64176 0 L
.64443 0 L
.64694 0 L
.64921 0 L
.6519 0 L
.65342 0 L
.6548 0 L
.65736 0 L
.65865 0 L
.66006 0 L
.66259 0 L
Mistroke
.66401 0 L
.66533 0 L
.66774 0 L
.6703 0 L
.67259 0 L
.67474 0 L
.67709 0 L
.67962 0 L
.68101 0 L
.6823 0 L
.68384 0 L
.68523 0 L
.68781 0 L
.68922 0 L
.69055 0 L
.69177 0 L
.69306 0 L
.69536 0 L
.69664 0 L
.69784 0 L
.69916 0 L
.70056 0 L
.70179 0 L
.70316 0 L
.70556 0 L
.70691 0 L
.70837 0 L
.70963 0 L
.711 0 L
.71352 0 L
.71489 0 L
.71617 0 L
.71845 0 L
.71974 0 L
.7209 0 L
.72206 0 L
.72328 0 L
.72548 0 L
.7267 0 L
.72784 0 L
.72918 0 L
.73044 0 L
.73271 0 L
.73479 0 L
.73702 0 L
.73828 0 L
.73945 0 L
.74074 0 L
.74211 0 L
.74454 0 L
Mistroke
.7459 0 L
.74717 0 L
.74864 0 L
.75004 0 L
.75125 0 L
.75256 0 L
.75485 0 L
.75615 0 L
.75753 0 L
.75882 0 L
.76001 0 L
.76221 0 L
.76336 0 L
.76458 0 L
.76662 0 L
.76778 0 L
.76886 0 L
.77013 0 L
.77134 0 L
.77358 0 L
.77484 0 L
.776 0 L
.77735 0 L
.77862 0 L
.7798 0 L
.78107 0 L
.78331 0 L
.78457 0 L
.78592 0 L
.78708 0 L
.78834 0 L
.7895 0 L
.79056 0 L
.79265 0 L
.79376 0 L
.79497 0 L
.79614 0 L
.79742 0 L
.79881 0 L
.80012 0 L
.80129 0 L
.80258 0 L
.80398 0 L
.80546 0 L
.80683 0 L
.80811 0 L
.80939 0 L
.81061 0 L
.81291 0 L
.81419 0 L
Mistroke
.81537 0 L
.81668 0 L
.81807 0 L
.81931 0 L
.82067 0 L
.8221 0 L
.82343 0 L
.82465 0 L
.82581 0 L
.82714 0 L
.82836 0 L
.8297 0 L
.83112 0 L
.83234 0 L
.83369 0 L
.83513 0 L
.83668 0 L
.83814 0 L
.83948 0 L
.84066 0 L
.84192 0 L
.843 0 L
.84418 0 L
.84556 0 L
.84687 0 L
.84814 0 L
.84931 0 L
.85047 0 L
.8517 0 L
.85306 0 L
.85434 0 L
.85576 0 L
.85712 0 L
.85833 0 L
.85966 0 L
.86099 0 L
.86222 0 L
.86357 0 L
.86499 0 L
.86623 0 L
.86738 0 L
.86865 0 L
.87 0 L
.87121 0 L
.87253 0 L
.87376 0 L
.87491 0 L
.87708 0 L
.87817 0 L
.87937 0 L
Mistroke
.88077 0 L
.8821 0 L
.88329 0 L
.88459 0 L
.886 0 L
.8875 0 L
.88892 0 L
.89021 0 L
.89151 0 L
.89272 0 L
.89404 0 L
.89543 0 L
.89665 0 L
.89778 0 L
.89903 0 L
.90036 0 L
.90158 0 L
.90292 0 L
.90432 0 L
.90564 0 L
.90686 0 L
.90799 0 L
.90922 0 L
.91052 0 L
.91184 0 L
.91326 0 L
.91459 0 L
.9158 0 L
.91723 0 L
.91877 0 L
.92024 0 L
.92158 0 L
.92274 0 L
.92398 0 L
.92516 0 L
.92623 0 L
.92749 0 L
.92886 0 L
.93015 0 L
.93135 0 L
.9327 0 L
.93398 0 L
.93512 0 L
.93636 0 L
.93771 0 L
.93914 0 L
.94036 0 L
.9417 0 L
.94281 0 L
.94384 0 L
Mistroke
.94497 0 L
.94617 0 L
.94721 0 L
.94819 0 L
.94926 0 L
.95041 0 L
.95138 0 L
.95243 0 L
.95353 0 L
.95455 0 L
.95639 0 L
.95742 0 L
.95835 0 L
.95947 0 L
.96064 0 L
.96165 0 L
.96276 0 L
.96395 0 L
.96522 0 L
.96643 0 L
.96753 0 L
.96863 0 L
.96966 0 L
.97078 0 L
.97197 0 L
.97312 0 L
.97419 0 L
.97515 0 L
.97619 0 L
Mfstroke
.02381 .00041 m
.02846 .00052 L
.03279 .00065 L
.03793 .00085 L
.04262 .00107 L
.0522 .00169 L
.05746 .00216 L
.06244 .00271 L
.06754 .0034 L
.07295 .00429 L
.08265 .00642 L
.08804 .00796 L
.09308 .00968 L
.10458 .01481 L
.11496 .02124 L
.12483 .02928 L
.14335 .05059 L
.15294 .06523 L
.16316 .0837 L
.18154 .12392 L
.20152 .17488 L
.22313 .23061 L
.23327 .25372 L
.24399 .27403 L
.25315 .28702 L
.25834 .29233 L
.26069 .29421 L
.26319 .29583 L
.26443 .29649 L
.26579 .29711 L
.26705 .29757 L
.2682 .29791 L
.26884 .29807 L
.26955 .2982 L
.27026 .29831 L
.27101 .29839 L
.27167 .29843 L
.27237 .29844 L
.27364 .29837 L
.27492 .29821 L
.27565 .29807 L
.27631 .29791 L
.27754 .29755 L
.27883 .29706 L
.28108 .29597 L
.28355 .2944 L
.28817 .29048 L
.29313 .28486 L
.3021 .27135 L
.32328 .226 L
Mistroke
.34338 .17387 L
.36345 .12277 L
.38162 .08318 L
.40134 .05035 L
.41215 .03691 L
.42232 .02693 L
.43211 .01948 L
.44244 .01353 L
.45126 .00974 L
.46092 .00666 L
.46618 .00538 L
.47116 .00436 L
.48047 .00291 L
.48569 .0023 L
.4905 .00184 L
.49575 .00144 L
.5014 .00109 L
.50644 .00085 L
.51105 .00068 L
.5201 .00042 L
.52491 .00033 L
.53015 .00025 L
.53563 .00018 L
.54072 .00014 L
.54578 .0001 L
.55127 7e-005 L
.55645 5e-005 L
.56122 4e-005 L
.56552 3e-005 L
.57026 2e-005 L
.5752 2e-005 L
.57982 1e-005 L
.58481 1e-005 L
.59025 1e-005 L
.59539 0 L
.60014 0 L
.60442 0 L
.60913 0 L
.61406 0 L
.61869 0 L
.62338 0 L
.62603 0 L
.62851 0 L
.63351 0 L
.63631 0 L
.63885 0 L
.64341 0 L
.64599 0 L
.64836 0 L
.65272 0 L
Mistroke
.65493 0 L
.65735 0 L
.65984 0 L
.66255 0 L
.66494 0 L
.66749 0 L
.67002 0 L
.67231 0 L
.67677 0 L
.67946 0 L
.68194 0 L
.6846 0 L
.68753 0 L
.69245 0 L
.69514 0 L
.69766 0 L
.70009 0 L
.70267 0 L
.7055 0 L
.70812 0 L
.71283 0 L
.71551 0 L
.71802 0 L
.72029 0 L
.72268 0 L
.72696 0 L
.72934 0 L
.73156 0 L
.734 0 L
.73658 0 L
.73921 0 L
.74164 0 L
.74425 0 L
.74712 0 L
.74959 0 L
.75225 0 L
.75476 0 L
.75706 0 L
.75927 0 L
.76162 0 L
.7642 0 L
.7666 0 L
.76905 0 L
.77135 0 L
.77343 0 L
.77565 0 L
.77807 0 L
.78033 0 L
.78301 0 L
.78545 0 L
Mistroke
.78799 0 L
.79076 0 L
.79337 0 L
.79578 0 L
.79799 0 L
.80005 0 L
.80232 0 L
.80476 0 L
.8073 0 L
.80972 0 L
.8119 0 L
.81427 0 L
.81682 0 L
.81958 0 L
.82219 0 L
.82458 0 L
.82675 0 L
.82913 0 L
.83162 0 L
.83394 0 L
.83665 0 L
.83923 0 L
.84154 0 L
.84405 0 L
.84679 0 L
.84969 0 L
.85217 0 L
.85491 0 L
.85725 0 L
.85982 0 L
.8625 0 L
.86499 0 L
.86733 0 L
.86946 0 L
.87192 0 L
.87424 0 L
.87677 0 L
.87945 0 L
.88173 0 L
.88425 0 L
.88695 0 L
.88847 0 L
.88985 0 L
.89254 0 L
.8951 0 L
.89769 0 L
.90014 0 L
.90233 0 L
.9047 0 L
.9073 0 L
Mistroke
.9086 0 L
.91003 0 L
.91257 0 L
.91493 0 L
.91732 0 L
.91958 0 L
.92161 0 L
.92382 0 L
.92621 0 L
.92876 0 L
.93093 0 L
.93333 0 L
.93568 0 L
.93826 0 L
.93956 0 L
.94094 0 L
.94344 0 L
.94464 0 L
.94594 0 L
.9483 0 L
.95059 0 L
.9527 0 L
.9552 0 L
.95754 0 L
.95888 0 L
.9601 0 L
.96152 0 L
.96285 0 L
.96548 0 L
.96687 0 L
.96835 0 L
.97083 0 L
.97224 0 L
.97357 0 L
.97619 0 L
Mfstroke
.02381 .00084 m
.03279 .00118 L
.04262 .0017 L
.05288 .00245 L
.06244 .00341 L
.0731 .00485 L
.0828 .00659 L
.094 .00925 L
.10458 .01254 L
.11428 .01637 L
.12455 .0214 L
.14299 .03343 L
.16253 .051 L
.18083 .07232 L
.2196 .13062 L
.23931 .16326 L
.26083 .19622 L
.27079 .20922 L
.28142 .22074 L
.28658 .22534 L
.29144 .229 L
.29614 .23189 L
.30053 .234 L
.30297 .23491 L
.30519 .23558 L
.30765 .23615 L
.30901 .23638 L
.3103 .23654 L
.31154 .23665 L
.31286 .23671 L
.31399 .23672 L
.31524 .23668 L
.31593 .23664 L
.31657 .23659 L
.31801 .23642 L
.31928 .23622 L
.32061 .23596 L
.32282 .23539 L
.32518 .23462 L
.32943 .2328 L
.33449 .22992 L
.33908 .22666 L
.34907 .2176 L
.35827 .2071 L
.37907 .17758 L
.41847 .11315 L
.45636 .06026 L
.4758 .04046 L
.4967 .02492 L
.50683 .01929 L
Mistroke
.51787 .01436 L
.5283 .01071 L
.53797 .00805 L
.54857 .00581 L
.55854 .00421 L
.56749 .00312 L
.57716 .00223 L
.58669 .00158 L
.59713 .00107 L
.6024 .00087 L
.60804 .0007 L
.61821 .00046 L
.62351 .00037 L
.62841 .0003 L
.63368 .00024 L
.63949 .00019 L
.64926 .00012 L
.65461 .0001 L
.65962 8e-005 L
.66948 5e-005 L
.67443 4e-005 L
.67985 3e-005 L
.68449 2e-005 L
.68944 2e-005 L
.69378 1e-005 L
.69836 1e-005 L
.70371 1e-005 L
.70863 1e-005 L
.71393 0 L
.71975 0 L
.72478 0 L
.73017 0 L
.73527 0 L
.73991 0 L
.74471 0 L
.74981 0 L
.75416 0 L
.75897 0 L
.76412 0 L
.76967 0 L
.77492 0 L
.77973 0 L
.78446 0 L
.78951 0 L
.79429 0 L
.79863 0 L
.80373 0 L
.80927 0 L
.81449 0 L
.81932 0 L
Mistroke
.82398 0 L
.829 0 L
.83373 0 L
.83806 0 L
.84312 0 L
.84598 0 L
.84864 0 L
.8535 0 L
.85622 0 L
.85869 0 L
.86357 0 L
.86603 0 L
.86872 0 L
.8735 0 L
.87795 0 L
.88065 0 L
.88321 0 L
.888 0 L
.89069 0 L
.89316 0 L
.89609 0 L
.89878 0 L
.90341 0 L
.90585 0 L
.90841 0 L
.91273 0 L
.91518 0 L
.91745 0 L
.92014 0 L
.92268 0 L
.92742 0 L
.93008 0 L
.93253 0 L
.93542 0 L
.93806 0 L
.94259 0 L
.94508 0 L
.94745 0 L
.95165 0 L
.95402 0 L
.95622 0 L
.95884 0 L
.9613 0 L
.9659 0 L
.96848 0 L
.97085 0 L
.97619 0 L
Mfstroke
.02381 .00188 m
.03279 .0024 L
.04262 .00312 L
.06244 .00516 L
.07298 .00665 L
.08426 .00863 L
.10458 .01346 L
.1148 .01661 L
.12589 .02066 L
.14603 .02992 L
.16586 .04167 L
.18689 .05711 L
.22473 .09171 L
.26501 .13309 L
.28355 .1509 L
.30379 .16747 L
.31475 .17467 L
.32492 .18001 L
.33464 .18376 L
.34008 .18525 L
.34243 .18575 L
.34501 .18621 L
.34753 .18656 L
.34989 .18679 L
.35119 .18688 L
.35237 .18695 L
.35303 .18697 L
.35374 .18699 L
.35503 .187 L
.35614 .18699 L
.35736 .18696 L
.35863 .1869 L
.35983 .18683 L
.36196 .18663 L
.36426 .18634 L
.36678 .18593 L
.36955 .18537 L
.37512 .18388 L
.38028 .18209 L
.38508 .18007 L
.40553 .16806 L
.42412 .15311 L
.4641 .11359 L
.50257 .0751 L
.52206 .05808 L
.54349 .0422 L
.56408 .02994 L
.58289 .02121 L
.60234 .0144 L
.61318 .01144 L
Mistroke
.62323 .00917 L
.64226 .00589 L
.6523 .0046 L
.66299 .00351 L
.67331 .00268 L
.68445 .00198 L
.69496 .00147 L
.70463 .00111 L
.71439 .00083 L
.72349 .00063 L
.73348 .00046 L
.74417 .00033 L
.75437 .00023 L
.76545 .00016 L
.77591 .00011 L
.78558 8e-005 L
.79523 6e-005 L
.80428 4e-005 L
.81421 3e-005 L
.81979 2e-005 L
.8249 2e-005 L
.82965 1e-005 L
.83473 1e-005 L
.84386 1e-005 L
.84945 1e-005 L
.85472 1e-005 L
.85942 0 L
.86458 0 L
.87432 0 L
.87965 0 L
.88463 0 L
.89354 0 L
.89853 0 L
.90309 0 L
.90789 0 L
.91299 0 L
.92216 0 L
.92724 0 L
.93202 0 L
.93725 0 L
.94291 0 L
.95064 0 L
.95503 0 L
.95911 0 L
.96737 0 L
.97199 0 L
.97619 0 L
Mfstroke
.02381 .00372 m
.04262 .00535 L
.06244 .00769 L
.08255 .01087 L
.10458 .01549 L
.12415 .02077 L
.14509 .02778 L
.18653 .04616 L
.22646 .06907 L
.26488 .09395 L
.30574 .11958 L
.32606 .13045 L
.3451 .13873 L
.35444 .14198 L
.36332 .14452 L
.36822 .14568 L
.37356 .14674 L
.37806 .14747 L
.38293 .14808 L
.3857 .14835 L
.38824 .14854 L
.39068 .14867 L
.3919 .14872 L
.39259 .14874 L
.39325 .14876 L
.39447 .14879 L
.39558 .1488 L
.39678 .1488 L
.39809 .14879 L
.39922 .14877 L
.40043 .14874 L
.40146 .14871 L
.4026 .14866 L
.40532 .1485 L
.40781 .1483 L
.41342 .14767 L
.41837 .14692 L
.42358 .14593 L
.43312 .14359 L
.44332 .14038 L
.46168 .13292 L
.50318 .10998 L
.54316 .08404 L
.58163 .05988 L
.62255 .0383 L
.64291 .02967 L
.66195 .0229 L
.68139 .01724 L
.69984 .01292 L
.72013 .00922 L
Mistroke
.73866 .00664 L
.75851 .00458 L
.77691 .00319 L
.7875 .00257 L
.79747 .00208 L
.81609 .00139 L
.82588 .00111 L
.83621 .00088 L
.85469 .00056 L
.8642 .00045 L
.87437 .00035 L
.89272 .00022 L
.90292 .00016 L
.914 .00012 L
.92446 9e-005 L
.93413 7e-005 L
.94378 5e-005 L
.95283 4e-005 L
.96276 3e-005 L
.97345 2e-005 L
.97619 2e-005 L
Mfstroke
.02381 .00625 m
.04262 .00812 L
.06244 .01057 L
.10458 .01768 L
.14264 .02669 L
.18314 .03918 L
.22214 .05375 L
.26358 .07101 L
.30351 .08782 L
.34193 .10228 L
.36137 .10837 L
.38279 .11376 L
.39258 .1157 L
.40311 .1174 L
.40821 .11806 L
.41305 .1186 L
.41773 .11903 L
.42214 .11936 L
.42456 .1195 L
.42717 .11963 L
.42955 .11972 L
.43173 .11979 L
.43296 .11982 L
.4341 .11984 L
.43535 .11985 L
.43606 .11986 L
.4367 .11986 L
.43799 .11987 L
.43872 .11987 L
.4394 .11986 L
.44063 .11985 L
.44195 .11983 L
.44308 .11981 L
.44412 .11979 L
.44646 .11972 L
.44852 .11963 L
.45069 .11953 L
.4553 .11924 L
.46034 .11883 L
.47061 .11768 L
.47995 .11627 L
.5009 .11194 L
.52008 .10669 L
.54088 .09984 L
.5818 .08389 L
.6212 .06718 L
.65909 .05159 L
.69943 .03688 L
.73825 .02533 L
.758 .02051 L
Mistroke
.77953 .01604 L
.81929 .00978 L
.839 .00749 L
.85999 .00556 L
.88144 .00404 L
.90162 .00295 L
.92174 .00212 L
.94023 .00155 L
.95738 .00115 L
.97619 .00081 L
Mfstroke
.02381 .00902 m
.06244 .01329 L
.10458 .01949 L
.14415 .02692 L
.18221 .0355 L
.22272 .04594 L
.26171 .05681 L
.30316 .06853 L
.34309 .0791 L
.3815 .08771 L
.40095 .09123 L
.42237 .09432 L
.43215 .09543 L
.44268 .0964 L
.44778 .09679 L
.45262 .0971 L
.45731 .09736 L
.46172 .09755 L
.46413 .09764 L
.46674 .09772 L
.46892 .09778 L
.4713 .09783 L
.47255 .09785 L
.47389 .09787 L
.4753 .09788 L
.47663 .09789 L
.47794 .0979 L
.47919 .0979 L
.48031 .0979 L
.48152 .09789 L
.48266 .09789 L
.48372 .09788 L
.48489 .09787 L
.48615 .09785 L
.48872 .0978 L
.49107 .09774 L
.49538 .09761 L
.49991 .09742 L
.50945 .09688 L
.51965 .09608 L
.53802 .0941 L
.55936 .09095 L
.57952 .08723 L
.61798 .07848 L
.6589 .06757 L
.6983 .05641 L
.73619 .04585 L
.77653 .03546 L
.81535 .02673 L
.85663 .01906 L
Mistroke
.89639 .01325 L
.93464 .00903 L
.97533 .00579 L
.97619 .00573 L
Mfstroke
.02381 .01158 m
.06244 .01549 L
.10458 .02071 L
.14415 .02652 L
.18221 .03286 L
.22272 .04026 L
.26171 .04778 L
.30316 .05583 L
.34309 .06322 L
.3815 .06958 L
.42237 .07512 L
.44268 .07727 L
.46172 .07887 L
.47994 .08001 L
.49018 .08047 L
.49955 .08078 L
.50432 .08089 L
.50693 .08094 L
.5094 .08098 L
.5117 .08101 L
.51291 .08102 L
.51419 .08104 L
.51527 .08104 L
.51645 .08105 L
.51753 .08106 L
.51854 .08106 L
.51982 .08106 L
.52055 .08106 L
.52122 .08106 L
.52246 .08106 L
.52377 .08106 L
.52494 .08105 L
.52604 .08105 L
.52854 .08102 L
.53123 .08099 L
.5337 .08096 L
.53926 .08084 L
.544 .08072 L
.54906 .08055 L
.55818 .08017 L
.56903 .07959 L
.57888 .07893 L
.59807 .07733 L
.61887 .07514 L
.65979 .0696 L
.69919 .06307 L
.73708 .05605 L
.77742 .04823 L
.81624 .04073 L
.85752 .03316 L
Mistroke
.89728 .02652 L
.93552 .02089 L
.97619 .0158 L
Mfstroke
.02381 .01364 m
.06244 .01703 L
.10458 .0213 L
.14415 .02581 L
.18221 .03055 L
.22272 .0359 L
.26171 .04123 L
.30316 .04688 L
.34309 .05211 L
.3815 .05674 L
.42237 .06102 L
.46172 .0643 L
.48147 .06559 L
.49955 .06653 L
.51896 .0673 L
.52966 .0676 L
.535 .06772 L
.53984 .06781 L
.54444 .06788 L
.54943 .06793 L
.55217 .06796 L
.55469 .06797 L
.5571 .06799 L
.55831 .06799 L
.55895 .06799 L
.55964 .06799 L
.56088 .06799 L
.56205 .06799 L
.56318 .06799 L
.56423 .06799 L
.56537 .06799 L
.56662 .06799 L
.56793 .06798 L
.56915 .06798 L
.57138 .06796 L
.57343 .06795 L
.57803 .0679 L
.58277 .06783 L
.58784 .06775 L
.59696 .06754 L
.6078 .06721 L
.61766 .06684 L
.63684 .06592 L
.65764 .06464 L
.69856 .06133 L
.73796 .05728 L
.77585 .05278 L
.81619 .04754 L
.85501 .04226 L
.89629 .03661 L
Mistroke
.93605 .03132 L
.97429 .02651 L
.97619 .02628 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{430, 265.625},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006^00012A000`40O003h00OWgoo00<007ooOol0
BGoo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0A7oo00<007ooOol027oo00<007ooOol0
A7oo00<007ooOol017oo00<007ooOol00Woo00<007ooOol047oo002OOol00`00Oomoo`19Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`14Ool00`00Oomoo`08Ool00`00Oomoo`15Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0@Ool009Yoo`D004aoo`03001oogoo00=oo`03001o
ogoo009oo`03001oogoo04Aoo`03001oogoo00=oo`D004Uoo`03001oogoo009oo`03001oogoo009o
o`03001oogoo011oo`00VWoo00<007ooOol0CWoo00<007ooOol00goo00<007ooOol00Woo00<007oo
Ool0A7oo00<007ooOol00goo00<007ooOol0C7oo00D007ooOomoo`0000Aoo`03001oogoo011oo`00
VWoo00<007ooOol0CWoo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0A7oo00<007ooOol0
0goo00<007ooOol0C7oo00D007ooOomoo`0000Aoo`03001oogoo011oo`00VWoo00<007ooOol0C7oo
0`001Goo00<007ooOol00Woo00<007ooOol0@Woo0`001Goo00<007ooOol0Agoo00<007ooOol00Woo
00D007ooOomoo`0000Aoo`03001oogoo011oo`00VWoo1P00Bgoo00<007ooOol017oo1000Agoo00<0
07ooOol00goo1P00AGoo10001Goo10004goo003oOon_Ool00?moojmoo`00ogoo[goo003oOon_Ool0
0?moojmoo`00ogoo[goo003oOon_Ool000moool00900011oo`0067oo4`003Woo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol00goo1P001Goo00<007oo
Ool01goo1`0047oo00<007oo000010002Goo00<007ooOol03Goo1`002Woo00<007ooOol03Woo2@00
1goo00<007ooOol03Woo00<007ooOol00goo30003goo00<007ooOol03Goo400000=oo`00Ool03Woo
00<007ooOol01Goo600000=oo`00Ool03goo00<007ooOol05goo000HOolI000IOol00`00Oomoo`0c
Ool00`00Oomoo`0?Ool40006Ool00`00Oomoo`0<Ool4000IOol5000KOol8000NOol8000NOol>000P
Ool8000ROol9000IOol001Qooa/001Moo`03001oogoo035oo`80015oo`03001oogoo01Eoo`8001Yo
o`<001aoo`@0029oo`@0029oo`@002Ioo`P001ioo``0029oo`0067oo4`0000=oo`0000002@004goo
00<007ooOol0;goo0P0047oo0`005Woo0P006Goo0`0077oo0`007goo1`008Goo1@008Woo20007Woo
2000;Woo000HOolJ00000goo00000006000?Ool00`00Oomoo`0]Ool2000@Ool2000GOol2000HOol3
000MOol2000POol2000ROol6000OOol8000OOol7000fOol001]oob<000aoo`03001oogoo02aoo`03
001oogoo00moo`03001oogoo01Eoo`8001Uoo`03001oogoo01aoo`8001moo`<0021oo`@001moo`H0
01moo`P001moo`D001Uoo`0077oo00<007ooOol01Goo70002Woo00<007ooOol0:goo00<007ooOol0
3goo00<007ooOol057oo0P006Goo0P007Goo0P007Goo10007goo10007goo10007Woo1`007goo2000
7Woo000MOol00`00Oomoo`0;Ool00`00Oomoo`03OolA0008Ool00`00Oomoo`0ZOol00`00Oomoo`0@
Ool00`00Oomoo`0COol00`00Oomoo`0HOol00`00Oomoo`0KOol2000LOol3000OOol4000OOol4000M
Ool5000NOol8000VOol001ioo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo009oo`X000Ao
o`03001oogoo02Uoo`03001oogoo011oo`03001oogoo01=oo`03001oogoo01Qoo`03001oogoo01Yo
o`8001aoo`8001moo`<001moo`@001]oo`H001]oo`P002ioo`007goo00<007ooOol02goo00<007oo
Ool027oo00<007ooOol017oo00<007oo00002P00:Goo00<007ooOol047oo00<007ooOol04goo00<0
07ooOol05goo0P006goo0P0077oo0P007goo0P007Woo10006goo10006goo1P0067oo1@006Goo000O
Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00Oomoo`04Ool01000Oomoogoo400087oo00<007oo
Ool047oo00<007ooOol04goo00<007ooOol05goo00<007ooOol06Goo0P0077oo0P007Woo0`007Goo
0`006goo10006Woo1@005Woo20007Woo000POol00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00Oomo
o`04Ool00`00Oomoo`02OolF000HOol00`00Oomoo`0?Ool00`00Oomoo`0DOol00`00Oomoo`0FOol0
0`00Oomoo`0IOol00`00Oomoo`0KOol00`00Oomoo`0KOol3000MOol3000JOol4000HOol6000DOol7
000VOol0025oo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo00Eoo`03001oogoo00=oo`05
001oo`00001oo`0200000goo000000080002Ool8000?Ool00`00Oomoo`0?Ool00`00Oomoo`0DOol0
0`00Oomoo`0FOol00`00Oomoo`0HOol2000LOol2000LOol2000LOol4000IOol4000GOol5000BOol8
000]Ool0025oo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00Eoo`03001oogoo00=oo`80
0004Ool00000Ool20003Ool<0004Ool80006Ool00`00Oomoo`0@Ool00`00Oomoo`0COol00`00Oomo
o`0FOol00`00Oomoo`0HOol00`00Oomoo`0JOol2000KOol3000KOol3000IOol4000FOol5000@Ool7
000eOol0029oo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo00Ioo`03001oogoo00=oo`04
001oogooOol2000017oo000000000goo1`000Woo1P001Woo200047oo00<007ooOol04goo00<007oo
Ool05Woo00<007ooOol05goo0P006goo0P006goo0P006goo0`0067oo100057oo1P003goo1P00?7oo
000ROol00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`06Ool00`00Oomoo`02Ool20004Ool2
0002Ool20004Ool20002Ool40004Ool50006Ool00`00Oomoo`06000:Ool00`00Oomoo`0BOol00`00
Oomoo`0FOol00`00Oomoo`0GOol00`00Oomoo`0IOol2000KOol2000JOol3000GOol4000COol5000?
Ool60012Ool002=oo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00Eoo`03001oogoo009o
o`04001oo`000004Ool01000Oomoogoo0P0017oo0`000goo10001Goo1@0000=oo`00Ool01goo1P00
0goo00<007ooOol04goo00<007ooOol05Goo00<007ooOol05goo00<007ooOol06Goo00<007ooOol0
6Goo0P006Goo0`005Woo10004Woo1@003Woo1P00B7oo000SOol00`00Oomoo`0<Ool00`00Oomoo`08
Ool00`00Oomoo`06Ool01@00Oomoogoo00000goo00<007ooOol00Woo00<007ooOol00Woo0P001Goo
0P001Goo10001Woo1@002goo1P004Woo00<007ooOol05Woo00<007ooOol05Woo00<007ooOol06Goo
00<007ooOol067oo0P005goo10005Goo100047oo1P002goo2000CWoo000TOol00`00Oomoo`0;Ool0
0`00Oomoo`09Ool00`00Oomoo`06Ool01000Oomoo`0017oo00<007ooOol00Woo00<007ooOol00goo
0P001Goo0`001Woo10000Woo00<007ooOol00Woo1@0027oo00@007ooOomoo`H000]oo`03001oogoo
01Ioo`03001oogoo01Ioo`03001oogoo01Qoo`8001Yoo`03001oogoo01Aoo`<001Eoo`@000moo`D0
00Yoo`L005Ioo`0097oo00<007ooOol037oo00<007ooOol027oo00<007ooOol01goo00@007oo0000
00Aoo`03001oogoo009oo`8000Eoo`8000Ioo`8000Qoo`@000Qoo`H0009oo`03001oogoo00Moo`P0
00=oo`03001oogoo01Eoo`03001oogoo01Ioo`03001oogoo01Qoo`03001oogoo01Qoo`8001Aoo`<0
01Aoo`@000ioo`D000Moo`P005eoo`009Goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol0
1goo0P001Woo00<007ooOol00goo00<007ooOol017oo0P001Woo0`001Woo00<007ooOol010002Woo
1P003Woo30003Woo00<007ooOol05goo00<007ooOol05goo00<007ooOol05goo0P0057oo0P004goo
100037oo1P0017oo2000IGoo000UOol00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`07Ool2
0007Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`06Ool20004Ool00`00Oomoo`04Ool3
0008Ool00`00Oomoo`02Ool5000;Ool00`00Oomoo`07Ool;0003Ool00`00Oomoo`0FOol00`00Oomo
o`0FOol2000HOol2000DOol2000BOol3000;Ool50002Ool8001]Ool002Ioo`03001oogoo00]oo`03
001oogoo00Uoo`03001oogoo00Moo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`80
00Qoo`@000Yoo`@000=oo`03001oogoo00Qoo`D000Eoo`03001oogoo01=oo`P001=oo`03001oogoo
01Ioo`03001oogoo01Ioo`8001Aoo`80015oo`<000Uoo``007Eoo`009Woo00<007ooOol037oo00<0
07ooOol027oo00<007ooOol01goo0P001goo00<007ooOol017oo00<007ooOol01Woo0P002Goo0P00
3Goo10003goo1P005goo00<007ooOol00goo30001Woo00<007ooOol05Woo00<007ooOol05Woo00<0
07ooOol04Woo0P0047oo0`0000=oo`0000002P00P7oo000VOol00`00Oomoo`0<Ool00`00Oomoo`09
Ool00`00Oomoo`06Ool20008Ool00`00Oomoo`04Ool00`00Oomoo`07Ool20007Ool01000Ool00000
3Woo0`004Woo1P004Goo00<007ooOol047oo30004Woo00<007ooOol05Goo0P004goo0P003Woo2000
00=oo`0000000`00QWoo000WOol00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`06Ool00`00
Ool00008Ool00`00Oomoo`04Ool20009Ool20004Ool00`00Oomoo`02Ool3000:Ool01000Oomoogoo
10003Goo00<007ooOol017oo1@002goo00<007ooOol05Woo00<007ooOol017oo3`000Woo00<007oo
Ool057oo0P003goo5P0017oo1@00Rgoo000WOol00`00Oomoo`0<Ool00`00Oomoo`09Ool00`00Oomo
o`05Ool01000Oomoo`001goo00<007ooOol01Woo00<007ooOol027oo00D007ooOomoo`0000Moo`80
00Qoo`03001oogoo00Eoo`<000Yoo`03001oogoo00Uoo`D000Ioo`03001oogoo01Eoo`03001oogoo
01AoobX00004Ool00000000<Ool30002Ool5002@Ool002Moo`03001oogoo00aoo`03001oogoo00Uo
o`03001oogoo00Eoo`04001oogoo0008Ool00`00Oomoo`06Ool00`00Oomoo`08Ool3000:Ool30004
Ool00`00Oomoo`09Ool40006Ool00`00Oomoo`0>Ool6000GOol00`00Oomoo`0DOol00`00Oomoo`0D
Ool00`00Oomoo`0@Ool2000;Ool9002EOol002Qoo`03001oogoo00aoo`03001oogoo00Uoo`03001o
ogoo00Aoo`80009oo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Uoo`03001oogoo00]o
o`80009oo`03001oogoo00eoo`@00003Ool007oo01Aoo`03001oo`0000L000ioo`03001oogoo01Ao
o`03001oogoo01=oo`80011oo`<000Moo`P009aoo`00:7oo00<007ooOol037oo00<007ooOol02Goo
00<007ooOol017oo00D007ooOomoo`0000Uoo`03001oogoo00Ioo`03001oogoo00Qoo`<000eoo`<0
01=oo`@001=oo`03001oogoo00Moo`P000Ioo`03001oogoo01=oo`03001oogoo019oo`80011oo`80
009oo`X00:9oo`00:7oo00<007ooOol03Goo00<007ooOol02Goo00<007ooOol00goo00<007ooOol0
0Woo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01Woo00D007ooOomoo`0000eoo`<0019o
o`04001oogooOol4000>Ool00`00Oomoo`0@Ool@000;Ool00`00Oomoo`0AOol20008Ool>0002Ool4
002VOol002Qoo`03001oogoo00eoo`03001oogoo00Uoo`03001oogoo00=oo`03001oogoo009oo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Eoo`03001oogoo009oo`8000]oo`03001oogoo
00<000moo`03001oogoo00Eoo`@000Yoo`03001oogoo01Aoo`03001oogoo00UoobT000Eoo`8000Eo
o`@00:Yoo`00:Goo00<007ooOol037oo00<007ooOol02Goo00<007ooOol00goo00<007ooOol00goo
00<007ooOol01goo00<007ooOol01goo0P001Goo00<007ooOol017oo00<007ooOol01goo00<007oo
Ool017oo0P003Goo00<007ooOol02Goo10001Goo00<007ooOol05Goo00<007ooOol04Woo00<007oo
Ool047oo00<007ooOol037oo0`000goo1000[Woo000YOol00`00Oomoo`0=Ool00`00Oomoo`09Ool0
0`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomoo`09Ool00`00Oomoo`02Ool0
0`00Oomoo`05Ool20007Ool00`00Oomoo`06Ool2000:Ool00`00Oomoo`0>Ool400000goo001oo`0E
Ool00`00Oomoo`0BOol00`00Oomoo`0?Ool2000=Ool20002Ool4002bOol002Uoo`03001oogoo00eo
o`03001oogoo00Uoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo00Moo`03001oogoo00Uo
o`04001oogoo000:Ool00`00Oomoo`04Ool00`00Oomoo`08Ool30007Ool00`00Oomoo`0BOol5000B
Ool00`00Oomoo`0BOol00`00Oomoo`0?Ool00`00Oomoo`0:Ool7002fOol002Uoo`03001oogoo00eo
o`03001oogoo00Uoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo00Qoo`03001oogoo00Uo
o`03001oo`0000]oo`8000=oo`03001oogoo00aoo`8000Aoo`03001oogoo01=oo`03001oogoo009o
o`P000Uoo`03001oogoo019oo`03001oogoo00ioo`8000Ioo`T00;]oo`00:Woo00<007ooOol03Goo
00<007ooOol02Goo00D007ooOomoo`0000Moo`03001oogoo00Moo`03001oogoo00Yoo`8000eoo`04
001oogoo000@Ool300000goo001oo`0COol00`00Oomoo`0;Ool60003Ool00`00Oomoo`0AOol00`00
Oomoo`0>Ool90003Ool2002oOol002Yoo`03001oogoo00eoo`03001oogoo00Uoo`05001oogooOol0
0007Ool00`00Oomoo`08Ool00`00Oomoo`0:Ool00`00Oomoo`0<Ool3000COol2000DOol00`00Oomo
o`0AOol9000=Ool00`00Oomoo`07Ool90008Ool30031Ool002Yoo`03001oogoo00eoo`03001oogoo
00Yoo`03001oogoo008000Moo`03001oogoo00Qoo`03001oogoo00Uoo`8000moo`80019oo`03001o
o`000080011oo`03001oogoo01=oo`03001oogoo00EooaL000Eoo`8000Qoo`800<Aoo`00:Woo00<0
07ooOol03Goo00<007ooOol02Woo00@007ooOol000Qoo`03001oogoo00Qoo`03001oogoo00Qoo`04
001oogoo000=Ool01000Oomoo`004Goo00<007ooOol00Woo0P003Woo00<007ooOol04goo00<007oo
Ool047oo00<007ooOol03Goo00<007ooOol01Goo0`00aWoo000[Ool00`00Oomoo`0=Ool00`00Oomo
o`09Ool01000Oomoo`002Goo00<007ooOol027oo00<007ooOol01goo00D007ooOomoo`0000aoo`04
001oogooOol2000?Ool00`00Oomoo`04Ool3000:Ool00`00Oomoo`0COol00`00Oomoo`0@Ool00`00
Oomoo`0<Ool20004Ool40039Ool002]oo`03001oogoo00eoo`03001oogoo00Yoo`03001oo`0000Uo
o`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00=o
o`8000aoo`03001oogoo00Qoo`@000Ioo`03001oogoo019oo`03001oogoo011oo`03001oogoo00ao
o`03001oogoo00@00<eoo`00:goo00<007ooOol03Goo00<007ooOol02Woo00<007oo00002Goo00<0
07ooOol02Goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol027oo00<007ooOol01Goo0P00
2Woo00<007ooOol037oo10000Woo00<007ooOol04Goo00<007ooOol047oo00<007ooOol02goo1@00
dGoo000[Ool00`00Oomoo`0=Ool00`00Oomoo`0:Ool00`00Ool0000:Ool00`00Oomoo`09Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00
Oomoo`0@Ool4000BOol00`00Oomoo`0?Ool00`00Oomoo`09Ool4003EOol002aoo`D000Ioo`8000=o
o`03001oogoo00D000Eoo`8000Yoo`03001oogoo00Uoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Ioo`03001oogoo00Uoo`8000Ioo`03001oogoo019oo`03001oogoo00@000eoo`03001o
ogoo00moo`03001oogoo00Ioo`H00=Moo`00;7oo00<007ooOol00Woo00<007ooOol00goo0P000goo
00<007ooOol00Woo00<007ooOol01Goo0P002goo00<007ooOol02Goo00<007ooOol00goo00<007oo
Ool01Woo00<007ooOol01Goo00<007ooOol02goo0P0017oo00<007ooOol04Goo00<007ooOol01Goo
100027oo00<007ooOol03goo00<007ooOol00goo10000Woo0P00fGoo000/Ool00`00Oomoo`02Ool0
0`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`05Ool2000;Ool00`00Oomoo`0:Ool00`00Oomo
o`02Ool00`00Oomoo`07Ool00`00Oomoo`04Ool00`00Oomoo`0=Ool01@00Oomoogoo00004goo00<0
07ooOol02Goo3@001goo300017oo0P00fgoo000/Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00
Oomoo`02Ool00`00Oomoo`05Ool2000<Ool00`00Oomoo`09Ool00`00Oomoo`02Ool00`00Oomoo`08
Ool00`00Oomoo`02Ool00`00Oomoo`0?Ool3000COol00`00Oomoo`0AOol00`00Oomoo`03Ool80003
Ool00`00Oomoo`08Ool00`00Oomoo`3KOol002aoo`8000=oo`03001oogoo00Uoo`05001oogooOol0
0008Ool3000:Ool00`00Oomoo`0:Ool01@00Oomoogoo00002goo00D007ooOomoo`0001=oo`03001o
ogoo015oo`03001oogoo015oo`03001oogoo00eoo`03001oogoo00Moo`800=ioo`00;7oo0P000goo
00<007ooOol02Goo00D007ooOomoo`0000Qoo`03001oogoo00Yoo`03001oogoo00]oo`03001oo`00
00eoo`04001oogoo000COol3000AOol00`00Oomoo`0@Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool2
003POol002aoo`8000=oo`03001oogoo00Uoo`05001oogooOol00008Ool00`00Oomoo`0;Ool00`00
Oomoo`0:Ool00`00Ool0000>Ool00`00Ool0000BOol01000Oomoogoo0P003Woo00<007ooOol047oo
00<007ooOol03Goo00<007ooOol01Goo0P00hWoo000/Ool20003Ool00`00Oomoo`09Ool01@00Oomo
ogoo000027oo0P0037oo00<007ooOol02goo0P003goo00<007ooOol04Goo00<007ooOol00goo0P00
37oo00<007ooOol047oo00<007ooOol037oo00<007ooOol017oo0P00i7oo000/Ool00`00Ool00002
Ool00`00Oomoo`0:Ool40008Ool2000=Ool00`00Oomoo`0;Ool00`00Oomoo`0=Ool2000BOol00`00
Oomoo`05Ool20009Ool00`00Oomoo`0@Ool00`00Oomoo`0<Ool00`00Oomoo`03Ool2003VOol002eo
o`@000eoo`04001oogoo0008Ool2000=Ool00`00Oomoo`0:Ool2000?Ool00`00Ool0000@Ool00`00
Oomoo`08Ool20007Ool00`00Oomoo`0?Ool00`00Oomoo`0<Ool00`00Oomoo`02Ool2003XOol002io
o`03001oogoo00eoo`03001oogoo00Uoo`8000eoo`03001oogoo00Yoo`03001oo`0000ioo`04001o
ogoo000?Ool00`00Oomoo`0:Ool30004Ool00`00Oomoo`0?Ool00`00Oomoo`0;Ool00`00Oomoo`03
003ZOol002ioo`03001oogoo00eoo`03001oogoo00Uoo`03001oo`0000eoo`03001oogoo00Uoo`03
001oo`0000eoo`03001oogoo009oo`03001oogoo00aoo`03001oogoo00eoo`@0015oo`03001oogoo
00]oo`@00>eoo`00;goo00<007ooOol037oo00<007ooOol02Goo00<007oo00003Goo00<007ooOol0
2Goo00@007ooOol000aoo`03001oogoo00=oo`8000]oo`03001oogoo015oo`@000ioo`03001oogoo
00Qoo`@00?1oo`00;goo00<007ooOol03Goo00<007ooOol027oo00<007oo00003Goo00<007ooOol0
2Goo00D007ooOomoo`0000]oo`03001oogoo00Eoo`03001oogoo00Qoo`03001oogoo011oo`03001o
ogoo009oo`@000Uoo`03001oogoo00Aoo`D00003Ool007oo0?5oo`00;goo00<007ooOol03Goo00<0
07ooOol027oo0P0000=oo`00Ool037oo00<007ooOol01goo00<007ooOol00Woo00<007ooOol02Goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol047oo00<007ooOol01Woo40001Goo00<007oo
Ool0lGoo000_Ool00`00Oomoo`0=Ool00`00Oomoo`08Ool01000Oomoo`003Goo00<007ooOol01goo
00<007ooOol00goo00<007ooOol027oo00<007ooOol01goo00<007ooOol01Goo00<007ooOol04Goo
00<007ooOol03Woo00<007ooOol02Goo00<007ooOol0lWoo000`Ool00`00Oomoo`0<Ool00`00Oomo
o`08Ool01000Oomoo`003Woo00<007ooOol01Woo00<007ooOol017oo00<007ooOol01Woo00<007oo
Ool02Goo00<007ooOol017oo00<007ooOol047oo00<007ooOol03Woo00<007ooOol02Goo00<007oo
Ool0lgoo000`Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool01000Oomoo`003Woo00<007ooOol01Woo
00<007ooOol017oo00<007ooOol01Woo00<007ooOol02Woo00<007ooOol00goo00<007ooOol047oo
00<007ooOol03Woo00<007ooOol027oo00<007ooOol0m7oo000`Ool00`00Oomoo`0=Ool00`00Oomo
o`07Ool01@00Oomoogoo00003Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol02goo00D007ooOomoo`00019oo`03001oogoo00ioo`03001oogoo00Moo`800?Moo`00<7oo
00<007ooOol03Goo00<007ooOol01goo00D007ooOomoo`0000ioo`03001oogoo00Aoo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00aoo`800003Ool007oo015oo`03001oogoo00eoo`03001o
ogoo00Moo`03001oogoo0?Moo`00<7oo00<007ooOol03Goo00<007ooOol01goo00D007ooOomoo`00
00ioo`03001oogoo00Aoo`03001oogoo00Moo`03001oogoo00=oo`03001oogoo00moo`80019oo`03
001oogoo00eoo`03001oogoo00Ioo`03001oogoo0?Qoo`00<Goo00<007ooOol037oo00<007ooOol0
1goo00<007ooOol00Woo00<007ooOol02goo00<007ooOol017oo00<007ooOol027oo00<007ooOol0
0Woo00<007ooOol03goo0P004Goo00<007ooOol03Goo00<007ooOol01Goo0P00ngoo000aOol00`00
Oomoo`0<Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`03Ool00`00
Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`0?Ool00`00Ool0000@Ool00`00Oomoo`0<Ool00`00
Oomoo`05Ool00`00Oomoo`3kOol0035oo`03001oogoo00eoo`03001oogoo00Ioo`03001oogoo009o
o`03001oogoo00aoo`03001oogoo009oo`03001oogoo00Yoo`05001oogooOol0000AOol00`00Oomo
o`02000=Ool00`00Oomoo`0=Ool00`00Oomoo`03Ool2003nOol0035oo`03001oogoo00eoo`03001o
ogoo00Ioo`8000=oo`03001oogoo00eoo`05001oogooOol0000=Ool01000Oomoo`004Goo00<007oo
Ool00Woo0P002goo00<007ooOol037oo00<007ooOol00goo00<007ooOol0oWoo000aOol00`00Oomo
o`0=Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`0<Ool01@00Oomoogoo00003Goo00<0
07oo00004Goo00<007ooOol01Goo00<007ooOol027oo00<007ooOol037oo00@007ooOomoo`800?mo
o`9oo`00<Goo00<007ooOol03Goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol037oo00D0
07ooOomoo`0000ioo`80015oo`03001oogoo00Ioo`8000Moo`03001oogoo00aoo`03001oogoo0080
0?moo`Aoo`00<Woo00<007ooOol037oo00<007ooOol01Woo00<007ooOol00goo00<007ooOol03Goo
00<007oo000047oo00<007ooOol03goo00<007ooOol027oo0P001Goo00<007ooOol02goo1000ogoo
1Woo000bOol00`00Oomoo`0=Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`0<Ool00`00
Ool0000@Ool2000@Ool00`00Oomoo`0:Ool300000goo001oo`0<Ool2003oOol9Ool0039oo`03001o
ogoo00eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00eoo`80011oo`8000moo`03001o
ogoo00iooa000?moo`Yoo`00<Woo00<007ooOol03Goo00<007ooOol01Goo00<007ooOol017oo00<0
07ooOol03Goo0P003goo00@007ooOol000ioo`03001oogoo00moo`03001oogoo00Yoo`03001oogoo
0?moo`Uoo`00<Woo00<007ooOol03Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol03Goo
0P003goo00D007ooOomoo`0000eoo`03001oogoo00ioo`03001oogoo00Yoo`03001oogoo0?moo`Yo
o`00<goo00<007ooOol037oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol037oo0P003goo
00D007ooOomoo`0000eoo`03001oogoo00ioo`03001oogoo00Yoo`03001oogoo0?moo`Yoo`00<goo
00<007ooOol03Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol037oo0P003goo00<007oo
Ool00Woo00<007ooOol02Goo00<007ooOol03goo00<007ooOol02Goo00<007ooOol0ogoo2goo000c
Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool20006Ool00`00Oomoo`0<Ool00`00Ool0000>Ool00`00
Oomoo`03Ool00`00Oomoo`08Ool00`00Oomoo`0>Ool00`00Oomoo`09Ool00`00Oomoo`3oOol<Ool0
03=oo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00aoo`03001oo`00
00eoo`03001oogoo00Eoo`03001oogoo00Moo`03001oogoo00ioo`03001oogoo00Qoo`03001oogoo
0?moo`eoo`00<goo00<007ooOol03Goo00<007ooOol017oo00<007ooOol01Woo00<007ooOol02Woo
00D007ooOomoo`0000aoo`03001oogoo00Eoo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo
00Uoo`03001oogoo0?moo`eoo`00<goo00<007ooOol03Goo00<007ooOol017oo00<007ooOol01Woo
00<007ooOol02Woo00D007ooOomoo`0000aoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo
00ioo`03001oogoo00Qoo`03001oogoo0?moo`ioo`00=7oo00<007ooOol037oo00<007ooOol017oo
00<007ooOol01Woo00<007ooOol02Woo00D007ooOomoo`0000aoo`03001oogoo00Moo`03001oogoo
00Aoo`03001oogoo00ioo`03001oogoo00Moo`03001oogoo0?moo`moo`00=7oo00<007ooOol03Goo
00<007ooOol00goo00<007ooOol01Woo00<007ooOol02Woo00<007ooOol00Woo00<007ooOol02Goo
00<007ooOol027oo00<007ooOol00goo00<007ooOol03Goo00<007ooOol01goo00<007ooOol0ogoo
47oo000dOol00`00Oomoo`0=Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomoo`09Ool00`00
Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00
Oomoo`07Ool00`00Oomoo`3oOol@Ool003Aoo`03001oogoo00eoo`03001oogoo00=oo`03001oogoo
00Moo`03001oogoo00Qoo`03001oogoo00Aoo`03001oogoo00Moo`03001oogoo00Yoo`05001oogoo
Ool0000@Ool00`00Oomoo`06Ool00`00Oomoo`3oOolAOol003Aoo`03001oogoo00eoo`03001oogoo
00=oo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Aoo`03001oogoo00Moo`03001oogoo
00]oo`04001oogoo000?Ool00`00Oomoo`06Ool00`00Oomoo`3oOolBOol003Eoo`03001oogoo00ao
o`03001oogoo00=oo`8000Uoo`03001oogoo00Moo`03001oogoo00Aoo`03001oogoo00Moo`03001o
ogoo00aoo`03001oo`0000moo`03001oogoo00Eoo`03001oogoo0?mooa=oo`00=Goo00<007ooOol0
3Goo00<007ooOol00Woo00<007ooOol027oo00<007ooOol01goo00<007ooOol01Goo00<007ooOol0
1Woo00<007ooOol03Goo0P003Woo00<007ooOol017oo0P00ogoo5Woo000eOol00`00Oomoo`0=Ool0
0`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`0>Ool2000>Ool00`00Oomoo`03Ool00`00Oomoo`3oOolFOol003Eoo`03001oogoo00eo
o`03001oogoo009oo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Ao
o`03001oogoo00ioo`04001oo`00000;Ool00`00Oomoo`02Ool2003oOolIOol003Eoo`03001oogoo
00eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00Eoo`03001oogoo00Moo`03001oogoo
00Aoo`03001oogoo00ioo`04001oogooOol20009Ool01@00Oomoogoo0000ogoo6goo000eOol00`00
Oomoo`0=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`05Ool00`00Oomoo`07Ool00`00
Oomoo`04Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool30005Ool00`00Ool00002003oOolLOol002eo
o`@000Eoo`<000Eoo`H0009oo`05001oogooOol0000;Ool00`00Oomoo`05Ool00`00Oomoo`08Ool0
0`00Oomoo`03Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool8003oOolOOol002aoo`03001oogoo009o
o`03001oogoo009oo`<000Eoo`03001oogoo00Eoo`05001oogooOol0000;Ool00`00Oomoo`05Ool0
0`00Oomoo`08Ool00`00Oomoo`03Ool00`00Oomoo`0=Ool00`00Oomoo`0;Ool00`00Oomoo`3oOolO
Ool002aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo00Aoo`05001o
ogooOol0000<Ool00`00Oomoo`04Ool00`00Oomoo`09Ool01@00Oomoogoo000047oo00<007ooOol0
2goo00<007ooOol0ogoo7goo000/Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`07Ool0
0`00Oomoo`03Ool01@00Oomoogoo000037oo00<007ooOol017oo00<007ooOol02Goo00D007ooOomo
o`0000moo`03001oogoo00]oo`03001oogoo0?moob1oo`00;7oo00<007ooOol00Woo00<007ooOol0
0Woo00<007ooOol027oo00<007ooOol00Woo00@007ooOomoo`<000Yoo`03001oogoo00=oo`03001o
ogoo00]oo`04001oogoo000?Ool00`00Oomoo`0;Ool00`00Oomoo`3oOolPOol002aoo`03001oogoo
009oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo009oo`04001oogoo000<Ool00`00Oomo
o`03Ool00`00Oomoo`0;Ool01000Oomoo`003goo00<007ooOol02Woo00<007ooOol0ogoo8Goo000/
Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`09Ool01@00Oomoogoo00000Woo00<007oo
Ool02goo00<007ooOol00Woo00<007ooOol037oo00<007oo00003goo00<007ooOol02Woo00<007oo
Ool0ogoo8Goo000/Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`09Ool01@00Oomoogoo
00000Woo00<007ooOol02goo00<007ooOol00Woo00<007ooOol037oo0P003goo00<007ooOol02Woo
00<007ooOol0ogoo8Woo000/Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00
Oomoo`02Ool01@00Oomoogoo00000Woo00<007ooOol02goo00<007ooOol00Woo00<007ooOol03Goo
00<007ooOol03Goo00<007ooOol02Woo00<007ooOol0ogoo8Woo000]Ool40006Ool00`00Oomoo`05
Ool40004Ool01000Oomoo`003Goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol03Goo00<0
07ooOol02Goo00<007ooOol0ogoo8goo000gOol00`00Oomoo`0=Ool01000Oomoo`003Woo00@007oo
Ool0011oo`8000ioo`03001oogoo00Uoo`03001oogoo0?moob=oo`00>7oo00<007ooOol03Goo00<0
07oo00003Woo00@007ooOol0011oo`8000eoo`03001oogoo00Uoo`03001oogoo0?moobAoo`00>7oo
00<007ooOol03Goo00<007oo00003Woo00@007ooOol0011oo`03001oo`0000aoo`03001oogoo00Uo
o`03001oogoo0?moobAoo`00>7oo00<007ooOol03Goo00<007oo00003goo00<007oo00003goo00@0
07ooOol000aoo`03001oogoo00Qoo`03001oogoo0?moobEoo`00>7oo00<007ooOol03Goo00@007oo
000000ioo`03001oo`0000moo`05001oogooOol0000;Ool00`00Oomoo`08Ool00`00Oomoo`3oOolU
Ool003Qoo`03001oogoo00eoo`03001oo`0000moo`80011oo`05001oogooOol0000:Ool00`00Oomo
o`08Ool00`00Oomoo`3oOolVOol003Qoo`03001oogoo00ioo`8000moo`80011oo`03001oogoo009o
o`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo0?moobIoo`00>Goo00<007ooOol03Goo0P00
47oo00<007ooOol03Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol0
ogoo9goo000iOol00`00Oomoo`0=Ool2000@Ool00`00Oomoo`0>Ool00`00Oomoo`03Ool00`00Oomo
o`06Ool00`00Oomoo`07Ool00`00Oomoo`3oOolWOol003Uoo`03001oogoo00eoo`80011oo`03001o
ogoo00eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Moo`03001oogoo0?moobQoo`00
>Goo00<007ooOol03Goo0P0047oo00<007ooOol03Goo00<007ooOol01Woo00<007ooOol00goo00<0
07ooOol01Woo00<007ooOol0ogoo:Goo000iOol00`00Oomoo`0>Ool00`00Oomoo`0=Ool00`00Ool0
000>Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomoo`3oOolYOol003Uo
o`03001oogoo00ioo`03001oogoo00eoo`03001oo`0000ioo`03001oogoo00Qoo`05001oogooOol0
0007Ool00`00Oomoo`3oOolZOol003Yoo`03001oogoo00eoo`03001oogoo00eoo`03001oo`0000io
o`03001oogoo00Uoo`03001oo`0000Ioo`800?moobeoo`00>Woo00<007ooOol03Goo0P003Woo00<0
07oo00003Goo00<007ooOol02goo0P000goo0`00ogoo;goo000jOol00`00Oomoo`0=Ool00`00Oomo
o`0=Ool01000Oomoo`0037oo00<007ooOol037oo1@00ogoo<Goo000jOol00`00Oomoo`0=Ool2000>
Ool01000Oomoo`0037oo00<007ooOol037oo00<007ooOol0ogoo<goo000jOol00`00Oomoo`0=Ool2
000=Ool01@00Oomoogoo000037oo00<007ooOol02goo00<007ooOol0ogoo=7oo000jOol00`00Oomo
o`0=Ool2000=Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`0;Ool00`00Oomoo`3oOold
Ool003Yoo`03001oogoo00eoo`8000eoo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo00]o
o`03001oogoo0?moocAoo`00>goo00<007ooOol037oo0P003Goo00<007ooOol00Woo00<007ooOol0
27oo00<007ooOol02goo00<007ooOol0ogoo=Goo000kOol00`00Oomoo`0<Ool2000=Ool00`00Oomo
o`03Ool00`00Oomoo`07Ool00`00Oomoo`0;Ool00`00Oomoo`3oOoleOol003]oo`03001oogoo00ao
o`03001oo`0000aoo`03001oogoo00=oo`03001oogoo00Moo`03001oogoo00]oo`03001oogoo0?mo
ocEoo`00>goo00<007ooOol037oo00<007oo00002goo00<007ooOol017oo00<007ooOol01goo00<0
07ooOol02Woo00<007ooOol0ogoo=Woo000kOol00`00Oomoo`0<Ool3000;Ool00`00Oomoo`04Ool0
0`00Oomoo`07Ool00`00Oomoo`0:Ool00`00Oomoo`3oOolfOol003]oo`03001oogoo00aoo`03001o
o`0000]oo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00]oo`03001oogoo0?moocIoo`00
>goo00<007ooOol037oo00<007oo00002goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol0
2goo00<007ooOol0ogoo=Woo000kOol00`00Oomoo`0<Ool01000Oomoo`002Woo00<007ooOol01Goo
00<007ooOol01Goo00<007ooOol02Woo00<007ooOol0ogoo=goo000lOol00`00Oomoo`0;Ool01000
Oomoo`002Woo00<007ooOol01Woo00<007ooOol017oo00<007ooOol02Woo00<007ooOol0ogoo=goo
000lOol00`00Oomoo`0;Ool01000Oomoo`002Goo00<007ooOol01goo00<007ooOol00goo00<007oo
Ool02goo00<007ooOol0ogoo=goo000lOol00`00Oomoo`0;Ool01000Oomoo`002Goo00<007ooOol0
27oo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol0ogoo>7oo000lOol00`00Oomoo`0;Ool0
1@00Oomoogoo000027oo00<007ooOol027oo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol0
ogoo>7oo000lOol00`00Oomoo`0;Ool01@00Oomoogoo000027oo00<007ooOol02Goo00D007ooOomo
o`0000]oo`03001oogoo0?moocUoo`00?7oo00<007ooOol02goo00D007ooOomoo`0000Qoo`03001o
ogoo00Uoo`05001oogooOol0000;Ool00`00Oomoo`3oOoliOol003eoo`03001oogoo00Yoo`80009o
o`03001oogoo00Ioo`03001oogoo00Yoo`03001oo`0000]oo`03001oogoo0?moocYoo`00?Goo00<0
07ooOol02Woo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol02Woo00<007oo00002goo00<0
07ooOol0ogoo>Woo000mOol00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomo
o`0<Ool2000:Ool00`00Oomoo`3oOolkOol003eoo`03001oogoo00Yoo`03001oogoo009oo`03001o
ogoo00Aoo`03001oogoo00aoo`8000Yoo`03001oogoo0?mooc]oo`00?Goo00<007ooOol02Woo00<0
07ooOol00Woo00<007ooOol017oo00<007ooOol037oo0P002Goo00<007ooOol0ogoo?7oo000nOol0
0`00Oomoo`09Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0<Ool00`00Ool00008Ool0
0`00Oomoo`3oOollOol002eoo`@000Ioo`8000Eoo`D000Moo`03001oogoo00=oo`03001oogoo00=o
o`03001oogoo00aoo`03001oo`0000Moo`03001oogoo0?mooceoo`00;7oo00<007ooOol00Woo00<0
07ooOol00goo0P001Goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol037oo00<007ooOol00P000goo0P00ogoo@7oo000/Ool00`00Oomoo`02Ool00`00
Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00
Oomoo`0<Ool01000Oomoogoo1000ogoo@Woo000/Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00
Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`04Ool01@00Oomoogoo00003Woo00<007ooOol0ogoo
B7oo000/Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool01@00Oomoogoo00001Woo0`0017oo00D007oo
Oomoo`0000ioo`03001oogoo0?moodQoo`00;7oo00<007ooOol00Woo00<007ooOol02goo10001goo
00<007ooOol017oo00D007ooOomoo`0000ioo`03001oogoo0?moodQoo`00;7oo00<007ooOol00Woo
00<007ooOol02goo00D007ooOomoo`0000Ioo`03001oogoo00Aoo`05001oogooOol0000>Ool00`00
Oomoo`3oOom8Ool002aoo`03001oogoo009oo`03001oogoo00]oo`05001oogooOol00006Ool00`00
Oomoo`05Ool01000Oomoo`003Goo00<007ooOol0ogooBGoo000/Ool00`00Oomoo`02Ool00`00Oomo
o`0:Ool20003Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Ool0000>Ool00`00Oomoo`3oOom9
Ool002eoo`@000ioo`@000Moo`03001oogoo00Eoo`03001oo`0000ioo`03001oogoo0?moodUoo`00
@7oo00<007ooOol01goo00<007ooOol01Goo00<007oo00003Woo00<007ooOol0ogooBGoo0010Ool0
0`00Oomoo`07Ool00`00Oomoo`06Ool2000=Ool00`00Oomoo`3oOom:Ool0041oo`03001oogoo00Mo
o`03001oogoo00Ioo`03001oogoo00aoo`03001oogoo0?moodYoo`00@Goo00<007ooOol01Woo0P00
1goo00<007ooOol037oo00<007ooOol0ogooBWoo0011Ool00`00Oomoo`06Ool00`00Oomoo`06Ool0
0`00Oomoo`0<Ool00`00Oomoo`3oOom:Ool0045oo`03001oogoo00Ioo`03001oogoo00Ioo`8000ao
o`03001oogoo0?mood]oo`00@Woo00<007ooOol01Goo00<007ooOol01Goo00<007oo000037oo00<0
07ooOol0ogooBgoo0012Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Ool0000;Ool00`00Oomo
o`3oOom<Ool0049oo`03001oogoo00Eoo`03001oogoo00Eoo`04001oogoo000:Ool00`00Oomoo`3o
Oom<Ool0049oo`03001oogoo00Eoo`03001oogoo00Eoo`04001oogoo0009Ool00`00Oomoo`3oOom=
Ool004=oo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo00Ioo`03001o
ogoo0?moodeoo`00@goo00<007ooOol017oo00<007ooOol017oo00<007ooOol00Woo00<007ooOol0
1Goo00<007ooOol0ogooCWoo0013Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`03Ool0
0`00Oomoo`04Ool00`00Oomoo`3oOom>Ool004Aoo`03001oogoo00=oo`8000Eoo`03001oogoo00=o
o`03001oogoo00=oo`03001oogoo0?moodmoo`00A7oo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol01Goo00D007ooOomoo`000?mooe9oo`00A7oo00<007ooOol00goo00<007ooOol00goo00<0
07ooOol01Woo1000ogooDWoo0014Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`3oOomL
Ool004Eoo`03001oogoo009oo`03001oogoo009oo`03001oogoo0?mooeeoo`00AGoo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol0ogooGGoo0016Ool01@00Oomoogoo000017oo00<007ooOol0
ogooGGoo0016Ool01@00Oomoogoo00000goo00<007ooOol0ogooGWoo0017Ool01000Oomoo`000goo
00<007ooOol0ogooGWoo0017Ool01000Oomoo`000Woo00<007ooOol0ogooGgoo0017Ool00`00Oomo
o`03003oOomROol004Qoo`D00?moof9oo`00BGoo0P00ogooI7oo001:Ool00`00Oomoo`3oOomROol0
04Yoo`03001oogoo0?moof9oo`00BWoo00<007ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol0
04Yoo`03001oogoo0?moof9oo`00BWoo00<007ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol0
04Yoo`800?moof=oo`00BWoo00<007ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol004Yoo`03
001oogoo0?moof9oo`00BWoo00<007ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol002eoo`@0
00Ioo`8000Qoo`<000Ioo`03001oogoo0?moof9oo`00;7oo00<007ooOol00Woo00<007ooOol00goo
0P002Goo00<007ooOol01Goo00<007ooOol0ogooHWoo000/Ool00`00Oomoo`02Ool00`00Oomoo`0>
Ool00`00Oomoo`05Ool00`00Oomoo`3oOomROol002aoo`03001oogoo009oo`03001oogoo00Yoo`H0
00Ioo`03001oogoo0?moof9oo`00;7oo00<007ooOol00Woo00<007ooOol02Woo00D007ooOomoo`00
00Moo`<00?moof9oo`00;7oo00<007ooOol00Woo00<007ooOol02goo00@007ooOol000Moo`03001o
ogoo0?moof9oo`00;7oo00<007ooOol00Woo00<007ooOol037oo00<007oo00001goo00<007ooOol0
ogooHWoo000/Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Ool00007Ool00`00Oomoo`3oOomR
Ool002aoo`03001oogoo009oo`03001oogoo00eoo`8000Moo`03001oogoo0?moof9oo`00;Goo1000
4Goo00<007ooOol01Goo00<007ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol004Yoo`03001o
ogoo0?moof9oo`00BWoo00<007ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol004Yoo`800?mo
of=oo`00BWoo00<007ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol004Yoo`03001oogoo0?mo
of9oo`00BWoo00<007ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol004Yoo`03001oogoo0?mo
of9oo`00BWoo00<007ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol004Yoo`800?moof=oo`00
BWoo00<007ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol004Yoo`03001oogoo0?moof9oo`00
BWoo00<007ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol004Yoo`03001oogoo0?moof9oo`00
BWoo00<007ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol004Yoo`03001oogoo0?moof9oo`00
BWoo0P00ogooHgoo001:Ool00`00Oomoo`3oOomROol004Yoo`03001oogoo0?moof9oo`00BWoo00<0
07ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol004Yoo`03001oogoo0?moof9oo`00BWoo00<0
07ooOol0ogooHWoo001:Ool00`00Oomoo`3oOomROol004Yoo`03001oogoo0?moof9oo`00BWoo00<0
07ooOol0ogooHWoo001:Ool2003oOomSOol004Yoo`03001oogoo0?moof9oo`00BWoo00<007ooOol0
ogooHWoo001:Ool00`00Oomoo`3oOomROol004Yoo`03001oogoo0?moof9oo`00BWoo00<007ooOol0
ogooHWoo000]Ool40006Ool20006Ool40007Ool00`00Oomoo`3oOomROol002aoo`03001oogoo009o
o`03001oogoo00=oo`8000Eoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0?moof9oo`00
;7oo00<007ooOol00Woo00<007ooOol03goo00<007ooOol017oo00<007ooOol0ogooHWoo000/Ool0
0`00Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomoo`04Ool00`00Oomoo`3oOomROol002aoo`03001o
ogoo009oo`03001oogoo00moo`03001oogoo00Aoo`<00?moof9oo`00;7oo00<007ooOol00Woo00<0
07ooOol02Woo1@00ogooK7oo000/Ool00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`3oOom^
Ool002aoo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo0?moofioo`00;7oo00<007ooOol0
0Woo00<007ooOol02Woo00<007ooOol0ogooKWoo0000\
\>"],
  ImageRangeCache->{{{0, 429}, {264.625, 0}} -> {-4.50662, -0.0283971, 
  0.0606369, 0.00203131}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot3D[psi[x, t] /. const, {x, \(-3\), 20}, {t, 0, 2}, 
      PlotPoints -> 40, PlotRange -> {0, 0.5}]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
5.55112e-017 1.04977 -0.0679587 1.04977 [
[.10416 .21603 -6 -8.92767 ]
[.10416 .21603 0 .07233 ]
[.23717 .1637 -5.77706 -9 ]
[.23717 .1637 .22294 0 ]
[.37733 .10857 -11.0102 -9 ]
[.37733 .10857 .98977 0 ]
[.52524 .05043 -10.4663 -9 ]
[.52524 .05043 1.53366 0 ]
[.68156 -0.01098 -9.92245 -9 ]
[.68156 -0.01098 2.07755 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 6 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 18 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 18 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02494 .25992 -6 -2.73794 ]
[.02494 .25992 0 6.26206 ]
[.0179 .30404 -18 -2.77522 ]
[.0179 .30404 0 6.22478 ]
[.01066 .34944 -18 -2.81369 ]
[.01066 .34944 0 6.18631 ]
[.0032 .39618 -18 -2.85342 ]
[.0032 .39618 0 6.14658 ]
[-0.00448 .44432 -18 -2.89446 ]
[-0.00448 .44432 0 6.10554 ]
[-0.0124 .49393 -18 -2.93688 ]
[-0.0124 .49393 0 6.06312 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.03716 .25514 m
.68874 0 L
s
.11352 .22524 m
.11819 .22984 L
s
[(0)] .10416 .21603 1 .98393 Mshowa
.24608 .17333 m
.25054 .17814 L
s
[(5)] .23717 .1637 .92569 1 Mshowa
.38574 .11864 m
.38995 .12368 L
s
[(10)] .37733 .10857 .83504 1 Mshowa
.53307 .06095 m
.53699 .06622 L
s
[(15)] .52524 .05043 .74439 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(20)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.13949 .21507 m
.14227 .21785 L
s
.16573 .20479 m
.16848 .20761 L
s
.19224 .19441 m
.19497 .19725 L
s
.21902 .18393 m
.22172 .18679 L
s
.27343 .16262 m
.27607 .16554 L
s
.30106 .1518 m
.30368 .15474 L
s
.32899 .14087 m
.33158 .14383 L
s
.35721 .12981 m
.35977 .13281 L
s
.41457 .10735 m
.41706 .1104 L
s
.44372 .09594 m
.44617 .09902 L
s
.47318 .08441 m
.4756 .08751 L
s
.50296 .07274 m
.50535 .07587 L
s
.56352 .04903 m
.56583 .05222 L
s
.5943 .03698 m
.59658 .04019 L
s
.62543 .02479 m
.62766 .02803 L
s
.6569 .01246 m
.6591 .01573 L
s
.08781 .23531 m
.09064 .23804 L
s
.06236 .24527 m
.06521 .24798 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(0)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(0.5)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(1)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1.5)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03716 .25514 m
.04327 .25274 L
s
[(0)] .02494 .25992 1 -0.39157 Mshowa
.03016 .29934 m
.03628 .29699 L
s
[(0.1)] .0179 .30404 1 -0.38329 Mshowa
.02295 .34483 m
.02909 .34253 L
s
[(0.2)] .01066 .34944 1 -0.37474 Mshowa
.01552 .39167 m
.02169 .38942 L
s
[(0.3)] .0032 .39618 1 -0.36591 Mshowa
.00788 .43991 m
.01406 .43771 L
s
[(0.4)] -0.00448 .44432 1 -0.35679 Mshowa
0 .48963 m
.0062 .48748 L
s
[(0.5)] -0.0124 .49393 1 -0.34736 Mshowa
.125 Mabswid
.03578 .26388 m
.03944 .26245 L
s
.03438 .27267 m
.03805 .27124 L
s
.03298 .28151 m
.03665 .28009 L
s
.03157 .2904 m
.03525 .28898 L
s
.02873 .30833 m
.03241 .30693 L
s
.0273 .31738 m
.03098 .31598 L
s
.02585 .32648 m
.02954 .32509 L
s
.0244 .33563 m
.02809 .33424 L
s
.02148 .35409 m
.02517 .35272 L
s
.02 .3634 m
.02369 .36203 L
s
.01852 .37277 m
.02221 .37141 L
s
.01703 .38219 m
.02072 .38083 L
s
.01401 .40121 m
.01771 .39986 L
s
.01249 .4108 m
.01619 .40946 L
s
.01096 .42044 m
.01467 .41911 L
s
.00943 .43015 m
.01313 .42882 L
s
.00632 .44974 m
.01003 .44842 L
s
.00476 .45962 m
.00847 .45831 L
s
.00318 .46956 m
.00689 .46826 L
s
.00159 .47957 m
.00531 .47827 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.643 .732 .913 r
.39731 .59592 .40513 .60336 .41825 .6001 .41046 .59264 Metetra
.641 .732 .915 r
.41046 .59264 .41825 .6001 .43144 .59688 .42369 .58943 Metetra
.639 .732 .916 r
.42369 .58943 .43144 .59688 .44469 .59371 .43698 .58627 Metetra
.636 .733 .918 r
.43698 .58627 .44469 .59371 .45802 .59059 .45034 .58316 Metetra
.634 .734 .92 r
.45034 .58316 .45802 .59059 .47141 .5875 .46378 .58011 Metetra
.632 .735 .922 r
.46378 .58011 .47141 .5875 .48488 .58445 .47729 .5771 Metetra
.63 .736 .924 r
.47729 .5771 .48488 .58445 .49843 .58143 .49087 .57413 Metetra
.628 .738 .927 r
.49087 .57413 .49843 .58143 .51205 .57842 .50454 .57118 Metetra
.626 .74 .929 r
.50454 .57118 .51205 .57842 .52575 .57542 .51828 .56824 Metetra
.625 .742 .931 r
.51828 .56824 .52575 .57542 .53952 .57242 .53209 .5653 Metetra
.625 .745 .933 r
.53209 .5653 .53952 .57242 .55337 .56939 .54599 .56234 Metetra
.625 .748 .935 r
.54599 .56234 .55337 .56939 .5673 .56633 .55997 .55935 Metetra
.625 .751 .937 r
.55997 .55935 .5673 .56633 .58131 .56321 .57403 .55629 Metetra
.627 .754 .939 r
.57403 .55629 .58131 .56321 .5954 .56003 .58817 .55316 Metetra
.629 .757 .94 r
.58817 .55316 .5954 .56003 .60957 .55676 .60239 .54993 Metetra
.632 .761 .94 r
.60239 .54993 .60957 .55676 .62381 .55338 .61668 .54657 Metetra
.635 .764 .94 r
.61668 .54657 .62381 .55338 .63813 .54988 .63106 .54308 Metetra
.639 .766 .94 r
.63106 .54308 .63813 .54988 .65252 .54625 .64551 .53944 Metetra
.644 .768 .939 r
.64551 .53944 .65252 .54625 .66699 .54247 .66003 .53563 Metetra
.649 .77 .937 r
.66003 .53563 .66699 .54247 .68154 .53853 .67463 .53163 Metetra
.654 .771 .935 r
.67463 .53163 .68154 .53853 .69615 .53443 .6893 .52745 Metetra
.659 .772 .933 r
.6893 .52745 .69615 .53443 .71083 .53016 .70403 .52307 Metetra
.664 .771 .929 r
.70403 .52307 .71083 .53016 .72558 .52571 .71884 .5185 Metetra
.669 .771 .926 r
.71884 .5185 .72558 .52571 .7404 .52109 .7337 .51373 Metetra
.674 .769 .922 r
.7337 .51373 .7404 .52109 .75528 .51629 .74864 .50877 Metetra
.678 .767 .918 r
.74864 .50877 .75528 .51629 .77023 .51134 .76363 .50364 Metetra
.682 .765 .914 r
.76363 .50364 .77023 .51134 .78524 .50623 .77869 .49835 Metetra
.685 .762 .91 r
.77869 .49835 .78524 .50623 .80031 .50098 .79381 .4929 Metetra
.687 .759 .906 r
.79381 .4929 .80031 .50098 .81545 .4956 .809 .48732 Metetra
.689 .756 .903 r
.809 .48732 .81545 .4956 .83065 .49011 .82424 .48163 Metetra
.69 .752 .899 r
.82424 .48163 .83065 .49011 .84592 .48452 .83955 .47585 Metetra
.691 .749 .896 r
.83955 .47585 .84592 .48452 .86125 .47884 .85493 .46999 Metetra
.691 .746 .893 r
.85493 .46999 .86125 .47884 .87665 .47311 .87038 .46408 Metetra
.691 .743 .891 r
.87038 .46408 .87665 .47311 .89211 .46732 .88589 .45813 Metetra
.691 .74 .889 r
.88589 .45813 .89211 .46732 .90765 .4615 .90148 .45217 Metetra
.69 .738 .887 r
.90148 .45217 .90765 .4615 .92327 .45567 .91715 .44621 Metetra
.689 .735 .886 r
.91715 .44621 .92327 .45567 .93896 .44983 .93289 .44026 Metetra
.688 .734 .886 r
.93289 .44026 .93896 .44983 .95472 .444 .94871 .43434 Metetra
.686 .732 .885 r
.94871 .43434 .95472 .444 .97057 .43818 .96462 .42845 Metetra
.643 .731 .913 r
.38941 .58839 .39731 .59592 .41046 .59264 .40261 .58511 Metetra
.64 .731 .915 r
.40261 .58511 .41046 .59264 .42369 .58943 .41587 .58189 Metetra
.637 .732 .916 r
.41587 .58189 .42369 .58943 .43698 .58627 .4292 .57874 Metetra
.634 .732 .918 r
.4292 .57874 .43698 .58627 .45034 .58316 .4426 .57566 Metetra
.632 .733 .921 r
.4426 .57566 .45034 .58316 .46378 .58011 .45607 .57264 Metetra
.629 .734 .923 r
.45607 .57264 .46378 .58011 .47729 .5771 .46962 .56968 Metetra
.627 .735 .925 r
.46962 .56968 .47729 .5771 .49087 .57413 .48325 .56676 Metetra
.624 .737 .928 r
.48325 .56676 .49087 .57413 .50454 .57118 .49695 .56388 Metetra
.623 .739 .93 r
.49695 .56388 .50454 .57118 .51828 .56824 .51073 .56102 Metetra
.621 .742 .933 r
.51073 .56102 .51828 .56824 .53209 .5653 .5246 .55816 Metetra
.621 .745 .935 r
.5246 .55816 .53209 .5653 .54599 .56234 .53854 .55528 Metetra
.621 .748 .938 r
.53854 .55528 .54599 .56234 .55997 .55935 .55257 .55236 Metetra
.621 .752 .94 r
.55257 .55236 .55997 .55935 .57403 .55629 .56668 .54937 Metetra
.623 .755 .941 r
.56668 .54937 .57403 .55629 .58817 .55316 .58087 .5463 Metetra
.626 .759 .942 r
.58087 .5463 .58817 .55316 .60239 .54993 .59514 .54311 Metetra
.629 .762 .943 r
.59514 .54311 .60239 .54993 .61668 .54657 .60949 .53979 Metetra
.633 .765 .943 r
.60949 .53979 .61668 .54657 .63106 .54308 .62391 .53631 Metetra
.638 .768 .942 r
.62391 .53631 .63106 .54308 .64551 .53944 .63842 .53265 Metetra
.643 .771 .941 r
.63842 .53265 .64551 .53944 .66003 .53563 .653 .52879 Metetra
.649 .772 .939 r
.653 .52879 .66003 .53563 .67463 .53163 .66765 .52472 Metetra
.655 .773 .936 r
.66765 .52472 .67463 .53163 .6893 .52745 .68237 .52044 Metetra
.661 .774 .933 r
.68237 .52044 .6893 .52745 .70403 .52307 .69716 .51594 Metetra
.667 .773 .929 r
.69716 .51594 .70403 .52307 .71884 .5185 .71202 .51122 Metetra
.673 .772 .925 r
.71202 .51122 .71884 .5185 .7337 .51373 .72694 .50628 Metetra
.678 .77 .92 r
.72694 .50628 .7337 .51373 .74864 .50877 .74192 .50113 Metetra
.682 .767 .916 r
.74192 .50113 .74864 .50877 .76363 .50364 .75697 .4958 Metetra
.686 .764 .911 r
.75697 .4958 .76363 .50364 .77869 .49835 .77207 .49029 Metetra
.689 .761 .907 r
.77207 .49029 .77869 .49835 .79381 .4929 .78724 .48462 Metetra
.691 .757 .903 r
.78724 .48462 .79381 .4929 .809 .48732 .80247 .47883 Metetra
.692 .754 .899 r
.80247 .47883 .809 .48732 .82424 .48163 .81776 .47293 Metetra
.693 .75 .895 r
.81776 .47293 .82424 .48163 .83955 .47585 .83312 .46694 Metetra
.694 .746 .892 r
.83312 .46694 .83955 .47585 .85493 .46999 .84854 .46089 Metetra
.694 .743 .889 r
.84854 .46089 .85493 .46999 .87038 .46408 .86403 .45481 Metetra
.693 .74 .887 r
.86403 .45481 .87038 .46408 .88589 .45813 .8796 .44871 Metetra
.692 .737 .886 r
.8796 .44871 .88589 .45813 .90148 .45217 .89524 .44261 Metetra
.691 .735 .884 r
.89524 .44261 .90148 .45217 .91715 .44621 .91095 .43654 Metetra
.689 .733 .884 r
.91095 .43654 .91715 .44621 .93289 .44026 .92675 .43049 Metetra
.688 .731 .883 r
.92675 .43049 .93289 .44026 .94871 .43434 .94263 .4245 Metetra
.686 .73 .884 r
.94263 .4245 .94871 .43434 .96462 .42845 .9586 .41855 Metetra
.642 .731 .913 r
.38145 .58078 .38941 .58839 .40261 .58511 .39468 .57749 Metetra
.639 .731 .915 r
.39468 .57749 .40261 .58511 .41587 .58189 .40797 .57427 Metetra
.636 .731 .917 r
.40797 .57427 .41587 .58189 .4292 .57874 .42134 .57114 Metetra
.633 .731 .919 r
.42134 .57114 .4292 .57874 .4426 .57566 .43478 .56808 Metetra
.629 .732 .921 r
.43478 .56808 .4426 .57566 .45607 .57264 .44829 .5651 Metetra
.626 .733 .924 r
.44829 .5651 .45607 .57264 .46962 .56968 .46188 .56219 Metetra
.623 .734 .926 r
.46188 .56219 .46962 .56968 .48325 .56676 .47555 .55934 Metetra
.621 .736 .929 r
.47555 .55934 .48325 .56676 .49695 .56388 .48929 .55654 Metetra
.618 .739 .932 r
.48929 .55654 .49695 .56388 .51073 .56102 .50312 .55376 Metetra
.617 .741 .935 r
.50312 .55376 .51073 .56102 .5246 .55816 .51703 .55099 Metetra
.616 .745 .938 r
.51703 .55099 .5246 .55816 .53854 .55528 .53102 .5482 Metetra
.616 .748 .94 r
.53102 .5482 .53854 .55528 .55257 .55236 .54509 .54537 Metetra
.617 .752 .942 r
.54509 .54537 .55257 .55236 .56668 .54937 .55925 .54247 Metetra
.619 .756 .944 r
.55925 .54247 .56668 .54937 .58087 .5463 .57349 .53946 Metetra
.622 .76 .945 r
.57349 .53946 .58087 .5463 .59514 .54311 .58781 .53633 Metetra
.626 .764 .945 r
.58781 .53633 .59514 .54311 .60949 .53979 .60222 .53303 Metetra
.631 .768 .945 r
.60222 .53303 .60949 .53979 .62391 .53631 .6167 .52955 Metetra
.637 .771 .944 r
.6167 .52955 .62391 .53631 .63842 .53265 .63126 .52587 Metetra
.643 .773 .942 r
.63126 .52587 .63842 .53265 .653 .52879 .6459 .52196 Metetra
.65 .775 .94 r
.6459 .52196 .653 .52879 .66765 .52472 .6606 .5178 Metetra
.657 .776 .936 r
.6606 .5178 .66765 .52472 .68237 .52044 .67538 .5134 Metetra
.664 .776 .932 r
.67538 .5134 .68237 .52044 .69716 .51594 .69022 .50875 Metetra
.671 .775 .928 r
.69022 .50875 .69716 .51594 .71202 .51122 .70513 .50385 Metetra
.677 .773 .923 r
.70513 .50385 .71202 .51122 .72694 .50628 .7201 .49871 Metetra
.682 .77 .918 r
.7201 .49871 .72694 .50628 .74192 .50113 .73513 .49334 Metetra
.687 .767 .913 r
.73513 .49334 .74192 .50113 .75697 .4958 .75023 .48778 Metetra
.69 .763 .908 r
.75023 .48778 .75697 .4958 .77207 .49029 .76538 .48203 Metetra
.693 .759 .903 r
.76538 .48203 .77207 .49029 .78724 .48462 .78059 .47612 Metetra
.695 .755 .898 r
.78059 .47612 .78724 .48462 .80247 .47883 .79586 .4701 Metetra
.696 .751 .894 r
.79586 .4701 .80247 .47883 .81776 .47293 .8112 .46397 Metetra
.696 .747 .891 r
.8112 .46397 .81776 .47293 .83312 .46694 .8266 .45777 Metetra
.696 .743 .888 r
.8266 .45777 .83312 .46694 .84854 .46089 .84207 .45154 Metetra
.696 .74 .885 r
.84207 .45154 .84854 .46089 .86403 .45481 .85761 .44528 Metetra
.694 .737 .883 r
.85761 .44528 .86403 .45481 .8796 .44871 .87323 .43904 Metetra
.693 .734 .882 r
.87323 .43904 .8796 .44871 .89524 .44261 .88892 .43282 Metetra
.691 .732 .882 r
.88892 .43282 .89524 .44261 .91095 .43654 .90469 .42665 Metetra
.69 .73 .881 r
.90469 .42665 .91095 .43654 .92675 .43049 .92054 .42053 Metetra
.688 .729 .882 r
.92054 .42053 .92675 .43049 .94263 .4245 .93648 .41448 Metetra
.686 .728 .882 r
.93648 .41448 .94263 .4245 .9586 .41855 .95251 .4085 Metetra
.641 .73 .913 r
.37341 .5731 .38145 .58078 .39468 .57749 .38668 .56979 Metetra
.638 .73 .915 r
.38668 .56979 .39468 .57749 .40797 .57427 .40001 .56657 Metetra
.634 .73 .917 r
.40001 .56657 .40797 .57427 .42134 .57114 .41342 .56345 Metetra
.631 .73 .919 r
.41342 .56345 .42134 .57114 .43478 .56808 .42689 .56042 Metetra
.627 .731 .922 r
.42689 .56042 .43478 .56808 .44829 .5651 .44044 .55748 Metetra
.623 .732 .925 r
.44044 .55748 .44829 .5651 .46188 .56219 .45407 .55463 Metetra
.62 .733 .928 r
.45407 .55463 .46188 .56219 .47555 .55934 .46778 .55186 Metetra
.616 .735 .931 r
.46778 .55186 .47555 .55934 .48929 .55654 .48156 .54914 Metetra
.614 .738 .934 r
.48156 .54914 .48929 .55654 .50312 .55376 .49543 .54646 Metetra
.612 .741 .937 r
.49543 .54646 .50312 .55376 .51703 .55099 .50938 .5438 Metetra
.611 .744 .94 r
.50938 .5438 .51703 .55099 .53102 .5482 .52342 .54112 Metetra
.61 .748 .943 r
.52342 .54112 .53102 .5482 .54509 .54537 .53754 .53839 Metetra
.612 .753 .945 r
.53754 .53839 .54509 .54537 .55925 .54247 .55175 .53558 Metetra
.614 .757 .947 r
.55175 .53558 .55925 .54247 .57349 .53946 .56604 .53266 Metetra
.618 .762 .948 r
.56604 .53266 .57349 .53946 .58781 .53633 .58042 .52958 Metetra
.623 .766 .948 r
.58042 .52958 .58781 .53633 .60222 .53303 .59488 .52631 Metetra
.629 .77 .948 r
.59488 .52631 .60222 .53303 .6167 .52955 .60942 .52283 Metetra
.636 .774 .946 r
.60942 .52283 .6167 .52955 .63126 .52587 .62403 .51911 Metetra
.644 .776 .944 r
.62403 .51911 .63126 .52587 .6459 .52196 .63872 .51513 Metetra
.652 .778 .94 r
.63872 .51513 .6459 .52196 .6606 .5178 .65349 .51086 Metetra
.66 .778 .936 r
.65349 .51086 .6606 .5178 .67538 .5134 .66832 .50631 Metetra
.668 .778 .931 r
.66832 .50631 .67538 .5134 .69022 .50875 .68321 .50148 Metetra
.675 .776 .926 r
.68321 .50148 .69022 .50875 .70513 .50385 .69817 .49637 Metetra
.682 .773 .92 r
.69817 .49637 .70513 .50385 .7201 .49871 .71319 .49099 Metetra
.687 .77 .914 r
.71319 .49099 .7201 .49871 .73513 .49334 .72827 .48538 Metetra
.692 .766 .909 r
.72827 .48538 .73513 .49334 .75023 .48778 .74341 .47955 Metetra
.695 .762 .903 r
.74341 .47955 .75023 .48778 .76538 .48203 .75861 .47353 Metetra
.697 .757 .898 r
.75861 .47353 .76538 .48203 .78059 .47612 .77386 .46737 Metetra
.699 .752 .893 r
.77386 .46737 .78059 .47612 .79586 .4701 .78918 .46109 Metetra
.699 .748 .889 r
.78918 .46109 .79586 .4701 .8112 .46397 .80456 .45473 Metetra
.699 .744 .886 r
.80456 .45473 .8112 .46397 .8266 .45777 .82001 .44833 Metetra
.698 .74 .883 r
.82001 .44833 .8266 .45777 .84207 .45154 .83552 .44191 Metetra
.697 .736 .881 r
.83552 .44191 .84207 .45154 .85761 .44528 .85111 .4355 Metetra
.695 .733 .88 r
.85111 .4355 .85761 .44528 .87323 .43904 .86678 .42913 Metetra
.694 .731 .879 r
.86678 .42913 .87323 .43904 .88892 .43282 .88252 .42281 Metetra
.691 .729 .879 r
.88252 .42281 .88892 .43282 .90469 .42665 .89835 .41657 Metetra
.689 .728 .88 r
.89835 .41657 .90469 .42665 .92054 .42053 .91426 .4104 Metetra
.687 .727 .881 r
.91426 .4104 .92054 .42053 .93648 .41448 .93027 .40433 Metetra
.685 .726 .882 r
.93027 .40433 .93648 .41448 .95251 .4085 .94636 .39834 Metetra
.641 .73 .913 r
.3653 .56533 .37341 .5731 .38668 .56979 .3786 .562 Metetra
.637 .729 .915 r
.3786 .562 .38668 .56979 .40001 .56657 .39198 .55878 Metetra
.633 .729 .917 r
.39198 .55878 .40001 .56657 .41342 .56345 .40542 .55567 Metetra
.629 .729 .92 r
.40542 .55567 .41342 .56345 .42689 .56042 .41893 .55267 Metetra
.624 .729 .922 r
.41893 .55267 .42689 .56042 .44044 .55748 .43252 .54979 Metetra
.62 .73 .926 r
.43252 .54979 .44044 .55748 .45407 .55463 .44619 .54701 Metetra
.615 .732 .929 r
.44619 .54701 .45407 .55463 .46778 .55186 .45993 .54432 Metetra
.612 .734 .932 r
.45993 .54432 .46778 .55186 .48156 .54914 .47376 .5417 Metetra
.608 .737 .936 r
.47376 .5417 .48156 .54914 .49543 .54646 .48767 .53914 Metetra
.606 .74 .94 r
.48767 .53914 .49543 .54646 .50938 .5438 .50166 .5366 Metetra
.604 .744 .943 r
.50166 .5366 .50938 .5438 .52342 .54112 .51575 .53404 Metetra
.604 .748 .946 r
.51575 .53404 .52342 .54112 .53754 .53839 .52992 .53143 Metetra
.605 .753 .949 r
.52992 .53143 .53754 .53839 .55175 .53558 .54417 .52873 Metetra
.608 .758 .95 r
.54417 .52873 .55175 .53558 .56604 .53266 .55852 .52589 Metetra
.613 .764 .951 r
.55852 .52589 .56604 .53266 .58042 .52958 .57295 .52288 Metetra
.619 .769 .951 r
.57295 .52288 .58042 .52958 .59488 .52631 .58746 .51964 Metetra
.627 .773 .95 r
.58746 .51964 .59488 .52631 .60942 .52283 .60206 .51615 Metetra
.636 .777 .948 r
.60206 .51615 .60942 .52283 .62403 .51911 .61673 .51238 Metetra
.645 .779 .945 r
.61673 .51238 .62403 .51911 .63872 .51513 .63148 .5083 Metetra
.655 .781 .941 r
.63148 .5083 .63872 .51513 .65349 .51086 .64629 .50389 Metetra
.664 .781 .936 r
.64629 .50389 .65349 .51086 .66832 .50631 .66118 .49916 Metetra
.673 .779 .93 r
.66118 .49916 .66832 .50631 .68321 .50148 .67613 .49411 Metetra
.681 .777 .923 r
.67613 .49411 .68321 .50148 .69817 .49637 .69114 .48874 Metetra
.688 .773 .917 r
.69114 .48874 .69817 .49637 .71319 .49099 .7062 .4831 Metetra
.693 .769 .91 r
.7062 .4831 .71319 .49099 .72827 .48538 .72133 .47719 Metetra
.697 .764 .904 r
.72133 .47719 .72827 .48538 .74341 .47955 .73651 .47107 Metetra
.7 .759 .898 r
.73651 .47107 .74341 .47955 .75861 .47353 .75175 .46476 Metetra
.702 .754 .892 r
.75175 .46476 .75861 .47353 .77386 .46737 .76705 .45832 Metetra
.702 .749 .888 r
.76705 .45832 .77386 .46737 .78918 .46109 .78241 .45179 Metetra
.702 .744 .884 r
.78241 .45179 .78918 .46109 .80456 .45473 .79784 .4452 Metetra
.701 .74 .881 r
.79784 .4452 .80456 .45473 .82001 .44833 .81333 .43859 Metetra
.7 .736 .879 r
.81333 .43859 .82001 .44833 .83552 .44191 .8289 .432 Metetra
.698 .733 .877 r
.8289 .432 .83552 .44191 .85111 .4355 .84453 .42546 Metetra
.696 .73 .877 r
.84453 .42546 .85111 .4355 .86678 .42913 .86025 .41898 Metetra
.693 .728 .877 r
.86025 .41898 .86678 .42913 .88252 .42281 .87605 .4126 Metetra
.691 .727 .877 r
.87605 .4126 .88252 .42281 .89835 .41657 .89194 .40631 Metetra
.688 .726 .879 r
.89194 .40631 .89835 .41657 .91426 .4104 .90792 .40013 Metetra
.686 .725 .88 r
.90792 .40013 .91426 .4104 .93027 .40433 .92399 .39405 Metetra
.683 .725 .882 r
.92399 .39405 .93027 .40433 .94636 .39834 .94016 .38808 Metetra
.64 .73 .913 r
.35711 .55748 .3653 .56533 .3786 .562 .37046 .55413 Metetra
.636 .729 .915 r
.37046 .55413 .3786 .562 .39198 .55878 .38387 .5509 Metetra
.631 .728 .917 r
.38387 .5509 .39198 .55878 .40542 .55567 .39735 .54781 Metetra
.626 .728 .92 r
.39735 .54781 .40542 .55567 .41893 .55267 .4109 .54484 Metetra
.621 .728 .923 r
.4109 .54484 .41893 .55267 .43252 .54979 .42452 .54201 Metetra
.616 .729 .927 r
.42452 .54201 .43252 .54979 .44619 .54701 .43823 .53931 Metetra
.611 .73 .93 r
.43823 .53931 .44619 .54701 .45993 .54432 .45201 .53672 Metetra
.606 .733 .934 r
.45201 .53672 .45993 .54432 .47376 .5417 .46588 .53422 Metetra
.602 .735 .938 r
.46588 .53422 .47376 .5417 .48767 .53914 .47983 .53179 Metetra
.599 .739 .942 r
.47983 .53179 .48767 .53914 .50166 .5366 .49387 .52939 Metetra
.597 .743 .946 r
.49387 .52939 .50166 .5366 .51575 .53404 .50799 .52698 Metetra
.597 .748 .95 r
.50799 .52698 .51575 .53404 .52992 .53143 .52221 .52451 Metetra
.599 .754 .952 r
.52221 .52451 .52992 .53143 .54417 .52873 .53652 .52193 Metetra
.602 .76 .954 r
.53652 .52193 .54417 .52873 .55852 .52589 .55092 .51919 Metetra
.608 .766 .955 r
.55092 .51919 .55852 .52589 .57295 .52288 .5654 .51624 Metetra
.616 .771 .955 r
.5654 .51624 .57295 .52288 .58746 .51964 .57997 .51303 Metetra
.625 .776 .953 r
.57997 .51303 .58746 .51964 .60206 .51615 .59462 .50951 Metetra
.636 .78 .95 r
.59462 .50951 .60206 .51615 .61673 .51238 .60935 .50567 Metetra
.647 .783 .946 r
.60935 .50567 .61673 .51238 .63148 .5083 .62415 .50146 Metetra
.659 .784 .941 r
.62415 .50146 .63148 .5083 .64629 .50389 .63903 .49688 Metetra
.669 .783 .934 r
.63903 .49688 .64629 .50389 .66118 .49916 .65396 .49192 Metetra
.679 .781 .927 r
.65396 .49192 .66118 .49916 .67613 .49411 .66896 .4866 Metetra
.687 .777 .92 r
.66896 .4866 .67613 .49411 .69114 .48874 .68402 .48094 Metetra
.694 .773 .912 r
.68402 .48094 .69114 .48874 .7062 .4831 .69914 .47498 Metetra
.699 .767 .905 r
.69914 .47498 .7062 .4831 .72133 .47719 .71431 .46875 Metetra
.703 .762 .898 r
.71431 .46875 .72133 .47719 .73651 .47107 .72953 .4623 Metetra
.705 .756 .892 r
.72953 .4623 .73651 .47107 .75175 .46476 .74482 .45568 Metetra
.706 .75 .886 r
.74482 .45568 .75175 .46476 .76705 .45832 .76016 .44895 Metetra
.706 .745 .882 r
.76016 .44895 .76705 .45832 .78241 .45179 .77556 .44216 Metetra
.705 .74 .878 r
.77556 .44216 .78241 .45179 .79784 .4452 .79103 .43534 Metetra
.703 .735 .876 r
.79103 .43534 .79784 .4452 .81333 .43859 .80657 .42855 Metetra
.701 .732 .874 r
.80657 .42855 .81333 .43859 .8289 .432 .82219 .42182 Metetra
.699 .729 .874 r
.82219 .42182 .8289 .432 .84453 .42546 .83788 .41517 Metetra
.696 .727 .874 r
.83788 .41517 .84453 .42546 .86025 .41898 .85366 .40863 Metetra
.693 .725 .875 r
.85366 .40863 .86025 .41898 .87605 .4126 .86952 .40221 Metetra
.69 .724 .876 r
.86952 .40221 .87605 .4126 .89194 .40631 .88547 .39591 Metetra
.687 .724 .878 r
.88547 .39591 .89194 .40631 .90792 .40013 .90152 .38975 Metetra
.684 .724 .881 r
.90152 .38975 .90792 .40013 .92399 .39405 .91766 .3837 Metetra
.681 .725 .883 r
.91766 .3837 .92399 .39405 .94016 .38808 .9339 .37778 Metetra
.64 .729 .913 r
.34886 .54955 .35711 .55748 .37046 .55413 .36224 .54618 Metetra
.635 .728 .915 r
.36224 .54618 .37046 .55413 .38387 .5509 .37568 .54294 Metetra
.63 .727 .918 r
.37568 .54294 .38387 .5509 .39735 .54781 .3892 .53986 Metetra
.624 .727 .921 r
.3892 .53986 .39735 .54781 .4109 .54484 .40279 .53693 Metetra
.618 .727 .924 r
.40279 .53693 .4109 .54484 .42452 .54201 .41645 .53416 Metetra
.612 .728 .928 r
.41645 .53416 .42452 .54201 .43823 .53931 .43019 .53154 Metetra
.606 .729 .932 r
.43019 .53154 .43823 .53931 .45201 .53672 .44401 .52907 Metetra
.6 .731 .936 r
.44401 .52907 .45201 .53672 .46588 .53422 .45792 .5267 Metetra
.595 .734 .941 r
.45792 .5267 .46588 .53422 .47983 .53179 .47191 .52443 Metetra
.591 .738 .946 r
.47191 .52443 .47983 .53179 .49387 .52939 .48599 .52219 Metetra
.589 .743 .95 r
.48599 .52219 .49387 .52939 .50799 .52698 .50016 .51994 Metetra
.588 .748 .953 r
.50016 .51994 .50799 .52698 .52221 .52451 .51443 .51763 Metetra
.59 .755 .956 r
.51443 .51763 .52221 .52451 .53652 .52193 .52878 .51519 Metetra
.595 .761 .958 r
.52878 .51519 .53652 .52193 .55092 .51919 .54323 .51256 Metetra
.603 .768 .959 r
.54323 .51256 .55092 .51919 .5654 .51624 .55777 .50967 Metetra
.613 .775 .958 r
.55777 .50967 .5654 .51624 .57997 .51303 .5724 .50648 Metetra
.624 .78 .956 r
.5724 .50648 .57997 .51303 .59462 .50951 .58711 .50292 Metetra
.637 .784 .952 r
.58711 .50292 .59462 .50951 .60935 .50567 .60189 .49897 Metetra
.651 .786 .946 r
.60189 .49897 .60935 .50567 .62415 .50146 .61675 .4946 Metetra
.664 .787 .94 r
.61675 .4946 .62415 .50146 .63903 .49688 .63168 .48979 Metetra
.676 .785 .932 r
.63168 .48979 .63903 .49688 .65396 .49192 .64667 .48456 Metetra
.686 .782 .923 r
.64667 .48456 .65396 .49192 .66896 .4866 .66172 .47892 Metetra
.695 .777 .915 r
.66172 .47892 .66896 .4866 .68402 .48094 .67683 .47292 Metetra
.701 .771 .906 r
.67683 .47292 .68402 .48094 .69914 .47498 .69199 .46659 Metetra
.706 .765 .898 r
.69199 .46659 .69914 .47498 .71431 .46875 .7072 .46 Metetra
.709 .758 .891 r
.7072 .46 .71431 .46875 .72953 .4623 .72247 .45319 Metetra
.71 .751 .885 r
.72247 .45319 .72953 .4623 .74482 .45568 .7378 .44625 Metetra
.71 .745 .88 r
.7378 .44625 .74482 .45568 .76016 .44895 .75318 .43923 Metetra
.709 .74 .876 r
.75318 .43923 .76016 .44895 .77556 .44216 .76863 .43218 Metetra
.707 .735 .873 r
.76863 .43218 .77556 .44216 .79103 .43534 .78415 .42516 Metetra
.704 .731 .871 r
.78415 .42516 .79103 .43534 .80657 .42855 .79974 .41822 Metetra
.701 .728 .871 r
.79974 .41822 .80657 .42855 .82219 .42182 .8154 .41137 Metetra
.698 .725 .871 r
.8154 .41137 .82219 .42182 .83788 .41517 .83115 .40466 Metetra
.695 .724 .872 r
.83115 .40466 .83788 .41517 .85366 .40863 .84699 .3981 Metetra
.691 .723 .874 r
.84699 .3981 .85366 .40863 .86952 .40221 .86292 .39168 Metetra
.688 .723 .876 r
.86292 .39168 .86952 .40221 .88547 .39591 .87894 .38542 Metetra
.685 .723 .879 r
.87894 .38542 .88547 .39591 .90152 .38975 .89506 .3793 Metetra
.682 .724 .882 r
.89506 .3793 .90152 .38975 .91766 .3837 .91128 .37332 Metetra
.679 .725 .885 r
.91128 .37332 .91766 .3837 .9339 .37778 .92759 .36745 Metetra
.64 .729 .913 r
.34052 .54154 .34886 .54955 .36224 .54618 .35394 .53814 Metetra
.634 .728 .915 r
.35394 .53814 .36224 .54618 .37568 .54294 .36742 .53489 Metetra
.628 .727 .918 r
.36742 .53489 .37568 .54294 .3892 .53986 .38098 .53182 Metetra
.622 .726 .921 r
.38098 .53182 .3892 .53986 .40279 .53693 .3946 .52893 Metetra
.615 .726 .925 r
.3946 .52893 .40279 .53693 .41645 .53416 .4083 .52623 Metetra
.607 .726 .929 r
.4083 .52623 .41645 .53416 .43019 .53154 .42208 .52371 Metetra
.6 .727 .934 r
.42208 .52371 .43019 .53154 .44401 .52907 .43594 .52136 Metetra
.593 .729 .939 r
.43594 .52136 .44401 .52907 .45792 .5267 .44988 .51915 Metetra
.586 .732 .944 r
.44988 .51915 .45792 .5267 .47191 .52443 .46391 .51705 Metetra
.582 .736 .949 r
.46391 .51705 .47191 .52443 .48599 .52219 .47803 .515 Metetra
.579 .742 .954 r
.47803 .515 .48599 .52219 .50016 .51994 .49225 .51295 Metetra
.578 .748 .958 r
.49225 .51295 .50016 .51994 .51443 .51763 .50656 .51081 Metetra
.581 .755 .961 r
.50656 .51081 .51443 .51763 .52878 .51519 .52097 .50853 Metetra
.587 .763 .963 r
.52097 .50853 .52878 .51519 .54323 .51256 .53547 .50601 Metetra
.597 .771 .963 r
.53547 .50601 .54323 .51256 .55777 .50967 .55006 .50319 Metetra
.609 .778 .962 r
.55006 .50319 .55777 .50967 .5724 .50648 .56475 .5 Metetra
.624 .784 .958 r
.56475 .5 .5724 .50648 .58711 .50292 .57951 .49638 Metetra
.64 .788 .953 r
.57951 .49638 .58711 .50292 .60189 .49897 .59436 .49228 Metetra
.656 .79 .946 r
.59436 .49228 .60189 .49897 .61675 .4946 .60927 .48769 Metetra
.671 .789 .938 r
.60927 .48769 .61675 .4946 .63168 .48979 .62426 .4826 Metetra
.684 .786 .928 r
.62426 .4826 .63168 .48979 .64667 .48456 .6393 .47703 Metetra
.694 .782 .918 r
.6393 .47703 .64667 .48456 .66172 .47892 .6544 .47102 Metetra
.703 .775 .908 r
.6544 .47102 .66172 .47892 .67683 .47292 .66955 .46461 Metetra
.709 .768 .899 r
.66955 .46461 .67683 .47292 .69199 .46659 .68476 .45787 Metetra
.712 .761 .89 r
.68476 .45787 .69199 .46659 .7072 .46 .70001 .45088 Metetra
.714 .753 .883 r
.70001 .45088 .7072 .46 .72247 .45319 .71532 .44371 Metetra
.714 .746 .877 r
.71532 .44371 .72247 .45319 .7378 .44625 .73069 .43643 Metetra
.713 .74 .873 r
.73069 .43643 .7378 .44625 .75318 .43923 .74612 .42913 Metetra
.711 .734 .87 r
.74612 .42913 .75318 .43923 .76863 .43218 .76161 .42185 Metetra
.708 .73 .868 r
.76161 .42185 .76863 .43218 .78415 .42516 .77718 .41467 Metetra
.704 .726 .867 r
.77718 .41467 .78415 .42516 .79974 .41822 .79282 .40761 Metetra
.701 .724 .868 r
.79282 .40761 .79974 .41822 .8154 .41137 .80854 .40071 Metetra
.697 .722 .869 r
.80854 .40071 .8154 .41137 .83115 .40466 .82435 .39398 Metetra
.693 .722 .872 r
.82435 .39398 .83115 .40466 .84699 .3981 .84026 .38743 Metetra
.689 .722 .874 r
.84026 .38743 .84699 .3981 .86292 .39168 .85625 .38107 Metetra
.686 .722 .877 r
.85625 .38107 .86292 .39168 .87894 .38542 .87235 .37487 Metetra
.682 .723 .881 r
.87235 .37487 .87894 .38542 .89506 .3793 .88854 .36883 Metetra
.679 .725 .884 r
.88854 .36883 .89506 .3793 .91128 .37332 .90484 .36293 Metetra
.676 .727 .888 r
.90484 .36293 .91128 .37332 .92759 .36745 .92124 .35714 Metetra
.64 .729 .913 r
.33211 .53345 .34052 .54154 .35394 .53814 .34557 .53001 Metetra
.634 .727 .915 r
.34557 .53001 .35394 .53814 .36742 .53489 .35909 .52675 Metetra
.627 .726 .918 r
.35909 .52675 .36742 .53489 .38098 .53182 .37268 .52369 Metetra
.619 .725 .922 r
.37268 .52369 .38098 .53182 .3946 .52893 .38634 .52084 Metetra
.611 .724 .926 r
.38634 .52084 .3946 .52893 .4083 .52623 .40007 .51821 Metetra
.602 .724 .931 r
.40007 .51821 .4083 .52623 .42208 .52371 .41389 .51581 Metetra
.593 .725 .936 r
.41389 .51581 .42208 .52371 .43594 .52136 .42778 .5136 Metetra
.584 .727 .941 r
.42778 .5136 .43594 .52136 .44988 .51915 .44176 .51157 Metetra
.577 .73 .947 r
.44176 .51157 .44988 .51915 .46391 .51705 .45583 .50968 Metetra
.57 .735 .953 r
.45583 .50968 .46391 .51705 .47803 .515 .46999 .50785 Metetra
.567 .741 .958 r
.46999 .50785 .47803 .515 .49225 .51295 .48425 .50601 Metetra
.567 .748 .962 r
.48425 .50601 .49225 .51295 .50656 .51081 .49861 .50408 Metetra
.57 .756 .966 r
.49861 .50408 .50656 .51081 .52097 .50853 .51307 .50197 Metetra
.578 .765 .967 r
.51307 .50197 .52097 .50853 .53547 .50601 .52762 .49958 Metetra
.591 .774 .967 r
.52762 .49958 .53547 .50601 .55006 .50319 .54227 .49682 Metetra
.607 .783 .965 r
.54227 .49682 .55006 .50319 .56475 .5 .55701 .4936 Metetra
.625 .789 .961 r
.55701 .4936 .56475 .5 .57951 .49638 .57184 .48987 Metetra
.644 .793 .954 r
.57184 .48987 .57951 .49638 .59436 .49228 .58674 .48558 Metetra
.663 .794 .945 r
.58674 .48558 .59436 .49228 .60927 .48769 .60171 .48071 Metetra
.679 .792 .934 r
.60171 .48071 .60927 .48769 .62426 .4826 .61675 .47527 Metetra
.693 .787 .923 r
.61675 .47527 .62426 .4826 .6393 .47703 .63184 .46929 Metetra
.704 .781 .911 r
.63184 .46929 .6393 .47703 .6544 .47102 .64699 .46283 Metetra
.711 .773 .9 r
.64699 .46283 .6544 .47102 .66955 .46461 .66219 .45596 Metetra
.716 .764 .89 r
.66219 .45596 .66955 .46461 .68476 .45787 .67744 .44877 Metetra
.718 .756 .882 r
.67744 .44877 .68476 .45787 .70001 .45088 .69273 .44135 Metetra
.719 .748 .875 r
.69273 .44135 .70001 .45088 .71532 .44371 .70809 .4338 Metetra
.717 .74 .87 r
.70809 .4338 .71532 .44371 .73069 .43643 .7235 .4262 Metetra
.715 .734 .866 r
.7235 .4262 .73069 .43643 .74612 .42913 .73897 .41864 Metetra
.712 .729 .864 r
.73897 .41864 .74612 .42913 .76161 .42185 .75451 .41118 Metetra
.708 .725 .863 r
.75451 .41118 .76161 .42185 .77718 .41467 .77013 .40388 Metetra
.704 .722 .864 r
.77013 .40388 .77718 .41467 .79282 .40761 .78583 .39677 Metetra
.699 .721 .866 r
.78583 .39677 .79282 .40761 .80854 .40071 .80161 .38986 Metetra
.695 .72 .869 r
.80161 .38986 .80854 .40071 .82435 .39398 .81749 .38318 Metetra
.691 .72 .872 r
.81749 .38318 .82435 .39398 .84026 .38743 .83346 .3767 Metetra
.686 .721 .876 r
.83346 .3767 .84026 .38743 .85625 .38107 .84953 .37042 Metetra
.683 .722 .88 r
.84953 .37042 .85625 .38107 .87235 .37487 .86571 .36433 Metetra
.679 .724 .884 r
.86571 .36433 .87235 .37487 .88854 .36883 .88198 .35838 Metetra
.676 .726 .887 r
.88198 .35838 .88854 .36883 .90484 .36293 .89836 .35257 Metetra
.674 .728 .891 r
.89836 .35257 .90484 .36293 .92124 .35714 .91484 .34686 Metetra
.64 .729 .913 r
.32362 .52528 .33211 .53345 .34557 .53001 .33712 .52181 Metetra
.633 .727 .915 r
.33712 .52181 .34557 .53001 .35909 .52675 .35068 .51853 Metetra
.625 .725 .919 r
.35068 .51853 .35909 .52675 .37268 .52369 .3643 .51547 Metetra
.617 .724 .922 r
.3643 .51547 .37268 .52369 .38634 .52084 .378 .51267 Metetra
.607 .723 .927 r
.378 .51267 .38634 .52084 .40007 .51821 .39177 .51012 Metetra
.596 .722 .932 r
.39177 .51012 .40007 .51821 .41389 .51581 .40561 .50784 Metetra
.585 .723 .938 r
.40561 .50784 .41389 .51581 .42778 .5136 .41954 .5058 Metetra
.575 .724 .944 r
.41954 .5058 .42778 .5136 .44176 .51157 .43356 .50398 Metetra
.565 .727 .951 r
.43356 .50398 .44176 .51157 .45583 .50968 .44766 .50232 Metetra
.557 .732 .957 r
.44766 .50232 .45583 .50968 .46999 .50785 .46186 .50074 Metetra
.553 .739 .963 r
.46186 .50074 .46999 .50785 .48425 .50601 .47617 .49916 Metetra
.552 .747 .967 r
.47617 .49916 .48425 .50601 .49861 .50408 .49057 .49746 Metetra
.558 .757 .971 r
.49057 .49746 .49861 .50408 .51307 .50197 .50508 .49554 Metetra
.568 .768 .972 r
.50508 .49554 .51307 .50197 .52762 .49958 .51969 .49327 Metetra
.585 .778 .972 r
.51969 .49327 .52762 .49958 .54227 .49682 .5344 .49055 Metetra
.605 .788 .968 r
.5344 .49055 .54227 .49682 .55701 .4936 .54919 .48728 Metetra
.628 .794 .962 r
.54919 .48728 .55701 .4936 .57184 .48987 .56408 .48339 Metetra
.651 .798 .953 r
.56408 .48339 .57184 .48987 .58674 .48558 .57904 .47883 Metetra
.672 .797 .942 r
.57904 .47883 .58674 .48558 .60171 .48071 .59407 .4736 Metetra
.69 .793 .929 r
.59407 .4736 .60171 .48071 .61675 .47527 .60916 .46772 Metetra
.704 .786 .916 r
.60916 .46772 .61675 .47527 .63184 .46929 .6243 .46125 Metetra
.714 .778 .903 r
.6243 .46125 .63184 .46929 .64699 .46283 .6395 .45428 Metetra
.72 .768 .891 r
.6395 .45428 .64699 .46283 .66219 .45596 .65474 .44689 Metetra
.723 .759 .881 r
.65474 .44689 .66219 .45596 .67744 .44877 .67003 .43921 Metetra
.724 .749 .872 r
.67003 .43921 .67744 .44877 .69273 .44135 .68537 .43135 Metetra
.723 .741 .866 r
.68537 .43135 .69273 .44135 .70809 .4338 .70076 .42343 Metetra
.72 .734 .862 r
.70076 .42343 .70809 .4338 .7235 .4262 .71621 .41555 Metetra
.716 .728 .86 r
.71621 .41555 .7235 .4262 .73897 .41864 .73173 .40778 Metetra
.712 .724 .859 r
.73173 .40778 .73897 .41864 .75451 .41118 .74733 .4002 Metetra
.707 .721 .86 r
.74733 .4002 .75451 .41118 .77013 .40388 .763 .39285 Metetra
.702 .719 .863 r
.763 .39285 .77013 .40388 .78583 .39677 .77876 .38575 Metetra
.697 .718 .866 r
.77876 .38575 .78583 .39677 .80161 .38986 .79462 .37891 Metetra
.692 .719 .87 r
.79462 .37891 .80161 .38986 .81749 .38318 .81056 .37231 Metetra
.687 .72 .874 r
.81056 .37231 .81749 .38318 .83346 .3767 .82661 .36595 Metetra
.683 .721 .879 r
.82661 .36595 .83346 .3767 .84953 .37042 .84276 .3598 Metetra
.679 .724 .883 r
.84276 .3598 .84953 .37042 .86571 .36433 .85901 .35382 Metetra
.676 .726 .887 r
.85901 .35382 .86571 .36433 .88198 .35838 .87537 .34798 Metetra
.673 .728 .891 r
.87537 .34798 .88198 .35838 .89836 .35257 .89183 .34226 Metetra
.671 .73 .894 r
.89183 .34226 .89836 .35257 .91484 .34686 .90839 .33662 Metetra
.64 .729 .913 r
.31505 .51704 .32362 .52528 .33712 .52181 .32859 .51352 Metetra
.633 .727 .916 r
.32859 .51352 .33712 .52181 .35068 .51853 .34219 .51022 Metetra
.624 .725 .919 r
.34219 .51022 .35068 .51853 .3643 .51547 .35585 .50717 Metetra
.614 .722 .923 r
.35585 .50717 .3643 .51547 .378 .51267 .36958 .5044 Metetra
.603 .721 .928 r
.36958 .5044 .378 .51267 .39177 .51012 .38338 .50195 Metetra
.59 .72 .934 r
.38338 .50195 .39177 .51012 .40561 .50784 .39726 .4998 Metetra
.577 .72 .94 r
.39726 .4998 .40561 .50784 .41954 .5058 .41122 .49796 Metetra
.563 .721 .947 r
.41122 .49796 .41954 .5058 .43356 .50398 .42527 .49637 Metetra
.551 .724 .955 r
.42527 .49637 .43356 .50398 .44766 .50232 .43941 .49499 Metetra
.541 .729 .961 r
.43941 .49499 .44766 .50232 .46186 .50074 .45365 .4937 Metetra
.535 .737 .968 r
.45365 .4937 .46186 .50074 .47617 .49916 .46799 .49241 Metetra
.536 .746 .973 r
.46799 .49241 .47617 .49916 .49057 .49746 .48244 .49098 Metetra
.543 .758 .976 r
.48244 .49098 .49057 .49746 .50508 .49554 .497 .48926 Metetra
.557 .77 .978 r
.497 .48926 .50508 .49554 .51969 .49327 .51167 .48712 Metetra
.579 .783 .976 r
.51167 .48712 .51969 .49327 .5344 .49055 .52643 .48441 Metetra
.605 .793 .971 r
.52643 .48441 .5344 .49055 .54919 .48728 .54129 .48103 Metetra
.634 .8 .963 r
.54129 .48103 .54919 .48728 .56408 .48339 .55623 .4769 Metetra
.66 .802 .951 r
.55623 .4769 .56408 .48339 .57904 .47883 .57125 .47199 Metetra
.684 .8 .937 r
.57125 .47199 .57904 .47883 .59407 .4736 .58634 .46631 Metetra
.702 .793 .921 r
.58634 .46631 .59407 .4736 .60916 .46772 .60148 .45989 Metetra
.715 .784 .906 r
.60148 .45989 .60916 .46772 .6243 .46125 .61667 .45284 Metetra
.724 .773 .892 r
.61667 .45284 .6243 .46125 .6395 .45428 .63191 .44527 Metetra
.728 .762 .88 r
.63191 .44527 .6395 .45428 .65474 .44689 .6472 .43732 Metetra
.729 .752 .87 r
.6472 .43732 .65474 .44689 .67003 .43921 .66253 .42914 Metetra
.728 .742 .863 r
.66253 .42914 .67003 .43921 .68537 .43135 .67791 .42086 Metetra
.725 .734 .858 r
.67791 .42086 .68537 .43135 .70076 .42343 .69335 .4126 Metetra
.721 .727 .855 r
.69335 .4126 .70076 .42343 .71621 .41555 .70885 .40449 Metetra
.716 .722 .855 r
.70885 .40449 .71621 .41555 .73173 .40778 .72442 .39659 Metetra
.71 .719 .856 r
.72442 .39659 .73173 .40778 .74733 .4002 .74007 .38897 Metetra
.705 .717 .859 r
.74007 .38897 .74733 .4002 .763 .39285 .75581 .38165 Metetra
.699 .716 .862 r
.75581 .38165 .763 .39285 .77876 .38575 .77164 .37463 Metetra
.693 .717 .867 r
.77164 .37463 .77876 .38575 .79462 .37891 .78756 .36791 Metetra
.688 .718 .872 r
.78756 .36791 .79462 .37891 .81056 .37231 .80358 .36146 Metetra
.684 .72 .877 r
.80358 .36146 .81056 .37231 .82661 .36595 .81971 .35525 Metetra
.679 .723 .882 r
.81971 .35525 .82661 .36595 .84276 .3598 .83594 .34923 Metetra
.676 .726 .887 r
.83594 .34923 .84276 .3598 .85901 .35382 .85227 .34337 Metetra
.673 .728 .891 r
.85227 .34337 .85901 .35382 .87537 .34798 .86871 .33764 Metetra
.671 .731 .895 r
.86871 .33764 .87537 .34798 .89183 .34226 .88525 .33199 Metetra
.669 .733 .898 r
.88525 .33199 .89183 .34226 .90839 .33662 .90189 .32641 Metetra
.64 .729 .913 r
.30641 .50873 .31505 .51704 .32859 .51352 .31998 .50515 Metetra
.632 .727 .916 r
.31998 .50515 .32859 .51352 .34219 .51022 .33362 .50182 Metetra
.623 .724 .919 r
.33362 .50182 .34219 .51022 .35585 .50717 .34732 .49877 Metetra
.611 .721 .924 r
.34732 .49877 .35585 .50717 .36958 .5044 .36108 .49606 Metetra
.598 .719 .929 r
.36108 .49606 .36958 .5044 .38338 .50195 .37492 .4937 Metetra
.583 .717 .936 r
.37492 .4937 .38338 .50195 .39726 .4998 .38883 .49171 Metetra
.566 .717 .943 r
.38883 .49171 .39726 .4998 .41122 .49796 .40282 .49009 Metetra
.55 .717 .951 r
.40282 .49009 .41122 .49796 .42527 .49637 .41689 .48877 Metetra
.534 .72 .959 r
.41689 .48877 .42527 .49637 .43941 .49499 .43107 .4877 Metetra
.522 .725 .966 r
.43107 .4877 .43941 .49499 .45365 .4937 .44534 .48676 Metetra
.514 .733 .973 r
.44534 .48676 .45365 .4937 .46799 .49241 .45973 .4858 Metetra
.515 .744 .978 r
.45973 .4858 .46799 .49241 .48244 .49098 .47422 .48466 Metetra
.525 .758 .982 r
.47422 .48466 .48244 .49098 .497 .48926 .48883 .48316 Metetra
.546 .774 .983 r
.48883 .48316 .497 .48926 .51167 .48712 .50355 .48112 Metetra
.575 .789 .98 r
.50355 .48112 .51167 .48712 .52643 .48441 .51837 .47839 Metetra
.608 .8 .973 r
.51837 .47839 .52643 .48441 .54129 .48103 .53329 .47483 Metetra
.642 .806 .962 r
.53329 .47483 .54129 .48103 .55623 .4769 .5483 .47038 Metetra
.673 .807 .947 r
.5483 .47038 .55623 .4769 .57125 .47199 .56337 .465 Metetra
.698 .801 .929 r
.56337 .465 .57125 .47199 .58634 .46631 .57852 .45874 Metetra
.716 .792 .911 r
.57852 .45874 .58634 .46631 .60148 .45989 .59371 .45168 Metetra
.727 .78 .894 r
.59371 .45168 .60148 .45989 .61667 .45284 .60895 .44396 Metetra
.733 .767 .88 r
.60895 .44396 .61667 .45284 .63191 .44527 .62424 .43574 Metetra
.735 .755 .868 r
.62424 .43574 .63191 .44527 .6472 .43732 .63957 .42719 Metetra
.734 .743 .859 r
.63957 .42719 .6472 .43732 .66253 .42914 .65494 .41851 Metetra
.731 .734 .853 r
.65494 .41851 .66253 .42914 .67791 .42086 .67036 .40984 Metetra
.726 .726 .85 r
.67036 .40984 .67791 .42086 .69335 .4126 .68585 .40132 Metetra
.72 .72 .85 r
.68585 .40132 .69335 .4126 .70885 .40449 .7014 .39307 Metetra
.714 .717 .851 r
.7014 .39307 .70885 .40449 .72442 .39659 .71703 .38513 Metetra
.708 .715 .854 r
.71703 .38513 .72442 .39659 .74007 .38897 .73274 .37756 Metetra
.701 .714 .859 r
.73274 .37756 .74007 .38897 .75581 .38165 .74855 .37035 Metetra
.695 .715 .864 r
.74855 .37035 .75581 .38165 .77164 .37463 .76445 .36349 Metetra
.689 .717 .87 r
.76445 .36349 .77164 .37463 .78756 .36791 .78045 .35695 Metetra
.684 .719 .876 r
.78045 .35695 .78756 .36791 .80358 .36146 .79655 .35068 Metetra
.68 .722 .882 r
.79655 .35068 .80358 .36146 .81971 .35525 .81276 .34463 Metetra
.676 .725 .887 r
.81276 .34463 .81971 .35525 .83594 .34923 .82907 .33875 Metetra
.673 .728 .892 r
.82907 .33875 .83594 .34923 .85227 .34337 .84548 .33301 Metetra
.67 .731 .895 r
.84548 .33301 .85227 .34337 .86871 .33764 .862 .32736 Metetra
.668 .733 .899 r
.862 .32736 .86871 .33764 .88525 .33199 .87862 .32177 Metetra
.667 .735 .901 r
.87862 .32177 .88525 .33199 .90189 .32641 .89533 .31621 Metetra
.641 .729 .913 r
.29768 .50034 .30641 .50873 .31998 .50515 .31129 .49671 Metetra
.632 .727 .916 r
.31129 .49671 .31998 .50515 .33362 .50182 .32497 .49334 Metetra
.621 .723 .919 r
.32497 .49334 .33362 .50182 .34732 .49877 .3387 .49029 Metetra
.608 .72 .924 r
.3387 .49029 .34732 .49877 .36108 .49606 .3525 .48762 Metetra
.593 .717 .93 r
.3525 .48762 .36108 .49606 .37492 .4937 .36637 .48537 Metetra
.574 .715 .938 r
.36637 .48537 .37492 .4937 .38883 .49171 .38031 .48357 Metetra
.554 .713 .946 r
.38031 .48357 .38883 .49171 .40282 .49009 .39432 .48219 Metetra
.533 .713 .954 r
.39432 .48219 .40282 .49009 .41689 .48877 .40843 .4812 Metetra
.513 .715 .963 r
.40843 .4812 .41689 .48877 .43107 .4877 .42263 .48049 Metetra
.497 .72 .971 r
.42263 .48049 .43107 .4877 .44534 .48676 .43694 .47994 Metetra
.488 .729 .978 r
.43694 .47994 .44534 .48676 .45973 .4858 .45136 .47936 Metetra
.49 .742 .983 r
.45136 .47936 .45973 .4858 .47422 .48466 .4659 .47855 Metetra
.506 .759 .987 r
.4659 .47855 .47422 .48466 .48883 .48316 .48056 .47727 Metetra
.534 .778 .987 r
.48056 .47727 .48883 .48316 .50355 .48112 .49533 .47531 Metetra
.573 .795 .983 r
.49533 .47531 .50355 .48112 .51837 .47839 .51022 .47248 Metetra
.615 .808 .974 r
.51022 .47248 .51837 .47839 .53329 .47483 .5252 .46865 Metetra
.656 .813 .959 r
.5252 .46865 .53329 .47483 .5483 .47038 .54027 .46374 Metetra
.689 .81 .939 r
.54027 .46374 .5483 .47038 .56337 .465 .55541 .45776 Metetra
.714 .8 .918 r
.55541 .45776 .56337 .465 .57852 .45874 .57061 .45079 Metetra
.73 .787 .898 r
.57061 .45079 .57852 .45874 .59371 .45168 .58585 .44297 Metetra
.739 .773 .88 r
.58585 .44297 .59371 .45168 .60895 .44396 .60114 .43449 Metetra
.742 .758 .866 r
.60114 .43449 .60895 .44396 .62424 .43574 .61647 .42557 Metetra
.741 .745 .855 r
.61647 .42557 .62424 .43574 .63957 .42719 .63184 .41644 Metetra
.737 .734 .848 r
.63184 .41644 .63957 .42719 .65494 .41851 .64726 .4073 Metetra
.732 .725 .845 r
.64726 .4073 .65494 .41851 .67036 .40984 .66273 .39832 Metetra
.726 .719 .844 r
.66273 .39832 .67036 .40984 .68585 .40132 .67827 .38965 Metetra
.718 .715 .846 r
.67827 .38965 .68585 .40132 .7014 .39307 .69388 .38136 Metetra
.711 .712 .849 r
.69388 .38136 .7014 .39307 .71703 .38513 .70957 .3735 Metetra
.704 .712 .855 r
.70957 .3735 .71703 .38513 .73274 .37756 .72535 .36608 Metetra
.697 .713 .861 r
.72535 .36608 .73274 .37756 .74855 .37035 .74123 .35907 Metetra
.69 .715 .868 r
.74123 .35907 .74855 .37035 .76445 .36349 .75721 .35242 Metetra
.685 .718 .875 r
.75721 .35242 .76445 .36349 .78045 .35695 .77329 .34609 Metetra
.68 .722 .881 r
.77329 .34609 .78045 .35695 .79655 .35068 .78947 .34 Metetra
.676 .725 .887 r
.78947 .34 .79655 .35068 .81276 .34463 .80576 .33411 Metetra
.672 .729 .892 r
.80576 .33411 .81276 .34463 .82907 .33875 .82215 .32836 Metetra
.67 .731 .896 r
.82215 .32836 .82907 .33875 .84548 .33301 .83864 .32271 Metetra
.668 .734 .899 r
.83864 .32271 .84548 .33301 .862 .32736 .85524 .31711 Metetra
.666 .736 .902 r
.85524 .31711 .862 .32736 .87862 .32177 .87193 .31155 Metetra
.666 .737 .904 r
.87193 .31155 .87862 .32177 .89533 .31621 .88872 .306 Metetra
.642 .73 .913 r
.28886 .49189 .29768 .50034 .31129 .49671 .30252 .48819 Metetra
.632 .727 .916 r
.30252 .48819 .31129 .49671 .32497 .49334 .31623 .48477 Metetra
.62 .723 .92 r
.31623 .48477 .32497 .49334 .3387 .49029 .33001 .48172 Metetra
.605 .719 .925 r
.33001 .48172 .3387 .49029 .3525 .48762 .34384 .4791 Metetra
.587 .715 .932 r
.34384 .4791 .3525 .48762 .36637 .48537 .35773 .47697 Metetra
.565 .711 .94 r
.35773 .47697 .36637 .48537 .38031 .48357 .3717 .47537 Metetra
.54 .708 .949 r
.3717 .47537 .38031 .48357 .39432 .48219 .38574 .47428 Metetra
.513 .707 .958 r
.38574 .47428 .39432 .48219 .40843 .4812 .39987 .47366 Metetra
.488 .708 .967 r
.39987 .47366 .40843 .4812 .42263 .48049 .4141 .47339 Metetra
.467 .712 .975 r
.4141 .47339 .42263 .48049 .43694 .47994 .42844 .47329 Metetra
.456 .722 .982 r
.42844 .47329 .43694 .47994 .45136 .47936 .4429 .47314 Metetra
.46 .738 .988 r
.4429 .47314 .45136 .47936 .4659 .47855 .45748 .47268 Metetra
.483 .759 .991 r
.45748 .47268 .4659 .47855 .48056 .47727 .47219 .47161 Metetra
.523 .783 .992 r
.47219 .47161 .48056 .47727 .49533 .47531 .48702 .46968 Metetra
.575 .804 .986 r
.48702 .46968 .49533 .47531 .51022 .47248 .50197 .46667 Metetra
.628 .816 .973 r
.50197 .46667 .51022 .47248 .5252 .46865 .51701 .46243 Metetra
.674 .818 .953 r
.51701 .46243 .5252 .46865 .54027 .46374 .53215 .45691 Metetra
.708 .81 .929 r
.53215 .45691 .54027 .46374 .55541 .45776 .54735 .45016 Metetra
.731 .797 .904 r
.54735 .45016 .55541 .45776 .57061 .45079 .56261 .44233 Metetra
.743 .78 .883 r
.56261 .44233 .57061 .45079 .58585 .44297 .57791 .43363 Metetra
.749 .763 .865 r
.57791 .43363 .58585 .44297 .60114 .43449 .59324 .42433 Metetra
.748 .748 .852 r
.59324 .42433 .60114 .43449 .61647 .42557 .60862 .41471 Metetra
.745 .735 .843 r
.60862 .41471 .61647 .42557 .63184 .41644 .62403 .40504 Metetra
.739 .725 .839 r
.62403 .40504 .63184 .41644 .64726 .4073 .6395 .39553 Metetra
.731 .717 .838 r
.6395 .39553 .64726 .4073 .66273 .39832 .65502 .38637 Metetra
.723 .712 .84 r
.65502 .38637 .66273 .39832 .67827 .38965 .67061 .37767 Metetra
.715 .71 .844 r
.67061 .37767 .67827 .38965 .69388 .38136 .68628 .36948 Metetra
.706 .71 .85 r
.68628 .36948 .69388 .38136 .70957 .3735 .70204 .36181 Metetra
.699 .711 .858 r
.70204 .36181 .70957 .3735 .72535 .36608 .7179 .35463 Metetra
.691 .714 .866 r
.7179 .35463 .72535 .36608 .74123 .35907 .73385 .34788 Metetra
.685 .717 .874 r
.73385 .34788 .74123 .35907 .75721 .35242 .74991 .34148 Metetra
.68 .721 .881 r
.74991 .34148 .75721 .35242 .77329 .34609 .76607 .33537 Metetra
.675 .725 .887 r
.76607 .33537 .77329 .34609 .78947 .34 .78234 .32946 Metetra
.672 .729 .892 r
.78234 .32946 .78947 .34 .80576 .33411 .79871 .3237 Metetra
.669 .732 .897 r
.79871 .3237 .80576 .33411 .82215 .32836 .81517 .31805 Metetra
.667 .734 .9 r
.81517 .31805 .82215 .32836 .83864 .32271 .83174 .31245 Metetra
.666 .736 .902 r
.83174 .31245 .83864 .32271 .85524 .31711 .84841 .30687 Metetra
.665 .738 .904 r
.84841 .30687 .85524 .31711 .87193 .31155 .86518 .30131 Metetra
.665 .739 .905 r
.86518 .30131 .87193 .31155 .88872 .306 .88205 .29574 Metetra
.642 .73 .913 r
.27997 .48336 .28886 .49189 .30252 .48819 .29366 .47959 Metetra
.633 .727 .916 r
.29366 .47959 .30252 .48819 .31623 .48477 .30742 .47613 Metetra
.619 .723 .92 r
.30742 .47613 .31623 .48477 .33001 .48172 .32123 .47307 Metetra
.602 .718 .926 r
.32123 .47307 .33001 .48172 .34384 .4791 .33509 .4705 Metetra
.58 .713 .934 r
.33509 .4705 .34384 .4791 .35773 .47697 .34902 .46851 Metetra
.554 .708 .942 r
.34902 .46851 .35773 .47697 .3717 .47537 .36301 .46714 Metetra
.523 .703 .952 r
.36301 .46714 .3717 .47537 .38574 .47428 .37707 .46639 Metetra
.489 .699 .962 r
.37707 .46639 .38574 .47428 .39987 .47366 .39122 .4662 Metetra
.455 .698 .971 r
.39122 .4662 .39987 .47366 .4141 .47339 .40547 .46642 Metetra
.428 .701 .979 r
.40547 .46642 .4141 .47339 .42844 .47329 .41984 .46685 Metetra
.415 .712 .985 r
.41984 .46685 .42844 .47329 .4429 .47314 .43433 .46718 Metetra
.424 .731 .99 r
.43433 .46718 .4429 .47314 .45748 .47268 .44895 .46709 Metetra
.459 .759 .994 r
.44895 .46709 .45748 .47268 .47219 .47161 .46371 .46621 Metetra
.516 .79 .995 r
.46371 .46621 .47219 .47161 .48702 .46968 .4786 .46423 Metetra
.583 .814 .987 r
.4786 .46423 .48702 .46968 .50197 .46667 .49362 .46089 Metetra
.646 .825 .969 r
.49362 .46089 .50197 .46667 .51701 .46243 .50873 .45607 Metetra
.696 .821 .942 r
.50873 .45607 .51701 .46243 .53215 .45691 .52393 .44975 Metetra
.729 .808 .914 r
.52393 .44975 .53215 .45691 .54735 .45016 .5392 .44205 Metetra
.747 .789 .887 r
.5392 .44205 .54735 .45016 .56261 .44233 .55452 .43321 Metetra
.755 .77 .865 r
.55452 .43321 .56261 .44233 .57791 .43363 .56987 .42354 Metetra
.756 .752 .849 r
.56987 .42354 .57791 .43363 .59324 .42433 .58526 .41339 Metetra
.752 .737 .838 r
.58526 .41339 .59324 .42433 .60862 .41471 .60068 .40311 Metetra
.746 .724 .832 r
.60068 .40311 .60862 .41471 .62403 .40504 .61614 .39299 Metetra
.737 .715 .831 r
.61614 .39299 .62403 .40504 .6395 .39553 .63165 .38327 Metetra
.728 .71 .833 r
.63165 .38327 .6395 .39553 .65502 .38637 .64723 .37409 Metetra
.719 .707 .838 r
.64723 .37409 .65502 .38637 .67061 .37767 .66288 .36552 Metetra
.71 .707 .845 r
.66288 .36552 .67061 .37767 .68628 .36948 .67862 .35757 Metetra
.701 .709 .854 r
.67862 .35757 .68628 .36948 .70204 .36181 .69446 .3502 Metetra
.693 .712 .863 r
.69446 .3502 .70204 .36181 .7179 .35463 .71039 .34333 Metetra
.686 .716 .872 r
.71039 .34333 .7179 .35463 .73385 .34788 .72643 .33686 Metetra
.68 .721 .88 r
.72643 .33686 .73385 .34788 .74991 .34148 .74256 .33072 Metetra
.675 .725 .887 r
.74256 .33072 .74991 .34148 .76607 .33537 .75881 .3248 Metetra
.671 .729 .893 r
.75881 .3248 .76607 .33537 .78234 .32946 .77515 .31903 Metetra
.669 .732 .897 r
.77515 .31903 .78234 .32946 .79871 .3237 .7916 .31337 Metetra
.667 .735 .901 r
.7916 .31337 .79871 .3237 .81517 .31805 .80814 .30777 Metetra
.666 .737 .903 r
.80814 .30777 .81517 .31805 .83174 .31245 .82478 .30218 Metetra
.665 .738 .905 r
.82478 .30218 .83174 .31245 .84841 .30687 .84153 .29661 Metetra
.664 .739 .906 r
.84153 .29661 .84841 .30687 .86518 .30131 .85837 .29102 Metetra
.664 .74 .906 r
.85837 .29102 .86518 .30131 .88205 .29574 .87531 .28541 Metetra
.643 .731 .912 r
.27098 .47477 .27997 .48336 .29366 .47959 .28472 .47092 Metetra
.633 .727 .916 r
.28472 .47092 .29366 .47959 .30742 .47613 .29852 .4674 Metetra
.618 .722 .921 r
.29852 .4674 .30742 .47613 .32123 .47307 .31236 .46433 Metetra
.599 .717 .927 r
.31236 .46433 .32123 .47307 .33509 .4705 .32626 .46182 Metetra
.573 .71 .935 r
.32626 .46182 .33509 .4705 .34902 .46851 .34021 .45998 Metetra
.541 .703 .945 r
.34021 .45998 .34902 .46851 .36301 .46714 .35422 .45887 Metetra
.502 .696 .956 r
.35422 .45887 .36301 .46714 .37707 .46639 .3683 .45851 Metetra
.458 .689 .966 r
.3683 .45851 .37707 .46639 .39122 .4662 .38247 .45883 Metetra
.413 .684 .973 r
.38247 .45883 .39122 .4662 .40547 .46642 .39674 .45964 Metetra
.378 .685 .979 r
.39674 .45964 .40547 .46642 .41984 .46685 .41112 .46067 Metetra
.363 .696 .983 r
.41112 .46067 .41984 .46685 .43433 .46718 .42564 .46155 Metetra
.381 .722 .989 r
.42564 .46155 .43433 .46718 .44895 .46709 .44031 .46183 Metetra
.434 .76 .996 r
.44031 .46183 .44895 .46709 .46371 .46621 .45512 .46108 Metetra
.514 .799 .997 r
.45512 .46108 .46371 .46621 .4786 .46423 .47008 .45892 Metetra
.6 .826 .986 r
.47008 .45892 .4786 .46423 .49362 .46089 .48516 .45508 Metetra
.672 .832 .96 r
.48516 .45508 .49362 .46089 .50873 .45607 .50035 .44945 Metetra
.721 .821 .927 r
.50035 .44945 .50873 .45607 .52393 .44975 .51563 .44209 Metetra
.749 .801 .894 r
.51563 .44209 .52393 .44975 .5392 .44205 .53096 .43323 Metetra
.762 .778 .867 r
.53096 .43323 .5392 .44205 .55452 .43321 .54634 .42325 Metetra
.764 .757 .846 r
.54634 .42325 .55452 .43321 .56987 .42354 .56174 .41256 Metetra
.761 .739 .832 r
.56174 .41256 .56987 .42354 .58526 .41339 .57718 .40161 Metetra
.754 .724 .825 r
.57718 .40161 .58526 .41339 .60068 .40311 .59265 .39079 Metetra
.744 .714 .823 r
.59265 .39079 .60068 .40311 .61614 .39299 .60816 .3804 Metetra
.734 .707 .825 r
.60816 .3804 .61614 .39299 .63165 .38327 .62373 .37065 Metetra
.723 .704 .831 r
.62373 .37065 .63165 .38327 .64723 .37409 .63937 .36163 Metetra
.713 .704 .84 r
.63937 .36163 .64723 .37409 .66288 .36552 .65509 .35336 Metetra
.703 .706 .85 r
.65509 .35336 .66288 .36552 .67862 .35757 .67091 .34577 Metetra
.694 .71 .86 r
.67091 .34577 .67862 .35757 .69446 .3502 .68682 .33877 Metetra
.686 .715 .871 r
.68682 .33877 .69446 .3502 .71039 .34333 .70283 .33223 Metetra
.68 .72 .88 r
.70283 .33223 .71039 .34333 .72643 .33686 .71895 .32605 Metetra
.675 .725 .887 r
.71895 .32605 .72643 .33686 .74256 .33072 .73516 .32012 Metetra
.671 .729 .894 r
.73516 .32012 .74256 .33072 .75881 .3248 .75148 .31435 Metetra
.668 .733 .898 r
.75148 .31435 .75881 .3248 .77515 .31903 .7679 .30869 Metetra
.666 .735 .901 r
.7679 .30869 .77515 .31903 .7916 .31337 .78442 .30307 Metetra
.665 .737 .904 r
.78442 .30307 .7916 .31337 .80814 .30777 .80104 .29748 Metetra
.665 .739 .905 r
.80104 .29748 .80814 .30777 .82478 .30218 .81776 .29188 Metetra
.664 .74 .906 r
.81776 .29188 .82478 .30218 .84153 .29661 .83457 .28627 Metetra
.664 .74 .907 r
.83457 .28627 .84153 .29661 .85837 .29102 .85149 .28064 Metetra
.664 .74 .907 r
.85149 .28064 .85837 .29102 .87531 .28541 .8685 .27498 Metetra
.645 .732 .912 r
.26191 .46612 .27098 .47477 .28472 .47092 .27569 .46218 Metetra
.633 .728 .916 r
.27569 .46218 .28472 .47092 .29852 .4674 .28953 .4586 Metetra
.617 .722 .921 r
.28953 .4586 .29852 .4674 .31236 .46433 .30341 .45551 Metetra
.595 .716 .928 r
.30341 .45551 .31236 .46433 .32626 .46182 .31734 .45306 Metetra
.565 .708 .937 r
.31734 .45306 .32626 .46182 .34021 .45998 .33132 .45139 Metetra
.525 .698 .948 r
.33132 .45139 .34021 .45998 .35422 .45887 .34535 .4506 Metetra
.475 .687 .959 r
.34535 .4506 .35422 .45887 .3683 .45851 .35944 .4507 Metetra
.418 .674 .968 r
.35944 .4507 .3683 .45851 .38247 .45883 .37361 .45161 Metetra
.359 .664 .972 r
.37361 .45161 .38247 .45883 .39674 .45964 .38789 .45311 Metetra
.313 .661 .973 r
.38789 .45311 .39674 .45964 .41112 .46067 .40229 .45483 Metetra
.298 .674 .974 r
.40229 .45483 .41112 .46067 .42564 .46155 .41684 .45629 Metetra
.33 .709 .982 r
.41684 .45629 .42564 .46155 .44031 .46183 .43154 .45694 Metetra
.412 .762 .995 r
.43154 .45694 .44031 .46183 .45512 .46108 .44642 .45622 Metetra
.523 .812 .998 r
.44642 .45622 .45512 .46108 .47008 .45892 .46144 .4537 Metetra
.628 .838 .981 r
.46144 .4537 .47008 .45892 .48516 .45508 .47661 .4491 Metetra
.704 .836 .946 r
.47661 .4491 .48516 .45508 .50035 .44945 .49188 .44238 Metetra
.747 .816 .906 r
.49188 .44238 .50035 .44945 .51563 .44209 .50723 .43372 Metetra
.768 .79 .871 r
.50723 .43372 .51563 .44209 .53096 .43323 .52264 .42352 Metetra
.773 .764 .845 r
.52264 .42352 .53096 .43323 .54634 .42325 .53808 .4123 Metetra
.77 .742 .827 r
.53808 .4123 .54634 .42325 .56174 .41256 .55354 .40062 Metetra
.762 .725 .818 r
.55354 .40062 .56174 .41256 .57718 .40161 .56902 .38899 Metetra
.752 .713 .815 r
.56902 .38899 .57718 .40161 .59265 .39079 .58454 .37782 Metetra
.741 .705 .817 r
.58454 .37782 .59265 .39079 .60816 .3804 .60011 .3674 Metetra
.729 .701 .824 r
.60011 .3674 .60816 .3804 .62373 .37065 .61574 .35785 Metetra
.717 .701 .834 r
.61574 .35785 .62373 .37065 .63937 .36163 .63145 .3492 Metetra
.706 .703 .845 r
.63145 .3492 .63937 .36163 .65509 .35336 .64724 .34136 Metetra
.696 .708 .857 r
.64724 .34136 .65509 .35336 .67091 .34577 .66313 .3342 Metetra
.687 .714 .869 r
.66313 .3342 .67091 .34577 .68682 .33877 .67912 .32759 Metetra
.68 .72 .879 r
.67912 .32759 .68682 .33877 .70283 .33223 .69521 .32137 Metetra
.674 .725 .888 r
.69521 .32137 .70283 .33223 .71895 .32605 .71141 .31543 Metetra
.67 .73 .894 r
.71141 .31543 .71895 .32605 .73516 .32012 .7277 .30966 Metetra
.668 .733 .899 r
.7277 .30966 .73516 .32012 .75148 .31435 .7441 .30399 Metetra
.666 .736 .902 r
.7441 .30399 .75148 .31435 .7679 .30869 .76059 .29836 Metetra
.665 .738 .904 r
.76059 .29836 .7679 .30869 .78442 .30307 .77718 .29276 Metetra
.664 .739 .906 r
.77718 .29276 .78442 .30307 .80104 .29748 .79387 .28714 Metetra
.664 .74 .906 r
.79387 .28714 .80104 .29748 .81776 .29188 .81066 .28151 Metetra
.664 .74 .907 r
.81066 .28151 .81776 .29188 .83457 .28627 .82755 .27585 Metetra
.664 .741 .907 r
.82755 .27585 .83457 .28627 .85149 .28064 .84453 .27016 Metetra
.664 .741 .907 r
.84453 .27016 .85149 .28064 .8685 .27498 .86162 .26445 Metetra
.646 .732 .912 r
.25275 .45739 .26191 .46612 .27569 .46218 .26658 .45337 Metetra
.634 .728 .916 r
.26658 .45337 .27569 .46218 .28953 .4586 .28045 .44972 Metetra
.617 .722 .921 r
.28045 .44972 .28953 .4586 .30341 .45551 .29437 .44662 Metetra
.591 .715 .929 r
.29437 .44662 .30341 .45551 .31734 .45306 .30833 .44424 Metetra
.555 .705 .94 r
.30833 .44424 .31734 .45306 .33132 .45139 .32233 .44276 Metetra
.506 .691 .951 r
.32233 .44276 .33132 .45139 .34535 .4506 .33637 .44233 Metetra
.442 .674 .962 r
.33637 .44233 .34535 .4506 .35944 .4507 .35047 .44297 Metetra
.365 .654 .967 r
.35047 .44297 .35944 .4507 .37361 .45161 .36464 .44459 Metetra
.286 .634 .964 r
.36464 .44459 .37361 .45161 .38789 .45311 .37892 .44689 Metetra
.227 .624 .956 r
.37892 .44689 .38789 .45311 .40229 .45483 .39333 .4494 Metetra
.217 .641 .954 r
.39333 .4494 .40229 .45483 .41684 .45629 .4079 .45148 Metetra
.275 .694 .969 r
.4079 .45148 .41684 .45629 .43154 .45694 .42266 .45243 Metetra
.399 .768 .993 r
.42266 .45243 .43154 .45694 .44642 .45622 .43759 .45159 Metetra
.547 .829 .998 r
.43759 .45159 .44642 .45622 .46144 .4537 .4527 .44844 Metetra
.667 .849 .97 r
.4527 .44844 .46144 .4537 .47661 .4491 .46795 .44276 Metetra
.738 .834 .924 r
.46795 .44276 .47661 .4491 .49188 .44238 .48332 .43462 Metetra
.771 .804 .88 r
.48332 .43462 .49188 .44238 .50723 .43372 .49875 .4244 Metetra
.782 .774 .846 r
.49875 .4244 .50723 .43372 .52264 .42352 .51423 .41272 Metetra
.78 .747 .823 r
.51423 .41272 .52264 .42352 .53808 .4123 .52973 .40026 Metetra
.772 .727 .81 r
.52973 .40026 .53808 .4123 .55354 .40062 .54525 .38771 Metetra
.761 .712 .806 r
.54525 .38771 .55354 .40062 .56902 .38899 .56079 .37563 Metetra
.748 .702 .808 r
.56079 .37563 .56902 .38899 .58454 .37782 .57637 .3644 Metetra
.734 .697 .815 r
.57637 .3644 .58454 .37782 .60011 .3674 .59199 .35421 Metetra
.721 .697 .826 r
.59199 .35421 .60011 .3674 .61574 .35785 .60769 .3451 Metetra
.709 .7 .84 r
.60769 .3451 .61574 .35785 .63145 .3492 .62346 .33696 Metetra
.697 .705 .854 r
.62346 .33696 .63145 .3492 .64724 .34136 .63933 .32964 Metetra
.688 .712 .867 r
.63933 .32964 .64724 .34136 .66313 .3342 .6553 .32294 Metetra
.68 .719 .879 r
.6553 .32294 .66313 .3342 .67912 .32759 .67137 .31668 Metetra
.674 .725 .888 r
.67137 .31668 .67912 .32759 .69521 .32137 .68754 .31073 Metetra
.67 .73 .895 r
.68754 .31073 .69521 .32137 .71141 .31543 .70381 .30495 Metetra
.667 .734 .9 r
.70381 .30495 .71141 .31543 .7277 .30966 .72018 .29927 Metetra
.666 .737 .903 r
.72018 .29927 .7277 .30966 .7441 .30399 .73664 .29364 Metetra
.665 .738 .905 r
.73664 .29364 .7441 .30399 .76059 .29836 .75321 .28802 Metetra
.664 .739 .906 r
.75321 .28802 .76059 .29836 .77718 .29276 .76987 .28238 Metetra
.664 .74 .907 r
.76987 .28238 .77718 .29276 .79387 .28714 .78663 .27673 Metetra
.664 .74 .907 r
.78663 .27673 .79387 .28714 .81066 .28151 .80349 .27104 Metetra
.664 .741 .907 r
.80349 .27104 .81066 .28151 .82755 .27585 .82044 .26533 Metetra
.664 .741 .907 r
.82044 .26533 .82755 .27585 .84453 .27016 .8375 .25958 Metetra
.664 .741 .907 r
.8375 .25958 .84453 .27016 .86162 .26445 .85466 .2538 Metetra
.647 .733 .912 r
.2435 .4486 .25275 .45739 .26658 .45337 .25737 .44449 Metetra
.635 .729 .916 r
.25737 .44449 .26658 .45337 .28045 .44972 .27129 .44077 Metetra
.616 .722 .922 r
.27129 .44077 .28045 .44972 .29437 .44662 .28525 .43765 Metetra
.587 .713 .931 r
.28525 .43765 .29437 .44662 .30833 .44424 .29924 .43535 Metetra
.544 .701 .942 r
.29924 .43535 .30833 .44424 .32233 .44276 .31325 .4341 Metetra
.482 .683 .955 r
.31325 .4341 .32233 .44276 .33637 .44233 .3273 .43409 Metetra
.399 .657 .963 r
.3273 .43409 .33637 .44233 .35047 .44297 .34139 .43538 Metetra
.295 .624 .96 r
.34139 .43538 .35047 .44297 .36464 .44459 .35555 .43783 Metetra
.19 .588 .942 r
.35555 .43783 .36464 .44459 .37892 .44689 .36982 .44107 Metetra
.118 .57 .919 r
.36982 .44107 .37892 .44689 .39333 .4494 .38424 .44446 Metetra
.121 .596 .916 r
.38424 .44446 .39333 .4494 .4079 .45148 .39883 .44718 Metetra
.222 .677 .949 r
.39883 .44718 .4079 .45148 .42266 .45243 .41364 .44832 Metetra
.404 .783 .992 r
.41364 .44832 .42266 .45243 .43759 .45159 .42865 .4471 Metetra
.59 .85 .993 r
.42865 .4471 .43759 .45159 .4527 .44844 .44385 .44297 Metetra
.712 .853 .949 r
.44385 .44297 .4527 .44844 .46795 .44276 .4592 .4358 Metetra
.77 .823 .894 r
.4592 .4358 .46795 .44276 .48332 .43462 .47467 .42588 Metetra
.79 .787 .85 r
.47467 .42588 .48332 .43462 .49875 .4244 .4902 .41388 Metetra
.79 .754 .82 r
.4902 .41388 .49875 .4244 .51423 .41272 .50575 .40064 Metetra
.783 .729 .803 r
.50575 .40064 .51423 .41272 .52973 .40026 .52132 .38707 Metetra
.77 .711 .797 r
.52132 .38707 .52973 .40026 .54525 .38771 .53689 .37391 Metetra
.756 .699 .798 r
.53689 .37391 .54525 .38771 .56079 .37563 .55249 .36172 Metetra
.741 .694 .806 r
.55249 .36172 .56079 .37563 .57637 .3644 .56812 .35077 Metetra
.726 .693 .818 r
.56812 .35077 .57637 .3644 .59199 .35421 .58381 .3411 Metetra
.712 .696 .833 r
.58381 .3411 .59199 .35421 .60769 .3451 .59957 .33261 Metetra
.699 .703 .85 r
.59957 .33261 .60769 .3451 .62346 .33696 .61542 .32508 Metetra
.689 .71 .865 r
.61542 .32508 .62346 .33696 .63933 .32964 .63137 .31828 Metetra
.68 .718 .878 r
.63137 .31828 .63933 .32964 .6553 .32294 .64741 .31198 Metetra
.674 .725 .888 r
.64741 .31198 .6553 .32294 .67137 .31668 .66356 .30601 Metetra
.67 .73 .895 r
.66356 .30601 .67137 .31668 .68754 .31073 .6798 .30023 Metetra
.667 .734 .9 r
.6798 .30023 .68754 .31073 .70381 .30495 .69614 .29454 Metetra
.665 .737 .903 r
.69614 .29454 .70381 .30495 .72018 .29927 .71258 .2889 Metetra
.665 .739 .905 r
.71258 .2889 .72018 .29927 .73664 .29364 .72911 .28326 Metetra
.664 .74 .906 r
.72911 .28326 .73664 .29364 .75321 .28802 .74575 .2776 Metetra
.664 .74 .907 r
.74575 .2776 .75321 .28802 .76987 .28238 .76248 .27192 Metetra
.664 .741 .907 r
.76248 .27192 .76987 .28238 .78663 .27673 .77931 .26621 Metetra
.664 .741 .907 r
.77931 .26621 .78663 .27673 .80349 .27104 .79623 .26047 Metetra
.664 .741 .907 r
.79623 .26047 .80349 .27104 .82044 .26533 .81326 .25469 Metetra
.664 .741 .907 r
.81326 .25469 .82044 .26533 .8375 .25958 .83039 .24888 Metetra
.664 .741 .907 r
.83039 .24888 .8375 .25958 .85466 .2538 .84762 .24304 Metetra
.648 .734 .912 r
.23416 .43974 .2435 .4486 .25737 .44449 .24807 .43554 Metetra
.636 .729 .916 r
.24807 .43554 .25737 .44449 .27129 .44077 .26203 .43175 Metetra
.615 .723 .922 r
.26203 .43175 .27129 .44077 .28525 .43765 .27603 .42861 Metetra
.582 .712 .932 r
.27603 .42861 .28525 .43765 .29924 .43535 .29004 .4264 Metetra
.53 .696 .945 r
.29004 .4264 .29924 .43535 .31325 .4341 .30407 .42542 Metetra
.452 .672 .957 r
.30407 .42542 .31325 .4341 .3273 .43409 .31812 .42592 Metetra
.341 .633 .961 r
.31812 .42592 .3273 .43409 .34139 .43538 .3322 .42798 Metetra
.201 .578 .941 r
.3322 .42798 .34139 .43538 .35555 .43783 .34634 .43142 Metetra
.063 .519 .896 r
.34634 .43142 .35555 .43783 .36982 .44107 .36059 .43575 Metetra
0 .493 .853 r
.36059 .43575 .36982 .44107 .38424 .44446 .375 .44011 Metetra
.015 .538 .858 r
.375 .44011 .38424 .44446 .39883 .44718 .38962 .44343 Metetra
.18 .665 .926 r
.38962 .44343 .39883 .44718 .41364 .44832 .40448 .44456 Metetra
.437 .809 .993 r
.40448 .44456 .41364 .44832 .42865 .4471 .41958 .44258 Metetra
.651 .868 .981 r
.41958 .44258 .42865 .4471 .44385 .44297 .43489 .43699 Metetra
.758 .847 .918 r
.43489 .43699 .44385 .44297 .4592 .4358 .45037 .42787 Metetra
.795 .804 .859 r
.45037 .42787 .4592 .4358 .47467 .42588 .46595 .41584 Metetra
.801 .765 .82 r
.46595 .41584 .47467 .42588 .4902 .41388 .48157 .40191 Metetra
.794 .734 .797 r
.48157 .40191 .4902 .41388 .50575 .40064 .49721 .38723 Metetra
.781 .712 .787 r
.49721 .38723 .50575 .40064 .52132 .38707 .51284 .37283 Metetra
.765 .697 .787 r
.51284 .37283 .52132 .38707 .53689 .37391 .52847 .35947 Metetra
.748 .69 .795 r
.52847 .35947 .53689 .37391 .55249 .36172 .54412 .34757 Metetra
.732 .689 .809 r
.54412 .34757 .55249 .36172 .56812 .35077 .55981 .33723 Metetra
.716 .692 .826 r
.55981 .33723 .56812 .35077 .58381 .3411 .57556 .32831 Metetra
.702 .699 .845 r
.57556 .32831 .58381 .3411 .59957 .33261 .5914 .32054 Metetra
.69 .708 .862 r
.5914 .32054 .59957 .33261 .61542 .32508 .60732 .31362 Metetra
.68 .717 .877 r
.60732 .31362 .61542 .32508 .63137 .31828 .62334 .30728 Metetra
.674 .725 .888 r
.62334 .30728 .63137 .31828 .64741 .31198 .63946 .30129 Metetra
.669 .731 .896 r
.63946 .30129 .64741 .31198 .66356 .30601 .65567 .2955 Metetra
.667 .735 .901 r
.65567 .2955 .66356 .30601 .6798 .30023 .67199 .2898 Metetra
.665 .738 .904 r
.67199 .2898 .6798 .30023 .69614 .29454 .6884 .28414 Metetra
.664 .739 .906 r
.6884 .28414 .69614 .29454 .71258 .2889 .7049 .27848 Metetra
.664 .74 .907 r
.7049 .27848 .71258 .2889 .72911 .28326 .72151 .2728 Metetra
.664 .74 .907 r
.72151 .2728 .72911 .28326 .74575 .2776 .73821 .26709 Metetra
.664 .741 .907 r
.73821 .26709 .74575 .2776 .76248 .27192 .75501 .26135 Metetra
.664 .741 .907 r
.75501 .26135 .76248 .27192 .77931 .26621 .77191 .25558 Metetra
.664 .741 .907 r
.77191 .25558 .77931 .26621 .79623 .26047 .7889 .24978 Metetra
.664 .741 .907 r
.7889 .24978 .79623 .26047 .81326 .25469 .806 .24394 Metetra
.664 .741 .907 r
.806 .24394 .81326 .25469 .83039 .24888 .8232 .23807 Metetra
.664 .741 .907 r
.8232 .23807 .83039 .24888 .84762 .24304 .84051 .23216 Metetra
.65 .735 .912 r
.22472 .43082 .23416 .43974 .24807 .43554 .23868 .42652 Metetra
.636 .73 .916 r
.23868 .42652 .24807 .43554 .26203 .43175 .25269 .42266 Metetra
.614 .723 .923 r
.25269 .42266 .26203 .43175 .27603 .42861 .26672 .4195 Metetra
.576 .711 .934 r
.26672 .4195 .27603 .42861 .29004 .4264 .28076 .4174 Metetra
.513 .691 .948 r
.28076 .4174 .29004 .4264 .30407 .42542 .2948 .41675 Metetra
.413 .656 .959 r
.2948 .41675 .30407 .42542 .31812 .42592 .30883 .41787 Metetra
.263 .597 .951 r
.30883 .41787 .31812 .42592 .3322 .42798 .32288 .42085 Metetra
.074 .509 .899 r
.32288 .42085 .3322 .42798 .34634 .43142 .33698 .42548 Metetra
0 .42 .812 r
.33698 .42548 .34634 .43142 .36059 .43575 .3512 .43106 Metetra
0 .391 .75 r
.3512 .43106 .36059 .43575 .375 .44011 .3656 .43646 Metetra
0 .473 .782 r
.3656 .43646 .375 .44011 .38962 .44343 .38025 .44025 Metetra
.168 .67 .909 r
.38025 .44025 .38962 .44343 .40448 .44456 .39518 .44103 Metetra
.508 .847 .996 r
.39518 .44103 .40448 .44456 .41958 .44258 .4104 .43778 Metetra
.72 .874 .953 r
.4104 .43778 .41958 .44258 .43489 .43699 .42585 .43015 Metetra
.795 .829 .878 r
.42585 .43015 .43489 .43699 .45037 .42787 .44147 .41859 Metetra
.811 .78 .823 r
.44147 .41859 .45037 .42787 .46595 .41584 .45717 .40418 Metetra
.806 .741 .792 r
.45717 .40418 .46595 .41584 .48157 .40191 .4729 .38837 Metetra
.792 .714 .778 r
.4729 .38837 .48157 .40191 .49721 .38723 .48861 .37254 Metetra
.775 .696 .776 r
.48861 .37254 .49721 .38723 .51284 .37283 .5043 .35779 Metetra
.757 .686 .784 r
.5043 .35779 .51284 .37283 .52847 .35947 .51998 .34473 Metetra
.738 .684 .798 r
.51998 .34473 .52847 .35947 .54412 .34757 .53569 .33355 Metetra
.721 .688 .818 r
.53569 .33355 .54412 .34757 .55981 .33723 .55144 .32409 Metetra
.705 .696 .839 r
.55144 .32409 .55981 .33723 .57556 .32831 .56726 .31602 Metetra
.691 .706 .859 r
.56726 .31602 .57556 .32831 .5914 .32054 .58316 .30896 Metetra
.681 .716 .876 r
.58316 .30896 .5914 .32054 .60732 .31362 .59915 .30256 Metetra
.673 .725 .888 r
.59915 .30256 .60732 .31362 .62334 .30728 .61524 .29655 Metetra
.669 .731 .896 r
.61524 .29655 .62334 .30728 .63946 .30129 .63143 .29075 Metetra
.666 .735 .902 r
.63143 .29075 .63946 .30129 .65567 .2955 .64771 .28504 Metetra
.665 .738 .904 r
.64771 .28504 .65567 .2955 .67199 .2898 .66409 .27936 Metetra
.664 .739 .906 r
.66409 .27936 .67199 .2898 .6884 .28414 .68057 .27368 Metetra
.664 .74 .907 r
.68057 .27368 .6884 .28414 .7049 .27848 .69714 .26797 Metetra
.664 .741 .907 r
.69714 .26797 .7049 .27848 .72151 .2728 .71382 .26224 Metetra
.664 .741 .907 r
.71382 .26224 .72151 .2728 .73821 .26709 .73059 .25647 Metetra
.664 .741 .907 r
.73059 .25647 .73821 .26709 .75501 .26135 .74745 .25067 Metetra
.664 .741 .907 r
.74745 .25067 .75501 .26135 .77191 .25558 .76442 .24484 Metetra
.664 .741 .907 r
.76442 .24484 .77191 .25558 .7889 .24978 .78149 .23897 Metetra
.664 .741 .907 r
.78149 .23897 .7889 .24978 .806 .24394 .79866 .23307 Metetra
.664 .741 .907 r
.79866 .23307 .806 .24394 .8232 .23807 .81594 .22713 Metetra
.664 .741 .907 r
.81594 .22713 .8232 .23807 .84051 .23216 .83332 .22116 Metetra
.651 .736 .911 r
.21519 .42182 .22472 .43082 .23868 .42652 .22919 .41744 Metetra
.637 .731 .916 r
.22919 .41744 .23868 .42652 .25269 .42266 .24324 .4135 Metetra
.612 .723 .924 r
.24324 .4135 .25269 .42266 .26672 .4195 .25731 .41033 Metetra
.568 .709 .936 r
.25731 .41033 .26672 .4195 .28076 .4174 .27137 .40838 Metetra
.491 .683 .952 r
.27137 .40838 .28076 .4174 .2948 .41675 .28541 .40812 Metetra
.36 .634 .958 r
.28541 .40812 .2948 .41675 .30883 .41787 .29942 .40998 Metetra
.156 .542 .925 r
.29942 .40998 .30883 .41787 .32288 .42085 .31342 .4141 Metetra
0 .405 .818 r
.31342 .4141 .32288 .42085 .33698 .42548 .32747 .42013 Metetra
0 .289 .68 r
.32747 .42013 .33698 .42548 .3512 .43106 .34164 .42714 Metetra
.311 0 0 r
.34164 .42714 .3512 .43106 .3656 .43646 .35603 .43358 Metetra
0 .417 .704 r
.35603 .43358 .3656 .43646 .38025 .44025 .37072 .4376 Metetra
.208 .707 .913 r
.37072 .4376 .38025 .44025 .39518 .44103 .38576 .43751 Metetra
.612 .885 .99 r
.38576 .43751 .39518 .44103 .4104 .43778 .40112 .4323 Metetra
.781 .862 .91 r
.40112 .4323 .4104 .43778 .42585 .43015 .41674 .42196 Metetra
.82 .801 .834 r
.41674 .42196 .42585 .43015 .44147 .41859 .43252 .40752 Metetra
.819 .752 .79 r
.43252 .40752 .44147 .41859 .45717 .40418 .44835 .39067 Metetra
.805 .718 .769 r
.44835 .39067 .45717 .40418 .4729 .38837 .46418 .37328 Metetra
.786 .695 .764 r
.46418 .37328 .4729 .38837 .48861 .37254 .47996 .35686 Metetra
.766 .683 .771 r
.47996 .35686 .48861 .37254 .5043 .35779 .4957 .34236 Metetra
.746 .679 .786 r
.4957 .34236 .5043 .35779 .51998 .34473 .51143 .33012 Metetra
.726 .683 .808 r
.51143 .33012 .51998 .34473 .53569 .33355 .52719 .31999 Metetra
.708 .692 .832 r
.52719 .31999 .53569 .33355 .55144 .32409 .543 .31155 Metetra
.693 .703 .855 r
.543 .31155 .55144 .32409 .56726 .31602 .55888 .30431 Metetra
.681 .715 .874 r
.55888 .30431 .56726 .31602 .58316 .30896 .57485 .29783 Metetra
.673 .724 .888 r
.57485 .29783 .58316 .30896 .59915 .30256 .59091 .2918 Metetra
.668 .731 .897 r
.59091 .2918 .59915 .30256 .61524 .29655 .60707 .28598 Metetra
.666 .736 .902 r
.60707 .28598 .61524 .29655 .63143 .29075 .62332 .28026 Metetra
.665 .738 .905 r
.62332 .28026 .63143 .29075 .64771 .28504 .63967 .27456 Metetra
.664 .74 .906 r
.63967 .27456 .64771 .28504 .66409 .27936 .65612 .26885 Metetra
.664 .74 .907 r
.65612 .26885 .66409 .27936 .68057 .27368 .67266 .26312 Metetra
.664 .741 .907 r
.67266 .26312 .68057 .27368 .69714 .26797 .6893 .25736 Metetra
.664 .741 .907 r
.6893 .25736 .69714 .26797 .71382 .26224 .70604 .25157 Metetra
.664 .741 .907 r
.70604 .25157 .71382 .26224 .73059 .25647 .72288 .24574 Metetra
.664 .741 .907 r
.72288 .24574 .73059 .25647 .74745 .25067 .73982 .23988 Metetra
.664 .741 .907 r
.73982 .23988 .74745 .25067 .76442 .24484 .75686 .23398 Metetra
.664 .741 .907 r
.75686 .23398 .76442 .24484 .78149 .23897 .774 .22805 Metetra
.664 .741 .907 r
.774 .22805 .78149 .23897 .79866 .23307 .79125 .22208 Metetra
.664 .741 .907 r
.79125 .22208 .79866 .23307 .81594 .22713 .80859 .21608 Metetra
.664 .741 .907 r
.80859 .21608 .81594 .22713 .83332 .22116 .82605 .21004 Metetra
.652 .736 .911 r
.20556 .41275 .21519 .42182 .22919 .41744 .21961 .40828 Metetra
.638 .731 .916 r
.21961 .40828 .22919 .41744 .24324 .4135 .2337 .40427 Metetra
.611 .723 .925 r
.2337 .40427 .24324 .4135 .25731 .41033 .24781 .40111 Metetra
.559 .706 .939 r
.24781 .40111 .25731 .41033 .27137 .40838 .26189 .39934 Metetra
.463 .673 .955 r
.26189 .39934 .27137 .40838 .28541 .40812 .27592 .39958 Metetra
.287 .601 .951 r
.27592 .39958 .28541 .40812 .29942 .40998 .28988 .40235 Metetra
.011 .456 .869 r
.28988 .40235 .29942 .40998 .31342 .4141 .30381 .40784 Metetra
0 .264 .683 r
.30381 .40784 .31342 .4141 .32747 .42013 .31778 .41555 Metetra
.44 0 0 r
.31778 .41555 .32747 .42013 .34164 .42714 .33189 .42414 Metetra
.431 0 0 r
.33189 .42414 .34164 .42714 .35603 .43358 .34627 .43152 Metetra
.206 0 0 r
.34627 .43152 .35603 .43358 .37072 .4376 .36103 .43533 Metetra
.324 .784 .945 r
.36103 .43533 .37072 .4376 .38576 .43751 .37621 .43362 Metetra
.723 .899 .958 r
.37621 .43362 .38576 .43751 .40112 .4323 .39177 .42559 Metetra
.822 .832 .856 r
.39177 .42559 .40112 .4323 .41674 .42196 .40759 .41188 Metetra
.831 .768 .792 r
.40759 .41188 .41674 .42196 .43252 .40752 .42355 .39432 Metetra
.818 .724 .762 r
.42355 .39432 .43252 .40752 .44835 .39067 .43951 .37528 Metetra
.798 .696 .752 r
.43951 .37528 .44835 .39067 .46418 .37328 .45542 .3569 Metetra
.776 .68 .757 r
.45542 .3569 .46418 .37328 .47996 .35686 .47125 .34063 Metetra
.754 .674 .773 r
.47125 .34063 .47996 .35686 .4957 .34236 .48704 .32705 Metetra
.733 .677 .796 r
.48704 .32705 .4957 .34236 .51143 .33012 .50281 .31605 Metetra
.713 .687 .823 r
.50281 .31605 .51143 .33012 .52719 .31999 .51862 .30713 Metetra
.695 .7 .85 r
.51862 .30713 .52719 .31999 .543 .31155 .53448 .29967 Metetra
.682 .713 .872 r
.53448 .29967 .543 .31155 .55888 .30431 .55043 .2931 Metetra
.673 .724 .887 r
.55043 .2931 .55888 .30431 .57485 .29783 .56646 .28703 Metetra
.668 .732 .897 r
.56646 .28703 .57485 .29783 .59091 .2918 .58259 .2812 Metetra
.666 .736 .903 r
.58259 .2812 .59091 .2918 .60707 .28598 .59881 .27546 Metetra
.665 .739 .905 r
.59881 .27546 .60707 .28598 .62332 .28026 .61513 .26974 Metetra
.664 .74 .906 r
.61513 .26974 .62332 .28026 .63967 .27456 .63155 .26401 Metetra
.664 .74 .907 r
.63155 .26401 .63967 .27456 .65612 .26885 .64806 .25825 Metetra
.664 .741 .907 r
.64806 .25825 .65612 .26885 .67266 .26312 .66467 .25246 Metetra
.664 .741 .907 r
.66467 .25246 .67266 .26312 .6893 .25736 .68138 .24664 Metetra
.664 .741 .907 r
.68138 .24664 .6893 .25736 .70604 .25157 .69818 .24078 Metetra
.664 .741 .907 r
.69818 .24078 .70604 .25157 .72288 .24574 .71509 .23489 Metetra
.664 .741 .907 r
.71509 .23489 .72288 .24574 .73982 .23988 .7321 .22896 Metetra
.664 .741 .907 r
.7321 .22896 .73982 .23988 .75686 .23398 .74921 .223 Metetra
.664 .741 .907 r
.74921 .223 .75686 .23398 .774 .22805 .76643 .217 Metetra
.664 .741 .907 r
.76643 .217 .774 .22805 .79125 .22208 .78374 .21097 Metetra
.664 .741 .907 r
.78374 .21097 .79125 .22208 .80859 .21608 .80116 .2049 Metetra
.664 .741 .907 r
.80116 .2049 .80859 .21608 .82605 .21004 .81869 .19879 Metetra
.653 .737 .911 r
.19583 .4036 .20556 .41275 .21961 .40828 .20993 .39905 Metetra
.638 .732 .916 r
.20993 .39905 .21961 .40828 .2337 .40427 .22407 .39497 Metetra
.608 .723 .926 r
.22407 .39497 .2337 .40427 .24781 .40111 .2382 .39184 Metetra
.547 .703 .942 r
.2382 .39184 .24781 .40111 .26189 .39934 .25229 .39031 Metetra
.424 .658 .957 r
.25229 .39031 .26189 .39934 .27592 .39958 .2663 .39117 Metetra
.185 .548 .93 r
.2663 .39117 .27592 .39958 .28988 .40235 .2802 .39509 Metetra
0 .329 .764 r
.2802 .39509 .28988 .40235 .30381 .40784 .29404 .40226 Metetra
.47 0 0 r
.29404 .40226 .30381 .40784 .31778 .41555 .30789 .41193 Metetra
.574 0 0 r
.30789 .41193 .31778 .41555 .33189 .42414 .32193 .42219 Metetra
.511 0 0 r
.32193 .42219 .33189 .42414 .34627 .43152 .33631 .43024 Metetra
.176 0 0 r
.33631 .43024 .34627 .43152 .36103 .43533 .35119 .43311 Metetra
.516 .88 .98 r
.35119 .43311 .36103 .43533 .37621 .43362 .36657 .42877 Metetra
.806 .878 .899 r
.36657 .42877 .37621 .43362 .39177 .42559 .38238 .41699 Metetra
.843 .793 .803 r
.38238 .41699 .39177 .42559 .40759 .41188 .39844 .39939 Metetra
.832 .736 .758 r
.39844 .39939 .40759 .41188 .42355 .39432 .41457 .37883 Metetra
.812 .7 .741 r
.41457 .37883 .42355 .39432 .43951 .37528 .43065 .35823 Metetra
.788 .678 .743 r
.43065 .35823 .43951 .37528 .45542 .3569 .44662 .33978 Metetra
.764 .669 .758 r
.44662 .33978 .45542 .3569 .47125 .34063 .46249 .32449 Metetra
.74 .671 .783 r
.46249 .32449 .47125 .34063 .48704 .32705 .4783 .31236 Metetra
.718 .681 .813 r
.4783 .31236 .48704 .32705 .50281 .31605 .49411 .30282 Metetra
.698 .696 .844 r
.49411 .30282 .50281 .31605 .51862 .30713 .50996 .29505 Metetra
.683 .711 .869 r
.50996 .29505 .51862 .30713 .53448 .29967 .52588 .28837 Metetra
.674 .723 .887 r
.52588 .28837 .53448 .29967 .55043 .2931 .54189 .28225 Metetra
.668 .732 .897 r
.54189 .28225 .55043 .2931 .56646 .28703 .55799 .2764 Metetra
.665 .736 .903 r
.55799 .2764 .56646 .28703 .58259 .2812 .57418 .27064 Metetra
.664 .739 .906 r
.57418 .27064 .58259 .2812 .59881 .27546 .59047 .2649 Metetra
.664 .74 .907 r
.59047 .2649 .59881 .27546 .61513 .26974 .60685 .25914 Metetra
.664 .741 .907 r
.60685 .25914 .61513 .26974 .63155 .26401 .62333 .25335 Metetra
.664 .741 .907 r
.62333 .25335 .63155 .26401 .64806 .25825 .63991 .24754 Metetra
.664 .741 .907 r
.63991 .24754 .64806 .25825 .66467 .25246 .65659 .24169 Metetra
.664 .741 .907 r
.65659 .24169 .66467 .25246 .68138 .24664 .67336 .2358 Metetra
.664 .741 .907 r
.67336 .2358 .68138 .24664 .69818 .24078 .69024 .22988 Metetra
.664 .741 .907 r
.69024 .22988 .69818 .24078 .71509 .23489 .70722 .22392 Metetra
.664 .741 .907 r
.70722 .22392 .71509 .23489 .7321 .22896 .7243 .21793 Metetra
.664 .741 .907 r
.7243 .21793 .7321 .22896 .74921 .223 .74148 .2119 Metetra
.664 .741 .907 r
.74148 .2119 .74921 .223 .76643 .217 .75877 .20583 Metetra
.664 .741 .907 r
.75877 .20583 .76643 .217 .78374 .21097 .77616 .19973 Metetra
.664 .741 .907 r
.77616 .19973 .78374 .21097 .80116 .2049 .79365 .19359 Metetra
.664 .741 .907 r
.79365 .19359 .80116 .2049 .81869 .19879 .81126 .18741 Metetra
.654 .737 .911 r
.186 .39438 .19583 .4036 .20993 .39905 .20015 .38974 Metetra
.638 .732 .916 r
.20015 .38974 .20993 .39905 .22407 .39497 .21433 .38562 Metetra
.605 .722 .928 r
.21433 .38562 .22407 .39497 .2382 .39184 .22849 .38254 Metetra
.531 .698 .946 r
.22849 .38254 .2382 .39184 .25229 .39031 .24259 .38132 Metetra
.369 .636 .957 r
.24259 .38132 .25229 .39031 .2663 .39117 .25655 .38297 Metetra
.039 .465 .88 r
.25655 .38297 .2663 .39117 .2802 .39509 .27036 .38834 Metetra
0 .161 .594 r
.27036 .38834 .2802 .39509 .29404 .40226 .28406 .39756 Metetra
.622 .062 0 r
.28406 .39756 .29404 .40226 .30789 .41193 .29778 .40948 Metetra
.662 .108 0 r
.29778 .40948 .30789 .41193 .32193 .42219 .31174 .4214 Metetra
.545 0 0 r
.31174 .4214 .32193 .42219 .33631 .43024 .32617 .42955 Metetra
0 .549 .715 r
.32617 .42955 .33631 .43024 .35119 .43311 .34122 .43041 Metetra
.713 .926 .963 r
.34122 .43041 .35119 .43311 .36657 .42877 .35688 .42221 Metetra
.849 .832 .83 r
.35688 .42221 .36657 .42877 .38238 .41699 .373 .40578 Metetra
.847 .753 .759 r
.373 .40578 .38238 .41699 .39844 .39939 .38931 .38417 Metetra
.826 .706 .732 r
.38931 .38417 .39844 .39939 .41457 .37883 .40561 .36121 Metetra
.801 .678 .729 r
.40561 .36121 .41457 .37883 .43065 .35823 .42177 .34012 Metetra
.775 .665 .742 r
.42177 .34012 .43065 .35823 .44662 .33978 .43777 .32263 Metetra
.749 .664 .768 r
.43777 .32263 .44662 .33978 .46249 .32449 .45365 .30903 Metetra
.724 .674 .801 r
.45365 .30903 .46249 .32449 .4783 .31236 .46948 .29864 Metetra
.702 .69 .836 r
.46948 .29864 .4783 .31236 .49411 .30282 .48532 .29048 Metetra
.685 .708 .865 r
.48532 .29048 .49411 .30282 .50996 .29505 .50122 .28364 Metetra
.674 .722 .885 r
.50122 .28364 .50996 .29505 .52588 .28837 .5172 .27746 Metetra
.668 .731 .897 r
.5172 .27746 .52588 .28837 .54189 .28225 .53327 .27158 Metetra
.665 .737 .903 r
.53327 .27158 .54189 .28225 .55799 .2764 .54943 .2658 Metetra
.664 .739 .906 r
.54943 .2658 .55799 .2764 .57418 .27064 .56568 .26003 Metetra
.664 .74 .907 r
.56568 .26003 .57418 .27064 .59047 .2649 .58203 .25425 Metetra
.664 .741 .907 r
.58203 .25425 .59047 .2649 .60685 .25914 .59848 .24843 Metetra
.664 .741 .907 r
.59848 .24843 .60685 .25914 .62333 .25335 .61503 .24259 Metetra
.664 .741 .907 r
.61503 .24259 .62333 .25335 .63991 .24754 .63167 .23671 Metetra
.664 .741 .907 r
.63167 .23671 .63991 .24754 .65659 .24169 .64842 .23079 Metetra
.664 .741 .907 r
.64842 .23079 .65659 .24169 .67336 .2358 .66526 .22484 Metetra
.664 .741 .907 r
.66526 .22484 .67336 .2358 .69024 .22988 .68221 .21885 Metetra
.664 .741 .907 r
.68221 .21885 .69024 .22988 .70722 .22392 .69925 .21283 Metetra
.664 .741 .907 r
.69925 .21283 .70722 .22392 .7243 .21793 .7164 .20677 Metetra
.664 .741 .907 r
.7164 .20677 .7243 .21793 .74148 .2119 .73366 .20067 Metetra
.664 .741 .907 r
.73366 .20067 .74148 .2119 .75877 .20583 .75102 .19454 Metetra
.664 .741 .907 r
.75102 .19454 .75877 .20583 .77616 .19973 .76848 .18837 Metetra
.664 .741 .907 r
.76848 .18837 .77616 .19973 .79365 .19359 .78606 .18216 Metetra
.664 .741 .907 r
.78606 .18216 .79365 .19359 .81126 .18741 .80374 .17591 Metetra
.654 .738 .911 r
.17608 .38507 .186 .39438 .20015 .38974 .19027 .38036 Metetra
.638 .733 .917 r
.19027 .38036 .20015 .38974 .21433 .38562 .20449 .3762 Metetra
.599 .721 .93 r
.20449 .3762 .21433 .38562 .22849 .38254 .21868 .37321 Metetra
.508 .691 .95 r
.21868 .37321 .22849 .38254 .24259 .38132 .23276 .37243 Metetra
.29 .599 .95 r
.23276 .37243 .24259 .38132 .25655 .38297 .24666 .37511 Metetra
0 .333 .776 r
.24666 .37511 .25655 .38297 .27036 .38834 .26034 .3823 Metetra
.579 .022 0 r
.26034 .3823 .27036 .38834 .28406 .39756 .27386 .39401 Metetra
.721 .189 0 r
.27386 .39401 .28406 .39756 .29778 .40948 .28741 .40844 Metetra
.709 .181 0 r
.28741 .40844 .29778 .40948 .31174 .4214 .3013 .42174 Metetra
.529 0 0 r
.3013 .42174 .31174 .4214 .32617 .42955 .31584 .42903 Metetra
.282 .779 .875 r
.31584 .42903 .32617 .42955 .34122 .43041 .33118 .42642 Metetra
.831 .894 .886 r
.33118 .42642 .34122 .43041 .35688 .42221 .34722 .41302 Metetra
.862 .781 .77 r
.34722 .41302 .35688 .42221 .373 .40578 .36368 .3914 Metetra
.842 .717 .726 r
.36368 .3914 .373 .40578 .38931 .38417 .38024 .36622 Metetra
.815 .681 .716 r
.38024 .36622 .38931 .38417 .40561 .36121 .39666 .34206 Metetra
.787 .662 .726 r
.39666 .34206 .40561 .36121 .42177 .34012 .41285 .32178 Metetra
.759 .658 .751 r
.41285 .32178 .42177 .34012 .43777 .32263 .42883 .30621 Metetra
.732 .667 .786 r
.42883 .30621 .43777 .32263 .45365 .30903 .44471 .29468 Metetra
.707 .684 .825 r
.44471 .29468 .45365 .30903 .46948 .29864 .46055 .28598 Metetra
.688 .704 .86 r
.46055 .28598 .46948 .29864 .48532 .29048 .47644 .27891 Metetra
.675 .721 .884 r
.47644 .27891 .48532 .29048 .50122 .28364 .49239 .27266 Metetra
.668 .731 .897 r
.49239 .27266 .50122 .28364 .5172 .27746 .50842 .26674 Metetra
.665 .737 .903 r
.50842 .26674 .5172 .27746 .53327 .27158 .52455 .26094 Metetra
.664 .739 .906 r
.52455 .26094 .53327 .27158 .54943 .2658 .54077 .25514 Metetra
.664 .74 .907 r
.54077 .25514 .54943 .2658 .56568 .26003 .55709 .24933 Metetra
.664 .741 .907 r
.55709 .24933 .56568 .26003 .58203 .25425 .57351 .24349 Metetra
.664 .741 .907 r
.57351 .24349 .58203 .25425 .59848 .24843 .59002 .23761 Metetra
.664 .741 .907 r
.59002 .23761 .59848 .24843 .61503 .24259 .60663 .2317 Metetra
.664 .741 .907 r
.60663 .2317 .61503 .24259 .63167 .23671 .62334 .22576 Metetra
.664 .741 .907 r
.62334 .22576 .63167 .23671 .64842 .23079 .64016 .21978 Metetra
.664 .741 .907 r
.64016 .21978 .64842 .23079 .66526 .22484 .65707 .21376 Metetra
.664 .741 .907 r
.65707 .21376 .66526 .22484 .68221 .21885 .67408 .2077 Metetra
.664 .741 .907 r
.67408 .2077 .68221 .21885 .69925 .21283 .6912 .20161 Metetra
.664 .741 .907 r
.6912 .20161 .69925 .21283 .7164 .20677 .70842 .19548 Metetra
.664 .741 .907 r
.70842 .19548 .7164 .20677 .73366 .20067 .72575 .18932 Metetra
.664 .741 .907 r
.72575 .18932 .73366 .20067 .75102 .19454 .74319 .18312 Metetra
.664 .741 .907 r
.74319 .18312 .75102 .19454 .76848 .18837 .76073 .17687 Metetra
.664 .741 .907 r
.76073 .17687 .76848 .18837 .78606 .18216 .77837 .17059 Metetra
.664 .741 .907 r
.77837 .17059 .78606 .18216 .80374 .17591 .79613 .16428 Metetra
.655 .738 .911 r
.16605 .37567 .17608 .38507 .19027 .38036 .18029 .3709 Metetra
.637 .733 .918 r
.18029 .3709 .19027 .38036 .20449 .3762 .19454 .36672 Metetra
.592 .72 .933 r
.19454 .36672 .20449 .3762 .21868 .37321 .20875 .3639 Metetra
.476 .68 .955 r
.20875 .3639 .21868 .37321 .23276 .37243 .22281 .3637 Metetra
.169 .537 .925 r
.22281 .3637 .23276 .37243 .24666 .37511 .23661 .36773 Metetra
0 .15 .596 r
.23661 .36773 .24666 .37511 .26034 .3823 .2501 .37722 Metetra
.715 .182 0 r
.2501 .37722 .26034 .3823 .27386 .39401 .26338 .39192 Metetra
.776 .279 .022 r
.26338 .39192 .27386 .39401 .28741 .40844 .27675 .40897 Metetra
.725 .218 .021 r
.27675 .40897 .28741 .40844 .3013 .42174 .29063 .42299 Metetra
.432 0 0 r
.29063 .42299 .3013 .42174 .31584 .42903 .30539 .4279 Metetra
.665 .947 .958 r
.30539 .4279 .31584 .42903 .33118 .42642 .32113 .42004 Metetra
.872 .829 .801 r
.32113 .42004 .33118 .42642 .34722 .41302 .33764 .40031 Metetra
.859 .736 .726 r
.33764 .40031 .34722 .41302 .36368 .3914 .35446 .37361 Metetra
.831 .687 .705 r
.35446 .37361 .36368 .3914 .38024 .36622 .37122 .3461 Metetra
.801 .662 .71 r
.37122 .3461 .38024 .36622 .39666 .34206 .38768 .32235 Metetra
.77 .652 .732 r
.38768 .32235 .39666 .34206 .41285 .32178 .40384 .30415 Metetra
.741 .658 .769 r
.40384 .30415 .41285 .32178 .42883 .30621 .41979 .29106 Metetra
.714 .676 .812 r
.41979 .29106 .42883 .30621 .44471 .29468 .43566 .28159 Metetra
.691 .699 .853 r
.43566 .28159 .44471 .29468 .46055 .28598 .45152 .27421 Metetra
.676 .718 .881 r
.45152 .27421 .46055 .28598 .47644 .27891 .46745 .26785 Metetra
.668 .731 .896 r
.46745 .26785 .47644 .27891 .49239 .27266 .48345 .26189 Metetra
.665 .737 .903 r
.48345 .26189 .49239 .27266 .50842 .26674 .49955 .25605 Metetra
.664 .739 .906 r
.49955 .25605 .50842 .26674 .52455 .26094 .51574 .25023 Metetra
.664 .74 .907 r
.51574 .25023 .52455 .26094 .54077 .25514 .53202 .24439 Metetra
.664 .741 .907 r
.53202 .24439 .54077 .25514 .55709 .24933 .54841 .23852 Metetra
.664 .741 .907 r
.54841 .23852 .55709 .24933 .57351 .24349 .56489 .23261 Metetra
.664 .741 .907 r
.56489 .23261 .57351 .24349 .59002 .23761 .58146 .22667 Metetra
.664 .741 .907 r
.58146 .22667 .59002 .23761 .60663 .2317 .59814 .2207 Metetra
.664 .741 .907 r
.59814 .2207 .60663 .2317 .62334 .22576 .61492 .21469 Metetra
.664 .741 .907 r
.61492 .21469 .62334 .22576 .64016 .21978 .6318 .20864 Metetra
.664 .741 .907 r
.6318 .20864 .64016 .21978 .65707 .21376 .64878 .20255 Metetra
.664 .741 .907 r
.64878 .20255 .65707 .21376 .67408 .2077 .66587 .19643 Metetra
.664 .741 .907 r
.66587 .19643 .67408 .2077 .6912 .20161 .68306 .19027 Metetra
.664 .741 .907 r
.68306 .19027 .6912 .20161 .70842 .19548 .70035 .18407 Metetra
.664 .741 .907 r
.70035 .18407 .70842 .19548 .72575 .18932 .71775 .17784 Metetra
.664 .741 .907 r
.71775 .17784 .72575 .18932 .74319 .18312 .73526 .17156 Metetra
.664 .741 .907 r
.73526 .17156 .74319 .18312 .76073 .17687 .75288 .16525 Metetra
.664 .741 .907 r
.75288 .16525 .76073 .17687 .77837 .17059 .7706 .1589 Metetra
.664 .741 .907 r
.7706 .1589 .77837 .17059 .79613 .16428 .78844 .15251 Metetra
.655 .738 .911 r
.15591 .36619 .16605 .37567 .18029 .3709 .1702 .36137 Metetra
.635 .733 .919 r
.1702 .36137 .18029 .3709 .19454 .36672 .18449 .3572 Metetra
.581 .717 .936 r
.18449 .3572 .19454 .36672 .20875 .3639 .1987 .35462 Metetra
.426 .662 .959 r
.1987 .35462 .20875 .3639 .22281 .3637 .21271 .35524 Metetra
0 .429 .856 r
.21271 .35524 .22281 .3637 .23661 .36773 .22636 .36105 Metetra
.603 .054 0 r
.22636 .36105 .23661 .36773 .2501 .37722 .2396 .37346 Metetra
.793 .298 .006 r
.2396 .37346 .2501 .37722 .26338 .39192 .25259 .39162 Metetra
.801 .333 .121 r
.25259 .39162 .26338 .39192 .27675 .40897 .26578 .41112 Metetra
.712 .214 .055 r
.26578 .41112 .27675 .40897 .29063 .42299 .27974 .42458 Metetra
.136 0 0 r
.27974 .42458 .29063 .42299 .30539 .4279 .29489 .42503 Metetra
.852 .912 .874 r
.29489 .42503 .30539 .4279 .32113 .42004 .3112 .41006 Metetra
.877 .767 .738 r
.3112 .41006 .32113 .42004 .33764 .40031 .32822 .38348 Metetra
.848 .699 .698 r
.32822 .38348 .33764 .40031 .35446 .37361 .34536 .3528 Metetra
.816 .664 .694 r
.34536 .3528 .35446 .37361 .37122 .3461 .3622 .32488 Metetra
.783 .648 .713 r
.3622 .32488 .37122 .3461 .38768 .32235 .37863 .30322 Metetra
.752 .65 .749 r
.37863 .30322 .38768 .32235 .40384 .30415 .39471 .28795 Metetra
.722 .667 .796 r
.39471 .28795 .40384 .30415 .41979 .29106 .41062 .27738 Metetra
.696 .693 .843 r
.41062 .27738 .41979 .29106 .43566 .28159 .42649 .26955 Metetra
.678 .715 .877 r
.42649 .26955 .43566 .28159 .45152 .27421 .44239 .26303 Metetra
.669 .729 .895 r
.44239 .26303 .45152 .27421 .46745 .26785 .45836 .25701 Metetra
.665 .737 .903 r
.45836 .25701 .46745 .26785 .48345 .26189 .47442 .25114 Metetra
.664 .739 .906 r
.47442 .25114 .48345 .26189 .49955 .25605 .49058 .24529 Metetra
.664 .74 .907 r
.49058 .24529 .49955 .25605 .51574 .25023 .50683 .23943 Metetra
.664 .741 .907 r
.50683 .23943 .51574 .25023 .53202 .24439 .52318 .23353 Metetra
.664 .741 .907 r
.52318 .23353 .53202 .24439 .54841 .23852 .53962 .22759 Metetra
.664 .741 .907 r
.53962 .22759 .54841 .23852 .56489 .23261 .55617 .22162 Metetra
.664 .741 .907 r
.55617 .22162 .56489 .23261 .58146 .22667 .57281 .21561 Metetra
.664 .741 .907 r
.57281 .21561 .58146 .22667 .59814 .2207 .58956 .20957 Metetra
.664 .741 .907 r
.58956 .20957 .59814 .2207 .61492 .21469 .60641 .20349 Metetra
.664 .741 .907 r
.60641 .20349 .61492 .21469 .6318 .20864 .62335 .19737 Metetra
.664 .741 .907 r
.62335 .19737 .6318 .20864 .64878 .20255 .64041 .19122 Metetra
.664 .741 .907 r
.64041 .19122 .64878 .20255 .66587 .19643 .65756 .18503 Metetra
.664 .741 .907 r
.65756 .18503 .66587 .19643 .68306 .19027 .67482 .1788 Metetra
.664 .741 .907 r
.67482 .1788 .68306 .19027 .70035 .18407 .69219 .17253 Metetra
.664 .741 .907 r
.69219 .17253 .70035 .18407 .71775 .17784 .70967 .16622 Metetra
.664 .741 .907 r
.70967 .16622 .71775 .17784 .73526 .17156 .72725 .15988 Metetra
.664 .741 .907 r
.72725 .15988 .73526 .17156 .75288 .16525 .74494 .15349 Metetra
.664 .741 .907 r
.74494 .15349 .75288 .16525 .7706 .1589 .76274 .14707 Metetra
.664 .741 .907 r
.76274 .14707 .7706 .1589 .78844 .15251 .78066 .14061 Metetra
.654 .738 .911 r
.14568 .35662 .15591 .36619 .1702 .36137 .16 .35175 Metetra
.632 .732 .92 r
.16 .35175 .1702 .36137 .18449 .3572 .17432 .34764 Metetra
.564 .713 .941 r
.17432 .34764 .18449 .3572 .1987 .35462 .18853 .34545 Metetra
.347 .629 .958 r
.18853 .34545 .1987 .35462 .21271 .35524 .20244 .3472 Metetra
0 .25 .703 r
.20244 .3472 .21271 .35524 .22636 .36105 .21587 .35537 Metetra
.747 .228 0 r
.21587 .35537 .22636 .36105 .2396 .37346 .22878 .37142 Metetra
.83 .373 .133 r
.22878 .37142 .2396 .37346 .25259 .39162 .24144 .3934 Metetra
.805 .36 .185 r
.24144 .3934 .25259 .39162 .26578 .41112 .2545 .41461 Metetra
.659 .152 .029 r
.2545 .41461 .26578 .41112 .27974 .42458 .26871 .42546 Metetra
.511 .911 .899 r
.26871 .42546 .27974 .42458 .29489 .42503 .28446 .41889 Metetra
.892 .823 .773 r
.28446 .41889 .29489 .42503 .3112 .41006 .30146 .3954 Metetra
.866 .719 .697 r
.30146 .3954 .3112 .41006 .32822 .38348 .31899 .36263 Metetra
.832 .67 .682 r
.31899 .36263 .32822 .38348 .34536 .3528 .33632 .33009 Metetra
.798 .646 .694 r
.33632 .33009 .34536 .3528 .3622 .32488 .35313 .30395 Metetra
.764 .642 .727 r
.35313 .30395 .3622 .32488 .37863 .30322 .36944 .28563 Metetra
.732 .657 .776 r
.36944 .28563 .37863 .30322 .39471 .28795 .38544 .27347 Metetra
.703 .684 .829 r
.38544 .27347 .39471 .28795 .41062 .27738 .40132 .26497 Metetra
.681 .71 .87 r
.40132 .26497 .41062 .27738 .42649 .26955 .4172 .25821 Metetra
.67 .728 .893 r
.4172 .25821 .42649 .26955 .44239 .26303 .43314 .25212 Metetra
.665 .736 .903 r
.43314 .25212 .44239 .26303 .45836 .25701 .44917 .24621 Metetra
.664 .739 .906 r
.44917 .24621 .45836 .25701 .47442 .25114 .46529 .24033 Metetra
.664 .74 .907 r
.46529 .24033 .47442 .25114 .49058 .24529 .48151 .23444 Metetra
.664 .741 .907 r
.48151 .23444 .49058 .24529 .50683 .23943 .49782 .22851 Metetra
.664 .741 .907 r
.49782 .22851 .50683 .23943 .52318 .23353 .51424 .22254 Metetra
.664 .741 .907 r
.51424 .22254 .52318 .23353 .53962 .22759 .53075 .21654 Metetra
.664 .741 .907 r
.53075 .21654 .53962 .22759 .55617 .22162 .54736 .2105 Metetra
.664 .741 .907 r
.54736 .2105 .55617 .22162 .57281 .21561 .56407 .20443 Metetra
.664 .741 .907 r
.56407 .20443 .57281 .21561 .58956 .20957 .58088 .19832 Metetra
.664 .741 .907 r
.58088 .19832 .58956 .20957 .60641 .20349 .59779 .19217 Metetra
.664 .741 .907 r
.59779 .19217 .60641 .20349 .62335 .19737 .61481 .18598 Metetra
.664 .741 .907 r
.61481 .18598 .62335 .19737 .64041 .19122 .63193 .17976 Metetra
.664 .741 .907 r
.63193 .17976 .64041 .19122 .65756 .18503 .64916 .1735 Metetra
.664 .741 .907 r
.64916 .1735 .65756 .18503 .67482 .1788 .6665 .1672 Metetra
.664 .741 .907 r
.6665 .1672 .67482 .1788 .69219 .17253 .68394 .16086 Metetra
.664 .741 .907 r
.68394 .16086 .69219 .17253 .70967 .16622 .70149 .15448 Metetra
.664 .741 .907 r
.70149 .15448 .70967 .16622 .72725 .15988 .71914 .14806 Metetra
.664 .741 .907 r
.71914 .14806 .72725 .15988 .74494 .15349 .73691 .1416 Metetra
.664 .741 .907 r
.73691 .1416 .74494 .15349 .76274 .14707 .75479 .1351 Metetra
.664 .741 .907 r
.75479 .1351 .76274 .14707 .78066 .14061 .77278 .12856 Metetra
.654 .738 .912 r
.13533 .34695 .14568 .35662 .16 .35175 .14969 .34206 Metetra
.626 .731 .923 r
.14969 .34206 .16 .35175 .17432 .34764 .16404 .33807 Metetra
.537 .705 .948 r
.16404 .33807 .17432 .34764 .18853 .34545 .17821 .33646 Metetra
.215 .565 .937 r
.17821 .33646 .18853 .34545 .20244 .3472 .19198 .3398 Metetra
.533 0 0 r
.19198 .3398 .20244 .3472 .21587 .35537 .2051 .3511 Metetra
.823 .347 .059 r
.2051 .3511 .21587 .35537 .22878 .37142 .21758 .37156 Metetra
.843 .417 .219 r
.21758 .37156 .22878 .37142 .24144 .3934 .22988 .39736 Metetra
.793 .359 .217 r
.22988 .39736 .24144 .3934 .2545 .41461 .24295 .41871 Metetra
.497 0 0 r
.24295 .41871 .2545 .41461 .26871 .42546 .25768 .42402 Metetra
.866 .935 .866 r
.25768 .42402 .26871 .42546 .28446 .41889 .27427 .40792 Metetra
.886 .753 .709 r
.27427 .40792 .28446 .41889 .30146 .3954 .29202 .37563 Metetra
.85 .682 .674 r
.29202 .37563 .30146 .3954 .31899 .36263 .30992 .33873 Metetra
.814 .648 .677 r
.30992 .33873 .31899 .36263 .33632 .33009 .32727 .30708 Metetra
.779 .637 .704 r
.32727 .30708 .33632 .33009 .35313 .30395 .34393 .28457 Metetra
.744 .646 .752 r
.34393 .28457 .35313 .30395 .36944 .28563 .36009 .27006 Metetra
.711 .673 .811 r
.36009 .27006 .36944 .28563 .38544 .27347 .37601 .26054 Metetra
.686 .704 .861 r
.37601 .26054 .38544 .27347 .40132 .26497 .39188 .25342 Metetra
.671 .725 .89 r
.39188 .25342 .40132 .26497 .4172 .25821 .4078 .24721 Metetra
.666 .736 .902 r
.4078 .24721 .4172 .25821 .43314 .25212 .42379 .24126 Metetra
.664 .739 .906 r
.42379 .24126 .43314 .25212 .44917 .24621 .43988 .23535 Metetra
.664 .74 .907 r
.43988 .23535 .44917 .24621 .46529 .24033 .45606 .22942 Metetra
.664 .741 .907 r
.45606 .22942 .46529 .24033 .48151 .23444 .47234 .22346 Metetra
.664 .741 .907 r
.47234 .22346 .48151 .23444 .49782 .22851 .48872 .21746 Metetra
.664 .741 .907 r
.48872 .21746 .49782 .22851 .51424 .22254 .50519 .21143 Metetra
.664 .741 .907 r
.50519 .21143 .51424 .22254 .53075 .21654 .52177 .20536 Metetra
.664 .741 .907 r
.52177 .20536 .53075 .21654 .54736 .2105 .53844 .19926 Metetra
.664 .741 .907 r
.53844 .19926 .54736 .2105 .56407 .20443 .55522 .19312 Metetra
.664 .741 .907 r
.55522 .19312 .56407 .20443 .58088 .19832 .5721 .18694 Metetra
.664 .741 .907 r
.5721 .18694 .58088 .19832 .59779 .19217 .58909 .18072 Metetra
.664 .741 .907 r
.58909 .18072 .59779 .19217 .61481 .18598 .60617 .17446 Metetra
.664 .741 .907 r
.60617 .17446 .61481 .18598 .63193 .17976 .62337 .16817 Metetra
.664 .741 .907 r
.62337 .16817 .63193 .17976 .64916 .1735 .64067 .16184 Metetra
.664 .741 .907 r
.64067 .16184 .64916 .1735 .6665 .1672 .65807 .15546 Metetra
.664 .741 .907 r
.65807 .15546 .6665 .1672 .68394 .16086 .67559 .14905 Metetra
.664 .741 .907 r
.67559 .14905 .68394 .16086 .70149 .15448 .69321 .1426 Metetra
.664 .741 .907 r
.69321 .1426 .70149 .15448 .71914 .14806 .71095 .13611 Metetra
.664 .741 .907 r
.71095 .13611 .71914 .14806 .73691 .1416 .72879 .12957 Metetra
.664 .741 .907 r
.72879 .12957 .73691 .1416 .75479 .1351 .74675 .123 Metetra
.664 .741 .907 r
.74675 .123 .75479 .1351 .77278 .12856 .76482 .11638 Metetra
.652 .738 .913 r
.12487 .3372 .13533 .34695 .14969 .34206 .13928 .33231 Metetra
.618 .73 .926 r
.13928 .33231 .14969 .34206 .16404 .33807 .15363 .32854 Metetra
.492 .691 .956 r
.15363 .32854 .16404 .33807 .17821 .33646 .16773 .3278 Metetra
0 .434 .859 r
.16773 .3278 .17821 .33646 .19198 .3398 .18127 .33337 Metetra
.728 .203 0 r
.18127 .33337 .19198 .3398 .2051 .3511 .19397 .34876 Metetra
.855 .421 .186 r
.19397 .34876 .2051 .3511 .21758 .37156 .20592 .37431 Metetra
.843 .438 .275 r
.20592 .37431 .21758 .37156 .22988 .39736 .21793 .40325 Metetra
.76 .322 .212 r
.21793 .40325 .22988 .39736 .24295 .41871 .23126 .422 Metetra
.23126 .422 .24295 .41871 .25768 .42402 .24684 .41824 Metetra
.906 .818 .75 r
.24684 .41824 .25768 .42402 .27427 .40792 .26444 .39095 Metetra
.87 .703 .673 r
.26444 .39095 .27427 .40792 .29202 .37563 .28286 .35137 Metetra
.832 .655 .663 r
.28286 .35137 .29202 .37563 .30992 .33873 .30092 .31355 Metetra
.795 .634 .682 r
.30092 .31355 .30992 .33873 .32727 .30708 .31811 .28543 Metetra
.758 .636 .726 r
.31811 .28543 .32727 .30708 .34393 .28457 .33454 .26748 Metetra
.723 .661 .788 r
.33454 .26748 .34393 .28457 .36009 .27006 .35056 .25638 Metetra
.693 .695 .848 r
.35056 .25638 .36009 .27006 .37601 .26054 .36643 .24868 Metetra
.674 .721 .885 r
.36643 .24868 .37601 .26054 .39188 .25342 .38232 .24229 Metetra
.666 .734 .901 r
.38232 .24229 .39188 .25342 .4078 .24721 .39828 .23628 Metetra
.664 .739 .906 r
.39828 .23628 .4078 .24721 .42379 .24126 .41433 .23034 Metetra
.664 .74 .907 r
.41433 .23034 .42379 .24126 .43988 .23535 .43048 .22438 Metetra
.664 .741 .907 r
.43048 .22438 .43988 .23535 .45606 .22942 .44673 .21839 Metetra
.664 .741 .907 r
.44673 .21839 .45606 .22942 .47234 .22346 .46307 .21236 Metetra
.664 .741 .907 r
.46307 .21236 .47234 .22346 .48872 .21746 .47951 .2063 Metetra
.664 .741 .907 r
.47951 .2063 .48872 .21746 .50519 .21143 .49605 .2002 Metetra
.664 .741 .907 r
.49605 .2002 .50519 .21143 .52177 .20536 .51269 .19406 Metetra
.664 .741 .907 r
.51269 .19406 .52177 .20536 .53844 .19926 .52943 .18789 Metetra
.664 .741 .907 r
.52943 .18789 .53844 .19926 .55522 .19312 .54628 .18168 Metetra
.664 .741 .907 r
.54628 .18168 .55522 .19312 .5721 .18694 .56322 .17543 Metetra
.664 .741 .907 r
.56322 .17543 .5721 .18694 .58909 .18072 .58028 .16914 Metetra
.664 .741 .907 r
.58028 .16914 .58909 .18072 .60617 .17446 .59744 .16281 Metetra
.664 .741 .907 r
.59744 .16281 .60617 .17446 .62337 .16817 .6147 .15645 Metetra
.664 .741 .907 r
.6147 .15645 .62337 .16817 .64067 .16184 .63207 .15004 Metetra
.664 .741 .907 r
.63207 .15004 .64067 .16184 .65807 .15546 .64955 .14359 Metetra
.664 .741 .907 r
.64955 .14359 .65807 .15546 .67559 .14905 .66714 .13711 Metetra
.664 .741 .907 r
.66714 .13711 .67559 .14905 .69321 .1426 .68484 .13058 Metetra
.664 .741 .907 r
.68484 .13058 .69321 .1426 .71095 .13611 .70265 .12401 Metetra
.664 .741 .907 r
.70265 .12401 .71095 .13611 .72879 .12957 .72057 .1174 Metetra
.664 .741 .907 r
.72057 .1174 .72879 .12957 .74675 .123 .73861 .11075 Metetra
.664 .741 .907 r
.73861 .11075 .74675 .123 .76482 .11638 .75676 .10406 Metetra
.649 .737 .914 r
.11431 .32735 .12487 .3372 .13928 .33231 .12874 .32251 Metetra
.603 .726 .932 r
.12874 .32251 .13928 .33231 .15363 .32854 .14308 .31912 Metetra
.414 .662 .962 r
.14308 .31912 .15363 .32854 .16773 .3278 .15706 .31969 Metetra
0 .197 .648 r
.15706 .31969 .16773 .3278 .18127 .33337 .17026 .32838 Metetra
.826 .352 .053 r
.17026 .32838 .18127 .33337 .19397 .34876 .18238 .34896 Metetra
.864 .462 .27 r
.18238 .34896 .19397 .34876 .20592 .37431 .19376 .37991 Metetra
.831 .438 .305 r
.19376 .37991 .20592 .37431 .21793 .40325 .20563 .41011 Metetra
.675 .207 .133 r
.20563 .41011 .21793 .40325 .23126 .422 .21962 .42231 Metetra
.861 .964 .867 r
.21962 .42231 .23126 .422 .24684 .41824 .23641 .40617 Metetra
.892 .74 .686 r
.23641 .40617 .24684 .41824 .26444 .39095 .25505 .36791 Metetra
.851 .668 .654 r
.25505 .36791 .26444 .39095 .28286 .35137 .27389 .32438 Metetra
.813 .636 .663 r
.27389 .32438 .28286 .35137 .30092 .31355 .29184 .2892 Metetra
.775 .629 .699 r
.29184 .2892 .30092 .31355 .31811 .28543 .30872 .26628 Metetra
.737 .647 .76 r
.30872 .26628 .31811 .28543 .33454 .26748 .32493 .25269 Metetra
.702 .683 .829 r
.32493 .25269 .33454 .26748 .35056 .25638 .34084 .24406 Metetra
.678 .715 .877 r
.34084 .24406 .35056 .25638 .36643 .24868 .35672 .23738 Metetra
.667 .732 .898 r
.35672 .23738 .36643 .24868 .38232 .24229 .37265 .23129 Metetra
.665 .739 .905 r
.37265 .23129 .38232 .24229 .39828 .23628 .38866 .2253 Metetra
.664 .74 .907 r
.38866 .2253 .39828 .23628 .41433 .23034 .40477 .21931 Metetra
.664 .741 .907 r
.40477 .21931 .41433 .23034 .43048 .22438 .42098 .21329 Metetra
.664 .741 .907 r
.42098 .21329 .43048 .22438 .44673 .21839 .43729 .20724 Metetra
.664 .741 .907 r
.43729 .20724 .44673 .21839 .46307 .21236 .45369 .20114 Metetra
.664 .741 .907 r
.45369 .20114 .46307 .21236 .47951 .2063 .4702 .19501 Metetra
.664 .741 .907 r
.4702 .19501 .47951 .2063 .49605 .2002 .4868 .18884 Metetra
.664 .741 .907 r
.4868 .18884 .49605 .2002 .51269 .19406 .50351 .18264 Metetra
.664 .741 .907 r
.50351 .18264 .51269 .19406 .52943 .18789 .52032 .17639 Metetra
.664 .741 .907 r
.52032 .17639 .52943 .18789 .54628 .18168 .53723 .17011 Metetra
.664 .741 .907 r
.53723 .17011 .54628 .18168 .56322 .17543 .55425 .16379 Metetra
.664 .741 .907 r
.55425 .16379 .56322 .17543 .58028 .16914 .57137 .15743 Metetra
.664 .741 .907 r
.57137 .15743 .58028 .16914 .59744 .16281 .5886 .15103 Metetra
.664 .741 .907 r
.5886 .15103 .59744 .16281 .6147 .15645 .60593 .14459 Metetra
.664 .741 .907 r
.60593 .14459 .6147 .15645 .63207 .15004 .62338 .13811 Metetra
.664 .741 .907 r
.62338 .13811 .63207 .15004 .64955 .14359 .64093 .13159 Metetra
.664 .741 .907 r
.64093 .13159 .64955 .14359 .66714 .13711 .6586 .12503 Metetra
.664 .741 .907 r
.6586 .12503 .66714 .13711 .68484 .13058 .67637 .11842 Metetra
.664 .741 .907 r
.67637 .11842 .68484 .13058 .70265 .12401 .69426 .11178 Metetra
.664 .741 .907 r
.69426 .11178 .70265 .12401 .72057 .1174 .71226 .10509 Metetra
.664 .741 .907 r
.71226 .10509 .72057 .1174 .73861 .11075 .73038 .09836 Metetra
.664 .741 .907 r
.73038 .09836 .73861 .11075 .75676 .10406 .74861 .09159 Metetra
.644 .737 .916 r
.10363 .31741 .11431 .32735 .12874 .32251 .11808 .31269 Metetra
.578 .72 .94 r
.11808 .31269 .12874 .32251 .14308 .31912 .13238 .30994 Metetra
.264 .595 .95 r
.13238 .30994 .14308 .31912 .15706 .31969 .14614 .31249 Metetra
.64 .097 0 r
.14614 .31249 .15706 .31969 .17026 .32838 .15884 .32545 Metetra
.864 .437 .2 r
.15884 .32545 .17026 .32838 .18238 .34896 .17025 .3523 Metetra
.861 .48 .323 r
.17025 .3523 .18238 .34896 .19376 .37991 .18108 .38807 Metetra
.807 .413 .308 r
.18108 .38807 .19376 .37991 .20563 .41011 .19318 .41607 Metetra
.318 0 0 r
.19318 .41607 .20563 .41011 .21962 .42231 .20833 .41704 Metetra
.915 .817 .735 r
.20833 .41704 .21962 .42231 .23641 .40617 .22654 .38671 Metetra
.872 .691 .654 r
.22654 .38671 .23641 .40617 .25505 .36791 .24604 .34018 Metetra
.831 .643 .648 r
.24604 .34018 .25505 .36791 .27389 .32438 .26495 .29711 Metetra
.793 .625 .674 r
.26495 .29711 .27389 .32438 .29184 .2892 .28254 .26733 Metetra
.754 .634 .728 r
.28254 .26733 .29184 .2892 .30872 .26628 .29908 .24989 Metetra
.716 .668 .802 r
.29908 .24989 .30872 .26628 .32493 .25269 .3151 .23968 Metetra
.685 .707 .864 r
.3151 .23968 .32493 .25269 .34084 .24406 .33098 .23251 Metetra
.669 .729 .894 r
.33098 .23251 .34084 .24406 .35672 .23738 .34688 .22628 Metetra
.665 .738 .904 r
.34688 .22628 .35672 .23738 .37265 .23129 .36286 .22024 Metetra
.664 .74 .907 r
.36286 .22024 .37265 .23129 .38866 .2253 .37893 .21422 Metetra
.664 .741 .907 r
.37893 .21422 .38866 .2253 .40477 .21931 .39511 .20817 Metetra
.664 .741 .907 r
.39511 .20817 .40477 .21931 .42098 .21329 .41137 .20208 Metetra
.664 .741 .907 r
.41137 .20208 .42098 .21329 .43729 .20724 .42774 .19596 Metetra
.664 .741 .907 r
.42774 .19596 .43729 .20724 .45369 .20114 .44421 .18979 Metetra
.664 .741 .907 r
.44421 .18979 .45369 .20114 .4702 .19501 .46078 .18359 Metetra
.664 .741 .907 r
.46078 .18359 .4702 .19501 .4868 .18884 .47745 .17736 Metetra
.664 .741 .907 r
.47745 .17736 .4868 .18884 .50351 .18264 .49422 .17108 Metetra
.664 .741 .907 r
.49422 .17108 .50351 .18264 .52032 .17639 .5111 .16476 Metetra
.664 .741 .907 r
.5111 .16476 .52032 .17639 .53723 .17011 .52808 .15841 Metetra
.664 .741 .907 r
.52808 .15841 .53723 .17011 .55425 .16379 .54516 .15202 Metetra
.664 .741 .907 r
.54516 .15202 .55425 .16379 .57137 .15743 .56236 .14558 Metetra
.664 .741 .907 r
.56236 .14558 .57137 .15743 .5886 .15103 .57966 .13911 Metetra
.664 .741 .907 r
.57966 .13911 .5886 .15103 .60593 .14459 .59707 .13259 Metetra
.664 .741 .907 r
.59707 .13259 .60593 .14459 .62338 .13811 .61458 .12604 Metetra
.664 .741 .907 r
.61458 .12604 .62338 .13811 .64093 .13159 .63221 .11944 Metetra
.664 .741 .907 r
.63221 .11944 .64093 .13159 .6586 .12503 .64995 .1128 Metetra
.664 .741 .907 r
.64995 .1128 .6586 .12503 .67637 .11842 .6678 .10612 Metetra
.664 .741 .907 r
.6678 .10612 .67637 .11842 .69426 .11178 .68577 .0994 Metetra
.664 .741 .907 r
.68577 .0994 .69426 .11178 .71226 .10509 .70385 .09263 Metetra
.664 .741 .907 r
.70385 .09263 .71226 .10509 .73038 .09836 .72205 .08582 Metetra
.664 .741 .907 r
.72205 .08582 .73038 .09836 .74861 .09159 .74036 .07897 Metetra
.636 .735 .92 r
.09283 .30741 .10363 .31741 .11808 .31269 .10729 .30292 Metetra
.532 .707 .952 r
.10729 .30292 .11808 .31269 .13238 .30994 .12148 .30121 Metetra
0 .428 .851 r
.12148 .30121 .13238 .30994 .14614 .31249 .13489 .30669 Metetra
.804 .313 0 r
.13489 .30669 .14614 .31249 .15884 .32545 .1469 .32535 Metetra
.874 .482 .291 r
.1469 .32535 .15884 .32545 .17025 .3523 .15748 .35911 Metetra
.85 .481 .351 r
.15748 .35911 .17025 .3523 .18108 .38807 .16797 .39761 Metetra
.755 .341 .266 r
.16797 .39761 .18108 .38807 .19318 .41607 .18086 .41833 Metetra
.808 .992 .873 r
.18086 .41833 .19318 .41607 .20833 .41704 .19765 .40394 Metetra
.895 .731 .671 r
.19765 .40394 .20833 .41704 .22654 .38671 .21727 .3604 Metetra
.851 .657 .64 r
.21727 .3604 .22654 .38671 .24604 .34018 .23721 .31039 Metetra
.812 .627 .653 r
.23721 .31039 .24604 .34018 .26495 .29711 .25582 .27188 Metetra
.773 .624 .696 r
.25582 .27188 .26495 .29711 .28254 .26733 .27294 .24864 Metetra
.733 .651 .769 r
.27294 .24864 .28254 .26733 .29908 .24989 .28918 .23579 Metetra
.696 .694 .844 r
.28918 .23579 .29908 .24989 .3151 .23968 .3051 .22773 Metetra
.673 .724 .888 r
.3051 .22773 .3151 .23968 .33098 .23251 .32098 .22126 Metetra
.666 .736 .903 r
.32098 .22126 .33098 .23251 .34688 .22628 .33693 .21516 Metetra
.664 .74 .906 r
.33693 .21516 .34688 .22628 .36286 .22024 .35296 .2091 Metetra
.664 .741 .907 r
.35296 .2091 .36286 .22024 .37893 .21422 .3691 .20302 Metetra
.664 .741 .907 r
.3691 .20302 .37893 .21422 .39511 .20817 .38533 .1969 Metetra
.664 .741 .907 r
.38533 .1969 .39511 .20817 .41137 .20208 .40166 .19074 Metetra
.664 .741 .907 r
.40166 .19074 .41137 .20208 .42774 .19596 .41809 .18455 Metetra
.664 .741 .907 r
.41809 .18455 .42774 .19596 .44421 .18979 .43462 .17832 Metetra
.664 .741 .907 r
.43462 .17832 .44421 .18979 .46078 .18359 .45126 .17205 Metetra
.664 .741 .907 r
.45126 .17205 .46078 .18359 .47745 .17736 .46799 .16574 Metetra
.664 .741 .907 r
.46799 .16574 .47745 .17736 .49422 .17108 .48483 .15939 Metetra
.664 .741 .907 r
.48483 .15939 .49422 .17108 .5111 .16476 .50177 .153 Metetra
.664 .741 .907 r
.50177 .153 .5111 .16476 .52808 .15841 .51882 .14657 Metetra
.664 .741 .907 r
.51882 .14657 .52808 .15841 .54516 .15202 .53598 .14011 Metetra
.664 .741 .907 r
.53598 .14011 .54516 .15202 .56236 .14558 .55324 .1336 Metetra
.664 .741 .907 r
.55324 .1336 .56236 .14558 .57966 .13911 .57061 .12705 Metetra
.664 .741 .907 r
.57061 .12705 .57966 .13911 .59707 .13259 .58809 .12046 Metetra
.664 .741 .907 r
.58809 .12046 .59707 .13259 .61458 .12604 .60569 .11383 Metetra
.664 .741 .907 r
.60569 .11383 .61458 .12604 .63221 .11944 .62339 .10715 Metetra
.664 .741 .907 r
.62339 .10715 .63221 .11944 .64995 .1128 .64121 .10044 Metetra
.664 .741 .907 r
.64121 .10044 .64995 .1128 .6678 .10612 .65914 .09368 Metetra
.664 .741 .907 r
.65914 .09368 .6678 .10612 .68577 .0994 .67718 .08687 Metetra
.664 .741 .907 r
.67718 .08687 .68577 .0994 .70385 .09263 .69534 .08003 Metetra
.664 .741 .907 r
.69534 .08003 .70385 .09263 .72205 .08582 .71362 .07314 Metetra
.664 .741 .907 r
.71362 .07314 .72205 .08582 .74036 .07897 .73201 .0662 Metetra
.62 .732 .926 r
.08191 .29735 .09283 .30741 .10729 .30292 .09634 .29331 Metetra
.439 .676 .963 r
.09634 .29331 .10729 .30292 .12148 .30121 .11033 .29329 Metetra
.45 0 0 r
.11033 .29329 .12148 .30121 .13489 .30669 .12321 .30303 Metetra
.862 .43 .183 r
.12321 .30303 .13489 .30669 .1469 .32535 .13431 .32883 Metetra
.871 .502 .346 r
.13431 .32883 .1469 .32535 .15748 .35911 .14406 .36911 Metetra
.831 .463 .358 r
.14406 .36911 .15748 .35911 .16797 .39761 .1547 .40616 Metetra
.577 .093 .069 r
.1547 .40616 .16797 .39761 .18086 .41833 .16907 .41373 Metetra
.92 .821 .732 r
.16907 .41373 .18086 .41833 .19765 .40394 .18778 .38217 Metetra
.872 .681 .642 r
.18778 .38217 .19765 .40394 .21727 .3604 .20845 .32953 Metetra
.831 .635 .638 r
.20845 .32953 .21727 .3604 .23721 .31039 .22832 .2815 Metetra
.792 .62 .667 r
.22832 .2815 .23721 .31039 .25582 .27188 .24636 .25005 Metetra
.752 .635 .731 r
.24636 .25005 .25582 .27188 .27294 .24864 .26302 .23287 Metetra
.711 .677 .815 r
.26302 .23287 .27294 .24864 .28918 .23579 .27906 .2232 Metetra
.68 .716 .876 r
.27906 .2232 .28918 .23579 .3051 .22773 .29494 .21628 Metetra
.667 .734 .9 r
.29494 .21628 .3051 .22773 .32098 .22126 .31086 .21006 Metetra
.664 .739 .906 r
.31086 .21006 .32098 .22126 .33693 .21516 .32686 .20396 Metetra
.664 .741 .907 r
.32686 .20396 .33693 .21516 .35296 .2091 .34296 .19785 Metetra
.664 .741 .907 r
.34296 .19785 .35296 .2091 .3691 .20302 .35915 .19169 Metetra
.664 .741 .907 r
.35915 .19169 .3691 .20302 .38533 .1969 .37544 .18551 Metetra
.664 .741 .907 r
.37544 .18551 .38533 .1969 .40166 .19074 .39184 .17928 Metetra
.664 .741 .907 r
.39184 .17928 .40166 .19074 .41809 .18455 .40833 .17301 Metetra
.664 .741 .907 r
.40833 .17301 .41809 .18455 .43462 .17832 .42492 .16671 Metetra
.664 .741 .907 r
.42492 .16671 .43462 .17832 .45126 .17205 .44162 .16037 Metetra
.664 .741 .907 r
.44162 .16037 .45126 .17205 .46799 .16574 .45842 .15399 Metetra
.664 .741 .907 r
.45842 .15399 .46799 .16574 .48483 .15939 .47533 .14757 Metetra
.664 .741 .907 r
.47533 .14757 .48483 .15939 .50177 .153 .49234 .1411 Metetra
.664 .741 .907 r
.49234 .1411 .50177 .153 .51882 .14657 .50946 .1346 Metetra
.664 .741 .907 r
.50946 .1346 .51882 .14657 .53598 .14011 .52669 .12806 Metetra
.664 .741 .907 r
.52669 .12806 .53598 .14011 .55324 .1336 .54402 .12148 Metetra
.664 .741 .907 r
.54402 .12148 .55324 .1336 .57061 .12705 .56146 .11485 Metetra
.664 .741 .907 r
.56146 .11485 .57061 .12705 .58809 .12046 .57902 .10818 Metetra
.664 .741 .907 r
.57902 .10818 .58809 .12046 .60569 .11383 .59669 .10147 Metetra
.664 .741 .907 r
.59669 .10147 .60569 .11383 .62339 .10715 .61446 .09472 Metetra
.664 .741 .907 r
.61446 .09472 .62339 .10715 .64121 .10044 .63236 .08792 Metetra
.664 .741 .907 r
.63236 .08792 .64121 .10044 .65914 .09368 .65036 .08108 Metetra
.664 .741 .907 r
.65036 .08108 .65914 .09368 .67718 .08687 .66849 .0742 Metetra
.664 .741 .907 r
.66849 .0742 .67718 .08687 .69534 .08003 .68673 .06727 Metetra
.664 .741 .907 r
.68673 .06727 .69534 .08003 .71362 .07314 .70509 .0603 Metetra
.664 .741 .907 r
.70509 .0603 .71362 .07314 .73201 .0662 .72357 .05328 Metetra
.59 .725 .937 r
.07085 .2873 .08191 .29735 .09634 .29331 .0852 .28408 Metetra
.234 .584 .946 r
.0852 .28408 .09634 .29331 .11033 .29329 .09885 .28675 Metetra
.748 .229 0 r
.09885 .28675 .11033 .29329 .12321 .30303 .11093 .3024 Metetra
.876 .486 .293 r
.11093 .3024 .12321 .30303 .13431 .32883 .12096 .33632 Metetra
.86 .504 .375 r
.12096 .33632 .13431 .32883 .14406 .36911 .13014 .38083 Metetra
.794 .412 .333 r
.13014 .38083 .14406 .36911 .1547 .40616 .14166 .41029 Metetra
.603 .951 .83 r
.14166 .41029 .1547 .40616 .16907 .41373 .15815 .39986 Metetra
.895 .725 .663 r
.15815 .39986 .16907 .41373 .18778 .38217 .17865 .35305 Metetra
.851 .65 .631 r
.17865 .35305 .18778 .38217 .20845 .32953 .19976 .29749 Metetra
.813 .622 .645 r
.19976 .29749 .20845 .32953 .22832 .2815 .21911 .25572 Metetra
.774 .623 .693 r
.21911 .25572 .22832 .2815 .24636 .25005 .23652 .23178 Metetra
.732 .657 .776 r
.23652 .23178 .24636 .25005 .26302 .23287 .25283 .21921 Metetra
.692 .703 .855 r
.25283 .21921 .26302 .23287 .27906 .2232 .26876 .21139 Metetra
.671 .729 .894 r
.26876 .21139 .27906 .2232 .29494 .21628 .28466 .20496 Metetra
.665 .738 .905 r
.28466 .20496 .29494 .21628 .31086 .21006 .30062 .1988 Metetra
.664 .74 .907 r
.30062 .1988 .31086 .21006 .32686 .20396 .31668 .19264 Metetra
.664 .741 .907 r
.31668 .19264 .32686 .20396 .34296 .19785 .33283 .18646 Metetra
.664 .741 .907 r
.33283 .18646 .34296 .19785 .35915 .19169 .34909 .18024 Metetra
.664 .741 .907 r
.34909 .18024 .35915 .19169 .37544 .18551 .36544 .17398 Metetra
.664 .741 .907 r
.36544 .17398 .37544 .18551 .39184 .17928 .3819 .16768 Metetra
.664 .741 .907 r
.3819 .16768 .39184 .17928 .40833 .17301 .39846 .16135 Metetra
.664 .741 .907 r
.39846 .16135 .40833 .17301 .42492 .16671 .41512 .15497 Metetra
.664 .741 .907 r
.41512 .15497 .42492 .16671 .44162 .16037 .43188 .14856 Metetra
.664 .741 .907 r
.43188 .14856 .44162 .16037 .45842 .15399 .44875 .1421 Metetra
.664 .741 .907 r
.44875 .1421 .45842 .15399 .47533 .14757 .46572 .13561 Metetra
.664 .741 .907 r
.46572 .13561 .47533 .14757 .49234 .1411 .4828 .12907 Metetra
.664 .741 .907 r
.4828 .12907 .49234 .1411 .50946 .1346 .49999 .12249 Metetra
.664 .741 .907 r
.49999 .12249 .50946 .1346 .52669 .12806 .51729 .11587 Metetra
.664 .741 .907 r
.51729 .11587 .52669 .12806 .54402 .12148 .53469 .10921 Metetra
.664 .741 .907 r
.53469 .10921 .54402 .12148 .56146 .11485 .55221 .10251 Metetra
.664 .741 .907 r
.55221 .10251 .56146 .11485 .57902 .10818 .56984 .09576 Metetra
.664 .741 .907 r
.56984 .09576 .57902 .10818 .59669 .10147 .58758 .08897 Metetra
.664 .741 .907 r
.58758 .08897 .59669 .10147 .61446 .09472 .60543 .08214 Metetra
.664 .741 .907 r
.60543 .08214 .61446 .09472 .63236 .08792 .6234 .07526 Metetra
.664 .741 .907 r
.6234 .07526 .63236 .08792 .65036 .08108 .64149 .06834 Metetra
.664 .741 .907 r
.64149 .06834 .65036 .08108 .66849 .0742 .65969 .06137 Metetra
.664 .741 .907 r
.65969 .06137 .66849 .0742 .68673 .06727 .67801 .05436 Metetra
.664 .741 .907 r
.67801 .05436 .68673 .06727 .70509 .0603 .69646 .0473 Metetra
.664 .741 .907 r
.69646 .0473 .70509 .0603 .72357 .05328 .71502 .0402 Metetra
.526 .708 .954 r
.05964 .27737 .07085 .2873 .0852 .28408 .07381 .2756 Metetra
0 .314 .751 r
.07381 .2756 .0852 .28408 .09885 .28675 .08689 .28239 Metetra
.851 .403 .142 r
.08689 .28239 .09885 .28675 .11093 .3024 .09791 .30569 Metetra
.874 .509 .354 r
.09791 .30569 .11093 .3024 .12096 .33632 .10685 .34745 Metetra
.843 .489 .384 r
.10685 .34745 .12096 .33632 .13014 .38083 .11605 .39139 Metetra
.693 .259 .214 r
.11605 .39139 .13014 .38083 .14166 .41029 .12935 .40639 Metetra
.919 .833 .744 r
.12935 .40639 .14166 .41029 .15815 .39986 .14824 .37637 Metetra
.871 .676 .636 r
.14824 .37637 .15815 .39986 .17865 .35305 .16999 .31978 Metetra
.832 .631 .63 r
.16999 .31978 .17865 .35305 .19976 .29749 .19089 .26743 Metetra
.796 .618 .661 r
.19089 .26743 .19976 .29749 .21911 .25572 .20948 .23394 Metetra
.756 .639 .731 r
.20948 .23394 .21911 .25572 .23652 .23178 .22633 .21637 Metetra
.712 .685 .822 r
.22633 .21637 .23652 .23178 .25283 .21921 .24241 .20678 Metetra
.679 .721 .882 r
.24241 .20678 .25283 .21921 .26876 .21139 .25831 .19988 Metetra
.667 .736 .902 r
.25831 .19988 .26876 .21139 .28466 .20496 .27425 .19361 Metetra
.664 .74 .906 r
.27425 .19361 .28466 .20496 .30062 .1988 .29027 .18742 Metetra
.664 .741 .907 r
.29027 .18742 .30062 .1988 .31668 .19264 .30638 .1812 Metetra
.664 .741 .907 r
.30638 .1812 .31668 .19264 .33283 .18646 .3226 .17495 Metetra
.664 .741 .907 r
.3226 .17495 .33283 .18646 .34909 .18024 .33891 .16865 Metetra
.664 .741 .907 r
.33891 .16865 .34909 .18024 .36544 .17398 .35533 .16232 Metetra
.664 .741 .907 r
.35533 .16232 .36544 .17398 .3819 .16768 .37185 .15595 Metetra
.664 .741 .907 r
.37185 .15595 .3819 .16768 .39846 .16135 .38847 .14955 Metetra
.664 .741 .907 r
.38847 .14955 .39846 .16135 .41512 .15497 .40519 .1431 Metetra
.664 .741 .907 r
.40519 .1431 .41512 .15497 .43188 .14856 .42202 .13661 Metetra
.664 .741 .907 r
.42202 .13661 .43188 .14856 .44875 .1421 .43896 .13008 Metetra
.664 .741 .907 r
.43896 .13008 .44875 .1421 .46572 .13561 .456 .12351 Metetra
.664 .741 .907 r
.456 .12351 .46572 .13561 .4828 .12907 .47315 .11689 Metetra
.664 .741 .907 r
.47315 .11689 .4828 .12907 .49999 .12249 .49041 .11024 Metetra
.664 .741 .907 r
.49041 .11024 .49999 .12249 .51729 .11587 .50777 .10354 Metetra
.664 .741 .907 r
.50777 .10354 .51729 .11587 .53469 .10921 .52525 .0968 Metetra
.664 .741 .907 r
.52525 .0968 .53469 .10921 .55221 .10251 .54284 .09002 Metetra
.664 .741 .907 r
.54284 .09002 .55221 .10251 .56984 .09576 .56054 .08319 Metetra
.664 .741 .907 r
.56054 .08319 .56984 .09576 .58758 .08897 .57836 .07632 Metetra
.664 .741 .907 r
.57836 .07632 .58758 .08897 .60543 .08214 .59629 .06941 Metetra
.664 .741 .907 r
.59629 .06941 .60543 .08214 .6234 .07526 .61434 .06245 Metetra
.664 .741 .907 r
.61434 .06245 .6234 .07526 .64149 .06834 .63251 .05544 Metetra
.664 .741 .907 r
.63251 .05544 .64149 .06834 .65969 .06137 .65079 .04839 Metetra
.664 .741 .907 r
.65079 .04839 .65969 .06137 .67801 .05436 .66919 .0413 Metetra
.664 .741 .907 r
.66919 .0413 .67801 .05436 .69646 .0473 .68772 .03415 Metetra
.664 .741 .907 r
.68772 .03415 .69646 .0473 .71502 .0402 .70636 .02696 Metetra
.377 .655 .966 r
.04823 .26778 .05964 .27737 .07381 .2756 .06205 .2685 Metetra
.657 .112 0 r
.06205 .2685 .07381 .2756 .08689 .28239 .07428 .28123 Metetra
.874 .478 .28 r
.07428 .28123 .08689 .28239 .09791 .30569 .08402 .31335 Metetra
.863 .512 .385 r
.08402 .31335 .09791 .30569 .10685 .34745 .09218 .36043 Metetra
.814 .448 .365 r
.09218 .36043 .10685 .34745 .11605 .39139 .10231 .39684 Metetra
.10231 .39684 .11605 .39139 .12935 .40639 .11814 .39217 Metetra
.893 .724 .665 r
.11814 .39217 .12935 .40639 .14824 .37637 .1392 .3454 Metetra
.851 .647 .626 r
.1392 .3454 .14824 .37637 .16999 .31978 .1614 .28623 Metetra
.816 .621 .639 r
.1614 .28623 .16999 .31978 .19089 .26743 .1816 .24124 Metetra
.78 .626 .689 r
.1816 .24124 .19089 .26743 .20948 .23394 .19941 .21582 Metetra
.737 .663 .777 r
.19941 .21582 .20948 .23394 .22633 .21637 .21585 .20285 Metetra
.694 .709 .859 r
.21585 .20285 .22633 .21637 .24241 .20678 .23182 .19493 Metetra
.671 .732 .896 r
.23182 .19493 .24241 .20678 .25831 .19988 .24773 .18842 Metetra
.665 .739 .905 r
.24773 .18842 .25831 .19988 .27425 .19361 .26372 .18216 Metetra
.664 .741 .907 r
.26372 .18216 .27425 .19361 .29027 .18742 .27979 .17591 Metetra
.664 .741 .907 r
.27979 .17591 .29027 .18742 .30638 .1812 .29597 .16963 Metetra
.664 .741 .907 r
.29597 .16963 .30638 .1812 .3226 .17495 .31225 .1633 Metetra
.664 .741 .907 r
.31225 .1633 .3226 .17495 .33891 .16865 .32862 .15694 Metetra
.664 .741 .907 r
.32862 .15694 .33891 .16865 .35533 .16232 .3451 .15053 Metetra
.664 .741 .907 r
.3451 .15053 .35533 .16232 .37185 .15595 .36168 .14409 Metetra
.664 .741 .907 r
.36168 .14409 .37185 .15595 .38847 .14955 .37837 .13761 Metetra
.664 .741 .907 r
.37837 .13761 .38847 .14955 .40519 .1431 .39516 .13108 Metetra
.664 .741 .907 r
.39516 .13108 .40519 .1431 .42202 .13661 .41205 .12452 Metetra
.664 .741 .907 r
.41205 .12452 .42202 .13661 .43896 .13008 .42906 .11791 Metetra
.664 .741 .907 r
.42906 .11791 .43896 .13008 .456 .12351 .44617 .11126 Metetra
.664 .741 .907 r
.44617 .11126 .456 .12351 .47315 .11689 .46338 .10457 Metetra
.664 .741 .907 r
.46338 .10457 .47315 .11689 .49041 .11024 .48071 .09784 Metetra
.664 .741 .907 r
.48071 .09784 .49041 .11024 .50777 .10354 .49815 .09106 Metetra
.664 .741 .907 r
.49815 .09106 .50777 .10354 .52525 .0968 .5157 .08425 Metetra
.664 .741 .907 r
.5157 .08425 .52525 .0968 .54284 .09002 .53336 .07738 Metetra
.664 .741 .907 r
.53336 .07738 .54284 .09002 .56054 .08319 .55114 .07047 Metetra
.664 .741 .907 r
.55114 .07047 .56054 .08319 .57836 .07632 .56904 .06352 Metetra
.664 .741 .907 r
.56904 .06352 .57836 .07632 .59629 .06941 .58704 .05652 Metetra
.664 .741 .907 r
.58704 .05652 .59629 .06941 .61434 .06245 .60517 .04948 Metetra
.664 .741 .907 r
.60517 .04948 .61434 .06245 .63251 .05544 .62342 .04239 Metetra
.664 .741 .907 r
.62342 .04239 .63251 .05544 .65079 .04839 .64178 .03526 Metetra
.664 .741 .907 r
.64178 .03526 .65079 .04839 .66919 .0413 .66027 .02807 Metetra
.664 .741 .907 r
.66027 .02807 .66919 .0413 .68772 .03415 .67887 .02084 Metetra
.664 .741 .907 r
.67887 .02084 .68772 .03415 .70636 .02696 .6976 .01356 Metetra
.003 .457 .866 r
.03656 .25894 .04823 .26778 .06205 .2685 .04978 .26367 Metetra
.83 .363 .088 r
.04978 .26367 .06205 .2685 .07428 .28123 .06083 .28419 Metetra
.872 .506 .351 r
.06083 .28419 .07428 .28123 .08402 .31335 .06929 .32478 Metetra
.847 .499 .393 r
.06929 .32478 .08402 .31335 .09218 .36043 .07736 .37191 Metetra
.748 .34 .279 r
.07736 .37191 .09218 .36043 .10231 .39684 .08949 .39342 Metetra
.909 .855 .778 r
.08949 .39342 .10231 .39684 .11814 .39217 .10812 .36788 Metetra
.869 .673 .636 r
.10812 .36788 .11814 .39217 .1392 .3454 .13062 .31085 Metetra
.834 .63 .626 r
.13062 .31085 .1392 .3454 .1614 .28623 .15253 .25542 Metetra
.802 .62 .656 r
.15253 .25542 .1614 .28623 .1816 .24124 .1718 .2193 Metetra
.765 .643 .727 r
.1718 .2193 .1816 .24124 .19941 .21582 .18896 .20043 Metetra
.718 .69 .822 r
.18896 .20043 .19941 .21582 .21585 .20285 .20514 .19036 Metetra
.681 .724 .883 r
.20514 .19036 .21585 .20285 .23182 .19493 .22107 .18328 Metetra
.667 .737 .903 r
.22107 .18328 .23182 .19493 .24773 .18842 .23703 .17689 Metetra
.664 .74 .907 r
.23703 .17689 .24773 .18842 .26372 .18216 .25307 .1706 Metetra
.664 .741 .907 r
.25307 .1706 .26372 .18216 .27979 .17591 .2692 .16428 Metetra
.664 .741 .907 r
.2692 .16428 .27979 .17591 .29597 .16963 .28544 .15792 Metetra
.664 .741 .907 r
.28544 .15792 .29597 .16963 .31225 .1633 .30178 .15152 Metetra
.664 .741 .907 r
.30178 .15152 .31225 .1633 .32862 .15694 .31821 .14509 Metetra
.664 .741 .907 r
.31821 .14509 .32862 .15694 .3451 .15053 .33476 .13861 Metetra
.664 .741 .907 r
.33476 .13861 .3451 .15053 .36168 .14409 .3514 .13209 Metetra
.664 .741 .907 r
.3514 .13209 .36168 .14409 .37837 .13761 .36815 .12553 Metetra
.664 .741 .907 r
.36815 .12553 .37837 .13761 .39516 .13108 .385 .11893 Metetra
.664 .741 .907 r
.385 .11893 .39516 .13108 .41205 .12452 .40197 .11229 Metetra
.664 .741 .907 r
.40197 .11229 .41205 .12452 .42906 .11791 .41904 .10561 Metetra
.664 .741 .907 r
.41904 .10561 .42906 .11791 .44617 .11126 .43621 .09888 Metetra
.664 .741 .907 r
.43621 .09888 .44617 .11126 .46338 .10457 .4535 .09211 Metetra
.664 .741 .907 r
.4535 .09211 .46338 .10457 .48071 .09784 .4709 .0853 Metetra
.664 .741 .907 r
.4709 .0853 .48071 .09784 .49815 .09106 .48841 .07844 Metetra
.664 .741 .907 r
.48841 .07844 .49815 .09106 .5157 .08425 .50604 .07154 Metetra
.664 .741 .907 r
.50604 .07154 .5157 .08425 .53336 .07738 .52377 .06459 Metetra
.664 .741 .907 r
.52377 .06459 .53336 .07738 .55114 .07047 .54163 .0576 Metetra
.664 .741 .907 r
.54163 .0576 .55114 .07047 .56904 .06352 .5596 .05057 Metetra
.664 .741 .907 r
.5596 .05057 .56904 .06352 .58704 .05652 .57768 .04348 Metetra
.664 .741 .907 r
.57768 .04348 .58704 .05652 .60517 .04948 .59589 .03636 Metetra
.664 .741 .907 r
.59589 .03636 .60517 .04948 .62342 .04239 .61421 .02918 Metetra
.664 .741 .907 r
.61421 .02918 .62342 .04239 .64178 .03526 .63266 .02196 Metetra
.664 .741 .907 r
.63266 .02196 .64178 .03526 .66027 .02807 .65123 .01469 Metetra
.664 .741 .907 r
.65123 .01469 .66027 .02807 .67887 .02084 .66992 .00737 Metetra
.664 .741 .907 r
.66992 .00737 .67887 .02084 .6976 .01356 .68874 0 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.11352 .22524 m
.11819 .22984 L
s
[(0)] .10416 .21603 1 .98393 Mshowa
.24608 .17333 m
.25054 .17814 L
s
[(5)] .23717 .1637 .92569 1 Mshowa
.38574 .11864 m
.38995 .12368 L
s
[(10)] .37733 .10857 .83504 1 Mshowa
.53307 .06095 m
.53699 .06622 L
s
[(15)] .52524 .05043 .74439 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(20)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.13949 .21507 m
.14227 .21785 L
s
.16573 .20479 m
.16848 .20761 L
s
.19224 .19441 m
.19497 .19725 L
s
.21902 .18393 m
.22172 .18679 L
s
.27343 .16262 m
.27607 .16554 L
s
.30106 .1518 m
.30368 .15474 L
s
.32899 .14087 m
.33158 .14383 L
s
.35721 .12981 m
.35977 .13281 L
s
.41457 .10735 m
.41706 .1104 L
s
.44372 .09594 m
.44617 .09902 L
s
.47318 .08441 m
.4756 .08751 L
s
.50296 .07274 m
.50535 .07587 L
s
.56352 .04903 m
.56583 .05222 L
s
.5943 .03698 m
.59658 .04019 L
s
.62543 .02479 m
.62766 .02803 L
s
.6569 .01246 m
.6591 .01573 L
s
.08781 .23531 m
.09064 .23804 L
s
.06236 .24527 m
.06521 .24798 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{497, 403},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007a0001Ta000`40O003h00OogooCGoo1P0017oo
1000Ugoo003oOom=Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`2DOol00?moodioo`03
001oogoo00Eoo`03001oogoo009oo`03001oogoo09Aoo`00ogooCgoo00<007ooOol017oo00<007oo
Ool00Woo00<007ooOol0U7oo003oOom@Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`2D
Ool00?mooe5oo`03001oogoo009oo`03001oogoo009oo`03001oogoo09Aoo`00ogooDWoo00D007oo
Oomoo`0000Aoo`03001oogoo09Aoo`00ogooDWoo00D007ooOomoo`0000Aoo`03001oogoo09Aoo`00
ogooCGoo00<007ooOol00Woo00D007ooOomoo`0000Aoo`03001oogoo00Qoo`@008Qoo`00ogooCWoo
10001Goo10002Woo00<007ooOol00Woo00<007ooOol0QGoo003oOomUOol00`00Oomoo`02Ool00`00
Oomoo`25Ool00?moofEoo`03001oogoo009oo`03001oogoo08Eoo`00ogooIGoo00<007ooOol00Woo
00<007ooOol0QGoo003oOomUOol00`00Oomoo`02Ool00`00Oomoo`25Ool00?moofEoo`03001oogoo
009oo`03001oogoo08Eoo`00ogooIGoo00<007ooOol00Woo00<007ooOol0QGoo003oOomUOol00`00
Oomoo`02Ool00`00Oomoo`25Ool00?mooeeoo`8000Moo`@008Qoo`00ogooFgoo0P0000=Fo0000000
TWoo003oOomHOol30003D_`2002BOol00?mooeIoo`<0009Bo003E_aBo5;l00<0095oo`00ogooDgoo
10001e;l00@005;l0000091oo`00ogooDGoo0`0000=Bo5Kl00000U;l00IFo5;lD_aBo5Kl0002D_`0
0`00Oomoo`2>Ool00?moodioo`<000EBo003001Bo5;l00EBo003001Bo5;l008008moo`00ogooBgoo
0`0000=Bo5Kl00000U;l00EFo5;lD_aBo00000=Bo006E_aBo5;l001Fo5;l0`00SWoo003oOom8Ool3
0002D_`01000D_aBo0001e;l00<005;lD_`00e;l0`000U;l00<007ooOol0S7oo003oOom5Ool40000
1EKlD_aBo5;l00000e;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l00@0009Bo004E_aBo000002=Ool0
0?mood9oo`@000QBo003001Bo5;l00MBo0<000ABo003001Bo5;l009Bo08008aoo`00ogoo@7oo1@00
0U;l00EFo5;lD_aBo5Kl00=Bo006001Bo5;lD_aFo5;l0`000U;l00<005KlD_`00U;l00L005;lD_aB
o5KlD_`0002<Ool00?moo`Aoo`D000Aoo`@002eoo`<000=Bo003001Bo5;l00QBo003001Bo5;l00<0
00EBo003001Bo5;l009Bo003001Bo5;l00=Bo08008]oo`00ogoo1Woo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol0:7oo0`000U;l00D005;lD_aBo00000=Bo006E_aBo5;lD_aFo5;l0`000e;l
00eFo5;lD_aBo5KlD_`005;lE_aBo000D_aFo003D_`2002;Ool00?moo`Ioo`03001oogoo00Qoo`03
001oogoo02Eoo`<000UBo003001Bo5;l00EBo080009Bo003001Bo5;l00QBo004001Bo5;l0002D_`3
0002D_`00`00Oomoo`28Ool00?moo`Ioo`03001oogoo00Qoo`03001oogoo02=oo`<00003D_`005;l
009Bo005E_aBo5;lD_aFo002D_`00`00E_aBo002D_`20002D_`01EKlD_`005;lE_`00e;l00IFo5;l
D_aBo5Kl0002D_`300000e;lE_aBo002D_`20029Ool00?moo`Ioo`03001oogoo00Qoo`03001oogoo
021oo`<000EBo003001Bo5;l00MBo003001Bo5;l008000MBo003001Bo5;l00MBo0@000QBo003001o
ogoo08Moo`00ogoo1Woo00<007ooOol00goo1@0087oo100000EFo5;lD_aBo5Kl00=Bo005001Bo5;l
D_aFo003D_`01EKl00000000E_`00e;l00IFo5;lD_aBo5Kl0002D_`01EKlD_aBo5;lE_`00P0000IB
o5Kl000005;lE_`3D_`01EKlD_aBo5;l0000R7oo003oOol6Ool00`00Oomoo`03Ool00`00Oomoo`0P
Ool300000e;l001Bo008D_`00`00D_aBo004D_`20002D_`00`00D_aBo008D_`00`00D_aBo002D_`2
0004D_`20009D_`20027Ool00?moo`Ioo`03001oogoo00=oo`03001oogoo01ioo`800003E_aBo5;l
008000=Bo005E_aBo5;lD_aFo002D_`00`00E_aBo0030003D_`01EKlD_`005;lE_`00e;l00EFo5;l
D_aBo000009Bo08000=Bo005E_aBo5;lD_`00003D_`01UKlD_aBo5;lE_aBo08008Moo`00ogoo17oo
0`001Goo00<007ooOol06goo0`001e;l00<005;lD_`01e;l0`002E;l00<005;lD_`01U;l0`002E;l
0P001E;l0`000U;l00<007ooOol0Q7oo003oOol6Ool00`00Oomoo`03Ool6000FOol30002D_`01EKl
D_aBo5;lE_`00e;l00H005;lD_aBo5KlD_`30002D_`00`00E_aBo002D_`01UKlD_aBo5;lE_`0009B
o004E_aBo5;lD_`20002D_`01@00D_aBo5;lE_`00e;l00IFo5;l000005KlD_`30003D_`015KlD_`0
0000QGoo003oOolUOol30002D_`00`00D_aBo008D_`00`00D_aBo0030005D_`00`00D_aBo008D_`0
0`00D_aBo0030004D_`00`00D_aBo007D_`40009D_`00`00Oomoo`23Ool00?moob9oo`@00003D_aF
o5;l009Bo005001Bo5;lD_aFo003D_`00eKlD_aBo0020003D_`02EKlD_aBo5;lE_aBo000D_aFo003
D_`015KlD_aBo5;l0`0000=Bo5KlD_`00U;l00EFo5;lD_`005Kl00=Bo003E_aBo5;l0080009Bo003
001Fo5;l009Bo007E_aBo5;lD_aFo5;l0000Q7oo003oOolPOol40008D_`00`00D_aBo005D_`20000
0e;l001Bo009D_`00`00D_aBo003D_`30002D_`00`00D_aBo007D_`00`00D_aBo002D_`200001E;l
001Bo5;l00002U;l0P00Pgoo003oOolMOol300001U;lE_`005;l001Fo0=Bo005E_aBo5;l001Fo003
D_`02EKl000005;lE_aBo000D_aFo003D_`01UKlD_aBo5;lE_`0009Bo0<00003D_aFo5;l009Bo005
001Bo5;lD_aFo003D_`01EKlD_`005;lE_`00P0000YBo5KlD_`005;lE_aBo000D_aFo0=Bo004E_aB
o5;lD_`20023Ool00?mooaYoo`@000ABo003001Bo5;l00QBo003001Bo5;l008000IBo003001Bo5;l
00MBo0<000UBo003001Bo5;l00IBo0<000EBo005001Bo5;lD_`00007D_`20002D_`00`00Oomoo`20
Ool00?mooaQoo`<00005E_aBo5;lD_aFo003D_`01@00D_aBo5;lE_`00e;l00=Fo5;l00000P000e;l
00IFo5;lD_aBo5Kl0002D_`01EKlD_aBo5;lE_`00P0000=Bo5Kl00000U;l00EFo5;lD_aBo5Kl00=B
o006001Bo5;lD_aFo5;l0P0000EFo5;l001Bo5Kl00=Bo006001Bo5;lD_aFo0000U;l00EFo5;l0000
05Kl00=Bo080085oo`00ogoo5Woo10002U;l00<005;lD_`00e;l0`000U;l00<005;lD_`01e;l00<0
05;lD_`00U;l0P0015;l00<005;lD_`025;l00<005;lD_`00`001E;l00<005;lD_`00U;l00<005;l
D_`00U;l00<005;lD_`00P001e;l00<007ooOol0Ogoo003oOolCOol30003D_`01EKl001Bo5;lE_`0
0e;l00IFo5;lD_`005KlD_`30003D_`01EKlD_`005;lE_`00e;l00EFo5;lD_aBo000009Bo08000=B
o005E_aBo5;lD_`00003D_`01UKlD_aBo5;lE_aBo0<000=Bo009E_aBo5;lD_aFo5;l001Bo5Kl009B
o004001Fo5;lD_`30002D_`01EKlD_aBo5;lE_`00e;l00<007ooOol0OWoo003oOolAOol300000e;l
001Bo004D_`00`00D_aBo006D_`30009D_`00`00D_aBo006D_`3000:D_`00`00D_aBo003D_`30002
D_`00`00D_aBo007D_`00`00D_aBo002D_`01000D_`000000U;l00<005;lD_`025;l0P00Ogoo003o
Ool>Ool400001U;lE_aBo5;l001Fo0=Bo005001Bo5;lD_aFo002D_`20002D_`00`00E_aBo002D_`0
2EKlD_aBo5;lE_aBo000D_aFo003D_`20002D_`01@00D_aBo5;lE_`00e;l00IFo5;lD_`005KlD_`3
0003D_`01EKlD_`005;lE_`00e;l00IFo5;lD_aBo5Kl0002D_`300001U;lE_aBo5;l001Fo0=Bo006
E_aBo5;lD_aFo5;l0P00Ogoo003oOol<Ool30002D_`00`00D_aBo008D_`00`00D_aBo0030004D_`0
0`00D_aBo008D_`00`00D_aBo0030005D_`00`00D_aBo008D_`20009D_`00`00D_aBo007D_`30000
0e;l001Bo005D_`00`00D_aBo005D_`20002D_`00`00Oomoo`1lOol00?moo`Uoo`<00003D_aFo5;l
009Bo005001Bo5;lD_aFo003D_`00eKlD_aBo0030002D_`02EKlD_aBo5;lE_aBo000D_aFo003D_`0
15KlD_aBo5;l0`0000=Bo5KlD_`00U;l00EFo5;lD_aBo00000=Bo004E_aBo5;lD_`200000e;l001F
o003D_`02EKlD_aBo5;lE_aBo000D_aFo003D_`300001U;lE_`005;l001Fo0=Bo005E_aBo5;l001F
o003D_`20002D_`00eKlD_`0001nOol00?moo`Ioo`<000UBo003001Bo5;l00EBo080009Bo003001B
o5;l00MBo003001Bo5;l00=Bo0<0009Bo003001Bo5;l00MBo003001Bo5;l00=Bo08000=Bo003001B
o5;l00QBo003001Bo5;l00<000EBo003001Bo00000MBo003001Bo5;l008000MBo003001oogoo07]o
o`00ogoo17oo1@000U;l00EFo5;lD_aBo5Kl00=Bo005001Bo5;lD_aFo00200001U;lE_aBo5;l001F
o0=Bo006E_aBo5;lD_aFo0000U;l0`0000=Bo5KlD_`00U;l00D005;lD_aBo5Kl00=Bo006E_aBo5;l
001Fo5;l0P0000UFo5;lD_aBo5KlD_`005;lE_`00e;l00AFo5;lD_aBo0<00003D_aFo5;l009Bo004
E_aBo5;lD_`20002D_`01EKlD_aBo5;lE_`00`0000EFo5;lD_aBo5Kl00=Bo003E_aBo00007aoo`00
ogoo0Goo0`000e;l00<005;l00002E;l00<005;lD_`00P001e;l00<005;lD_`01U;l0`002E;l00<0
05;lD_`01e;l0`002E;l00<005;lD_`00e;l0`000U;l00<005;lD_`025;l00<005;lD_`00e;l0P00
0U;l00<005;lD_`025;l00<007ooOol0NWoo003mOol40003D_`01UKlD_aBo5;lE_`0009Bo006E_aB
o5;lD_aFo5;l0`000e;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l009Bo006E_`00000D_aFo0000U;l
00EFo5;lD_aBo5Kl00=Bo006001Bo5;lD_aFo5;l0`000U;l00<005KlD_`00U;l00IFo5;lD_aBo5Kl
0002D_`300000e;lE_aBo002D_`01@00D_aBo5;lE_`00e;l00IFo5;lD_`005KlD_`30003D_`01EKl
001Bo5;lE_`00e;l00AFo5;lD_aBo08007]oo`00ngoo0`0000=Bo000D_`025;l00<005;lD_`015;l
0P000U;l00<005;lD_`025;l00<005;lD_`00`001E;l00<005;lD_`01e;l00<005;lD_`00`001E;l
00<005;lD_`025;l0P002E;l00<005;lD_`01e;l0`0025;l00<005;lD_`01E;l0P000U;l00<007oo
Ool0N7oo002lOol50004Ool4000_Ool40002D_`01EKlD_`005;lE_`00e;l00EFo5;lD_aBo000009B
o0<0009Bo005E_aBo5;l001Fo003D_`01UKlD_aBo5;lE_aBo0800005E_aBo5;lD_aFo003D_`01EKl
001Bo5;lE_`00e;l00=Fo5;l00000P000e;l00UFo5;lD_aBo5KlD_`005;lE_`00e;l00IFo5;l0000
05Kl0002D_`01EKlD_aBo5;lE_`00e;l00H005;lD_aBo5KlD_`400000e;l001Fo003D_`01UKlD_aB
o5;lE_`0009Bo005E_aBo000001Fo003D_`00`00Oomoo`1hOol00;ioo`03001oogoo00=oo`03001o
ogoo009oo`03001oogoo02Uoo`@000QBo003001Bo5;l00IBo0<000UBo003001Bo5;l00EBo0800003
D_`005;l00QBo003001Bo5;l00ABo080009Bo003001Bo5;l00QBo003001Bo5;l009Bo08000ABo003
001Bo5;l00MBo003001Bo5;l00<000=Bo003001Bo00000UBo003001Bo5;l008000MBo003001oogoo
07Moo`00_Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol09goo0`0000=Bo00000000e;l
00IFo5;lD_aBo5Kl0002D_`015KlD_aBo5;l0P000U;l00D005;lD_aBo5Kl00=Bo005E_aBo000D_aF
o003D_`20002D_`01EKl001Bo5;lE_`00e;l00EFo5;lD_aBo000009Bo0<0009Bo005E_aBo000D_aF
o003D_`01UKlD_aBo5;lE_`0009Bo080009Bo006E_aBo5;lD_aFo0000U;l00IFo5;lD_aBo5KlD_`3
0003D_`02EKlD_aBo000E_aBo000D_aFo003D_`00eKlD_aBo0030002D_`01EKlD_aBo5;lE_`00e;l
00<007ooOol0MWoo002nOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0UOol30003D_`0
0`00D_aBo008D_`00`00D_aBo0030004D_`00`00D_aBo008D_`00`00D_aBo0020006D_`00`00D_aB
o007D_`30008D_`00`00D_aBo007D_`30009D_`00`00D_aBo004D_`20002D_`00`00D_aBo004D_`0
1@00D_aBo5;l00001E;l0P000U;l00<005;lD_`025;l00<007ooOol0MWoo002nOol00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`0SOol200000e;lE_aBo002D_`01EKlD_`005;lE_`00e;l00AF
o5;lD_aBo0<00003D_aFo5;l009Bo005E_aBo5;l001Fo003D_`01EKlD_aBo5;lE_`00`0000EFo5;l
D_aBo5Kl00=Bo005E_`005;lD_aFo002D_`30002D_`01@00D_aBo5;lE_`00e;l00EFo5;l001Bo5Kl
00=Bo0<00003D_aFo000009Bo005E_aBo5;lD_aFo003D_`00`00D_aBo0030002D_`01EKlD_`005;l
E_`00e;l00IFo000D_aBo5Kl0002D_`300001U;lE_aBo5;l001Fo0=Bo006E_aBo5;lD_aFo5;l0P00
Mgoo002nOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0POol3000:D_`00`00D_aBo003
D_`30002D_`00`00D_aBo007D_`00`00D_aBo003D_`30002D_`00`00D_aBo007D_`00`00D_aBo003
0005D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00D_aBo008D_`30008D_`00`00D_aBo003
D_`01000D_aBo5;l0`0025;l00<005;lD_`01E;l0P000U;l00<007ooOol0M7oo002nOol00`00Oomo
o`03Ool00`00Oomoo`02Ool00`00Oomoo`0MOol300001EKlD_`005;lE_`00e;l00IFo5;lD_aBo5Kl
0002D_`300000e;lE_aBo002D_`01@00D_aBo5;lE_`00e;l00EFo5;l001Bo5Kl00<00006E_aBo5;l
D_aFo0000U;l00EFo5;lD_aBo5Kl00=Bo080009Bo005E_aBo5;lD_aFo002D_`00`00E_aBo002D_`0
15KlD_aBo5;l0`0000=Bo5KlD_`00U;l00EFo5;lD_aBo00000=Bo004E_aBo5;lD_`20002D_`01@00
D_aBo5;lE_`00e;l00EFo5;l001Bo5Kl009Bo0@00003D_aFo000009Bo005E_aBo5;lD_aFo002D_`0
0`00E_aBo002D_`20002D_`00eKlD_`0001fOol00;ioo`03001oogoo00=oo`03001oogoo009oo`03
001oogoo01]oo`@000ABo003001Bo5;l00MBo0<000UBo003001Bo5;l00IBo0<000UBo003001Bo5;l
00EBo0800003D_`005;l00UBo003001Bo5;l00=Bo080009Bo003001Bo5;l00QBo003001Bo5;l009B
o08000ABo003001Bo5;l00MBo003001Bo5;l00<000EBo003001Bo5;l00MBo003001Bo5;l008000MB
o003001oogoo07=oo`00_7oo0`001Goo00<007ooOol00Woo00<007ooOol067oo0`000e;l00T005;l
D_aBo5KlD_`005;lE_`00e;l00IFo000001Bo5Kl0002D_`01EKlD_aBo5;lE_`00e;l00H005;lD_aB
o5KlD_`200001EKlD_`005;lE_`00e;l00IFo5;lD_aBo5Kl0002D_`01EKlD_`00000E_`00e;l00D0
05;lD_aBo5Kl00=Bo005E_aBo000D_aFo00300001UKlD_aBo5;lE_`0009Bo005E_aBo5;lD_aFo002
D_`00`00E_aBo00200001EKlD_aBo5;lE_`00U;l00<005KlD_`00U;l00AFo5;lD_aBo0<00003D_aF
o000009Bo005E_aBo5;lD_`00003D_`01EKlD_aBo5;lE_`00`0000EFo5;lD_aBo5Kl00=Bo003E_aB
o00007Aoo`00_Woo00<007ooOol017oo10006Goo0`0000=Bo000D_`02E;l00<005;lD_`00`001E;l
00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;lD_`01e;l00<005;lD_`00P001e;l00<005;l
D_`01U;l0`002E;l00<005;lD_`01U;l0`002U;l00<005;lD_`00e;l0P000U;l00@005;lD_`000MB
o003001Bo5;l00=Bo080009Bo003001Bo5;l00QBo003001oogoo079oo`00ggoo0`000U;l00EFo5;l
D_`005Kl00=Bo006E_aBo5;lD_aFo5;l0P0000EFo5;lD_aBo5Kl00=Bo005E_`005;lD_aFo003D_`0
0eKlD_`000020003D_`02EKlD_aBo5;lE_aBo000D_aFo003D_`00eKlD_aBo0030002D_`01EKlD_aB
o5;lE_`00U;l00<005KlD_`00U;l00UFo5;l000005KlD_`005;lE_`00e;l00EFo5;lD_aBo00000=B
o003E_aBo5;l0080009Bo003001Fo5;l009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00<00005E_aBo5;l
D_`00003D_`01@00D_aBo5;lE_`00U;l00<005KlD_`00`000e;l00EFo5;l001Bo5Kl00=Bo004E_aB
o5;lD_`2001cOol00=aoo`@000QBo003001Bo5;l00EBo0800003D_`005;l00QBo003001Bo5;l00AB
o080009Bo003001Bo5;l00MBo003001Bo5;l00ABo080009Bo003001Bo5;l00QBo003001Bo5;l00<0
00ABo003001Bo5;l00QBo003001Bo5;l00<000EBo003001Bo5;l00MBo0<000QBo004001Bo5;l0006
D_`30008D_`00`00D_aBo004D_`30002D_`00`00Oomoo`0;Ool40006Ool20006Ool4001?Ool00=Yo
o`<00003D_`005;l009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo080009Bo005E_aBo000D_aFo003
D_`01EKlD_aBo5;l00000U;l0`000U;l00EFo5;lD_`005Kl00=Bo006E_aBo5;lD_aFo0000U;l0`00
00=Bo5KlD_`00U;l00D005;lD_aBo5Kl00=Bo003E_aBo000008000=Bo006E_aBo5;lD_aFo0000U;l
00EFo5;lD_aBo5Kl009Bo0<0009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo009E_`00000001Fo5;l
001Bo5Kl00=Bo00:E_aBo5;lD_`005;l001Bo5KlD_`30002D_`00`00E_aBo002D_`01UKlD_aBo5;l
E_`0009Bo0<00003D_aFo5;l009Bo003001oogoo00Yoo`03001oogoo009oo`03001oogoo00=oo`80
00Eoo`03001oogoo009oo`03001oogoo04aoo`00egoo0`000U;l00@005;lD_`000UBo003001Bo5;l
008000MBo003001Bo5;l00IBo0<000UBo003001Bo5;l00IBo0<000QBo003001Bo5;l00ABo0<0009B
o003001Bo5;l00MBo003001Bo5;l00=Bo0<0009Bo003001Bo5;l00MBo003001Bo5;l00<000EBo003
001Bo5;l00MBo003001Bo00000<000EBo003001Bo5;l00QBo08000UBo003001oogoo00Uoo`03001o
ogoo009oo`03001oogoo00moo`03001oogoo04aoo`00e7oo100000EFo5;lD_aBo5Kl00=Bo005001B
o5;lD_aFo003D_`01EKl00000000E_`00e;l00IFo5;lD_aBo5Kl0002D_`015KlD_aBo5;l0P000U;l
00D005;lD_aBo5Kl00=Bo005E_aBo000D_aFo003D_`01UKl000005;lE_`0009Bo005E_aBo5;lD_aF
o002D_`00`00E_aBo0030003D_`01EKlD_`005;lE_`00e;l00EFo5;lD_aBo000009Bo0<0009Bo005
E_aBo5;lD_`00003D_`01EKlD_aBo5;lE_`00`0000EFo5;lD_aBo5Kl00=Bo005E_`005;lD_aFo003
D_`00eKlD_`000020003D_`02EKlD_aBo5;lE_aBo000D_aFo003D_`01UKlD_`00000E_`0009Bo005
E_aBo5;lD_aFo002D_`00`00Oomoo`09Ool00`00Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomoo`1<
Ool00=9oo`<00003D_`005;l00QBo003001Bo5;l00ABo080009Bo003001Bo5;l00QBo003001Bo5;l
00<000ABo003001Bo5;l00QBo003001Bo5;l00<000EBo003001Bo5;l00IBo0<000UBo003001Bo5;l
00IBo0<000UBo003001Bo5;l00ABo080009Bo003001Bo5;l00QBo003001Bo5;l00=Bo080009Bo003
001Bo5;l00QBo003001Bo5;l009Bo08000=Bo003001Bo5;l00QBo003001oogoo00Qoo`03001oogoo
009oo`03001oogoo00moo`03001oogoo04aoo`00cgoo10000e;l00EFo000D_aBo5Kl00=Bo006E_aB
o5;l001Fo5;l0`000e;l00EFo5;l001Bo5Kl00=Bo004E_aBo5;lD_`300000e;lE_aBo002D_`01EKl
D_aBo000E_`00e;l00EFo5;lD_aBo5Kl00<00005E_aBo5;lD_aFo003D_`01@00D_aBo5;lE_`00U;l
0P000U;l00<005KlD_`00U;l00UFo5;lD_aBo5KlD_`005;lE_`00e;l0P000U;l00D005;lD_aBo5Kl
00=Bo006E_aBo5;l001Fo5;l0`000e;l00EFo000D_aBo5Kl00=Bo005E_aBo5;lD_`00002D_`30002
D_`01EKlD_`005;lE_`00e;l00IFo5;lD_aBo5Kl0002D_`20002D_`01EKlD_aBo5;l00000e;l00EF
o5;lD_aBo5Kl00<000Uoo`03001oogoo009oo`03001oogoo00Yoo`D004moo`00c7oo100025;l00<0
05;lD_`01U;l0`002E;l00<005;lD_`015;l0P000U;l00<005;lD_`01e;l00<005;lD_`00e;l0`00
0U;l00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;lD_`01e;l00<005;lD_`00`001E;l00<0
05;lD_`025;l0P0025;l00<005;lD_`01e;l0`001e;l0P002E;l0`002E;l00<005;lD_`00e;l0P00
0U;l00<007ooOol01goo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol0DGoo003:Ool50000
0e;lE_aBo002D_`01EKlD_aBo5;l00000e;l00=Fo5;lD_`00P000U;l00<005KlD_`00U;l00UFo5;l
D_aBo5KlD_`005;lE_`00`0000EFo5;lD_aBo00000=Bo009E_aBo5;lD_aFo5;l001Bo5Kl00<00006
E_aBo5;lD_aFo0000U;l00EFo5;lD_aBo5Kl00=Bo080009Bo005E_aBo5;lD_aFo002D_`00`00E_aB
o002D_`015KlD_aBo5;l0`0000=Bo5KlD_`00U;l00EFo5;lD_aBo00000=Bo004E_aBo5;lD_`20000
0e;l001Fo003D_`01UKlD_aBo5;lE_`0009Bo003E_aBo5;l00<0009Bo005001Bo5;lD_aFo003D_`0
1@00D_`005;lE_`00e;l0`0000=Bo5Kl00000U;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l00<000=B
o003E_`0000000Qoo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo055oo`00agoo100015;l
00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;lD_`025;l0P0025;l00<005;lD_`01U;l0`00
2E;l00<005;lD_`01E;l0P0000=Bo000D_`025;l00<005;lD_`015;l0P000U;l00<005;lD_`01e;l
00<005;lD_`00e;l0P000e;l00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;lD_`01E;l00<0
05;l00000U;l0`001E;l00<005;lD_`01e;l0`0025;l0P001goo00<007ooOol00Woo00<007ooOol0
2Woo00<007ooOol0DGoo0034Ool500000e;lE_aBo002D_`01EKlD_`005;lE_`00e;l00=Fo5;lD_`0
0`000U;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l009Bo003E_aBo5;l00800004D_`005;lE_`3D_`0
1EKlD_aBo5;l00000e;l00UFo5;l000005KlD_`005;lE_`00e;l00IFo5;lD_aBo5Kl0002D_`01EKl
D_`00000E_`00e;l00D005;lD_aBo5Kl00=Bo005E_aBo000D_aFo00300001EKlD_aBo5;l00000e;l
00EFo5;lD_aBo5Kl009Bo003001Fo5;l00800009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo003E_aBo5;l
00<0009Bo005E_aBo5;lD_aFo002D_`00`00E_aBo002D_`015KlD_`005;l0`0000=Bo5KlD_`00U;l
00EFo5;lD_aBo00000=Bo003E_aBo0000080009Bo003001Fo5;l009Bo006E_aBo5;lD_aFo00027oo
10003Goo1P00CWoo0032Ool50009D_`00`00D_aBo004D_`20002D_`00`00D_aBo007D_`00`00D_aB
o003D_`20003D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00D_aBo007D_`00`00D_aBo002
0007D_`00`00D_aBo006D_`30008D_`00`00D_aBo007D_`30009D_`00`00D_aBo003D_`20002D_`0
0`00D_aBo008D_`00`00D_aBo003D_`20002D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00
D_aBo007D_`2001/Ool00;moo`D00005E_aBo5;l001Fo003D_`01UKlD_aBo5;lE_`0009Bo0<00003
D_aFo5;l009Bo005001Bo5;lD_aFo003D_`01EKlD_`005;lE_`00P0000=Bo5KlD_`00U;l00EFo000
D_aBo5Kl00=Bo003E_aBo000008000=Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo003E_aBo5;l00<0
009Bo005E_aBo5;lD_aFo002D_`00`00E_aBo002D_`02EKlD_`00000E_aBo000D_aFo003D_`01EKl
D_aBo5;l00000e;l00=Fo5;l00000P000U;l00<005KlD_`00U;l00IFo5;lD_aBo5Kl0002D_`30000
1U;lE_aBo5;l001Fo0=Bo009E_aBo5;lD_aFo5;l001Bo5Kl00@000=Bo005E_`005;lD_aFo003D_`0
0eKlD_`000020003D_`02EKlD_aBo5;lE_aBo000D_aFo003D_`00eKlD_aBo003001[Ool00;eoo`D0
00IBo003001Bo5;l00IBo0<000UBo003001Bo5;l00IBo0<000UBo003001Bo5;l00=Bo080009Bo003
001Bo5;l00MBo003001Bo5;l00ABo080009Bo003001Bo5;l00QBo003001Bo5;l00<000ABo003001B
o5;l00MBo003001Bo5;l00<000IBo003001Bo5;l00IBo0<000QBo003001Bo5;l00MBo0<000=Bo003
001Bo5;l009Bo003001Bo5;l00ABo080009Bo003001Bo5;l00QBo003001Bo5;l00=Bo080009Bo003
001oogoo06Uoo`00^goo10000U;l00<005KlD_`00U;l00EFo5;l001Bo5Kl00=Bo006E_`00000D_aF
o0000U;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l009Bo009E_aBo000001Fo5;l001Bo5Kl00=Bo005
E_aBo5;lD_`00002D_`30002D_`01EKlD_aBo000E_`00e;l00IFo5;lD_aBo5Kl0002D_`300000e;l
E_aBo002D_`01@00D_aBo5;lE_`00e;l00=Fo5;l00000P000e;l00IFo5;lD_aBo5Kl0002D_`01UKl
D_aBo5;lE_aBo0<000=Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo006E_`00000D_aFo0000U;l00EF
o5;lD_aBo5Kl009Bo003001Fo5;l009Bo00=E_`00000001Fo5;l001Bo5KlD_`005;lE_`00e;l00<0
05;lD_`00`000U;l00EFo5;l001Bo5Kl00=Bo006E_aBo5;lD_aFo0000U;l0`0000=Bo5KlD_`00U;l
00<007ooOol0J7oo002iOol30003D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00D_aBo007
D_`00`00D_aBo0030005D_`00`00D_aBo006D_`30009D_`00`00D_aBo006D_`30008D_`00`00D_aB
o004D_`30002D_`00`00D_aBo007D_`00`00D_aBo003D_`20002D_`00`00D_aBo008D_`00`00D_aB
o0030004D_`00`00D_aBo007D_`00`00D_aBo0030006D_`01000D_aBo0001E;l0`0025;l00<005;l
D_`01e;l0`0025;l0P00JGoo0022Ool4000aOol20003D_`01EKlD_aBo5;l00000e;l00EFo5;lD_aB
o5Kl00<00005E_aBo5;lD_aFo003D_`01EKl001Bo5;lE_`00e;l00=Fo5;l00000P000e;l00IFo5;l
D_aBo5Kl0002D_`015KlD_aBo5;l0P000U;l00D005;lD_aBo5Kl00=Bo005E_aBo000D_aFo003D_`0
1UKl000005;lE_`0009Bo005E_aBo5;lD_aFo002D_`00`00E_aBo0030003D_`01EKlD_`005;lE_`0
0e;l00EFo5;lD_aBo000009Bo0<0009Bo005E_aBo5;l001Fo003D_`01EKlD_aBo5;lE_`00`0000EF
o5;lD_aBo5Kl00=Bo005001Bo5;lD_aFo003D_`01EKl00000000E_`00e;l00IFo5;lD_aBo5Kl0002
D_`01000D_aBo5;l0P000U;l00D005;lD_aBo5Kl00=Bo005E_aBo000D_aFo003D_`300000e;lE_`0
0002D_`01EKlD_aBo5;lE_`00U;l00<007ooOol0Igoo0021Ool00`00Oomoo`02Ool00`00Oomoo`0[
Ool30009D_`00`00D_aBo004D_`20002D_`00`00D_aBo007D_`00`00D_aBo004D_`20002D_`00`00
D_aBo007D_`00`00D_aBo0030005D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00D_aBo006
D_`30009D_`00`00D_aBo006D_`30008D_`00`00D_aBo004D_`30002D_`00`00D_aBo007D_`00`00
D_aBo003D_`20002D_`00`00D_aBo008D_`00`00D_`000030004D_`00`00D_aBo007D_`00`00D_aB
o0030005D_`00`00D_aBo007D_`2001XOol008Ioo`03001oogoo02Uoo`80009Bo005001Bo5;lD_aF
o003D_`01UKlD_aBo000E_aBo0<000=Bo005E_aBo000D_aFo003D_`01EKlD_aBo5;l00000U;l0`00
0U;l00EFo5;lD_`005Kl00=Bo004E_aBo5;lD_`300000e;lE_aBo002D_`01EKlD_aBo5;l00000e;l
00EFo5;lD_aBo5Kl00<00005E_aBo5;lD_aFo003D_`01@00D_aBo5;lE_`00U;l0P000U;l00<005Kl
D_`00U;l00UFo5;lD_aBo5KlD_`005;lE_`00e;l0P000U;l00D005;lD_aBo5Kl00=Bo005E_aBo000
D_aFo00300001UKlD_aBo5;lE_`0009Bo005E_aBo5;lD_aFo002D_`00`00E_aBo0030003D_`01EKl
D_`005;lE_`00e;l00AFo5;lD_aBo0<00003D_aFo5;l009Bo005E_aBo5;l001Fo003D_`015KlD_aB
o5;l0`0000=Bo5KlD_`00U;l00EFo5;lD_aBo00000=Bo003E_aBo5;l0080009Bo003001oogoo06Eo
o`00QWoo00<007ooOol09Woo0`000U;l00@005;lD_`000UBo0<000UBo003001Bo5;l00IBo0<000QB
o003001Bo5;l00ABo080009Bo003001Bo5;l00MBo003001Bo5;l00ABo080009Bo003001Bo5;l00MB
o003001Bo5;l00<000EBo003001Bo5;l00MBo003001Bo5;l00<000EBo003001Bo5;l00IBo0<000UB
o003001Bo5;l00IBo0<000QBo003001Bo5;l00ABo0<0009Bo08000QBo003001Bo5;l00=Bo080009B
o003001Bo5;l00MBo003001Bo5;l009Bo08000ABo003001oogoo06Eoo`00QWoo00<007ooOol097oo
0`0000EFo5;lD_aBo5Kl00=Bo005001Bo5;lD_aFo002D_`20002D_`00`00E_aBo002D_`01UKlD_aB
o5;lE_`0009Bo004E_aBo5;lD_`20002D_`01@00D_aBo5;lE_`00e;l00EFo5;l001Bo5Kl00<00006
E_aBo5;lD_aFo0000U;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l00<000=Bo005E_aBo000D_aFo003
D_`00eKlD_aBo0030002D_`01EKlD_aBo5;lE_`00U;l00<005KlD_`00U;l00AFo5;lD_aBo0<00003
D_aFo5;l009Bo005E_aBo5;l001Fo003D_`02EKlD_`00000E_aBo000D_aFo003D_`01UKlD_aBo5;l
E_`0009Bo003E_aBo5;l0080009Bo003001Fo5;l009Bo006E_aBo5;lD_aFo0000U;l0`0000=Bo5Kl
D_`00U;l0P000U;l00UFo5;lD_aBo5KlD_`005;lE_`00`0000EFo5;lD_aBo00000=Bo005E_aBo5;l
D_aFo002D_`01P00E_`00000D_aFo0=Bo003E_aBo00006Ioo`00PGoo1@0097oo0`000U;l00<005;l
D_`01e;l00<005;lD_`00`001E;l00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;lD_`01U;l
0`002E;l00<005;lD_`01U;l0`0025;l00<005;lD_`015;l0P000U;l00<005;lD_`01e;l00<005;l
D_`015;l0P000U;l00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;lD_`01e;l00<005;lD_`0
0`0015;l00<005;lD_`025;l0P002E;l00<005;lD_`01U;l0`0025;l00<005;lD_`01U;l0`002U;l
00<007ooOol0Hgoo0021Ool00`00Oomoo`0TOol30003D_`01EKlD_`005;lE_`00e;l00=Fo5;lD_`0
0`000U;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l009Bo004E_aBo5;lD_`300000e;lE_aBo002D_`0
1EKlD_aBo000E_`00e;l00UFo5;l000005KlD_`005;lE_`00e;l00EFo5;lD_aBo00000=Bo003E_aB
o5;l0080009Bo003001Fo5;l009Bo006E_aBo5;lD_aFo0000U;l0`0000=Bo5KlD_`00U;l00D005;l
D_aBo5Kl00=Bo005E_aBo000D_aFo00300001UKlD_aBo5;lE_`0009Bo006E_aBo5;lD_aFo5;l0`00
0e;l00UFo5;lD_aBo5KlD_`005;lE_`00e;l00=Fo5;lD_`00`000U;l00UFo5;lD_aBo5KlD_`005;l
E_`00e;l00IFo5;l000005Kl0002D_`01EKlD_aBo5;lE_`00U;l0P000e;l00UFo5;l000005KlD_`0
05;lE_`00e;l00EFo5;lD_aBo00000=Bo009E_aBo000001Fo5;l001Bo5Kl00=Bo006E_aBo5;lD_aF
o000IGoo0021Ool00`00Oomoo`0QOol30009D_`00`00D_aBo003D_`20002D_`00`00D_aBo007D_`0
0`00D_aBo004D_`20002D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00D_aBo007D_`00`00
D_aBo0030005D_`00`00D_aBo006D_`30009D_`00`00D_aBo006D_`30008D_`00`00D_aBo004D_`2
0002D_`00`00D_aBo007D_`00`00D_aBo004D_`20002D_`00`00D_aBo007D_`00`00D_aBo002D_`2
0003D_`00`00D_aBo007D_`20002D_`30004D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00
D_aBo007D_`2001TOol0085oo`03001oogoo01ioo`<0009Bo003001Fo5;l009Bo009E_aBo5;lD_aF
o5;l001Bo5Kl00800003D_aFo5;l009Bo005001Bo5;lD_aFo003D_`01EKlD_`005;lE_`00`0000IF
o5;lD_aBo5Kl0002D_`01UKlD_aBo5;lE_aBo0<000=Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo003
E_aBo5;l00<0009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo006E_`00000D_aFo0000U;l00EFo5;l
D_aBo5Kl009Bo003001Fo5;l009Bo009E_aBo000001Fo5;l001Bo5Kl00=Bo005E_aBo5;lD_`00002
D_`30002D_`01EKlD_`005;lE_`00e;l00IFo5;lD_aBo5Kl0002D_`300001U;lE_aBo5;l001Fo0=B
o006E_aBo5;lD_aFo0000U;l0P000U;l00EFo5;lD_aBo00000=Bo005E_aBo5;lD_aFo0040003D_`0
1UKlD_aBo5;lE_`0009Bo006E_aBo5;lD_aFo5;l0`000e;l00IFo5;lD_aBo5Kl0002D_`015KlD_aB
o5;l0`0000=Bo0000000Hgoo0021Ool6000IOol30005D_`00`00D_aBo007D_`30008D_`00`00D_aB
o006D_`30008D_`00`00D_aBo004D_`20002D_`00`00D_aBo007D_`00`00D_aBo004D_`20002D_`0
0`00D_aBo007D_`00`00D_aBo0030005D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00D_aB
o006D_`30008D_`00`00D_aBo007D_`30008D_`00`00D_aBo006D_`30009D_`00`00D_aBo003D_`3
0002D_`00`00D_aBo007D_`00`00D_aBo003D_`20002D_`00`00D_aBo007D_`00`00D_aBo0030005
D_`00`00Oomoo`1QOol009eoo`<0009Bo005E_aBo5;lD_aFo002D_`00`00E_aBo002D_`02EKlD_`0
0000E_aBo000D_aFo003D_`01EKlD_aBo000E_`00e;l00UFo5;l000005KlD_`005;lE_`00e;l00EF
o5;lD_aBo000009Bo0<0009Bo005E_aBo5;l001Fo003D_`01UKlD_aBo5;lE_`0009Bo0<00003D_aF
o5;l009Bo005001Bo5;lD_aFo003D_`01EKl00000000E_`00e;l00IFo5;lD_aBo5Kl0002D_`01UKl
D_aBo5;lE_aBo0<000=Bo006E_aBo5;lD_aFo0000U;l00AFo5;lD_aBo080009Bo005001Bo5;lD_aF
o003D_`01EKlD_`005;lE_`00e;l0`0000=Bo5Kl00000U;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l
009Bo006E_`00000D_aFo0000U;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l00<0009Bo006001Fo5;l
001Bo5Kl0e;l00EFo5;lD_aBo000009Bo0<0009Bo005E_aBo5;l001Fo003D_`015KlD_aBo5;l0`00
00=Bo5KlD_`00U;l00EFo5;lD_aBo000069oo`00Vgoo0P000U;l00<005;lD_`025;l00<005;lD_`0
0`0015;l00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;lD_`01U;l0`002E;l00<005;lD_`0
1U;l0`0025;l00<005;lD_`015;l0P000U;l00<005;lD_`01e;l00<005;lD_`015;l0P000U;l00<0
05;lD_`01e;l00<005;lD_`00`0015;l00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;lD_`0
1e;l00<005;lD_`00`001E;l00<005;lD_`01U;l0`001E;l00D005;lD_aBo00000QBo0<000QBo003
001Bo5;l00ABo080009Bo003001Bo5;l00MBo003001oogoo061oo`00V7oo0`0000=Bo5KlD_`00U;l
00D005;lD_aBo5Kl00=Bo003E_aBo000008000=Bo006E_aBo5;lD_aFo0000U;l00IFo5;lD_aBo5Kl
D_`30003D_`02EKlD_aBo5;lE_aBo000D_aFo003D_`20002D_`01@00D_aBo5;lE_`00e;l00EFo5;l
001Bo5Kl00=Bo006E_`00000D_aFo0000U;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l00<000=Bo005
E_aBo000D_aFo003D_`01EKlD_aBo5;l00000U;l0`000U;l00EFo5;lD_`005Kl00=Bo004E_aBo5;l
D_`300000e;lE_aBo002D_`01EKlD_aBo000E_`00e;l00AFo5;lD_aBo0<00003D_aFo5;l009Bo005
E_aBo5;lD_`00003D_`01EKlD_aBo5;lE_`00`0000EFo5;lD_aBo5Kl00=Bo005001Bo5;lD_aFo002
D_`20002D_`00`00E_aBo002D_`01UKl001Bo5;lE_`0009Bo003E_aBo5;l00<0009Bo005001Bo5;l
D_aFo003D_`01EKlD_`005;lE_`00`0000EFo5;lD_aBo00000=Bo005E_aBo5;lD_aFo002D_`00`00
Oomoo`1OOol009Eoo`<00003D_`0000000IBo003001Bo5;l00ABo080009Bo003001Bo5;l00MBo003
001Bo5;l00=Bo080009Bo003001Bo5;l00QBo003001Bo5;l008000EBo003001Bo5;l00MBo003001B
o5;l00<000EBo003001Bo5;l00IBo0<000UBo003001Bo5;l00IBo0<000QBo003001Bo5;l00ABo080
009Bo003001Bo5;l00MBo003001Bo5;l00=Bo080009Bo003001Bo5;l00QBo003001Bo5;l00=Bo080
009Bo003001Bo5;l00MBo003001Bo5;l00<000ABo003001Bo5;l00=Bo003001Bo5;l009Bo003001B
o000008000IBo003001Bo5;l00IBo0<000QBo003001Bo5;l00IBo0<0061oo`00Tgoo0`0000EFo000
D_aBo5Kl00=Bo005E_aBo5;lD_`00002D_`30002D_`01EKlD_aBo000E_`00e;l00EFo5;lD_aBo000
009Bo0<0009Bo005E_aBo5;l001Fo003D_`01EKlD_aBo5;lE_`00`0000EFo5;lD_aBo5Kl00=Bo005
001Bo5;lD_aFo003D_`01EKl00000000E_`00e;l00EFo5;lD_aBo00000=Bo003E_aBo5;l0080009B
o003001Fo5;l009Bo006E_aBo5;lD_aFo0000U;l00AFo5;lD_aBo080009Bo005001Bo5;lD_aFo003
D_`01EKlD_`005;lE_`00`0000EFo5;lD_aBo00000=Bo009E_aBo5;lD_aFo5;l001Bo5Kl00<00006
E_aBo5;lD_aFo0000U;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l00<000=Bo005E_aBo000D_aFo003
D_`00eKlD_aBo0030002D_`02EKlD_aBo5;lE_aBo000D_aFo002D_`01000E_aBo5;l0`000U;l00EF
o5;lD_aBo5Kl009Bo003001Fo5;l009Bo009E_aBo000001Fo5;l001Bo5Kl00=Bo005E_aBo5;lD_`0
0003D_`01eKlD_`00000E_aBo000061oo`00TGoo0P001E;l00<005;lD_`01e;l0`002E;l00<005;l
D_`01E;l0`002E;l00<005;lD_`015;l0P000U;l00<005;lD_`01U;l00<005;lD_`015;l0P000U;l
00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;l
D_`01U;l0`0025;l00<005;lD_`01U;l0`002E;l00<005;lD_`01U;l0`0025;l00<005;lD_`015;l
0P000U;l00<005;lD_`01e;l00H005;lD_aBo000D_`20002D_`00`00D_aBo008D_`00`00D_aBo003
0004D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00Oomoo`1MOol008ioo`<000=Bo006E_aB
o5;lD_aFo0000U;l00AFo5;lD_aBo080009Bo005001Bo5;lD_aFo003D_`01EKlD_`005;lE_`00e;l
0P000U;l00D005;lD_aBo5Kl00=Bo006E_aBo5;l001Fo5;l0`000e;l00EFo000D_aBo5Kl00=Bo006
E_aBo5;l001Fo5;l0`000e;l00EFo5;l001Bo5Kl00=Bo003E_aBo5;l00<0009Bo005E_aBo5;lD_aF
o002D_`00`00E_aBo002D_`015KlD_aBo5;l0`0000=Bo5KlD_`00U;l00EFo5;lD_`005Kl00=Bo009
E_aBo000001Fo5;l001Bo5Kl00=Bo005E_aBo5;lD_`00003D_`02EKlD_`00000E_aBo000D_aFo003
D_`01UKlD_aBo5;lE_`0009Bo003E_`000000080009Bo003001Fo5;l009Bo006E_aBo5;lD_aFo000
0U;l0`0000IBo5KlD_aBo000E_`3D_`01UKlD_aBo5;lE_`0009Bo0<00003D_aFo5;l009Bo005001B
o5;lD_aFo003D_`00eKlD_`000020003D_`01UKlD_aBo5;lE_`0009Bo006E_aBo5;lD_aFo5;l0`00
0e;l00EFo5;lD_aBo5Kl008005ioo`00S7oo0P000U;l00<005;lD_`01e;l00<005;lD_`00`001E;l
00<005;lD_`01e;l00<005;lD_`00P001E;l00<005;lD_`01e;l0`0025;l00<005;lD_`01U;l0`00
2E;l00<005;lD_`00e;l0P000U;l00<005;lD_`01e;l00<005;lD_`015;l0P000U;l00<005;lD_`0
1e;l00<005;lD_`00`0015;l00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;lD_`01e;l1000
1e;l00<005;lD_`01U;l0`0025;l00<005;lD_`01U;l0`0000=Bo000D_`01E;l00<005;lD_`015;l
0`000U;l00<005;lD_`01e;l00<005;lD_`00e;l0P000U;l00<005;lD_`01e;l00<007ooOol0G7oo
0029Ool300000e;l001Fo002D_`00`00E_aBo002D_`015KlD_aBo5;l0`0000=Bo5KlD_`00U;l00EF
o5;lD_aBo00000=Bo005E_aBo5;lD_aFo00300001EKlD_aBo5;lE_`00e;l00D005;lD_aBo5Kl009B
o080009Bo003001Fo5;l009Bo006E_aBo5;lD_aFo0000U;l00=Fo5;lD_`00P000U;l00<005KlD_`0
0U;l00UFo5;lD_aBo5KlD_`005;lE_`00P0000=Bo5KlD_`00U;l00D005;lD_aBo5Kl00=Bo005E_aB
o000D_aFo00300001UKlD_aBo5;lE_`0009Bo006E_aBo5;lD_aFo5;l0`000e;l00IFo5;lD_aBo5Kl
0002D_`01UKlD_aBo5;lE_aBo0<000=Bo006E_aBo5;lD_aFo0000U;l00AFo5;lD_aBo0<00003D_aF
o000009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo006E_`00000D_aFo0000U;l00EFo5;lD_aBo5Kl
009Bo003001Fo5;l009Bo009E_`00000D_aFo000D_`005Kl00=Bo006E_aBo5;l001Fo5;l0`000e;l
00EFo5;l001Bo5Kl00=Bo005E_aBo5;lD_`00002D_`30002D_`01EKlD_`005;lE_`00e;l00AFo5;l
D_aBo08005eoo`00QWoo0`001E;l00D005;lD_aBo00000EBo080009Bo003001Bo5;l00MBo003001B
o5;l00ABo080009Bo003001Bo5;l00MBo003001Bo5;l00<000EBo003001Bo5;l00IBo003001Bo5;l
00<000EBo003001Bo5;l00MBo0<000QBo003001Bo5;l00IBo0<000QBo003001Bo5;l00ABo080009B
o003001Bo5;l00MBo003001Bo5;l00=Bo080009Bo003001Bo5;l00MBo003001Bo5;l00<000EBo003
001Bo5;l00MBo003001Bo5;l00<000EBo003001Bo5;l00IBo003001Bo5;l00<000EBo08000MBo0<0
00UBo003001Bo5;l00IBo0<000QBo003001Bo5;l00=Bo0<0009Bo003001oogoo05Yoo`00Q7oo0P00
00=Fo5;k00000e;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l00800006E_aBo5;lD_aFo0000U;l00EF
o5;lD_aBo5Kl009Bo003001Fo5;l00<000=Bo005E_aBo000D_aFo003D_`00eKlD_aBo0030002D_`0
1EKlD_aBo5;lE_`00U;l00<005KlD_`00U;l00=Fo5;lD_`00`000U;l00EFo5;lD_aBo5Kl009Bo003
001Fo5;l009Bo009E_aBo000001Fo5;l001Bo5Kl00=Bo005E_aBo5;l001Fo003D_`02EKlD_`00000
E_aBo000D_aFo003D_`01EKlD_aBo5;l00000U;l0`000U;l00EFo5;l001Bo5Kl00=Bo005E_aBo5;l
D_`00002D_`30002D_`01EKlD_aBo000E_`00e;l00AFo5;lD_aBo0<00003D_aFo5;l009Bo005E_aB
o5;lD_`00003D_`01EKlD_aBo5;lE_`00`0000EFo5;lD_aBo5Kl00=Bo005001Bo5;lD_aFo003D_`0
1EKl00000000E_`00e;l00AFo5;lD_aBo080009Bo003E_aBo5;l0080009Bo003001Fo5;l009Bo006
E_aBo5;lD_aFo0000U;l00=Fo5;lD_`00`000U;l00D005;lD_aBo5Kl00=Bo004E_`005;lD_`30000
0e;lE_aBo002D_`00`00Oomoo`1JOol0085oo`<000EBo003001Bo5;l00MBo0<000QBo003001Bo5;l
00IBo0<000UBo003001Bo5;l00=Bo080009Bo003001Bo5;l00MBo003001Bo5;l00=Bo080009Bo003
001Bo5;l00QBo003001Bo5;l00<000ABo003001Bo5;l00MBo003001Bo5;l00<000EBo003001Bo5;l
00IBo0<000QBo003001Bo5;l00IBo0<000QBo003001Bo5;l00ABo080009Bo003001Bo5;l00QBo003
001Bo5;l00=Bo080009Bo003001Bo5;l00MBo004001Bo5;lD_`40002D_`00`00D_aBo007D_`00`00
D_aBo0030005D_`00`00D_aBo007D_`00`00D_`000020005D_`00`00D_aBo006D_`30009D_`00`00
Oomoo`1IOol007moo`<00009E_aBo5KlD_]Fo5;lE_aBn`0000=Bo003E_aBo5;l00800004D_aFo000
E_`3D_`01EKlD_aBo5;l00000e;l00=Fo5;lD_`00P000U;l00<005KlD_`00U;l00UFo5;lD_aBo5Kl
D_`005;lE_`00P0000=Bo5KlD_`00U;l00D005;lD_aBo5Kl00=Bo005E_aBo000D_aFo00200000e;l
E_aBo002D_`01@00D_aBo5;lE_`00e;l00=Fo5;l00000P000e;l00IFo5;lD_aBo5Kl0002D_`01UKl
D_aBo5;lE_aBo0<000=Bo006E_aBo5;lD_aFo0000U;l00AFo5;lD_aBo080009Bo005001Bo5;lD_aF
o003D_`01EKlD_`005;lE_`00e;l0P000U;l00D005;lD_aBo5Kl00=Bo005E_aBo000D_aFo0030000
1UKlD_aBo5;lE_`0009Bo005E_aBo5;lD_aFo002D_`00`00E_aBo0030003D_`01EKlD_`005;lE_`0
0e;l00=Fo5;lD_`0100000=Bo5KlD_`00U;l00EFo5;l001Bo5Kl00=Bo003E_aBo5;l00<0009Bo009
E_aBo5;lD_aFo5;l001Bo5Kl00=Bo003E_aBo5;l00<0009Bo005E_aBo5;lD_aFo002D_`00`00E_aB
o002D_`01UKl000005;lE_`0009Bo005E_aBo5;lD_aFo002D_`2001JOol007aoo`<00003E]/00000
00UBo003001Bo5;l00<000EBo003001Bo5;l00IBo003001Bo5;l00<000EBo003001Bo5;l00MBo0<0
00QBo003001Bo5;l00IBo0<000QBo003001Bo5;l00ABo080009Bo003001Bo5;l00MBo003001Bo5;l
00=Bo080009Bo003001Bo5;l00MBo003001Bo5;l00<000ABo003001Bo5;l00MBo003001Bo5;l00<0
00EBo003001Bo5;l00IBo0<000UBo003001Bo5;l00IBo0<000QBo003001Bo5;l00ABo080009Bo003
001Bo5;l00IBo003001Bo5;l00ABo0800003D_`0000000UBo004001Bo5;lD_`40002D_`00`00D_aB
o007D_`00`00D_aBo0030004D_`00`00D_aBo008D_`00`00Oomoo`1HOol007Yoo`<0000>D]]Fo5;K
E_aBf`00D_]Fo5;lE_aBneKlD_aFo0<0000;E_aBneKlD_aFo5;kE_aBo5Kl001Fo003D_`00eKlD_aB
o0030002D_`01EKlD_aBo5;lE_`00U;l00<005KlD_`00U;l00UFo5;l000005KlD_`005;lE_`00e;l
00EFo5;lD_`005Kl00=Bo009E_aBo000001Fo5;l001Bo5Kl00=Bo005E_aBo5;lD_`00002D_`30002
D_`01EKlD_`005;lE_`00e;l00EFo5;lD_aBo000009Bo0<0009Bo005E_aBo5;l001Fo003D_`015Kl
D_aBo5;l0`0000=Bo5KlD_`00U;l00EFo5;lD_`005Kl00=Bo004E_aBo5;lD_`300000e;lE_aBo002
D_`01EKlD_aBo5;l00000e;l00UFo5;l000005KlD_`005;lE_`00e;l00EFo5;lD_aBo00000=Bo003
E_aBo5;l0080009Bo003001Fo5;l009Bo006E_aBo5;lD_aFo0000U;l0`0000IBo5KlD_aBo000E_`3
D_`01UKlD_aBo5;lE_`0009Bo0<00006D_aFo5;l001Bo0000e;l00EFo5;lD_aBo5Kl00@000=Bo005
E_aBo5;lD_`00003D_`01EKlD_aBo5;lE_`00`0000EFo5;lD_aBo5Kl00=Bo005001Bo5;lD_aFo003
D_`015Kl00000000FGoo0013Ool4000`Ool30009E]/00`00D_aBo003D_`200000eKlD_/00009D_`0
0`00D_aBo003D_`20002D_`00`00D_aBo008D_`00`00D_aBo0030004D_`00`00D_aBo007D_`00`00
D_aBo0030005D_`00`00D_aBo006D_`30008D_`00`00D_aBo006D_`30008D_`00`00D_aBo004D_`2
0002D_`00`00D_aBo007D_`00`00D_aBo003D_`20002D_`00`00D_aBo008D_`00`00D_aBo0020005
D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00D_aBo006D_`30008D_`00`00D_aBo006D_`3
0006D_`00`00D_`00006D_`20002D_`00`00D_aBo006D_`00`00D_aBo004D_`20002D_`00`00D_aB
o007D_`00`00D_aBo003D_`20002D_`2001HOol0049oo`03001oogoo009oo`03001oogoo02]oo`<0
000?F[X005KlD]]Fo5;KE_aBfeKlD]]Fo5;K001BneKl0080000BD]]Fo5;KE_aBf`00D_aFo5;kE_aB
o5KlD_]Fo5;l001Bo5Kl0P0000IBneKlD_aBo5;k0003D_`01UKlD_aBo5;lE_aBo0<000=Bo006E_aB
o5;lD_aFo0000U;l00IFo5;lD_aBo5KlD_`30003D_`01UKlD_aBo5;lE_`0009Bo004E_aBo5;lD_`2
0002D_`01@00D_aBo5;lE_`00e;l00EFo5;l001Bo5Kl00=Bo080009Bo005001Bo5;lD_aFo003D_`0
1EKlD_`005;lE_`00`0000IFo5;lD_aBo5Kl0002D_`02EKlD_aBo5;lE_aBo000D_aFo00300001UKl
D_aBo5;lE_`0009Bo005E_aBo5;lD_aFo002D_`30002D_`02EKlD_aBo5;lE_aBo000D_aFo003D_`0
0eKlD_aBo0030002D_`02EKlD_aBo5;lE_aBo000D_aFo003D_`01UKl000005;lE_`0009Bo005E_aB
o5;lD_aFo002D_`00`00E_aBo002D_`01UKl000005;lE_`0009Bo005E_aBo5;lD_`00002D_`00`00
E_aBo0030003D_`01EKl001Bo5;lE_`00e;l00IFo5;lD_`005KlD_`30003D_`01EKlD_`005;lE_`0
0e;l00IFo5;lD_`005KlD_`30003D_`00eKlD_`0001HOol0049oo`03001oogoo009oo`03001oogoo
02Qoo`@000AJ^@03001FfeKK00QFf`80009Bo007E_aBne;lD_aFo5;k000025;l0`0025;l00<005;l
D_`015;l0P000U;l00<005;lD_`01e;l00<005;lD_`00e;l0P000U;l00<005;lD_`01e;l00<005;l
D_`00`001E;l00<005;lD_`01U;l00<005;lD_`00`001E;l00<005;lD_`01U;l0`002E;l00<005;l
D_`01E;l0`002E;l00<005;lD_`015;l0P000U;l00<005;lD_`01U;l00<005;lD_`015;l0P000U;l
00<005;lD_`01e;l00<005;lD_`00`0015;l00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;l
D_`00e;l00<005;lD_`00`0025;l00<005;lD_`01U;l0`0025;l00<005;lD_`01U;l0`0025;l0P00
Egoo0012Ool00`00Oomoo`02Ool00`00Oomoo`0VOol200004Goo000005ZiF[YF^EZjF[UJ^P00E_aB
feKlD]]Fo5;KE_`00P0000mFfP00D]]Fo5;KE_aBfeKlD]]Fo5;K001Bo5KlD_/0100000EFo5;k001B
neKl009Bo006D_]Fo5;lD_aBn`000U;l0`000U;l00EFo5;lD_`005Kl00=Bo005E_aBo5;lD_`00002
D_`30002D_`01EKlD_aBo000E_`00e;l00AFo5;lD_aBo0<00003D_aFo5;l009Bo005E_aBo5;lD_`0
0003D_`015KlD_aBo5;l0`0000=Bo5KlD_`00U;l00EFo5;lD_aBo00000=Bo009E_aBo000001Fo5;l
001Bo5Kl00=Bo005E_aBo5;lD_`00003D_`02EKlD_`00000E_aBo000D_aFo003D_`01UKlD_aBo5;l
E_`0009Bo0<00006D_aFo5;lD_`005Kl0e;l00IFo5;lD_aBo5Kl0002D_`300000e;lE_aBo002D_`0
1@00D_aBo5;lE_`00e;l00EFo000000005Kl00=Bo005E_aBo5;lD_`00003D_`01EKlD_aBo5;lE_`0
0`0000EFo5;lD_aBo5Kl00=Bo006001Bo5;lD_aFo5;l0`000U;l00<005KlD_`00U;l00IFo5;lD_aB
o5Kl0002D_`00eKlD_aBo0020002D_`00`00E_aBo002D_`01UKlD_aBo5;lE_`0009Bo003E_`00000
0080009Bo003001Fo5;l009Bo006E_aBo5;lD_aFo000Egoo0012Ool00`00Oomoo`02Ool00`00Oomo
o`0SOol30002Ool20007F[T00`00E]]Ff`03E]/200001UKKE]YFfUKJ001Bn`9Bo006E_aBne;lD_aF
o5;k0`001e;l00<005;lD_`01U;l0`002E;l00<005;lD_`01E;l0`002E;l00<005;lD_`00e;l0P00
0U;l00<005;lD_`01e;l00<005;lD_`00e;l0P000U;l00<005;lD_`025;l00<005;lD_`00P001E;l
00<005;lD_`01e;l00<005;lD_`00P001E;l00<005;lD_`01e;l0`0025;l00<005;lD_`01U;l0`00
25;l00<005;lD_`015;l0P000U;l00<005;lD_`01e;l00<005;lD_`00e;l0P000U;l00<005;lD_`0
1e;l00<005;lD_`00`0015;l00<005;lD_`01e;l00<005;lD_`00`001E;l00<005;lD_`01U;l1000
1e;l00<005;lD_`01U;l0P00EWoo0012Ool00`00Oomoo`02Ool00`00Oomoo`0POol30004Ool03P00
F[YJ^EZjE[UJ^UZiF[YF^EZjF[T005;KE_`200003UKJF]]FfUKKE]YJfeKJ001BfeKlD]]Fo5;KE_`2
00003U;K001BneKlD_]Fo5;kE_aBneKlD_/005;kE_`2D_`01U;k000005KlD_/000=Bo005E_aBo5;l
D_aFo002D_`00`00E_aBo0040002D_`01@00D_aBo5;lE_`00e;l00IFo5;lD_`005KlD_`200001UKl
D_aBo5;lE_`0009Bo005E_aBo5;lD_aFo002D_`00`00E_aBo00200001UKlD_aBo5;lE_`0009Bo005
E_aBo5;lD_aFo002D_`30002D_`02EKlD_aBo5;lE_aBo000D_aFo003D_`00eKlD_aBo0030002D_`0
2EKlD_aBo5;lE_aBo000D_aFo003D_`01UKl000005;lE_`0009Bo005E_aBo5;lD_aFo002D_`00`00
E_aBo002D_`01UKl000005;lE_`0009Bo005E_aBo5;lD_aFo002D_`00`00E_aBo0030003D_`01EKl
001Bo5;lE_`00e;l00IFo5;lD_`005KlD_`30003D_`01EKlD_`005;lE_`00e;l00=Fo5;lD_`00`00
0U;l00T005;lD_aBo5KlD_`005;lE_`00e;l00=Fo5;lD_`00`000U;l00UFo5;lD_aBo5KlD_`005;l
E_`00e;l00IFo000001Bo5Kl0002D_`02EKlD_aBo5;lE_aBo000D_aFo003D_`01UKl000005;lE_`0
05Eoo`00@Woo00<007ooOol00Woo00<007ooOol07Woo0P001Woo00<006:F00002UZi0P000UKJ00EF
feKJE]YFfUKK009FfP03001Fo5;k009Bo08000=Ff`03D]/005;l00QBo003001Bo5;l008000EBo003
001Bo5;l00MBo0<000MBo003001Bo5;l00MBo0<000QBo003001Bo5;l00IBo0<000QBo003001Bo5;l
00ABo080009Bo003001Bo5;l00IBo003001Bo5;l00ABo080009Bo003001Bo5;l00MBo003001Bo5;l
00<000EBo003001Bo5;l00IBo003001Bo5;l00<000EBo003001Bo5;l00IBo0<000QBo003001Bo5;l
00IBo0<000QBo003001Bo5;l00ABo080009Bo004001Bo5;l0006D_`00`00D_aBo003D_`20002D_`0
0`00D_aBo007D_`00`00D_aBo0030004D_`00`00D_aBo007D_`00`00D_aBo0030004D_`00`00Oomo
o`1COol0049oo`03001oogoo009oo`03001oogoo01]oo`<000Moo`0L001RUejF001F^EZjF[UJ^UJi
F[YJ^EZjE[T005ZG001FfU[KE]YFfeKJF]]FfUKKE]YJf`00E_`2000045;KE]]BfeKLD]]Ffe;K001B
neKlD_]Fo5;kE_aBneKl0`0000UFo5;lE_aBneKlD_aFo5;k00000e;l00=Fo5;lD_`00P000U;l00<0
05KlD_`00U;l00EFo5;lD_aBo00000=Bo003E_aBo5;l0080009Bo003001Fo5;l009Bo006E_aBo5;l
D_aFo0000U;l00=Fo00000000P000U;l00<005KlD_`00U;l00IFo5;lD_aBo5Kl0002D_`300000e;l
E_aBo002D_`01@00D_aBo5;lE_`00e;l00AFo000D_aBo0<00003D_aFo5;l009Bo005001Bo5;lD_aF
o003D_`01EKl00000000E_`00e;l00EFo5;lD_aBo00000=Bo005E_aBo5;lD_aFo00300001EKlD_aB
o5;lE_`00e;l00D005;lD_aBo5Kl009Bo080009Bo003001Fo5;l009Bo006E_aBo5;lD_aFo0000U;l
00=Fo5;lD_`00P000U;l00<005KlD_`00U;l00IFo5;lD_aBo5Kl0002D_`300002U;lE_aBo5;l001F
o5;l001Bo5Kl0e;l00AFo000D_aBo0<00006D_aFo5;lD_`005Kl0e;l00EFo5;lD_aBo5Kl00<00005
E_aBo5;lD_aFo003D_`01@00D_aBo5;lE_`00e;l00EFo000000005Kl00=Bo005E_aBo5;lD_`0001D
Ool0049oo`03001oogoo009oo`03001oogoo01Uoo`80009oo`03001oogoo00Aoo`03001RUUjF009N
UP03001J^EZi00EJ^@05001JV5jHFYP00003E]X01EKKE]YFfUKJE]/00UKJ00<005KKD]/00eKK00EB
feKKE]]Ff`0000IBo0800003D_aBf`0000UBo003001Bo5;l00<000ABo003001Bo5;l00MBo003001B
o5;l00<000EBo003001Bo5;l00IBo0@000MBo003001Bo5;l00IBo0<000QBo003001Bo5;l00IBo0<0
00QBo003001Bo5;l00ABo080009Bo003001Bo5;l00MBo004001Bo5;lD_`40002D_`00`00D_aBo007
D_`00`00D_aBo0030005D_`00`00D_aBo006D_`00`00D_aBo0030005D_`00`00D_aBo006D_`30008
D_`00`00D_`00006D_`30008D_`00`00D_aBo003D_`30002D_`00`00D_aBo006D_`00`00D_aBo003
D_`30002D_`00`00D_aBo006D_`2001COol004=oo`@001Uoo`<000Yoo`0<001RUejFHYMNUV:GGYH0
05JiF[YJ^EZj0P0000eJUejhFYMN^5ZG001FfU[KE]YFfeKJF]]FfP0200003UZj001Ffe;KE]aBfeKK
D]]Fg5;KE]/005KlD_/300003U;KE_aBfeKlD]/005;kE_aBo5KlD_]Fo5;lE_`300000e;lD_]Fo002
D_`01U;kE_aBo000D_aFo0=Bo003E_aBo5;l00<0009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo006
E_`00000D_aFo0000U;l00UFo5;lD_aBo5KlD_`005;lE_`00e;l00IFo000001Bo5Kl0002D_`01EKl
D_aBo5;lE_`00U;l00@005KlD_aBo0@00003D_aFo000009Bo005E_aBo5;lD_aFo002D_`00`00E_aB
o0030003D_`01EKlD_`005;lE_`00e;l00=Fo5;lD_`0100000=Bo5KlD_`00U;l00EFo5;l001Bo5Kl
00=Bo003E_aBo5;l00<0009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo003E_aBo5;l00<0009Bo009
E_aBo5;lD_aFo5;l001Bo5Kl00=Bo006E_`00000D_aFo0000U;l00EFo5;lD_aBo5Kl009Bo08000=B
o006E_`00000D_aFo0000U;l00UFo5;lD_aBo5KlD_`005;lE_`00`0000IFo5;lD_aBo5Kl0002D_`0
1EKlD_aBo5;lE_`00U;l00<005Kl00000P0000IFo5;lD_aBo5Kl0002D_`01UKlD_aBo5;lE_aBo080
05=oo`00GWoo0P0037oo00<006:FGYH00UjF00ERUUjFGYINUP00009J^@0:001NV5ZHGYQJV5jHFYQN
V000E]/3E]X00eKK00000004F[T00`00E]]Bf`03E]/015;KE]]FfeKK0P0000YBfeKlD]]Bo5;KE_aB
fe;lD]/000EBo080009Bo003001Bo5;l00MBo003001Bo5;l00=Bo080009Bo003001Bo5;l00MBo003
001Bo5;l00<000ABo003001Bo5;l00MBo003001Bo5;l00<000EBo003001Bo5;l00IBo0@000MBo003
001Bo5;l00IBo0<000QBo003001Bo5;l00ABo080009Bo003001Bo5;l00IBo003001Bo5;l00ABo080
009Bo003001Bo5;l00MBo004001Bo5;lD_`40002D_`00`00D_aBo007D_`00`00D_aBo0030004D_`0
0`00D_aBo007D_`2000015;l0000000015;l00<005;lD_`01U;l0`002E;l00<005;lD_`01E;l0`00
2E;l00<005;lD_`00e;l0P000U;l00<007ooOol0D7oo001KOol3000=Ool06@00HYMNUV:GGYIRUejF
HYMNUV:G001J^P00G[QJUejhFYMN^5ZGG[QJUejh001FfeKJ0080000>F[YF^EZjE[UJ^UJiF[X005KK
D]]Fg5;KE]]Bf`80000?E]/005KlD]]Fo5;KE_aBfeKlD]]Fo5;K001BneKl00800006D]]Fo5;KE_aB
f`000U;l00MBneKlD_aBo5;kE_`00002D_`300001U;kE_aBo5;lD_/000=Bo005E_aBo5;lD_aFo003
00001EKlD_aBo5;lE_`00e;l00D005;lD_aBo5Kl00=Bo005E_`00000001Fo003D_`01EKlD_aBo5;l
00000e;l00=Fo5;lD_`00P000U;l00<005KlD_`00U;l00EFo5;lD_aBo00000=Bo003E_aBo5;l0080
009Bo003001Fo5;l009Bo006E_aBo5;lD_aFo0000U;l0`0000IBo5KlD_aBo000E_`3D_`01UKlD_aB
o5;lE_`0009Bo0<00003D_aFo5;l009Bo005001Bo5;lD_aFo003D_`00eKl000000020003D_`01EKl
D_aBo5;l00000e;l00EFo5;lD_aBo5Kl00<00005E_aBo5;lD_aFo003D_`01@00D_aBo5;lE_`00e;l
100000EFo5;lD_aBo5Kl00=Bo006001Bo5;lD_aFo5;l0P0000EFo5;l001Bo5Kl00=Bo005E_aBo5;l
D_`00003D_`02EKlD_`00000E_aBo000D_aFo003D_`01EKlD_aBo5;l00000U;l0`000U;l00AFo5;l
0000055oo`00FGoo0P003goo00<006:FGYH00UjF00ERUUjFGYINUV:F009NUP0<001NV5ZHGYQJV5jH
FYQNV5ZHGYQJV5jH0P002EZi00D005KKE]]BfeKK008000AFfP0:001Bo5;KE_aBfe;lD]]Fo5;KD_`3
0008D_`00`00D_aBo005D_`30009D_`00`00D_aBo003D_`20002D_`00`00D_aBo007D_`00`00D_aB
o003D_`20002D_`00`00D_aBo007D_`00`00D_aBo0030004D_`00`00D_aBo007D_`00`00D_aBo003
0005D_`00`00D_aBo006D_`30008D_`00`00D_aBo006D_`30008D_`00`00D_aBo004D_`20002D_`0
0`00D_aBo006D_`00`00D_aBo004D_`20002D_`00`00D_aBo006D_`01000D_aBo5;l10000U;l0P00
25;l00<005;lD_`00`001E;l00<005;lD_`01e;l00<005;l00000P001E;l00<005;lD_`01U;l0`00
25;l00<007ooOol0Cgoo001FOol300000goo0000000=Ool03000HYMNUV:GGYIRUejFHYMNUV:GGYIR
U`80000IFYMN^5ZGG[QJUejhFYMN^5ZGG[P006:G001J^UJiF[YF^EZjE[UJ^UJiF[YF^@00D]/00P00
00iJfeJjE]]F^U[KE[YFf`00E_aBfeKlD]]Fo5;K0P0000eFfe;K001BfeKlD]]Fo5;KE_aBfeKl001F
o002D_`02U;kE_`00000D_]Fo000D_aBneKl0U;l00IBneKlD_aBo5;k0002D_`20003D_`01EKlD_`0
05;lE_`00e;l00IFo5;lD_`005KlD_`30003D_`01EKlD_`005;lE_`00e;l00=Fo5;lD_`00`000U;l
00UFo5;lD_aBo5KlD_`005;lE_`00e;l00=Fo5;lD_`00`000U;l00UFo5;lD_aBo5KlD_`005;lE_`0
0e;l00IFo000001Bo5Kl0002D_`01EKlD_aBo5;lE_`00U;l00<005KlD_`00U;l00IFo000001Bo5Kl
0002D_`01EKlD_aBo5;lE_`00U;l00<005KlD_`00`000e;l00EFo000D_aBo5Kl00=Bo006E_aBo5;l
001Fo5;l0`000e;l00EFo000D_aBo5Kl00=Bo003E_aBo00000<0009Bo004E_aBo5;lD_`20002D_`0
1UKlD_aBo5;lE_aBo0<000=Bo006E_aBo5;lD_aFo0000U;l00IFo5;lD_aBo5KlD_`30003D_`01UKl
D_aBo5;lE_`0009Bo004E_aBo5;lD_`20002D_`01@00D_aBo5;lE_`00e;l00=Fo5;l0000D7oo001D
Ool2000BOol00`00HYINUP02GYH01F:FGYINUUjFHYH00UjF0100069eHWD005ZHGYQJV5jHFYQNV5ZH
GYP005jGGYH000]J^@03001FfUKJ00QFfP03001Bo5;K00<000AFf`03001Bo5;l00MBo003001Bo5;l
008000EBo003001Bo5;l00MBo0<000QBo003001Bo5;l00EBo0<000UBo003001Bo5;l00=Bo080009B
o003001Bo5;l00MBo003001Bo5;l00=Bo080009Bo003001Bo5;l00MBo003001Bo5;l00<000ABo003
001Bo5;l00MBo003001Bo5;l00<000EBo003001Bo5;l00IBo0<000QBo003001Bo5;l00IBo0<000QB
o003001Bo5;l00=Bo080009Bo003001Bo5;l00EBo003001Bo00000EBo080009Bo003001Bo5;l00MB
o004001Bo5;lD_`40002D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00D_aBo006D_`2000=
Ool5000mOol0055oo`<001=oo`0>001VM000HYMNUV:GGYIRUejFHYMNUV:GGYH0009RM@0T001N^5ZG
G[QJUejhFYMN^000HYMNMUjGGWH005JiF[YF^EZjE[UJ^UJiF[YF^@00FYL005JjE]]F^U[KE[YFfeJj
F]]F^UKK0P00015BfeKKD]]Ffe;KE]]BfeKK001Fo5;KE_aBfeKlD]]Fo5;K00<0000<D_aFo5;kE_aB
o5KlD_]Fo000D_aBneKl0U;l00IBn`00001Fo5;k0003D_`02EKlD_aBo5;lE_aBo000D_aFo0040002
D_`00`00E_aBo002D_`02EKlD_aBo5;lE_aBo000D_aFo00200000e;lE_aBo002D_`01@00D_aBo5;l
E_`00e;l00AFo000D_aBo0<00003D_aFo5;l009Bo005001Bo5;lD_aFo003D_`01EKl00000000E_`0
0e;l00EFo5;lD_aBo00000=Bo005E_aBo5;lD_aFo00300001EKlD_aBo5;lE_`00e;l00D005;lD_aB
o5Kl009Bo080009Bo003001Fo5;l009Bo006E_aBo5;lD_aFo0000U;l00=Fo5;lD_`00P000U;l00<0
05KlD_`00U;l00EFo5;lD_aBo000009Bo0<0009Bo005E_aBo000D_aFo003D_`01EKlD_`005;l0000
0U;l0`000U;l00EFo5;lD_`005Kl00=Bo004E_aBo5;lD_`400001EKlD_aBo5;lE_`00U;l00<005Kl
D_`00U;l00AFo5;lD_aBo0<00003D_aFo5;l009Bo005E_aBo5;l001Fo003D_`015KlD_aBo5;l0P00
3goo00<007ooOol0?Goo001=Ool4000FOol01@00HW@005jFHYH00ejF00ERUUjFGYINUP0000ARM@08
001NV5ZHGYQJV5jH001NU`=NUP03GYMNUP0000IJ^@800004FYQNV5ZH0007E]X200000eZi001Ff`08
E]/00`00D_aBo003D_`200000e;KE]`00009D_`00`00D_aBo0030005D_`00`00D_aBo006D_`30007
D_`00`00D_aBo007D_`30008D_`00`00D_aBo005D_`30008D_`00`00D_aBo004D_`20002D_`00`00
D_aBo007D_`00`00D_aBo003D_`20002D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00D_aB
o006D_`00`00D_aBo0030005D_`00`00D_aBo005D_`30008D_`00`00D_aBo004D_`00`00D_`00002
0008D_`00`00D_aBo004D_`20002D_`00`00D_aBo006D_`00`00D_aBo004D_`20002D_`00`00D_aB
o007D_`01000D_aBo5;l10000U;l00<007ooOol037oo00<007ooOol0?Goo001<Ool3000GOol03@00
HWAVM69c001NUV:GGYIRUejFHYMNUP00009RM@0dGWERMF9e001JUejhFYMN^5ZG001NMUjGGWIRUeif
GYL005ZjE[UJ^UJiF[X005jHFYMNV5ZGGYQJU`00E[YFfeJjF]]F^P00E[UJ^EJiF[T005KKD]]Ffe;K
E]]BfeKKD]/005;KE_`300003UKlD]]Fo5;KE_`005KlD_aFo5;kE_aBo5KlD_/300002U;kE_aBo5Kl
D_]Fo5;lE_`005Kl0e;l00UFo5;l000005KlD_`005;lE_`00e;l00EFo5;lD_`005Kl00=Bo009E_aB
o000001Fo5;l001Bo5Kl00=Bo005E_aBo5;lD_`00002D_`400000e;lE_`00002D_`01EKlD_aBo5;l
E_`00U;l00<005KlD_`00`000e;l00EFo5;l001Bo5Kl00=Bo006E_aBo5;l001Fo5;l0`000e;l00EF
o5;l001Bo5Kl00=Bo003E_aBo5;l00<0009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo003E_aBo5;l
00<0009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo080009Bo005001Bo5;lD_aFo003D_`01EKlD_`0
05;lE_`00e;l0P000U;l00D005;lD_aBo5Kl00=Bo005E_aBo000D_aFo00300001EKlD_aBo5;l0000
0e;l00UFo5;lD_aBo5KlD_`005;lE_`00`0000EFo5;lD_aBo00000=Bo006E_aBo5;lD_aFo5;l1000
0U;l00AFo5;lD_aBo08000eoo`03001oogoo03eoo`00BGoo0`000Woo00<007ooOol05Goo00D006Id
IWAVM000009NUP05HYINUUjFGYH00007HWD01@00FYQNV5ZH00000ejF00INUejFGYINUUjG0003F[T0
1000FYQJV5jH0eZH00=NV000E]X00eKJ00<005ZiF[T015Zi00<005KKE]/01EKK0`0000YFg5;KE]]B
feKLD]]Ffe;KE]`000EBo0800003D]]Bo00000UBo003001Bo5;l00<000ABo003001Bo5;l00MBo003
001Bo5;l00<000EBo003001Bo5;l00IBo0<000MBo003001Bo5;l00IBo0<000QBo003001Bo5;l00IB
o0<000QBo003001Bo5;l00ABo080009Bo003001Bo5;l00MBo004001Bo5;lD_`40002D_`00`00D_aB
o007D_`00`00D_aBo0020005D_`00`00D_aBo006D_`00`00D_aBo00300000e;l001Bo002D_`00`00
D_aBo006D_`30008D_`00`00D_aBo006D_`30008D_`00`00D_aBo003D_`30002D_`00`00D_aBo006
D_`00`00Oomoo`0;Ool00`00Oomoo`0mOol004Moo`8000Ioo`03001oogoo01=oo`0?001VM69cIWAR
M6Id001RUejFHYMNUV:G001RMEie00=RM@0AGWERM@00G[QJU`00GWINUeifHYMNMUjGGWIRUeif001F
^@0200002ejHFYMNV5ZGGYQJUejHFYMNV000F]/00P0000eF^EZiE[UJ^EJiF[UF^@00D]]Ffe;KE]]B
f`02000045[JE[X005;KE_aBfeKlD]]Fo5;KE_aBfeKl001Fo5;l0P0000iFo5;KE_aBfeKl001Fo5;k
E_aBo5KlD_]Fo5;l0`0000UBo5KlD_]Fo5;lE_aBneKl00000U;l00IFo5;lD_aBo5KlD_`30003D_`0
1UKlD_aBo5;lE_`0009Bo004E_aBo5;lD_`20002D_`01@00D_aBo5;lE_`00e;l00EFo000D_aBo5Kl
009Bo080009Bo003001Fo5;l009Bo006E_aBo5;lD_aFo0000U;l00=Fo00000000P000U;l00<005Kl
D_`00U;l00IFo5;lD_aBo5Kl0002D_`300000e;lE_aBo002D_`01@00D_aBo5;lE_`00e;l00=Fo000
00000P000e;l00EFo5;lD_aBo00000=Bo005E_aBo5;lD_aFo00300001EKlD_aBo5;lE_`00U;l00<0
05KlD_`00U;l00AFo5;lD_aBo0<00006D_aFo5;lD_`005Kl0U;l00<005KlD_`00U;l00UFo5;l0000
05KlD_`005;lE_`00e;l00EFo5;lD_aBo00000=Bo009E_aBo000001Fo5;l001Bo5Kl00=Bo006E_aB
o5;l001Fo5;l0`000e;l00EFo5;l001Bo5Kl00=Bo003E_aBo5;l008000aoo`03001oogoo03eoo`00
A7oo0`007Woo00@006IdIWARM09VM006001NUUjFGYIRUP002F9e0P000ejF00ENUejFGYINUUjG00=N
UP05001JV5ZHFYQNV003FYP01UjHFYQJV5ZHGYP000YJ^@03001FfeKK008000EF^P0:001BfeKLD]]F
fe;KE]aBfeKKD]/300002E;KE_aBfe;lD]]Fo5;KD_`00005D_`20002D_`00`00D_aBo007D_`00`00
D_aBo003D_`20002D_`00`00D_aBo007D_`00`00D_aBo0030004D_`00`00D_aBo007D_`00`00D_aB
o0020005D_`00`00D_aBo006D_`40007D_`00`00D_aBo006D_`30008D_`00`00D_aBo004D_`20002
D_`00`00D_aBo006D_`00`00D_aBo004D_`20002D_`00`00D_aBo006D_`01000D_aBo5;l10000U;l
00<005;lD_`00U;l00<005;lD_`00U;l00<005;lD_`00`001E;l00<005;lD_`01U;l00<005;lD_`0
0`0015;l00<005;lD_`01U;l0`002E;l00<005;lD_`01E;l0`002goo00<007ooOol0?Goo0011Ool3
000POol03P00HW=VM69dIWARLfIdHW@005jFHYL0069eGWD3HWD0:eieHWERMF9eGWD005ifGYMNMV:G
GWINUeifHYMNMUjGGWH005ie001JUejHFYMNV5ZGGYQJUejHFYMNV000GYL005ZiE[UJ^EJiF[UF^EZi
E[UJ^EJi0080000?F]YF^U[JE[YJfUJjF]YF^P00D]]Fo5;KE_aBfeKl0080000?E]YFf`00E_aBfeKl
D]]Fo5;KE_aBfeKl001Fo5;k0080000?E_aBfeKlD]]Fo000E_aBo5KlD_]Fo5;lE_aBn`00009Bo0<0
0003D_aBneKl009Bo003001Fo5;l009Bo004E_aBo5;lD_`300000e;lE_aBo002D_`01EKlD_aBo000
E_`00e;l00AFo5;lD_aBo0<00003D_aFo5;l009Bo005E_aBo5;l001Fo003D_`01UKl000005;lE_`0
009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo006E_`00000D_aFo0000U;l00EFo5;lD_aBo5Kl009B
o003001Fo5;l00<000=Bo005E_`005;lD_aFo003D_`01UKlD_aBo000E_aBo0<000=Bo005E_`005;l
D_aFo003D_`00eKlD_`000030002D_`01UKlD_aBo5;lE_`0009Bo006E_`005;lD_aFo5;l0`000e;l
00IFo5;lD_aBo5Kl0002D_`01UKlD_aBo5;lE_aBo0<000=Bo006E_aBo5;lD_aFo0000U;l00=Fo5;l
D_`00P000U;l00<005KlD_`00U;l00IFo5;lD_aBo5Kl0002D_`00eKlD_aBo0020002D_`00`00Oomo
o`09Ool00`00Oomoo`0mOol003moo`@0025oo`03001VM69d00=VM005HWAVM000HYH0000:HWD01@00
HW@005jFGYL00ejF00UNUejFGYINUUjG001RM@00GYP00eZH00UNV5ZHFYQJV5jH001NUUif00002EZi
00<005ZG00002EJj00<005;KE]`00`0000=FfeKJE]/00UKK00T005;lD]]Fo5;KD_aBfeKlD]/00`00
00EBne;lD_aBo5;k00=Bo003001Bo5;l00EBo0<000QBo003001Bo5;l00ABo080009Bo003001Bo5;l
00MBo003001Bo5;l00=Bo080009Bo003001Bo5;l00MBo003001Bo5;l008000EBo003001Bo5;l00IB
o003001Bo5;l00<000EBo003001Bo5;l00IBo0<000QBo003001Bo5;l00IBo0<000QBo003001Bo5;l
00=Bo080009Bo003001Bo5;l00IBo005001Bo5;lD_`00002D_`20002D_`00`00D_aBo007D_`01000
D_aBo5;l10000U;l00<005;lD_`01U;l00<005;lD_`00`001E;l00<005;lD_`01e;l00<005;l0000
0P001E;l00<007ooOol01Woo0`00?goo000mOol2000TOol02P00IWARM6IdHW=VM69dIWARLfId0P00
00ENMF9eHWERMEie00=RM@0VGWERM@00IW@006:GGWINUeifHYMNMUjGGWIRU`00HWENMF9f001NV5ZG
GYQJUejHFYMNV000GYMNMUjGGWH005JiF[UF^EZiE[UJ^@80000=FYMNV000F]YF^U[JE[YJfUJjF]YF
^U[JE[X00P0000mFfe;JE]]FfUKKD]YFfeKJ001BfeKlD]]Fo5;KE_`00P0000mBfeKK001Fo5;KE_aB
feKlD]]Fo5;KE_`005KlD_`0100000=Fo5;K00000U;l00YBneKlD_aBo5;kE_aBo000D_aFo0<00006
E_aBo5;lD_]Fo0000U;l00UFo5;lD_aBo5KlD_`005;lE_`00`0000IFo5;lD_aBo5Kl0002D_`01UKl
D_aBo5;lE_aBo0<000=Bo006E_aBo5;lD_aFo0000U;l00EFo5;lD_aBo5Kl00<00005E_aBo5;lD_aF
o003D_`01@00D_aBo5;lE_`00U;l0P000U;l00<005KlD_`00U;l00IFo5;lD_aBo5Kl0002D_`00eKl
D_aBo0020002D_`00`00E_aBo002D_`01EKlD_aBo5;l00000U;l0`000U;l00EFo5;l001Bo5Kl00=B
o005E_aBo5;lD_`00002D_`30002D_`01EKlD_aBo000E_`00e;l00AFo5;lD_aBo0@00009E_aBo5;l
D_aFo5;l001Bo5Kl00=Bo003E_aBo5;l00<0009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo003E_aB
o5;l00<0009Bo007E_aBo5;lD_aFo5;l00002Woo00<007ooOol0?Goo000jOol3000VOol00`00HWAV
M002IW@01V9dIWAVM6IdHW@000YRM@05001RM69dIW@00002GYH01UjGGYINUUjFGYL000ERM@03001N
V5ZH009JV008GYP005jFGWINUeifGYH000EJ^@07001JV5ZGGYQJUeZH00001eJj0P0000EJ^000E]]F
feKJ00=Ff`06E]YFfeKK001Bfe;l0`000eKK00EBf`00D_aBo5;k00=Bo004D_]Bo5;lD_`20007D_`0
0`00D_aBo006D_`30008D_`00`00D_aBo006D_`30008D_`00`00D_aBo004D_`20002D_`00`00D_aB
o007D_`00`00D_aBo0040002D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00D_aBo006D_`0
0`00D_aBo0030004D_`00`00D_aBo006D_`30008D_`00`00D_aBo006D_`40007D_`00`00D_aBo004
D_`20002D_`00`00D_aBo006D_`00`00D_aBo003D_`20002D_`00`00D_aBo007D_`01000D_aBo5;l
10000U;l00<005;lD_`01e;l00<007ooOol0Agoo000hOol2000XOol03000HWAVM69cIWARM6IdHW=V
M69dIW@000=RM@05GWERMF9eHWENM@02HWD0@000HWAVMF9d001NMV:GGWINUeifHYL0069eGWERMUie
HWENM@00FYMNV5ZGGYP005jGGWINUeifGYMNMUjG001J^EJiF[T005jHFYMNV5ZGGYQJUejH001JfUJj
F]YF^U[J001J^EZHF[UFV000E]YFfe;JE]]FfUKKD]YFfeKJ0P00011Ffe;KE]]BfeKKD]]Ffe;K001B
feKlD]]Fo5;KE_aBf`80000;E]`005KlD]]Fo5;KE_aBfeKlD]/00002D_`00e;kE_aBo00200001EKl
D_/005;kE_`00U;l00IBneKlD_aBo5;k0003D_`400001EKlD_`005;lE_`00e;l00EFo5;lD_aBo000
009Bo0<0009Bo005E_aBo5;l001Fo003D_`015KlD_aBo5;l0`0000=Bo5KlD_`00U;l00EFo5;l001B
o5Kl00=Bo003E_aBo5;l00<0009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo003E_aBo5;l00<0009B
o009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo080009Bo005001Bo5;lD_aFo003D_`01EKlD_`005;lE_`0
0e;l0P000U;l0P000U;l00UFo5;lD_aBo5KlD_`005;lE_`00`0000EFo5;lD_aBo00000=Bo006E_aB
o5;lD_aFo0000U;l0`0000=Bo5KlD_`00U;l00D005;lD_aBo5Kl00=Bo003E_`00000008000=Bo005
E_aBo5;l001Fo003D_`01EKlD_aBo5;lE_`00P00B7oo000eOol3000ZOol01@00IWAVM6IdHW@00fId
00ERM6Id001VM00000QRM@03001RM6Id00=RM007001NUUjFGYINUejF00001f9e00h005ZHGYP005jF
GWINUeifGYINMUjGGWH005Zi0P0000YJV5ZGGYQJUeZHFYMNV5ZGFYP000=F^P03001J^EZh00=J^@05
F[P005KKE]]FfP03E]/200000eJi001Bf`03E]/01U;KE]]FfeKKD]/0009Bo008D_]Bo000001BfeKK
D]/000UBo003001Bo5;l008000EBo003001Bo5;l00IBo0@000MBo003001Bo5;l00IBo0<000QBo003
001Bo5;l00ABo080009Bo003001Bo5;l00EBo003001Bo5;l00ABo080009Bo003001Bo5;l00MBo004
001Bo5;lD_`40002D_`00`00D_aBo006D_`00`00D_aBo0030005D_`00`00D_aBo006D_`00`00D_aB
o0030004D_`20008D_`30008D_`00`00D_aBo005D_`30008D_`00`00D_aBo004D_`20002D_`00`00
D_aBo006D_`00`00D_aBo003D_`300000e;l00000017Ool0039oo`<00003Ool007oo02Uoo`0?001V
M69cIWARM6IdHW=VM69dIWARL`00IW<005ie00=RM@0cGWERMF9e001RM6IeHWAVM69dIWD005jGGWIR
Ueif001NMF9fGWERMEieHWINMF9e001NV000GYMNMUjGGWINUeifGYMNMUjGGWH005ZGGYQJUejHFYMN
V5ZGGYQJUejHFYL005Jj0080000<F[UJV5ZiEYQJ^EZHF[T005KKE]YFfe;J0P00011J^UJiF[YF^@00
D]]Ffe;KE]]BfeKKD]]Ff`00E_aBf`80000?E]aBfeKLD]]Fg5;K001BfeKlD]]Fo5;KE_aBfeKl00<0
000;E_aBneKlD_]Fo5;kE_aBn`00D_]Fo002D_`01U;k000005KlD_/0009Bo007D_]Fo5;lD_aBneKl
00000U;l00AFo5;lD_aBo0800003D_aBn`0000=Bo009E_aBo5;lD_aFo5;l001Bo5Kl00<00005E_aB
o5;lD_`00003D_`01UKlD_aBo5;lE_`0009Bo0<00003D_aFo5;l009Bo005001Bo5;lD_aFo003D_`0
0eKl000000020003D_`01EKlD_aBo5;l00000e;l00AFo5;lD_aBo0<00003D_aFo5;l009Bo005E_aB
o5;l001Fo003D_`015KlD_aBo5;l0`0000ABo5KlD_aBo0<00003D_`0000000=Bo009E_aBo000001F
o5;l001Bo5Kl00=Bo005E_aBo5;l001Fo002D_`400000e;lE_`00002D_`01EKlD_aBo5;lE_`00U;l
00<005KlD_`00`000e;l00EFo000D_aBo5Kl00=Bo005E_aBo000D_aFo00300001UKlD_aBo5;lE_`0
04Moo`00<7oo0P00;goo00@006IdIWARM0=VM004HWAVM6Id0002IW<00`00HWERM@05HWD00`00IWAR
M002HW@01fIdHWARM000GYMNUP0000YRM@0J001NUUifGYMNMUjFGWINUeifGYINMP00GWD005ZGGYQJ
UeZHFYMNV5ZGFYQJUejHFYL0009J^@05F[QJ^EZiF[UJ^003F[T03@00E]/00000E[UF^UJiF[YF^EJj
E[T005;K00=Ff`03D]]FfeKK00<0000:D]]Ffe;KE]]BfeKKD]]Ffe;K0005D_`200000eKLD]/00009
D_`00`00D_aBo0020005D_`00`00D_aBo006D_`00`00D_aBo0030005D_`00`00D_aBo006D_`30008
D_`00`00D_aBo005D_`30008D_`00`00D_aBo004D_`20002D_`00`00D_aBo006D_`00`00D_aBo003
D_`20002D_`00`00D_aBo007D_`01000D_aBo5;l10000U;l00<005;l00000P001E;l00<005;lD_`0
0`0015;l00<005;lD_`01U;l10001e;l00<005;lD_`01U;l0`0025;l00<005;lD_`01E;l0`002E;l
00<007ooOol0A7oo000/Ool4000`Ool04P00HW=VM69dIWARLfIdHWAVM69cIW@006IdIW=VM000HWEN
M@=RM@0F001VMF9dIWARM6IeHWAVM69d001NMP00GWERMUieHWENMF9fGWERMEieHWH20000=5ifGYMN
MUjGGWINUeifGYMNMUjG001RMP00GYQJUejHFYMNV5ZGGYQJUejHFYL005if001JV5ZiEYQJ^EZHF[UF
V5ZiFYQJ^@00F[YF^EZjE[UJ^UJiF[YF^EZj001Ffe;KE]]BfeKK0P0000mF^UKJ001Fg5;KE]aBfeKL
D]]Fg5;KE]`005KlD]/00`0000iBfeKlD]]Fo5;K001BneKlD_]Fo5;kE_aBneKl0`0000UFo5;lE_aB
neKlD_aFo5;k00000U;l00EBneKlD_aBo5;k00<00006D_]Fo5;lD_aBneKl0U;l00<005KlD_`00U;l
00UFo5;l000005KlD_`005;lE_`00e;l00EFo5;lD_aBo00000=Bo006E_`00000D_aFo0000U;l00EF
o5;lD_aBo5Kl009Bo003001Fo5;l00<000=Bo005E_aBo000D_aFo003D_`01UKlD_aBo000E_aBo080
0006E_aBo5;lD_aFo0000U;l00IFo5;lD_aBo5KlD_`40002D_`00eKlD_aBo0030002D_`01UKlD_aB
o5;lE_aBo0<000=Bo006E_aBo5;lD_aFo0000U;l00=Fo5;lD_`00P000U;l00<005KlD_`00U;l00EF
o5;lD_aBo00000=Bo003E_aBo5;l0080009Bo003001Fo5;l009Bo005E_aBo5;lD_`00003D_`40000
1EKlD_`005;lE_`00e;l00EFo5;lD_aBo00004Ioo`00:Woo0`00<goo00<006IdHW@00fId00ERM6Id
IWAVM000009VL`03IWAVL`0000ERM@05001RM69dHWAVM003HW@016IdHW@000002V9e00`0069d001N
MUjFGWINUeifGYINMUjG0003HWD03@00FYQJUejHFYMJV5ZGGYQJU`00GWINUP0000=J^@0EF[QJ^EZi
F[UJ^5Zi001NU`00E[YF^EZjE[UF^UJiF[YF^EJj001Ffe;K008000EF^P09001Ffe;KE]]BfeKKD]]F
fe;K00<000=Bf`06E]aBfe;KD]]Fg0001U;l0P0000=Bo5;K00002E;l00<005;lD_`010000U;l00<0
05;lD_`01e;l00<005;lD_`00`001E;l00<005;lD_`01U;l00<005;lD_`00P001E;l00<005;lD_`0
1U;l0`0025;l00<005;lD_`01U;l0`001e;l00<005;lD_`015;l0P000U;l00<005;lD_`00U;l0P00
0U;l00<005;lD_`015;l0P000U;l00<005;lD_`01U;l00<005;lD_`00`001E;l00<005;lD_`01U;l
00<005;lD_`00`0015;l00<005;lD_`01U;l10001e;l00<005;lD_`01U;l0P00AGoo000YOol2000d
Ool04@00IWARM6IdHW=VM69dIWARLfIdHW@006IcIWAVLfId00000f9e04YNM@00HWAVM69dIWERM6Id
HWAVMF9dIW@0069fGWERMEieHWINMF9eGWERMUie001RM6Ie001NUeifGYMNMUjGGWINU`00HWINMF9f
GWD005ZGGYQJUejHFYMNV5ZG001NMV:GGWINU`00F[UJV5ZiEYQJ^EZHF[T005jHFYL005JiF[YF^EZj
E[UJ^UJiF[YF^EZj0P0000iF^U[KE[YFfUJjF]]F^UKJ001Fg5;KE]aBfeKL0P0000mBfUKK001Fo5;K
E_aBfeKlD]]Fo5;KE_`005KlD_/00`0000iBfeKlD]]Fo5;K001BneKlD_aFo5;kE_aBo5Kl0`0000]F
o5;kE_aBo5KlD_]Fo000D_aBneKl009Bo003D_]Fo5;l00<0009Bo007D_]Fo5;lD_aBneKl00000U;l
00IFo5;lD_aBo5KlD_`30003D_`01EKlD_aBo5;l00000e;l00=Fo5;lD_`00P000U;l00<005KlD_`0
0U;l00IFo5;lD_aBo5Kl0002D_`00eKl000000020002D_`00`00E_aBo002D_`01EKlD_aBo5;l0000
0U;l0`000U;l00=Fo5;lD_`0100000=Bo5KlD_`00U;l00<005;lD_`00`000U;l00EFo5;l000005Kl
00=Bo003E_aBo5;l00<0009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo003E_aBo5;l00<0009Bo009
E_aBo5;lD_aFo5;l001Bo5Kl00=Bo080009Bo005001Bo5;lD_aFo003D_`01EKl001Bo5;lE_`00e;l
0P000U;l00<007ooOol0@Woo000MOol40008Ool2000dOol00`00HWAVM002IW@0269dIWAVM6IdHWAV
M000IW@3IW<01FId001RMF9e00000f9d00EVM69dHWARM6Id00=RM003001RMF9e00QRM@0;001RM69d
HW@005jGGWINUUifGYL00003HWD04EieHWERM@00FYMJV5ZGGYQJU`00GWINUUifGYINMP00F[P00eZi
00mJ^5Zi001NUeZGGYMJU`00E[UF^UJiF[YF^EJjE[T00P0000=JV000E[X025Jj00<005KKD]/00P00
00MFfeKJE]]FfUKK001Fg003D]/015KLD]]Bfe;K0`0000UBfeKlD]]Bo5;KE_aBfe;l00001U;l0P00
00=Fo5;K000025;l00<005;lD_`00e;l0P000U;l00<005;lD_`01e;l00@005;lD_aBo0@0009Bo003
001Bo5;l00IBo003001Bo5;l00<000EBo003001Bo5;l00IBo0@000MBo003001Bo5;l00EBo0<000IB
o0<000QBo0<000QBo003001Bo5;l00=Bo080009Bo003001Bo5;l00MBo004001Bo5;lD_`40002D_`0
0`00D_aBo006D_`00`00D_aBo0030005D_`00`00D_aBo006D_`00`00D_aBo0030004D_`00`00Oomo
o`12Ool001aoo`03001oogoo009oo`03001oogoo00Eoo`<0039oo`1>001VL`00HW=VM69dIWARLfId
HWAVM000IWAVLfIdIW=VM6Ic001NMF9e001VM69dIWERM6IdHWAVMF9dIWARM000IW<005ieHWINMF9e
GWERMUieHWD006IeHWAVMF9d001NMUjGGWINUeif001NMF9fGWERMUieHWH005jHFYMNV5ZG001NMV:G
GWINUeifHYMNMP00EYQJ^EZH0P0001]NV5ZGGYQJUejH001J^UJiF[YF^EZjE[T005ZHF[QJV000E[YF
fUJjF]]F^UKJE[YJfeJjE]X00P0000iFfUKKD]YFfeKJE]]BfUKK001Fo5;KE_aBfeKl0P0000mBfUKK
001Fo5;KE_aBfeKlD]]Fo5;KE_`005KlD_/00`00015BfeKlD]]Fo000E_aBo5KlD_]Fo5;lE_aBneKl
001Bo5;k00800007E_aBneKlD_aFo000E_`00U;l00EBneKlD_aBo5;k00@00005E_aBo5;lD_]Fo002
D_`00`00E_aBo002D_`00eKlD_aBo0030002D_`02EKlD_aBo5;lE_aBo000D_aFo003D_`01UKl0000
05;lE_`0009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo080009Bo004001Bo5;lD_`300001e;lE_aB
o000D_aFo5;l00@0009Bo005001Bo5;lD_aFo003D_`015Kl000005;l0`0000=Bo5KlD_`00U;l00D0
05;lD_aBo5Kl00=Bo003E_`00000008000=Bo005E_aBo5;l001Fo003D_`015KlD_aBo5;l0`0000=B
o5KlD_`00U;l00EFo5;lD_`005Kl00=Bo004E_aBo5;lD_`300000e;lE_aBo002D_`015KlD_aBo000
@goo000LOol00`00Oomoo`02Ool00`00Oomoo`05Ool5000`Ool01@00JW<006IdHW@00fId00ARM6Id
IW@000=VL`06IWAVLfIc001RM@000V9d00EVM69dHWARM6Id00=RM004IW@006Id0007HWD00`00HWAR
M003HW@01P00GYINMUjGGWH0009RM@0RGWERMF9eHWENMF9e001NV5ZG001NMUjFGWINUUifGYINMUjF
001J^EZh001JUejGFYMNUeZGGYMJUejG001J^UJiE[X20005FYP00`00E[YF^P05E[X200003UZi001F
feKJE]]FfUKKE]YFfeKJE]/005KLD]/20005E]/02@00D_aBfeKlD]]Bo5;KE_aBf`0300002E;KD_aB
g5KlD]]Bo5;LE_`00008D_`30007D_`00`00D_aBo004D_`20002D_`00`00D_aBo006D_`00`00D_aB
o003D_`20002D_`00`00D_aBo007D_`00`00D_aBo0030005D_`00`00D_aBo006D_`00`00D_aBo002
0005D_`30006D_`40007D_`00`00D_aBo005D_`30008D_`00`00D_aBo004D_`20002D_`00`00D_aB
o006D_`00`00D_aBo003D_`20002D_`00`00D_aBo007D_`01000D_aBo5;l10000U;l00<005;lD_`0
1U;l0P00@Woo000LOol00`00Oomoo`02Ool00`00Oomoo`04Ool20002Ool00`000MX00002000/Ool0
5000JY=VL`00HWAVM69cIWARM6IdHW<006IcIWAVLfIdIW=VM6IcIW@20000=V9dIWERM6IdHWAVMF9d
IWARM6Ie001VM6Ic001NMF9eGWERMUieHWENM@00HWAVMF9dIWERM6Ie001NUeif001NMF9fGWERMUie
HWINMF9fGWD005ZG001NMV:GGWINUeifHYMNMUjGGWIRU`80000;FYMNV5ZGGYQJUejHFYMNV5ZG001F
^@0200007EjiFYQJ^5ZHG[UJV5Zh001JfeJjE]YF^U[KE[X005JhF[UF^@00D]YFfeKJE]]BfUKKE]YF
fe;JE]/00P0000iBfUKKD]YFfe;JE]]BfUKK001Fo5;KE_aBfeKl0P00019BfeKK001Fo5;KE_aBfeKl
D]]Fo5;KE_`005KlD_aFo5;kE_`200003U;KE_`005KlD_]Fo5;lE_aBneKlD_`005;kE_`300002EKl
D_aFo5;kE_`005;lD_]Fo002D_`01U;kE_aBo000D_aFo0800006D_]Fo5;lD_aBn`000e;l00EFo5;l
D_aBo5Kl00<00005E_aBo5;lD_aFo003D_`01@00D_aBo5;lE_`00e;l00EFo000000005Kl00=Bo0@0
0006E_aBo5;lD_aFo5;l0P0000EFo5;l001Bo5Kl00=Bo005E_aBo5;l001Fo003D_`01EKl000005;l
E_`00P0000=Bo5KlD_`00U;l00IFo5;lD_`005KlD_`30003D_`01EKl001Bo5;lE_`00e;l00EFo5;l
001Bo5Kl00<00006E_aBo5;lD_aFo0000U;l00IFo5;lD_aBo5KlD_`40002D_`01EKlD_aBo5;l0000
0e;l00EFo5;lD_aBo5Kl0080049oo`0077oo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0
0Woo00<0007K0M/01000:Goo00D006YcJW=VL`00009VM005HWAVM6IdIW@00002IW<02FIdIW=VLfIc
IWAVL`00HWAVM003HW@01fIdHWARM69dIWARM000009VM003IW<0069e00ARM@03001RM69d00ERM003
001NMP00009RM@05GWERMF9eHWENM@03HWD06Uie001NMUjFGWINUUifGYINMUjFGWINUUif001JUejG
FYMNUeZGGYMJUejGFYMNUeZG000:FYP01000E[YF^UJj0P001EZi00P005KJE]]FfUKKE]YFfeKJ0P00
00=F^P00E]/025KK00<005;lD]/00P000eKK00aBfeKK001Fo5;KD_aBg5KlD]]Bo5;L0002D_`30002
D_`015KlD_]Bo0001e;l0`0025;l00<005;lD_`01U;l0`001e;l00<005;lD_`015;l0P000U;l00<0
05;lD_`01e;l00@005;lD_aBo0@0009Bo003001Bo000008000ABo003001Bo5;l00<000EBo003001B
o5;l00IBo003001Bo5;l008000EBo003001Bo5;l00IBo0<000QBo003001Bo5;l00EBo0<000QBo003
001Bo5;l00ABo080009Bo003001Bo5;l00IBo003001Bo5;l00=Bo080009Bo003001oogoo03moo`00
77oo00<007ooOol00Woo00<007ooOol017oo00<007ooOol00goo0`0000=UHFURIF400P009goo03<0
06ZCIW=ZT`00IWARM6IdHW=VM000IWAVLfIdIW=VM6IcIWAVLfId001VMF9dIWARM6IeHWAVM69dIWER
M000IW=VM6IcIW@0069fGWERMEieHWH006IeHWAVMF9dIWERM6IeHW@00P0000YRMUieHWINMF9fGWER
MUieHWINM@80000THYMNMUjGGWIRUeifGYMNMV:GGWH005ie001JUejHFYMNV5ZGGYQJUejHFYL005if
001JV5ZhFYQN^EZHF[QJV5jiFYP005Jj0P0000eJ^EJhF[UF^EZiE[QJ^EJi001BfUKKE]YFf`020000
3UJiF[YF^@00D]YFfe;JE]]BfUKKD]YFfe;JE]/2000045;KE]]BfeKKD]]Ffe;KE]/005KlD]]Fo5;K
E_aBfeKl0`0000iFo5;KE_aBfeKlD]]Fo5;K001Bo5KlD_]Fo5;l0P0000eFo5;K001BneKlD_aFo5;k
E_aBo5KlD_/00002D_`00e;k0000000200001EKlD_`005;kE_`00U;l00MBneKlD_aBo000E_aBo003
0002D_`01U;kE_aBo000D_aFo0=Bo003E_aBo5;l00@00005D_]Fo5;lD_aBn`0300000e;lE_aBo002
D_`00eKlD_`000020003D_`01UKlD_aBo5;lE_`0009Bo006E_aBo5;lD_aFo5;l0`000e;l00AFo5;l
D_aBo080009Bo003E_aBo5;l0080009Bo003001Fo5;l009Bo005E_aBo5;lD_`00003D_`400001EKl
D_`005;lE_`00e;l00EFo5;lD_aBo000009Bo0<0009Bo005E_aBo000D_aFo003D_`01UKlD_aBo000
E_aBo0<000=Bo003E_`00000041oo`0077oo00<007ooOol00Woo00<007ooOol017oo0P001Goo0`00
00AUHVURIF9YHP8002Aoo`03001ZLfIc00=ZL`08001VM6IdIWARM000IW=VM0=VL`06IWAVLfIc001Z
L`000V9d00EVM69dHWARM6Id009RM003001VM6Ic009VM003001RMF9e009RM@03001RM69d00MRM003
001RMEie00=RM@0QGWERMF9eHWENMF9e001VM@00GYINMUjFGWINUUifGYINMUjF001RM@00GYMJUejG
FYMNUeZGGYMJU`00GWINUP0000YJV003001J^EZi00QJ^@03001FfeKJ00800007F[YF^EJjE[UJ^UJi
00001eKK0P0000=F^P00E]/00UKK00]BfeKKE]]Ffe;K001Bg5KlD]]Bo5;L0080009Ff`06001Bne;l
D_aFo5;k0U;l00=Fo5;k00000U;l0P0000=Bo5KlD_/00U;l00<005;lD_`01U;l10001e;l00<005;l
D_`01E;l0`0025;l00<005;lD_`015;l0P000U;l00@005;lD_aBo0<0009Bo003001Bo5;l00=Bo080
009Bo003001Bo5;l00MBo004001Bo5;lD_`40002D_`00`00D_aBo006D_`2000015;l0000000015;l
00<005;lD_`01U;l10001e;l00<005;lD_`01U;l0`0025;l00<005;lD_`01E;l0`0025;l00<007oo
Ool0?Woo000LOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`06Ool01P00JF9UHFURIF5Y
HP<0029oo`1a001VLfZCIW=ZTfIc001RLfIdHWAVM000IWAVLfIdIW=VM6IcIWAVL`00IW<0069dIWER
M6IdHWAVMF9dIW@006IdIW=VM6IcIWAVL`00GWERMP00IWERM6IeHWAVMF9dIWERM6IeHW@005ieHWIN
MF9fGWERMUieHWINMF9f001VMF9d001NMV:GGWINUeifHYMNMUjG001RUUieHYH005jHFYMNV5ZGGYQJ
UejH001RUeifHYH005jiFYQJ^5ZHG[UJV5ZhFYP005ZG001F^5ZiE[UJ^EJhF[UF^EZiE[QJ^@020000
3UJiF[YF^EZjE[UJ^UJiF[YF^@00D]YFfe;JE]/2000045JiF]YF^P00D]]Ffe;KE]]BfeKKD]]Ffe;K
001BfeKl0P0000iBfeKKD]]Fg5;K001BfeKlD]]Fo5;KE_aBfeKl0`0000iFo5;KE_aBfeKlD]]Fo5;K
001BneKlD_aFo5;k0P0000mFo5;K001Bo5KlD_]Fo5;lE_aBneKl001Bo5;kE_`00U;l0P0000ABo5Kl
001Fo09Bo007D_]Fo5;lD_aBneKl00000U;l0`0000EBneKlD_aFo5;k00<00006D_]Fo5;lD_aBn`00
0U;l0`0000=Bo5;kE_`00U;l00<005KlD_`00U;l00AFo5;lD_aBo0@00009E_aBo5;lD_aFo5;l001B
o5Kl00=Bo003E_aBo5;l00<0009Bo009E_aBo5;lD_aFo5;l001Bo5Kl00=Bo080009Bo005001Bo5;l
D_aFo003D_`01EKl001Bo5;lE_`00e;l0P000U;l00D005;lD_aBo5Kl00=Bo005E_`005;lD_aFo004
0002D_`00`00E_aBo002D_`015KlD_aBo5;l0P00?goo000LOol00`00Oomoo`02Ool00`00Oomoo`04
Ool00`00Oomoo`07Ool02@00JF9UHVURIF9YHP00D600000QOol03000JW=ZLfYcIW=ZL`00IWARM6Id
001VM0=VL`09IWAVLfIcIW=VM000JW<006Id00=RM006IWARM69dHW@006Ic0fId00=VLfId00000V9e
00<0069dHW@01f9d00<006Id00000V9e01=NMF9eHWERMEieHWD006IeHWARM@00GYINMUjFGWINUUif
GYH00004HWD03P00FYMNUeZGGYMJUejG001NUUifGYINMUjF0006FYP01000GYMNU`002EZi00d005ZH
001J^UJiE[YF^EZjE[UF^UJiF[X00002E]/20006E[X00`00D]]Ff`02E]/015;KE]]FfeKK0`0000=F
fe;KE]/00UKK00EBfeKK001Fo5;k009Bo00:E_aBn`00001Ffe;K001Bo5KlD_/2D_`01EKlD_]Bo5;l
00000U;l0P0000IBne;lD_aFo5;k0008D_`00`00D_aBo0020005D_`00`00D_aBo006D_`30006D_`3
0007D_`30008D_`00`00D_aBo004D_`20002D_`00`00D_aBo006D_`00`00D_aBo003D_`20002D_`0
0`00D_aBo006D_`00`00D_aBo0030005D_`00`00D_aBo006D_`00`00D_aBo0030004D_`00`00D_aB
o006D_`40006D_`00`00D_aBo006D_`3000nOol001eoo`@000Ioo`03001oogoo00Qoo`07001UHFUR
IF5YHVEQ00000U1P0P007Woo068006ZCIW=ZTfIcJY=VLfZC001VM69c001VLfIdIW=VM6IcIWAVLfId
001ZTfIcJY@006IdHWAVMF9dIWARM000IW=VM6IcIWAVLfIdIW<005ie001RM6IeHWAVMF9dIWERM6Ie
HWAVM@00IW@0069fGWERMUieHWINMF9fGWD0069dIWERM6Ie001NUeifHYMNMUjG001RUUieHYINMF:F
GWD005ZGGYQJUejH001RUeifHYINMV:GGWH005ZHG[UJV5Zh0P0001YJUejGFYMNU`00F[UF^5ZiE[UJ
^EJhF[T005jHFYL005JiF[YF^EZjE[UJ^UJiF[YF^EZj0P0000mF^U[JE[UJfUJjF]YF^E[JE[X005;K
E]]BfeKKD]/00P0000iFfeJj001BfeKKD]]Fg5;KE]]BfeKL001Fo5;K0`0000iBfeKLD]]Fg5;K001B
feKlD]]Fo5;KE_aBfeKl0`00011Fo5;KE_aBfeKlD]]Fo000E_aBo5KlD_]Fo5;lE_aBn`<0000:D_]F
o5;lE_aBneKlD_`005;kE_`2D_`02U;kE_`00000D_]Fo000E_aBneKl0`0000IFo5;lE_`005KlD_`4
00000eKlD_/00002D_`02U;kE_aBo5;lD_]Fo5;l001Bo5Kl0`0000EFo5;lD_aBn`0000=Bo006E_aB
o5;lD_aFo0000U;l0`0000=Bo5KlD_`00U;l00D005;lD_aBo5Kl00=Bo0<00003D_aFo5;l009Bo005
E_aBo5;l001Fo003D_`015KlD_aBo5;l0`0000=Bo5KlD_`00U;l00EFo5;lD_`005Kl00=Bo006E_`0
0000D_aFo0000U;l00UFo5;lD_aBo5KlD_`005;lE_`00e;l0P000U;l00<007ooOol0?7oo000WOol0
0`00Ool00009Ool01`00IF9YHVERJF9UHP0000=@H08001aoo`04001ZLfYcIW<3JW<016Ic001VM000
0fIc00eVM6IcIW=VLfIdIW<006IcJW=VL`00HWAVM003HW@00fId001VM002IW@01FIcIWAVM6IdIW<0
0P002F9d00D006IdIW@005ie00=RM@0@GWERMF9e001RM69eHWAVMF9d001NMUjFGWINUUif0006HWD0
3P00GYMJUejG001NUUifGYINMUjFGWINUUif0002FYP00`00GYMNU`05GYL00`00F[UJ^@02F[T20002
FYP02UjHFYP005JiF[YF^EJjE[UJ^UJi0P0000=J^@00E[X025Jj00<005KKD]/00`0000IF^UKJE[YF
fUJj0002E]/01E;KE]]FfeKKD]/00`0000UBfeKKD]]Ffe;KE]]BfeKK00000U;l00AFo5;kD_aBo080
0004E]]Bf`00D_/2D_`01UKlD_]Bo5;lE_`000=Bo0@00003D_]Bo00000QBo003001Bo5;l00<000EB
o0<000IBo0<000MBo003001Bo5;l00IBo0<000QBo003001Bo5;l00EBo0<000QBo08000ABo080009B
o003001Bo5;l00MBo004001Bo5;lD_`40002D_`00`00D_aBo006D_`00`00D_aBo0030004D_`00`00
D_aBo006D_`00`00D_aBo0030005D_`00`00Oomoo`0kOol002Moo`8000Yoo`05001YHVEQJF9UH@0:
000HOol0=P00IW=ZTfIcJY=VLfZCIW=ZT`00IW@006IdIW=VM6IcIWAVLfIdIW<006IcJYAVLfZC001V
MF9dIWARM6IeHW@006IcIWAVLfIdIW=VM6IcIW@006IeHWAVMF9dIWERM6IeHWAVMF9d001RL`9VM01C
001NMF9fGWERMUie001RM6IeHWAVMF9dIWERM000GWINUeif001NMF:FGWERUUieHYINMF:F001NV5ZG
001NMV:FGWIRUeifHYINMV:G001J^000GYMJUejGFYMNUeZGGYMJUejG001J^EJh001JUejHFYMNV5ZG
GYQJU`00E[UJ^UJiF[YF^@00FYQJ^EZH001F^E[JE[YJfUJiF]YF^U[JE[UJfP0200003UJjE]]F^UKK
E[YFfeJjE]/005KLD]]Ffe;KE]`200003eKJE]/005KLD]]Fg5;KE]aBfeKLD]]Fg000E_aBf`030000
3E;KE]aBfeKLD]/005;KE_aBfeKlD]]Fo5;K00@0000?E_aBfeKlD]]Fo5;KE_`005KlD_]Fo5;lE_aB
neKl00<00005E_aBo5KlD_]Fo00400001U;lE_aBneKlD_aFo080000<D_]Fo000E_aBo5KlD_]Fo5;l
E_`005Kl0U;l00=BneKlD_`00P0000EFo5;l001BneKl009Bo006D_]Fo5;lD_`005Kl0U;l100000=B
neKl00000U;l00EFo5;lD_aBo5Kl009Bo003001Fo5;l00800006E_aBo5;lD_]Fo0000U;l00IFo5;l
D_aBo5KlD_`40002D_`01EKlD_aBo5;l00000e;l00EFo5;lD_aBo5Kl00<00005E_aBo5;lD_aFo003
D_`01@00D_aBo5;lE_`00e;l0`0000=Bo5KlD_`00U;l00AFo5;lD_`003eoo`009goo00<007ooOol0
2Woo10000VgZ00L006gXKLQ]j6g8KNQ]b004000EOol00`00JW=VL`03JW<01FIcJW=ZLfYc00000VIc
00EVM6IcIW=VLfId009VL`07001ZLfIcJW=VLfYc00000V9d00=VM69d00000VId00EVLfIdIWAVM6Ic
009VM003001RM69d00MRM003001VM6Id009VM003001RMEie00=RM@0<001RMF9dIWERM69eHWAVM@00
GYINMP002F9e00h005ZG001NMUjFGWINUUifGYINMUjFGWINUP002UjG00<005Zi00000eZH015NV5ZH
FYQJV5jHFYP005JiF[YF^@00FYQJ^EZHF[QJV00000MF^P80000<F[T005KJE[YFfUJjE]YF^UKJE[YF
fP000UKK0P0000iFfeKJE]]FfUKK001Ffe;KE]]BfeKKD]]Ffe;K0`0000]BfeKKD]]Ffe;KE]]BfeKK
001Fo5;k009Bo006E_`00000D]]Fg0000U;l00MFo5;kD_aBo5KlD_/00005D_`20002D_`00`00D_aB
o0030004D_`00`00D_aBo0030004D_`00`00D_aBo006D_`00`00D_aBo0030005D_`00`00D_aBo005
D_`40007D_`00`00D_aBo006D_`30007D_`00`00D_aBo004D_`20002D_`00`00D_aBo006D_`00`00
D_aBo003D_`20002D_`00`00D_aBo006D_`01000D_aBo5;l10000U;l00<005;lD_`01e;l00<007oo
Ool0>Woo000WOol00`00Oomoo`0:Ool04@00JNY^2fgZKPYYjVh;001]j6W7KNQ]b6gX001]Q6V3JH@0
0P004goo03@006IcJY=VLfZCIW=ZTfIcJY=VL`00IW=VM6IcIWAVLfIdIW=VM6Ic001VLfZCIW=ZU6Ic
001RM6IeHWAVM000IWAVLfIdIW=VM6IcIWAVL`00IW<0069dIWERM6IeHWAVMF9dIWD000=VM00XHW<0
05ieHWINMF9f001VMF9dIWERM6IeHWAVMF9d001NMP00GWERUUieHYINMF:FGWERUUieHYINM@00GWIR
UUifHYMNMV:FGWIRUeifHYH2000065ZGGYMJUejGFYMNUeZGGYMJUejGFYL005ZGGYQJUejHFYMNV5ZG
GYQJUejH001J^P80000LFYQJ^EZHF[UJV5ZiFYP005JiF]YF^U[JE[T005JiF[UF^000E[YFfeJjE]]F
^UKKE[YFfeJjE]/200003UKJE]]FfUKKE]YFfeKJ001BfeKLD]]Fg5;KE]`200003eKJE]/005KLD]]F
g5;KE]aBfeKLD]]Fg000E_aBf`0200004EKlD]]Fo5;KE_`005KlD]]Fo5;KE_aBfeKlD]/005;lE_`0
0P0000ABfeKlD]]Fo0<00007E_aBo5KlD_]Fo5;lE_`00`00011Fo5;kE_aBneKlD_]Fo5;k001BneKl
D_aFo5;kE_aBo0<0000<D_aFo5;kE_aBo5KlD_]Fo000D_aBneKl0U;l0P0000ABo5Kl001Fo09Bo006
D_]Fo5;lD_aBn`000e;l00=Fo5;lD_`00P0000ABo5Kl001Fo09Bo006D_]Fo5;lD_aBn`000U;l0`00
00MBo5;kE_aBo000D_aFo003D_`01UKlD_aBo000E_aBo0<0009Bo003D_]Fo000009Bo006E_aBo5;l
D_aFo5;l10000U;l00IFo5;lD_aBo5Kl0002D_`01UKlD_aBo5;lE_aBo08003]oo`009goo00<007oo
Ool02Woo00<006gZKNX016gZ00d006g8KNQ]b6gXKLQ]j000JHAYPfV4JH<0000AOol00`00IW=ZL`02
JW<026IcJW=ZLfYcIW=ZL`00IW@3IW<03FIdIW=VLfIc001VLfYcIW=ZLfIcJW<006Id009RM003001V
M6Ic00=VM007IW=VM6IdIW@006ZC00001f9d00<006IdIW@016Id00h0069eHWENM@00HWAVMF9dHWER
M6IeHWARMF9d0P002V9e0P0000eNUUifGYINMUjFGWINUUifGYINMP00HYD00009GYL01@00GYH005ZH
GYP00eZH015NV5ZHFYQJV5jH001J^5ZHF[UJV5ZhFYQJ^EZHF[QJV00000=F^P03001J^EZi00=J^@08
001F^UKJE[YFfUJjE]YF^P80000=F[X005KKE]YFfeKJE]]FfUKKE]X005;KE]/00`0000=FfeKJE]/0
0UKK00T005KKD]]Ffe;KE]]BfeKKD]/00`0000UBfeKKD]]Fg5;KE]]Bf`00D_/00U;l00EFo5;kD_aB
o5Kl00<00003E_aBne;l00<00003D_`005;l00EBo0800003E_aBn`0000QBo004001Bo5;lD_`40002
D_`00`00D_aBo007D_`00`00D_aBo0020005D_`00`00D_aBo006D_`00`00D_aBo0030004D_`20007
D_`30008D_`00`00D_aBo005D_`30008D_`00`00D_aBo003D_`20002D_`00`00D_aBo006D_`00`00
D_aBo004D_`200000e;l0000000jOol002Ioo`<000aoo`0C001^2VWZKP]]jVh:001]j6g8KNQYafgX
KLP006V3KHAYPfV4JH<00P003goo03@006ZCIW=ZTfIcJY=VLfZCIW=ZT`00KY<006IdIW=VM6IcIWAV
LfId001ZTfIcJYAVLfZCIW=ZU000IWARM000IW=VM6IcIWAVLfIdIW=VM000JYAVL`00HWAVMF9dIWER
M6IeHW@0009VM01@HW=VM6IdIW@0069fGWD0069dIWERM6IeHWAVMF9dIWERM6Ie001RUUieHYINMF:F
GWERUUieHYINMF:F001VU@00HYMNMV:FGWIRUeifHYINMP00HWERUP00GYMJUejGFYMNUeZGGYMJU`00
GYIRU`00GYQJUejHFYMNV5ZGGYQJUejH001NU`00F[UJV5ZiFYQJ^EZHF[UJV5Zi001JfP80000<E[UJ
^EJhF[UF^EZiE[P005JjE]]F^UKK0P0000eF^EZjE[T005KJE]]FfUKKE]YFfeKJE]]FfP0200003eKK
D]YFfeKJE]]BfUKKE]X005;KE]aBfeKLD]]Fg00200003e;JE]/005KlD]]Fo5;KE_aBfeKlD]/005;K
E_aBf`0400000eKlD]/00003000025KlD]]Fo5;KE_`005KlD_/300003E;KE_aBfeKlD]/005;kE_aB
neKlD_]Fo5;k00@0000@E_aBneKlD_]Fo5;kE_`005KlD_aFo5;kE_aBo5KlD_/300002U;kE_aBo5Kl
D_]Fo5;l001BneKl0U;l00ABneKlD_aBo0<0000;E_aBneKlD_aFo5;kE_aBo000D_]Fo002D_`01U;k
000005KlD_/0009Bo007D_]Fo5;lD_aBneKl00000U;l00=Fo00000000P000U;l00H005KlD_aBo5;k
E_`2D_`015;k001Bo5;l0`0000=Bo5;kE_`00U;l00<005KlD_`00U;l00EFo5;lD_aBo000009Bo0<0
0005D_aBneKlD_`0000jOol002Ioo`03001oogoo00aoo`03001]jVgZ00A]jP0?001]j6g8KNQ]b6gX
KLP006V3JHAYPfV4001Lh00000eoo`05001ZLfYcJW=VL`03JW<026IcJW=ZL`00JY<006IcIW@3IW<0
3VIdIW<006IcJW=VLfYcIW=ZLfIc001RM000IW<3IW@02FIcIWAVM6IdIW<006IcJY@00006HW@00`00
IWAVM005IW@03@00GWD0069dIWERM69eHWAVMF9dHWERM6Ie008000YRM@0A001RUF9e001NMUjFGWIN
UUifGYINMP00HYERUV:EHYH00006GYL01P00GYINUUjFHYH0009JV006GYQJV5ZHFYQNV0000UjG00`0
05ZHF[QJV5ZiFYQJ^5ZHF[UJV5Zh0009F[T00`00E]YF^P0200003EZiE[UJ^UJiF[UF^@00E]YFfeKJ
E]]FfUKK00800005E[X005KKE]]FfP03E]/01UKJE]]Ff`00D]]Ff`<000AFf`0:001BfeKLD]]Ffe;K
E]aBfeKKD]/300001E;KE]aBfeKKD]/00`0000=Bo5KlD_/00U;l00=Fo5;k00000P0000EBne;lD_aF
o5;k009Bo003E_`005;l00ABo0800003D_]Bo00000QBo003001Bo5;l00ABo080009Bo003001Bo5;l
00IBo004001Bo5;lD_`40002D_`00`00D_aBo006D_`2000015;l0000000015;l00<005;lD_`01U;l
10001e;l00<005;lD_`01E;l0`0025;l00<005;lD_`01U;l0`0025;l00<007ooOol0=goo000VOol0
0`00Oomoo`0<Ool05`00KP]]jVh:JNY^2fgZ001YafgXKLQ]j6W7KNP006V4JH=]Q6V3JH@005cP0000
37oo00/006IcJY=VLfZCIW=ZTfIcJY=VL`00009ZT`0Y001VM6IcIWAVLfIdIW<006IcJYAVLfZCIW=Z
U6IcJY<006Ie001VM6IcIWAVLfIdIW=VM6IcIW@006ZDIW=ZU000IWERM6IeHWAVM@00IWARL`03IW@0
0f9cIWAVM0020000?6IeHWAVMF9dIWERM6IeHWAVMF9d001VM000GWERUUieHYINMF:FGWERUP00IYER
M6JEHW@005ifHYMNMV:FGWH0069eHYINMF:FHWD005ZGGYMJUejGFYL005jFHYMNUV:GGYH005ZGGYQJ
UejHFYMNV000GYMNUP9NU`0E001JV5ZiFYQJ^EZHF[UJV5Zi001NV000F[UF^5ZiE[UJ^EJhF[UF^EZi
0080000=E[UJ^UJiF[YF^EZjE[UJ^UJi001FfUKKE]X00P0000iJ^UJiF[YF^@00E]YFfe;JE]]FfUKK
D]YFfeKJ0P0000mFfe;JE]]BfUKKD]YFfe;J001BfeKlD]]Fo5;KE_`00P0000EBf`00D]]Fo5;K00<0
0008D]]Fo000E_aBfeKlD]]Fo080000?D]]Fo000E_aBfeKlD]]Fo5;KE_aBfeKl001Fo5;k0080000A
E_aBfeKlD]]Fo000E_aBneKlD_]Fo5;kE_aBn`00D_]Fo00300003EKlD_]Fo5;k001Bo5KlD_]Fo5;l
E_aBneKl00@0000?D_aFo5;kE_aBo5KlD_/005;lE_aBneKlD_aFo5;k00<0000:D_]Fo5;lE_aBneKl
D_aFo000E_`2D_`02U;kE_`00000D_]Fo000D_aBneKl0U;l00IBneKlD_`005;kE_`2D_`01U;k0000
05KlD_/0009Bo00;D_]Fo5;lD_aBneKlD_`005;lE_aBo00400000e;lD_/00002D_`01e;kE_aBo5;l
D_]Fo00003Uoo`009Woo00<007oo000037oo00<006gZKNX016gZ010006gXKLQ]j6g8KNQ]b6gX001Y
Q6V3JHAYPfV4001Lh08000Yoo`03001ZLfIc00=ZL`05IW=ZLfYcJW<00002JY<01@00IW=VLfIcIW@0
0VIc00/006YcIW=ZLfIcJW=VLfYcIW=ZL`0000=VM00<IW=VM6IdIWAVLfId001ZU6IcJY=VL`00169d
00<006IdIW@01fId00l006IeHWARMF9dIWERM69eHWAVMF9d001VM6JD0000269e0180069eIYERMF:E
001NUUifGYINMUjF001RUV:EHYIRUF:F0005GYL01000GYINUV:F0ejF00@005ZHFYQJV08000ENU`07
001J^EZHF[QJV5ZiFYP00P0000=NV5ZG000025Zi00h005jh001J^EJiF[YF^EZiE[UJ^UJiF[T005KK
0P0000=F^UZjE[X00UJj00=J^UJj00000UKK00AFfUKKE]]Ff`800003E[X005KK00QFf`04001BfeKL
D]/20003E]/400001e;KE]aBfeKKD]]Fg000009Bo0800008E]]BfeKLD]]Ff`00E_aBn`9Bo004E_aB
ne;lD_`300000e;lE_aBn`02D_`00eKlD_/00008D_`30008D_`00`00D_aBo003D_`20002D_`00`00
D_aBo006D_`01000D_aBo5;l10000U;l00<005;lD_`01U;l00<005;lD_`00`001E;l00<005;lD_`0
1U;l00<005;lD_`00P001E;l00<005;lD_`01U;l10001e;l00<005;lD_`01E;l0P00>7oo000VOol2
000=Ool06@00KPYYjVh;KNY^2VWZKP/006gXJLM]j6g8KNQYa`00JH=YQ6V3KHAYPfV4001Lh5c00080
00Moo`0e001ZTfIcJY=VLfZCIW=ZTfIcJY=VL`00JY=^TfZC001VLfIdIW=VM6Ic001VLfZCIW=ZU6Ic
JY=VLfZDIW<006IcIWAVLfIdIW=VM6IcIWAVL`00IW=ZU6IcJY@006IeHWAVMF9d001RL`03IW@0?V9c
IWAVM6IdHW<0069dIWERM6IeHWAVMF9dIWERM6Ie001VUFId001NMF:FGWERUUieHYINM@00HWAVUF9d
IYERM000GWIRUUifHYL006:FGWERUV9eHYINMF:F001NUeZGGYL006:GGYIRUejFHYMNUV:G001NV5ZG
0002GYL0=EjFGYMNUejGGYINU`00F[UJV5ZiFYP005ZGGYQJUejHFYL005JiF[UF^5ZiE[UJ^@00G[UJ
V000E[UJ^UJiF[YF^EZjE[UJ^UJiF[X005ZjE[UJ^UJiF[YF^EZjE[UJ^P00E]]FfUKKD]X00P0000mJ
fUJjF]X005KKD]YFfe;JE]]BfUKKD]YFf`00E_`00P0000=BfUKKD]/0100000QFo5;KE_aBfeKlD]]F
o5;K0`0000iBfeKlD]]Fo5;KE_aBf`00D]]Fo5;KE_aBfeKl0P0000mBfeKl001Fo5;KE_aBfeKlD]]F
o5;K001BneKlD_/0100000iFo5;K001BneKlD_]Fo5;kE_aBneKl001Fo5;l0`0000eBfeKlD]]Fo5;K
001BneKlD_aFo5;kE_aBo00400003eKlD_]Fo5;lE_aBneKl001Fo5;kE_aBo5KlD_]Fo00300002EKl
D_aFo5;kE_aBo5KlD_/00002D_`01U;kE_aBo5;lD_]Fo0<00009E_aBo5KlD_]Fo5;lE_`005Kl009B
o003D_]Fo5;l00800005E_aBo000D_]Fo002D_`01U;kE_aBo5;l001Fo09Bo0@00003D_]Fo00003Mo
o`009Woo00<007ooOol03Goo00<006gZKNX016gZ01<006g8KNQ]b6gXKLQ]j6g8001YPfV4JH=YQ6V3
001L`5cPG<1Lh0020005Ool00`00IW=ZL`02JW<01VIcJW=ZLfYcIW<000AZT`03001VM6Ic009VL`0>
001VLfYcIW=ZLfIcJW=VLfYcIW=ZL`00IWAVL`=VM00;IW=VM6Id001VLfZCIW=ZU6IcJY<00002HW@0
0`00IWAVM007IW@04@00IY<0069dIWERM69eHWAVMF9dHWD006JDIWAVU6Id00001F9e01D0069eIYER
MF:EHWEVUF9e001NMUjF001RUV:EHYIRUF:FHYERUV:E00000UjG00@005jFGYIRUP=NUP03HYINUUjF
008000UNU`0<001JV5ZiFYP005jGGYQJUejHGYMNV00015Zi0P0000aN^5ZHF[QJV000E[UJ^EJiF[YF
^EZiE[T200000eZi001J^P03E[X01eZjE[YF^UJjF[X005KK00800007E[YFfUJjE]YF^UKJ000025KK
0P000UKK0`0015KK00H005KLD]]Ffe;KE]`20002E]/03000E]]BfeKLD]]Ffe;KE]aBf`00D_aFo0<0
0006E]aBfeKKD]]Fg0000U;l00EFo5;kD_aBo5Kl00@00005D_]Bo5;lE_aBn`02D_`00`00D_aBo005
D_`30008D_`00`00D_aBo003D_`20002D_`00`00D_aBo006D_`20004D_`20002D_`00`00D_aBo007
D_`01000D_aBo5;l10000U;l00<005;lD_`01U;l00<005;lD_`00`0015;l00<005;lD_`01U;l1000
1U;l00<007ooOol0=Goo0008Ool40006Ool20006Ool50006Ool00`00Oomoo`0>Ool05000KNY^2VWZ
KP]]jVh:001]j6g8KNQYafgXKLQ]j000KHAYPfV4JH<:0003Ool03000JY=VLfZCIW=ZTfIcJY=VLfZC
001^T`=ZT`0T001VLfIdIW=VM000JY=VLfZDIW=ZTfIcJYAVLfZC001^U000IWAVLfIdIW=VM6IcIW@0
06ZDIW=ZU6IcJYAVL`00HWAVM@000fId035RLfIdIWAVM69cIW@006ZD001VMF9dIWERM6IeHWAVMF9d
001VM6JDIWAVU@00HYINMF:FGWD0069dIYERM6JEHWAVUF9dIYD006:G001RUUieHYIRMF:FGWERUV9e
HYINM@0200002f:GGYIRUejFHYMNUV:GGYIRUejF00000UjG00ENUUjGGYMNUejF00=NU`0lGYH00000
001JUejHFYMNV5ZGGYQJUejH001J^EJi001JV5jiFYQN^5ZHG[UJV000E[UJ^UJiF[YF^@00F[QJ^EZh
001F^EZjE[UJ^UJiF[YF^EZjE[UJ^P00F]YF^U[JE[YJfUJjF]YF^U[J001Ffe;JE]]BfUKK0P0000iF
^P00000005;KE]]BfUKKD]]Ffe;J001BfeKl0`0000eFfe;JE]]BfeKK001Fo5;KE_aBfeKlD]]Fo003
00003UKlD]]Fo5;KE_aBfeKlD]/005;KE_aBfeKlD]/200004EKlD]/005;KE_aBfeKlD]]Fo5;KE_`0
05KlD_]Fo5;kE_`00P0000mBfeKl001Fo5;KE_aBfeKlD]]Fo5;KE_`005KlD_/00P0000iFo5;KE_aB
feKl001Fo5;lE_aBneKlD_aFo5;k0P00015Fo000001BneKlD_]Fo5;k001BneKlD_aFo5;kE_aBo5Kl
00@0000?D_]Fo5;lE_aBneKlD_`005;kE_aBo5KlD_]Fo5;l00<0000<D_aFo5;kE_aBo5KlD_]Fo000
D_aBneKl0U;l0P0000aBo5Kl001Fo5;lE_aBneKlD_aFo5;k000fOol000Moo`03001oogoo009oo`03
001oogoo00=oo`8000Qoo`03001oogoo00Ioo`03001oogoo00ioo`03001]jVgZ00E]jP08001]j6g8
KNQ]b6gXKLQ]j0@00004KNY^2P00KNT3KNP00fgY001]Y@030003JW<01fIcJW=ZLfYcIW=ZL`0000EZ
T`0B001VLfIcIWAVL`00IW=ZLfIcJW=VLfYcIW=ZLfIc001ZT`000VId00mVLfIdIWAVM6Ic001VLfZD
IW=ZTfIcJY@0069d00002FId01<006ZDIYAZU000HWERM6IeHWARMF9d001VM6JDIWAVU6IdIY@00003
HWD02P00IYERMF:EHWEVUF9eHYERMFJE0P0000]RUF:FHYERUV:EHYIRUF:FHYERUP00009NUP05HYIN
UUjFGYIRUP03GYH2000;GYL07@00GYQNUejHFYMNV5jGGYQJUejHGYL005Zi001JV5jhFYQJ^5ZHG[QJ
V5ZhFYP005JiF[UF^@00F[P00eZi00AJ^000E[YJ^P=F^P0?F[YF^P00001J^@00E]YF^UKJE[YFfUJj
E]YF^P00009Ff`H0009FfP03001FfeKK00EFf`<000QFf`06001BfeKKD]]Fg5;K0P000UKK00d005;K
E]aBfeKKD]]Fg5;KE]]Bf`00D_]Bo00200002E;KE]]BfeKLD]/005;lE_aBn`02D_`015KlD_]Bo000
0U;l0P0000IFo5;KD_aBg5Kl0008D_`30007D_`00`00D_aBo006D_`30007D_`00`00D_aBo004D_`2
0002D_`00`00D_aBo006D_`01000D_aBo5;l10000U;l00<005;lD_`01U;l00<005;lD_`00`0015;l
00<005;lD_`01U;l0P00=Goo0007Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool0
0`00Ool0000>Ool03P00JNY^2fgZKPYYjVh;KNX006W7KNQ]b6gXJLL300006VWZKP]]jVh;JNY^2`00
KNU]j6gYKNQ]j@00KJEYY000IW=ZTfIcJY=VLfZCIW=ZTfIc0003JY<04FjCJY=ZT`00IWAVL`00IW=Z
U6IcJY=VLfZDIW=ZTfIc00000VZC018006IdIW=VM6IcIWAVL`00IW=ZU6IcJYAVLfZDIW<0069d0002
IW@01F9cIWAVM6IdHW<00VId02/006JCJYAVT`00HWAVMF9dIWERM6Ie001VU6IdIYEVM6JDIW@005ie
HYH006JEHWAVUF9dIYERM6JEHWAVUF9d001NMF:FHWERUUieHYIRMF:FGWERUP0200003EjFHYMNUV:G
GYIRUejFHYMNUP00HYERUP0000=NU`0PGYINUejGGYMNUUjG001RU`00GYQJUejHFYMNV5ZGGYQJUejH
FYL005ZHG[UJV5jhFYQN^EZHG[QJV5ji001J^P80000?F[QJ^EZhG[UJ^5Zi001J^UJiF[YF^EZjE[T0
05Ji009J^@0:001F^U[JE[YJfUJjF]YF^U[JE[X500002eJjE]YF^U[KE[X005;JE]]BfeKKD]X00P00
00mFfeJj001BfeKKD]YFfe;KE]]BfUKKD]/005;KE_`00P0000iBfeKKD]]Ffe;K001BfeKlD]]Fo5;K
E_aBfeKl0`00011Fo5;KE_aBfeKlD]]Fo000E_aBfeKlD]]Fo5;KE_aBf`<0000>D]]Fo5;KE_aBfeKl
D]/005;KE_aBfeKlD]]Fo080000?D]]Fo000E_aBfeKlD]]Fo5;KE_aBf`00D_]Fo5;l00@0000>E_aB
f`00D_]Fo5;kE_aBneKlD_]Fo000E_aBn`<0000=D_]Fo5;kE_`005KlD_aFo5;kE_aBo5KlD_/01000
00mFo5;lE_aBneKlD_`005;kE_aBo5KlD_]Fo5;lE_`00`00011Fo5;kE_aBo5KlD_]Fo5;l001BneKl
D_aFo5;kE_aBo08003Eoo`001goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol01Woo0P00
47oo00<006gZKNX016gZ00@006gXKLQ]j080000<JP]^2`00KPY]jVh:KNY^2VgZ001]j6gY0fgX00<0
06VU00000VYc00EVLfYcJW=ZLfIc00=ZL`03001ZTfZC00AZT`0>001VLfIc001ZLfIcJW=VLfYcIW=Z
LfIcJW<0009ZT`03001VLfId009VM00<IW=VM000JYAVLfZCIW=ZU6IcJY=VL`002VId01l006ZDIY=Z
U000IWERM69eHWAVM@00IYAVM6JDIWAVU6IdIY@0069e001VUF9eHYERMFJEHWERUF9eIYERM@020000
3F:FHYERUV:EHYIRUF:FHYERUV:E001RU@0000=NUP06HYINUUjFGYIRUP000V:F00<005jGGYL01UjG
01d006:FHYH005ZGGYQNUejHFYMNV5jGGYQJU`00GYL005ZHF[QJV5jhFYQJ^5ZHG[QJV5Zh001J^EZh
00=J^@05F[QJ^EZiF[T00002E[X00eZj00000005F[T01`00E[YFfUJjE]YF^UKJ00@000UFfP03001F
feKK008000EFfP03001FfeKK00IFf`<000MFf`07001Ffe;KE]aBfeKKD]/00P000UKK00X005;KE]]B
feKLD]]Ffe;KE]`0009Bo003E_`000000080000<D]]Ff`00E_aBfe;lD]aFo5;KD_aBg0000U;l0`00
00EBo5;LE_aBf`0000QBo0@00003D_aFo5;l009Bo003E_`0000000MBo0<000QBo003001Bo5;l00=B
o080009Bo003001Bo5;l00IBo003001Bo5;l00=Bo080009Bo003001Bo5;l00IBo004001Bo5;lD_`4
0002D_`00`00Oomoo`0bOol000Moo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00Ioo`03
001oogoo00moo`08001^2VWZKP]]jVh:JNY^2`<0000BKPaYjfh<JN]^3000KP]YjVh;KNY^2`00KNU]
j6gYKNQ]jFgX0P0000YZTfIcJY=VLfZCIW=ZTfIcJY<0009ZT`0XKY=ZTfZCJY=^T`00IW@006ZDIW=Z
TfIcJYAVLfZCIW=ZU6Ic001ZTfjDJY<006IcIWAVLfIdIW<006IcJYAVLfZDIW=ZU6IcJY@006IdHW<3
IW@0669cIWAVM6Id001ZU6JCJYAVTfZD001VMF9dIWERM000IWAVUFIdIYAVM6JEIWAVU080000WHWAV
UF9dIYERM6JEHWAVUF9dIYD006JE001RUUieHYIRMF:FGWERUV9e001RUFJF001RUejFHYMNUV:GGYIR
U`00HYIRUF:FHYD005jF00=NU`0YGYINU`00HYMNUV:GGYH005ZGGYQJUejHFYMNV5ZG001NUf:G001N
^5ZHG[UJV5jhFYQN^EZHG[P005jh001J^EZhG[UJ^5ZiF[QN^EZh001F^@0200000eZiE[UJ^@02F[T0
1eJiF[UJ^@00E[YJfUJj00<0000=E[UJ^P00F]]F^UKJE[YJfeJjE]YF^U[KE[X00P0000iJfeJjE]]F
^U[KE[YFf`00E]]BfeKKD]YFfe;K0P0000iFfeKJ001BfeKKD]]Ffe;KE]]BfeKK001Fo5;K0`0000eB
feKKD]]Ff`00E_aBfeKlD]]Fo5;KE_aBf`0400003eKlD]]Fo5;KE_aBf`00D]]Fo5;KE_aBfeKlD]]F
o00300003UKlD]]Fo5;KE_aBfeKlD]/005;KE_aBfeKlD]/200004EKlD]/005;KE_aBfeKlD]]Fo5;K
E_`005KlD_]Fo5;kE_`00P0000iBfeKl001Fo5;kE_aBneKlD_]Fo5;k001BneKl0`00011Fo5;kE_aB
n`00D_aFo5;kE_aBo5KlD_]Fo000E_aBn`<0000=D_]Fo5;kE_`005KlD_aFo5;kE_aBo5KlD_/01000
00QFo5;lE_aBneKlD_aFo000<goo0007Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`06
Ool00`00Oomoo`0?Ool00`00KNY]jP05KNX03`00JP]^2fX;KP]Z2fh;JP/006gZKPY]jVh:KNX00003
KNP00fgYKNQ]j00200001FIcJW=ZLfYcIW<00fYc00=VL`00JY<01VZC00d006Ic001VLfYcIW=ZLfIc
JW=VLfYcIW<00004JY<00`00IWAVL`02IW@02`00IW=ZTfIcJYAVLfZCIW=ZU6Ic00002FId034006JC
JYAVU6ZDIY<0069dIWERM000IWAVU6IdIYAVM6JDIWAVU6Id001RMF:EHWEVUF9eHYERMFJEHWERU@00
IYEVU000HYERUV:EHYIRUF:FHYD006:EIYERUFJE001RUP03GYH00f:F001RUP04HYH00`00GYMNU`03
GYL03P00HYIRUV:GGYIRUP00GYQJUejHGYMNV5ZG0004GYL01`00G[QJV5ZhFYQN^5ZH00800003GYQN
U`00009J^@05F[QJ^EZiF[UJ^002F[T00`00F[UJ^@08F[T00`00E]X000020005F[T00`00E]YFfP05
E]X200000eZi001FfP07E]X00`00E]]Ff`0300000eKJE]]FfP02E]X00`00E]]Ff`05E]/30008E]/0
1P00E]aBfeKKD]]Fg080009Ff`0?001Ffe;KE]aBfeKKD]]Fg5;K001Bg5KlD]]Bo5;L0080000<E]]B
f`00D]]Bo5;LE_aBfe;lD]aFo0000U;l0`0000IBfeKlD]]Bo000E_`3D_`015KlD_aBo5;l0P0000AB
o0000000009Bo003E_aBn`0000QBo0<000QBo003001Bo5;l00EBo0<000QBo003001Bo5;l00=Bo080
009Bo003001Bo5;l00IBo003001oogoo035oo`001goo00<007ooOol00Woo00<007ooOol03Goo00<0
07ooOol01Goo00<007oo000047oo00H006h;KNY^2VWZKP/300008Fh<JN]^36W[KPaYjfh<001^2fgZ
KP]YjVh;KNX006gXKNU]j6gYKNP006Zc001VLfZCIW=ZTfIcJY=VL`00JY=^T`03JY<016jCJY=ZTfZC
0P0000]ZTfIcJYAVLfZCIW=ZU6IcJY<006jD00=ZT`0A001VLfIdIW=VM000JYAVLfZDIW=ZU6IcJYAV
L`00JY<00002IW@0DV9cIWAVM6IdHW=VM000JYAVTfZDIY=ZU000IWERM6Ie001VUFIdIYAVM6JEIWAV
U6IdIYD006JEHWAVUF9dIYERM6JEHWAVUF9d001VU6JE001RUV9eHYINMF:FHWERUP00IYIRUFJEHYD0
05jFHYMNUV:G001RUV:EHYIRUF:FHYERUP00GYMNUUjG001RUejFHYMNUV:GGYIRU`00GYQJUejH0P00
01QNUf:GGYMRUejG001JV5jhFYQN^EZH001JUejhGYMN^5ZG001J^5ZiF[QN^EZhF[T200000eZH001F
^@03F[T015JiF[UJ^EZi0`0000iJ^UJiF[YF^EZjE[UJ^UJiF[X005[KE[YFfUJj0P0000eJfUJiF]X0
05KKE[YJfeJjE]]F^U[KE[YFf`0200003UKJE]]FfUKKE]YFfeKJE]/005KKD]]Ffe;KE]/200003UKJ
E]/005KKD]]Ffe;KE]]BfeKKD]/005;KE_`3000045KKD]]Ffe;K001BfeKlD]]Fo5;KE_aBfeKl001F
o5;K0`0000eBfeKlD]]Fo5;K001BfeKlD]]Fo5;KE_aBf`03000045;KE_aBfeKlD]]Fo5;KE_`005Kl
D]]Fo5;KE_aBfeKl0`0000iFo5;KE_aBfeKlD]]Fo5;K001BneKlD_]Fo5;k0P0000mFo5;K001BneKl
D_]Fo5;kE_aBneKl001Fo5;lE_`0100000iBfeKl001Fo5;kE_aBneKlD_]Fo5;k001BneKl0`0000eF
o5;kE_aBn`00D_aFo5;kE_aBo5KlD_]Fo002000bOol000Moo`03001oogoo009oo`03001oogoo00eo
o`03001oogoo00Eoo`80015oo`03001]jVgZ009]jP0D001Yk6W[001Z2fh;JP]^2fX;KP]Z2`00KNY^
2VgZKPY]jVh:001]j@=]j006KNT006jc001ZLfIc0fYc00=VLfYc00002FZC00`006YcIW=ZLfIcJW=V
LfYcIW=ZLfIc0004JY<04@00IWAVM6Id001ZTfIcJYAVLfZCIW=ZU6IcJY<006ZD00001fId024006ZD
IYAZU6JCJYAVU6ZD001RM@00IYAVM6JDIWAVU6IdIYAVM6JD001ZU000IYERMF:EHWEVUF9eHYERM@00
IY@00fJE014006:FHYERUV:EHYH006JEHYEVUF:EIYERU@00GYIRUP0000QRUP04001NUejG0002HYH0
2V:GGYIRUV:FHYMNUP00GYMNV00025jG00`005ZHG[QJV000GYMNV5jGGYQNUejH0003F[T01eZhF[T0
05jhF[QN^00000EJ^@<00004F[T005Zh0008F[T00`00E]YFfP0200001eJiF[YJ^EZjE[UJ^P0000IF
fP800005F]X005KJE]YFf`03E]X015KKE]YFfP000UKK0P0000EFfeKJE]]FfP0000UFf`8000QFf`08
001BfeKKD]]Fg5;KE]]Bf`<0000>D]]Fg5;KE]]BfeKLD]]Ff`00E_aBfe;lD]aFo080000?D]]Fg000
D_aBfeKlD]]Bo5;KE_aBf`00D_aFo5;l00@00004D_aBf`000002D_`01UKlD_]Bo5;lE_`0009Bo0<0
0005D_aFo5;kD_`00008D_`40007D_`00`00D_aBo005D_`30008D_`00`00D_aBo003D_`20002D_`0
0`00Oomoo`0_Ool000Moo`03001oogoo009oo`03001oogoo00]oo`<000Moo`03001oogoo015oo`0W
001YjVh;001Yk6W[JNaYj`00JN]^36W[KPaYjfh<001^2fWZKP]]jVh;JNX006gXKNU]j6gY001^]6Zc
001VLfZCIW=ZTfIcJY=VL`0000=ZT`0AKY=ZTfZCJY=^TfZC001VLfZDIW=ZTfIcJYAVLfZCIW<00003
JY<056jDJY=ZT`00IWAVL`00IW=ZU6IcJYAVLfZDIW=ZU000KYAZT`00HW<3IW@0@F9cIWAVM000IY=Z
U6JCJYAVTfZDIY<0069d001VM6JDIWAVUFIdIYAVM6JEIW@006JD001RM6JEHWAVUF9dIYERM6JE001V
UFJDIYEVU000GWERUV9eHYH006JFHYEVUF:EIYIRUFJE001RUejF001RUF:FHYERUV:EHYIRUF:FHYD0
0P0000YRUejFHYMNUV:GGYIRUejFHYMNUP80000;HYMNUf:GGYMRUejGHYMNUf:G001N^@02000055ZG
G[QNUejhFYMN^5jGG[P005jiF[QJ^@00G[QJV5jhFYQN^000F[T3000045ZiE[T00000G[UJ^000E[UJ
^UJiF[YF^EZjE[UJ^UJi0P0000eJfUJiF]YF^E[JE[UJfUJiF]X005KKE[YJf`0200003UJiF]YF^@00
E]YFfeKJE]]FfUKKE]YFfeKJE]/200003UKJE]]FfUKKE]YFfeKJ001BfeKKD]]Ffe;KE]/2000045KJ
001BfeKKD]]Ffe;KE]]BfeKKD]/005;KE_aBfeKl0P0000mBfeKK001Fo5;KE_aBfeKlD]]Fo5;KE_`0
05KlD]/00P0000eFo5;KE_aBfeKl001Fo5;KE_aBfeKlD]]Fo00400003e;KE_aBfeKlD]]Fo5;K001B
feKlD]]Fo5;KE_aBf`0300003U;KE_aBfeKlD]]Fo5;KE_`005KlD_]Fo5;kE_`200003e;KE_`005Kl
D]]Fo5;KE_aBfeKlD]/005;kE_aBn`0400003UKlD]/005;kE_aBneKlD_]Fo5;kE_`005KlD_`30000
1E;kE_aBneKl00003Woo1@001Goo0P001Woo10003Goo0008Ool4000@Ool00`00Oomoo`05Ool00`00
Oomoo`0AOol3000056W/JN]Yk6W[JN`006h;JP]^2fX;KP]Z2fh;001^2VgZKPY]jVh:0002KNP00fgY
KNP00002K[<01@00JW=ZLfYcIW<00VYc00<006ZCJY<026ZC00/006YcIW=ZLfIcJW=VLfYcIW=ZL`00
00IZT`0=001VLfId001ZU6IcJY=VLfZDIW=ZTfIc00000fZC00<006IdIW@00fId020006JDJYAVTfZD
IYAZU6JCJYAVU000IWAVU6IdIYAVM6JDIWAVU6Id001VU6ZDIY@0069eIYERMF:EHWEVU@000fJE011V
U6JEIYD006:EHYIRU@00HYEVUF:EIYERUFJEHYEVU@8000YRUP05001RUV:FHYMNUP02HYH01V:GGYIR
UV:FHYL000]NU`0=001NV5jGGYQNUejHGYMNV5jGGYQNU`00F[P00P0000=N^5ZhG[P00Ujh0`0015Zi
00L005ZhF[QJ^5jiF[P00006F[T200003EZi001F^EZjF[UJ^UJiF[YJ^EZjE[T005KJ00800007F]YF
^U[JE[YJfUJj00000eKJ00AFfeKJE]YFfP80000;E]X005KKE]YFfeKJE]]FfUKKE]X00003E]/20003
E]/00`00E]]Ff`07E]/00`00E]aBf`020005E]/02@00E]]BfeKLD]]Ffe;KE]aBf`0300003E;KE]]B
feKLD]]Ffe;K001Bfe;lD]]Fo5;K0080000?E]aBf`00D]]Fo5;KD_aBfeKlD]]Bo5;K001Bne;l00@0
0003D]]Fo000009Bo007E_aBne;lD_aFo5;k00000U;l0`0000IFo5;kD_aBo5Kl0007D_`40003D_`0
15KlD_aBo00025;l0`0025;l00<007ooOol03Goo00<007ooOol01Goo0P001Goo00<007ooOol00Woo
00<007ooOol02Woo000TOol00`00Oomoo`0AOol09P00JN]Yk6W[JNaYjfW/JN/006W[KPaYjfh<JN]^
36W[001]jVh;JNY^2fgZKP/006gYKNQ]j@00K[AZ/fjd001ZTfIcJY=VLfZC0002JY<01FjCJY=ZTfZC
KY<00VZC00/006jd001ZTfIcJYAVLfZCIW=ZU000009ZT`0HKYAZTfZCJY=^U000IW@006ZDIW=ZU6Ic
JYAVLfZDIW=ZU000JYAZTfjD001VM69c0fId04X006ZDIY=ZU6JCJYAVTfZDIY=ZU000IYAVM6JEIWAV
U6IdIYEVM6JD001ZUFJDJY@006JEHWAVUF9dIYERM000IYAVUFJDIYEVU6JE001RUUie001RUFJEHYEV
UV:EIYERUFJFHYD006:EHYIRUF:FHYERUV:EHYIRUF:F001V]P00HYMNUV:GGYIRUejFHYMNUV:G0P00
00YNUf:GGYMRUejGHYMNUf:GGYMRU`80000@FYMN^5jGG[QJUejhGYMN^5ZGG[QNU`00FYQN^5ZHG[P3
00000ejhFYP00002F[T0;5Ji001J^5jiF[QN^EZhG[T005ZjE[UJ^UJiF[X005ZiF[QN^@00F]YF^E[J
E[UJfUJiF]YF^E[JE[T005JiF]YF^E[JE[UJfUJiF]YF^@00E]YFfeKJE]/200003UJjF]YF^P00E]YF
feKJE]]FfUKKE]YFf`00E]/200003eKJE]]FfUKKE]YFf`00E]]BfeKKD]]Ffe;KE]]Bf`0300003U;K
E]aBfeKKD]]Fg5;K001BfeKlD]]Fo5;KE_`200003U;KE]`005KlD]]Fo5;KE_aBfeKlD]/005;KE_`2
00003U;KE_aBfeKlD]/005;KE_aBfeKlD]]Fo5;KE_`300003eKlD]]Fo5;KE_aBfeKl001Fo5;KE_aB
feKlD]]Fo00300003UKlD]]Fo5;KE_aBfeKlD]/005;KE_aBfeKlD]/200004EKlD]/005;KE_aBfeKl
D]]Fo5;KE_`005KlD_]Fo5;kE_`00P0000aBfeKl001Fo5;kE_aBneKlD_]Fo5;k000?Ool00`00Oomo
o`0AOol00`00Oomoo`0:Ool002Aoo`80019oo`0H001Yk6W[JNaYjfW/JN]Yk000KP]Z2fh;JP]^2fX;
KP/006h:KNY^2VgZKPY]jP000VgX00<006jcK[<00Vjc00<006IcJW<00VYc00=VL`00JY<026ZC00/0
06jc001VLfYcIW=ZLfIcJW=VL`0000MZT`0<001VM000IW=ZTfIcJYAVLfZCIW=ZU0000VZC00AZU6ZC
JY<000AVM00O001VTfZDIYAZU6JCJYAVU6ZDIY<006IdIYAVM6JDIWAVU6IdIY@006ZDIYAZU6JDJY@0
06:EHWEVUF9e00000VJE015VU6JEIYEVUFJD001RU@00HYEVUF:EIYERUFJEHYEVUF:E008000YRUP04
001VUP00GYH2HYH02F:GGYIRUV:FHYMNUP00HYH00008GYL03`00H[MRU`00GYMNV5jGGYQNUejHGYMN
V5jG001N]`0400000ejhF[QN^002G[P01000F[T000000eZh00IN^EZhF[QJ^5ji0003F[T00`00F[UJ
^@03F[T02000F[YF^EZjF[UJ^UJiF[X200003EZi001F^U[JE[YJfUJjF]YF^U[J001FfeKJ0080000>
F]YF^UKJE[YJfUJj001FfUKKE]YFfeKJE]]FfP800003E]]FfUKK009Ff`05E]YFfeKKE]/00005E]/2
00000eKJE]/00008E]/00`00D]]Ff`030004E]/02@00D]]Fg5;KE]]BfeKLD]]Ff`0300003UKKD]]F
g5;KE]]BfeKL001Bo5;KE_aBfe;lD]/2000035KKD]/005;KD_aBfeKlD]]Bo5;K001Bn`9Bo00:E_aB
n`00001Fo5;K001Bo5KlD_/2D_`01EKlD_]Bo5;l00000U;l0P0000QBne;lD_aFo5;k001Bo5Kl0e;l
00=Fo5;l00000U;l0`0000EFo5;lD_aBo00000QBo08000ioo`03001oogoo015oo`03001oogoo00Yo
o`008goo00<007ooOol04Woo02L006W[JNaYjfW/JN]Yk6W[001Yjfh<JN]^36W[KPaYj`00JNY^2fgZ
KP]YjVh;001]jFgX001Z/fjdJ[=^]000JY=VLfZCIW<006ZCKY<00fZC015^TfZCJY=ZT`00J[=^]000
JYAVLfZCIW=ZU6IcJY<006jD00=ZT`0EKYAZTfZCJY<006IcJYAVLfZDIW=ZU6IcJYAVL`00JY=^U6ZC
JYAZT`00009VM00YHW<006JCJYAVTfZDIY=ZU6JCJYAVT`00JY<006IdIYAVM6JEIWAVU6Id001VU6ZD
IYAZUFJD001RM6JEHWAVU@00IYEVU6JEIYAVUFJDIYEVU0020000>6JEHYEVUV:EIYERUFJFHYEVU@00
I[H006:FHYERUV:EHYIRUF:FHYD006:EI[IRU@00GYIRUejFHYMNUV:GGYH006:FI[L006:GGYMRUejG
HYMNUf:G001R]ejFH[L005jhFYMN^5jGG[QJUejhGYL400005UjhFYQN^5ZHG[QJV5jhFYQN^000G[UJ
^5jiF[QN^EZhG[UJ^5jiF[P005Ji0P0000mJ^EZhG[UJ^5ZiF[P005JiF]YF^E[JE[UJfP00F[X00UZi
00X005[JE[UJfUJiF]YF^E[JE[UJfP80000>E[YJfUJjF]YF^U[JE[YJfP00E]]FfUKKE]YFf`80000>
E[YJf`00E]]FfUKKE]YFfeKJE]]FfP00D]]Ff`<0000=E]]FfUKKE]X005;KE]]BfeKLD]]Ffe;KE]`0
0`0000iFg5;KE]]BfeKLD]]Ffe;K001BfeKlD]]Fo5;K0P0000iFg5;K001BfeKlD]]Fo5;KE_aBfeKl
001Fo5;K0`00011BfeKlD]]Fo000E_aBfeKlD]]Fo5;KE_aBf`00D]]Fo080000>D]]Fo5;KE_aBf`00
D]]Fo5;KE_aBfeKlD]]Fo0<0000?E_aBfeKlD]]Fo5;KE_`005KlD]]Fo5;KE_aBfeKl00<0000>E_aB
feKlD]]Fo5;KE_aBf`00D_]Fo5;kE_aBn`800003E_aBf`0000eoo`03001oogoo015oo`03001oogoo
00Yoo`008goo00<007ooOol04goo01T006W[JNaYjfW/JN]Yk000KP]Z2fh;JP]^2fX;KP/006h:KNY^
2VgZKPY]jP00KNP00005K[<01P00JW=ZLfIcJW<000UZT`0;001^/fjc001VLfYcIW=ZLfIcJW<00009
JY<03000JY=VLfZDIW=ZTfIcJYAVL`00JY=ZU0=ZT`03JY@006Id009VM00Q001ZU6JDJYAVTfZDIYAZ
U6JCJY@006Zd001VU6IdIYAVM6JDIW@006JDJYAVU6ZDIYAZU000IYERMF:E001VUFJD00=VU@0?IYAV
UFJEIYD006JEHYEVUF:EIYERUFJEHYEVU@00009VU@03001RUV:F00IRUP07001VUV:EIYH006:GGYH0
0V:F00=RUejF000016:F00<005jGGYL00ejG00d006:gHYMR]f:FH[L005jHGYMNV5jGGYQNU`020000
1V:gG[MN]`00G[QJ^0=N^005F[QN^000G[P00002F[P01EjiF[QJ^5ZhG[T00eZh00<005ZiF[T01eZi
00@005ZiF[YF^@8000EJ^@07001JfUJjF]YF^U[JE[X00P0000eJ^@00F]YF^UKJE[YJfUJjE]YF^U[J
001Ff`030005E]X00`00E]]FfP03E]/00eKJE]/000020003E]/01UKJE]]FfeKKE]X000EFf`80009F
f`03001FfeKK00IFf`03001Ffe;K00<000AFf`09001Fg5;KE]]BfeKLD]]Ffe;K00<0000@D]]Fg5;K
E]]BfeKLD]]Ff`00E_aBfe;lD]]Fo5;KD_`3000025KlD]]Fo5;KE_aBfeKl0002D_`015KlD_]Bo5;l
0P0000AFo5;K001Bn`9Bo006E_aBne;lD_aFo0000U;l100000EFo5;k001Bo5Kl00=Bo004E_aBo5;l
0002D_`300001E;kD_aBo5Kl00003Goo00<007ooOol037oo1@003Goo000SOol00`00Oomoo`0COol0
5`00JNaYjfW/JN]Yk6W[JN`006h<JN]^36W[KPaYjfh<001^2fWZKP]]jVh;JNX00P0000]^]6ZcK[AZ
/fjdJ[<006IcJY<006jC00=ZT`0AKY=ZTfZCJY=^TfZC001Z/fjdJ[<006IcJYAVLfZCIW<00003JY<0
66jDJY=ZTfZCKYAZT`00IW=ZU6IcJYAVLfZDIW=ZU000KYAZTfZDJY=^U6ZCJY@0009VM00W001VTfZD
IY=ZU6JCJYAVTfZD001^]6ZD001VM6JEIWAVU6IdIYD006ZDIYAZUFJDJYAVU6ZE001VUF9d001VU6JE
IYAVUFJDIYEVU6JE0080000eHYEVUV:EIYERUFJFHYEVUF:E001VUFJeIYD006:EHYIRUF:FHYERUP00
I[IRUFJfHYEV]P00HYMNUV:GGYH006:FI[MRUV:fHYH005jGHYMNUf:GGYL005jFH[MNUV:gGYH005jG
G[QJU`0300009UjGH[QNUf:hGYL005ZHG[QJV5jhFYQN^000H[QN]`00F[QN^EZhG[UJ^5jiF[QN^EZh
001J^000F[QN^EZhF[UJ^5jiF[QJ^@00F]X200000eZiF[YJ^@02F[T01eZjF[UJ^@00F]YF^E[J0080
000=F[UJfUJi001F^U[JE[YJfUJjF]YF^U[JE[X00P0000iJfeJjF]YF^U[KE[YJfUJj001FfUKKE]YF
feKJ0P0000iJfeKJ001FfUKKE]YFfeKJE]]FfUKK001Fg5;K0`0000eFfUKKD]YFfeKJ001BfeKLD]]F
fe;KE]aBf`0300003U;KE]]BfeKLD]]Ffe;KE]`005KlD]]Fo5;KE_`200002e;KE]/005KlD]]Fo5;K
E_aBfeKlD]/00P0000=Fo5;K00000`0000iFo5;K001BfeKlD]]Fo5;KE_aBfeKl001Fo5;K0`0000eB
feKlD]]Fo000E_aBfeKlD]]Fo5;KE_aBf`0300003e;KE_aBfeKlD]]Fo5;K001BfeKlD]]Fo5;KE_aB
f`0300002E;KE_aBfeKlD]]Fo5;KE_`0000<Ool00`00Oomoo`0<Ool00`00Oomoo`0?Ool002=oo`03
001oo`0001=oo`0G001YjfW/JN]Yk6W[JNaYj`00JP]^2fX;KP]Z2fh;JP/006gZKPY]jVh:KNY^2P02
0006K[<01000JW=ZL`002FZC00<006jcK[<00Vjc00H006YcIW=ZLfIc0009JY<02`00K[<006IcJY=V
LfZDIW=ZTfIc00000fZC015ZU6ZCJY=ZT`00IW@006JDJYAVTfZDIYAZU6JCJYAVU00000=Z]00B001V
M6JDIWAVU6Id001VU6ZDIYAZU6JDJYAVU000HWD006JD0fJE011VU6JEIYEVUFJD001V]@00HYEVUF:E
IYERUFJEHYD000AVU@03001RUV:F00=RUP03001VUV:E00=VUP07HYD006:FHYMNUV:F00001V:F00`0
05jGGYMNU`00HYMR]f:FH[MRUf:gHYH3000015jG001N]f:g0ejg00=R]ejg00000Ujh00EJ^000001N
^5jg009N^005001J^5ZhF[QN^@02F[P20002G[P00`00F[UJ^@07F[T00`00F[UJ^@08F[T01@00E[X0
0000F[X00eZi00UJ^UZi001F^U[JE[YFfUJjF]X00P0000=J^P00E]X025KJ00<005KKE]/00P001EKJ
00<005KJE]/00UKK00=FfUKKE]/00`0025KK00<005KKE]/00eKK0P000UKK00<005KKE]/01UKK00<0
05;KE]`00`0015KK00T005;KE]]BfeKLD]]Ffe;KE]`0100000mBfeKKD]]Fg5;KE]/005KlD]]Fo5;K
E_aBfeKlD]/00`0000]BfeKlD]]Fo5;KE_aBfeKl001Fo5;k009Bo006E_`00000D]]Fo0000U;l00IF
o5;kD_aBo5Kl0002D_`00eKlD_aBo00200001E;kD_`005KlD_/00U;l00AFo5;kD_aBo08000]oo`03
001oogoo00aoo`03001oogoo00moo`008goo0P0057oo02<006W/JN]Yk6W[JNaYjfW/001^36W[KPaY
jfh<JN]^3000KP]]jVh;JNY^2fgZ001Z/fjdJ[=^]6ZcK[AZ/`00IW=ZT`00009ZT`05KY=ZTfZCJY=^
T`02JY<02`00K[AZ/fjdJ[<006IcJY=VLfZD00000VZC00E^U6ZCJY=ZTfjD009ZT`0a001^]000JYAV
LfZDIW=ZU6Ic001ZTfZDJY=^U6ZCJYAZTfjD001VM000JYAVTfZDIY=ZU6JCJYAVT`00JYAZ]6ZCK[@0
06JDIWAVUFId001VU6ZEIYAZU6JDJYEVU6ZDIY@00P0003YVUFJDIYEVU6JEIYAVUFJD001VU6Ze001V
UF:EIYIRUFJEHYEVUP00I[EVUFJfIYEV]@00HYIRUF:FHYD006:EI[IRUFJfHYEV]V:E001NUV:G001V
]f:FH[IRUVJgHYIR]P00HYMNU`00GYIR]ejFH[MNUP@0000XG[QNU`00GYMR^5jGH[QNUf:hGYMR^000
G[QJV000G[MR^5jgG[QN]f:h001N^EZhG[UJ^5ji001N^EZhG[QJ^5ji001J^EZhG[UJ^5ZiF[P20000
0eji001J^P03F[T055ZjF[UJ^EZiF[YJ^@00E[UJfUZiF]YF^E[JF[UJfUJi001F^U[JE[X200003U[J
E[UJfP00F]YF^U[KE[YJfUJjF]]F^U[JE[X200003E[KE]YJfeKJF]]FfU[K001FfeKJE]]FfUKK0080
000?E]YJf`00E]]FfUKKD]YFfeKJE]]BfUKK001Ffe;K0080000=E]]BfUKKE]YFf`00E]aBfeKKD]]F
g5;KE]/00`0000iFfe;KE]aBfeKKD]]Fg5;K001BfeKlD]]Fo5;K0P00015Ffe;K001BfeKlD]]Fo5;K
E_aBfeKl001Fo5;KE_aBfeKl0080000>D]]Fo000E_aBfeKlD]]Fo5;KE_aBf`00D]]Fo0<0000@E_aB
feKlD]/005;KE_aBfeKlD]]Fo5;KE_`005KlD]/200003EKlD]]Fo5;K001BfeKlD]]Fo5;KE_aBfeKl
008000Uoo`<000ioo`03001oogoo00moo`008goo00<007ooOol04goo01H006W[JNaYjfW/JN]Yk6W[
001Z2fh;JP]^2fX;KP]Z2`00KNY^2VgZKPY]jP8000M^/`03001ZL`0000UZT`03001^/fjc00=^/`06
001ZLfIcJW=VL`0026ZC00/006jdK[<006IcJYAVLfZCIW=ZU000009ZT`05JYAZTfZCJY=ZU002JY<0
2`00JYAVTfZDIYAZU6JCJYAVU6ZD000016Zd010006IdIYAVM6JD001ZU6JDJYAVU6ZDIYAZU6JDJY@0
00=VU@0AIYAVUFJEIYEVU6JE001Z]FJe001RUFJEHYEVUF:EIYD00006IYD01P00HYIRUV:F001RU@=V
UP07HYEVUVJFIYH006:F00002F:F0P0000=RUf:gHYH00`0000ARUV:gHYMR]`800003G[MR]ejg009N
]`05H[MN]ejgG[MR]`020002G[P025jgG[QN^5jhG[MN^000G[T2F[P00`00G[QN^004G[P00`00F[UJ
^@03F[T01@00F[QN^EZh000025Zi0P0000=J^@00F[T00UZi00MJ^UZiF[UJ^EZj001FfP0200001eZi
F]YJ^U[JF[UJfP0000MFfP800003E]X005KJ00MFfP03001FfeKJ00800006E]]FfUKJE]YFf`0025KK
0`001eKK00<005KKE]/00eKK0P000UKK00<005KKE]/01UKK00<005KLD]/00`0015KK0P0000YBfeKL
D]]Ffe;KE]aBf`00D]]Fo0<0000=E]aBfeKKE]/005;KE_aBfeKlD]]Fo5;KE_`00`0000YFo5;KE_aB
feKlD]]Fo5;K001Bn`9Bo004E_aBne;lD_`300000e;lE_aBn`02D_`01UKlD_/005;lE_aBn`9Bo080
0003D_aBf`0000Yoo`03001oogoo00aoo`H000aoo`008Woo00<007ooOol057oo01D006W/JN]Yk6W[
JNaYjfW/001^36W[KPaYjfh<JN]^3000KP]YjVh;KNX00P0000U^]6ZcK[AZ/fjdJ[=^]6ZcK[@00P00
00=ZTfjCJY<00VZC015^TfZCJY=ZT`00J[=^]6ZcK[AZ/fjd001ZU6Ic001ZTfjD00=ZT`0eKYAZTfZC
JY<006jcK[@006ZDIW=ZU6IcJYAVL`00JY=^U6ZCJYAZTfjDJY=ZU6ZC001VTfZDIY=ZU6JCJYAVTfZD
IY<006ZCK[AZU6Zd001VUFIdIY@006ZEIYAZU6JDJYEVU6ZDIYAZU@020000:6JDIYEVU6JEIYAVUFJD
IYD006ZeIYAZ]FJD001RUFJEHYEVUP00I[EVUFJfIYEV]FJEI[IVU@00HYERUP00I[IRUFJfHYEV]V:E
I[IRUFJf0P0000]RUV:fHYIV]f:FH[IRUVJgHYH005jF00<0000OGYIR]ejFH[MNUV:gGYH005jGH[QN
Uf:hGYMR^5jGH[QNUf:hGYL005jgH[QN]ejhG[MR^5jgG[QN]`00F[P00P0001EN^EZhG[QJ^5jiF[QN
^5Zh001J^5ZiF[P005ZhG[UJ^5jiF[P005ZiF[X00eZi01iJ^P00G[UJ^5ji001JfUJiF]YJ^E[JE[UJ
fUZiF]X005[JE[UJfUJiF]YF^E[JE[UJfP00F]YF^U[KE[X200003E[JE[YJfP00F]]FfU[KE]YJfeKJ
F]]FfU[K0080000>E]YJfeKJF]]FfU[KE]X005;JE]]FfUKKD]YFf`80000>E]YJf`00E]]BfUKKE]YF
fe;JE]]FfP00D]]Fg080000=D]YFfeKKE]]BfP00D]]Ffe;KE]aBfeKKD]/00`0000QBfeKLD]]Ffe;K
E]aBfeKK0P0000IBfeKlD]]Fo5;KE_`300003UKlD]]Fo5;KE_aBfeKlD]/005;KE_aBfeKlD]/20000
3eKlD]/005;KE_aBfeKlD]]Fo5;KE_`005KlD]]Fo00400003E;KE_`005KlD]]Fo5;KE_aBfeKl001F
o5;K00<00004D]]Fo5;KE_`2000ZOol0029oo`04001oo`00000DOol04P00JNaYjfW/JN]Yk6W[JN`0
06h;JP]^2fX;KP]Z2fh;001^2P800003JN/006jc00Q^/`03001ZTfZC00QZT`03001^/fjc00A^/`04
001VLfYc0009JY<03000K[A^/fjd001ZTfIcJYAVL`00JY=ZU0=ZT`0?JYAZTfZCJY=ZU000JYAVU6ZD
IY=ZU6JDJYAVT`0000IZ]00A001VU6Id001VU6ZDIYAZU6JDJYAVU6ZDIY@006Zd001VU003IYD03VJD
IYEVU@00I[EZ]FJeJ[D006JEHYEVUF:E0008IYD00`00HYH00003IYH01F:EIYIVUVJFHYD00VJF00<0
06:FHYH01f:F0`0000aRUV:gHYMR]f:FH[MRUf:gHYH006:g0003G[L02V:gG[MN]ejgH[MN]`00H[L0
05jg0ejh00IN]ejhG[QN^5jg000:G[P03000F[T00000F[QN^EZhG[UJ^5jiF[P000=J^@80009J^@05
G[UJ^EZi001J^P03F[T03eZjF[T00000F[T005[JF[YJfUZiF]YJ^U[JF[T00002E]X20002F]X01EKJ
F]YJfU[J00001UKJ0P0000=JfP00E]/00eKJ00EFfeKJE]YFfP00009Ff`<00005E]]FfUKKE]X00008
E]/30007E]/00`00E]]Ff`03E]/20002E]/00`00E]]Ff`06E]/2000015KKD]]Fg5;K0P000UKK00@0
05KKE]aBf`9Ff`06E]aBfeKK001Fo5;K0`0000eBfeKKE]]Fg000E_aBfeKlD]]Fo5;KE_aBf`040000
25KlD]]Fo5;KE_aBfeKl0002D_`015KlD_]Bo5;l0`0000UBfeKlD]]Bo5;KE_aBfe;l0000:Woo000R
Ool2000FOol04000JN]Yk6W[JNaYjfW/JN/006W[KPaYjfh<JN]^36W[0P0000mYk6G[001Z/fjdJ[=^
]6ZcK[AZ/fjdJ[=^]000KY<00fZC015^TfZCJY=ZTfjC001^]6ZcK[AZ/fjdJ[=^]000JY=VL`0000=Z
T`1EKYAZTfZCJY=^U000K[AZ/fjdK[<006IcJYAVLfZD001^U6ZCJYAZTfjDJY=ZU6ZCKY@006jd001Z
U6JCJYAVTfZDIY=ZU000K[AZU6ZdJY=^]6ZD001VM000IYAZU6JDJYEVU6ZDIYAZUFJD001Z]6je001V
UFJDIYEVU6JEIY@006JDJ[EVU6ZeIYAZ]@00IYIRU@00IYEV]VJEI[EVUFJfIYEV]FJEI[H00P0000UR
UFJfHYEV]V:EI[IRUFJfHYD00P0000IR]V:FI[MRUV:fHYH40000>fJg001R]ejFH[MNUV:gGYIR]ejF
001R]VJg001R^5jGH[QNUf:hGYMR^5jG001N]f:h001N^5jgH[QN]ejhG[MR^5jg001N]`00F[QN^5Zh
G[UJ^5jhF[QN^EZhG[P005jiF[QN^EZhG[UJ^5jiF[QN^@00F[T00P0001]J^EjiF[QN^EZiG[UJ^000
F[UJfUJiF]YJ^@00F[UNfUZi001F^E[JE[UJfUJiF]YF^E[JE[T00P0000eJfUJiF]YF^U[JE[UJfUJj
001FfU[KE]YJf`0200003EJjF]YF^P00E]YJfeKJF]]FfU[KE]YJfeKJ0080000>F]]FfUKKE]YJfeKJ
E]]FfP00E]YFfe;JE]]FfP800004F]]FfP00D]X3E]/01e;JE]]FfeKK001Fg5;K008000=Ff`0;D]YF
f`00E]]BfeKLD]]Ffe;KE]aBf`0500003E;KE]aBfeKK001Fo5;KE_aBfeKlD]]Fo5;K00<0000>D]]F
o5;KE_aBfeKlD]]Fo000E_aBfeKlD]]Fo080000>D]]Fo000E_aBfeKlD]]Fo5;KE_aBf`00D]]Fo0@0
000;D]]Fo000E_aBfeKlD]]Fo5;KE_aBf`02000YOol000Aoo`@000Ioo`8000Eoo`H000Moo`03001o
ogoo01Eoo`0A001Yk6W[JNaYjfW/JN]Yk000KP]Z2fh;JP]^2fX;KP/00003JN/00`00K[=^/`08K[<0
0`00JY=ZT`07JY<00`00K[=^/`05K[<00`00IW<00009JY<02`00K[=^]6jcK[@006ZDIW=ZT`00JY@0
0fZC011ZU6ZCJY=ZTfZDJY<006jd001VTfZDIYAZU6JCJY@000MZ]00@001VU000JYAVU6ZDIYAZU6JD
JYAVU6ZD001Z]FZd0002IYD03fJDIYEVUFJE001Z]FJeJ[EV]FZeI[D006:EIYD0000:IYD01000IYIV
UV:E0fJF00MRUFJFIYIVUP00I[H00002HYH30002HYH03000I[IR]VJf001R]f:FH[MRUf:gHYH000AR
]`03001R]ejg009N]`03H[MN]`0000AR]`03001N^5jg00=N^005G[L005jhH[P00009G[P03P00G[P0
05jiF[QN^EZhG[UJ^5jiF[QN^@00G[T3F[T02ejiF[UJ^EZiG[UJ^@00F[UJ^UZi00001EZi00L005Zi
F]YJ^U[JF[UJfP0200001EZi001JfU[JE]X00e[J00EFfU[JF]X005KJ00800009F]YFfU[JE]YJfUKJ
001FfUKK00=FfP0>E]/00000E]X005KJE]]FfUKKE]YFfeKJE]/0009Ff`<00005E]YFfeKJE]/00009
E]/20007E]/00`00E]]Ff`05E]/40007E]/01P00E]]FfeKLD]]Ff`80009Ff`03001Fg5;K009Ff`07
E]aBfeKKE]/005;KE_`00`000UKK00]Fg5;K001BfeKlD]]Fo5;KE_aBfeKl00<0000?E_aBfeKlD]]F
o5;KE_`005;lD]]Fo5;KD_aBfeKl00<002Qoo`000goo00<007ooOol00Woo00<007ooOol00goo0P00
1Goo00<007ooOol02Woo00<007ooOol05Goo00l006W[JNaYjfW/JN]Yk6W[001Yjfh<JN]^36W[KP`0
0P00019UjfW/JN/006ZcK[AZ/fjdJ[=^]6ZcK[AZ/`00K]@006ZCKY<3JY<036jCJY<006ZcK[AZ/fjd
J[=^]6ZcK[AZ/`80009ZT`1FKYAZTfZCJY=^U6ZC001Z/fjdK[=^]6ZcK[@006ZDIW<006ZCJYAZTfjD
JY=ZU6ZCKYAZT`00J[=^]000JYAVTfZDIY=ZU6JC001ZU6ZdJY=^]6ZDJ[AZTfjd001ZU6JDJYEVU6ZD
IYAZUFJDJY@006jeJ[AZ]FZd001VU6JEIYAVU@00J[EVU6ZeIYAZ]FJDJ[D006JE001V]VJEI[EVUFJf
IYEV]FJEI[IVU@80000<I[IRUFJfHYEV]V:EI[IRUFJf001V]VJe0`0003=RUVJgHYIR]P00I[MR]VJg
H[IV]`00H[MNUV:gGYH006:fI[MR]V:gH[H005jGH[QNUf:hGYL005jgH[QN]f:gG[L005jgG[QN]f:h
G[L005jgH[QN]f:h001N^EZhG[QJ^5jiF[P00P0001UR^5jh001J^5jiF[QN^EZhG[UJ^5ji001N^@00
G[UJ^5jiF[UN^EZhG[UJ^Eji001JfP0200002eZiG]YJ^E[IF[UNfUZi001F^E[JE[T00P0000eJfUZi
F]X005[JE[YJfUJiF]YF^U[JE[UJfP0200003EJjF]YF^U[JE[YJfUJjF]YF^P00E]YJfeKJ0080000=
F]YFfU[K001FfeKJF]]FfUKKE]YJfeKJE]/00P0000]FfUKKE]YJfeKJE]]FfU[K001Ffe;J00=Ff`05
D]X00000E]/00003E]/025;JE]]FfeKKD]X005;KE]/400003U;JE]/005KK001Fg5;KE]]BfeKLD]/0
05;KE_`300003EKLD]]Ffe;K001BfeKlD]]Fo5;KE_aBfeKl00<0000>E_aBfeKlD]]Fo5;KE_aBf`00
D]]Fo5;KE_aBf`80000@E_aBf`00D]]Fo5;KE_aBfeKlD]/005;KE_aBfeKlD]/200000eKlD]/0000X
Ool000=oo`03001oogoo009oo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo01Eoo`0A001Y
k6W[JNaYjfW/JN]Yk000KP]Z2fh;JP]^2`00IL/00002JN/00`00K[=^/`08K[<00`00L]@00007JY<0
0`00K[=^/`07K[<00`00JY=ZT`07JY<02`00K[A^/fjdK[=^]6jc001VLfZD00000VZC00EZU6ZCJY=Z
TfZD009ZT`0:001^]6jdK[@006ZDIY=ZU6JD0009J[@04000IYAZU6JDJYAVU6ZDIYAZU6JD001Z]6Ze
J[AZ]@000fJE00YVU000I[EZ]FJeJ[EV]FZeI[EZ]@8000YVU@03001Z]P0000=VUP06HYEVUVJFIYH0
06Jf100016:F00<006JfH[H00fJf00MR]P00HYMR]f:FH[L00006H[L01@00G[MR]ejg00001f:g00/0
05jhG[QN]`00G[QR^5jgH[QN^00000EN^003001N^5jh00=N^00=001J^5jiF[QN^EZhG[T005jiG[P0
05ZiG[T00eZi00IN^EZiF[UJ^Eji0009F[T02`00F]X00000F[UJfUZiF]UJ^E[J00000e[J00=FfU[J
F]X00P0000eJfP00F]YFfU[JE]YJfUKJF]YFfU[J001FfP020003E]X02U[JE]YFfP00E]]FfUKKE]YF
feKJ0P0000]JfP00E]]FfUKKE]YFfeKJE]]FfP0000AFf`800004E]YFfeKK0009E]/20007E]/20006
E]/30008E]/01000E]]Fg5;K0UKK0P000UKK00H005;KE]]FfeKLD]/2E]/015KL001Fo5;K0`00011F
feKLD]]Ff`00E_aBfeKlD]]Fo5;KE_aBf`00D]]Bo0800004D]]Fo5;KE_`2000WOol000=oo`03001o
ogoo009oo`03001oogoo00aoo`03001oogoo00Moo`<001Ioo`0<001YjfW/JN]Yk6W[JNaYj`00JN]^
36W[0P0001=UbfFZIL/006W/001^]6ZcK[AZ/fjdJ[=^]6ZcK[@007;eK]@00003JY<04FjCJY=ZT`00
K[AZ/fjdJ[=^]6ZcK[AZ/fjdJ[<006ZCKY@00fZC01Q^U6ZCJY=ZT`00K[=^]6ZcK[A^/fjd001ZU000
JYAZTfjDJY=ZU6ZCKYAZTfZD0003K[@0@VZc001VTfZDIY=ZU000J[AZTfjdJYAZ]6ZCK[AZU6Zd001Z
UFJDJYAVU6ZEIYAZU6JD001Z]6ZeJ[A^]FZdJ[D006JEIY@006JDJ[EVU6ZeIYAZ]FJDJ[EVU000IYEV
]FJEI[IVUFJeIYEV]VJEI[D006ZfI[D006:EI[IRUFJfHYEV]P<000=V]P0f001V]f:FH[IRUP00H[IV
]f:fI[MR]VJgH[H005jFH[L006JgH[IR]f:fI[MR]V:g001R^5jG001N]f:hG[MR]ejgH[QN]f:g001R
^5jg001N]f:hG[MR^5jgH[QN]`00F[QN^EZh001N^6:h0ejh00IR^000G[UJ^5jiF[P2000035jiG[QN
^EZh001J^EjiF[QN^EZiG[UJ^080000IG]T005kJF[UJfEZiG]YJ^E[IF[UNfP00F]YJ^E[JF[UJfUZi
F]YJ^E[J001JfUJjF]X00P0001aJ^E[JE[T005JjF]YF^U[JE[YJfUJjF]YF^U[J001JfeKJF]YFfU[K
E]YJfUKJF]/005KKE]YJf`80000?E]YJfeKJ001FfU[KE]YFfeKJF]]FfUKKE]X005KK00800008E]]F
fUKKE]YFfeKJ001BfP=Ff`06D]YFf`00001FfP000UKK00]BfUKKE]]Ffe;J001Bf`00D]]Fg5;K0080
009Ff`0<001BfeKLD]]Ffe;KE]aBfeKK001Fo5;K0`0000eBfeKkD]]Fo000E_aBfeKlD]]Fo5;KE_aB
f`03000045;KE_aBfeKlD]]Fo5;KE_`005KlD]]Fo5;KE_aBfeKl0`0000MFo5;KE_aBfeKlD]]Fo002
000VOol000=oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00Ioo`03001oogoo01Moo`0@
001YjfW/JN]Yk6W[JNaYj`00JP/006FZIL]UZfG;IJX2000:K[<01000K]Abe0001VZC00<006jcK[<0
26jc00<006ZCJY<01VZC00d006jcK[A^/fjdK[=^]6jc001VL`00JY=ZU003JY<01FZDJY=ZTfZC0000
16jd00H006ZDIYAZU6JC0008J[@08000K]D006ZDIYAZU6JDJYAVU6ZD001Z]FZdJ[EZ]6ZeJ[@006JD
IYD006ZeI[EZ]FJeJ[EV]FZeI[D006Ze0009IYD01`00I[EZ]VJe001RUFJF00@000IV]P05001RUV:F
001R]P03I[H01f:fI[IV]VJf001R]`0000UR]`8000YR]`80000:G[QR^5jgH[QN^6:hG[MR^000G[P2
0008G[P01P00G[UJ^000G[QN^@=N^005G[T005ZiF[UN^@03F[T01@00F[UN^Eji00001eZi0P0000aJ
f@00F]YJ^E[IF[UJfUZiF]UJ^@00E]X200000e[JF]UJfP02F]X02E[I001FfU[JE]YJfUKJF]YFfP02
00001E[J001FfUKJF]X00eKJ00AJfUKJ001FfP80009FfP0<F]YFfUKJE]X005KJE]]FfUKKE]YFfeKJ
0`000UKK00MFfUKKE]]FfeKJE]/00004E]/20003E]/00`00E]]Ff`06E]/00`00E]/000020005E]/0
0`00E]]Ff`05E]/30002E]/02E;KE]]FfeKKD]]Ff`00E]aBf`02E]/00eKL00000002E]/01@00E]]F
feKLD]/00UKK00IFg5;K001BfeKlD]/40002E]/02000D]]Fo5;KE_aBfeKlD]/2000VOol000=oo`03
001oogoo009oo`03001oogoo00ioo`03001oogoo00Eoo`03001oogoo01Moo`08001Yk6W[JNaYjfW/
JN]Yk0800006IJYUbfFZIL]UZVG;0P00011Z/fjdJ[=^]6ZcK[AZ/fjdJ[<006kDL_E^e7;e001^T`=Z
T`0>KY<006jdJ[=^]6ZcK[AZ/fjdJ[=^]000L_D0009ZT`0IKYAZTfZCJY=^U000K[AZ/fjdK[=^]6Zc
K[A^/`00JY=^U6ZCJYAZTfjDJY=ZU6ZC00000Vjd03iZ/fjdK[@006JCJYAVT`00JY=^]6ZDJ[AZTfjd
JYAZ]6ZC001Z]000IYAZUFJDJYAVU6ZE001Z]FZdK[EZ]6ZeJ[A^]@00IYD006ZeIYAZ]FJDJ[EVU6Ze
IYAZ]@00J]H006JfIYEV]FJEI[IVUFJeIYD006JeJ[IV]FZf0`0000AV]V:E001V]@=V]P0cI[EV]VJf
001RUP00H[IV]f:fI[MR]VJgH[IV]f:fI[L006JgH[IR]f:fI[MR]V:gH[IV]f:f001N]f:hG[MR]ejg
H[QN]f:gG[MR^5jg001N]f:hG[MR^5jgH[QN]f:hG[MR^000009N^005H[QN^5jhG[QR^003G[P03`00
F[P005ZhG[UN^5jiF[QN^EjhG[T005jiF[UN^@020000:5ZhG]UJ^5kIF[P005ZiG]YJ^E[IF[T005Zi
G]UJ^@00F[UJfUZiF]YJ^E[JF[UJfUZi001F^E[JF[UJfUJiF]YJ^E[JE[T005JjF]YF^U[J0P0001aF
fE[JE]X005KJF]]FfU[JE]YJfeKJF]YFfP00E]YJfeKJF]]FfU[KE]YJfeKJ001FfU[KE]YFf`80000>
E]YJf`00E]]FfUKKE]YFfeKJE]]FfUKK001Ff`800007E]YFfeKJE]]FfUKK00000eKK00ABfUKKE]]F
f`<00003E]]BfeKK009Ff`08D]]Ff`00E]]BfeKLD]]Ff`80009Ff`0<001Fo5;KE_]BfeKlD]]Fne;K
001BfeKl0`0000eFo5;KE_aBf`00D]]Fo5;KE_aBfeKlD]]Fo00400003U;KE_aBfeKlD]]Fo5;K001B
feKlD]]Fo5;KE_`3000UOol000=oo`03001oogoo009oo`03001oogoo00moo`03001oogoo00Aoo`03
001oogoo01Moo`0@001YjfW/JN]Yk6W[JNaYj`00IJYUbfF[IL]UZVG;IJ/20009K[<01P00L]A^e7;D
K]@000AZT`03001^/fjc00Q^/`03001^e00000IZT`0<001^]6jcK[A^/fjdK[=^]6jcK[@006ZD0fZC
00IZU6ZCJY=ZTfZD0006K[@01000IY=ZU00026Zd01<006kDK]D006ZDIYAZU6JDJYAVU000J[AZ]FZd
J[EZ]6ZeJ[AZ]@0200003FJeJ[EV]FZeI[EZ]FJeJ[D006[EJ[EZe@0000IVU@03001V]FZf00<00005
J[H006JFHYD00009I[H20003I[H02F:fI[IV]VJfH[IV]P00I]L00008H[L00`00H[L00009H[L03P00
H[L005jgH[QN^6:hG[MR^5jhH[P006;H000:G[P00`00G[QN^@03G[P01UjiG[QN^5jh001J^@800003
G[UJ^Eji009N^@03F[UN^@0000=J^@80000<F[UJfEZiG]UJ^@00F[UJfUZiF]UJ^E[J0P0000=Jf@00
F]T00e[J00MJfE[JF]YJfP00F]YFfP020006F]X01@00E]YFfUKJF]X00UKJ0P0000AFfP00E]YJfP=F
fP06F]YFfUKJ001FfeKJ0P0000IFfeKJE]YFfUKK0003E]/015KJE]]FfeKK0`0025KK00<005KKE]/0
0eKK0P000UKK0P001eKK00<005KKE]/00P001EKK00D005KKE]]Ffe;K00=Ff`<00003E]]BfeKK009F
f`05D]]FfeKK001Bf`02E]/02UKLD]/00000E]]Bf`00E]]Fg5;K0UKK00IFg5;KE]/005KlD]/40000
15KkE]/0000097oo0003Ool00`00Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomoo`04Ool00`00Ool0
000GOol01`00JNaYjfW/JN]Yk6W[0080000HIL]UZVG;IJYUbfFZIL/006jdJ[=^]6ZcK[AZ/fjdJ[=^
]000L_E^e7;eK]Abm@000VZC015^TfZC001Z/fjdJ[=^]6ZcK[AZ/fjdJ[<006kDL_@006jD00=ZT`0H
KYAZT`00J[=^]6jcK[AZ/fjdK[=^]6Zc001ZTfZDJY=^U6ZCJYAZTfjD001^]6Zc0fjd03IZ/fjd001Z
U000K[AZU6ZdJY=^]6ZDJ[AZTfjd001^eFZdK]D006ZDIYAZUFJD001Z]6jeJ[AZ]FZdK[EZ]6ZeJ[@0
06JDJ[EVU6ZeIYAZ]FJDJ[EVU000J[E^eVZe001VUFJfIYEV]FJEI[H3000026ZfI[EZ]VJe001RU@00
I[D3I[H0=VJeI[IV]VJfI[EV]P00I[MR]VJgH[IV]f:fI[MR]VJg001VefJf001R]VJgH[IR]f:fI[MR
]P00H[MVe`00H[MN]f:hG[MR]ejgH[QN]`00H[MVf000H[QN]f:hG[MR^5jgH[P006;HG[L000=N^00M
H[QN^5jhG[QR^5jh001N^000G[QN^EZhG[UN^5jiF[QN^Ejh001J^5kIF[QNfEZhG]UJ^5kIF[QNf@03
00006ekIF[UNfEZiG]UJ^EkI001JfUZiF]YJ^E[J001NfUZiG]X005[JE[UJfUZiF]YF^E[JF[UJfP02
00003EKJF]YFfE[JE]YJfUKIF]X005[JE]YJfeKJ0080000=F]YFfU[J001JfeKJF]]FfU[KE]YJfeKJ
F]/00P0000eFfU[KE]YJfeKJF]]FfP00E]YFfeKJE]]FfP0200003U[KE]X005KJE]]FfUKKE]YFfeKJ
E]]FfP00D]X300002EKJE]]FfUKK001Ff`00E]]Bf`03E]/01E;K00000000D]/00eKK00UBfeKKE]/0
05;KE_aBfeKkD]/00P0000iFfe;K001BfeKlD]]Fo5;KE_aBfeKl001Fo5;K0`0000eBfeKlD]]Fo000
E_aBfeKlD]]Fo5;KE_aBf`0300001U;KE_aBfeKlD]]Fo08002Aoo`000goo00<007ooOol00Woo00<0
07ooOol02Woo00<007ooOol00Woo00<007ooOol017oo0P0067oo00L006W[JNaYjfW/JN/00002GDP0
2000IL]UZVG;IJ]UbfFZ0009K[<01`00K]Abe6kDL]A^e00000=ZT`03001^/fjc00Q^/`04001be7;D
0006JY<03P00K[A^/fjdK[=^]6jcK[A^/`00K_@006ZCJY@3JY<00fZDJY<00007K[@00`00IY@00008
J[@04`00K]E^e6kEK]@006JDJYAVU6ZD001Z]FZdJ[EZ]6ZeJ[AZ]FZd0080000?J[EV]FZeI[EZ]FJe
J[EV]@00J[EZeFZeJ]EZ]@00009VU@<00008J[IV]FZfI[EZ]VJeJ[IV]@8000UV]P05001VeP00I[IR
]P03I[H01F:fI[IV]P00I]H00VKG00<006:gH[L00f:g00H006:gI]MR]fKG0006H[L00`00H[MR^002
H[L03000H[QN]f:hG[QR^000H]QR^6;HH[P000IN^0800003G[QRf000009N^00:G[UN^5jhG[QN^Ejh
001N^000F[T3G[T05EZiG[UN^EjiF[T005ZiG]UJ^E[IF[UNfEZiF]UJ^EkI001JfEZiF]X00005F]T0
0`00F]YJf@03F]X01E[I000005[J00002E[J00@005[J0000009JfP05E]YJfU[JF]X00002E]X015[J
E]YFfUKJ0P0000=JfP00E]/00eKJ00MFfeKJE]YFfP00E]YFf`0200001UKJE]]FfUKKE]X000MFf`<0
00QFf`03001Ff`0000=Ff`80009Ff`03001FfeKK00IFf`03001BfeKK008000AFf`05001FfeKKE]]B
f`03E]/01E;K00000000D]/00eKK00EBfeKKE]]Ff`00009Ff`03E]aBfeKK0080000:D]]Ff`00E_aB
feKkE]]Fo5;KE_/2000SOol000Aoo`@000ioo`@000Ioo`03001oogoo01Qoo`04001Yk6W[JN`20002
GDP06UU7001UZVG;IJYUbfFZ001Z/fjdJ[=^]6ZcK[AZ/fjdJ[<006kDL_E^e7;eK]AbmFkD0002JY<0
4P00K[AZ/fjdJ[=^]6ZcK[AZ/fjd001bm6kDL_E^e000JY=^U09ZT`0E001^]6jcK[AZ/fjdK[=^]6Zc
K[@007;e001^U6ZCJYAZTfjDJY=ZU00000=^]00bJ[=^]6jdK[AZ/`00JYAZ]6ZCK[AZU6ZdJY=^]6ZD
001Z]6kEJ[A^eFZd001VU6ZD001^]FZdJ[EZ]6jeJ[AZ]FZdK[D006kF001Z]FJDJ[EVU6ZeIYAZ]@00
K]IZ]F[FJ[E^eP<0000<I[H006ZfI[EZ]VJeJ[IV]FZfI[EZ]P000fJf03YV]FJfI[IV]VJeI[H006[G
I]H006:fI[MR]VJgH[IV]f:f001V]VKGH[IVe`00H[MR]VJgH[H006:gI]MR]fKGH[MVe`00H[MN]f:h
G[L006:gI]QR]f;HH[L005jgH[QN]f:h001Rf5jgH]QN]f;H001R^0=N^00IH[P006;HG[QRfEjhH]P0
05jiG[QN^EZhG[UN^000G[QRf@00G]UJ^5kIF[QNfEZhG]T00P0000eJ^000F[UNfEZiG]UJ^EkIF[UN
fEZi001J^@0200002ekJF[UNfUZiG]YJ^EkJ001JfUJiF]X00P0000eJfEkJF]T005KIF]YFfU[JE]UJ
fUKJF]YFf@0200003E[JE]YJfUKJF]YFfU[JE]X005KJF]]FfU[K0080000<E]YJfUKJ001FfU[KE]YJ
feKJF]]FfU[K0`0000eJfeKJF]]FfU[KE]YJf`00E]]FfUKKE]YFf`0200003EKJF]/005KKE]YFfeKJ
E]]FfUKKE]X005;K00@000=Ff`05E]X005KKE]]Bf`03E]/00e;KE]/0000200003EKLD]]Ffe;KE]aB
feKK001Fo5;KE_aBfeKl0080000>D]]Fg000E_aBfeKlD]]Fo5;KE_aBf`00D]]Fo0<0000<E_aBfeKl
D]/005;KE_aBfeKlD]]Fo5;K0P008goo000POol00`00Oomoo`0IOol00`00JN`00005GDP01`00IL]U
ZfG;IJYUb`0000U^/`09001be6kDL]A^e7;DK]Abe000009ZT`03001^/fjc00M^/`06001be7;DK]Ab
e00016ZC00X006jcK[A^/fjdK[=^]6jcK[@0009bm005001ZTfZCJY=ZU002JY<00`00K[A^]007K[@0
0`00J[AZ]006J[@05000K]A^eFkDK]E^e6kE001ZU6JD001Z]6ZeJ[AZ]FZdJ[EZ]6Ze0002K]D03000
I[EZ]FJeJ[EV]FZe001ZeFZeJ]EZ]@@0009VU@0<001V]FZfI[EZ]VJeJ[IV]FZf001ZeP0026Jf00D0
06KFJ]MVeP00009V]P05H[IV]VJf001VeP03I]L00fKFI]L00003H[L02@00I]MR]fKGH[MVef:gI]L0
0002H[L00`00H[MR^003H[L03V:hH[L005jhH[P006;HH[QRf6:hH]QR^6;H0003G[P02000G]QN^6;H
G[QNf5jh0003G[P02Uji000005jhG]UN^5kI001N^EZi0eji010005kIG]UNf@00F]UJ^EkIF[UJfEZi
G]UJ^E[IF[T000UJf@0;001JfP00001JfU[IF]YJfE[JF]T00006F]X200001E[J001JfU[JE]X00e[J
00EFfU[JF]X005KJ00800009F]YFfU[JE]YJfUKJ001FfUKK00=FfP80000<F]YFfP00E]YFfeKJE]]F
fUKKE]YFf`000UKK0P000eKK00=FfUKK00001eKK10001eKK00<005KKE]/00eKK0P000UKK00<005KK
E]/01EKK00<005;KE]/00`0015KK00@005KKE]]Bf`=Ff`03D]]Ff`00008000=Ff`0<D]]FfeKKE]]B
f`00E]]Fo5;KE_]FfeKl0`008Woo000POol00`00Ool0000IOol20003GDP025U7GDQMB000IJYUbfFZ
IL/2000096ZcK[AZ/fjdJ[=^]6ZcK[AZ/`00K]AbmFkDL_E^e7;eK]@006ZC001Z/fjdJ[=^]6ZcK[AZ
/fjdJ[<006kDL_E^e7;dK]@000=ZT`0E001^/fjdJ[=^]6jcK[AZ/fjdK[<006kDL_E^e000JY=^U6ZC
JYAZT`00009^]006J[=^]6jdK[AZ/fjd0P0002MZTfjdJYAZ]6ZCK[AZU6Zd001^eFZdK]EZ]6kEJ[@0
06JD001Z]6ZeJ[A^]FZdJ[EZ]6jeJ[@006[EK]IZe@00IYAZ]FJDJ[D006kFJ[D00`0001=Z]F[FJ[D0
06JE001V]FZfI[EZ]VJeJ[IV]FZfI[D006[F001V]@03I[H0>FJeI[IV]P00I]IZefKFJ]L006JgH[IV
]f:f001V]VKGH[IVefJfI]MR]P00H[IR]`00I]MR]fKGH[MVef:gI]MR]`00G[L006:gI]QR]f;HH[MV
f6:gH]P006:h001Rf5jgH]QN]f;HG[MRf5jg001N^00200009F;HG[QRfEjhH]QN^6;IG[P005ZhG[T0
05kIG[QRfEjhG]UN^6;I001NfEZhG]T005kIF[QNfEjhG]T005kIF[UNfEZiG]UJ^EkI0080000IF]T0
05ZiG]YJ^EkJF[UNfUZiG]YJ^@00F]UJfU[IG]YJfE[JF]UNfU[I001FfE[JE]X00P0000aJfU[IF]YJ
f@00E]YJfUKJF]YFfU[JE]X300002eKJF]]FfU[JE]YJfeKJF]X005[KE]X00`0000eFfU[KE]YJf`00
F]]FfU[KE]YJfeKJF]]FfP0300003EKJE]]FfU[KE]YFfeKJ001FfUKKE]YFfeKJ00800005F]]FfP00
E]X00002E]/01EKJE]]FfeKK00000UKK0`000UKK00YBfUKK001Ffe;KE]aBfeKKD]]Fg0<0000>E]aB
feKKD]]Fg5;KE]]Bf`00D]]Fo5;KE_aBf`80000>E_aBf`00D]]Fo5;KE_aBfeKlD]]Fo000E_aBf`@0
0004E_aBf`00000QOol0021oo`8001Yoo`03001MB5e800IMB007001UZVG;IJ/007=H00001fjc00`0
06kDL]A^e7;DK]Abe6kDL]@006ZC0009K[<00`00L]A^e003L]@056kD001ZTfZC001^]6jcK[A^/fjd
K[=^]6jc001bm7;eK_Abm000JY@3JY<00`00K[A^]007K[@00`00K_D00006J[@02@00K]E^e6kEK]A^
eFkDK]E^e00200002FZeJ[AZ]FZdJ[EZ]6ZeJ[@00002K]D01f[EK]D006ZeI[EZ]FJe00<00007J[EZ
eFZeJ]EZ]F[EJ[D00P0000UZ]VJeJ[IV]FZfI[EZ]VJe00000f[F00<006JfI[H00fJf00<006KFJ]L0
0fKF00IZe`00I[IV]P00I]H3I]L01FKFI]MVefKGI]H00P0000eVef:gI]MR]fKGH[MVef:gI]MR]`00
H[MR^003H[L0:6:hH[MR]f:gH[P006;HH[QRf6:hH]QR^6;HH[QRf6:h001N^5kHG[QRf5jhG]QN^6;H
G[QNf000G[T005kIG[QNfEjhG]UN^5kIG[P005ji0P001ekI00D005[IF[UNfEZi00800004G]UJfEkI
0007F]T2000035[I001JfE[JF]UJfU[IF]YJfE[J001JfP8000IJfP06001JfU[JF]YFfU[J0P000U[J
00X005[JE]YJfUKJF]YFfU[JE]YJfP80000>E]YJfUKJF]YFfU[JE]YJfP00E]]FfUKKE]YFf`800003
E]YJf`0000=Ff`06E]YFfeKKE]]FfP000UKK0P000UKK00IFfUKKE]/005KK0005E]/30008E]/00`00
E]]Ff`02E]/20002E]/00`00E]]Ff`06E]/00`00E]]Ff`030004E]/00`00E]]Bf`03E]/00e;KE]]F
f`030002E]/01U;KE]]FfeKKD]/0025oo`0087oo00<007ooOol06Woo00<005e8FDL00ee804EIAee8
001UbfFZ001cF7=h001^]6ZcK[AZ/fjdJ[=^]000L_E^e7;eK]AbmFkDL_E^e7;e001^]6ZcK[AZ/fjd
J[=^]6ZcK[@007;eK]Abm6kDL_E^e7;d001^U6ZC001Z/fjdK[=^]6ZcK[A^/fjd001bmFkDL_E^e000
JY=ZU6ZCKY@006jdJ[<00fjd02MZ/fjdK[@006kdL_D006ZdJY=^]6ZDJ[AZT`00J[A^eFZdK]EZ]6kE
J[A^e@00J[EZ]6jeJ[AZ]FZdK[EZ]6Ze001^eV[EK]IZe@00IY@00`0001AZ]F[FJ[E^eVZeJ]IZ]FkF
J[EZeP00J[IV]FZfI[EZ]VJeJ[IV]@000V[F00EVeV[G001V]VJe009V]P1K001VeV[GI]IZefKFJ]MV
eP00H[IV]`00I]MR]VKGI[IVef:fI]MV]VKG001Vef:gI]MR]fKGH[MVef:gI]MR]`00H]L006:gH]QR
]fKHH[MRf6:gI]P006KH001Rf5jgH]QN]f;HG[MRf5jg001Rf000G[QRfEjhH]QN^6;IG[QRf5jhH]T0
05kIG[QRfEjhG]UN^6;IG[QNfEjh001N^5kIF[QNfEjhG]UJ^5kIG[P005ZiG]T00P0002MJfEkJF]UN
fE[IG]X005kJF[UNfUZiG]X005kJF]UNfP00G]YJfE[JF]UNfU[IF]YJfEkJ001JfU[IF]YJfE[JF]UJ
fU[IF]X005[JE]X00P000e[J00UFfU[J001JfUKJF]]FfU[JE]X00P0000eJfP00F]]FfU[KE]YJfeKJ
F]]FfP00E]YJf`0300003E[KE]YJfeKJ001FfU[KE]YFfeKJF]]FfUKK00<0000:E]]FfU[KE]YFfeKJ
F]/005KK0003E]/200000eKJE]/00003E]/025;JE]]FfeKKD]X005;KE]/20002E]/02e;KE]]Ff`00
D]]Fg5;KE]]BfeKLD]/00`0000iBfeKkD]]Fo5;KE_]BfeKl001Fo5;KE_aBfeKl0P0000YBfeKk001F
o5;KE_aBfeKlD]]Fo080021oo`0087oo00<007ooOol06Woo00<005e8GDP01Ee800P006F[001cF7=h
LeQcN0001Fjc00`007;DK]Abe6kDL]A^e7;DK]Abe6kD0009K[<00`00K]Abe002L]@04FkDL]Abe000
JY<006jcK[A^/fjdK[=^]6jcK[A^/`00K_@00W;d00Ibm@00JY=ZTfZD0009K[@01000L_E^m@001FZd
01H006kDK]E^e6kEK]A^eFkDK]D006kf001Z]FZdJ[EZ]6ZeJ[AZ]@00K]EZe@9^e@<0000GI[EZ]@00
J]EZ]F[EJ[EZeFZeJ]EZ]F[E001^mP00J[IV]FZfI[EZ]VJeJ[H00005J]H01P00I[IV]P00I]IZe`=V
eP04J]MVeVKFI]H20003I]L05FKFI]MVefKGI]IVe`00I]P006KGH[MVef:gI]MR]fKGH[L006KGI]P0
0002H[L01V:hH[MR]f:gH[P0009Rf009001R^6;HH[QRf6:hH]QR^000009Rf00H001Rf5jhG]QN^6;H
G[QNf5jhH]P006;I001NfEjhG]UN^5kIG[QNfEjh001Nf@002EkI0P000ekI00IJfEkIG]UNfE[I0003
F]T2000035kJF]UJfE[IG]X005[JF]UJfU[IF]YJf@800003F]X005[J00QJfP8000MJfP05001FfU[J
E]YJfP020003F]X02P00E]YJfUKJF]YFfU[JE]YJfUKJ0P0000EJfeKJE]YFfU[K00=FfP03001FfUKK
009Ff`06E]X00000E]]FfP000UKK00QFfUKKE]]FfeKJE]/005KK0`0015KK00<005KKE]/01UKK0`00
1eKK00<005KKE]/00eKK0P000UKK00<005KKE]/01UKK00<005KKE]/00`0015KK00<005;KE]/00UKK
00=BfeKKE]/00`007goo000POol00`00Oomoo`0KOol01000GDQMB5U70ee801MIA`00001cN7=GLgQc
F000J[=^]6ZcK[AZ/`00K]AbmFkDL_E^e7;eK]AbmFkD0080000XK[AZ/fjdJ[=^]6ZcK[AZ/fjd001b
m6kDL_E^e7;dK]Abm@00JY<006jdK[=^]6ZcK[A^/fjdJ[<006kDL_E^e7;eK]Abm@00KYAZT`00J[<3
K[@08fZcK[A^]6jd001bmFkeL_E^m000JYAZ]6ZCK[@006kEJ[A^eFZdK]EZ]6kEJ[@006ke001Z]6Ze
J[A^]FZdJ[EZ]000J]D00`0001aZeFkF001Z]@00J]IZ]FkFJ[EZeVZeK]IZ]F[FJ[D006[f001V]FZf
I[EZ]VJeJ[H006[FI]IZe`9ZeP0jI]H006JfI[H006[GI]IZefKFJ]MVeV[GI]IZe`00I]MR]VKGI[IV
ef:fI]MV]VKG001Zn6KG001R]fKGH[MVef:gI]MR]`00H]MVf6;GI]P006KHH[MRf6:gI]P006KHH]MV
f6;H001N]f;HG[MRf5jg0002H]P02EkHH]T006;HG[QRfEjhH]QN^00200008V;IG]P005jhG]UN^6;I
G[QNfEjh001Nf6;I001NfEjhG]UJ^5kIG[QNfEZh001Nf@00F]UNfU[IG]UJfEkJF]UNfE[I0`0000aJ
fEkJF]UNfU[IG]YJfEkJ001NfU[IF]X200002e[IG]YJf@00F]UJfU[IF]YJfE[JF]T00P0000=JfP00
F]X00U[J00MFfU[JF]YJfUKJ001FfP0200003E[KE]YJfUKJF]]FfP00E]YJfeKJF]]FfU[K0080000=
E]X005KJF]]FfU[KE]YJfeKJF]/005KKE]X00`0000eFfU[KE]YJf`00F]]FfUKKE]YJfeKJE]]FfP04
000025[KE]YFfeKJF]]FfP00D]X3E]/01U;J000005KKE]X0009Ff`09D]]FfeKKE]]BfeKK001Ffe;K
0080000=E]]BfeKKE]/005;KE_aBfeKkD]]Fo5;KE_/00`0000eFne;KE_aBfeKkD]]Fo5;K001BfeKl
D]]Fo00200000e;KE_`0000OOol001moo`03001oo`0001aoo`03001MB5e800EMB008001cN7=HLgQc
F7=hLeP000=^/`0>001^e7;DK]Abe6kDL]A^e7;DK]Abe000MeL000M^/`05001be7;DL]A^e003L]@0
3FkDL]@006jdK[=^]6jcK[A^/fjdK[=^]000009bm007L_E^m7;dL_@006ZC00002Fjd00H006keL_E^
mG;e0003J[@02P00K]E^e6kEK]A^eFkDK]E^e0000Vkf00M^m@00J[AZ]FZdJ[EZ]0030002K]D016[E
K]E^eFkE0P0000YZ]F[EJ[EZeFZeJ]EZ]F[EJ[D000=ZmP06001V]FZfI[EZ]P0026[F0P0000EZefKF
I]IVeV[G00=VeP06J]L006[g001VefKF0fKG00AVeVKG001Vf0=Ve`0=001R]fKGH[MVef:g001VefKH
I]MVf6KG00000f:g00=R^000H]P016;H00H006;HH[QRf6:h0005H]P04@00G[QRf5jhG]QN^000G]QR
fF;HH]UNf000G[QNfEjhG]T00P0015kI00<005kIG]T015kI00H005kIG]T005kIF]T3G]T01E[IG]UN
fEkI00000U[I00ENfU[IF]UJfEkJ00=Jf@06001Jf@00001JfU[I0e[J00=Jf@00F]X015[J00D005[J
F]YJfP0000UJfP03001JfU[J00MJfP04001FfU[JE]X20003F]X01000E]YFfU[K0eKJ00=JfeKJE]X0
0P0000UFfUKKE]YFfeKJE]]FfUKK00000eKK00IFfUKK000005KJE]/20006E]/00`00E]]Ff`030004
E]/00`00E]]Ff`06E]/30007E]/00`00E]]Ff`03E]/20002E]/00`00E]]Ff`06E]/00`00E]]Bf`02
0004E]/2000NOol001moo`8001ioo`15001MB5e8GDQIAee8001cN7=GLgQcF7=hLeMcN000K[AZ/fjd
001bmFkDL_E^e7;eK]AbmFkDL_D007MGLeH006ZcK[AZ/fjdJ[=^]6Zc001^e7;eK]Abm6kDL_E^e7;d
K]@006jcK[AZ/fjdK[=^]6ZcK[@007;eK]AbmFkDL_E^e7;e001ZU00000=^]00OJ[=^]6jdK[AZ/`00
K_EbmFkdL_E^mG;e001^]6ZD001Z]6kEJ[A^eFZdK]EZ]6kE001bmVkeL_H006jeJ[@0100001m^eV[E
K]IZeFkFJ]E^eV[E001Z]FkFJ[EZeVZeK]IZ]F[FJ[D006[fK_IZmVkg001Z]VJeJ[IV]@00I]IZe`02
J]H0>VKFJ]MZeV[F001ZefKFJ]MVeV[GI]IZefKFJ]L006[hI_L006JfI]MR]VKGI[IVe`00J_QVefKh
I]MZn000I]MR]fKGH[MVe`00I]QRefKHH]MVf6;G001R]fKH001Vf6;GI]QRf6KHH]MVf000H]QN]`00
0V;H021Nf6;IH]QRf5kH001N^6;HG[P005kHH]UNf6;IG]QRfEkH001N^5kI001RfEkHH]UNf6;IG]P0
05ZhG]UN^5kI0P0015kI00L005kIF]UNfU[IG]UJf@0200006ekJ001NfU[IG]YJfEkJF]UNfU[IG]YJ
f@00F]UNfU[IG]YJfEkJF]UNfU[I001JfE[JF]T00002F]X01E[IG]YJfP00E]X00e[J011FfU[J0000
05KJ001FfU[JE]YJfeKJF]YFfU[K001Jf`80000=E]YJfeKJF]]FfU[K001JfeKJF]]FfU[KE]X00P00
00eJf`00F]]FfU[KE]YJfeKJF]]FfP00E]YJf`03000035[KE]YJfeKJ001FfP00E]YJfeKJE]]FfP<0
0005E]YFfeKKE]]FfP03E]/01P00E]]FfeKKD]]Ff`800005E]YFf`00E]]Bf`03E]/01E;KE]/005Kk
D]/00`0000eBfeKlE]]Fn`00E_aBfeKkD]]Fo5;KE_]Bf`0300001e;KE_aBfeKlD]]Fo5;K008001eo
o`007goo00<007ooOol07Woo00<005e8GDP00Ue801L007=HLgQcF7=hLeQcN7=HLgP006jc001be6kD
L]A^e7;DK]Abe6kDL]@007MG00=cE`03001^/fjc00=^/`04001be7;DK]@3L]@04FkDL]Abe000LcH0
06jcK[A^/fjdK[=^]6jc001bm7;eK_@00W;d00AbmFkdL_@000U^]00E001bmFkeL_E^mG;eK_D006Zd
001^e6kEK]A^eFkDK]E^e6kE001^mVke00=^mP800003J[AZ]@0000=^e@0AJ]E^eFkEK]EZe@00KaH0
06ZeJ]EZ]F[EJ[EZeFZeJ]D00002J_H01fkfJ_IZmP00J[IV]@0000QZeP03001Zm`00009VeP0;J]MV
eVKFI]IZefKF001Vmf[gI_L00002I]L016KFI]MVe`000fKG019Vf6KGI]L006KGH[MVe`00I]QVefKH
I]MVf6KGI]P006:h0008H]P00`00H[P00008H]P03`00G]P00000G]QRfF;HH]UNf6;IH]QRf@00G]T0
0008G]T01000G]UNf@001UkI00@005kIG]UJf@9Nf@05001NfEkIG]T00003F]T01EkJF]UJfE[IG]X0
0P0000=Jf@00F]T00e[J00IJfE[JF]YJfP00F]X20007F]X01000F]YJfU[J0P000e[J00<005[JF]X0
1e[J00<005[JE]X00e[J00EFfU[JF]YJfP00009FfP0@F]/00000E]YJfeKJ001FfUKKE]YFfeKJE]]F
fUKKE]X20003E]/025KJE]]FfeKKE]X005KK0002E]/20002E]/00`00E]]Ff`06E]/00`00E]]Ff`03
0004E]/00`00E]]Ff`05E]/30008E]/00`00E]]Ff`03E]/20002E]/00`00E]]Ff`05E]/2000MOol0
01moo`03001oogoo01ioo`13001IAee8GDP007=GLgQcF7=hLeMcN7=HLgQcE`00J[<006kDL_E^e7;e
K]AbmFkDL_E^e000LeIgEg=FMeL006jdJ[=^]6ZcK[@007;eK]Abm6kDL_E^e7;dK]Abm@00MeL006jd
K[=^]6ZcK[A^/`00K]AbmFkDL_E^e7;eK]AbmFkD00000Vjd01aZ/fjdK[A^]6ZcK[@007;eK_AbmFke
L_E^m7;e001Z]000K]EZ]6kEJ[A^eFZdK]EZ]000K_EbmP@0000RJ[A^]FZd001ZeFkFJ]E^eV[EK]IZ
eFkF001_5`00J]IZ]FkFJ[EZeVZeK]H006kfJ_I^mf[fK_IZmP00I[D006KFJ]L2J]H0>VKFJ]MZeV[F
I]H006[g001VeV[GI]IZefKFJ]MVeP00I_MZn6KgJ_P006KGI[IVef:f001VefKhI]MZn6KGI_QVe`00
H[MVe`00I]QRefKHH]MVf6;GI]QRefKH001Vf6;GI]QRf6KHH]MVf6;HI]QRe`000V;H00INf6;IH]QR
f5kHH]T2H]P06@00H]UNf6;IG]QRfEkHH]UNf6;IG]QRf@00H]UNf6;IG]QRfEkHH]UNf6;I001Nf@00
00QNf@0Q001JfEkIF]T005[IG]YJfEkJF]T005[IG]YJfEkJF]UNfP00G]YJfEkJ001NfU[IG]YJfEkJ
F]UNfU[IG]X005kJ009JfP08F]UNfU[JF]YJfEkJ001JfP80009JfP0;E]YJfU[JF]X005[KE]YJfUKJ
F]]FfP02000035[K001JfeKJF]]FfU[KE]YJfeKJ001FfP80000=F]]FfU[KE]YJfeKJ001FfU[KE]YJ
feKJF]/00P0000eFfP00E]YJfeKJF]]FfU[KE]YJf`00F]]FfP02000025[KE]YFfeKJF]/005KKE]X3
E]/00eKJE]/000020003E]/01UKJE]]FfeKKE]X0009Ff`0BD]]Ff`00001FfeKk001Fne;KE_aFfeKk
D]]Fo5KK001BfeKl0`0000aFo5KKE_]Bf`00D]]Fo5;KE_aBfeKlD]/3000LOol001moo`04001oo`00
000NOol06@00GDP007=HLgQcF7=hLeQcN7=HLgQcF7=hLeP006kDL]A^e7;DK]Abe6kDL]A^e00000=c
E`04MeMcEg=G0003K[<00`00L]A^e003L]@04FkDL]Abe7;D001cEW<fMeL006jdK[=^]6jcK[@007;e
K_@00W;d00MbmFkdL_Abm000LcH00007K[@04P00K_EbmFkeL_E^mG;eK_Ebm@00K]E^e6kEK]A^eFkD
K]E^e0@00007K_I^mFkfK_H006Zd00000VkE015ZeFkEK]E^eF[EK]D006lGKaI_5`00J]EZ]F[EJ[EZ
e@00009ZmP06K_IZmV[fJ_I^mV[f0P0026[F00D006[gJ_MZm`0000=VeP0:J]MVeP00I_MZmfKgJ_MV
mf[g0002I]L01@00I]MVefKGI]P00fKG011Vf6KG000006KHI]MVf6KGI]QVefKHI]MVf000I_P000QR
f003001Rn00000QRf00?001Rn@00H]URf6;IG]QRfF;HH]UNf6;I001Rn@0000UNf@03001NfEkI00MN
f@04001Nf@000007G]T01000F]UJfE[I0P0000QNfU[IG]YJfEkJ001JfU[I0e[J00EJf@00001NfP00
00UJfP03001JfU[J00MJfP04001JfU[JF]X20003F]X01000F]YJfUKJ0e[J015FfU[J000005KJF]YF
fU[KE]YJfUKJF]]FfP00E]YFfeKJ00800006F]]FfUKK001FfeKJ0eKK00=FfUKKE]/010001UKK00<0
05KKE]/00eKK0P000UKK00<005KKE]/01UKK00<005KKE]/00P0015KK00<005KKE]/01UKK0`0025KK
00<005KKE]/00UKK0P000UKK0P006goo000OOol2000POol03@00GDP007=hLeQcN7=GLgQcF7=hLeMc
N7=H0080000dL_E^e7;eK]AbmFkDL_E^e000LeIgEg=FMeMcEWMGLeH006ZcK[AZ/`00K]Abm6kDL_E^
e7;dK]Abm@00MeMc=WMGLcH006ZcK[A^/fjdJ[<006kDL_E^e7;eK]AbmFkDL_D007MG0003K[@056Zc
K[A^]000K_AbmFkeL_E^m7;eK_EbmFkd001Z]6kEJ[A^eFZdK]D300009g;fK_EbmVkeL_I^mG;f001Z
]@00K]IZeFkFJ]E^eV[EK]IZe@00KaI_5flFKaL006[FJ[E^eVZe001ZmVkgJ_I^mV[fK_MZmVkf001Z
e`02J]H0?VKFJ]MZeV[FI]H006[gJ_QZmf[h001ZefKFJ]MVeP00I_MZn6KgJ_QVmf[hI_L006:f001V
efKhI]MZn6KGI_QVef[hI]MVn000I]QRefKHH]MVf6;GI]QRefKH001VnF;h001Rf6KHH]MVf6;HI]QR
e`00H]QVn@00H]T2H]P03ekHH]URf6;H001RnF;H001Nf6;IG]QRfEkHH]UNf00200002V;iG]T005kH
H]UNf6;IG]QRfEkH0P0000=RnP00G]T025kI00`005kJF]UNfU[IG]YJfEkJF]UNfP00G]X2000035[I
G]YJfEkJF]UNfU[I001JfEkJF]UNfP800006F]UNfU[I001JfEkJ0U[J00=JfEkJF]X00P0000ANfP00
F]YFfP=JfP05E]YJfU[J001FfP02000035[JE]YJfeKJF]YFfP00E]YJfeKJF]]FfP80000=F]]FfP00
E]YJfeKJF]]FfU[KE]YJf`00F]/00P0000aFfU[KE]YJfeKJF]/005[KE]YJfeKJF]/2000035KJF]/0
05[K001FfeKJF]]FfUKKE]X0009Ff`80009Ff`05E]YJf`00E]]FfP03E]/00eKJE]]Ff`0300003EKK
E_]FfeKkE]]FneKK001FfeKkD]]Fo5KK0080000>E_]Ff`00D]]Fo5KKE_]BfeKlE]]Fn`00E_aBf`80
0004E_aBfeKkD]/2000KOol00003Ool00000008000Ioo`8000Ioo`@000Moo`03001oogoo025oo`<0
0005LgQcF7=hLeQcN00400002goo000007;DK]Abe6kDL]A^e7;D00000W=G00YgEg=GLeMcEgMGLeL0
06jc001^e0=be00AK]Abe7;DL]A^e000LcIgEg<fLeIc=P00K[=^]6jc001^m002L_@02W;eK_Abm7;d
L_D007<gLcIc=`001Fjd00h007;eK_EbmFkeL_E^mG;eK_D007<g001^e6kE0`0000=^e@00K_H00Vkf
00U^mFkfK_I^mVkeK_H006kEJ]D00fkE011ZeFkEK]D006lFKaM_5VlGKaH006ZeJ]EZ]@00J_I^mP=Z
mP06K_IZmV[f001_60001V[F00<006[gJ_L016[g00h006[GI]H006KgJ_MVmf[gI_MZmfKgJ_MVm`00
0fKG00EVf6KGI]MVefKH009Ve`0;001Vn000I]QVefKHI]MVf6KGI]P00004I_P00`00H]QRf003H]P0
1P00H_QRnF;hI_T000ARf080000AH_URf6;iH]T005kHH]URf6;IG]P006;IH_UNfF;iH]T00005G]T0
1@00G]URfEkI00001ekI0P0000=NfP00G]T025kI00d005kJF]UNfU[IG]YJfEkJF]UNfU[I001JfP02
0002F]X01EkJF]YJfU[J000015[J0P000e[J00<005[JF]X01e[J00<005[JF]X01U[J00<005[JF]X0
0`0000eJfU[KE]YJfP00F]]FfU[JE]YJfeKJF]YFfP0200002EKKE]YJfeKJE]]FfU[KE]X00002E]/3
00001EKKE]YFfeKK00000UKK00<005KKE]/00eKK0`001eKK00<005KKE]/00eKK0P000UKK00<005KK
E]/01EKK00<005KKE]/00`0015KK00<005KKE]/01UKK0`001eKK0P006Woo00000`00Oomoo`02Ool0
0`00Oomoo`03Ool20005Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0TOol50006Ool0
=P00K]AbmFkDL_E^e7;e001gEg=FMeMcEWMGLeIgEg=FMeL006jd001bm6kDL_E^e7;dK]AbmFkD001c
=WMGLcIgEg<fMeL006jdJ[=^]000L_E^e7;eK]AbmFkDL_E^e000LcIgEg<f001Z/`=^]00<001bmFke
L_E^m7;eK_EbmFkdL_D007=G0`0002m^eFZdK]EZ]000K_EbmVkeL_I^mG;fK_EbmVke001ZeFkFJ]E^
eV[EK]IZe@00KaI_5flFKaM_5VlGKaH006Ze001ZmVkgJ_I^mV[fK_MZmVkf001_66/G001VeV[G009Z
eP1NI]IZe`00J_QZmf[hJ_MZn6[g001VeV[G001Zn6KgJ_QVmf[hI_MZn6Kg001W6000I]MZn6KGI_QV
ef[hI]MVn000J_UVn000H]MVf6;GI]QRefKH001VnF;hI_URn6Ki001Vf6;HI]QRe`00H]QVnF;HI_UR
f6Ki001RfF;H001Rf6;iH]QRnF;HH_URf000G]QRfEkH001Nf6;iG]URnEkHH_UNf@00G]QRfEkH001N
fF;jG]URnEkI0005G]T03000G]URnUkIG_X005kJF]UNfU[IG]YJf@80000;G_X005kJF]UNfU[IG]YJ
fEkJF]UNfP0200002e[IG]YJfEkJF]UNfU[IG]X005[JF]T00P000U[J00ENfU[JF]YJfP00009JfP04
E]YJfU[JF]X200002U[J001FfU[KE]YJfUKJF]]FfU[J0P0000iFfU[KE]YJfeKJF]]FfU[K001JfeKJ
F]]FfU[K0P0000]FfU[K001JfeKJF]]FfU[KE]YJfeKJ0080000>F]]FfU[KE]YJfeKJF]]FfP00E]YJ
f`00E]]FfP800003F]]FfP00009Ff`06E]YJfeKKE]]FfP000UKK0`0000aFneKJE_]Ff`00E]]FneKK
E_]FfeKkE]/300003UKKE_]BfeKkE]]Fne;KE_/005KkD]]Fo5KKE_/200003EKKE_/005KlD]]Fne;K
E_aBfeKk001oo`0001Uoo`0000<007ooOol00Woo00<007ooOol03goo00<007ooOol017oo00<007oo
Ool0<7oo00T006kDL]A^e7;DK]@007=GMeL00g=G00IgEg=GLeMcEgMG0003L]@04FkDL]Abe7;DK]@0
07<fMeMc=W=FLcIgEg<fLeH006jd00000W;d00ebmFkdL_Abm7;eK_@007<fLcMc=W<gLcH00003K[@0
2@00K_EbmFkeL_E^mG;eK_Ebm@0300001g<g001^eFkDK]E^e000009^mP05K_E^mVkfK_I^m@02K_H0
0`00KcL00002K]D046[EK]E^eFkE001_5flFKaM_5VlGKaI_5`00J]D006kf0f[f00U^mV[fJ_IZmP00
JaM_66/H000016[F00<006[gJ_L01V[g0P0000eZmfKgJ_MVmf[gI_MZmfKg001W66/H001Vf003I]L0
16KHI]MVe`0016Kh00H006KGI]QVefKH0007I_P06000H]QRf000H_QRnF;hI_URn6;iH_P006;H001R
fF;iH]QRnF;IH_URf6;i001Rf@80000:H]URnEkIH_URfF;iG]URn@00G]T200000ekIH]UNf@02G]T0
0f;IG]T00003G]T00`00G]UNfP03G]T00`00G]UNf@02G]T200002ekIG]YNfEkJ001NfU[IG]YJfEkJ
F]T00P0000ENfP00F]YJfUkJ00=JfP03G]YJfU[J008000QJfP03001JfU[J009JfP8000=JfP03001J
fU[J00AJfP800006F]X005[JF]YJfeKJ0U[J00EJfeKJ001FfU[K00<0000;F]]FfU[KE]X005KJE]]F
fU[KE]YFf`0200001EKJ001FfeKKE]X00eKK00=FfUKK00000UKK0`0015KK00<005KKE]/01EKK0`00
25KK00<005KKE]/00UKK0P000UKK00<005KKE]/01UKK00<005KKE]/00`0015KK00<005KKE]/01EKK
0`006Goo00000`00Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomoo`04Ool00`00Ool0000`Ool20000
?6kDL_E^e000LeIgEg=FMeMcEWMGLeIgEg=FMeMcEP00K]AbmFkDL_A^e7;eK]Abm000MeMc=WMGLcIg
Eg<fMeMc=P00K[<006kDL_E^e7;eK]AbmFkDL_D007MGLcIgEg<fMeL006jdJ[<006keL_E^m7;eK_Eb
m@@0002FKcIcEg<gLeL006kEJ[A^e@00L_I^mG;fK_EbmVkeL_I^mG;f001cF000K]IZeFkFJ]E^eP00
KaM_5VlGKaI_5flFKaM_5VlG001^mf[fK_IZmVkgJ_I^mV[f001[5flHJaM_6000J]IVeV[G001Zn6[g
J_QZmf[hJ_MZn6[gJ_P006[hI_MZn6KgJ_QVmf[hI_MZn000JaUW66/I001Vn6KGJ_QVefKh001ZnFKh
I_UVn6[iI_P006;GI]P006KiH_QVnF;hI_URn6KiH_P006;G001Rf6KiH]QVnF;HI_URf6KiH]P006;H
H_URf6;iH]QRnF;HH_URf6;i001RnEkHH_UNfF;iG]QRnEkIH_UNf6;i001RnEkIH_YNfF;iG]URnUkI
H_T005kI0P0000UNfF;jG]UNnUkIH_YNf@00F]T00P0000]NnU[IG_YJfEkjF]T005[IG]YJfEkJ0080
000;F]UNnU[IG_X005kJF]UNfU[IG]YJf@0200001Ekj001JfU[JG]X00e[J00ENfU[JF]X005[J0080
0003F]YJfe[J009JfP05F]/005[JE]YJf`0200003EKJF]]JfP00E]YJfeKJF]]FfU[KE]YJfeKJ0080
000<F]]FfU[KE]YJfeKJF]]FfP00E]YJfeKJ0P0000eJfeKJF]/005[KE]YJfeKJF]]FfU[KE]YJf`02
00002UKJ001FfU[KE]YJfeKJF]/005[K0UKK015FfP00001FneKJ001FfeKkE]YFneKKE_]FfUKk001F
neKK0080000=E_]FfeKkE]/005;KE_]FfeKkD]]FneKKE_/00`0000eFne;KE_aFfeKkD]]Fo5KK001B
feKlD]]Fn`02000015KKE_/0000067oo00000`00Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomoo`04
Ool2000bOol2000016kD001cEgMG0g=G00EgEg=GLeMcEgMG00800003BmT006kD00=be00AK]Abe000
MeMc=W=FLcIgEg<fLeIc=WMGLcH007;dL_E^m002L_@04G;eK_Abm000LcMc=W<gLcIc=g<fLcL006jd
001bmFkeL_D00`0000=bmFke00001G<g00H006kDK]D006kfK_D3K_H02FkeK_I^mVkf001cF6lhLeP0
0003K]D03@00KaM_5VlGKaI_5flFKaM_5VlG001_F@00009ZmP0>K_IZmV[fJ_H006/GKaQ[66lHJaM_
6000J]H000UZm`0B001[>@00J_MVmf[gI_MZmfKgJ_L006/HIaQ[66LHJaP006KH0fKG00<006KhI_P0
16Kh00<006KH00002VKh02D006;hH_URn6KiH_QRnF;hI_URn000H_T006;HH_URfF;iH]QRnF;IH_T0
06;i001RnEkIH_URfF;iG]URnF;IH_T006;i001Rf@03G]T01V;IG]UNfEkIH]T0009Nf@05G]YNfEkI
G]UNfP03G]T03000G]UNfUkIG]YNfEkJG]UNfUkI001Jf@8000=NfP04F]YNfUkJ0003F]X01ekJ0000
05[JG]YJfP0000UJfP8000QJfP04001JfP000006F]X01`00E]YJfU[JF]]FfU[J0080000<F]X005KJ
F]]FfU[KE]YJfeKJF]/005[K0P0000MFfe[KE]YJfeKKF]/00003E]/00eKJE]]Ff`0200001EKK001F
feKK00001EKK00<005KKE]/00P0015KK00<005KKE]/01UKK0`001eKK00<005KKE]/00eKK0P000UKK
00<005KKE]/01UKK00<005KKE]/00P0015KK00<007oo00005goo00000`00Oomoo`02Ool00`00Oomo
o`0<Ool30007Ool00`00Oomoo`0bOol0<`00L_D007MGLeIgEg=FMeMcEWMGLeIgE`00CmY;^DoJBkT0
06kDL_E^e7;dK]@007<fMeMc=WMGLcIgEg<fMeMc=WMG001bmFkDL_E^e7;eK]Abm@00MeMc=WMGLcIg
Eg<fMeMc=P020000TW;eK_@00000L_E^m7;eK_D006lfLeMc=g=GKcIcEg<g001Z]000K_EbmVkeL_I^
mG;fK_EbmP00LeQ_=g=HKcL006[EK]IZe@00KaI_5flFKaM_5VlGKaI_5`00KeU_F000J_I^mf[fK_IZ
mP00JaM_66/GKaQ[5flHJaL006[F001Zmf[hJ_MZn6[gJ_QZmf[h001[>F/HJcT006[hI_MZn6KgJ_P0
06/IIaQ[6FLHJaUW66/I001Vn6KG001Vn6KiI_QZnFKhI_UVn6[i001VnF;hI_URn6KiH_QVnF;hI_UR
n000H_T006;HI_URf6KiH]QVnF;H001RnFLJ001RnF;HH_URf6;iH]QRn@00H_YNn@00G]URnEkHH_UN
fF;iG]P200002V;jG_T005kIH_UNfF;jG]URnEkI0P0000URnP00H_YNfEkjG]URnUkIG_X00P0001MN
n@00F]UNnU[IG_YJfEkjF]UNnU[I001JfEkjF]UNnU[IG_YJfEkjF]T005[I00800007G_YJfUkjF]YN
nU[J00000e[J00=NfU[JF]X00P0000AJfP00F]YJf`=JfP0BF]]JfU[JF]X005[JF]]FfU[KF]YJfeKJ
F]]JfP00E]YJfeKJ0P0000aJneKJF_]FfP00E]YJfeKJF]]FfU[KE]X200003E[KE]YJfeKJF]]FfU[K
E]YJf`00F]]FfU[K0080000<E]YJneKJ001FfU[K001JfeKJF]]FfU[K0`0000eJneKKE_]FfU[kE]]F
n`00E_]FfeKkE]YFn`0200003EKJF_/005KkE]]FneKKE_]FfeKk001Fne;K00<0000=E]]Fo5KKE_/0
05KlE]]Fne;KE_aFfeKkD]/00`0000MBfeKlE]]Fne;KE_aFf`02000GOol00003001oogoo009oo`03
001oogoo00moo`03001oogoo00=oo`03001oogoo03Aoo`8000=cE`04MeMcEg=GLeL500001D_IBmY;
f@00K]@00W;D00h007<fLeIc=WMGLcIcEW<fMeMc=W=F001Wn`000W;d00ibmFkdL_Abm000LcIc=g<f
LcMc=W<gLcIc=g<f0`0000M^mG;eK_EbmFkeL_D00007LcL200001FkeK_I^mVkfK_D00fkf01D007=H
KcQcF6lgLeQ_>000J]D006lFKaM_5VlGKaI_5flFKaL006mIKeP00VmI00l006[fJ_IZmP00JaM_66/H
KaQ[5flHJaQ_66/G000026[g00<006/iJcP00f/i010006[gI_MZm`00JaQW66/HIaQ[66LHJaQW6000
I]L000QVn003001W6@0000MVn080000:HaUW6@00I_URn6;iH_QVnF;h0004H_T01@00H_URf6;iH]T0
0P0016;i00P006;IH_UNfF;iH]T005ki0V;i00ERnUki001NfF;I00=Nf@06001NnEkjG_UNnP000UkI
00ANfUkIG]T000=NnP08001NfUkIG]YNfEkJG]UNfP800005G_X005kJG]YJfP03G]X015[JG]YNfP00
0e[J00MNfU[JF]YJfUkJF]X00003F]X20004F]X00`00F]YJfP04F]X200000e[J001JfP07F]X01P00
F]/00000F]YJf`=JfP07F]/005[KE]YJfeKJF]/00P0000eFfU[K001JfeKJF]]Ffe[KE]YJfeKK001F
fP0200001e[KE]]FfeKKF]]Ff`00009Ff`03001FfeKK0080009Ff`03001FfeKK00EFf`03001FfeKK
00<000AFf`03001FfeKK00EFf`<000QFf`03001FfeKK00=Ff`800003E]]Fn`0000MFf`03001oo`00
01Ioo`0000<007ooOol00Woo00<007ooOol03goo00<007ooOol00goo00<007oo0000=Woo0`0000=c
EWMG00000`000goo0P00021?fP00L_A^e000LcIgEg<fMeMc=WMGLcIgEg<fMeL006OkHo]Wn`00L_E^
e7;eK]@007<fMeMc=WMGLcIgEg<f0`000<1[fP00K_EbmFkdL_E^mG;e001cEg<gLeM_=W=GLcMcEflf
LeL007;fK_EbmVkeL_I^mG;fK_D006lgLeQ_=g=HKcMcF000K]H006lGKaI_5flFKaM_5VlG001_FFmH
KeU[F6mIKeP006[fK_L006lHJaM_66/GKaQ[5flHJaL006]I001Zmf[hJ_MZn6[gJ_P006/iJaQ[>FLH
JcU[6000I_MZn6Kg001W66/IIaQ[6FLHJaUW66/IIaP006KhI_UVn6[iI_QVnFKhJ_T006LJHaUW6P00
I_URn6KiH_QVn@00IaYRnFLIH_UW6P00I_URf6KiH]P006;iIaYRnFLIH_UW6P00H_URf000H_URnUki
H_YRnF;jG_T005kIH_UNf000G_URnUkiH_YNnF;jG_T005kIH_UNf@00G_URnUkiH_YNn@00G]URnUkI
G_X005kjG_UNnUkiG_X005kjF]UNnU[IG_X005kjF_YNnP00G_YJfEkjF]UNnU[IG_X2000035[J001J
fUkjF]YNnU[JG_YJfUkj001NfP800007F]YNne[JF_YJfUkk00000U[J011Jfe[J000005[kF]YJne[J
001JfU[KE]YJfe[JF]]FfP80000<F_]FfU[kE]YJneKJF_]FfU[k001JfeKJ0P0000eJneKJF_]FfP00
E]YJfeKJF]]FfU[KE]YJf`0200002eKJF_]FfU[kE]YJneKJF_/005[KE]X00`0000aFfU[kE]YJn`00
E_]FfU[kE]]FneKJF_/300003E[kE]]FneKJF_]FfeKkE]X005KKE_]FfeKk0080000>E]]Fn`00E_]F
feKlE]]FneKKE_aFf`00D]]Fo0<0000<E_aFfeKkD]/005KKE_]BfeKlE]]Fne;K0`005Woo00000`00
Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`03Ool2000jOol30008Ool30000
37;D001cEW<fMeMc=W=FLcIgEg<fLeH000EWn`09001bm7;dL_D007<gLcIc=g<f00<0000;LcH006_K
Km][fP00K_EbmFkeL_D00009LcL01@00Kk/006kfK_D00fkf01E^m@00KcQcF6lgLeQ_>7=HKcMcF000
KaM_5VlGKaI_5flFKaM_5P00KeP00fmI019_F6mI001^mP00KaQ[66lHJaM_66/HKaQ[5`00JeU[FV]I
0005J_L00`00JcQ[>@02JcT04V/hJcU[>@00I_L006LHJaQW66/HIaQ[66LHJaQW6000IcT000IVn003
001W6FLI009W6@03001Vn6Kh009Vn003001W6F<I00=W6@06HaUW6@00I_URn0001f;i00<006;I0000
26;i00D006;i000005ki009Rn@07H_YNnF;iH_URnP00G]T00P0000UNnEkjG_UNnUkiG_YNn@00G]T0
0P001ekj00D005kJG]UNfP0000ENnP0<001NfUkJG]YJfUkJ001NnU[jG_X005kJ0e[J00INfU[JF]YJ
fUkJ0009F]X02`00F]X00000F]YJnU[JF_YJfU[j00001E[J0P0000AJfU[k001Jf`=JfP05F]]JfU[J
F]YJf`0200003E[JF]]FfU[KF]YJfeKJ001Ffe[KE]YJfeKK00800003F]]Ff`0000=Ff`05F]]FfeKK
E]]Jf`020002E]/00`00E]]Ff`03E]/00`00E]]Ff`02E]/200000eKkE]/00008E]/00`00E]]Ff`02
00001UKkE]]FneKKE_/000MFf`<00009E_]FfeKkE]]FneKKE_]Ff`0000AFf`800004E]]Fn`00000E
Ool00003Ool00000008000ioo`@000Ioo`03001oogoo04Ioo`800008MeMc=WMGLcIgEg<fMeMc=P80
000<Io]SnfOkHoYWnf?k001^e7;e001gEg<f0`00061c=WMGLcH006_JKm][fVoKJmX006keL_E^m000
LcMcEflfLeMc=g=GKcIcE`00Kk][^Vnk001bmVkeL_I^m@00KcMcF6lgLeQ_=g=HKcMcF000Kk/006lG
KaI_5flFKaM_5P00KeQ_FF]HKeU_F6mIJeQ_F@00KaQ[5flHJaM_66/GKaQ[5`00JeU_FV]IJeY[F@00
J_MZn6[g001[66/iIaQ[>F/HJcUW66/iJaP006LHJaUW66/IIaQ[6FLHJaT200004FLiIcYW>@00I_QV
nFKhJ_T006LJHaUW6VLIIaYS6@00H_P00P00049W6V;iIaURnFLJH_UW6F;i001Rf000H_UW6V;iIaUR
nFLJH_UW6F;i001RnF;jG_URnV;iH_YNnF;jH_URnP00H_YNnF;jG_URnUkiH_YNnF;jG_URnP00H_YN
nF;jG_URnUkiH_YNnF;jG_T005kiG_YNnEkjG_UNnUkiG_YNn@00F]T2000065kjF_YNnU[iG_YJnUkj
001NnU[IG_X005kkF]YNnU[JG_/005kjF]YNnU[JG_YJfP80000HG_/005kkF]YJnU[JG_]JfU[jF]YN
n`00F_]JfU[kF]YJne[JF_]JfU[k001Jfe[J0P0000aJne[JF_]FfP00E]YJneKJF_]FfU[kE]X20000
35[k001JneKJF_]FfU[kE]YJn`00F]]FfP<0000;E]YJneKJF_/005[kE]YJneKJF_]FfP0200003E[k
001JneKJ001FfU[kE]YJneKJ001FfeKk0080000=E]]JneKJF_]Ff`00E]YJneKKE_]FfU[kE]/00`00
00eFfeKkE]]FneKKE_]Ff`00E]]FneKKE_aFf`0200003UKlE]/005;KE_aFfeKkD]]Fo5KKE_/005Kl
E]/2000015KlE]]Fne;K0`0037oo1P000Woo000MOol00`00Oomoo`18Ool200001W<fLeIc=WMGLcH0
00UWn`03001^m00000800004LcIc=g<fLcL200002V_KKm][fVoKJm]_f`00L_E^m@0027<g01<006nk
Kk]_^f^jKk/006kfK_D006lhLeQ_=g=HKcQcF6lgLeP00003Ji/200001FlFKaM_5P00KeP00fmI01U_
F6mIKeU_F@00Ji/006lHJaM_66/HKaQ[5`00JeU[FV]IJeY[FF]JJeT006[g001[>003JcT04F/hJcU[
>F/iJcP006MJ001W66/HIaQ[66LHJaP006LjIcT00fLj00D006KhI_QVn00000QW6@04001W6FLIHaT3
IaT01V<IIaUW6FLIHaT000QRn@800003HaX006;i00IRn@800006HaX006;iH_URnUki0V;i00eRnUki
000006;j001NnUkiG_YNnEkjG_UNnP0200000ekj001NnP08G_X00`00G_YNnP07G_X03@00F]X00000
G_YJnUkjF_YNnU[jG_X005kJ009JfP8000=JnP03001JfU[J00EJfP80000;F_X005[jF]YJnU[JF_YJ
fU[jF]YJnP0200002U[JF_]JfU[kF]YJne[J001JfU[K0U[J0P0000]JfU[kF]/005KJF]]JfU[KE]YJ
fe[J00<0000:E]]JfeKJF]]Ffe[KE]YJf`00F]/2E]/200001EKKE_]Ffe[k00000UKK00<005KKE]/0
0UKK0`0000QFneKKE_]FfeKkE]]Fn`001EKK0P0000aFfeKk001FneKKE_]FfeKkE]]FneKK0002E]/2
00003EKKE_]FfeKk001FneKKE_]FfeKkE]]FneKK00<00007E]]FneKKE_]FfeKkE]/00P0037oo00<0
07ooOol01Goo000MOol00`00Oomoo`1:Ool200001GMGLcH006?jIo/02`0001QgEg<fMeMc=WMG001_
ff_JKm][fVoKJmY_ff_JKm/007;e001cEflfLeMc=g=GKcH200009fnkJkY_^f^jKk][^Vnk001bmP00
LeQ_=g=HKcMcF6lgLeP006nkJi]_^f^JKk][V`00KaH006mHKeU[F6mIKeQ_FF]HKeT006^LIi][W002
00005V/GKaQ[5`00JeU_FV]IJeY[FFmJJeU[FV]I001[66/iIaQ[>F/HJcUW66/i0P0002IWFV]KIeX0
06LHJaUW66/I001[>VLiIcYW>F/jIcUW>P00J_T006LJHaUW6VLIIaYS6FLJIaT006<j001RnFLIH_UW
6V;iIaURnFLJ0P0000US6P00H_UW6F;iIaYRnFLI000016<J01h006;iH_YNnF;jH_T005kjHaYNnV<J
001RnUkiH_YNnF;jG_T005kjHaYNnP00G_URnUkiH_YNnF;j0002G_X02F;k001NnUkiG_YNnEkjG_UN
nP0200005e[j001JnUkjF_UNnU[jG_YJnEkjF_X005[JG_]JfUkjF]YNne[JG_YJfP00F]X00P0000]N
ne[JG_]JfUkkF]X005[JG_]JfU[j0080000;F]YJne[J001JfU[kF]YJne[JF_]JfP02000035[k001J
ne[JF_]FfU[kF]YJn`00F_]FfP80000;F_]FfU[kE]YJneKJ001FfU[kE]YJn`0200003EKJF_/005[k
E]YJneKJF_]FfU[kE]X005KJ0080000<F_]FfU[kE]YJneKJ001FfU[kE]X005KJ0P0000iJneKJ001F
fe[kE]YJneKKF_]FfU[k001FneKJ0P0000eFneKKF_]Ff`00E]]FneKKE_]FfeKkE]]Fn`0300003EKk
E]]Fo5KKE_]FfeKl001Fne;KE_aFfeKk0080000=E]/005;KE_aFfeKkD]]Fo5KKE_/007oo000037oo
00<007ooOol017oo000LOol00`00Ool0001=Ool50004Ool30004Ool200002g<fLcL006oKJm]_ff_J
Km][ffoKJmX01@001G<g00<006^jKk/00Vnk00E[^VnkKk]_^f^j00800008LeQ_=g=HKcQcF6lgLeP0
00Q[V`03001_F6mI009_F@03KeQ_FFmI0080000EJi]WVf^KIi][VfNK001[5`00JeU[FV]IJeY[FF]J
JeU[FV]I001WO000009[>@05JcQ[>F/iJcT00002IeX01VMKIeYWFVMJ001W60800003IcYW>FLj009W
>P05IcUW>VLjIcX00008IaT01@00HcYW>f<j00000VLI00ES6FLIIaUW6@0000AS6P03001RnF;i009R
n@03001S6V<J00=S6P03001RnF;i009Rn@04001S6V<JGaX2HaX01@00G_URnF;iH_X00P0000=NnV;j
G_X00Ukj00@005kiG_YNn@8000ENnP03001NnUkj009NnP8000=NnP03001NnUkj00ENnP80000>G_X0
05[jG_YJnUkjF_YNnU[jG_YJnP00F_YNnP=JnP04G_YJnU[j0002F]X200002e[kF_YJnU[jF_]JnP00
F]YJnU[JF_X00P0000]JnU[kF_X005[JF_]JfU[kF]YJne[J00<0000;F]]Jne[JF_]Jfe[kF]YJn`00
F]]FfP0200003E[kE]]Jne[KF_/005[KE]]JfeKJF]]Ffe[K0080000:E]]JneKKE_]Ffe[kE]]FneKK
0002E]/200003EKKE_]FfeKk001FneKKE_]FfeKkE]]FneKK00<0000=E]]FneKKE_]FfeKkE]/005KK
E_]FfeKkE]/00P0000eFn`00E_]FfeKkE]]FneKKE_]Ff`00E]]Fn`03000035KkE]]FneKK001FfeKk
E]]FneKKE_]Ff`800003Ool007oo00]oo`03001oogoo00=oo`0077oo0P00E7oo0`0027oo300000=>
g5;mC]`0100000]cEflf001[^VnkJkY_^f^jKk][^Vnk0080000@?i]3_000001_=g=HKcMcF000Kk][
VfnkJiY_^f^KKk/200006U>m000006mIKeQ_FF]H001WVf^LIi][W6NKJiaWVf^LIi/006]IKeY[FF]J
JeU_FV]IJeX200006f=kIgaSN`00JaQ[>FLHJcT006]KIeY[FfMJJe]WFV]KIeX006LiJcYW>FLjIcU[
>VLiIcYW>@0200001fMK001W6VLIIaYS6FLJ00800009HcYW>f<jIc/006LJH_UW6F;i00800008IcYS
6VLkHaYW>V<J001Rn@8000MS6P0=001RnP00001NnV<JG_YS6UkjHaYNnP00G_T00P0000US6UkjHaYN
nV<JG_YS6P00H_X00P000ekj00MRnekjG_YNnP00G_UNnP0200002ekjG_]JnUkkG_YNn`00G_YJnUkj
F_T00P0000]Nne[jG_/005kjF]YNne[JG_YJfUkk0080000:F_X005[JG_]JfUkkF]YNne[JG_/20000
2e[JG_]JfU[kF]YNne[JF_/005[kF]X00P0000]Jne[JF_]JfU[kF]X005KJF_]JfU[k0080000<F]YJ
n`00F_]FfU[kE]YJneKJF_]FfU[k0P0000eFfU[kE]YJneKJF_]FfP00E]YJneKJF_]FfP0200002e[k
E]X005KJF_]FfU[kE]YJneKJF_/00`0000eJn`00F_]FfU[kE]]Jn`00F_]Ffe[kE]YJn`0200003EKK
F_/005KkE]]JneKKE_]Ffe[k001FneKK00<0000<E]]Fo5KKE_/005KlE]]FneKKE_aFfeKk0`0000eF
neKKE_aFfeKkE]]Fo000E_]BfeKlE]]Fn`02000015KKE_`000003Goo00<007ooOol00Woo000LOol0
0`00Oomoo`1AOol2000<Ool00`00D_aBo006D_`00`00C_aBo002C_`80002Kk/00f^jKk/000020006
?i`200000g=H001[V`05Ji/200001E?NDkeCgU>nDmh00P0000Y_F@00Ii][VfNKJi]WVf^KIi][V`80
0009Fkh006]IJeY[FF]JJeU[FP0000IWO004001[>@000002IeX01FMKIeYWFVMJIe/00P0000=SO000
IcT00fLj00AW>FLjIcX000=SF`03Ie/006LI009W6@04001S>V<jIc/3HcX00fLk001W6@020009HaX0
0`00HaYS6P08HaX01@00HaYS6V<JGaX00f<J00AO6V<JHaX000=NnP05H_YNnUkjG_YRnP02G_X00`00
G_YNnP08G_X20008G_X00`00G_YNnP0200002e[jG_YNnUkjF_YNnP00G_YJnUkjF_X00P000U[j00EN
n`00F_YJnUkj00=JnP800003F_/005[k00=JnP05F_]JnU[jF_YJn`0200002e[jF_]JnU[kF_YJne[j
F_/005[kF]X00P0000=Jne[jF_/00U[k00L005[kF]]Jne[JF_]Jf`0200003E[k001JneKKF_]Jfe[k
E]]Jne[K001FfU[K0080000;E_]JneKkF_]Fn`00E]]JneKKE_]Ff`020002E_/02`00E]]Fn`00E_]F
feKkE]/005KKE_/00`0000aFneKKE_]Ff`00E]]FneKKE_]FfeKkE]/300003EKKE_]FfeKkE]]FneKK
001FfeKkE]]FneKK0080000=E_]Ff`00E]]FneKKE_]FfeKkE]]Fn`00E_/00`0000EFneKKE_]FfeKk
008000eoo`03001oogoo005oo`0077oo00<007ooOol0CWoo0`003goo00P005;mC_aBo4klD_e>o5;l
1@0000QBoDkLD_e>g000B]a>oD[L4P0000=_^f^JKk/00P0000QC_EONDkeGgU>mEmiC_EON0P0000MW
Vf^LIi][W6NKJiaWV`0200007U^nEkeK_UNm001[FFmJJeU[FP00IgaSNfMlHg]WO6=kIgaSN`00IeY[
FfMJJe]WFV]KIeY[F`00HgaOO09SO005001W>F/jIcUW>P02000076=KIe]SFfMKHe]WF`00IaX006Lk
HcYW>f<jIc]S>VLkHcYW>`00Ic]S6VLjHaYW>f<JIcYS6VLk0P0000=O>`00HaX01V<J0P0000US>`00
HaYNnV<JG_YS6UkjHaX00P0000UO6P00G_YS6UkjHaYNnV<JG_X00P0000ES6`00G_YNnV;k00=NnP0>
H_/00000F_X005kjG_]JnUkkG_YNne[jG_]NnP80000;G_]JnUkkF_YNne[jG_]JnP00F]YNnP020000
2U[jG_]JnUkkF_YNn`00G_]JfUkk0P0000]JnUkkF_YNn`00F_]JfUkkF]YJne[J0080000;F_/005[k
F]YJne[JF_]JfU[kF]YJn`02000035KJF_]JfU[kE]YJne[J001FfU[kE]YJn`80000<E]YJneKJ001F
fU[kE]YJneKJF_]FfU[k0`0000YJneKJF_]FfU[kE]YJn`00F_]FfP<0000<E]]JneKJF_/005[kE]YJ
n`00F_]FfU[k0`0000eJneKKF_]Ffe[kE]]JneKK001FfeKkE]]Jn`0200003EKKF_`005KkE]]Fo5KK
E_]FfeKlE]/005KK00<0000<E]]Fo5KKE_]Ff`00E]]FneKKE_aFfeKk0`0000]Fo5;KE_aFfeKlD]]F
o5KK001oo`0000eoo`40005oo`5oo`0077oo00<007ooOol0Bgoo0`004Woo00<005;lD_`00e;l0P00
0U;l010004kLC_a>g4klC]a>o4kL001>g4kMB]a>gDkLC]e:g0D00008A]e:gDKM0012_D;M@[e2g@@0
0005DkiCgU>mDmiC_P0400028a/200000f^KIi][V`020007Fkh01000JeT000001fMl0P0000AKW@00
001WF`=WFP03Ie/006=l00ESO005001W>@00001WF`03He/01VMKHe]SFf=KIe/0009S>P06Ic]S>V<j
HcYW>f<j0P0000=SG000HaX01V<J00H006<kHc]S>elk0005HaX01P00Ga]S>elKHc/000=S6P05GaYS
6P00Ha]O6P02Ga/01`00G_YNnUkjH_YNnP00009O6`03GaYO6`0000ENnP06001O6elKGa]O6P001Ukj
0P0000=Nn`00F_X00ekj00EJnUkjG_YNnU[j00800005G_]JnU[jF_YNn`03F_X03@00F_X00000F_]J
nU[kF_YJne[j001JnU[k009JnP80000;F_YJne[kF_/005[kF_YJne[jF_]JnP02000015[k001Jne[j
0e[k00EJnU[kF_/005[J008000IJn`06001Jfe[kE]]Jne[K0P0000]JneKk001Fne[kE_]JneKkF_]F
ne[k00800003E_]JneKk009Fn`08F_]FneKk001FneKK001Ff`80009Fn`0<001FfeKkE]]FneKKE_]F
feKk001FneKK0P001EKk00L005KkE]]FneKKE_]Ff`0300002eKKE_]FfeKkE]]FneKKE_/005KkE]/0
10000UKk00T005KKE_]FfeKkE]]FneKKE_/00`003Goo0@000Goo0Goo000LOol30018Ool3000FOol0
0`00C_aBo@02000044klD_e>o5;lC_`004kLD_e>g5;mC]aBoDkL001:g4km1000011:g4km001:gDKL
B]e6g4[MA]`004:m@]dn_D;N@[e2gA400009FkiG_E^nEkeK_UNmFkiG_E^n00<00006IgaSNfMlHg]W
O6=k0P0000EOWU^MFiiKWEnN00800005IeX00000HgaOO003Hg`03EmlHgaSO000He]WFf=KIe]SFfMK
He]WFf=K0080000=Hed006LkHcYW>f<jIc]S>P00Gc]SG5lkHe`00P0000]S6VLjHaYW>`00Hc]O>f<l
Gc]S>`0000AS6P0M001O6V<kGaYS>elJ001NnV<JG_YS6P00Ha]O6V<KGaYS6`00HaYNnV<JG_X005lJ
Ha]O6UlKGaX00003G_X036;k001O6e[jGa]NnUlK001NnekjG_]JnP80000;Ga]JnUlKF_X005[jG_]J
nUkkF_YNn`0200005e[j001JnUkkF_YNne[jG_]JnUkkF_X005[jG_]JnUkkF_YNne[jG_]JnP00F]X0
0P0000]Nne[jF_]JnUkkF_X005[JF_]JfU[k0080000<F_YJneKj001JfU[kE]YJne[JF_]FfU[k0P00
00]FfU[kE]YJneKJF_]FfU[k001JneKJ00<0000;E_]JneKjF_/005[kE]YJneKJF_]FfP0200003E[k
001JneKKF_]FfU[kE]]JneKJ001Ffe[k0080000=E]]JneKKF_/005[kE]]JneKKF_]Ffe[kE]/00`00
00YFfeKkE]]Jo5KKE_]Ff`00E]]Fn`@0000;E]]Fo000E_]FfeKlE]]FneKKE_aFf`0300003EKKE_aF
feKlE]]Fo5KK001FfeKlD]]Fo5KK00800004E_aFf`000007Ool00`00Oomoo`02Ool10001Ool1Ool0
01]oo`03001oogoo04Ioo`<001Yoo`8000MBo008001>o4kLC_a>g4klC]a>o0<0000QC]e:g4kMC]a>
gD[LC]d004[MA]e:gDKMB]e6g@00@[e2gD:m@]e2_D;M000f_SJm>[hf_CJn=[d002Yn:YhZORZN00H0
00=K_P@00003@ghoOT=n0080009WO080009KWP06FieKWU^NFiiKWE^N0P0026=l0P0000=KO@000000
0V=K00=WFf=KHe/00P000emL011OG@00HcYS>VLkHcX006<kHeaO>f=LHc]SG5lk001S6P8000=S>`06
Gc]S>f<kHc/006<J0P0000UO6f<kGa]S>elKHc]O6`00GaX00P0000US6elJGa]O6f<KGaYO6`00H_X0
0P000UlK00MO6UlKGa]O6elJ001NnP020003Ga/01UlJGa]O6elK001NnP800009F_YO6ekkGa]JnUlK
001NnU[j009NnP800007G_]JnekkF_/005[jG_/00e[j00eNn`00001Jn`00F_YJne[jF_]JnU[kF_YJ
n`020002F_/01E[jF_]Jne[kF_X00U[k00@005[j000000IJn`04001Jne[kF_X2F_/20002F_/00`00
F_]Jn`05F_/3000035KkF_]Fne[kE_]JneKkF_/005[kE_]Jn`8000=Fn`05001FneKkE_]Jn`03E_/0
15[k000000000UKk00<005KkE_/00UKk00H005KkE]]FneKKE_/20002E_/00`00E_]Fn`05E_/30007
E_/01P00E_]FfeKkE]]Fn`80009Fn`03001FneKk00EFn`03001FneKK00<000AFn`8000Qoo`@000=o
o`006goo00<007ooOol0@goo0`007Woo00`004klD_e>o5;lC_aBoDklD_`005;mC]`400005e;mC]`0
04[LC_e:g4kmB]a>oD[L0016g4[MA]a:gDKLB]e6g000@[e2gCjm@]h03@0000HZWRIm000F?AYM5Sd4
00001T>O?gi3Wcmn@iloOP@00008FiiKWEnNFieKWU^MGiiKW@800004Cim;OP00Gg`3Hg`025ml0000
05]nFgeKOU]mFgh2000036=K000006=MGeaSGEmLHeeOG6=M001W>`80001<Gc]SG5lkHeaO>f=LGc]S
G5lk001O>f<kGc]S?5lkHc]O>f<lGc]S>`00Hc]O6V<kGaYS>elJHc]O6V<kGaX005lJHa]O6V<KGaYS
6elJHa]O6V<K001O6elJHa]O6UlKGaYS6elJGa]O6P00G_YO6e[jGa]NnUlKF_YO6ekjGa/005lKF_YO
6e[jGa]JnUlKF_YO6`00G_/200002e[jGa]JnUlKF_YO6`00G_]JnUkkF_X00P0000YNne[jG_]JnP00
F_YNne[jG_]JnP80000;F_]JnP00F_YJne[jG_]JnU[kF_YNn`0200002eKjF_]JnU[kE_YJne[jF_/0
05[kF]X00`0000YFne[kE_YJneKk001FfU[kE]YJn`80000=E_]Jn`00F_]Fne[kE_YJneKkF_]FnP00
E]X00P0000aJneKkF_]Fne[kE_/005KJF_]Ffe[kE]X200003E[kE_/005KKF_]Ff`00E]]JneKK001F
fe[k00<0000:E_]Ffe[lE]]Fn`00F_aFfeKkE]/200003EKkE]/005KKE_]FfeKlE]]FneKK001FfeKk
00<0000<E_aFfeKlE]/005KKE_aFfeKlE]]Fo5KK0`0000UFfeKlD]]Fo5KKE_aBfeKl00003goo000K
Ool00`00Oomoo`10Ool3000ROol20006D_`3000054kLC_a>g4klC]a>o4kL001>g4kMB]a>gDkLC]e:
g000A]e:gDKMB]d70002@]d02DKM000j_SZm?[hj_CZn>[d00002<Yh6000011IM000000HL1P0012LM
0P0000=KWE^NFih00`0000E;OdnOBgi?Wd]o00800003Hg`0000000=KO@05FgiKOE]mFgeKOP020000
0emLGeeOG002Ge`015mMGeaOG5mL0P0000USG6<kHeaO>f=LHc]SG5lkHe`00P0000EKG000Hc]S>elk
00=S>`0<Gc/00000Gc`006<kGa]S>elKHc]O6f<k0P0000=O>`00GaX00UlK00AS6elJGa]O6`800004
Ga/005lKGaX3Ga/01UlJGa/00000Ga/0009O6`05GaYO6elKGa]O6P0200005elK001O6ekkGa]JnUlK
G_]O6e[jGa/005kkF_]Nne[kG_]JnekkF_]Nn`00F_X00P001e[k00<005[jF_/00P001E[k00@005[k
F_]JnP9Jn`80009Jn`03001Jne[k00IJn`8000QJn`03001Jne[k00800003F_]Fne[k009Jn`08001J
neKkF_]Fne[kE_]Jn`800003E_]JneKk009Fn`06F_]FneKk001JneKk0`000eKk00=Jn`00E_/00UKk
00@005KkE_]Fn`<000QFn`03001FneKk008000AFn`03001FneKk00EFn`<000QFn`03001FneKk009F
n`80009Fn`03001FneKk00IFn`03001oogoo00eoo`006goo00@007oo000003aoo`<002Moo`03001B
oDkl00<0000@C]aBo000D_e>g5;mC]aBoDkLD_e>g000B]a>oD[LC_d700002d[MA]a:gDKL0012_DKM
@[e6gT:mA]d00P0000dj_Cjn>[dn_SZm000^WC:N;YdbWRjM000RO@0D00001TnOBgi?Wd]nCim;OP@0
0008FgiKOE]nFgeKOU]mFgiKO@800009Dgm?OP00GeaSGEmLHeeOG6=M00800009EeeKOP00HeaO>f=L
Gc]SG5lk00800009GeeKG5mMFe`005lkHc]O>f<l00800009Fc]O?5llGc`006<kGaYS>elJ00800009
GcaK>ellGc/005lJHa]O6V<K00800009Ga]O?5/KGc`005lKGaYS6elJ00800009GaaK6elLFa/005kj
Ga]JnUlK0080000;Fa]O75/KGa/005lKF_YO6e[jGa]JnP0200002UlL001O6e[jGa]JnUlKF_YO6e[j
0P0000YNne[jG_]JnUkkF_YNne[jG_]JnP800005G_]Jne[kF_YNn`02F_/00`00G_]JnP030002F_/0
2E[jF_/005[kE_YJne[jF_]FnP0200002e[k001JneKkF_]FnU[kE_]JneKjF_/00P0000eFne[kE_]J
neKkF_]Fn`00E_YJneKkF_]FnP0200002U[kE_/005KkF_]Fne[kE_]JneKk0`0000aFne[lE_]JneKk
F_aFne[k001JneKKF_/300002e[kE_/005KKE_]Ffe[lE]]FneKKF_`00`0000aJo5KKE_]Ffe[lE]]F
n`00E_aFfeKkE]/200003UKlE_/005KKE_aFfeKlE]]Fo5KKE_`005KlE]/200003EKlE]]Fo5KK001B
feKlE]]Fo5;KE_aFfeKl008000ioo`006goo0P00>goo0`00:goo0P000U;l00A>o5;lD_aBo0800006
C]a>o4kLC_a>g4kl1@0000E>gDkLC]e:g00000M:g@030012gDKM00=2g@09A]e2g@00>[dn_SZm>[hj
_@0000DbWP8000039WhROB9n008000035Ud00000014000@oG`800003FgeKOU]m00<000=COP06DgmC
OP00001OGEmL0P0000EKOE]MFgeKGE]m0080000=Hc]SG000001KG5mMFeaOGE]LGeeKG000Hc/00P00
1ell00d006<k000005lkGcaO>ellGc]O?5lk001O6P0200001ElLGa]O6elKGa`00UlK00@005lK0000
00MO6`04001O6`000003Ga/025/KGa]O6`00F_YO6ekkGa/200002U/KGa]K6e/K001Nne[kG_]Jnekk
0P000U/K00<005[kF_/01E[k0P0000=Jn`00F_/01e[k0P0025[k00@005[kF_]Jn`8000AJn`03001J
ne[k00AJn`800004F_/005[kE_/3F_/01UKkF_]Jn`00E_]Jn`800008E_]JneKkF_]Fn`00E_]Jn`9F
n`80009Fn`03001JneKk009Fn`05F_]FneKkE_/00002E_/30004E_/00`00E_]Fn`03E_/20002E_/0
0`00E_]Fn`05E_/00`00E_]Fn`020004E_/00`00E_]Fn`06E_/30007E_/00`00E_]Fn`03E_/20000
0goo001oo`0=Ool00003001oogoo00Aoo`8000Qoo`<000Moo`03001oogoo03Qoo`8002moo`0<001B
oDkLD_a>g5;mC]aBo4kL001>g5;m0`0001MBoDkL001:g4kMB]a>gD[LC]e:g000A]a:gDKLB]e6g4[M
A]`004:mA]e2_DKN01@000048Wd000005Uh25Ud>00001CmN@eloGT=O?eh01@0000U?OU=oCgiCOdmn
Dgm?OU=oCgh00`0000QGGE]nEeeKOUMMFgiGGE]n0`0000UOGE]LGeeKG5mMFeaOGE]LGed00P000Ull
00EK>ellGcaO?5/k009O?0800009GcaO>ellFc]O?5lkGcaK>ell0080000QFa]O?5lKGcaK6ellGa]O
?5/KGc`005lLFa]O75/KGaaK6elLFa]O75/K001K6elKFa]O75/KGa]K6elLFa/005[j0080000:Ga]K
6elLFa]O6e/KGa`005lKF_X200002UlKF_]O75[kGa/005kkF_YNne[j0P0000MK6e[kGa`005[kF_YN
n`02F_/01E[j000005/K00000e[k00MJnU[kF_]Jne[j001JnP0200002e[kE_]JneKkF_]Fn`00E_YJ
neKkF_/00P0000aFne[kE_/005KkF_]Fne[kE_]JneKkF_/300002U[kE_]JneKkF_]Fne[k001JneKk
0P0000eJo5KkF_]Fne[l001JneKkF_aFne[kE_]Jo00300002U[lE_/005KkF_aFne[k001Jo5KK0`00
00aFneKlE_]Jo000E_]Ffe[lE]]FneKKF_`300003EKlE_]Fo5KkE_aFneKl001Fo5KKE_aFfeKl0080
000=E_]Fo000E_aFfeKlE]]Fo5KKE_`005KlD]/00`000goo00<007ooOol037oo00000goo001oo`04
Ool20009Ool00`00Oomoo`05Ool00`00Oomoo`0fOol3000bOol01@00D_aBo5;lC_`00e;l0`0000I>
o4kLC_a>g4klC]`200001dkMB]a>gDkLC]e:g00000A:g@L000A6g@03000n_Cjn00<n_@03000f_SJn
00@f_P03000^WRZN00H000055Ud000003S`>?@0>0005=cl20002Dgh00e=o000000020002Bel01`00
FgeKGE]mFeeKOE]M0080009CGP08001KG5mMFeaOGE]LGeeKG0800003FeeGG@0000IO?0800009FceK
G@00GcaO>ellGc]O?5lk0080009K?005001O6elKGa]O7003Ga/200000e/l001O6`06Ga/200001E/K
001O6elKFa/00elK00AK6elK000000=K6`05Ga]K6e/KFa]O6`02Fa/20007Fa/00`00F_]Jn`020000
1e[kFa]Jne/KF_]K6`0000=Jn`8000AJn`03001Jne[k00EJn`8000UJn`06001Jn`00001JneKk0e[k
00EFn`00F_]JneKk009Jn`80000:F_]Fn`00E_]JneKkF_]Fne[kE_/300000eKkF_]Fn`02E_/01E[k
E_/005KkF_/00eKk0P000UKk00D005KkE_]Fn`0000=Fn`<000QFn`03001FneKk009Fn`80009Fn`03
001FneKk00EFn`03001FneKk00<000EFn`03001FneKk00AFn`<000Ioo`03001oogoo00aoo`0000=o
o`00Ool03goo00<007ooOol01Goo00<007ooOol0<goo0`00=Woo00<005;mC]`01000011Bo4kL001>
g5;mC]aBoDkLD_e>g5;m001>gD[LC]e:g0H0000QB]e:g4[MA]`004;MA]e2gDKM@]e6gD;M000n_Cjn
?[e2_Sjm000f_CZn=[df_SJm>[h002jN:Yd^WRZN;Yh002JN00T000033Ud0000000L00005=clg?SLo
<chg?`0500001d]oAei;Od]NBgm7GT]o00800009EeeKOP00001CGUMnDeiGOU=N00800003GeeKG000
00800005EeeKGUMMFeiGG@0200002EllFc/00000FeeK?5]MFcaKG@0200003UlkGc`00000FcaO?5/l
GceK?000Fa]O?5lKGc`200002E/lGcaK>ell001O75/KGaaK6`0200002UllFa]O?5/K001K6elKFa]O
75/K0P0000YO75/K001K6elLFa]O6e/KGaaK6`80000:Ga`005lKF_]O75[kGa]JnelLF_/200002UlL
F_]K6e[kGaaJne/KF_/005[k0P0000QK75[kFa]Fne/LF_/005[j0e[k00iJnP00001Jo5Kk001Fne[k
E_]JneKkF_]Fne[k0P0000]Fne[lE_]JneKkF_aFne[k001JneKk00<0000:E_]JneKkF_aFn`00E_]J
neKkF_/200003UKkF_`005[lE_]JneKkF_aFne[kE_/005KkF_/200002EKkF_aFne[lE_/005KkF_aF
n`0300003UKkF_`005[lE_]Fo5KkF_aFneKlE_/005KKE_/2000035KkE_aFne[l001Fo5KkE_aFneKl
E_]Fo0<0000;E_aFneKlE_]Fo5KkE_aFn`00E]]Fo0040009Ool00`00Oomoo`0<Ool00003Ool007oo
00]oo`H000Ioo`<0031oo`<003Yoo`80009Bo00=C_aBo5;lD_a>o000C]a>o4kLC_a>g4klC]`01@00
00A>g4kMB]`0009:g@06B]a:gD[MB]e:g0001dKM00<003jm?[h00cjm00<003Jn=[h013Jn00<002jN
:Yh00bjN0P0000HROR:N8Wh001Ym6Wh900000aZm000000050003<al00c<N00000005Bel50008Deh3
00002EMMFeeGGE]MEeeKGEMMFeeGG@03000025/lFeeK?E]MFcaKGE/mFed30008Fc`01@00Ga/00000
Gc`00e/l00EO?5/lFc`005lK0080009K7006Fa]K75/LFaaK6`000UlK0P0000IK6e/LFa]K75/K0003
Fa/01elK000005/KFaaK6`0000IK6`80000:Fa/005[kFa]Jne/KF_]K6e[kFa/20009F_/00`00F_]J
n`020005F_/00`00F_]Jn`03F_/20002F_/00`00E_]Jn`02F_/00eKkF_]Jn`0300002eKkF_]Fne[k
E_]JneKkF_/005[kE_/00P0000EJneKkE_]Fn`0000=Fn`05F_]FneKkE_]Jn`030007E_/00`00E_]F
n`030003E_/00`00E_]Fn`06E_/30007E_/00`00E_]Fn`02E_/20002E_/00`00E_]Fn`06E_/3000=
Ool00`00Oomoo`0<Ool00003Ool007oo00]oo`05001oogooOol00007Ool00`00Oomoo`0]Ool3000n
Ool03000D_e>g5;lC]aBoDkLD_a>g000C]aBo@@00009C]aBo@00C]e:g4kMB]a>gD[L0080000;B]e6
g4[MB]a:gDKL0012gDKM@]e6g@0J00002R9m000001in6WdNOQYm000FWAZN2@0000Dc7blN<alc7S<O
00L00004Aem3GdMO@el200000eMnDeiGOP0400002TmNCel005]NEeeKGUMMFeiGGE]N0P0000UCGEMN
001KGE/lFeeK?5]MFc`00P0000]KGELm001K?5llFcaO?E/lGcaK?5lm00800009Fc]O?5/lGcaK>ell
FcaO?5/k0080000:GcaK6ellFa]O?5/KGcaK6ellFa/200002UlLFa]O75/KGaaK6elLFa/005/K0P00
00YK75/KGaaK6e/LFa/005[kGa]Jn`80000:FaaK6e/LFa/005[kGaaJne/KF_/200002e/LE_/005[k
Fa]Fne/LF_]K6eKkFa`00`0000YJo5KkF_aFne[lE_]Jo000F_]Fn`<0000:E_]Jo5KkF_aFn`00E_]J
o5KkF_/200002eKkF_`005[lE_]JneKkF_aFne[kE_/00`0000eFne[lE_]Jo5KkF_aFn`00E_]Jo5Kk
F_]Fn`0200002U[lE_/005KkF_aFne[lE_]Jo5Kk0`0000eFne[l001Jo5KkF_aFn`00E_]Jo5KkE_aF
n`0200003EKlE_/005KkE_aFne[lE_]Fo5Kk001FneKl0080000;E_]Fo5KkE_aFn`00E_]Fo5KkE_aF
n`02000@Ool00`00Oomoo`0<Ool00003Ool007oo00aoo`04001oogoo0007Ool00`00Oomoo`0ZOol3
0012Ool20002D_`014klD_aBo5;l0`0000Y>o4kLC_a>g4klC]a>o000C]e:g09>g006C]e:g4kL001:
gD[L0T[M1P0014KM00P004:m@]e2_D;M@[d003Zm0cZn00@j_CZn000f_P<b_P04=[hb_P00:Yh70000
21Ym000001ZN6YdJWQZM00028[h70004<al02@00@em7Gd=OAem3GdMO@em7G`0300001DmOCei?GTmN
Cel00TmN0P0000=GGE]M00000P0000EGGU=NEeiCGEMN0080000:FcaKG@00001G?EMMEceGGELm0005
Fc`20002Fcd01@00FcaK?5/lGc`00U/l0P000U/l00<005/LFa/00e/L00iK6e/L000005/L001K6e/L
Fa]K75/KFaaK6e/L0P0000YK6e/LFa]K75/KFaaK6e/L001K6`80000:Fa]K75/KFaaK6e/LFa/005[k
Fa/20003Fa/00e/LFa/00005F_/200000e/KF_/00007F_/30002F_/02EKkF_]Jne[kE_]Jn`00F_]F
n`0200002e[kE_]JneKkF_/005[kE_]JneKkF_/00P000UKk00<005[kE_/00UKk00IJneKkE_/005[k
E_/30005E_/00`00E_]Fn`02E_/20002E_/01@00E_]FneKk00000eKk00<005KkE_/00`000eKk00=F
o5Kk00001UKk0`0000EFo5KkE_]FneKl009Fn`03001FneKk00<0019oo`03001oogoo00aoo`0000=o
o`00Ool03Goo00<007oo00001goo00<007ooOol09goo0`00Agoo00<004kLD_`00`00019Bo4kL001>
g5;mC]aBoDkLD_e>g000B]a>gD[LC]e:g4kMB]`5000014[LB]e:g0000TKM00]6g4KMA]e6gDKL000n
_D;N?[e2gSjm0080000A?[hj_CZn>[dn_P00=[hb_CJn<[hf_S:m000ZWRjn:Yh^_P0200000bJN0000
000500001aJM000002;N7[hRgQjn00800006<al_7S<O;ahc7blN0P0000=7Gd=O00000`0000]3?clo
001?GTmOCei?GdmNCem?GTmO00<00009EeiCGEMNDeeGGU=MEeiCGEMN00<0000;FeiG?E]MEceKGULm
FeeG?@00FcaO?00200001ELlFceG?5/mEc`00P0000iO?5/l000005/mEcaK?ELlFcd005llFa]O?5/K
0P0000YK?E/LFcaG7000Fa]O75/KGaaK6`80009K7008001K6elLFa]K75/KGaaK6`80000:FaaK6e/L
Fa]K75/KFaaK6e/LFa/200002e/LF_]K75KkFaaJne/LE_/005[kFa/00P0000YFne/LE_]K75Kk001F
ne[lE_]Jo080000;E_]K7000F_aFne[lE_]Jo5KkF_aFn`0300002eKkF_aFne[lE_]Jo5KkF_`005[l
E_/00P0000aJo5KkF_aFn`00E_]Jo5KkF_aFne[lE_/300002eKkF_aFne[lE_]Jo5KkF_`005[lE_/0
0P0000aJo5KkF_aFn`00E_]Jo5KkF_`005[lE_/300002eKkF_aFneKlE_]Jo5KkE_`005[lE_/01000
00YFo5Kk001FneKlE_]Fo5KkE_aFn`<001Ioo`03001oogoo00]oo`0000=oo`00Ool03Goo00<007oo
00001Woo00<007oo00009Goo0`00Bgoo0P0000=Bo4klD_`00U;l00a>o000001>o4kLC_a>g4klC]`0
04kLC]d400001D[LC]`004[MB]`00d[M00=:g000A]d01TKM00P004:m@]e2_D;M@[e2g@000cZn00@j
_CZn000f_P<b_P05=[hb_P00:Yh^WP03:Yh200039Yh00`009[hR_P0C0002@cl01Clo@cm3?d<o?cl0
0P0000=?GdmN00000`0000Y;Gd]N001CGEMNDeiGGU=MEeiCGP80009CGP09001G?EMMEceGGELmEeeG
?EMM00<00003FceG?5/m009K?@03EcaK?E/m00<00003FcaK?E/l009K?005FceK?5/l001K70020000
2E/LFcaK75/lFaaK?000FaaK6`030005Fa`01@00Fa]K75/KFa`00P000U/L00P005/LFa]K75/KFaaK
6e/L0P0000=K7000Fa/00U/K00EK75/KFa]K6e/L00<00008FaaJne/KF_]K75[kFa/0009Jn`800006
FaaFne/LF_]K70000e[k011Fne[k000005KkF_`005[kE_]JneKkF_]Fne[kE_]Jn`800003E_]Jo5Kk
009Fn`05F_aFn`00E_]Jn`02E_/20002E_/00`00E_]Fn`06E_/300000eKkE_aFn`02E_/00eKlE_/0
0004E_/20002E_/00`00E_aFn`02E_/015KlE_]FneKk0`0000=FneKlE_/00UKk00EFo5Kk001FneKl
009Fn`8001Uoo`03001oogoo00]oo`0000=oo`00Ool03Woo0P001Woo0P008goo0`00Cgoo00h004kL
D_a>g5;mC]aBo4kLD_d005;mC]aBoDkL100000m>gD[LC]e:g4kMB]a>g@00B]e:g4[MB]a:gD[L0000
0TKM00=6g4KM0000800000LV_P00000R_RJn8[hV_`0200001BKN:]lVgR[O9]h00P0000Dc7c;n=alb
oS<O00800005?cm3?clo@clo?`0500001d/nCem;?T]OBci?Gd/n00800003EeiCG@0000800009CciC
GTlnDei??P00EceKGULm00@00009EeiC?@00EcaK?ELlFceG?5/m0080009G?@09001K?ELlFceG?5/m
EcaK?ELl00800008FcaG75/mFaaK?5LLFceK70<0009K7009Ea]K75/LFaaG6e/L001K75/K0080000:
FaaG6e/LEaaK7000FaaK6e/LFa/200002U/LEa]K75LK001Fne/LF_]K75Kk0P0000YK75LK001Fne/L
E_]K75KkFaaFn`<0000;E_]K75KkFaaFne/LE_]K7000F_aFn`02000035/LE_]K75Kk001Fne[lE_]J
o5KkF_aFn`80000<Fa`005[lE_]Jo5KkF_aFne[l001Jo5Kk0P0000]Jo5KkF_aFne[l001Jo5KkF_aF
ne[l0080000=E_]Jo000F_aFne[lE_]Jo5KkF_`005[lE_/00`0000YFneKlE_]Jo000E_aFne[lE_]F
o080000=E_]Fo000E_aFneKlE_]Fo5KkE_`005KlE_/00P006goo00<007ooOol02goo00000`00Oomo
o`0?Ool00`00Oomoo`04Ool00`00Oomoo`0POol2001COol01000D_aBo4kl0e;l00=>o00000000`00
00M>g4klC]`004kLC]e:g002C]`01TkMB]a>g000B]e:g09:g@H000A6g@030012gD;M00A2g@09000n
gSjm?]hn_CkN000j_SJn00<j_P03=[h003:n00Db_P03000^_P0001/00004?cm3?clo?cl200001D]N
Bem;GT]OBeh01@000U=N00I?GU=NDeiCGTmNDeh4000025<mEciC?ELmDceG?U<m0002Fcd30005Ecd0
1000FcaK?5/m0U/l0P0000QG?5Lm001K?5/LFcaK75/l0P0000=G?5/m000025/L0`0025/L00@005/L
000000IK7003001K75/K00<0000:EaaK75/LFaaG7000F_]K75[kFa/200002eLKFa`005/LE_]K75[k
FaaFne/LF_/00`0000aFne[lE_]Jo5KkF_aFn`00E_]JneKkF_/2000015KkE_aFn`000eKk00AJo5Kk
E_]Fn`<00003E_]Fo5Kk009Fn`03E_aFn`00009Fn`<00005E_aFneKlE_/00003E_/015KlE_]FneKk
0`0000YFneKlE_/005KkE_aFn`00E_]Fo0<00005E_aFneKlE_/00003E_/015KlE_]FneKk0`007Goo
00<007ooOol02goo000IOol00`00Oomoo`0MOol3001FOol00`00C]aBo00400004DkLD_d005;mC]aB
oDkLD_e>g000B]a>gD[LC]e:g4kMB]`01@0001Q:g4[MB]`004KMB]e6g4[MA]e:gDKL0012_DKM@[e6
gT:mA]d003kN?[dngSjm?]h200001CJm>[hf_SZn=[d00P000S:n00<f_c:n<[h00P0000<^_Rjo;[h0
0P0001<^gbZn;]lZ_RkO000bgbkN;]l^gS;O;]h003;n=alfoSLO<_hg7`0200001Clo@clo?d<o?cl0
1`0000A7?T/oAci;?`800003CciCGTln00@0000;Ccm??P00DceGGU<mEeiC?EMNDceGGP030008Ecd0
0`00EcaK?@03000025/mEcaK?ELlFcd005/lEa`200001U/mEaaK?ELLFcd000=K700?Ea]K7000001G
75/m001K75LKFaaG75/LEa]K75LL00800008FaaG6e/LEa]K75LKFaaG6`<0000;Ea]K75LKFaaG6e/L
Ea]K7000FaaFn`0200002e/LE_]K75KkFa`005/LE_]K75KkFa`00P0000eFne/L001K75KkFaaFne/L
E_]K7000F_aFn`0200002e/LE_]K75KkFaaFn`00E_]Jo5KkF_`00P0000YFne[l001Jo5KkF_aFne[l
E_]Jo0<0000=F_aFne[lE_]Jo5KkF_aFn`00E_]Jo5KkF_`00P0000YFneKl001Jo5KkE_aFn`00E_]F
o0<0000=E_aFneKlE_]Fo5KkE_aFn`00E_]Fo5KkE_`00P0087oo00<007ooOol02goo000IOol00`00
Oomoo`0JOol3001JOol200000e;lC_aBo002D_`034klD_`004klC]a>o4kLC_a>g000C]a>g@@0009>
g003001:gD[L00=:g@03B]`0000000I6g@030012gD;M00A2g@05000ngSjm?]hn_@0D00001bjn0000
02Zn;]hZ_RkO0080008^g`03;]h^gbkO00800004=alfocLO=_l700003ClO@clo7d<o001;?d/nBcm7
?T/oBci;?dLn00<000M??P800003EceC?@0000<00003DciC?@0000QG?@<000=G?@05EcaG?ELmEceG
?0030003Ec`01U/mEcaG?5LlFcd0009K70800006FaaG75/LEaaK70001E/L0P0000=G75/L00001E/L
0P000ULL00<005/LEa`00e/L00=G75/LFa`00`0000]G75/LEa]K75LLFaaG6e/L001K75Kk0080000<
FaaG6eLLEa`005KkF_aFne[lE_]Jo5Kk0`0000]Fne[lE_]Fo5KkF_aFneKl001Jo5Kk00800006E_aF
neKlE_]Fo0000UKk019Fo5Kk000005KlE_/005KkE_aFneKlE_]Fo5KkE_`005KlE_/200001UKlE_]F
o5KkE_`0009Fn`0BE_`00000001Fo5Kk001FneKlE_]Fo5KkE_aFneKl001Fo5Kk0P008Woo00<007oo
Ool02goo000IOol00`00Ool0000GOol3001NOol03P00C]aBo4kLD_e>g5;lC]aBo@00D_e>g5;mC]`4
000054kMB]a>gD[LC]e:g4kM001:gD[LC]e:g4[MB]a>g@00B]e6g4[MA]d=000053jm@]hn_@00>[dn
gSZm?]hj_CkN000jgSJn>]hf_S[N=[h003:n=]lD000033Kn>alfoS/O0013?clN@clo7T<o?ai3?`80
0003Aci;?`0000<00003Aci;?`00009??P06Ccm??TlnCci??dln0`0000MC?E<nCceC?U<mDci??@02
0002Ecd400002ELnDcd005LlFceG?5/mEcaK?@0200002e<lEcd005/mEaaK?ELLFceG75/mEa`00`00
00]G75/mEaaK?ELLFceG75/m001K75LK00800008FaaG75/MEaaK7000FaaG6`80000;FaaG75/LEaaK
7000FaaG6e/LEa]K700200002eLLFa`005/LE_]K75KkFaaFne/LE_/00`0000aFne/LE_]K75KkFaaF
n`00E_]K75KkFa`200002eKkFa`005/LE_]K75KkFaaFne/LE_/00`0000YFne[lE_]Jo5KkF_aFn`00
E_]Jo080000=E_]Jo5KkF_aFn`00E_]Jo5KkF_aFne[lE_/00`0000YFne[lE_]Fo5KkF_aFn`00E_]J
o0<0000<E_aFneKlE_/005KkE_aFneKlE_]Fo5Kk0`0097oo00<007ooOol02goo000HOol3000EOol3
001ROol01000D_aBo4kl0e;l00=>o00000000`0000I>g4klC]`004kLC]d3C]`01TkMC]a>g000B]e:
g09:g@L00004A]e:gDKM0002A]d01D;MA]e6gDKM00000T;M01=2gSkM@]e2g@00>[hngSjn?]hj_SkN
000jgSJn>]hf_S[N=[h00002=]h02C;N=]hfgP00<]hbgc;N<]lbgP0200001CKo<_hfoc;o=_l00P00
00Hjoc/O=_lk7c[o>al2000013lO@clo7d<o1@0000M;?dLnAcm7?T/oAci7?`020002Cch40002Cch0
1@00DciC?U<nDcd00e<n00]C?@00000005<mEceC?ELmDceG?E<m0080009G?@8000EG?@03001K?ELl
009G?003Fcd00000009G?@09001K75LLFaaG75/LEaaK75LL00<00007EaaK75LLFaaG75/LEa`00`00
00=G75/LEa`00ULL00IK75LLEa`005/LEa`200002e/LEaaG75LLFa`005/LEaaK75LKFa`00P000ULL
00<005/LEa/00ULL00IK75LKEa`005[lE_/200002e/LE_]G75KlFa`005KlE_]Jo5KkE_`00P0000YF
neKl001Fo5KkE_aFneKlE_]Fo0<0000;E_aFneKlE_]Fo5KkE_`005KlE_]Fo00400002UKkE_`005Kl
E_]Fo5KkE_aFneKl0`0000]Fo5KkE_`005KlE_]Fo000E_aFneKl00@002Qoo`03001oogoo00Yoo`00
67oo00<007ooOol04Woo0`00IWoo00<004kLD_`0100000U>g5;m001BoDkLD_e>g5;mC]`00P0000I>
gD[LC]e:g4kMB]`50000;D[LC]e:g4kM001:gDKLB]e6gD[MA]`004;MA]e2gDKN@]e6g@00@]hn_D;N
?[e2gSjm000j_CkN>[dngSZm?]h003[N=[hjgSJn>]hf_P00<[hfgc:n=]lb_P02000013KO<]hfgc;N
500000e37clN@alo7P00Aci;?dLnBcm7?T/oAci;?`0300001dloBci??T/nCcm;?Tln00800003DceC
?P0000<0000;CceC?P00EciC?ELnDceG?U<mEciC?@030002Ecd02E<lEceG?ELmDcaG?@00FceG7002
00001ELmEaaG?ELLEcd00P0000=G75/m00000`0000QG75/m001K75LLFaeG75/L0P0000]G75LM001K
75LLFaaG75/LEaaK75LL00<0000:Ea]K75LLFaaG6e/LEa`005KkFa`3000035/LEaaK75LKFa`005/L
E_]K75KkFaaFn`<0000;E_]K75KkFaaFne/LE_]K7000FaaFn`0200002U/LE_]K75KkFa`005[lE_]J
o5Kk0P0000YK75Kk001Fne[lE_]Jo5KkF_aFn`@0000<E_aFne[lE_]Fo5KkF_`005KlE_]Jo5Kk0P00
00YFo5Kk001FneKlE_]Fo000E_aFn`@002aoo`03001oogoo00Yoo`0067oo00<007ooOol03goo0`00
JWoo0P00019Bo4klD_a>o5;lC_aBo000C_a>g4klC]a>o4kLC_`004kMC]`30002C]`00`00B]e:g003
B]d02T[LB]d004[MA]e:gDKMB]e6g@000TKM00E2gDKMA]e6g@000092g@03@]hng@0001X0000A=]hj
gSKN000foS[o>_hjocKn>_l003lO>_hk7c[o?aljoP0200000d<O?ai37`02@al01ClN000004/oAch0
10000TLn00<004/nCch00Tln00A;?TlnCci??P<00007Dci??U<nCciC?TlnDch00P0000=C?ELm0000
0`0000=C?E<n000025Lm0`0000EG?5LmEceG?ELl00=G?@<0000:EaeG75LMEaaG7ELLEad005/LEa`2
00001ULMEaaG75LLEad0009G7003FaaG75LL0080009G7003001K75LL009G7003FaaG75LL00<000QG
7003001G75/L00@0009G7009001K75KkEaaFo5/LE_]G75Kl00<0009Fo008E_]Fo5KlE_aFn`00E_]F
o080009Fo008E_]Fo5Kl001FneKlE_]Fo080009Fo005001Fo5KlE_aFn`03E_`015Kk001FneKl0P00
0UKl00MFneKlE_`005KkE_aFn`03000`Ool00`00Oomoo`0:Ool001Qoo`03001oogoo00aoo`<006io
o`0@001>g5;lC]aBoDkLD_a>g000C]aBoDkLD_e>g5;mC]`300004d[LC_e:g4kmB]a>o@00C]e:g4kM
B]a>gD[LC]d004[MA]a:gDKM00d0000B@]e6gT;M000ngD;N?]e2gSkM@]h003kN>]dngS[N?]hjg@00
0S[N00/fgS[O>]hjgP00>]lfgS[O=]hjgcKN00800005>_lfoS[o=_hjo`02000013[n?aljoSlO3000
00M77T/oAai;?dLNBcm77P0200000dloBch0000300002dlnBch004lmDci??E<nCceC?TlmDch00`00
00MC?U<mDciC?E<nDceC?P020002Ecd400002E<mEch005LmEaaG?ELLEceG700200002ULmDa`005LL
EceG75/mEaaG?ELL0`0000]G75/MEaaG7ELLFaeG75LM001K75LL0080000:FaeG75LMEaaK7@00FaaG
6e/LEa`200002e/MEa`005LKFaaG75/LEa]K75LLFa`00`0000eK75KkFaaFo5/LE_]K7000FaaFne/L
E_]K700200002UKlEa`005/LE_]K75KkFaaFne/L0`0000YG75KkFaaFneLLE_]K7000F_aFn`80000=
EaaFne/LE_]G7000F_aFneKlE_]Jo5KkE_`00`0000YFo5KkE_aFneKlE_]Fo000E_aFn`<0035oo`03
001oogoo00Yoo`0067oo00<007oo00002Goo0`00LWoo0P0000UBo4klD_a>o5;lC_`004kLC_`01000
00A>g4kl001>g@=>g003C]e>g000009:g@05B]a:gD[MB]e:g0050003B]d00`00A]e6g@04A]d00`00
@]e2g@04@]d20002?]h00d;N?]dngP0200001C[N?]hjgSkN>]h00P001C[N0P0000@fgS[O=]hjgPd0
000;?alnoSlO?_h004<N@am37T<O@ai37`020003Ach00dLoAch0000400000d/nCci;?P02Bch01Tln
Bch00000Dci??P@0009??P05001C?E<mDceC?P03Dcd03U<n00000000EceC?ELmDceG?E<mEcd005Lm
Ec`300002U<MEceG7ELmDad005LLEaeG75LM0P0000AG75LM001G7@=G7004EaeG75LLEa`30007Ea`0
0`00EaaK70020005Ea`00`00EaaG7003Ea`20002Ea`00`00EaaG7005Ea`00`00E_aK70030005Ea`0
1@00E_aFo5KlE_/00P0000=G75Kl00000UKl00EFneKlE_aFo5Kk00<000MFo003001FneKl009Fo003
E_/00000009Fo004001Fo5KlE_/3E_`015Kk000000000goo00<007ooOol0;Woo00<007ooOol02Woo
000HOol20008Ool2001gOol01@00D_a>g5;mC]`01000015BoDkLD_e>g5;mC]aBo@00C_e:g4kmB]a>
oD[L001:g4kM00@0000:B]a>g@00B]e6g4[MA]a:gDKL0006A]d200002d;MA]i2gDKN@]e6gP00@]hn
gD;N?]d05000018noc[N?_l003ko>_hnoc[n?_ljoP00?_i37ckn?alnoT<O?_h2000014<O@ai37d<N
1`0000e77T/oAai;?`00Ccm;?TlnBci??d/nCci;?P0300001dlmDci??E<nCceC?Tlm00800003DciC
?@0000<0000:Dci??@00DceG?E<mEciC?ELmDcd300002e<LEceC7ELmDaaG?E<MEcd005/mEa`00P00
00]G?ELLEceC75Lm001G7ELLFaeG75LM0080000:EaaG7@00FaeG75LMEaaK7ELLEad30002Ea`02E/M
EaaG75LLFaeG7000Ea]K700200000eLLFaaG7002Ea`01`00E_aK75KkFaaFo5/L00<0000;EaaFne/L
E_aG75KkFaaFo000E_]K700200002UKkFaaFo5LLE_/005KkEaaFne/L0P0000iFneLL001G75KkFaaF
neLLE_]K75Kk001Fne[l0P0000YFneKlE_]Fo5Kk001FneKlE_]Fo08000Moo`03001oogoo02eoo`03
001oogoo00Yoo`005goo00<007ooOol01Goo0`00NWoo100000i>g5;lC]`004kLC_a>g4klC]a>o4kL
C_`004kM0dkL100000Q:gD[LB]e:g4[MB]a:g@001T[M00<004KMA]d00TKM3P0000A2gD;N@]d000<n
gP04@]hngSkN0006?]h01`00>]hnoS[N?_hjgSkn00800003?_hnoc[n008noP800004?alnoSlO?_h7
0003@ah01DLO00177TLNBah00dLN00E;7P00001;?Tln00@0009;?P03001??Tln00I??P<00003DceC
?U<m009C?@05DciC?@00DceG?@040002Dcd02@00EceC7ELmEaeG?E<MEceG7@030002Ead02ELLEaeG
7ELMEaaG7@00EaeG700200001ULMEaaG7ELLEad000AG70800003EaeG700000QG70<000MG7003001G
75LL00@0009G7003001G75LL00IG70<00008EaaFo5LLE_aG75KlEa`0009Fo08000EFo003001Fo5Kl
00EFo0<000MFo003001Fo5Kl008000Uoo`03001oogoo02eoo`03001oogoo00Yoo`005goo00<007oo
Ool00Woo0`00OWoo00l005;lC]aBoDkLD_a>g000C]aBoDkLD_e>g5;mC]`01@00015:g4kmB]`004[L
C]e:g4kMB]a>gD[LC]d004[MA]a:gDKL00H0000IB]e6gD[MA]d004;MA]i2gDKN@]e6gP00@]i2gD;N
@]e2gT;M000ngD;N?]e2gSkM@]h00P0000DjgSkN?]hngS[N00800004?_ljgSko>]h=000033kn@aln
oT<O00177d<NAam37TLO@ai77`800004Aai;?dLNBcl500001dlnBai??T/NCci;7Tln00800003CceC
?P0000<0000:Cae??P00Dci??E<nCceC?TlmDch300001e<mDaeG?U<MDceC7ELn00800003DaaG?@00
00<0000;DaeG?@00EceG75LmDaaG?ELLEceC700300002U<LEaeG75LMDaaG7ELL001G75/M0P0000IC
75LMEaaG7E<L0003Ea`02E/MEa`00000EaeG7000EaaK7003Ea`00e/LEa`000020003Ea`015/LEaaG
75LL0P0000=G75Kk00000`0000YG75Kl001Fne/LE_aG75KkFaaFo0<0000;E_aG75KkEaaFo5LLE_/0
05KkEaaFn`0400002ULLE_`005KkE_aFneKlE_]Fo5Kk0`0037oo00<007ooOol0;7oo00<007ooOol0
2Woo000GOol00`00Ool000020022Ool02P00D_a>g5;lC]aBo4kL001>g4kl100000A>g4kl001>g@=>
g00:C]e>g000B]a:gD[LB]e:g4[MB]`50003B]d00`00A]e6g@05A]d01000A]e6gD;M0dKM0P0000I2
gD;N@]e2gT;M0003?]h00d;N0000000<00001Skn@_hnoP00?_i2oP<noP09@_h004<N@_i37d;n@ai2
oT<O00800004@ai77d<N@ah700001D/NAai;7TLN000024/n0`001dln00<005<mDcd0100000=C?Tlm
000025<m0`000U<M00EG7E<MDaeC7ELM0080009G7@@0000:DaeG7@00EaeG75LMEaaG7ELLEad30002
Ea`01eLMEaaG75LLEaeG7000009G708000EG7003001G75LL009G7080009G7003001G75LL00IG70<0
00MG7005001Fo5LLE_aG700200000eKlEa`00007E_`40007E_`00`00E_aFo002E_`2000@Ool00`00
Oomoo`0/Ool00`00Oomoo`09Ool001Moo`8008Ioo`05001Bo4kLD_e>g00400004DkmC]aBoDkLC_e>
g5;m001>oD[LC_e:g4kmB]`004[LC]d0100001I:g4kM001:gDKLB]e:g4[MA]`004KMB]e6gD[MA]e:
gDKM0012gDKN@]e6gPd0000I@]i2gD;N@]d003kM@_hngT;n?]e2oP00@_hngT;o?]i2oSkN000noT;o
?_i2ockn@_l00P0000@noT<O?_i37`L0000<Aam37TLO@ah004LNBai77T/OAai;7TLN0P0000=??T/N
00000`0000Y??T/N001?7DlnCae??TlMCci?7@<0000=CaeC?TlMDci?7E<nCad005<MDceC7ELnDad0
0P0000]C?U<M001C7ELmDaeG?E<MEceC7ELm00<0000:EaeC75LMDaaG7E<LEad005LMDa`400002eLM
Da`005<LEaeG75LMDaaG7ELLEad00`0000QG7ELLEaeG75LMEaaG7@000ULL0P0000=G75<LEad00ULL
00<005/LEa`00ULL011K7000001C75LM001G75KlEaaFo5LLE_aG7000EaaFn`80000:EaaFo5LLE_aG
7000EaaFo5LLE_/200003ULLD_/005KlEaaFneLLE_aG75KkEa`005KlE_/2000BOol00`00Oomoo`0/
Ool00`00Oomoo`09Ool000Aoo`8000Ioo`@000Qoo`03001oogoo08Eoo`@0000>C]aBo4kL001>g4kl
C]a>o4kLC_a>g4kl001>g@=>g0@00008C]e:g4[MB]a>gD[LB]d000I:g@030016gDKM0096g@L000A6
g@080012gDKN@]e6gD;M0012g@=2gP05@]e2gT;N000ngP03@]h013kN@]h000000ckn00E2oSkn000n
oT;n008noPL00005@ai2oTLN@_h00007Aah2000014/NAai;7TLN1@001d/N00<004lnCch010000TlN
00X005<nCceC?TlmDci??E<nCcd0009C?@800006DaeC?E<MDceC7@000e<M00AG7E<M0000009C7@04
001G7ELMDad3Ead01E<M00000000Da`00eLM00=C75LMEad00P000ULL100000=G7ELL00001eLL0`00
1eLL00<005LLEa`00`001ELL00<005LLEa`015LL0`0000QFo5LLE_aG75KlEaaFo0000UKl0P0000IF
o5LLE_aG75Kl0007E_`3000EOol00`00Oomoo`0[Ool00`00Oomoo`09Ool000Aoo`8000Eoo`03001o
ogoo009oo`03001oogoo00Ioo`8008Ioo`0?001Bo4kLD_e>g5;lC]`004kLC_e>g5;mC]a>oDkL00D0
000AB]a>oD[L001:g4kMB]a>gD[LC]e:g4kM001:gDKLB]e:g00600001D[MA]e:gDKL00000dKM00Y6
gTKMA]e6g@00@]e6gT;MA]i2g@80000;@]i2gD;N@]e2gT;M000ngD;n?]i2oP0=000034Ko@_i2oT;n
0012oTLN@_i77d;nAai2oP800004Aam37TLO@ah7000034LNBai77T/N001??T/MCci;7TlnBae??P<0
0007Cci?7DlnBae??TlMCch00P0000A?7E<nCaeC?PD0000;Dci?7E<nDaeC?TlMDciC7@00DaeG?@02
00002U<MEceC7E<mDad005<LEaeC75LM0P0000]C75LM001G7E<LEaeC75LMDaaG7E<L00<0000:DaaG
7E<LEaeC75LMDa`005LLEad400001U<LEad005LLDaaG7@9G7003DaaG7@0000800005EaeG75LLDaaG
7@02Ea`015<L001Fo5LL100000YBo5LM001G75KlEaaFo5LLE_aG70<0000;EaaFo5LLD_]G75KlEa`0
05LLE_aG7004000IOol00`00Oomoo`0ZOol00`00Oomoo`09Ool0011oo`03001oogoo00Qoo`03001o
ogoo08Aoo`0:001Bo4kLD_a>g5;lC]`004kLC_`4000014kLC_`004kM0dkL00Y>gDkL001:g4kMB]a:
gD[LC]e:g0D0009:g@05B]`004[MB]e6g@03B]d00dKM0016g@06A]d01@00@]e6gT;MA]d03@0000E2
oT;N@_i2gP0000E2oP030012oT;n00E2oP800004Aai2oT<N@_h70004Aah00`00Bai77P03Bah00dLN
Bah00002Bah40002Bah00`00Cai?7P06Cah50002Cad02e<NCad005<MDceC7E<mDaeC?E<MDcd00`00
1e<M00<005LMEad00P000U<M00IG7E<MDad005LMDa`3Ead200002U<MEad005LMEaaG7ELLEaeG75LM
0`0000EG7ELLEaaG75LM009G7003001G75LL009G7080009G7003001G75LL00IG70<000MG7003001G
75Kl00@0009G7008001Fo5LLE_aG75KlEaaFo0@001ioo`03001oogoo02Uoo`03001oogoo00Uoo`00
47oo00<007ooOol02Goo00<007ooOol0Q7oo00D005;lC]aBoDkL00@0000AC_e>g5;mC]a>oDkLD_d0
04kmB]a>oD[LC_e:g000B]a>g@0400004T[LC]d004[MB]a>gD[LB]e:g000A]e:gDKLB]e6gD[MA]`0
00=6g@03A]h0000000D0000DA]i6gDKN0016oT;MA_i2gDKn@]d004;MA_i2gDKn@]e6oT;M0012o@=2
oP03@_d000000092oP03A_m2oP0000H00005@_i77T;nAah00002Aah02T/NAai77TLNBah004/NAai;
7TLN1@0000M;7DlNBai?7T/MCai;7P0200000dlnCad0000300002TlNBad004lMDci?7E<nCaeC?TlM
0P0000=C?TlM00000`0000YC?TlM001C7ELmDaeC?E<MEceC7@<0000;DaeG7E<LEaeC7ELMDaaG7@00
EaeC700200002ULMDaaG7E<LEad005LMDaaG7E<L0P0000]G7E<L001C75LMDaaG7E<LEaeC7000009G
70800008DaaG7E<LEaeC7000DaaG7@9G700=Da`00000EaeC7000E_aG75;lEaeFo5LLD_`00`0000aB
o5LLE_aG75;lEaaFo000D_]G75KlEa`2000ROol00`00Oomoo`0YOol00`00Oomoo`09Ool0011oo`03
001oogoo00Yoo`03001oogoo08Aoo`@0000>C]aBo4kL001>g4klC]a>o4kLC_a>g4kl001>g@=>g0@0
000:C]e:g4kMB]a>gD[LC]d004[MB]`3B]d01T[L001:gD[MA]e:g@L00096g@03B]e6g@0000I6g@07
0016gTKMA]i2gDKNA]d00P0000I2oT;N@_i2gT;n0004@_h70002A_h00d;nA_h00007A_h20004Aah6
0004Bah00`00Cai;7P02Bah014lNBai;7T/N0`000TlN00Q?7DlNCai?7TlM001?7E<N0dlM00=C7TlM
00000P001e<M00<005<MDad010000U<M00@005<MDaeG7@=C7@03EaeC7@000080000:DaeG7E<MEaeC
7ELMDad005LLEad2000025<LEaeC7ELMDa`005LLEad3Ea`01ELM00000000Ead00eLL00EG7ELLEaaG
7000009G708000EG7003001G75LL009G7080009G7003001G75LL00EG7003001G75Kl008002Eoo`03
001oogoo02Qoo`03001oogoo00Uoo`002goo1@003Woo0P00QGoo00l005;lC]aBoDkLD_a>g000C]a>
oDkLD_e>g4kmC]`01@00015>g4kmB]`004[LC]e:g4kMB]a>gD[LC]d004[MB]a>gD[L00H000=:g@0E
A]`004KMB]e6gD[MA]e:gDKM0016gDKNA]e6gTKMA]h004Kn@]e6oT;M00d0000<@_e6oT;mA_h004Kn
@_e6oT;nA_i2oDKn0P0000A2oTLN@_i77PL00006Bai6oD/N001;7TLM0d/N00I77D/N000004/MCah4
00003T/MCah004lNCae?7T/MCai?7DlNBad004lMDch400002TlMDah005<nCaeC?TlMDci?7E<n0`00
1e<M00@005LMDaeG7@@0000:DaaG7@00EaeC75LMDaaG7E<LEad300002ULMDaaG7E<LEaeC75LM001G
7E<L100000]G7E<L001C75LMDaaG7E<LEaeC75LM00<0000:EaeC75LMDaaG7E<LEad005LME_`20000
35LMD_aG75;lEad005LLD_aG75KlEaaBo0<002Qoo`03001oogoo02Moo`03001oogoo00Uoo`002goo
00<007ooOol04Woo00<007ooOol0Pgoo00X005;lC]aBo4kLD_a>g000C]a>o0@00004C]a>o000C]d3
C]`02TkMC]`004[LC]e:g4kMB]a>gD[L1@000T[M00=:g000B]d01T[M00<004KMB]d00dKM00=:g@00
A]d00dKM1`0000e6gDKmA]e6oP00A_i6oDKnA_e6oP00A_i2oP03A_h01D;nA_h00000@_h00dKn1`00
14Kn00D004LNAai77T/N00977P8000A;7PD0009;7P05Cai;7T/NBai?7P020002Cah00dlMCah00004
00001E<NCae?7DlMDah00TlM00<005<MDad010000U<M00<005<MDad01E<M10001e<M00<005LMDad0
10000U<M00P005<LEaeC7ELMDaaG7E<M0`0000MG75LMDaaG7ELLEaeC700200000eLMEa`000030002
Ea`00`00EaaG7005Ea`30007Ea`00`00EaaG7004000[Ool00`00Oomoo`0XOol00`00Oomoo`08Ool0
00]oo`03001oogoo01=oo`03001oogoo08=oo`05001Bo4kLD_e>g00400004DkmC]aBoDkLC_e>g5;m
001>oD[LC_e>g4kmB]`004[LC]d0100000Y:g4kM001>gD[LC]e:g4kMB]`0009:g@0:A]a:gD[MB]e6
g000A]e:gDKMB]d600004TKMB_i6gD[m0016oTKMA_i6gDKnA]e6oP00A_i2gDKn@]e6oP800004@_e6
oT;mA_h700004DKnA_e:oTKm0016oD/NA_i77TKmBai6oP00A_e;7TKnBah01`0000e;7T/MBai;7@00
Bae?7T/MCai;7DlNBae?7P05000034lNCae?7T/M001?7E<NCaeC7TlMDai?7@<00007CaeC7TlMDai?
7E<NCad00P000U<M0`000U<M00H005LMDaeC7E<LEad2Dad03U<L00000000DaaG7E<LEaeC75LMDa`0
05<LEad400002e<LEad005LMDaaG7E<LEaeC75LMDa`00`0000YC75LMDaaG7E<LEaeC7000DaaG7@@0
000:DaaG7@00EaeBo5LLD_aG7E;lEa`3000`Ool00`00Oomoo`0WOol00`00Oomoo`08Ool000]oo`03
001oogoo01Aoo`03001oogoo08=oo`@0000>C]aBo4kL001>g4klC]a>o4kLC_a>g4kl001>g@=>g0@0
000:C]e:g4kMC]a>gD[LC]d004[MB]`3B]d00d[L001:g@03B]d70003B]d01000A]e6gD[M0dKM00i:
g@00A_e6gDKnA]e6oDKMA_h004KnA_e6oTKm1P0000E6oTKmA_i6oP0000M6oP8000A6oPH000A;7P03
001;7T/N00E;7P80009;7P@0000=Cai;7@00Cae?7TlMCai?7DlNCad004lMDah010000TlM00<005<M
Cad00e<M00=?7E<MDad00`001U<M0P000U<M10000U<M00<005LMDad00U<M00=G7E<MDad00`000U<M
00EG7E<LDaeC7ELM00800003EaaG7@0000<00005DaaG7@00EaeC7002Ea`00eLMDaaG70030002Ea`0
1ULMDaaG75LLEad000AG708003Aoo`03001oogoo02Ioo`03001oogoo00Qoo`002goo1P004Woo00<0
07ooOol0Pgoo00l005;lC]aBoDkLD_a>g000C]a>oDkLD_e>g4kmC]`01@00015>g4kmB]`004[LC]e:
g4kMB]a>gD[LC]d004kMB]a>gD[L00H0000HB]e:g4[MB]`004KMB_e6gD[mA]e:o@00B_i6gD[mA]e:
oTKMB_d004KnA]e6oTKM1`0000]6oD[nA_d004KmB_i6oDKnA_e:oTKm00800004B_i6oDKnA_d70000
2dKmBai6o@00A_e;7TKmBai6oD/NA_d00P0000A;7T/MBai;7@D0000<Bae?7T/MCai;7DlNBad004lM
Cai;7DlN1@0000MC7TlMDai?7E<NCaeC7P0200000dlMDah0000300000dlMDad00003Dad014lMDaeC
7E<M0`0000=C7E<LDad00U<M00MC75<M001G7E<LEaeC700200002eLMDa`005<LEaeC75LMDaaG7E<L
Ead00`0000aG7E<LEaeC75LMDaaG7@00EaeC75LMDa`200003ELMDa`005<LEaeC75LMDaaG7E<L001B
o5LM008003Moo`03001oogoo02Eoo`03001oogoo00Qoo`0097oo0P00Q7oo00X005;lC]a>o4kLD_a>
g000C]a>o0@00004C]a>o000C]d3C]`024kMC]`00000C]e:g4kMC]`7000014[MC]e:g0001d[M00@0
04[MB]e6g@=:g@050016gDKMB]e6g@0700001DKMA_e6gD[m00000TKm00A6oTKmA_e6o@8000=6oP03
A_d0000000D0000;A_e6oTKnB_h004[nA_i:oTKnB_i6oP020004Bah7000034/MBai;7T/N001?7T/N
Cai;7DlNBai?7PD0009?7@05Cai?7@00Cae?7P03Cad00dlNCae?7@030003Dad01DlMDaeC7E<M0000
0U<M10000U<M00<005<MDad01E<M00<005<MEad00P001E<M00H005<LDaeC7ELMDa`200003E<MDa`0
05<LEaeC75LMDaaG7E<L001G75LM00800007DaaG7E<LEaeC7000Da`00ULL00=G7E<LEa`00`00>Goo
00<007ooOol09Goo00<007ooOol027oo000VOol00`00Oomoo`22Ool01@00D_a>g5;mC]`0100000iB
oDkLD_e>g5;mC]aBo@00C_e:g4kmC]a>oD[L1@0001Q:g4kmB]a>o@00C_e:g4kmB]a>oD[L001:g4[M
B]a:gD[LB]e:g000A]e:oDKMB_d600004DKMB_e6gD[m001:oTKMB_i6gD[nA]e:oP00B_i6oDKnA_d0
1`000156oD[nA_e:oP00B_i6oD[nA_e:oTKmB_h004/NA_e;7TKm00L0000?B_e;7T[mBah004lNBae?
7T/MCai;7DlN001?7T/M00@0000:Cai;7@00Cae?7T/MCai?7DlNBad200000e<NCad0000300002U<N
Cad004lMDai?7E<MCaeC7TlM0`0000Q?7E<MCaeC7DlMDae?7@000U<M00AC75<MDaeC7@<0000;DaeC
75LMDaaC7E<LEaeC7000DaaG7@02000035<LEaeC75LMDa`005<LEaeC75LMDaaG7@<0000:EaeC75LM
DaaG7E<LEad005LMDa`4000mOol00`00Oomoo`0TOol00`00Oomoo`08Ool002Moo`03001oogoo089o
o`@00003C]aBo4kL0080000:C_a>g4klC]a>o4kLC_`004kMC]`30002C]`02`00C]e:g4kMC]a>gD[L
C]d004kMB]`00T[M00=>gD[L000014[M1`000d[M00P004[mB]e:oDKMB_e:gD[m0P0000A6gD[mA]e6
o@H0000=A_e:oDKmB_d004[nA_e:oTKmB_i6oD[n00000TKn00A:oTKmA_i6oPD0000=B_e:oT[mB_h0
04/NB_i;7T[mBai:oT/N00000d/N00=;7@0000000`0000M?7DlNBae?7TlMCai;7@02000014lNCae?
7DlM1@001dlM00<004lMDad0100000=?7E<M00001e<M00<005<MDad010000U<M00<005<MDad01U<M
0`000e<M00MC75<MDaeC7@00EaeC700400002ULMDa`005<LEaeC75LMDaaG7E<L0`00@Woo00<007oo
Ool08goo00<007ooOol027oo000XOol00`00Oomoo`22Ool02000D_a>g5;mC]aBo4kLD_d2000014kL
D_e>g5;m100001=:g4kmC]a>oD[LC_d004kmB]a>oD[LC_e:g4km001>oD[LC_e:g00600002dkmB]a>
oD[L001:gD[mA]a:oD[MB_d00P0000A6gD[mA]e:o@L0000FB_i6gD[m001:oTKmB_i6oD[nA_e:oP00
B_i6oD[nA_e:oTKmB_h004[nA_d300004DKmB_h004/NB_e;7TKmBai:oD/N001;7T[mBai:oD/NB_d0
1@0000e;7DlNBae?7P00Cai;7DlNBae?7T/MCai;7@05000034lMCai?7DlN001C7TlMDai?7E<NCaeC
7P<0000>Dai?7E<MCaeC7TlMDad005<MCaeC7DlMDae?7@<0009C7@05DaaC7E<MDaeC700200000e<M
Da`0000300002ULMDa`005<LEaeC75LMDaaG7E<L0`0000YC75LMDaaG7E<LEaeC7000DaaG7@@004Io
o`03001oogoo02=oo`03001oogoo00Moo`00:Goo0P00Pgoo00P005;lC]a>o4kLD_a>g4kl1@0000E>
o4kLC_`004kM00=>g008C]e>g4kL001>gD[LC]e>g0L00004B]e>gD[L0007B]d20004B]d600001D[m
B]e:oD[M00001T[m00d004[mA_e:oDKmB_e6oD[m001:oTKmB_i6o@0500000d[mB_i:o@02B_d034[n
001:oT[mB_i:oD[nB_e:oP00Bai:oP<0000:B_e;7P00Bai;7DlNBae;7T/MCah200000dlMCah00003
0002Cad00`00Cai?7@02Cad014lNCae?7@000TlM10000TlM00T004lMDae?7E<MCaeC7DlM00000U<M
10000U<M00<005<MDad01U<M0`001e<M00<005<LDad010000U<M00D005<MDaeG7E<L009C7@04Ead0
0000001:Ool00`00Oomoo`0SOol00`00Oomoo`07Ool002]oo`03001oogoo085oo`03001Bo4kL00@0
000@D_e>g000C]aBoDkLD_e>g5;m001>oD[LC_e>g4kmB]`500004d[LC_e:g4km001>oD[LC_e:g4km
B]`004[LC_e:g4kmB]a>oD[L00D0000GB]e:oD[L001:gD[mA]e:oD[MB_e6g@00A]e:oDKMB_i6gD[m
001:oTKmB_i6o@0700004DKmB_i6oD[n001:oTKmB_i6oD[nA_e:oP00Bai:oD/NA_d01@0000I:oDlN
B_e?7T[mCah2000014/MCai;7DlN1@0000i?7T/MCai;7DlNBae?7P00Cai?7DlNCae?7TlM0`0000a?
7E<NCaeC7TlMDai?7@00CaeC7TlMDad500001e<MCaeC7DlMDae?7E<M0080009C7@@0000:CaaC7@00
DaeC75LMDaaC7E<LEad300002ULMDaaC7E<LEaeC75<M001G7E<L1000CWoo00<007ooOol08Woo00<0
07ooOol01goo000/Ool00`00Oomoo`21Ool200004DkLC_a>g5;lC]a>o4kL001>g4klC]a>o4kLC_`0
04kMC]`00`000TkL010004kMC]a>gDkLC]e>g4kM001>gD[LC]e:gDkMB]`0009:g@@0000BB]a:g@00
B_e:gD[mB]e:oD[M001:gD[mB]e:oD[MB_e:g@0014[m1P0014[m00@004[mB_e:oP=:o@06B_h004[m
B_e:oT[m1`000d[m00U:oP00Bai:oD/NB_e;7T[mBah01@0000M?7D/MCai;7@00Cae?7P03Cad01DlN
Cad004lMCah010000TlM00<004lMCad01DlM1@0000EC7DlMDae?7@0000QC7@<000MC7@03001C7E<M
00@0009C7@03001C75<M009C7@03DaaC7E<M00<005=oo`03001oogoo025oo`03001oogoo00Moo`00
;Goo00<007ooOol0PGoo00h005;lC]aBoDkLD_a>g5;mC]`004kLD_e>g5;m100001=>g4kmC]a>oDkL
C_d004kmB]a>oD[LC_e:g4km001>oD[LC_e:g00400004dkmB]a>oD[LC_e:g4km001:oD[LC_e:gD[m
B]`004[MB_e6gD[m00L0000;B_e:gD[m001:oT[mB_i6oD[nB_e:oP02000014KmB_i6oD[n1P0000m:
oD[nB_e:oP00Cai:oD/NB_e?7T[mBah004lNB_d0100000m?7T[m001:oDlNB_e?7T[mCai:o@00Bae?
7T/MCah01@0000M?7TlMDai?7DlNCaeC7P0200000dlMDah0000200002U<NCad004lMDai?7E<MCaeC
7TlM0P0000=C7DlM00000`0000=C7DlM00000U<M00E?75<MDaeC7DlL00<0000:DaaC7E<LDaeC75<M
Da`005<LEad4001FOol00`00Oomoo`0QOol00`00Oomoo`07Ool002ioo`80089oo`08001Bo4kLC_a>
g5;lC]a>o0D00005C_a>g4kl001>g@03C]`024kMC]a>g000C]e>g4kMC]`700001dkLC]e:g000B]e>
gD[L009:g@07C]e:g000B]e:oD[MB_d01`0014[m00<004[mB_d014[m0P0014[m1`000d[m00@004[m
B_e:oP=:o@05B_h00000B_e:oP02B_d400003T[mCai:oD/MB_e?7T[m001;7DlNBae?7D/MCah50004
Cad00`00Cae?7@06Cad30002Cad035<MCae?7DlM001?7E<MCaeC7DlMDae?7@<000MC7@03001C7E<M
00@0009C7@03001C7E<M00EC7@<005]oo`03001oogoo021oo`03001oogoo00Moo`00<7oo00<007oo
Ool0P7oo00<005;lC]`01000011BoDkL001>g5;mC]aBoDkLD_d004kmC]a>oDkLC_e>g0D0000;C]a>
oD[LC_d004kmB]a>oD[LC_e:g002000014kmB]a>oD[L1P00015>oD[LC_e:g000B]e:oD[LC_e:gD[m
B]`004[MB_e:gD[m00L0000;C_i:oD[mB_d004[mB_i:oD[nB_e:oP02000014[mB_i:oD[n1`0000m>
oT[mC_h004lNB_e?7T[mCai:oDlNB_d004[mCah00`0000Y?7T[m001?7DlNBae?7TlMCai;7@800003
Cai?7@0000<0000=Dai?7@00CaeC7TlMDae?7E<NCad004lMDah0100000Y?7E<M001C7DlMDae?7E<M
CaeC7@<00003Dae?75<M009C7@05CaaC7@00DaeC7004001OOol00`00Oomoo`0OOol00`00Oomoo`07
Ool0035oo`03001oogoo081oo`80000AC]a>o4kLD_a>g4klC]`004kLC_a>g4klC]a>o000C]e>g003
000014kLC_`004kM0dkL00Y>gDkLC]`004kMB]a>gDkLC]e:g0D0000<B]e>oD[L001:gDkmB]e:oD[M
C_e:g@001T[m1@0014[m00<004[mB_d01D[m00<004[mB_d00T[m1`0014[m00<004[mB_d014[m0P00
00A:oDlNB_e;7@D000I?7@8000A?7@D000M?7@05001?7DlMCaeC7@05000025<MCaeC7DlMDae?7E<M
0002Dad40002Dad00`00DaeC7@05Dad3001TOol00`00Oomoo`0NOol00`00Oomoo`07Ool0039oo`03
001oogoo081oo`0=001Bo4kLD_e>g5;lC]aBo@00D_e>g5;mC]`01@00015>g4kmC]a>oDkLC_d004km
B]a>oDkLC_e:g4km001>oD[L00<0000DB]a>o@00C_e:g4kmB]a>oD[L001:g4kmB]a>oD[LC_e:g000
B]e:o@<0000;C_e:g000B_e>oD[mC_e:oDkmB_d00003B_d00dknB_e:o@0500004DknB_e>oD[m001:
oDknB_e>oT[mC_i:o@00B_e>oT[mC_h01`0000a?7T[mCai:o@00B_e?7T[mCai:oDlNB_d500001Dkm
Cae>oDlN00000TlM00EC7TlMCae?7E<N00D0000<Dae?7E<NCad004lMDae?7E<MCaeC7DlM0`0000Q?
7E<MCaaC7DlMDae?70000U<M1000Igoo00<007ooOol07goo00<007ooOol01Woo000cOol20021Ool0
1`00D_a>g4klC]aBo4kL00D0000>C]a>o4kLC_`004kmC]a>o4kLC_e>g4kl001>g@=>g0D0000BC]a>
oDkLC_e>g4km001>oD[LC_e:gDkmB]`004[MC_e:gD[m1@0000M>oD[mB_e:oDkmB_d00007B_d00`00
B_e:o@0300000dkmB_d00007B_d00`00B_e:o@04B_d500001DkmB_e>oD[m00000Tkm00I:oDkmC_e>
oD[m0002Cad400000dkmCad00007Cad00`00Cae?7@040002Cad01@00Cae?7DlMDad00dlM00<004lM
Dad0100000=?7E<M00001e<M0`00K7oo00<007ooOol07Woo00<007ooOol01Woo000eOol00`00Oomo
o`1oOol00`00D_a>g00300002TkLD_d005;mC]aBoDkLD_e>g5;m0P0000A>g4kmC]a>o@H0000AC]a>
oD[LC_d004kmB]a>oD[LC_e:g4km001>oD[LC_e:g00600004DkmB]a>oD[L001:gDkmB]a>oD[MC_e:
g000B_e>oD[mC_d01@00011>oD[mC_e:oDkmB_d004[mC_e:oDknB_e>o@00C_i:o@@0000?C_e:o@00
B_e>oD[mC_i:oDkmB_d004[mCai:oDlN00D0000>Cae:oDlNC_e?7D[mCah004lMC_e?7TkmCae>o@<0
000>C_eC7TkmDae>oE<NC_d004lMDai?7E<MCaeC7P<0000:Dae?7E<MCaeC7DlMDad005<MCad4001`
Ool00`00Oomoo`0MOol00`00Oomoo`06Ool003Ioo`03001oogoo07moo`80000>C]a>o4kLD_a>g4kl
001>o4kLC_a>g4klC]a>o0D0000@C_e>g4kl001>oDkLC_a>g4kmC]a>o000C_e>g4kmC]`700002dkM
C_e:g000B]e>oD[MC_e:gDkmB]d00P0000A>oD[mB_e:o@H0009:o@05C_e:o@00B_e>o@03B_d00dkm
B_d00004B_d400003T[mC_e:oDkmB_e>oD[m001:oDkmB_e>oD[mC_d50004C_d02@00C_e?7DkmCae>
oDlMC_d00002Cad40002Cad00`00Cae?7@05Cad00`00Dae?7@040002Cad02000CaeC7DlMDae?7E<M
Cad3001eOol00`00Oomoo`0LOol00`00Oomoo`06Ool003Moo`03001oogoo07moo`0;001Bo4kLD_e>
g5;lC]aBo@00D_e>g004000045;mC]`004kLD_e>g4kmC]aBo@00C_e:g4kmC]a>oD[L1@0000]:g4km
B]a>o@00C_e:g4kmB]a>oD[L00800004C_e:g4kmB]`7000044[LC_e:g000B_e>oD[lC_e:oDkmB_`0
04[mC_e:oDkm1`0000m>oD[mC_d004knB_e>oD[mC_i:oDkmB_d004[mC_d00`0000Y>oD[m001:oDlM
B_e?7T[mCae:o@800004Cae:oDlNC_d400001dlMC_eC7TkmCae>oE<N00800004C_eC7TkmDad40000
2TlMDae?7E<MCaeC7DlM001?7E<M1000N7oo00<007ooOol077oo00<007ooOol01Woo000hOol20020
Ool01`00D_a>g4klC]aBo4kL00<0000AC]a>o4kLC_a>g4klC]`004kLC_a>g4kmC]a>o000C_e>g003
00004DkLC_`004kmC]a>oDkLC_e>g4km001>oD[LC_e>gDkmB]`01@000Tkm00U:o4km001>oD[mC_e:
oDkmB_d00P0000A>oD[mB_e:o@H0000;C_e:oDkmB_d004[mC_e:oDkmB_e>o@02000014[mC_e:oDkm
1@0000=>oD[mC_d00Tkm00=:o@00000014km1`0000A>oDlMC_d000Q?7@D000=?7@03001C7DlM009?
7@03Dae?7DlM00<007eoo`03001oogoo01]oo`03001oogoo00Ioo`00>Woo00<007ooOol0OWoo00<0
05;lC]`00`00011>g5;m001BoDkLD_e>g5;mC]aBoDkL001>g5;mC]a>o@@0000AC]a>oDkLC_e>g4km
001>oD[LC_e:g4kmB]a>o@00C_e:g00300004D[LC_d004kmB]a>oD[LC_e:g4km001>oD[LC_e:g4km
B]`01@00011:oDkmB_`004[mC_e:o4kmB_e>oD[l001:oDkmB_e>o@L0000<C_e:oDkmB_d004[mC_e:
oDknB_e>oD[m1@0000]>oDlMB_e?7@00Cae>oDlNC_e?7Dkm00800003Cae>o@0000<00009Dae>o@00
C_eC7DkmDae>oE<M00800003CaeC7@000080085oo`03001oogoo01Yoo`03001oogoo00Ioo`00>goo
00<007ooOol0OWoo0P0000i>g4klC]aBo4kLC_`004klC]a>o4kLC_a>g4kl1@00011>o4kLC_`004km
C]a>o4kLC_e>g4kl001>oDkLC_e>g0D00009C]a>oDkMC_e>g4km001>oD[l00=>o@04B_`004[mC_d4
00001D[mC_d004kmB_d00dkm00Q:o@00B_e>oD[mC_e:oDkm1@000dkm00E:o@00C_e>oD[m00=>o@04
B_d004kmC_d40002C_d00`00C_e>o@05C_d01@00Cae>oDlMC_d01@0000Q>oDlMC_e?7DkmCae>o@00
14lM1@00Q7oo00<007ooOol06goo00<007ooOol01Goo000lOol00`00Oomoo`1nOol02`00D_a>g5;m
C]aBo4kLD_d005;mC]`0100000UBoDkL001>g5;mC]a>oDkLD_d00P0000A>g4kmC]a>o@H0000AC]a>
oD[LC_d004kmB]a>oD[LC_e:g4km001>oD[LC_e:g00400004DkmB_a>oD[lC_e:o4km001>oD[lC_e:
oDkmB_`004[mC_d00`0000Y>oD[l001:oDkmB_e>oD[mC_e:o@800004C_e:oDkmB_d400003TkmB_e>
oD[mC_e:oDkm001?7D[mCae>oDlMB_d5000034kmCae>oE<M001?7DkmDae>oDlMC_eC7@D008Yoo`03
001oogoo01Yoo`03001oogoo00Eoo`00?Goo00<007ooOol0OWoo0P0000A>g4klC]aBo0@0000>C]a>
o4kLC_a>g4klC]`004kLC_a>g4klC]a>o0D0000@C_e>g4kl001>oDkLC_e>g4kmC]a>o@00C_e>g4km
C]d70002C_d01Dkl001>oDkmB_d00dkm00I:o@00C_e>oD[mC_d500000dkmB_e>o@02C_d01D[m001>
oDkmB_d00dkm00=:o@0000000`000dkm00<004kmC_d01Dkm00<004kmC_d010000Tkm00<004kmC_d0
1Dkm00<004lMC_d01000T7oo00<007ooOol06Goo00<007ooOol01Goo000nOol20020Ool400003U;l
C]aBo@00D_e>g5;mC]aBoDkLD_d004kmC]`4000045;mC]`004kLD_e>g4kmC]aBo@00C_e:g4kmC]a>
oD[L1@0000]>g4kmB]a>o@00C_e:g4kmB]a>oD[L00800004C_e:o4kmB_`600003dkmB_a>oD[l001:
oDkmB_a>oD[mC_e:o000B_e>o@0400002D[lC_d004kmB_e>oD[mC_e:o@02000014kmB_e>oD[m1000
00i?7DkmCae>oDlMC_e?7@00Cae>oE<MC_e?7Dkm0`00UGoo00<007ooOol067oo00<007ooOol01Goo
0010Ool00`00Oomoo`1nOol01`00C]a>o4kLD_a>g4kl00800004C]a>o4kLC_`400004DkLC_a>g4kl
C]a>o4kL001>g4klC]a>oDkLC_`004kmC]`00`0000e>o4km001>oDklC_e>o4kmC_a>o@00C_e>o003
C_d00dkl000000030002C_d00dkl001>o@06C_d01@00C_e>oD[mC_d01@001dkm00<004kmC_d014km
1@000dkm00<004kmC_d01Dkm00<004kmC_d01000V7oo00<007ooOol067oo00<007ooOol01Goo0011
Ool00`00Oomoo`1nOol01`00C]aBoDkLD_a>g5;m00D0000AD_e>g5;m001BoDkLD_e>g5;mC]aBoDkL
001>g5;mC]a>o@04000044kLC_e>g4kmC]a>o@00C_e:g4kmC]a>oD[L001:g4km100000U:g4km001>
oD[lC_e:o4kmB_`00P0000A>oD[lC_e:o0H0000?C_e:o4kmB_`004[mC_e:o4kmB_e>oD[l001:oDkm
00@00005B_a>o@00C_e:o003C_d01d[l000004lMC_e?7Dkm00@009eoo`03001oogoo01Moo`03001o
ogoo00Eoo`00@Woo00<007ooOol0OWoo00<004kLC_`00`00015Bo4kL001>g4klC]aBo4kLC_`004kl
C]a>o4kLC_a>g4kl00D0000@C_e>g4kl001>oDklC_e>o4kmC_a>o@00C_e>o4kmC_`400000dkmC_a>
o@02C_d01DklC_d004kmC_`00dkm00=>o00000000`000dkm00<004kmC_d01Dkm0P0014km10001dkm
00<004kmC_d00Tkm1`00XWoo00<007ooOol05Woo00<007ooOol01Goo0013Ool2001oOol2000045;m
C]aBo4kLD_e>g000C]aBoDkLD_e>g5;m001BoDkL100000UBoDkL001>g5;mC]a>oDkLD_d00P0000A>
g4kmC]a>o@H0000?C]a>oDkL001>g4kmB]a>oDkLC_e:g4km001>oD[l00<00009B_a>o@00C_e:o4km
C_a>oD[l00800004C_e:o4kmB_`7000014klC_e:o0000Tkm00E:o4kmC_e>oD[l00D00:Yoo`03001o
ogoo01Eoo`03001oogoo00Eoo`00AGoo00<007ooOol0OGoo00d004kLD_a>g5;lC]aBo4kL001>g4kl
C]aBo00400003TkLC_a>g4klC]a>o4kL001>g4klC]a>oDkLC_`500002TkmC_a>o000C_e>o4kmC_a>
oDkl0P0000A>oDklC_e>o@D00007C_a>oDkmC_e>o4km00001Tkm1@0014km00<004kmC_d014km0P00
0Tkm0`00[goo00<007ooOol05Woo00<007ooOol017oo0016Ool00`00Oomoo`1mOol01`00C]aBoDkL
D_a>g5;m00D0000>D_e>g5;m001BoDkLD_e>g5;mC]aBo@00C_e>g0@00009D_e>g000C]aBoDkLC_e>
g5;m00800004C]a>oDkLC_d600003dklC_e>o4km001>oD[lC_e>o4kmB_a>o@00C_e:o00300003dkl
C_d004kmB_a>oDklC_e:o4km001>oD[lC_e>o005002cOol00`00Oomoo`0EOol00`00Oomoo`04Ool0
04Moo`03001oogoo07eoo`03001>g5;l00<00009D_a>g000C]a>o4kLD_a>g4kl00800004C]a>o4kL
C_`40003C_`01DkmC_a>o4kl00000dkl00=>oDklC_`01@0000i>oDklC_d004kmC_a>oDklC_e>o4km
001>oDkl0Tkm1@0000M>o4kmC_e>oDklC_d00006C_d5002iOol00`00Oomoo`0DOol00`00Oomoo`04
Ool004Qoo`8007ioo`80000=D_e>g5;lC]aBoDkL001>g5;mC]aBoDkLD_d01@0000iBoDkLD_d005;m
C]aBoDkLD_e>g5;m001>oDkL1000011BoDkL001>g5;mC]a>oDkLD_d004kmC_a>oDklC_e>o0D0000?
C_a>oDklC_d004kmC_a>oDklC_e>o4km001>oD[l00<00;ioo`03001oogoo01Aoo`03001oogoo00Ao
o`00BWoo00<007ooOol0O7oo00/004kLD_a>g5;lC]aBo4kL001>g4kl00<0009>o003001>o4kl00A>
o08000=>o003C_d00000008000=>o00>C_e>o4klC_`004klC_e>o4kmC_a>o@00C_e>o0<00005C_a>
o@00C_e>o003C_d01DklC_d004kmC_`00Tkm1@00`Woo00<007ooOol04goo00<007ooOol017oo001;
Ool00`00Oomoo`1lOol01@00C]aBoDkLD_`01@0000eBoDkLD_e>g5;mC]`004kLD_e>g5;mC]aBo@05
000045;mC]aBo@00C_e>g5;mC]a>oDkLD_d004kmC]aBoDkL1@0000e>o5;mC_a>oDklD_d004kmC_a>
oDklC_e>o0050038Ool00`00Oomoo`0BOol00`00Oomoo`04Ool004aoo`03001oogoo07aoo`@00005
D_a>o5;lC_`00003C_`01E;lC_a>o4kl00000Tkl0`000Tkl00D004klC_a>o4km009>o08000=>o003
C_d0000000@0000?C_a>oDklC_d004kmC_a>oDklC_e>o4km001>oDkl00<00<ioo`03001oogoo015o
o`03001oogoo00Aoo`00CGoo0P00OGoo00d004kLD_e>g5;lC]aBoDkL001>g5;mC]aBo@0500003E;m
C]aBoDkLD_e>g000C]aBoDkLD_e>g5;m00D0000@D_e>g5;m001>oDklD_e>o4kmC_aBo@00C_e>o5;m
C_`5003AOol00`00Oomoo`0BOol00`00Oomoo`03Ool004moo`03001oogoo07]oo`07001>o5;lC_aB
o4klD_`01@0000EBo4klC_a>o00000=>o005D_a>o4klC_`00002C_`30002C_`01@00C_a>o4klC_d0
0Tkl0P0000A>o4kmC_a>o@H00=Moo`03001oogoo015oo`03001oogoo00=oo`00D7oo00<007ooOol0
Ngoo00<004kLD_d00`0000mBoDkL001>g5;mC]aBoDkLD_e>g000C]aBoDkLD_d01@0000eBoDkLD_e>
g5;mC]`004kLD_e>g5;mC]aBo@05003NOol00`00Oomoo`0@Ool00`00Oomoo`03Ool0055oo`03001o
ogoo07]oo`800007D_a>o5;lC_aBo4kl00000dkl00=Bo4klC_`01@0000EBo4klC_a>o00000=>o005
C_e>o4klC_`00002C_`3003TOol00`00Oomoo`0?Ool00`00Oomoo`03Ool0059oo`03001oogoo07]o
o`0;001>g5;mC]aBo4kLD_e>g000C]aBo@0300003e;mC]`004kLD_e>g5;mC]aBoDkL001>g5;mC]aB
o@05003WOol00`00Oomoo`0?Ool00`00Oomoo`03Ool005=oo`8007aoo`800004D_a>o5;lC_`40000
1e;lC_aBo4klD_a>o00000=>o003D_a>o4kl00D00>eoo`03001oogoo00ioo`03001oogoo00=oo`00
EGoo00<007ooOol0Ngoo100000i>g5;mC]`004kLD_e>g5;mC]aBoDkL001>g5;m0`00lgoo00<007oo
Ool03Goo00<007ooOol00goo001FOol00`00Oomoo`1kOol01`00D_a>o5;lC_aBo4kl00800004D_a>
o5;lC_`4003fOol00`00Oomoo`0=Ool00`00Oomoo`03Ool005Moo`03001oogoo07]oo`07001BoDkL
D_a>g5;mC]`01@00ngoo00<007ooOol03Goo00<007ooOol00Woo001HOol2001lOol00`00D_a>o003
003oOol2Ool00`00Oomoo`0<Ool00`00Oomoo`02Ool005Yoo`03001oogoo07Yoo`800?moo`Ioo`03
001oogoo00]oo`03001oogoo009oo`00Fgoo00<007ooOol0NGoo00<007ooOol0ogoo1Goo00<007oo
Ool02goo00<007ooOol00Woo001LOol00`00Oomoo`1hOol00`00Oomoo`3oOol6Ool00`00Oomoo`0:
Ool00`00Oomoo`02Ool005eoo`8007Qoo`03001oogoo0?moo`Moo`03001oogoo00Uoo`03001oogoo
009oo`00Ggoo00<007ooOol0MGoo00<007ooOol0ogoo1goo00<007ooOol02Goo00<007ooOol00Woo
001POol00`00Oomoo`1dOol00`00Oomoo`3oOol8Ool00`00Oomoo`08Ool00`00Oomoo`02Ool0065o
o`03001oogoo07=oo`03001oogoo0?moo`Uoo`03001oogoo00Qoo`03001oogoo005oo`00HWoo0P00
Lgoo00<007ooOol0ogoo2Woo00<007ooOol01goo00<007ooOol00Goo001TOol00`00Oomoo`1`Ool0
0`00Oomoo`3oOol:Ool00`00Oomoo`07Ool00`00Oomoo`01Ool006Eoo`03001oogoo06moo`03001o
ogoo0?moo`]oo`03001oogoo00Ioo`03001oogoo005oo`00IWoo00<007ooOol0KWoo00<007ooOol0
ogoo37oo00<007ooOol01Goo00<007ooOol00Goo001WOol2001]Ool00`00Oomoo`3oOol>Ool00`00
Oomoo`04Ool00`00Oomoo`01Ool006Uoo`03001oogoo06Yoo`03001oogoo0?moo`ioo`03001oogoo
00Aoo`03001oogoo005oo`00JWoo00<007ooOol0JGoo00<007ooOol0ogoo3goo00<007ooOol017oo
0@000Goo0Goo001[Ool00`00Oomoo`1XOol00`00Oomoo`3oOol@Ool00`00Oomoo`03Ool10001Ool1
Ool006aoo`03001oogoo06Moo`03001oogoo0?mooa1oo`03001oogoo00=oo`40005oo`5oo`00KGoo
0P00Igoo00<007ooOol0ogoo4Goo00<007ooOol00Woo0@000Goo0Goo001_Ool00`00Oomoo`1TOol0
0`00Oomoo`3oOolBOol01@00Oomoogoo00000Woo001`Ool00`00Oomoo`1SOol00`00Oomoo`3oOolC
Ool01000Oomoo`000Woo001aOol00`00Oomoo`1ROol00`00Oomoo`3oOolCOol01000Oomoo`000Woo
001bOol2001ROol00`00Oomoo`3oOolDOol00`00Ool00002Ool007Aoo`03001oogoo05moo`03001o
ogoo0?mooaEoo`03001oo`00005oo`00MGoo00<007ooOol0GWoo00<007ooOol0ogoo5Woo0P000Goo
001fOol00`00Oomoo`1MOol00`00Oomoo`3oOolFOol20001Ool007Moo`8005eoo`03001oogoo0?mo
oaIoo`80005oo`00NGoo00<007ooOol0FWoo00<007ooOol0ogoo4Woo10000goo001jOol00`00Oomo
o`1IOol00`00Oomoo`3oOol>Ool40007Ool007]oo`03001oogoo05Qoo`03001oogoo0?moo`Yoo`@0
00]oo`00O7oo0P00F7oo00<007ooOol0ogoo1Woo10003goo001nOol00`00Oomoo`1EOol00`00Oomo
o`3oOol2Ool4000COol007moo`03001oogoo05Aoo`03001oogoo0?ioo`<001Moo`00P7oo00<007oo
Ool0Dgoo00<007ooOol0nWoo10006Woo0021Ool00`00Oomoo`1BOol00`00Oomoo`3fOol4000NOol0
089oo`80059oo`03001oogoo0?9oo`@0029oo`00Q7oo00<007ooOol0Cgoo00<007ooOol0kWoo1000
9Woo0025Ool00`00Oomoo`1>Ool00`00Oomoo`3ZOol4000ZOol008Ioo`03001oogoo04aoo`03001o
ogoo0>Qoo`<002ioo`00Qgoo0P00C7oo00<007ooOol0i7oo1000<Goo0029Ool00`00Oomoo`19Ool0
0`00Oomoo`3POol4000eOol008Yoo`03001oogoo04Qoo`03001oogoo0=aoo`@003Uoo`00Rgoo00<0
07ooOol0Agoo00<007ooOol0f7oo1000?Goo002<Ool20017Ool00`00Oomoo`3DOol40011Ool008io
o`03001oogoo04Aoo`03001oogoo0=5oo`<004Eoo`00Sgoo00<007ooOol0@goo00<007ooOol0cGoo
1000B7oo002@Ool00`00Oomoo`12Ool00`00Oomoo`39Ool4001<Ool0095oo`80049oo`03001oogoo
0<Eoo`@0051oo`00Tgoo00<007ooOol0?goo00<007ooOol0`Goo1000E7oo002DOol00`00Oomoo`0n
Ool00`00Oomoo`2mOol4001HOol009Eoo`03001oogoo03eoo`03001oogoo0;Uoo`@005aoo`00UWoo
0P00?Goo00<007ooOol0]Woo0`00H7oo002HOol00`00Oomoo`0jOol00`00Oomoo`2bOol4001SOol0
09Uoo`03001oogoo03Uoo`03001oogoo0:ioo`@006Moo`00VWoo00<007ooOol0>7oo00<007ooOol0
ZWoo1000Jgoo002KOol00`00Oomoo`0gOol00`00Oomoo`2VOol4001_Ool009aoo`8003Moo`03001o
ogoo0:9oo`@007=oo`00WWoo00<007ooOol0=7oo00<007ooOol0Wgoo0`00Mgoo002OOol00`00Oomo
o`0cOol00`00Oomoo`2KOol4001jOol00:1oo`03001oogoo039oo`03001oogoo09Moo`@007ioo`00
XGoo0P00<Woo00<007ooOol0Tgoo1000PWoo002SOol00`00Oomoo`0_Ool00`00Oomoo`2?Ool40026
Ool00:Aoo`03001oogoo02ioo`03001oogoo08]oo`@008Yoo`00YGoo00<007ooOol0;7oo00<007oo
Ool0RGoo0`00SWoo002VOol2000/Ool00`00Oomoo`25Ool4002AOol00:Qoo`03001oogoo02Uoo`03
001oogoo085oo`@009Eoo`00ZGoo00<007ooOol0:7oo00<007ooOol0OGoo1000VGoo002ZOol00`00
Oomoo`0WOol00`00Oomoo`1iOol4002MOol00:]oo`8002Moo`03001oogoo07Eoo`@00:5oo`00[Goo
00<007ooOol097oo00<007ooOol0LWoo0`00YGoo002^Ool00`00Oomoo`0SOol00`00Oomoo`1^Ool4
002XOol00:moo`03001oogoo029oo`03001oogoo06Yoo`@00:aoo`00/7oo00<007ooOol08Goo00<0
07ooOol0IWoo1000/7oo002aOol2000QOol00`00Oomoo`1ROol4002dOol00;=oo`03001oogoo01io
o`03001oogoo05ioo`@00;Qoo`00]7oo00<007ooOol07Goo00<007ooOol0Fgoo0`00_7oo002eOol0
0`00Oomoo`0LOol00`00Oomoo`1GOol4002oOol00;Ioo`8001aoo`03001oogoo05=oo`@00<=oo`00
^7oo00<007ooOol06Goo00<007ooOol0Cgoo1000agoo002iOol00`00Oomoo`0HOol00`00Oomoo`1;
Ool4003;Ool00;Yoo`03001oogoo01Moo`03001oogoo04Moo`@00<moo`00^goo0P005goo00<007oo
Ool0A7oo0`00dgoo002mOol00`00Oomoo`0DOol00`00Oomoo`10Ool4003FOol00;ioo`03001oogoo
01=oo`03001oogoo03aoo`@00=Yoo`00_goo00<007ooOol04Woo00<007ooOol0>7oo1000gWoo0030
Ool2000BOol00`00Oomoo`0dOol4003ROol00<9oo`03001oogoo00moo`03001oogoo031oo`@00>Io
o`00`goo00<007ooOol03Woo00<007ooOol0;7oo1000jWoo0034Ool00`00Oomoo`0<Ool00`00Oomo
o`0ZOol3003^Ool00<Eoo`8000aoo`03001oogoo02Ioo`@00?5oo`00agoo00<007ooOol02Goo00<0
07ooOol08Woo1000mGoo0038Ool00`00Oomoo`08Ool00`00Oomoo`0NOol4003iOol00<Uoo`03001o
ogoo00Moo`03001oogoo01Yoo`@00?eoo`00bWoo00<007ooOol01Woo00<007ooOol05Woo1000ogoo
0Woo003;Ool20006Ool00`00Oomoo`0COol3003oOol6Ool00<eoo`03001oogoo00=oo`03001oogoo
00moo`@00?moo`Uoo`00cWoo00<007ooOol00Woo00<007ooOol02goo1000ogoo3Goo003?Ool01@00
Oomoogoo00002Goo1000ogoo4Goo003@Ool200000goo001oo`04Ool4003oOolEOol00=9oo`800003
Ool0000000800?mooaUoo`00dgoo0P00ogoo7Goo003oOoobOol00?mooo9oo`00\
\>"],
  ImageRangeCache->{{{0, 496}, {402, 0}} -> {-0.0481337, 0.0312326, 0.0020176,
   0.0020176}}]
}, Open  ]],

Cell[TextData[{
  "Die Gruppengeschwindigkeit erh\[ADoubleDot]lt man durch Nullsetzen der \
Ableitung von ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Psi]\[Psi]\^*\)\)]],
  " "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\[PartialD]\_x\ psi[x, t] == 0, x]\)], "Input"],

Cell[BoxData[
    \(Solve::"ifun" \( : \ \) 
      "Inverse functions are being used by \!\(Solve\), so some solutions may \
not be found."\)], "Message"],

Cell[BoxData[
    \({{x \[Rule] k0\ t}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Die Potentialbarriere", "Section"],

Cell[TextData[{
  "Potentialbarriere der H\[ODoubleDot]he ",
  Cell[BoxData[
      \(TraditionalForm\`V\_0\ und\ der\ Breite\ \((l\_2 - \ l\_1)\)\)]]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Theta][x_] = If[x >= 0, 1, 0]; \nV[x_] = \[Theta][1\/2 - Abs[x - 4]]; 
    \nwall = Plot[V[x], {x, \(-2\), 6}, PlotRange -> {0, 1.5}]; \)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.119048 0 0.412023 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.7381 -0.0125 -3 -9 ]
[.7381 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[.2494 .0824 -18 -4.5 ]
[.2494 .0824 0 4.5 ]
[.2494 .16481 -18 -4.5 ]
[.2494 .16481 0 4.5 ]
[.2494 .24721 -18 -4.5 ]
[.2494 .24721 0 4.5 ]
[.2494 .32962 -18 -4.5 ]
[.2494 .32962 0 4.5 ]
[.2494 .41202 -6 -4.5 ]
[.2494 .41202 0 4.5 ]
[.2494 .49443 -18 -4.5 ]
[.2494 .49443 0 4.5 ]
[.2494 .57683 -18 -4.5 ]
[.2494 .57683 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02381 0 m
.02381 .00625 L
s
[(-2)] .02381 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(2)] .5 -0.0125 0 1 Mshowa
.7381 0 m
.7381 .00625 L
s
[(4)] .7381 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(6)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.08333 0 m
.08333 .00375 L
s
.14286 0 m
.14286 .00375 L
s
.20238 0 m
.20238 .00375 L
s
.32143 0 m
.32143 .00375 L
s
.38095 0 m
.38095 .00375 L
s
.44048 0 m
.44048 .00375 L
s
.55952 0 m
.55952 .00375 L
s
.61905 0 m
.61905 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.79762 0 m
.79762 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.91667 0 m
.91667 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.2619 .0824 m
.26815 .0824 L
s
[(0.2)] .2494 .0824 1 0 Mshowa
.2619 .16481 m
.26815 .16481 L
s
[(0.4)] .2494 .16481 1 0 Mshowa
.2619 .24721 m
.26815 .24721 L
s
[(0.6)] .2494 .24721 1 0 Mshowa
.2619 .32962 m
.26815 .32962 L
s
[(0.8)] .2494 .32962 1 0 Mshowa
.2619 .41202 m
.26815 .41202 L
s
[(1)] .2494 .41202 1 0 Mshowa
.2619 .49443 m
.26815 .49443 L
s
[(1.2)] .2494 .49443 1 0 Mshowa
.2619 .57683 m
.26815 .57683 L
s
[(1.4)] .2494 .57683 1 0 Mshowa
.125 Mabswid
.2619 .0206 m
.26565 .0206 L
s
.2619 .0412 m
.26565 .0412 L
s
.2619 .0618 m
.26565 .0618 L
s
.2619 .10301 m
.26565 .10301 L
s
.2619 .12361 m
.26565 .12361 L
s
.2619 .14421 m
.26565 .14421 L
s
.2619 .18541 m
.26565 .18541 L
s
.2619 .20601 m
.26565 .20601 L
s
.2619 .22661 m
.26565 .22661 L
s
.2619 .26781 m
.26565 .26781 L
s
.2619 .28842 m
.26565 .28842 L
s
.2619 .30902 m
.26565 .30902 L
s
.2619 .35022 m
.26565 .35022 L
s
.2619 .37082 m
.26565 .37082 L
s
.2619 .39142 m
.26565 .39142 L
s
.2619 .43262 m
.26565 .43262 L
s
.2619 .45322 m
.26565 .45322 L
s
.2619 .47383 m
.26565 .47383 L
s
.2619 .51503 m
.26565 .51503 L
s
.2619 .53563 m
.26565 .53563 L
s
.2619 .55623 m
.26565 .55623 L
s
.2619 .59743 m
.26565 .59743 L
s
.25 Mabswid
.2619 0 m
.2619 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 0 m
.06244 0 L
.10458 0 L
.14415 0 L
.18221 0 L
.22272 0 L
.26171 0 L
.30316 0 L
.34309 0 L
.3815 0 L
.42237 0 L
.46172 0 L
.49955 0 L
.53984 0 L
.57861 0 L
.61984 0 L
.64043 0 L
.65954 0 L
.66906 0 L
.67373 0 L
.67578 0 L
.67687 0 L
.67803 0 L
.67928 .41202 L
.68044 .41202 L
.683 .41202 L
.68837 .41202 L
.69774 .41202 L
.7391 .41202 L
.75979 .41202 L
.77894 .41202 L
.78853 .41202 L
.79322 .41202 L
.79528 .41202 L
.79644 .41202 L
.79753 .41202 L
.79859 0 L
.79973 0 L
.80204 0 L
.80691 0 L
.81727 0 L
.85877 0 L
.89875 0 L
.93722 0 L
.97619 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O57oo00<007ooOol0
N7oo00<007ooOol0>Woo1P00>Goo00<007ooOol00Woo00<007ooOol03Goo0009Ool60006Ool00`00
Oomoo`1hOol00`00Oomoo`0iOol01@00Oomoogoo0000>Woo0P000goo00<007ooOol03Goo000FOol0
0`00Oomoo`1hOol00`00Oomoo`0iOol01000Oomoo`00>Woo00<007oo00000P0047oo000GOol00`00
Oomoo`1hOol00`00Oomoo`0iOol00`00Ool0000jOol00`00Oomoo`0BOol001Moo`03001oogoo07Qo
o`03001oogoo03Uoo`03001oo`0003Yoo`03001oogoo019oo`004Woo00<007ooOol00Woo00<007oo
Ool0Lgoo00<007ooOol00Woo00<007ooOol0>Woo0P00>goo00<007ooOol04Goo000COol4001gOol4
000nOol00`00Oomoo`0jOol3000@Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo
8Goo000:Oooo000<000;Ool0011oo`03001oogoo00eoo`03001oogoo00eoo`03001oogoo00eoo`03
001oogoo00eoo`03001oogoo00aoo`03001oogoo00eoo`03001oogoo00eoo`03001oogoo00eoo`03
001oogoo00eoo`03001oogoo00eoo`03001oogoo00aoo`8000ioo`03001oogoo00eoo`8000ioo`03
001oogoo00eoo`03001oogoo00eoo`03001oogoo00moo`0047oo00<007ooOol0?Goo00<007ooOol0
?7oo00<007ooOol0;7oo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol0;7oo00<007ooOol0
3goo001@Ool00`00Oomoo`1[Ool00`00Oomoo`0NOol00`00Oomoo`0nOol0051oo`03001oogoo06]o
o`03001oogoo01ioo`03001oogoo03ioo`00D7oo0P00K7oo00<007ooOol07Woo00<007ooOol0?Woo
001@Ool00`00Oomoo`1[Ool00`00Oomoo`0NOol00`00Oomoo`0nOol0051oo`03001oogoo06]oo`03
001oogoo01ioo`03001oogoo03ioo`00D7oo00<007ooOol0Jgoo00<007ooOol07Woo00<007ooOol0
?Woo001@Ool00`00Oomoo`1[Ool00`00Oomoo`0NOol00`00Oomoo`0nOol0051oo`03001oogoo06]o
o`03001oogoo01ioo`03001oogoo03ioo`00D7oo0P00K7oo00<007ooOol07Woo00<007ooOol0?Woo
001@Ool00`00Oomoo`1[Ool00`00Oomoo`0NOol00`00Oomoo`0nOol0051oo`03001oogoo06]oo`03
001oogoo01ioo`03001oogoo03ioo`00D7oo00<007ooOol0Jgoo00<007ooOol07Woo00<007ooOol0
?Woo001@Ool00`00Oomoo`1[Ool00`00Oomoo`0NOol00`00Oomoo`0nOol0051oo`8006aoo`03001o
ogoo01ioo`03001oogoo03ioo`00D7oo00<007ooOol0Jgoo00<007ooOol07Woo00<007ooOol0?Woo
000dOol40006Ool20005Ool60005Ool00`00Oomoo`1[Ool00`00Oomoo`0NOol00`00Oomoo`0nOol0
03=oo`03001oogoo009oo`03001oogoo00=oo`8000Eoo`03001oogoo00Qoo`03001oogoo06]oo`03
001oogoo01ioo`03001oogoo03ioo`00<goo00<007ooOol00Woo00<007ooOol02goo00<007ooOol0
1goo00<007ooOol0Jgoo00<007ooOol07Woo00<007ooOol0?Woo000cOol00`00Oomoo`02Ool00`00
Oomoo`0<Ool00`00Oomoo`06Ool00`00Oomoo`1[Ool00`00Oomoo`0NOol00`00Oomoo`0nOol003=o
o`03001oogoo009oo`03001oogoo00eoo`03001oogoo00Eoo`8006aoo`03001oogoo01ioo`03001o
ogoo03ioo`00<goo00<007ooOol00Woo00<007ooOol03Woo00<007ooOol017oo00<007ooOol0Jgoo
00<007ooOol07Woo00<007ooOol0?Woo000cOol00`00Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomo
o`03Ool00`00Oomoo`1[Ool00`00Oomoo`0NOol00`00Oomoo`0nOol003=oo`03001oogoo009oo`03
001oogoo00moo`03001oogoo00=oo`03001oogoo06]oo`03001oogoo01ioo`03001oogoo03ioo`00
<goo00<007ooOol00Woo00<007ooOol02Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
Jgoo00<007ooOol07Woo00<007ooOol0?Woo000dOol4000>Ool40006Ool2001/Ool00`00Oomoo`0N
Ool00`00Oomoo`0nOol0051oo`03001oogoo06]oo`03001oogoo01ioo`03001oogoo03ioo`00D7oo
00<007ooOol0Jgoo00<007ooOol07Woo00<007ooOol0?Woo001@Ool00`00Oomoo`1[Ool00`00Oomo
o`0NOol00`00Oomoo`0nOol0051oo`03001oogoo06]oo`03001oogoo01ioo`03001oogoo03ioo`00
D7oo00<007ooOol0Jgoo00<007ooOol07Woo00<007ooOol0?Woo001@Ool2001/Ool00`00Oomoo`0N
Ool00`00Oomoo`0nOol0051oo`03001oogoo06]oo`03001oogoo01ioo`03001oogoo03ioo`00D7oo
00<007ooOol0Jgoo00<007ooOol07Woo00<007ooOol0?Woo001@Ool00`00Oomoo`1[Ool00`00Oomo
o`0NOol00`00Oomoo`0nOol0051oo`03001oogoo06]oo`03001oogoo01ioo`03001oogoo03ioo`00
D7oo0P00K7oo00<007ooOol07Woo00<007ooOol0?Woo001@Ool00`00Oomoo`1[Ool00`00Oomoo`0N
Ool00`00Oomoo`0nOol003Aoo`@000Ioo`8000Qoo`<000Eoo`03001oogoo06]oo`03001oogoo01io
o`03001oogoo03ioo`00<goo00<007ooOol00Woo00<007ooOol00goo0P002Goo00<007ooOol017oo
00<007ooOol0Jgoo00<007ooOol07Woo00<007ooOol0?Woo000cOol00`00Oomoo`02Ool00`00Oomo
o`0>Ool00`00Oomoo`04Ool00`00Oomoo`1[Ool00`00Oomoo`0NOol00`00Oomoo`0nOol003=oo`03
001oogoo009oo`03001oogoo00Yoo`H000Eoo`03001oogoo06]oo`03001oogoo01ioo`03001oogoo
03ioo`00<goo00<007ooOol00Woo00<007ooOol02Woo00D007ooOomoo`0000Ioo`8006aoo`03001o
ogoo01ioo`03001oogoo03ioo`00<goo00<007ooOol00Woo00<007ooOol02goo00@007ooOol000Io
o`03001oogoo06]oo`03001oogoo01ioo`03001oogoo03ioo`00<goo00<007ooOol00Woo00<007oo
Ool037oo00<007oo00001Woo00<007ooOol0Jgoo00<007ooOol07Woo00<007ooOol0?Woo000cOol0
0`00Oomoo`02Ool00`00Oomoo`0<Ool00`00Ool00006Ool00`00Oomoo`1[Ool00`00Oomoo`0NOol0
0`00Oomoo`0nOol003=oo`03001oogoo009oo`03001oogoo00eoo`8000Ioo`03001oogoo06]oo`03
001oogoo01ioo`03001oogoo03ioo`00=7oo10004Goo00<007ooOol017oo0P00K7oo00<007ooOol0
7Woo00<007ooOol0?Woo001@Ool00`00Oomoo`1[Ool00`00Oomoo`0NOol00`00Oomoo`0nOol0051o
o`03001oogoo06]oo`03001oogoo01ioo`03001oogoo03ioo`00D7oo00<007ooOol0Jgoo00<007oo
Ool07Woo00<007ooOol0?Woo001@Ool00`00Oomoo`1[Ool00`00Oomoo`0NOol00`00Oomoo`0nOol0
051oo`03001oogoo06]oo`03001oogoo01ioo`03001oogoo03ioo`00D7oo0P00KGoo00<007ooOol0
77oo00<007ooOol0?goo001@Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomoo`0oOol0051o
o`03001oogoo06aoo`03001oogoo01aoo`03001oogoo03moo`00D7oo00<007ooOol0K7oo00<007oo
Ool077oo00<007ooOol0?goo001@Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomoo`0oOol0
051oo`8006eoo`03001oogoo01aoo`03001oogoo03moo`00D7oo00<007ooOol0K7oo00<007ooOol0
77oo00<007ooOol0?goo000dOol40006Ool20006Ool40006Ool00`00Oomoo`1/Ool00`00Oomoo`0L
Ool00`00Oomoo`0oOol003=oo`03001oogoo009oo`03001oogoo00=oo`8000Eoo`03001oogoo009o
o`03001oogoo00=oo`03001oogoo06aoo`03001oogoo01aoo`03001oogoo03moo`00<goo00<007oo
Ool00Woo00<007ooOol02Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0K7oo00<007oo
Ool077oo00<007ooOol0?goo000cOol00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomoo`0oOol003=oo`03001oogoo
009oo`03001oogoo00Yoo`8000=oo`03001oogoo00=oo`8006eoo`03001oogoo01aoo`03001oogoo
03moo`00<goo00<007ooOol00Woo00<007ooOol02Woo00<007oo00000P001Woo00<007ooOol0K7oo
00<007ooOol077oo00<007ooOol0?goo000cOol00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomo
o`08Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomoo`0oOol003=oo`03001oogoo009oo`03
001oogoo00Yoo`03001oogoo00Qoo`03001oogoo06aoo`03001oogoo01aoo`03001oogoo03moo`00
<goo00<007ooOol00Woo00<007ooOol02goo00<007ooOol01goo00<007ooOol0K7oo00<007ooOol0
77oo00<007ooOol0?goo000dOol4000?Ool30006Ool2001]Ool00`00Oomoo`0LOol00`00Oomoo`0o
Ool0051oo`03001oogoo06aoo`03001oogoo01aoo`03001oogoo03moo`00D7oo00<007ooOol0K7oo
00<007ooOol077oo00<007ooOol0?goo001@Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomo
o`0oOol0051oo`03001oogoo06aoo`03001oogoo01aoo`03001oogoo03moo`00D7oo00<007ooOol0
K7oo00<007ooOol077oo00<007ooOol0?goo001@Ool2001]Ool00`00Oomoo`0LOol00`00Oomoo`0o
Ool0051oo`03001oogoo06aoo`03001oogoo01aoo`03001oogoo03moo`00D7oo00<007ooOol0K7oo
00<007ooOol077oo00<007ooOol0?goo001@Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomo
o`0oOol0051oo`03001oogoo06aoo`03001oogoo01aoo`03001oogoo03moo`00D7oo0P00KGoo00<0
07ooOol077oo00<007ooOol0?goo001@Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomoo`0o
Ool003Aoo`@000Ioo`8000Ioo`@000Ioo`03001oogoo06aoo`03001oogoo01aoo`03001oogoo03mo
o`00<goo00<007ooOol00Woo00<007ooOol00goo0P001Goo00<007ooOol00Woo00<007ooOol00goo
00<007ooOol0K7oo00<007ooOol077oo00<007ooOol0?goo000cOol00`00Oomoo`02Ool00`00Oomo
o`0:Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomo
o`0oOol003=oo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo009oo`03001oogoo00=oo`03
001oogoo06aoo`03001oogoo01aoo`03001oogoo03moo`00<goo00<007ooOol00Woo00<007ooOol0
2Woo00<007ooOol00Woo00<007ooOol00goo0P00KGoo00<007ooOol077oo00<007ooOol0?goo000c
Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool40006Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00
Oomoo`0oOol003=oo`03001oogoo009oo`03001oogoo00Yoo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo06aoo`03001oogoo01aoo`03001oogoo03moo`00<goo00<007ooOol00Woo00<007oo
Ool02Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0K7oo00<007ooOol077oo00<007oo
Ool0?goo000cOol00`00Oomoo`02Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`03Ool0
0`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomoo`0oOol003Aoo`@000ioo`@000Ioo`8006eoo`03
001oogoo01aoo`03001oogoo03moo`00D7oo00<007ooOol0K7oo00<007ooOol077oo00<007ooOol0
?goo001@Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomoo`0oOol0051oo`03001oogoo06ao
o`03001oogoo01aoo`03001oogoo03moo`00D7oo00<007ooOol0K7oo00<007ooOol077oo00<007oo
Ool0?goo001@Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomoo`0oOol0051oo`8006eoo`03
001oogoo01aoo`03001oogoo03moo`00D7oo00<007ooOol0K7oo00<007ooOol077oo00<007ooOol0
?goo001@Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomoo`0oOol0051oo`03001oogoo06ao
o`03001oogoo01aoo`03001oogoo03moo`00D7oo00<007ooOol0K7oo00<007ooOol077oo00<007oo
Ool0?goo001@Ool2001]Ool00`00Oomoo`0LOol00`00Oomoo`0oOol0051oo`03001oogoo06aoo`03
001oogoo01aoo`03001oogoo03moo`00AWoo1@001Goo00<007ooOol0K7oo00<007ooOol077oo00<0
07ooOol0?goo0018Ool00`00Oomoo`05Ool00`00Oomoo`1/Ool00`00Oomoo`0LOol00`00Oomoo`0o
Ool004Qoo`03001oogoo00Eoo`03001oogoo06aoo`03001oogoo01aoo`03001oogoo03moo`00B7oo
00<007ooOol01Goo00<007ooOol0K7oo00<007ooOol077oo00<007ooOol0?goo0018Ool00`00Oomo
o`05Ool2001]OolP0011Ool004Qoo`03001oogoo00Eoo`03001oogoo0<eoo`00B7oo00<007ooOol0
1Goo00<007ooOol0cGoo0018Ool00`00Oomoo`05Ool00`00Oomoo`3=Ool004Ioo`<000Moo`03001o
ogoo0<eoo`00B7oo00<007ooOol01Goo0P00cWoo001@Ool00`00Oomoo`3=Ool0051oo`03001oogoo
0<eoo`00D7oo00<007ooOol0cGoo001@Ool00`00Oomoo`3=Ool0051oo`03001oogoo0<eoo`00D7oo
0P00cWoo001@Ool00`00Oomoo`3=Ool0051oo`03001oogoo0<eoo`00D7oo00<007ooOol0cGoo001@
Ool00`00Oomoo`3=Ool0051oo`800<ioo`00D7oo00<007ooOol0cGoo000dOol50005Ool20005Ool6
0005Ool00`00Oomoo`3=Ool003Ioo`03001oogoo00Eoo`8000Eoo`03001oogoo00Qoo`03001oogoo
0<eoo`00=Woo00<007ooOol03Goo00<007ooOol01goo00<007ooOol0cGoo000fOol00`00Oomoo`0>
Ool00`00Oomoo`06Ool00`00Oomoo`3=Ool003Ioo`03001oogoo00moo`03001oogoo00Eoo`800<io
o`00=Woo00<007ooOol047oo00<007ooOol017oo00<007ooOol0cGoo000fOol00`00Oomoo`0AOol0
0`00Oomoo`03Ool00`00Oomoo`3=Ool003Ioo`03001oogoo015oo`03001oogoo00=oo`03001oogoo
0<eoo`00=7oo0`003Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0cGoo000fOol00`00
Oomoo`0=Ool40006Ool2003>Ool0051oo`03001oogoo0<eoo`00D7oo00<007ooOol0cGoo001@Ool0
0`00Oomoo`3=Ool0051oo`03001oogoo0<eoo`00D7oo00<007ooOol0cGoo001@Ool2003>Ool0051o
o`03001oogoo0<eoo`00D7oo00<007ooOol0cGoo001@Ool00`00Oomoo`3=Ool0051oo`03001oogoo
0<eoo`00D7oo0P00cWoo001@Ool00`00Oomoo`3=Ool003Aoo`D000Eoo`8000Qoo`<000Eoo`03001o
ogoo0<eoo`00=Woo00<007ooOol01Goo0P002Goo00<007ooOol017oo00<007ooOol0cGoo000fOol0
0`00Oomoo`0@Ool00`00Oomoo`04Ool00`00Oomoo`3=Ool003Ioo`03001oogoo00aoo`H000Eoo`03
001oogoo0<eoo`00=Woo00<007ooOol037oo00D007ooOomoo`0000Ioo`800<ioo`00=Woo00<007oo
Ool03Goo00@007ooOol000Ioo`03001oogoo0<eoo`00=Woo00<007ooOol03Woo00<007oo00001Woo
00<007ooOol0cGoo000fOol00`00Oomoo`0>Ool00`00Ool00006Ool00`00Oomoo`3=Ool003Aoo`<0
015oo`8000Ioo`03001oogoo0<eoo`00=Woo00<007ooOol047oo00<007ooOol017oo0P00cWoo001@
Ool00`00Oomoo`3=Ool0051oo`03001oogoo0<eoo`00D7oo00<007ooOol0cGoo001@Ool00`00Oomo
o`3=Ool0051oo`03001oogoo0<eoo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-2.52578, -0.112359, 
  0.0315384, 0.00911257}}]
}, Open  ]],

Cell[TextData[{
  "f\[UDoubleDot]r ",
  Cell[BoxData[
      \(TraditionalForm\`E = k\^2\/2 >= V\_0\ gilt\ folgender\ Anstatz\)]],
  " f\[UDoubleDot]r die 3 Bereiche ",
  Cell[BoxData[
      \(TraditionalForm\`x < l\_1\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[CurlyPhi]\_1)\)\ , \ 
      l\_1 <= x <= l2\ \((\[CurlyPhi]\_2)\)\ und\ x > l\_2\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[CurlyPhi]\_3)\)\)]]
}], "Text"],

Cell[BoxData[
    \(\[Omega][k_] = k\^2\/2; \n
    \[CurlyPhi]\_1[x_, t_] = 
      A1\ Exp[\[ImaginaryI]\ k\ x] Exp[\(-\[ImaginaryI]\)\ \[Omega][k] t] + 
        B1\ Exp[\(-\[ImaginaryI]\)\ k\ x] 
          Exp[\(-\[ImaginaryI]\)\ \[Omega][k] t]; \n
    \[CurlyPhi]\_2[x_, t_] = 
      A2\ Exp[\[ImaginaryI]\ kv\ x] Exp[\(-\[ImaginaryI]\)\ \[Omega][k] t] + 
        B2\ Exp[\(-\[ImaginaryI]\)\ kv\ x] 
          Exp[\(-\[ImaginaryI]\)\ \[Omega][k] t]; \n
    \[CurlyPhi]\_3[x_, t_] = 
      A3\ Exp[\[ImaginaryI]\ k\ x] Exp[\(-\[ImaginaryI]\)\ \[Omega][k] t]; 
    \)], "Input"],

Cell[TextData[{
  "mit kv = ",
  Cell[BoxData[
      \(TraditionalForm\`2 \((E - V\_0)\)\^\(1\/2\)\)]],
  "\nDie Wellenfunktion mu\[SZ] an den Potentialspr\[UDoubleDot]ngen stetig \
bez\[UDoubleDot]glich Funktionswert und 1. Ableitung sein."
}], "Text"],

Cell[BoxData[
    \(Clear[v0, l1, l2]; \n
    eq\_1 = \[CurlyPhi]\_1[l1, 0] == \[CurlyPhi]\_2[l1, 0]; \n
    eq\_2 = \[CurlyPhi]\_2[l2, 0] == \[CurlyPhi]\_3[l2, 0]; \n
    eq\_3 = \((\[PartialD]\_x\ \[CurlyPhi]\_1[x, 0]\  /. x -> l1)\) == 
        \((\[PartialD]\_x\ \[CurlyPhi]\_2[x, 0]\  /. x -> l1)\); \n
    eq\_4 = \((\[PartialD]\_x\ \[CurlyPhi]\_2[x, 0]\  /. x -> l2)\) == 
        \((\[PartialD]\_x\ \[CurlyPhi]\_3[x, 0]\  /. x -> l2)\); \)], "Input"],

Cell["\<\
Die L\[ODoubleDot]sung des linearen Gleichungssystems ergibt f\[UDoubleDot]r \
die Koeffizienten\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = Solve[{eq\_1, eq\_2, eq\_3, eq\_4}, {A1, B1, A2, B2}]\)], "Input"],

Cell[BoxData[
    \({{A1 \[Rule] 
          \(-\(1\/\(4\ k\ kv\)\((
              A3\ E\^\(\(-I\)\ k\ l1 - I\ kv\ l1 + I\ k\ l2 - I\ kv\ l2\)\ \((
                \(-E\^\(2\ I\ kv\ l1\)\)\ k\^2 + E\^\(2\ I\ kv\ l2\)\ k\^2 - 
                  2\ E\^\(2\ I\ kv\ l1\)\ k\ kv - 
                  2\ E\^\(2\ I\ kv\ l2\)\ k\ kv - 
                  E\^\(2\ I\ kv\ l1\)\ kv\^2 + E\^\(2\ I\ kv\ l2\)\ kv\^2)\))
              \)\)\), B1 \[Rule] 
          \(-\(\(A3\ E\^\(I\ k\ l1 - I\ kv\ l1 + I\ k\ l2 - I\ kv\ l2\)\ \((
                  \(-E\^\(2\ I\ kv\ l1\)\) + E\^\(2\ I\ kv\ l2\))\)\ 
                  \((k\^2 - kv\^2)\)\)\/\(4\ k\ kv\)\)\), 
        A2 \[Rule] 
          \(A3\ E\^\(I\ k\ l2 - I\ kv\ l2\)\ \((k + kv)\)\)\/\(2\ kv\), 
        B2 \[Rule] 
          \(A3\ E\^\(I\ k\ l2 + I\ kv\ l2\)\ \((\(-k\) + kv)\)\)\/\(2\ kv\)}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(const = {v0 -> 90, l1 -> 2, l2 -> 2.3, A3 -> 1}; \n
    sol1 = \(sol\  /. \ kv\  -> \@\(k\^2\  - 2\ v0\)\) /. const; \n
    sol2 = \(sol\  /. \ kv -> \ \[ImaginaryI]\ \@\(2\ v0\  - k\^2\)\)\  /. 
        const; \nwall = 
      Plot[If[\((x > 2)\) && \((x < 2.3)\), 8, 0], {x, \(-5\), 10}, 
        PlotPoints -> 30]; \)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.34127 0.0634921 0.0147151 0.0735755 [
[.0873 .00222 -6 -9 ]
[.0873 .00222 6 0 ]
[.21429 .00222 -6 -9 ]
[.21429 .00222 6 0 ]
[.46825 .00222 -3 -9 ]
[.46825 .00222 3 0 ]
[.59524 .00222 -3 -9 ]
[.59524 .00222 3 0 ]
[.72222 .00222 -3 -9 ]
[.72222 .00222 3 0 ]
[.84921 .00222 -3 -9 ]
[.84921 .00222 3 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.32877 .16187 -6 -4.5 ]
[.32877 .16187 0 4.5 ]
[.32877 .30902 -6 -4.5 ]
[.32877 .30902 0 4.5 ]
[.32877 .45617 -6 -4.5 ]
[.32877 .45617 0 4.5 ]
[.32877 .60332 -6 -4.5 ]
[.32877 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 .01472 m
.0873 .02097 L
s
[(-4)] .0873 .00222 0 1 Mshowa
.21429 .01472 m
.21429 .02097 L
s
[(-2)] .21429 .00222 0 1 Mshowa
.46825 .01472 m
.46825 .02097 L
s
[(2)] .46825 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(4)] .59524 .00222 0 1 Mshowa
.72222 .01472 m
.72222 .02097 L
s
[(6)] .72222 .00222 0 1 Mshowa
.84921 .01472 m
.84921 .02097 L
s
[(8)] .84921 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(10)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.11905 .01472 m
.11905 .01847 L
s
.15079 .01472 m
.15079 .01847 L
s
.18254 .01472 m
.18254 .01847 L
s
.24603 .01472 m
.24603 .01847 L
s
.27778 .01472 m
.27778 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.37302 .01472 m
.37302 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.43651 .01472 m
.43651 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.53175 .01472 m
.53175 .01847 L
s
.56349 .01472 m
.56349 .01847 L
s
.62698 .01472 m
.62698 .01847 L
s
.65873 .01472 m
.65873 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.75397 .01472 m
.75397 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.81746 .01472 m
.81746 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.9127 .01472 m
.9127 .01847 L
s
.94444 .01472 m
.94444 .01847 L
s
.05556 .01472 m
.05556 .01847 L
s
.02381 .01472 m
.02381 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.34127 .16187 m
.34752 .16187 L
s
[(2)] .32877 .16187 1 0 Mshowa
.34127 .30902 m
.34752 .30902 L
s
[(4)] .32877 .30902 1 0 Mshowa
.34127 .45617 m
.34752 .45617 L
s
[(6)] .32877 .45617 1 0 Mshowa
.34127 .60332 m
.34752 .60332 L
s
[(8)] .32877 .60332 1 0 Mshowa
.125 Mabswid
.34127 .0515 m
.34502 .0515 L
s
.34127 .08829 m
.34502 .08829 L
s
.34127 .12508 m
.34502 .12508 L
s
.34127 .19865 m
.34502 .19865 L
s
.34127 .23544 m
.34502 .23544 L
s
.34127 .27223 m
.34502 .27223 L
s
.34127 .3458 m
.34502 .3458 L
s
.34127 .38259 m
.34502 .38259 L
s
.34127 .41938 m
.34502 .41938 L
s
.34127 .49296 m
.34502 .49296 L
s
.34127 .52974 m
.34502 .52974 L
s
.34127 .56653 m
.34502 .56653 L
s
.25 Mabswid
.34127 0 m
.34127 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.05578 .01472 L
.09065 .01472 L
.1234 .01472 L
.1549 .01472 L
.18842 .01472 L
.22069 .01472 L
.25499 .01472 L
.28804 .01472 L
.31983 .01472 L
.35365 .01472 L
.38622 .01472 L
.41753 .01472 L
.43494 .01472 L
.45087 .01472 L
.45873 .01472 L
.46289 .01472 L
.46517 .01472 L
.46629 .01472 L
.46732 .01472 L
.46831 .60332 L
.46936 .60332 L
.47157 .60332 L
.47543 .60332 L
.48296 .60332 L
.48506 .60332 L
.4861 .60332 L
.48706 .60332 L
.48793 .01472 L
.48885 .01472 L
.4908 .01472 L
.49921 .01472 L
.51438 .01472 L
.54562 .01472 L
.57889 .01472 L
.61091 .01472 L
.64496 .01472 L
.67775 .01472 L
.70929 .01472 L
.74286 .01472 L
.77517 .01472 L
.80951 .01472 L
.8426 .01472 L
.87444 .01472 L
.9083 .01472 L
.94091 .01472 L
.97226 .01472 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O8Goo1P007Woo00<0
07ooOol0?Woo00<007ooOol07Goo1P007Goo00<007ooOol00Woo00<007ooOol06Woo00<007ooOol0
0Woo00<007ooOol06Goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol01Woo000HOol60003
Ool01@00Oomoogoo000057oo1P001Woo00<007ooOol0?Woo00<007ooOol077oo00D007ooOomoo`00
01ioo`8000=oo`03001oogoo01Yoo`03001oogoo009oo`03001oogoo01Uoo`03001oogoo00=oo`03
001oogoo009oo`03001oogoo00Ioo`008Woo00@007ooOol0025oo`03001oogoo03ioo`03001oogoo
01aoo`04001oogoo000NOol00`00Ool00002000NOol4000LOol00`00Oomoo`03Ool00`00Oomoo`02
Ool00`00Oomoo`06Ool002=oo`03001oo`00029oo`03001oogoo03ioo`03001oogoo01aoo`03001o
o`0001ioo`03001oogoo01moo`03001oogoo009oo`03001oogoo01Uoo`03001oogoo00=oo`03001o
ogoo009oo`03001oogoo00Ioo`008goo00<007oo00008Woo00<007ooOol0?Woo00<007ooOol077oo
00<007oo00007Woo00<007ooOol07goo00<007ooOol00Woo00<007ooOol06Goo00<007ooOol00goo
00<007ooOol00Woo00<007ooOol01Woo000TOol2000MOol00`00Oomoo`02Ool00`00Oomoo`0iOol0
0`00Oomoo`02Ool00`00Oomoo`0MOol2000OOol00`00Oomoo`0NOol00`00Oomoo`02Ool00`00Oomo
o`0GOol30005Ool00`00Oomoo`02Ool00`00Oomoo`06Ool002Eoo`03001oogoo01aoo`@003eoo`@0
025oo`03001oogoo01ioo`<001ioo`@001aoo`03001oogoo00Aoo`@000Uoo`00ogoo8Goo001TOol0
0`00Oomoo`2iOol006Aoo`03001oogoo0;Uoo`00I7oo00<007ooOol0^Goo001TOol00`00Oomoo`2i
Ool000Moool0018000Qoo`003Woo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol01Woo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Woo00<0
07ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Woo00<0
07ooOol01Goo00<007ooOol00goo00@007ooOol000Qoo`03001oogoo00Eoo`03001oogoo00Ioo`03
001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03
001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03
001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00eoo`007goo00<007ooOol07goo00<007ooOol0
87oo00<007ooOol07goo00<007ooOol00goo00<007ooOol06Woo00<007ooOol07goo00<007ooOol0
87oo00<007ooOol07goo00<007ooOol03Goo001TOol00`00Oomoo`0OOol00`00Oomoo`03Ool00`00
Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03001oogoo095oo`00I7oo00<007oo
Ool07goo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00Oomoo`0OOol00`00Oomoo`03Ool0
0`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03001oogoo095oo`00I7oo00<0
07ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00Oomoo`0OOol00`00Oomoo`03
Ool00`00Oomoo`2AOol006Aoo`80021oo`03001oogoo00=oo`03001oogoo095oo`00I7oo00<007oo
Ool07goo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00Oomoo`0OOol00`00Oomoo`03Ool0
0`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03001oogoo095oo`00I7oo00<0
07ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00Oomoo`0OOol00`00Oomoo`03
Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03001oogoo095oo`00I7oo
00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00Oomoo`0OOol00`00Oomo
o`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03001oogoo095oo`00
I7oo0P0087oo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00Oomoo`0OOol00`00Oomoo`03
Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03001oogoo095oo`00I7oo
00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00Oomoo`0OOol00`00Oomo
o`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03001oogoo095oo`00
I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00Oomoo`0OOol00`00
Oomoo`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03001oogoo095o
o`00I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol2000POol00`00Oomo
o`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03001oogoo095oo`00
I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00Oomoo`0OOol00`00
Oomoo`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03001oogoo095o
o`00I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001IOol60005Ool00`00Oomo
o`0OOol00`00Oomoo`03Ool00`00Oomoo`2AOol005Uoo`03001oogoo00Qoo`03001oogoo01moo`03
001oogoo00=oo`03001oogoo095oo`00FWoo00<007ooOol01goo00<007ooOol07goo00<007ooOol0
0goo00<007ooOol0TGoo001KOol00`00Oomoo`06Ool00`00Oomoo`0OOol00`00Oomoo`03Ool00`00
Oomoo`2AOol005aoo`03001oogoo00Eoo`<001moo`03001oogoo00=oo`03001oogoo095oo`00GGoo
00<007ooOol017oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001NOol00`00Oomo
o`03Ool00`00Oomoo`0OOol00`00Oomoo`03Ool00`00Oomoo`2AOol005ioo`03001oogoo00=oo`03
001oogoo01moo`03001oogoo00=oo`03001oogoo095oo`00FGoo00<007ooOol00Woo00<007ooOol0
0goo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001JOol40006Ool00`00Oomoo`0O
Ool00`00Oomoo`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03001o
ogoo095oo`00I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00Oomo
o`0OOol00`00Oomoo`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03
001oogoo095oo`00I7oo0P0087oo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00Oomoo`0O
Ool00`00Oomoo`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03001o
ogoo095oo`00I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00Oomo
o`0OOol00`00Oomoo`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03
001oogoo095oo`00I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00
Oomoo`0OOol00`00Oomoo`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=o
o`03001oogoo095oo`00I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol2
000POol00`00Oomoo`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=oo`03
001oogoo095oo`00I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol00`00
Oomoo`0OOol00`00Oomoo`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo00=o
o`03001oogoo095oo`00I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol0
0`00Oomoo`0OOol00`00Oomoo`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo
00=oo`03001oogoo095oo`00I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001T
Ool00`00Oomoo`0OOol00`00Oomoo`03Ool00`00Oomoo`2AOol006Aoo`80021oo`03001oogoo00=o
o`03001oogoo095oo`00I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001TOol0
0`00Oomoo`0OOol00`00Oomoo`03Ool00`00Oomoo`2AOol006Aoo`03001oogoo01moo`03001oogoo
00=oo`03001oogoo095oo`00I7oo00<007ooOol07goo00<007ooOol00goo00<007ooOol0TGoo001T
Ool00`00Oomoo`0OOol00`00Oomoo`03Ool00`00Oomoo`2AOol005aoo`<000Eoo`03001oogoo01mo
o`03001oogoo00=oo`03001oogoo095oo`00GGoo00<007ooOol017oo00<007ooOol07goo00<007oo
Ool00goo00<007ooOol0TGoo001MOol00`00Oomoo`04Ool00`00Oomoo`0OOol00`00Oomoo`03Ool0
0`00Oomoo`2AOol005Uoo`H000Eoo`03001oogoo01moo`03001oogoo00=oo`03001oogoo095oo`00
FGoo00D007ooOomoo`0000Ioo`<001moo`03001oogoo009oo`03001oogoo099oo`00FWoo00@007oo
Ool000Ioo`03001oogoo01moo`03001oogoo009oo`03001oogoo099oo`00Fgoo00<007oo00001Woo
00<007ooOol07goo00<007ooOol00Woo00<007ooOol0TWoo001KOol00`00Ool00006Ool00`00Oomo
o`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol005aoo`8000Ioo`03001oogoo01moo`03001oogoo
009oo`03001oogoo099oo`00GGoo00<007ooOol017oo00<007ooOol07goo00<007ooOol00Woo00<0
07ooOol0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03001o
ogoo01moo`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol00Woo
00<007ooOol0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`80
021oo`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol00Woo00<0
07ooOol0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03001o
ogoo01moo`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol00Woo
00<007ooOol0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03
001oogoo01moo`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol0
0Woo00<007ooOol0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Ao
o`03001oogoo01moo`03001oogoo009oo`03001oogoo099oo`00I7oo0P0087oo00<007ooOol00Woo
00<007ooOol0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03
001oogoo01moo`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol0
0Woo00<007ooOol0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Ao
o`03001oogoo01moo`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007oo
Ool00Woo00<007ooOol0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol0
06Aoo`03001oogoo01moo`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<0
07ooOol00Woo00<007ooOol0TWoo001TOol2000POol00`00Oomoo`02Ool00`00Oomoo`2BOol006Ao
o`03001oogoo01moo`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007oo
Ool00Woo00<007ooOol0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol0
06Aoo`03001oogoo01moo`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<0
07ooOol00Woo00<007ooOol0TWoo001JOol40006Ool00`00Oomoo`0OOol00`00Oomoo`02Ool00`00
Oomoo`2BOol005Uoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo01moo`03001oogoo009o
o`03001oogoo099oo`00FGoo00<007ooOol00Woo00<007ooOol00goo00<007ooOol07goo00<007oo
Ool00Woo00<007ooOol0TWoo001IOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`0OOol0
0`00Oomoo`02Ool00`00Oomoo`2BOol005Uoo`8000=oo`03001oogoo00=oo`<001moo`03001oogoo
009oo`03001oogoo099oo`00FGoo00<007oo00000P001Woo00<007ooOol07goo00<007ooOol00Woo
00<007ooOol0TWoo001IOol00`00Oomoo`08Ool00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomo
o`2BOol005Uoo`03001oogoo00Qoo`03001oogoo01moo`03001oogoo009oo`03001oogoo099oo`00
FWoo00<007ooOol01goo00<007ooOol07goo00<007ooOol00Woo00<007ooOol0TWoo001KOol30006
Ool00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03001oogoo01moo`03001o
ogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol00Woo00<007ooOol0TWoo
001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03001oogoo01moo`03
001oogoo009oo`03001oogoo099oo`00I7oo0P0087oo00<007ooOol00Woo00<007ooOol0TWoo001T
Ool00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03001oogoo01moo`03001o
ogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol00Woo00<007ooOol0TWoo
001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03001oogoo01moo`03
001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol00Woo00<007ooOol0
TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03001oogoo01mo
o`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol00Woo00<007oo
Ool0TWoo001TOol2000POol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03001oogoo01moo`03
001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol00Woo00<007ooOol0
TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03001oogoo01mo
o`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol00Woo00<007oo
Ool0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03001oogoo
01moo`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol00Woo00<0
07ooOol0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`80021o
o`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol00Woo00<007oo
Ool0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol006Aoo`03001oogoo
01moo`03001oogoo009oo`03001oogoo099oo`00I7oo00<007ooOol07goo00<007ooOol00Woo00<0
07ooOol0TWoo001TOol00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol005Yoo`@000Io
o`03001oogoo01moo`03001oogoo009oo`03001oogoo099oo`00FGoo00<007ooOol00Woo00<007oo
Ool00goo00<007ooOol07goo00<007ooOol00Woo00<007ooOol0TWoo001IOol00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`2BOol005Uoo`03001oogoo
009oo`03001oogoo00=oo`03001oogoo01moo`03001oogoo009oo`03001oogoo099oo`00FGoo00<0
07ooOol00Woo00<007ooOol00goo0`007goo1P00U7oo001JOol40006Ool00`00Oomoo`2iOol005Uo
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo0;Uoo`00FGoo00<007ooOol00Woo00<007oo
Ool00goo00<007ooOol0^Goo001IOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`2iOol0
0001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-5.8125, -0.61976, 0.0579268,
   0.049988}}]
}, Open  ]],

Cell["\<\
Das Einsetzen der berechneten Koeffizienten in den L\[ODoubleDot]sungsansatz \
\
\>", "Text"],

Cell[BoxData[
    \(p11[x_, k_, t_] = \((\[CurlyPhi]\_1[x, t] /. sol1\ )\)[\([1]\)]; \n
    p12[x_, k_, t_] = \((\[CurlyPhi]\_1[x, t] /. sol2\ )\)[\([1]\)]; \n
    p21[x_, k_, t_] = 
      \(\(\[CurlyPhi]\_2[x, t]\  /. kv -> \ \@\(k\^2 - 2\ v0\)\) /. const
          \) /. sol1\ [\([1]\)]; \n
    p22[x_, k_, t_] = 
      \(\(\[CurlyPhi]\_2[x, t]\  /. 
            kv -> \[ImaginaryI]\ \@\(2  v0\  - \ k\^2\)\) /. const\) /. 
        sol2\ [\([1]\)]; \n
    p31[x_, k_, t_] = 
      \((\(\[CurlyPhi]\_3[x, t] /. sol1\)\  /. const)\)[\([1]\)]; \n
    p32[x_, k_, t_] = 
      \((\(\[CurlyPhi]\_3[x, t] /. sol2\) /. const\ )\)[\([1]\)]; \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Kappa] = 12.5; \[Tau] = 0; \n
    plo1 = Plot[Re[p11[x, \[Kappa], \[Tau]]], {x, \(-3\), l1 /. const}, 
        DisplayFunction -> Identity]; \n
    plo2 = Plot[Re[p21[x, \[Kappa], \[Tau]]], {x, l1 /. const, l2 /. const}, 
        DisplayFunction -> Identity]; \n
    plo3 = Plot[Re[p31[x, \[Kappa], \[Tau]]], {x, l2 /. const, 10}, 
        DisplayFunction -> Identity]; \n
    Show[plo1, plo2, plo3, DisplayFunction -> $DisplayFunction]; \)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.24359 0.0732601 0.309015 0.0619319 [
[.09707 .29651 -6 -9 ]
[.09707 .29651 6 0 ]
[.39011 .29651 -3 -9 ]
[.39011 .29651 3 0 ]
[.53663 .29651 -3 -9 ]
[.53663 .29651 3 0 ]
[.68315 .29651 -3 -9 ]
[.68315 .29651 3 0 ]
[.82967 .29651 -3 -9 ]
[.82967 .29651 3 0 ]
[.97619 .29651 -6 -9 ]
[.97619 .29651 6 0 ]
[.23109 .06129 -12 -4.5 ]
[.23109 .06129 0 4.5 ]
[.23109 .18515 -12 -4.5 ]
[.23109 .18515 0 4.5 ]
[.23109 .43288 -6 -4.5 ]
[.23109 .43288 0 4.5 ]
[.23109 .55674 -6 -4.5 ]
[.23109 .55674 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.09707 .30901 m
.09707 .31526 L
s
[(-2)] .09707 .29651 0 1 Mshowa
.39011 .30901 m
.39011 .31526 L
s
[(2)] .39011 .29651 0 1 Mshowa
.53663 .30901 m
.53663 .31526 L
s
[(4)] .53663 .29651 0 1 Mshowa
.68315 .30901 m
.68315 .31526 L
s
[(6)] .68315 .29651 0 1 Mshowa
.82967 .30901 m
.82967 .31526 L
s
[(8)] .82967 .29651 0 1 Mshowa
.97619 .30901 m
.97619 .31526 L
s
[(10)] .97619 .29651 0 1 Mshowa
.125 Mabswid
.1337 .30901 m
.1337 .31276 L
s
.17033 .30901 m
.17033 .31276 L
s
.20696 .30901 m
.20696 .31276 L
s
.28022 .30901 m
.28022 .31276 L
s
.31685 .30901 m
.31685 .31276 L
s
.35348 .30901 m
.35348 .31276 L
s
.42674 .30901 m
.42674 .31276 L
s
.46337 .30901 m
.46337 .31276 L
s
.5 .30901 m
.5 .31276 L
s
.57326 .30901 m
.57326 .31276 L
s
.60989 .30901 m
.60989 .31276 L
s
.64652 .30901 m
.64652 .31276 L
s
.71978 .30901 m
.71978 .31276 L
s
.75641 .30901 m
.75641 .31276 L
s
.79304 .30901 m
.79304 .31276 L
s
.8663 .30901 m
.8663 .31276 L
s
.90293 .30901 m
.90293 .31276 L
s
.93956 .30901 m
.93956 .31276 L
s
.06044 .30901 m
.06044 .31276 L
s
.02381 .30901 m
.02381 .31276 L
s
.25 Mabswid
0 .30901 m
1 .30901 L
s
.24359 .06129 m
.24984 .06129 L
s
[(-4)] .23109 .06129 1 0 Mshowa
.24359 .18515 m
.24984 .18515 L
s
[(-2)] .23109 .18515 1 0 Mshowa
.24359 .43288 m
.24984 .43288 L
s
[(2)] .23109 .43288 1 0 Mshowa
.24359 .55674 m
.24984 .55674 L
s
[(4)] .23109 .55674 1 0 Mshowa
.125 Mabswid
.24359 .09225 m
.24734 .09225 L
s
.24359 .12322 m
.24734 .12322 L
s
.24359 .15418 m
.24734 .15418 L
s
.24359 .21612 m
.24734 .21612 L
s
.24359 .24708 m
.24734 .24708 L
s
.24359 .27805 m
.24734 .27805 L
s
.24359 .33998 m
.24734 .33998 L
s
.24359 .37095 m
.24734 .37095 L
s
.24359 .40191 m
.24734 .40191 L
s
.24359 .46384 m
.24734 .46384 L
s
.24359 .49481 m
.24734 .49481 L
s
.24359 .52578 m
.24734 .52578 L
s
.24359 .03032 m
.24734 .03032 L
s
.24359 .58771 m
.24734 .58771 L
s
.25 Mabswid
.24359 0 m
.24359 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .08557 m
.02726 .22964 L
.03104 .41602 L
.03295 .49807 L
.034 .5352 L
.03499 .56368 L
.03591 .58367 L
.03644 .59197 L
.03692 .59766 L
.03732 .60093 L
.03777 .60293 L
.03823 .6032 L
.03867 .60177 L
.03892 .60022 L
.03919 .59797 L
.03967 .59242 L
.04024 .58334 L
.04076 .57284 L
.04178 .54618 L
.04275 .51445 L
.04648 .34897 L
.05056 .15252 L
.05262 .07637 L
.05318 .06014 L
.05378 .0453 L
.05435 .03393 L
.05488 .02569 L
.05536 .02011 L
.0556 .01803 L
.05587 .01631 L
.05614 .01522 L
.05643 .01472 L
.0567 .01491 L
.05695 .01565 L
.05741 .01837 L
.05791 .02338 L
.05816 .02669 L
.05843 .03082 L
.05891 .03972 L
.05991 .06358 L
.06084 .09257 L
.0626 .16096 L
.06598 .32376 L
.0697 .49524 L
.07063 .52895 L
.07163 .55898 L
.07212 .57095 L
.07258 .58066 L
.07303 .58859 L
.07344 .59434 L
Mistroke
.07392 .59925 L
.07442 .60238 L
.07489 .60332 L
.07534 .60248 L
.07559 .60126 L
.07585 .59938 L
.07633 .59455 L
.07684 .58724 L
.0774 .57681 L
.07833 .5542 L
.07917 .52825 L
.08107 .45433 L
.0845 .28906 L
.08807 .1247 L
.08987 .06393 L
.09036 .0511 L
.09089 .03932 L
.09139 .0303 L
.09185 .02371 L
.09236 .01855 L
.09262 .0167 L
.09291 .01538 L
.09321 .01475 L
.09349 .01486 L
.09375 .01554 L
.09402 .0169 L
.09452 .02103 L
.09478 .02392 L
.09505 .0277 L
.096 .04538 L
.09696 .07016 L
.09799 .10378 L
.09984 .17956 L
.10375 .37069 L
.10581 .46605 L
.10694 .51083 L
.108 .54612 L
.10892 .57042 L
.10939 .58046 L
.10991 .58944 L
.11045 .59641 L
.11074 .59921 L
.11101 .60117 L
.1115 .60311 L
.11177 .60331 L
.11202 .60293 L
.1125 .60073 L
.11294 .59698 L
.11342 .591 L
.11393 .58258 L
Mistroke
.11479 .56377 L
.11574 .53675 L
.11989 .36064 L
.12384 .16873 L
.12555 .10008 L
.12649 .06963 L
.12738 .04658 L
.12788 .03609 L
.12843 .02703 L
.12892 .02091 L
.12938 .01711 L
.12981 .01514 L
.13029 .01481 L
.13078 .01652 L
.13124 .01998 L
.13172 .02551 L
.13217 .03233 L
.13318 .05359 L
.13407 .0786 L
.13501 .11095 L
.13844 .26436 L
.14216 .44532 L
.14318 .48833 L
.14425 .52775 L
.14517 .556 L
.14568 .56894 L
.14616 .57936 L
.14663 .58775 L
.14713 .59485 L
.14759 .59946 L
.14802 .60213 L
.14842 .60325 L
.14885 .6029 L
.14931 .60078 L
.14974 .59718 L
.15025 .59095 L
.15073 .58309 L
.15163 .56344 L
.1526 .5356 L
.15366 .49824 L
.15728 .33252 L
.16069 .16751 L
.1626 .09218 L
.16368 .05944 L
.16419 .04678 L
.16467 .03678 L
.16511 .02918 L
.16551 .02363 L
.16595 .01902 L
.16642 .01591 L
Mistroke
.16688 .01473 L
.16738 .01547 L
.16784 .01809 L
.16827 .02215 L
.16874 .02824 L
.16924 .03676 L
.17014 .05711 L
.17121 .089 L
.17219 .12467 L
.17635 .31845 L
.17988 .48352 L
.1809 .52182 L
.18186 .55207 L
.18272 .57373 L
.1832 .58339 L
.18365 .59074 L
.18415 .59696 L
.18441 .59941 L
.18469 .60138 L
.18499 .60271 L
.18527 .60328 L
.18552 .60321 L
.1858 .60252 L
.1863 .59962 L
.18655 .59735 L
.18683 .59423 L
.18732 .58716 L
.18778 .57874 L
.18874 .55584 L
.18963 .52898 L
.19162 .45126 L
.19513 .28093 L
.19707 .18756 L
.19889 .11126 L
.19993 .076 L
.20047 .0603 L
.20105 .04602 L
.20154 .03597 L
.20207 .0271 L
.20256 .02106 L
.20301 .01721 L
.20351 .01502 L
.20398 .01489 L
.2044 .01638 L
.20486 .01974 L
.20536 .0254 L
.2059 .03369 L
.20685 .05424 L
.20786 .08311 L
.20892 .12075 L
Mistroke
.21082 .20253 L
.2151 .41287 L
.21689 .49077 L
.21787 .52688 L
.2188 .55543 L
.21933 .56888 L
.2199 .58111 L
.22038 .58932 L
.22065 .59316 L
.2209 .59622 L
.22139 .60061 L
.22165 .60205 L
.22192 .603 L
.22241 .60311 L
.22286 .6014 L
.22335 .59755 L
.22382 .59205 L
.22424 .58559 L
.22469 .57702 L
.2257 .55205 L
.22664 .52259 L
.23015 .3712 L
.23214 .27204 L
.23427 .1706 L
.23521 .13068 L
.23624 .0925 L
.23713 .06484 L
.23764 .05156 L
.23812 .04083 L
.23861 .03155 L
.23907 .02478 L
.23955 .01943 L
.23981 .01742 L
.24008 .0159 L
.24053 .01474 L
.24094 .01521 L
.2414 .01745 L
.24189 .02182 L
.24234 .02753 L
.24282 .03556 L
.2437 .05485 L
.24534 .10582 L
.24735 .18902 L
.24947 .29215 L
.25146 .39102 L
.25329 .47352 L
.25417 .50846 L
.25514 .54135 L
.25607 .56687 L
.25691 .58447 L
Mistroke
.25741 .59235 L
.25788 .59785 L
.25839 .60162 L
.25867 .6028 L
.25893 .60328 L
.25936 .60281 L
.25984 .60042 L
.26034 .59588 L
.2608 .58976 L
.26124 .5824 L
.26171 .57267 L
.26258 .55059 L
.2642 .49553 L
.26784 .32814 L
.26973 .23415 L
.27176 .14174 L
.2727 .10535 L
.27369 .07267 L
.27454 .04976 L
.27545 .03134 L
.27595 .02406 L
.2764 .01924 L
.27685 .01612 L
.27728 .0148 L
.27778 .01525 L
.27825 .01757 L
.27875 .0222 L
.27901 .02535 L
.27929 .02944 L
.28035 .05044 L
.28148 .0823 L
.28353 .16029 L
.28743 .34871 L
.28948 .44659 L
.29061 .49384 L
.29168 .53208 L
.29269 .56176 L
.29322 .57439 L
.29378 .58535 L
.29426 .59263 L
.29451 .59573 L
.29478 .59847 L
.29525 .60182 L
.29569 .60322 L
.29617 .60286 L
.29644 .60179 L
.29669 .60024 L
.29715 .59602 L
.29763 .58963 L
.29848 .57401 L
Mistroke
.29941 .55046 L
.30355 .3833 L
.30749 .18974 L
.3092 .11732 L
.31014 .08412 L
.31103 .0581 L
.31153 .04581 L
.31208 .0347 L
.31258 .02667 L
.31303 .02106 L
.31346 .01737 L
.31394 .01514 L
.31443 .01485 L
.31489 .01647 L
.31537 .02008 L
.31582 .02514 L
.31631 .03258 L
.31682 .04258 L
.31769 .06398 L
.31865 .09385 L
.32208 .24059 L
.32611 .43747 L
.32787 .51012 L
.3288 .54161 L
.3298 .56876 L
.3303 .57971 L
.33078 .5882 L
.33121 .59425 L
.33167 .5991 L
.33211 .60201 L
.33258 .60329 L
.33298 .6029 L
.33342 .6009 L
.33391 .59668 L
.33437 .59101 L
.33489 .58238 L
.33539 .57216 L
.33723 .51845 L
.33922 .43764 L
.34107 .34932 L
.34308 .24892 L
.34525 .1486 L
.34628 .10788 L
.34737 .07165 L
.3483 .04715 L
.34883 .03602 L
.34932 .02785 L
.34981 .02155 L
.35028 .01745 L
.35077 .01512 L
Mistroke
.35104 .01472 L
.3513 .01493 L
.35173 .01652 L
.3522 .02008 L
.35269 .02578 L
.35315 .03294 L
.35403 .05122 L
.35495 .07664 L
.3566 .13588 L
.36031 .31036 L
.36399 .48283 L
.36504 .52266 L
.36604 .55389 L
.36694 .5759 L
.36744 .58554 L
.36791 .59271 L
.36832 .59749 L
.36876 .60106 L
.36925 .60308 L
.3697 .60313 L
.37016 .60138 L
.37067 .59738 L
.37115 .59164 L
.37159 .58464 L
.37245 .56654 L
.37323 .54536 L
.37498 .48344 L
.39011 .03536 L
Mfstroke
.39011 .03536 m
.391 .05136 L
.39197 .06778 L
.39289 .08228 L
.39377 .09543 L
.3947 .10864 L
.3956 .12061 L
.39656 .1326 L
.39748 .14348 L
.39836 .15335 L
.39931 .16326 L
.40022 .17226 L
.40109 .18045 L
.40202 .18868 L
.40291 .19618 L
.40386 .2037 L
.40478 .21056 L
.40566 .2168 L
.4066 .2231 L
.4075 .22885 L
.40846 .23464 L
.40939 .23993 L
.41028 .24477 L
.41122 .24968 L
.41209 .25396 L
s
.41209 .25396 m
.4174 .29744 L
.42045 .32922 L
.42323 .35368 L
.42395 .35863 L
.42474 .36314 L
.42548 .36651 L
.42617 .3688 L
.42689 .37034 L
.4273 .3708 L
.42769 .37095 L
.42847 .37043 L
.42891 .36966 L
.42931 .36867 L
.43003 .36618 L
.4307 .36309 L
.43221 .35358 L
.43497 .32921 L
.43796 .29807 L
.43953 .28231 L
.44119 .26775 L
.44265 .25767 L
.44347 .25332 L
.44424 .25025 L
.44495 .24832 L
.4456 .24733 L
.44634 .24713 L
.44705 .24786 L
.44744 .24863 L
.44787 .2498 L
.44873 .25311 L
.44953 .25727 L
.45029 .26205 L
.45381 .29307 L
.45673 .32366 L
.45828 .33885 L
.45993 .35277 L
.46074 .35841 L
.46151 .36287 L
.4622 .36608 L
.46295 .36868 L
.46365 .37025 L
.46441 .37093 L
.46505 .37071 L
.46575 .36962 L
.46616 .36858 L
.46655 .36733 L
.46728 .36429 L
.46806 .36007 L
.46892 .35442 L
Mistroke
.47188 .32834 L
.4746 .30002 L
.47602 .28551 L
.47753 .27172 L
.47885 .26161 L
.47955 .25721 L
.4803 .25331 L
.48099 .25052 L
.48162 .24868 L
.48225 .24753 L
.48284 .24709 L
.48358 .24745 L
.48396 .248 L
.48437 .24889 L
.4851 .2512 L
.48578 .25417 L
.48732 .2635 L
.48897 .277 L
.49452 .33332 L
.49616 .3481 L
.49768 .35914 L
.49845 .36347 L
.49927 .36705 L
.49974 .36859 L
.50018 .3697 L
.50058 .37039 L
.50101 .37083 L
.50172 .37083 L
.50213 .37041 L
.50251 .36976 L
.50328 .36766 L
.50371 .36605 L
.5041 .3643 L
.50556 .3557 L
.50695 .34487 L
.51266 .28739 L
.51404 .27439 L
.51554 .26254 L
.5164 .25708 L
.51718 .25303 L
.51794 .2501 L
.51831 .249 L
.51873 .24807 L
.51946 .24717 L
.52016 .24721 L
.52078 .24799 L
.52146 .24962 L
.52219 .25229 L
.52297 .25609 L
.52437 .26521 L
Mistroke
.52688 .28727 L
.52963 .3159 L
.53111 .331 L
.53271 .34586 L
.53413 .35671 L
.53491 .36152 L
.53564 .3652 L
.53636 .36797 L
.53714 .36996 L
.53784 .37084 L
.53849 .37086 L
.53911 .37018 L
.53978 .36867 L
.54048 .36625 L
.54114 .36326 L
.54274 .35315 L
.54426 .34054 L
.54711 .312 L
.55015 .28092 L
.55177 .26696 L
.55261 .26084 L
.55351 .2555 L
.55424 .25201 L
.55463 .25053 L
.55505 .24924 L
.55578 .24769 L
.55646 .2471 L
.55721 .24742 L
.55791 .24863 L
.55855 .25047 L
.55923 .25323 L
.55996 .25701 L
.56077 .26211 L
.56239 .27498 L
.56531 .30379 L
.56803 .33196 L
.56953 .34576 L
.57095 .35666 L
.57227 .36429 L
.57301 .36739 L
.5737 .36942 L
.57435 .37055 L
.57492 .37094 L
.57559 .37064 L
.57622 .36963 L
.57691 .36771 L
.57766 .36474 L
.57899 .3572 L
.58058 .34502 L
.58203 .33163 L
Mistroke
.58496 .30117 L
.58651 .28542 L
.58815 .27052 L
.58954 .26019 L
.59028 .25578 L
.59107 .25199 L
.5918 .24944 L
.59247 .2479 L
.59314 .24716 L
.59378 .2472 L
.59441 .24797 L
.5951 .24959 L
.59574 .25185 L
.59632 .2545 L
.59775 .26322 L
.5991 .27393 L
.60488 .3322 L
.60628 .34517 L
.60779 .35677 L
.60865 .36204 L
.60944 .36586 L
.60982 .36733 L
.61023 .36865 L
.61099 .3703 L
.61166 .37092 L
.61229 .37076 L
.61299 .36975 L
.61374 .3677 L
.61448 .36473 L
.61527 .36063 L
.61667 .35106 L
.61918 .32837 L
.62193 .29971 L
.62343 .2845 L
.62505 .26985 L
.6258 .26408 L
.62659 .25875 L
.62727 .25489 L
.62801 .25155 L
.62872 .24918 L
.62937 .24778 L
.63002 .24713 L
.63064 .24722 L
.63136 .24819 L
.63202 .24991 L
.63276 .25267 L
.63354 .25658 L
.63515 .2675 L
.63689 .28278 L
.64005 .31526 L
Mistroke
.64152 .33039 L
.6431 .34508 L
.64446 .35572 L
.64518 .36035 L
.64594 .36441 L
.64632 .36607 L
.64673 .36762 L
.64746 .36965 L
.6482 .37076 L
.64889 .3709 L
.64957 .3702 L
.65019 .36885 L
.65087 .3666 L
.65158 .3634 L
.65312 .35389 L
.65454 .3423 L
.65777 .31003 L
.66088 .27857 L
.6624 .26572 L
.66381 .25644 L
.6646 .25252 L
.665 .25092 L
.66543 .2495 L
.66586 .2484 L
.66627 .24767 L
.66675 .24718 L
.66719 .24709 L
.66794 .24776 L
.66837 .24859 L
.66876 .24963 L
.66948 .25225 L
.67025 .25598 L
.67166 .2651 L
.67314 .27742 L
.67579 .30386 L
.67888 .33565 L
.68039 .34901 L
.68177 .35889 L
.68238 .36247 L
.68305 .36568 L
.68368 .36803 L
.68426 .3696 L
.68488 .37062 L
.68556 .37094 L
.68627 .3704 L
.68693 .36907 L
.68766 .36673 L
.68835 .36367 L
.68966 .35591 L
.69106 .345 L
Mistroke
.69259 .33077 L
.69547 .3008 L
.69699 .28536 L
.69859 .27079 L
.69999 .26032 L
.70074 .25587 L
.70153 .25205 L
.70227 .24946 L
.70293 .24792 L
.70361 .24716 L
.70424 .24719 L
.70462 .24755 L
.70503 .24823 L
.70546 .24927 L
.70586 .25054 L
.70659 .25349 L
.70736 .25761 L
.70913 .27022 L
.71076 .2849 L
.71361 .31442 L
.71518 .33055 L
.71667 .34439 L
.71813 .35583 L
.7189 .36074 L
.71971 .36495 L
.72039 .36767 L
.72115 .36974 L
.72183 .37074 L
.72247 .37092 L
.72317 .37027 L
.72384 .36886 L
.72443 .36693 L
.72508 .36415 L
.72653 .35555 L
.72788 .34503 L
.73092 .31534 L
.7342 .28166 L
.7357 .26842 L
.73653 .26228 L
.73729 .25737 L
.738 .25362 L
.73865 .2509 L
.73937 .24872 L
.74014 .24739 L
.7409 .24711 L
.74128 .24736 L
.7417 .24794 L
.74244 .24974 L
.74314 .25229 L
.74396 .2563 L
Mistroke
.74471 .26089 L
.7464 .27396 L
.74923 .30168 L
.75232 .33363 L
.75374 .34653 L
.75525 .35786 L
.75599 .36224 L
.75668 .3656 L
.7573 .36795 L
.75798 .36974 L
.75862 .37071 L
.75934 .37091 L
.76008 .37014 L
.76077 .36853 L
.76142 .36627 L
.76202 .36359 L
.76335 .35558 L
.7647 .34503 L
.76619 .33118 L
.76922 .29978 L
.77205 .27239 L
.77329 .26272 L
.77465 .25451 L
.77541 .25113 L
.77613 .24888 L
.77689 .24747 L
.77731 .24713 L
.77769 .2471 L
.77812 .24738 L
.77851 .24791 L
.77893 .24881 L
.77939 .25011 L
.78015 .25308 L
.78098 .25744 L
.78247 .26766 L
.78406 .28155 L
.78694 .31098 L
.78984 .34016 L
.79143 .35338 L
.79293 .36287 L
.79379 .36674 L
.79427 .36839 L
.79471 .36955 L
.79508 .37026 L
.79549 .37075 L
.79592 .37095 L
.79632 .37083 L
.79673 .37041 L
.79712 .36974 L
.79784 .36778 L
Mistroke
.79862 .36466 L
.79947 .36016 L
.8009 .35024 L
.80247 .3365 L
.80565 .30385 L
.80839 .27666 L
.80993 .264 L
.81069 .25891 L
.81137 .25501 L
.81205 .25188 L
.81278 .24934 L
.81356 .24768 L
.81429 .24709 L
.81507 .24752 L
.81546 .24814 L
.81589 .24914 L
.81665 .2517 L
.81736 .25496 L
.81874 .26352 L
.82 .27356 L
.82284 .30129 L
.82588 .33272 L
.82748 .34729 L
.82836 .35413 L
.82918 .35964 L
.82997 .36397 L
.83039 .36585 L
.83082 .36752 L
.8316 .36969 L
.83231 .37074 L
.83302 .37089 L
.83369 .37021 L
.83442 .36855 L
.8352 .36575 L
.84091 .32031 L
.84404 .28777 L
.84557 .27348 L
.84697 .26249 L
.8477 .25778 L
.84849 .25355 L
.84893 .25166 L
.84933 .25018 L
.84972 .24904 L
.85013 .2481 L
.85059 .24742 L
.85101 .24711 L
.85143 .24713 L
.85182 .24743 L
.85223 .24805 L
.85269 .24909 L
Mistroke
.85317 .25056 L
.85361 .25228 L
.85516 .26073 L
.85657 .27138 L
.85975 .30212 L
.86257 .33138 L
.86411 .34566 L
.86556 .35678 L
.86638 .36178 L
.86712 .36547 L
.86752 .36706 L
.86795 .3685 L
.86839 .36962 L
.86885 .37043 L
.86961 .37095 L
.87004 .37078 L
.87042 .37035 L
.87118 .36873 L
.87189 .36631 L
.87255 .36328 L
.87328 .35915 L
.87476 .3485 L
.87741 .3237 L
.88027 .29375 L
.88189 .27795 L
.88339 .26538 L
.88489 .2557 L
.88572 .25177 L
.88648 .2492 L
.88721 .24768 L
.88762 .24723 L
.88799 .24708 L
.88868 .24748 L
.88941 .24882 L
.89007 .25083 L
.89077 .25378 L
.89204 .26106 L
.89354 .27259 L
.89491 .28519 L
.89803 .31751 L
.89974 .33478 L
.90134 .34903 L
.9027 .35884 L
.9034 .36287 L
.90417 .36639 L
.90455 .36779 L
.90496 .36901 L
.90539 .36998 L
.9058 .37058 L
.90658 .37093 L
Mistroke
.90729 .37029 L
.90799 .36876 L
.90874 .36619 L
.90938 .36327 L
.91008 .3593 L
.91165 .34797 L
.91311 .33487 L
.91861 .27893 L
.9202 .2655 L
.92099 .26001 L
.92171 .25571 L
.92236 .25257 L
.92307 .2499 L
.92378 .24809 L
.92455 .24716 L
.92495 .24709 L
.92537 .24733 L
.92612 .24856 L
.92655 .24968 L
.92694 .251 L
.92783 .25494 L
.92932 .26428 L
.93091 .27744 L
.93697 .33861 L
.93863 .35263 L
.93954 .35889 L
.94039 .36367 L
.94111 .36684 L
.94189 .36927 L
.94233 .37018 L
.94275 .37072 L
.94313 .37093 L
.94354 .37087 L
.94393 .37054 L
.94435 .36987 L
.94511 .36787 L
.94585 .36496 L
.94654 .3615 L
.94809 .35106 L
.94973 .33686 L
.95273 .30615 L
.95547 .27859 L
.95674 .26768 L
.95813 .25804 L
.95876 .25454 L
.95944 .25152 L
.96001 .24954 L
.96064 .24802 L
.96136 .24717 L
.96202 .2472 L
Mistroke
.96274 .24812 L
.9635 .2501 L
.96417 .25264 L
.96479 .25565 L
.96619 .26461 L
.96872 .28679 L
.97103 .31061 L
.97619 .3578 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{410, 253.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006J0000oA000`40O003h00OHgoo00<007ooOol0
ogoo=Goo001SOol00`00Oomoo`3oOoleOol006=oo`03001oogoo0?moocEoo`00Hgoo00<007ooOol0
ogoo=Goo001SOol00`00Oomoo`3oOoleOol006=oo`03001oogoo0?moocEoo`005goo00<007ooOol0
37oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo0P003Goo00<0
07ooOol037oo00<007ooOol037oo00<007ooOol0ogoo2Goo000GOol00`00Oomoo`0<Ool00`00Oomo
o`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool2000=Ool00`00Oomoo`0<Ool0
0`00Oomoo`0<Ool00`00Oomoo`3oOol9Ool001Moo`03001oogoo00aoo`8000eoo`03001oogoo00ao
o`03001oogoo00aoo`8000eoo`8000eoo`8000eoo`8000eoo`800?moo`Yoo`005goo0P0037oo00<0
07oo00003Goo00<007ooOol02goo00<007oo00003Goo0P003Goo0P003Goo0P003Goo0P003Goo0P00
ogoo2Woo000FOol00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool0
0`00Ool0000=Ool2000=Ool2000=Ool2000=Ool2003oOol:Ool001Ioo`03001oo`0000aoo`03001o
o`0000aoo`03001oo`0000aoo`03001oo`0000aoo`03001oo`0000eoo`8000eoo`8000eoo`8000eo
o`800?moo`Yoo`005Woo00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo0000
37oo00<007oo000037oo00<007oo000037oo00<007oo00003Goo0P003Goo0P00ogoo2Woo000FOol0
0`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool0
0`00Ool00002000:Ool00`00Ool0000<Ool00`00Ool0000=Ool2003oOol:Ool001Ioo`03001oo`00
00aoo`03001oo`0000aoo`03001oo`0000aoo`03001oo`0000aoo`03001oo`0000aoo`03001oo`00
00aoo`03001oo`0000aoo`03001oo`0000aoo`03001oo`000?moo`Yoo`005Woo00<007oo000037oo
00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo000037oo
00<007oo000037oo00<007oo000037oo00<007oo00003Woo00<007ooOol0n7oo000FOol00`00Ool0
000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0
000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000>Ool00`00Oomoo`3hOol001Ioo`03
001oo`0000aoo`03001oo`0000aoo`03001oo`0000aoo`03001oo`0000aoo`03001oo`0000aoo`03
001oo`0000aoo`03001oo`0000aoo`03001oo`0000aoo`03001oo`0000ioo`03001oogoo0?Qoo`00
5Woo00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo0000
37oo00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo00003Woo0P00nGoo000F
Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<
Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000>Ool2003iOol001Io
o`03001oo`0000aoo`03001oo`0000aoo`03001oo`0000aoo`03001oo`0000aoo`03001oo`0000ao
o`03001oo`0000aoo`03001oo`0000aoo`03001oo`0000aoo`03001oo`0000ioo`800?Uoo`005Woo
00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo00001Goo
0`0017oo00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo00003Woo0P00nGoo
000FOol00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0
0006Ool00`00Oomoo`03Ool00`00Ool0000<Ool00`00Ool0000<Ool01000Oomoo`002goo00<007oo
00003Woo0P00nGoo000FOol00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0
000<Ool00`00Ool00006Ool00`00Oomoo`03Ool00`00Ool0000<Ool00`00Ool0000<Ool01000Oomo
o`002goo00<007oo00003Woo0P00nGoo000FOol00`00Ool0000<Ool01000Oomoo`002goo00<007oo
000037oo00<007oo000037oo00<007oo00000Woo1P0017oo00<007oo000037oo00<007oo000037oo
00@007ooOol000]oo`03001oo`0000ioo`800?Uoo`005Woo00<007oo000037oo00@007ooOol000]o
o`03001oo`0000aoo`03001oo`0000Qoo`L0009oo`05001oogooOol00005Ool00`00Ool000030009
Ool00`00Ool0000<Ool01000Oomoo`002goo00<007oo00003Woo0P00nGoo000FOol00`00Ool0000<
Ool01000Oomoo`002goo00<007oo000037oo00<007oo000037oo00<007oo00000goo00@007ooOol0
00Eoo`03001oo`0000aoo`03001oo`0000aoo`04001oogoo000;Ool00`00Ool0000>Ool2003iOol0
01Ioo`03001oo`0000aoo`04001oogoo000;Ool01000Oomoo`002goo00<007oo000037oo00<007oo
000017oo00<007oo00001Goo00<007oo000037oo00<007oo000037oo00@007ooOol000]oo`04001o
ogoo000=Ool2003iOol001Eoo`04001oogoo000<Ool01000Oomoo`002goo00@007ooOol000]oo`03
001oo`0000aoo`04001oogoo0003Ool00`00Ool00005Ool00`00Ool0000<Ool01000Oomoo`002goo
00@007ooOol000]oo`04001oogoo000=Ool2003iOol001Eoo`04001oogoo000<Ool01000Oomoo`00
2goo00@007ooOol000]oo`03001oo`0000aoo`04001oogoo0004Ool20005Ool00`00Ool0000<Ool0
1000Oomoo`002goo00@007ooOol000]oo`04001oogoo000=Ool2003iOol001Eoo`04001oogoo000<
Ool01000Oomoo`002goo00@007ooOol000]oo`03001oo`0000aoo`04001oogoo0005Ool00`00Oomo
o`03Ool00`00Ool0000<Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000=Ool2003i
Ool001Eoo`04001oogoo000<Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool0
1000Oomoo`002goo00<007oo000037oo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`00
37oo00<007oo0000nGoo000EOol01@00Oomoogoo00002goo00@007ooOol000]oo`04001oogoo000:
Ool01@00Oomoogoo00002goo00@007ooOol000]oo`03001oo`0000aoo`04001oogoo000;Ool01000
Oomoo`002goo00@007ooOol000aoo`03001oo`000?Uoo`005Goo00D007ooOomoo`0000]oo`04001o
ogoo000;Ool01000Oomoo`002Woo00D007ooOomoo`0000]oo`04001oogoo000:Ool00`00Oomoo`02
000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000<Ool00`00Ool0003iOol001Eo
o`05001oogooOol0000;Ool01000Oomoo`002goo00@007ooOol000Yoo`05001oogooOol0000;Ool0
1000Oomoo`002Woo00<007ooOol00P002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomo
o`0037oo00<007oo0000nGoo000:Ool00`00Oomoo`08Ool01@00Oomoogoo00002goo00@007ooOol0
00Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002goo00@007ooOol000Yoo`03001oogoo0080
00]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000aoo`03001oo`000?Uoo`002Woo
00<007ooOol027oo00D007ooOomoo`0000]oo`04001oogoo000:Ool01@00Oomoogoo00002Woo00D0
07ooOomoo`0000]oo`04001oogoo000:Ool00`00Oomoo`02000;Ool01000Oomoo`002goo00@007oo
Ool000]oo`04001oogoo000<Ool00`00Ool0003iOol000Yoo`03001oogoo00Qoo`05001oogooOol0
000;Ool01000Oomoo`002Woo00D007ooOomoo`0000Yoo`05001oogooOol0000;Ool01000Oomoo`00
2Woo00<007ooOol00P002Woo00D007ooOomoo`0000]oo`04001oogoo000:Ool01@00Oomoogoo0000
37oo00@007ooOol00?Qoo`002Woo00<007ooOol027oo00D007ooOomoo`0000]oo`04001oogoo000:
Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000]oo`04001oogoo000:Ool00`00Oomoo`030009
Ool01@00Oomoogoo00002goo00@007ooOol000Yoo`05001oogooOol0000<Ool01000Oomoo`00n7oo
000:Ool00`00Oomoo`08Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001oogooOol0
000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`03001oogoo008000Yoo`05001oogoo
Ool0000;Ool01000Oomoo`002Woo00D007ooOomoo`0000aoo`04001oogoo003hOol000Yoo`03001o
ogoo00Qoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001o
ogooOol0000:Ool01@00Oomoogoo00002Woo00<007ooOol00P002Woo00D007ooOomoo`0000]oo`04
001oogoo000:Ool01@00Oomoogoo000037oo00@007ooOol00?Qoo`002Woo00<007ooOol027oo00D0
07ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yo
o`05001oogooOol0000:Ool00`00Oomoo`02000:Ool01@00Oomoogoo00002goo00@007ooOol000Yo
o`05001oogooOol0000<Ool01000Oomoo`00n7oo000:Ool00`00Oomoo`08Ool01@00Oomoogoo0000
2Woo00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomo
o`0000Yoo`03001oogoo008000Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007oo
Oomoo`0000aoo`04001oogoo003hOol000Yoo`03001oogoo00Qoo`05001oogooOol0000:Ool01@00
Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo
00<007ooOol00P002Woo00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo0000
37oo00@007ooOol00?Qoo`002Woo00<007ooOol027oo00D007ooOomoo`0000Yoo`05001oogooOol0
000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool00`00Oomo
o`02000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001oogooOol0000<Ool01000
Oomoo`00n7oo000:Ool00`00Oomoo`08Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05
001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`03001oogoo008000Yo
o`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000aoo`04001oogoo003h
Ool000Yoo`03001oogoo00Qoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomo
o`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00<007ooOol00P002Woo00D007oo
Oomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo000037oo00@007ooOol00?Qoo`002Woo
00<007ooOol027oo00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo
00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool00`00Oomoo`02000:Ool01@00Oomoogoo0000
2Woo00D007ooOomoo`0000Yoo`05001oogooOol0000<Ool01000Oomoo`00n7oo000:Ool00`00Oomo
o`08Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomo
ogoo00002Woo00D007ooOomoo`0000Yoo`03001oogoo008000Yoo`05001oogooOol0000:Ool01@00
Oomoogoo00002Woo00D007ooOomoo`0000aoo`04001oogoo003hOol000Yoo`03001oogoo00Qoo`05
001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001oogooOol0000:
Ool01@00Oomoogoo00002Woo00<007ooOol00P002Woo00D007ooOomoo`0000Yoo`05001oogooOol0
000:Ool01@00Oomoogoo000037oo00@007ooOol00?Qoo`002Woo00<007ooOol027oo00D007ooOomo
o`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001o
ogooOol0000:Ool00`00Oomoo`02000:Ool00`00Oomoo`02Ool00`00Oomoo`07Ool01@00Oomoogoo
00002Woo00D007ooOomoo`0000aoo`04001oogoo003hOol000Yoo`03001oogoo00Qoo`05001oogoo
Ool0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00
Oomoogoo00002Woo00<007ooOol00`002Goo00<007ooOol00Woo00<007ooOol01goo00D007ooOomo
o`0000Yoo`05001oogooOol0000<Ool01000Oomoo`00n7oo000:Ool00`00Oomoo`08Ool01@00Oomo
ogoo00002Woo00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D0
07ooOomoo`0000Yoo`03001oogoo008000Yoo`03001oogoo009oo`03001oogoo00Moo`05001oogoo
Ool0000:Ool01@00Oomoogoo000037oo00D007ooOomoo`000?Moo`002Woo00<007ooOol027oo00D0
07ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yo
o`05001oogooOol0000:Ool00`00Oomoo`02000:Ool00`00Oomoo`02Ool00`00Oomoo`07Ool01@00
Oomoogoo00002Woo00D007ooOomoo`0000aoo`05001oogooOol0003gOol000Yoo`03001oogoo00Qo
o`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001oogooOol0
000:Ool01@00Oomoogoo00002Woo00<007ooOol00P002Woo00<007ooOol00Woo00<007ooOol01goo
00D007ooOomoo`0000Yoo`05001oogooOol0000<Ool01@00Oomoogoo0000mgoo000:Ool00`00Oomo
o`08Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Uoo`03001oogoo009oo`03001oogoo00Qo
o`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00<007ooOol00P002Woo00<007ooOol00Woo
00<007ooOol01goo00D007ooOomoo`0000Yoo`05001oogooOol0000<Ool01@00Oomoogoo0000mgoo
000:Ool00`00Oomoo`08Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Uoo`03001oogoo009o
o`03001oogoo00Qoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00<007ooOol00P002Woo
00<007ooOol00Woo00<007ooOol01goo00D007ooOomoo`0000Yoo`05001oogooOol0000<Ool01@00
Oomoogoo0000mgoo000:Ool00`00Oomoo`08Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Uo
o`03001oogoo009oo`03001oogoo00Qoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00<0
07ooOol00P002Woo00<007ooOol00Woo00<007ooOol01goo00D007ooOomoo`0000Yoo`05001oogoo
Ool0000<Ool01@00Oomoogoo0000mgoo000:Ool00`00Oomoo`08Ool01@00Oomoogoo00002Woo00D0
07ooOomoo`0000Uoo`03001oogoo009oo`03001oogoo00Qoo`05001oogooOol0000:Ool01@00Oomo
ogoo00002Woo00<007ooOol00P002Woo00<007ooOol00Woo00<007ooOol01goo00D007ooOomoo`00
00Yoo`05001oogooOol0000<Ool01@00Oomoogoo0000mgoo000:Ool00`00Oomoo`08Ool01@00Oomo
ogoo00002Woo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol00Woo00<007ooOol027oo00D0
07ooOomoo`0000Yoo`05001oogooOol0000:Ool00`00Oomoo`02000:Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000aoo`05001oogooOol0003gOol000Yo
o`03001oogoo00Qoo`05001oogooOol0000:Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomo
o`02Ool00`00Oomoo`08Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`06001oogoo001o
o`002Goo00<007ooOol00Woo00<007ooOol01goo00D007ooOomoo`0000Yoo`05001oogooOol0000<
Ool01@00Oomoogoo0000mgoo000:Ool00`00Oomoo`08Ool01@00Oomoogoo00002Woo00<007ooOol0
0Woo00<007ooOol01Woo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Yoo`05001o
ogooOol0000:Ool01P00Oomoo`00Ool000Uoo`03001oogoo009oo`03001oogoo00Moo`05001oogoo
Ool0000:Ool01@00Oomoogoo00002goo00<007ooOol00goo00<007ooOol0m7oo000:Ool00`00Oomo
o`08Ool01@00Oomoogoo00002Woo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol00Woo00<0
07ooOol027oo00D007ooOomoo`0000Uoo`03001oogoo009oo`03001oogoo00Qoo`06001oogoo001o
o`002Goo00<007ooOol00Woo00<007ooOol01goo00D007ooOomoo`0000Yoo`05001oogooOol0000;
Ool00`00Oomoo`03Ool00`00Oomoo`3dOol000Yoo`03001oogoo00Qoo`05001oogooOol0000:Ool0
0`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo0000
2Goo00<007ooOol00Woo00<007ooOol027oo00<007ooOol00`002Goo00<007ooOol00Woo00<007oo
Ool01Woo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000]oo`03001oogoo00=oo`03
001oogoo0?Aoo`002Woo00<007ooOol027oo00D007ooOomoo`0000Yoo`03001oogoo009oo`03001o
ogoo00Ioo`03001oogoo009oo`03001oogoo00Qoo`05001oogooOol00009Ool00`00Oomoo`02Ool0
0`00Oomoo`08Ool01P00Oomoo`00Ool000Uoo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo
009oo`03001oogoo00Qoo`05001oogooOol0000;Ool00`00Oomoo`03Ool00`00Oomoo`3dOol000]o
o`03001oogoo00Moo`05001oogooOol0000:Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomo
o`02Ool00`00Oomoo`08Ool01@00Oomoogoo00002Goo00<007ooOol00Woo00<007ooOol027oo00H0
07ooOol007oo0009Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`08
Ool01@00Oomoogoo00002goo00<007ooOol00goo00<007ooOol0m7oo000;Ool00`00Oomoo`07Ool0
1@00Oomoogoo00002Woo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol00Woo00<007ooOol0
27oo00D007ooOomoo`0000Uoo`03001oogoo009oo`03001oogoo00Qoo`06001oogoo001oo`002Goo
00<007ooOol00Woo00<007ooOol01Woo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`00
00]oo`03001oogoo00=oo`03001oogoo0?Aoo`002goo00<007ooOol01goo00D007ooOomoo`0000Yo
o`03001oogoo009oo`03001oogoo00Ioo`03001oogoo009oo`03001oogoo00Qoo`05001oogooOol0
0009Ool00`00Oomoo`03Ool00`00Oomoo`07Ool01P00Oomoo`00Ool000Uoo`03001oogoo009oo`03
001oogoo00Ioo`03001oogoo009oo`03001oogoo00Qoo`05001oogooOol0000;Ool00`00Oomoo`03
Ool00`00Oomoo`3dOol000]oo`03001oogoo00Moo`05001oogooOol00009Ool00`00Oomoo`03Ool0
0`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00002Goo00<007ooOol0
0goo00<007ooOol01goo00H007ooOol007oo0009Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00
Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00002goo00<007ooOol00goo00<007ooOol0m7oo
000;Ool00`00Oomoo`07Ool01@00Oomoogoo00002Goo00<007ooOol00goo00<007ooOol01Woo00<0
07ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Uoo`03001oogoo00=oo`03001oogoo00Mo
o`06001oogoo001oo`002Goo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol00goo00<007oo
Ool01goo00D007ooOomoo`0000]oo`03001oogoo00=oo`03001oogoo0?Aoo`002goo00<007ooOol0
1goo00D007ooOomoo`0000Uoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo009oo`03001o
ogoo00Qoo`05001oogooOol00009Ool00`00Oomoo`03Ool00`00Oomoo`07Ool01P00Oomoo`00Ool0
00Uoo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Moo`05001oogoo
Ool0000;Ool00`00Oomoo`03Ool00`00Oomoo`3dOol000]oo`03001oogoo00Moo`05001oogooOol0
0009Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomo
o`02Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`07Ool01P00Oomoo`00Ool000Uoo`03
001oogoo009oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Moo`05001oogooOol0000;
Ool00`00Oomoo`03Ool00`00Oomoo`3dOol000]oo`03001oogoo00Moo`05001oogooOol00009Ool0
0`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`02Ool0
0`00Oomoo`06Ool00`00Oomoo`03Ool70003Ool01P00Oomoo`00Ool000Uoo`03001oogoo009oo`03
001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Moo`05001oogooOol0000;Ool00`00Oomoo`03
Ool00`00Oomoo`3dOol000]oo`03001oogoo00Moo`05001oogooOol00009Ool00`00Oomoo`03Ool0
0`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`06Ool0
0`00Oomoo`03Ool20008Ool01P00Oomoo`00Ool000Uoo`03001oogoo009oo`03001oogoo00Ioo`03
001oogoo00=oo`03001oogoo00Moo`05001oogooOol0000;Ool00`00Oomoo`04Ool00`00Oomoo`3c
Ool000]oo`03001oogoo00Moo`05001oogooOol00009Ool00`00Oomoo`03Ool00`00Oomoo`06Ool0
0`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomoo`03Ool0
0`00Ool00007Ool01P00Oomoo`00Ool000Uoo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo
00=oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo00Aoo`03001oogoo
0?=oo`002goo00<007ooOol01goo00D007ooOomoo`0000Uoo`03001oogoo00=oo`03001oogoo00Io
o`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo00=o
o`04001oogoo0006Ool01P00Oomoo`00Ool000Uoo`03001oogoo009oo`03001oogoo00Ioo`03001o
ogoo00=oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo00Aoo`03001o
ogoo0?=oo`002goo00<007ooOol01goo00D007ooOomoo`0000Uoo`03001oogoo00=oo`03001oogoo
00Ioo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001oogoo00Aoo`H0009oo`05
001oogooOol00005Ool00`00Oomoo`040008Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomo
o`03Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`08Ool00`00Oomoo`04Ool00`00Oomo
o`3cOol000]oo`03001oogoo00Moo`05001oogooOol00009Ool00`00Oomoo`03Ool00`00Oomoo`06
Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01P00Oomoo`00Ool000Qoo`03001oogoo00=oo`03001o
ogoo00Ioo`03001oogoo00=oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Qoo`03001o
ogoo00Aoo`03001oogoo0?=oo`002goo00<007ooOol01goo00D007ooOomoo`0000Uoo`03001oogoo
00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo
00Ioo`03001oogoo00=oo`03001oogoo00=oo`05001oogooOol00002Ool00`00Ool00008Ool00`00
Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00
Oomoo`08Ool00`00Oomoo`04Ool00`00Oomoo`3cOol000]oo`03001oogoo00Moo`05001oogooOol0
0009Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomo
o`02Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<0
07oo000027oo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01goo00<0
07ooOol00Woo00<007ooOol027oo00<007ooOol017oo00<007ooOol0lgoo000;Ool00`00Oomoo`07
Ool01@00Oomoogoo00002Goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007oo
Ool01goo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol00goo0P0017oo00D007ooOomoo`00
009oo`03001oo`0000Qoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo
00Moo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo00Aoo`03001oogoo0?=oo`002goo00<0
07ooOol01goo00D007ooOomoo`0000Uoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=o
o`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo00=oo`03001oo`0000<0
00Aoo`06001oogoo001oo`0027oo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<0
07ooOol01goo00<007ooOol00Woo00<007ooOol027oo00<007ooOol017oo00<007ooOol0lgoo000;
Ool00`00Oomoo`07Ool01@00Oomoogoo00002Goo00<007ooOol00goo00<007ooOol01Woo00<007oo
Ool00goo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol00goo00<007oo
Ool01goo00H007ooOol007oo0008Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool0
0`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`08Ool00`00Oomoo`05Ool00`00Oomoo`3bOol0
00]oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo
00Ioo`03001oogoo00=oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo
00=oo`03001oogoo00Moo`06001oogoo001oo`0027oo00<007ooOol00goo00<007ooOol01Woo00<0
07ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol027oo00<007ooOol01Goo00<0
07ooOol0lWoo000;Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03
Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`06
Ool00`00Oomoo`03Ool00`00Oomoo`07Ool01P00Oomoo`00Ool000Qoo`03001oogoo00=oo`03001o
ogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Qoo`03001o
ogoo00Eoo`03001oogoo0?9oo`002goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo
00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01goo00<007ooOol00Woo
00<007ooOol01Woo00<007ooOol00goo00<007ooOol01goo00H007ooOol007oo0008Ool00`00Oomo
o`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomo
o`08Ool00`00Oomoo`05Ool00`00Oomoo`3bOol000]oo`03001oogoo00Ioo`03001oogoo00=oo`03
001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03
001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Moo`06001oogoo001oo`00
27oo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol0
0goo00<007ooOol027oo00<007ooOol01Goo00<007ooOol0lWoo000;Ool00`00Oomoo`06Ool00`00
Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`07Ool01P00
Oomoo`00Ool000Qoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Io
o`03001oogoo00=oo`03001oogoo00Qoo`03001oogoo00Eoo`03001oogoo0?9oo`002goo00<007oo
Ool01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007oo
Ool00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007oo
Ool01goo00<007ooOol00`0027oo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<0
07ooOol01Woo00<007ooOol00goo00<007ooOol027oo00<007ooOol01Goo00<007ooOol0lWoo000;
Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06
Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03
Ool00`00Oomoo`07Ool01P00Oomoo`00Ool000Qoo`03001oogoo00=oo`03001oogoo00Ioo`03001o
ogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Qoo`03001oogoo00Eoo`03001o
ogoo0?9oo`002goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo
00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo
00<007ooOol00goo00<007ooOol01goo00H007ooOol007oo0008Ool00`00Oomoo`03Ool00`00Oomo
o`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`08Ool00`00Oomo
o`06Ool00`00Oomoo`3aOol000]oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03
001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03
001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`07001oogooOol007oo000027oo00<007oo
Ool00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007oo
Ool027oo00<007ooOol01Woo00<007ooOol0lGoo000;Ool00`00Oomoo`06Ool00`00Oomoo`03Ool0
0`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool0
0`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool01`00Oomoogoo001o
o`0000Qoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001o
ogoo00=oo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo0?5oo`002goo00<007ooOol01Woo
00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo
00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo
00L007ooOomoo`00Ool00008Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`3aOol000]o
o`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Io
o`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=o
o`03001oogoo00Ioo`07001oogooOol007oo000027oo00<007ooOol00goo00<007ooOol01Woo00<0
07ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01goo00<007ooOol01goo00<0
07ooOol0lGoo000;Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03
Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06
Ool00`00Oomoo`03Ool00`00Oomoo`06Ool01`00Oomoogoo001oo`0000Qoo`03001oogoo00=oo`03
001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Moo`03
001oogoo00Qoo`03001oogoo0?1oo`002goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol0
1Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol0
0goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00L007ooOomoo`00Ool00008Ool0
0`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool0
0`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`3`Ool000]oo`03001oogoo00Ioo`03001oogoo
00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo
00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`07001oogoo
Ool007oo000027oo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo
00<007ooOol00goo00<007ooOol01goo00<007ooOol027oo00<007ooOol0l7oo000;Ool00`00Oomo
o`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomo
o`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomo
o`06Ool01@00Oomoogoo00000Woo00<007ooOol01Goo00<007ooOol00goo00<007ooOol01Woo00<0
07ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01goo00<007ooOol027oo00<0
07ooOol0l7oo000;Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03
Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06
Ool00`00Oomoo`03Ool00`00Oomoo`06Ool01@00Oomoogoo00000Woo00<007ooOol01Goo00<007oo
Ool00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007oo
Ool01goo00<007ooOol027oo00<007ooOol0l7oo000;Ool00`00Oomoo`06Ool00`00Oomoo`03Ool0
0`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool0
0`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool01@00Oomoogoo0000
0Woo00<007ooOol01Goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol0
1Woo00<007ooOol00goo00<007ooOol01goo00<007ooOol027oo00<007ooOol0l7oo000;Ool00`00
Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00
Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`06Ool01000Oomoogoo10001goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo
00<007ooOol01Woo00<007ooOol00goo00<007ooOol01goo00<007ooOol02Goo00<007ooOol02goo
00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo00<007ooOol037oo0P003Goo00<007oo
Ool037oo0P003Goo0P003Goo0P003Goo0P003Goo0P003Goo0P003Goo0P003Goo0P003Goo0P0047oo
000;Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomo
o`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomo
o`03Ool00`00Oomoo`06Ool01@00Oomoogoo00000Woo00<007ooOol01Goo00<007ooOol00goo00<0
07ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01goo00<0
07ooOol02Goo00<007ooOol02Woo0`0037oo0`0037oo00<007oo000037oo00<007oo000037oo00<0
07oo00003Goo0P003Goo0P003Goo0P003Goo0P003Goo0P003Goo0P003Goo0P003Goo0P003Goo0P00
3Goo0P0047oo000;Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06
Ool00`00Oomoo`03Ool00`00Oomoo`06Ool01@00Oomoogoo00000Woo00<007ooOol01Goo00<007oo
Ool00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007oo
Ool01goo00<007ooOol02Goo00<007ooOol02Woo00<007oo000037oo00<007oo000037oo00<007oo
000037oo00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo
000037oo00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo
000037oo00<007oo00003Goo0P0047oo000;Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomo
o`05Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomo
o`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool01@00Oomoogoo00000Woo00<0
07ooOol01Goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<0
07ooOol00goo00<007ooOol01goo00<007ooOol02Goo00<007ooOol02Woo00<007oo000037oo00<0
07oo000037oo00<007oo000037oo00<007oo000037oo00<007oo000037oo00@007ooOol000]oo`03
001oo`0000aoo`03001oo`0000aoo`04001oogoo000;Ool00`00Ool0000<Ool01000Oomoo`002goo
00<007oo000037oo00<007oo000037oo00@007ooOol000]oo`04001oogoo000?Ool000]oo`03001o
ogoo00Ioo`03001oogoo00=oo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Ioo`03001o
ogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001o
ogoo00Eoo`05001oogooOol00002Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool0
0`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomoo`09Ool0
0`00Oomoo`0:Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool0
0`00Ool0000<Ool01000Oomoo`002goo00<007oo000037oo00@007ooOol000]oo`04001oogoo000;
Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool00`00Ool0000<Ool01000Oomo
o`002goo00@007ooOol000moo`002goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Goo
00<007ooOol017oo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo
00<007ooOol01Woo00<007ooOol017oo00<007ooOol01Goo00D007ooOomoo`00009oo`03001oogoo
00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo
00=oo`03001oogoo00Moo`03001oogoo00Uoo`03001oogoo00Yoo`04001oogoo000:Ool01@00Oomo
ogoo00002Woo00@007ooOol000]oo`05001oogooOol0000;Ool01000Oomoo`002goo00@007ooOol0
00]oo`03001oo`0000aoo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001o
ogoo000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`003goo
000;Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomo
o`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomo
o`04Ool00`00Oomoo`05Ool01@00Oomoogoo00000Woo00<007ooOol01Goo00<007ooOol017oo00<0
07ooOol01Goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01goo00<0
07ooOol02Goo00<007ooOol02Woo00@007ooOol000Yoo`05001oogooOol0000:Ool01@00Oomoogoo
00002Woo00D007ooOomoo`0000]oo`04001oogoo000:Ool01@00Oomoogoo00002Woo00D007ooOomo
o`0000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000Yoo`05001oogooOol0000;
Ool01000Oomoo`002Woo00D007ooOomoo`0000]oo`04001oogoo000;Ool01000Oomoo`003goo000;
Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool01@00Oomoogoo00000Woo00<007ooOol01Goo00<007ooOol017oo00<007oo
Ool01Goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01goo00<007oo
Ool02Goo00<007ooOol02Goo00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo
00002Woo00D007ooOomoo`0000]oo`04001oogoo000:Ool01@00Oomoogoo00002Woo00D007ooOomo
o`0000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000Yoo`05001oogooOol0000;
Ool01000Oomoo`002Woo00D007ooOomoo`0000]oo`04001oogoo000:Ool01@00Oomoogoo00003goo
000;Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`04Ool700000goo
001oo`05Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool01@00Oomoogoo00000Woo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo
00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01goo1`001Woo00<007oo
Ool027oo00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo000017oo0`000goo
00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`00
009oo`@000Aoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05
001oogooOol00002Ool40005Ool01@00Oomoogoo00002Goo00D007ooOomoo`0000]oo`04001oogoo
000:Ool00`00Ool000040004Ool40005Ool000]oo`03001oogoo00Ioo`03001oogoo00=oo`03001o
ogoo00Eoo`03001oogoo00Aoo`8000Ioo`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo00=o
o`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`05001oogooOol00002Ool00`00Oomo
o`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomo
o`04Ool00`00Oomoo`06Ool2000;Ool00`00Oomoo`08Ool01@00Oomoogoo00002Woo00D007ooOomo
o`0000Yoo`05001oogooOol00005Ool00`00Oomoo`02Ool01@00Oomoogoo00002Woo00D007ooOomo
o`0000Yoo`05001oogooOol0000:Ool01`00Oomoogoo001oo`0000Aoo`05001oogooOol00003Ool0
0`00Oomoo`08Ool00`00Oomoo`02Ool00`00Oomoo`07Ool01@00Oomoogoo00002Woo00<007ooOol0
0Woo0P0017oo00D007ooOomoo`0000Aoo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Qo
o`04001oogoo000:Ool01@00Oomoogoo00001Goo00<007ooOol00Woo00<007ooOol00Woo000;Ool0
0`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Ool00005Ool0
0`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool0
0`00Oomoo`05Ool01@00Oomoogoo00000Woo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol017oo00<007ooOol01Woo00<007oo0000
2Woo00<007ooOol027oo00D007ooOomoo`0000Yoo`03001oogoo009oo`03001oogoo00Moo`05001o
ogooOol00005Ool00`00Oomoo`02Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001o
ogooOol0000:Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00000goo00<007ooOol027oo00<0
07ooOol00Woo00<007ooOol01goo00D007ooOomoo`0000Yoo`03001oogoo009oo`8000Aoo`05001o
ogooOol00004Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo0000
2Goo00D007ooOomoo`0000Eoo`03001oogoo009oo`03001oogoo009oo`002goo00<007ooOol01Woo
00<007ooOol00goo00<007ooOol01Goo00<007ooOol017oo00@007ooOol000Aoo`03001oogoo00Ao
o`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`05001oogooOol00002Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomo
o`03Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`06Ool01000Oomoo`002Goo00<007oo
Ool027oo00D007ooOomoo`0000Yoo`03001oogoo009oo`03001oogoo00Moo`06001oogooOol007oo
1P000Woo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Yoo`05001oogooOol0000:
Ool00`00Oomoo`02Ool20004Ool01@00Oomoogoo00000goo00<007ooOol027oo00<007ooOol00Woo
00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo0P0017oo00D007oo
Oomoo`0000Aoo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03
001oogoo00Moo`05001oogooOol00005Ool00`00Oomoo`02Ool00`00Oomoo`02Ool000aoo`03001o
ogoo00Eoo`03001oogoo00=oo`03001oogoo00Aoo`H000=oo`04001oogoo0003Ool00`00Oomoo`04
Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool01@00Oomoogoo00000Woo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007oo
Ool00goo00<007ooOol01Woo00<007ooOol017oo00<007ooOol01Woo00D007ooOomoo`0000Qoo`03
001oogoo00Moo`03001oogoo009oo`03001oogoo00Qoo`03001oogoo009oo`03001oogoo00Moo`03
001oogoo009oo`8000=oo`05001oogooOol00004Ool00`00Oomoo`08Ool01@00Oomoogoo00002Goo
00<007ooOol00goo00<007ooOol01goo00<007ooOol00Woo0`000goo00D007ooOomoo`0000=oo`03
001oogoo00Qoo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03
001oogoo009oo`8000Aoo`05001oogooOol00004Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool01000Oomoogoo0P0017oo00<007ooOol00Woo
00<007ooOol00Woo000<Ool00`00Oomoo`05Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool01@00Oomoogoo00000Woo00<007ooOol017oo00<007ooOol01Woo00<007ooOol017oo00<0
07ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00@007ooOomoo`@000Moo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Io
o`03001oogoo009oo`03001oogoo00Eoo`03001oogoo00Moo`03001oogoo00=oo`03001oogoo00Io
o`03001oogoo00=oo`03001oogoo00Moo`03001oogoo009oo`03001oo`00009oo`05001oogooOol0
0004Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomo
o`07Ool00`00Oomoo`02Ool2000017oo000000000goo00<007ooOol00goo00<007ooOol01goo00<0
07ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<0
07oo00000`0017oo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo
00<007ooOol00Woo00<007ooOol01goo00@007ooOomoo`8000Aoo`03001oogoo009oo`03001oogoo
009oo`0037oo00<007ooOol01Goo00<007ooOol00goo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol00Woo00<007oo00001Woo00<007ooOol01Woo00<007ooOol017oo00<007ooOol01Goo00<0
07ooOol017oo00<007ooOol01Goo00D007ooOomoo`00009oo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Io
o`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00Moo`03001oogoo00=oo`03001oogoo00Io
o`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`06001oogoo001oo`000goo00<007oo
Ool00goo00<007ooOol01Woo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007oo
Ool01goo00<007ooOol00Woo0P001goo00<007ooOol00goo00<007ooOol01goo00<007ooOol00Woo
00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo0P0017oo00@007oo
Ool000Eoo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001o
ogoo00Moo`04001oogooOol20004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool000aoo`03001oogoo
00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo009oo`03001oo`00
00Ioo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo
00Eoo`05001oogooOol00002Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00
Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`04Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`06Ool00`00Oomoo`03Ool01P00Oomoo`00Ool000=oo`03001oogoo00=oo`03001oogoo00Io
o`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Moo`03001oogoo009o
o`8000Moo`03001oogoo00=oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001o
ogoo009oo`03001oogoo00Moo`03001oogoo009oo`8000Aoo`04001oogoo0005Ool00`00Oomoo`07
Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool01000Oomoogoo
0P0017oo00<007ooOol00Woo00<007ooOol00Woo000<Ool00`00Oomoo`05Ool00`00Oomoo`04Ool0
0`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Ool00006Ool00`00Oomoo`06Ool0
0`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool01@00Oomoogoo0000
0Woo00<007ooOol017oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol00goo00<007ooOol0
1Woo00<007ooOol017oo00<007ooOol01Woo0P0017oo00<007ooOol017oo00<007ooOol01goo00<0
07ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00@0
07ooOomoo`8000=oo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Io
o`03001oogoo00=oo`03001oogoo00Moo`03001oogoo009oo`03001oo`0000Ioo`03001oogoo00=o
o`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Mo
o`03001oogoo009oo`8000Aoo`04001oogoo0005Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Ool000030004Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool000aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo
00Eoo`D0009oo`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Aoo`03001oogoo00Eoo`05001oogooOol00002Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`06
Ool00`00Ool000030008Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomo
o`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01@00Oomoogoo00001Goo00<0
07ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<0
07ooOol00goo00<007ooOol00`000goo00<007ooOol00goo00<007ooOol01goo00<007ooOol00goo
00<007ooOol01Goo00<007ooOol00goo00<007ooOol01goo00<007ooOol00goo1@000goo00<007oo
Ool017oo00<007ooOol01Goo00<007ooOol00goo00<007ooOol01goo00<007ooOol00Woo00<007oo
Ool01goo00@007ooOomoo`8000Eoo`@000Eoo`0037oo00<007ooOol01Goo00<007ooOol017oo00<0
07ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol017oo00<007ooOol01Woo00<0
07ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00D007ooOomoo`00009o
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00=o
o`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Io
o`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=o
o`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Io
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Mo
o`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00aoo`0037oo00<007oo
Ool01Goo00<007ooOol017oo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007oo
Ool017oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol017oo00<007oo
Ool01Goo00D007ooOomoo`00009oo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo00]oo`03
001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03
001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03
001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03
001oogoo00aoo`0037oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol017oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00D007ooOomoo`00009oo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Ioo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00=oo`03001oogoo00aoo`0037oo00<007ooOol01Goo00<007ooOol017oo
00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol017oo00<007ooOol01Goo
00<007ooOol01Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00D007ooOomoo`00
009oo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00aoo`03001oogoo00Ioo`03001oogoo
00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo
00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo
00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo
00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo
00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00]oo`0037oo00<0
07ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<0
07ooOol017oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol017oo00<0
07ooOol01Goo00D007ooOomoo`00009oo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00ao
o`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00=o
o`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00]oo`0037oo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007oo
Ool01Goo00<007ooOol017oo00<007ooOol017oo00<007ooOol01Goo00<007ooOol01Goo00<007oo
Ool01Goo00<007ooOol017oo00<007ooOol01Goo00D007ooOomoo`00009oo`03001oogoo00Aoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00aoo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03
001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00]oo`0037oo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00D007ooOomo
o`00009oo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00aoo`03001oogoo00Ioo`03001o
ogoo00=oo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00]oo`00o`00
VP000Goo000:Ool00`00Ool00006Ool00`00Oomoo`03Ool00`00Ool00006Ool00`00Oomoo`03Ool0
0`00Ool00006Ool00`00Oomoo`02Ool01000Oomoo`001Woo00<007ooOol00Woo00@007ooOol000Mo
o`05001oogooOol00002Ool00`00Oomoo`05Ool01@00Oomoogoo00000Woo00<007ooOol017oo00<0
07ooOol00Woo00@007ooOol000Ioo`03001oogoo009oo`04001oogoo0006Ool00`00Oomoo`02Ool0
1000Oomoo`001goo00D007ooOomoo`0000]oo`04001oogoo0003Ool00`00Oomoo`05Ool01000Oomo
o`0017oo00<007ooOol017oo00@007ooOol000=oo`03001oogoo00Eoo`04001oogoo0003Ool00`00
Oomoo`05Ool01000Oomoo`000goo00<007ooOol01Goo00@007ooOol000Aoo`03001oogoo00Aoo`04
001oogoo0003Ool00`00Oomoo`05Ool01000Oomoo`0017oo00<007ooOol017oo00@007ooOol000=o
o`03001oogoo00Eoo`04001oogoo0004Ool00`00Oomoo`04Ool01000Oomoo`0017oo00<007ooOol0
17oo00@007ooOol000=oo`03001oogoo00Eoo`04001oogoo0003Ool00`00Oomoo`05Ool00`00Ool0
0005Ool00`00Oomoo`04Ool00`00Ool00005Ool00`00Oomoo`04Ool00`00Ool0000;Ool000Yoo`03
001oo`0000Ioo`03001oogoo00=oo`03001oo`0000Ioo`03001oogoo00=oo`03001oo`0000Ioo`03
001oogoo009oo`04001oogoo0006Ool00`00Oomoo`02Ool01000Oomoo`001goo00D007ooOomoo`00
009oo`03001oogoo00Eoo`05001oogooOol00002Ool00`00Oomoo`04Ool00`00Oomoo`02Ool01000
Oomoo`001Woo00<007ooOol00Woo00@007ooOol000Ioo`03001oogoo009oo`04001oogoo0007Ool0
1@00Oomoogoo00002goo00@007ooOol000=oo`03001oogoo00Eoo`04001oogoo0004Ool00`00Oomo
o`04Ool01000Oomoo`000goo00<007ooOol01Goo00@007ooOol000=oo`03001oogoo00Eoo`04001o
ogoo0003Ool00`00Oomoo`05Ool01000Oomoo`0017oo00<007ooOol017oo00@007ooOol000=oo`03
001oogoo00Eoo`04001oogoo0004Ool00`00Oomoo`04Ool01000Oomoo`000goo00<007ooOol01Goo
00@007ooOol000Aoo`03001oogoo00Aoo`04001oogoo0003Ool00`00Oomoo`05Ool01000Oomoo`00
0goo00<007ooOol01Goo00@007ooOol000=oo`03001oogoo00Eoo`03001oo`0000Eoo`03001oogoo
00Aoo`03001oo`0000Eoo`03001oogoo00Aoo`03001oo`0000]oo`0037oo00<007ooOol017oo00<0
07ooOol01Goo00<007ooOol017oo00<007ooOol00goo00<007oo00001Woo00<007ooOol01Goo00<0
07ooOol017oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00D0
07ooOomoo`00009oo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`05001oogooOol0000;Ool00`00Oomo
o`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomo
o`05Ool01000Oomoo`000goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007oo
Ool017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00@007ooOol000=oo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`04001oogoo0003Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Ool0000;Ool000aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Eoo`05001oogooOol00002Ool00`00Oomoo`04Ool00`00Oomo
o`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomo
o`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomo
o`03Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomo
o`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomo
o`03Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomo
o`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomo
o`05Ool00`00Oomoo`04Ool00`00Oomoo`0;Ool000aoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`05001oogooOol00002
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`06
Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`0;Ool000aoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Aoo`03001oogoo009oo`04001oogoo0006Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`0>Ool00`00
Oomoo`02Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00
Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00
Oomoo`0:Ool000aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo009oo`04001oogoo0006Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05
Ool00`00Oomoo`0>Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`06
Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02
Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06
Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03
Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06
Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`03
Ool00`00Oomoo`06Ool00`00Oomoo`0:Ool000aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo009oo`04001o
ogoo0006Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`0>Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00
Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00
Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00
Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`0:Ool000aoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo009oo`04001oogoo0006Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`0>Ool00`00Oomoo`02
Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06
Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03
Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06
Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02
Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06
Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`0:
Ool000aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo009oo`04001oogoo0006Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00
Oomoo`0>Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00
Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00
Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00
Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00
Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`06Ool00`00Oomoo`0:Ool000aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo009oo`04001oogoo0006
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`05Ool00`00Oomoo`0>Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02
Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07
Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02
Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`07
Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02
Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06
Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`0:Ool000aoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo009oo`04001oogoo0006Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`0>Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00
Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00
Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00
Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00
Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`0:Ool000ao
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo009oo`@000Ioo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00ioo`03001o
ogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001o
ogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001o
ogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001o
ogoo00Moo`03001oogoo009oo`03001oogoo00Qoo`05001oogooOol00009Ool00`00Oomoo`02Ool0
0`00Oomoo`08Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Uoo`03001oogoo00=oo`03001o
ogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Yoo`0037oo00<007ooOol017oo
00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo
00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo
00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo
00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00moo`04001oogoo
000:Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomo
o`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomo
o`07Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01@00Oomoogoo00002Goo00<007ooOol00Woo00<0
07ooOol027oo00D007ooOomoo`0000Uoo`03001oogoo009oo`03001oogoo00Qoo`05001oogooOol0
000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Uoo`03001oogoo00=oo`03001oogoo00Io
o`03001oogoo00Yoo`0037oo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007oo
Ool01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007oo
Ool017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00moo`04001oogoo000:Ool00`00Oomoo`02Ool00`00Oomoo`07Ool0
0`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool0
0`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`08Ool0
1@00Oomoogoo00002Goo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Uoo`03001o
ogoo009oo`03001oogoo00Qoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomo
o`0000Yoo`05001oogooOol00009Ool00`00Oomoo`0:Ool000aoo`03001oogoo00Aoo`03001oogoo
00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo
00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo
009oo`05001oogooOol00005Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`0?Ool01000Oomoo`002goo00D0
07ooOomoo`0000Uoo`03001oogoo009oo`03001oogoo00Moo`05001oogooOol0000:Ool00`00Oomo
o`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomo
o`08Ool01@00Oomoogoo00002Goo00<007ooOol00Woo00<007ooOol027oo00D007ooOomoo`0000Yo
o`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001oogooOol0
000:Ool01@00Oomoogoo00002Woo00<007ooOol02Goo000<Ool00`00Oomoo`04Ool00`00Oomoo`05
Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04
Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`02
Ool01@00Oomoogoo00001Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007oo
Ool017oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol03goo00@007ooOol000]oo`04001o
ogoo000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`03001oogoo009oo`03001oogoo
00Moo`03001oogoo009oo`03001oogoo00Qoo`04001oogoo000;Ool01@00Oomoogoo00002Woo00@0
07ooOol000]oo`04001oogoo000;Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001o
ogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`03001oogoo00Uoo`0037oo
00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo
00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo
00<007ooOol017oo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo00Eoo`03001oogoo
00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00moo`04001oogoo000;Ool01000Oomoo`002Woo00D007ooOomoo`0000]oo`04001oogoo000;Ool0
1000Oomoo`002goo00D007ooOomoo`0000Yoo`04001oogoo000;Ool01000Oomoo`002goo00@007oo
Ool000]oo`04001oogoo000;Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001oogoo
Ool0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`03001oogoo00Uoo`0037oo00<0
07ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<0
07ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<0
07ooOol017oo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00mo
o`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomo
o`002goo00D007ooOomoo`0000Yoo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000]o
o`04001oogoo000;Ool01000Oomoo`002goo00D007ooOomoo`0000Yoo`04001oogoo000;Ool01000
Oomoo`002goo00D007ooOomoo`0000Yoo`03001oogoo00Uoo`0037oo00<007ooOol017oo00<007oo
Ool01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007oo
Ool017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007oo
Ool00Woo00D007ooOomoo`0000Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00moo`04001oogoo000;Ool0
1000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol0
00]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000<Ool00`00
Ool0000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo
00<007ooOol02Goo000<Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomo
o`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomo
o`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`02Ool01@00Oomoogoo00001Goo00<0
07ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<0
07ooOol01Goo00<007ooOol03goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo
00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo
000;Ool01000Oomoo`002goo00@007ooOol000aoo`03001oo`0000]oo`04001oogoo000<Ool00`00
Ool0000;Ool01000Oomoo`002goo00@007ooOol001Moo`0037oo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol0
17oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Woo00<007ooOol00goo00<007ooOol0
0Woo00D007ooOomoo`0000Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00moo`04001oogoo000;Ool01000
Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000ao
o`03001oo`0000]oo`04001oogoo000<Ool00`00Ool0000;Ool01000Oomoo`0037oo00<007oo0000
37oo00<007oo000037oo00<007oo000037oo00<007oo000037oo00<007oo00005goo000<Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00
Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool01@00Oomoogoo00001Goo00<007ooOol01Goo00<007ooOol017oo
00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol047oo
0P003Goo00<007oo00002goo00@007ooOol000aoo`03001oo`0000]oo`04001oogoo000<Ool00`00
Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00
Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000GOol000ao
o`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Io
o`03001oogoo00=oo`03001oogoo009oo`05001oogooOol00005Ool00`00Oomoo`05Ool00`00Oomo
o`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`0@Ool2000=Ool2000=Ool3000<Ool00`00Ool0000<Ool2000=Ool2000=Ool00`00Ool0000<Ool0
0`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000<Ool0
0`00Ool0000<Ool00`00Ool0000<Ool00`00Ool0000GOol000eoo`03001oogoo00=oo`03001oogoo
00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo
00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo
009oo`05001oogooOol00005Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`0@Ool2000=Ool2000=Ool2000=
Ool2000=Ool2000=Ool2000=Ool2000=Ool2000=Ool2000=Ool2000=Ool2000=Ool2000=Ool2000=
Ool3000<Ool2000HOol000eoo`03001oogoo00=oo`03001oogoo00Eoo`03001oogoo00=oo`03001o
ogoo00Ioo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo009oo`<00003Ool007oo00Aoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo011oo`03001oogoo00aoo`8000eoo`8000eoo`8000ioo`03001oogoo
00aoo`03001oogoo00]oo`8000eoo`8000ioo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo
00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo00aoo`03001oogoo01Ioo`003Goo00<0
07ooOol00goo00<007ooOol01Goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol017oo00<0
07ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Woo00<0
07ooOol00goo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo0?eo
o`003Goo00<007ooOol00goo00<007ooOol01Goo00<007ooOol00goo00<007ooOol01Woo00<007oo
Ool017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007oo
Ool01Woo00<007ooOol00goo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo00Eoo`03
001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03
001oogoo0?eoo`003Goo00<007ooOol00goo00<007ooOol01Goo00<007ooOol00goo00<007ooOol0
1Woo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol0
17oo00<007ooOol01Woo00<007ooOol00goo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001o
ogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001o
ogoo00Aoo`03001oogoo0?eoo`003Goo00<007ooOol00goo00<007ooOol01Goo00<007ooOol00goo
00<007ooOol01Woo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo
00<007ooOol017oo00<007ooOol01Woo00<007ooOol00goo00<007ooOol00Woo00D007ooOomoo`00
00Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo
00Eoo`03001oogoo00Aoo`03001oogoo0?eoo`003Goo00<007ooOol00goo00<007ooOol01Goo00<0
07ooOol00goo00<007ooOol01Woo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<0
07ooOol01Goo00<007ooOol017oo00<007ooOol01Woo00<007ooOol00goo00<007ooOol00Woo00D0
07ooOomoo`0000Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Ao
o`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo0?eoo`003Goo00<007ooOol00goo00<007oo
Ool01Goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol017oo00<007ooOol01Goo00<007oo
Ool017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Woo00<007ooOol00goo00<007oo
Ool00Woo00D007ooOomoo`0000Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo0?eoo`003Goo00<007ooOol0
0goo00<007ooOol01Goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Woo00<007ooOol0
0goo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo00Eoo`03001oogoo00Aoo`03001o
ogoo00Ioo`03001oogoo00=oo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo0?eoo`003Goo
00<007ooOol00Woo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol017oo
00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Woo
00<007ooOol00goo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo00Eoo`03001oogoo
00Aoo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo
0?eoo`003Goo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<0
07ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<0
07ooOol01Woo00<007ooOol00goo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03001oogoo00Eo
o`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo00Ao
o`03001oogoo0?eoo`003Goo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol00goo00<007oo
Ool01Woo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007oo
Ool017oo00<007ooOol01Woo00<007ooOol00goo00<007ooOol00Woo00D007ooOomoo`0000Eoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Ioo`03001oogoo009oo`03001oogoo00Moo`03
001oogoo00=oo`03001oogoo0?eoo`003Goo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol0
0goo00<007ooOol01Woo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol017oo00<007ooOol01Woo00<007ooOol00goo00<007ooOol00Woo00D007ooOomo
o`0000Eoo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo009oo`03001o
ogoo00Moo`03001oogoo00=oo`03001oogoo0?eoo`003Goo00<007ooOol00Woo00<007ooOol01Woo
00<007ooOol00goo00<007ooOol01Woo00<007ooOol017oo00<007ooOol01Woo00<007ooOol00goo
00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol00Woo
0`0000=oo`00Ool017oo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo00<007ooOol0
0Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol0oGoo000=Ool00`00Oomoo`02Ool00`00
Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00
Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool01@00Oomoogoo00001Goo00<007ooOol01Woo00<007ooOol00goo00<007ooOol01Woo
00<007ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol0oGoo000=Ool00`00Oomo
o`02Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomo
o`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool01@00Oomoogoo00001Goo00<007ooOol01Woo00<007ooOol00goo00<0
07ooOol01Woo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol0oGoo000=
Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomoo`03
Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02Ool00`00Oomoo`07
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01@00Oomoogoo00001Goo00<007ooOol01Woo00<007oo
Ool00goo00<007ooOol01Woo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007oo
Ool0oGoo000=Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`06Ool0
0`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`02Ool0
0`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol0
1goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00Woo00<007ooOol01goo00<007ooOol0
0goo00<007ooOol0oGoo000=Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00
Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00
Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo
00<007ooOol01goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00Woo00<007ooOol01goo
00<007ooOol00goo00<007ooOol0oGoo000=Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomo
o`02Ool00`00Oomoo`06Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomo
o`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomo
ogoo000017oo00<007ooOol01goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol00Woo00<0
07ooOol01goo00<007ooOol00goo00<007ooOol0oGoo000=Ool00`00Oomoo`02Ool00`00Oomoo`07
Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02
Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol00goo00<007ooOol01Woo00<007oo
Ool00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol0oGoo000=Ool00`00Oomoo`02Ool0
0`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool0
0`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol00goo00<007ooOol0
1Woo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol0oGoo000=Ool00`00
Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`06Ool70005
Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol00goo00<007ooOol01Woo00<007oo
Ool00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol0oGoo000=Ool00`00Oomoo`02Ool0
0`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool0
0`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`06Ool20004Ool00`00Oomo
o`03Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<0
07ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol0oGoo000=Ool00`00Oomoo`02
Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07
Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02
Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol00Woo00<007oo
Ool01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol0oGoo000=Ool0
0`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool0
0`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool2
0003Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol00Woo00<0
07ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol0oGoo000=
Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02
Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07
Ool00`00Ool00002Ool00`00Oomoo`03Ool50004Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`3mOol000eo
o`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009o
o`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Mo
o`06001oogoo001oo`001Goo00D007ooOomoo`0000Aoo`03001oogoo00Moo`03001oogoo009oo`03
001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo00=oo`03001oogoo0?eoo`00
3Goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol0
0Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol0
1goo00@007ooOomoo`8000Eoo`05001oogooOol00004Ool00`00Oomoo`07Ool00`00Oomoo`02Ool0
0`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`3mOol0
00eoo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo
009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo
00Moo`04001oogooOol20005Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol00Woo
00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol0oGoo
000=Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomo
o`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomo
o`06Ool20003Ool20005Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol00Woo00<0
07ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol0oGoo000=
Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02
Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07
Ool400000goo001oo`04Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol00Woo00<0
07ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00goo00<007ooOol0oGoo000=
Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02
Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07
Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007oo
Ool00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007oo
Ool0oWoo000=Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool0
0`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool0
0`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol0
1goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol0
0Woo00<007ooOol0oWoo000=Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00
Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo
00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo
00<007ooOol00Woo00<007ooOol0oWoo000=Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomo
o`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomo
o`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`03Ool01@00Oomo
ogoo000017oo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<0
07ooOol01goo00<007ooOol00Woo00<007ooOol0oWoo000=Ool00`00Oomoo`02Ool00`00Oomoo`07
Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02
Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007oo
Ool00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol0oWoo000=Ool00`00Oomoo`02Ool0
0`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool0
0`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol00Woo00<007ooOol0
1goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol0oWoo000=Ool00`00
Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00
Oomoo`02Ool00`00Oomoo`03Ool01@00Oomoogoo000017oo00<007ooOol01goo00<007ooOol00Woo
00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol0oWoo
000=Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomo
o`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomo
o`07Ool00`00Oomoo`02Ool00`00Oomoo`03Ool300000goo001oo`03Ool00`00Oomoo`07Ool00`00
Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00
Oomoo`3nOol000eoo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Mo
o`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009o
o`03001oogoo00Moo`03001oogoo009oo`03001oogoo00=oo`05001oogooOol00004Ool00`00Oomo
o`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomo
o`02Ool00`00Oomoo`3nOol000eoo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03
001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03
001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00=oo`05001oogooOol00004
Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`07
Ool00`00Oomoo`02Ool00`00Oomoo`3nOol000eoo`03001oogoo009oo`03001oogoo00Moo`03001o
ogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001o
ogoo00Moo`03001oogoo009oo`03001oogoo00Moo`03001oogoo009oo`03001oogoo00=oo`05001o
ogooOol00004Ool00`00Oomoo`08Ool01@00Oomoogoo00002Goo00<007ooOol00Woo00<007ooOol0
1goo00<007ooOol00Woo00<007ooOol0oWoo000=Ool01@00Oomoogoo00002Woo00<007ooOol00Woo
00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo
00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol00goo00D007ooOomoo`00
00Aoo`03001oogoo00Qoo`05001oogooOol0000:Ool01@00Oomoogoo00002Goo00<007ooOol00Woo
00<007ooOol0oWoo000=Ool01@00Oomoogoo00002Woo00<007ooOol00Woo00<007ooOol01goo00<0
07ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<0
07ooOol01goo00<007ooOol00Woo00<007ooOol00goo00D007ooOomoo`0000Aoo`03001oogoo00Qo
o`05001oogooOol0000:Ool01@00Oomoogoo00002Goo00<007ooOol00Woo00<007ooOol0oWoo000=
Ool01@00Oomoogoo00002Woo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007oo
Ool01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007oo
Ool00Woo00<007ooOol00goo00D007ooOomoo`0000Aoo`03001oogoo00Qoo`05001oogooOol0000:
Ool01@00Oomoogoo00002Goo00<007ooOol00Woo00<007ooOol0oWoo000=Ool01@00Oomoogoo0000
2Woo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol0
0Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol0
0goo00D007ooOomoo`0000Aoo`03001oogoo00Qoo`05001oogooOol0000:Ool01@00Oomoogoo0000
2Goo00<007ooOol00Woo00<007ooOol0oWoo000=Ool01@00Oomoogoo00002Woo00<007ooOol00Woo
00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo
00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol00goo00D007ooOomoo`00
00Aoo`03001oogoo00Qoo`05001oogooOol0000:Ool01@00Oomoogoo00002Goo00<007ooOol00Woo
00<007ooOol0oWoo000=Ool01@00Oomoogoo00002Woo00<007ooOol00Woo00<007ooOol01goo00<0
07ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<007ooOol01goo00<007ooOol00Woo00<0
07ooOol01goo00D007ooOomoo`0000Ioo`05001oogooOol00004Ool00`00Oomoo`08Ool01@00Oomo
ogoo00002Woo00D007ooOomoo`0000Uoo`03001oogoo009oo`03001oogoo0?ioo`003Goo00D007oo
Oomoo`0000Yoo`03001oogoo009oo`03001oogoo00Qoo`05001oogooOol00009Ool00`00Oomoo`02
Ool00`00Oomoo`07Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Ioo`05001oogooOol00004
Ool00`00Oomoo`08Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Uoo`03001oogoo009oo`03
001oogoo0?ioo`003Goo00D007ooOomoo`0000Yoo`05001oogooOol0000;Ool01000Oomoo`002Woo
00<007ooOol00Woo00<007ooOol01goo00D007ooOomoo`0000Yoo`05001oogooOol00006Ool00`00
Oomoo`02Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001oogooOol00009Ool00`00
Oomoo`02Ool00`00Oomoo`3nOol000eoo`05001oogooOol0000:Ool01@00Oomoogoo00002goo00@0
07ooOol000Yoo`03001oogoo009oo`03001oogoo00Moo`05001oogooOol0000:Ool01@00Oomoogoo
00001Woo0`000Woo00D007ooOomoo`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002Goo
00<007ooOol00Woo00<007ooOol0oWoo000=Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000]o
o`04001oogoo000:Ool00`00Oomoo`02Ool00`00Oomoo`07Ool01@00Oomoogoo00002Woo00D007oo
Oomoo`0000Ioo`03001oogoo009oo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007oo
Oomoo`0000Uoo`03001oogoo009oo`03001oogoo0?ioo`003Goo00D007ooOomoo`0000Yoo`05001o
ogooOol0000;Ool01000Oomoo`002Woo00<007ooOol00Woo00<007ooOol01goo00D007ooOomoo`00
00Yoo`05001oogooOol00006Ool00`00Oomoo`02Ool01@00Oomoogoo00002Woo00D007ooOomoo`00
00Yoo`05001oogooOol00009Ool00`00Oomoo`02Ool00`00Oomoo`3nOol000eoo`05001oogooOol0
000:Ool01@00Oomoogoo00002goo00@007ooOol000Yoo`03001oogoo009oo`03001oogoo00Moo`05
001oogooOol0000:Ool01@00Oomoogoo00001Woo00<007ooOol00Woo00D007ooOomoo`0000Yoo`05
001oogooOol0000:Ool01@00Oomoogoo00002Goo00<007ooOol00Woo00<007ooOol0oWoo000=Ool0
1@00Oomoogoo00002Woo00D007ooOomoo`0000]oo`04001oogoo000:Ool00`00Oomoo`02Ool00`00
Oomoo`08Ool01000Oomoo`002Woo00D007ooOomoo`0000Ioo`03001oogoo009oo`05001oogooOol0
000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`0000Yoo`05001oogooOol0003oOol1Ool000eo
o`05001oogooOol0000:Ool01@00Oomoogoo00002goo00@007ooOol000Yoo`03001oogoo009oo`03
001oogoo00Qoo`04001oogoo000:Ool01@00Oomoogoo00001Woo00<007ooOol00Woo00D007ooOomo
o`0000Yoo`05001oogooOol0000:Ool01@00Oomoogoo00002Woo00D007ooOomoo`000?moo`5oo`00
3Goo00D007ooOomoo`0000Yoo`05001oogooOol0000;Ool01000Oomoo`002goo00D007ooOomoo`00
00Yoo`04001oogoo000;Ool01000Oomoo`001Woo00<007ooOol00Woo00D007ooOomoo`0000Yoo`04
001oogoo000;Ool01@00Oomoogoo00002Woo00D007ooOomoo`000?moo`5oo`003Goo00D007ooOomo
o`0000]oo`04001oogoo000;Ool01000Oomoo`002goo00D007ooOomoo`0000Yoo`04001oogoo000;
Ool01000Oomoo`001Woo00<007ooOol00Woo00D007ooOomoo`0000Yoo`04001oogoo000;Ool01@00
Oomoogoo00002Woo00D007ooOomoo`000?moo`5oo`003Goo00D007ooOomoo`0000]oo`04001oogoo
000;Ool01000Oomoo`002goo00D007ooOomoo`0000Yoo`04001oogoo000;Ool01000Oomoo`001Woo
00<007ooOol00Woo00D007ooOomoo`0000Yoo`04001oogoo000;Ool01@00Oomoogoo00002Woo00D0
07ooOomoo`000?moo`5oo`003Goo00D007ooOomoo`0000]oo`04001oogoo000;Ool01000Oomoo`00
2goo00D007ooOomoo`0000Yoo`04001oogoo000;Ool01000Oomoo`001Woo00<007ooOol00Woo00D0
07ooOomoo`0000Yoo`04001oogoo000;Ool01@00Oomoogoo00002Woo00@007ooOol00?moo`9oo`00
3Woo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001o
ogoo000;Ool01000Oomoo`001Woo00<007ooOol00Woo00D007ooOomoo`0000Yoo`04001oogoo000;
Ool01@00Oomoogoo00002Woo00@007ooOol00?moo`9oo`003Woo00@007ooOol000]oo`04001oogoo
000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`001Woo00<0
07ooOol00Woo00D007ooOomoo`0000Yoo`04001oogoo000;Ool01@00Oomoogoo00002Woo00@007oo
Ool00?moo`9oo`003Woo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007oo
Ool000]oo`04001oogoo000;Ool01000Oomoo`001Woo00<007ooOol00Woo00@007ooOol000]oo`04
001oogoo000;Ool01@00Oomoogoo00002Woo00@007ooOol00?moo`9oo`003Woo00@007ooOol000]o
o`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomo
o`001Woo0`000Woo00@007ooOol000]oo`04001oogoo000;Ool01@00Oomoogoo00002Woo00@007oo
Ool00?moo`9oo`003Woo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007oo
Ool000]oo`04001oogoo000;Ool01000Oomoo`001Woo00<007ooOol00Woo00@007ooOol000]oo`04
001oogoo000;Ool01@00Oomoogoo00002Woo00@007ooOol00?moo`9oo`003Woo00@007ooOol000]o
o`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomo
o`001Woo00<007ooOol00Woo00@007ooOol000]oo`04001oogoo000;Ool01@00Oomoogoo00002Woo
00@007ooOol00?moo`9oo`003Woo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo
00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`001Woo00<007ooOol00Woo00@007ooOol0
00]oo`04001oogoo000;Ool01@00Oomoogoo00002Woo00@007ooOol00?moo`9oo`003Woo00@007oo
Ool000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool0
1000Oomoo`001Woo00<007ooOol00Woo00@007ooOol000]oo`04001oogoo000;Ool01@00Oomoogoo
00002Woo00@007ooOol00?moo`9oo`003Woo00@007ooOol000]oo`04001oogoo000;Ool01000Oomo
o`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`001Woo00<007ooOol00Woo00@0
07ooOol000]oo`04001oogoo000;Ool01@00Oomoogoo00002Woo00@007ooOol00?moo`9oo`003Woo
00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo
000;Ool01000Oomoo`001Woo00<007ooOol00Woo00@007ooOol000]oo`04001oogoo000;Ool01@00
Oomoogoo00002Woo00@007ooOol00?moo`9oo`003Woo00@007ooOol000]oo`04001oogoo000;Ool0
1000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`001Woo00<007ooOol0
0Woo00@007ooOol000]oo`04001oogoo000;Ool01@00Oomoogoo00002Woo00@007ooOol00?moo`9o
o`003Woo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000]oo`04
001oogoo000;Ool40006Ool00`00Oomoo`02Ool01000Oomoo`002goo00@007ooOol000]oo`04001o
ogoo000;Ool01000Oomoo`00ogoo0Woo000>Ool01000Oomoo`002goo00@007ooOol000]oo`04001o
ogoo000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oo`000006Ool00`00Oomoo`02Ool0
1000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`00ogoo0Woo000>Ool0
1000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol0
00]oo`04001oo`000006Ool00`00Oomoo`02Ool01000Oomoo`002goo00@007ooOol000]oo`04001o
ogoo000;Ool01000Oomoo`00ogoo0Woo000>Ool01000Oomoo`002goo00@007ooOol000]oo`04001o
ogoo000;Ool01000Oomoo`002goo00@007ooOol000Uoo`H000Ioo`03001oogoo009oo`04001oogoo
000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo003oOol2Ool000ioo`04001oogoo
000;Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002Goo00@0
07oo001oo`8000Ioo`@00005Ool007ooOol0000;Ool01000Oomoo`0037oo00<007oo00002goo00@0
07ooOol00?moo`9oo`003Woo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@0
07ooOol000]oo`04001oogoo000:Ool200000goo00000006Ool00`00Oomoo`02Ool01000Oomoo`00
2goo00@007ooOol000aoo`03001oo`0000]oo`04001oogoo003oOol2Ool000ioo`04001oogoo000;
Ool01000Oomoo`002goo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007oo
000000Ioo`03001oogoo009oo`04001oogoo000;Ool01000Oomoo`0037oo00<007oo00002goo00@0
07ooOol00?moo`9oo`003Woo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@0
07ooOol000aoo`03001oo`0000]oo`04001oo`000006Ool00`00Oomoo`02Ool01000Oomoo`002goo
00@007ooOol000aoo`03001oo`0000]oo`04001oogoo003oOol2Ool000ioo`04001oogoo000;Ool0
1000Oomoo`002goo00@007ooOol000]oo`04001oogoo000<Ool00`00Ool0000;Ool40006Ool00`00
Oomoo`02Ool01000Oomoo`002goo00@007ooOol000aoo`03001oo`0000aoo`03001oo`000?moo`9o
o`003Woo00@007ooOol000]oo`04001oogoo000;Ool01000Oomoo`002goo00@007ooOol000aoo`03
001oo`0000]oo`04001oo`000006Ool00`00Oomoo`02Ool01000Oomoo`002goo00@007ooOol000ao
o`03001oo`0000aoo`03001oo`000?moo`9oo`003Woo00@007ooOol000]oo`04001oogoo000;Ool0
1000Oomoo`002goo00@007ooOol000aoo`03001oo`0000]oo`04001oogoo0006Ool00`00Oomoo`02
Ool01000Oomoo`0037oo00<007oo000037oo00<007oo000037oo00<007oo0000ogoo0Woo000?Ool0
0`00Ool0000;Ool01000Oomoo`002goo00<007oo000037oo00<007oo00003Goo00<007oo00002goo
00@007ooOol000Ioo`03001oogoo009oo`04001oogoo000<Ool00`00Ool0000<Ool00`00Ool0000<
Ool00`00Ool0003oOol2Ool000moo`03001oo`0000aoo`03001oo`0000aoo`8000eoo`8000eoo`03
001oo`0000aoo`03001oo`0000Ioo`03001oogoo009oo`04001oogoo000<Ool00`00Ool0000<Ool0
0`00Ool0000<Ool00`00Ool0003oOol2Ool000moo`8000eoo`03001oo`0000aoo`8000eoo`8000eo
o`03001oo`0000aoo`03001oo`0000Ioo`03001oogoo00=oo`03001oo`0000aoo`03001oo`0000ao
o`03001oo`0000aoo`03001oo`000?moo`9oo`003goo0P003Goo00<007oo000037oo0P003Goo0P00
3Goo00<007oo000037oo00<007oo00001Woo00<007ooOol00goo00<007oo000037oo00<007oo0000
37oo00<007oo000037oo00<007oo0000ogoo0Woo000?Ool2000=Ool2000=Ool2000=Ool2000=Ool2
000=Ool20007Ool00`00Oomoo`03Ool00`00Ool0000<Ool2000=Ool00`00Ool0000<Ool00`00Ool0
003oOol2Ool000moo`8000eoo`8000eoo`8000eoo`8000eoo`8000eoo`8000Moo`03001oogoo00=o
o`03001oo`0000aoo`8000eoo`03001oo`0000aoo`03001oo`000?moo`9oo`003goo0P003Goo0P00
3Goo0P003Goo0P003Goo0P003Goo0P001goo0`000goo0P003Goo0P003Goo0P003Goo00<007oo0000
ogoo0Woo000?Ool2000=Ool2000=Ool2000=Ool2000=Ool2000=Ool20007Ool00`00Oomoo`03Ool2
000=Ool2000=Ool2000=Ool2003oOol3Ool000moo`8000eoo`8000eoo`8000eoo`8000eoo`8000eo
o`8000Moo`03001oogoo00=oo`8000eoo`8000eoo`8000eoo`800?moo`=oo`003goo0P003Goo0P00
3Goo0P003Goo0P003Goo0P003Goo0P001goo00<007ooOol00goo0P003Goo0P003Goo0P003Goo0P00
ogoo0goo000?Ool2000=Ool2000=Ool2000=Ool2000=Ool2000=Ool20007Ool00`00Oomoo`03Ool2
000=Ool2000=Ool2000=Ool2003oOol3Ool000moo`8000eoo`8000eoo`8000eoo`8000eoo`8000eo
o`8000Moo`03001oogoo00=oo`8000eoo`8000eoo`8000eoo`800?moo`=oo`003goo0P003Goo0P00
3Goo0P003Goo0P003Goo0P003Goo0P001goo00<007ooOol00goo0P003Goo0P003Goo0P003Goo0P00
ogoo0goo001SOol00`00Oomoo`3oOoleOol006=oo`03001oogoo0?moocEoo`00Hgoo00<007ooOol0
ogoo=Goo001SOol00`00Oomoo`3oOoleOol006=oo`03001oogoo0?moocEoo`00Hgoo00<007ooOol0
ogoo=Goo0000\
\>"],
  ImageRangeCache->{{{0, 409}, {252.25, 0}} -> {-3.33926, -4.98964, 0.0334438,
   0.0395611}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(k0 = 10; dk = 0.5; \ng[k_] = Exp[\(-\((k - k0)\)\^2\)\/\(4\ dk\^2\)]; \n
    Plot[g[k], {k, 0, 20}, PlotRange -> {0, 1}]; \)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.047619 0 0.618034 [
[.2619 -0.0125 -3 -9 ]
[.2619 -0.0125 3 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.7381 -0.0125 -6 -9 ]
[.7381 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.01131 .12361 -18 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -18 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -18 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -18 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -6 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2619 0 m
.2619 .00625 L
s
[(5)] .2619 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(10)] .5 -0.0125 0 1 Mshowa
.7381 0 m
.7381 .00625 L
s
[(15)] .7381 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(20)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(0.2)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(0.4)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(0.6)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(0.8)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(1)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 0 m
.02499 0 L
.02605 0 L
.02729 0 L
.02846 0 L
.02954 0 L
.03053 0 L
.03163 0 L
.03279 0 L
.03395 0 L
.0352 0 L
.03638 0 L
.03746 0 L
.03873 0 L
.03944 0 L
.04011 0 L
.04132 0 L
.04262 0 L
.04327 0 L
.04396 0 L
.04519 0 L
.04588 0 L
.04652 0 L
.04722 0 L
.04797 0 L
.04862 0 L
.04933 0 L
.05061 0 L
.05186 0 L
.05302 0 L
.05414 0 L
.05519 0 L
.05634 0 L
.05759 0 L
.05882 0 L
.06012 0 L
.06123 0 L
.06244 0 L
.06315 0 L
.06381 0 L
.06453 0 L
.06529 0 L
.06657 0 L
.06729 0 L
.06797 0 L
.06924 0 L
.0704 0 L
.07103 0 L
.07173 0 L
.073 0 L
Mistroke
.07376 0 L
.07448 0 L
.07513 0 L
.07583 0 L
.0766 0 L
.0774 0 L
.07809 0 L
.07885 0 L
.07956 0 L
.0802 0 L
.08095 0 L
.08166 0 L
.08291 0 L
.08362 0 L
.08427 0 L
.08544 0 L
.08669 0 L
.08787 0 L
.08896 0 L
.09016 0 L
.09148 0 L
.09214 0 L
.09285 0 L
.09413 0 L
.09483 0 L
.09548 0 L
.09619 0 L
.09695 0 L
.09821 0 L
.09893 0 L
.09961 0 L
.10086 0 L
.10201 0 L
.10333 0 L
.10458 0 L
.10572 0 L
.10694 0 L
.1081 0 L
.10916 0 L
.11033 0 L
.11162 0 L
.11227 0 L
.11297 0 L
.11422 0 L
.11491 0 L
.11554 0 L
.11624 0 L
.11698 0 L
.11822 0 L
.11892 0 L
Mistroke
.11958 0 L
.12081 0 L
.12194 0 L
.12323 0 L
.12446 0 L
.12562 0 L
.12668 0 L
.12789 0 L
.12903 0 L
.13009 0 L
.13107 0 L
.13214 0 L
.13327 0 L
.13441 0 L
.13564 0 L
.1368 0 L
.13785 0 L
.13909 0 L
.13979 0 L
.14043 0 L
.14162 0 L
.14288 0 L
.14402 0 L
.14526 0 L
.14656 0 L
.14777 0 L
.14891 0 L
.14994 0 L
.15113 0 L
.15226 0 L
.15348 0 L
.15478 0 L
.15589 0 L
.15711 0 L
.15842 0 L
.15915 0 L
.15982 0 L
.16113 0 L
.16236 0 L
.16352 0 L
.16456 0 L
.16577 0 L
.1669 0 L
.16796 0 L
.16893 0 L
.16999 0 L
.17111 0 L
.17225 0 L
.17347 0 L
.17462 0 L
Mistroke
.17566 0 L
.17689 0 L
.17758 0 L
.17823 0 L
.1794 0 L
.18065 0 L
.18185 0 L
.18316 0 L
.18441 0 L
.18556 0 L
.1867 0 L
.18773 0 L
.18893 0 L
.19005 0 L
.19128 0 L
.19258 0 L
.19369 0 L
.19491 0 L
.19623 0 L
.19696 0 L
.19763 0 L
.19894 0 L
.20017 0 L
.20122 0 L
.20238 0 L
.20359 0 L
.20472 0 L
.20578 0 L
.20675 0 L
.20781 0 L
.20894 0 L
.21008 0 L
.21129 0 L
.21244 0 L
.21349 0 L
.21472 0 L
.21605 0 L
.21731 0 L
.21847 0 L
.21972 0 L
.22091 0 L
.22198 0 L
.22314 0 L
.2244 0 L
.22574 0 L
.22701 0 L
.22816 0 L
.22933 0 L
.2304 0 L
.23158 0 L
Mistroke
.23283 0 L
.23391 0 L
.23493 0 L
.23604 0 L
.23722 0 L
.23861 0 L
.23988 0 L
.24129 0 L
.24277 0 L
.24406 0 L
.24527 0 L
.2466 0 L
.24802 0 L
.24922 0 L
.25053 0 L
.25189 0 L
.25316 0 L
.25435 0 L
.25543 0 L
.25668 0 L
.25786 0 L
.25902 0 L
.26026 0 L
.26143 0 L
.2625 0 L
.26376 0 L
.26512 0 L
.26641 0 L
.2676 0 L
.26882 0 L
.26997 0 L
.27123 0 L
.2726 0 L
.27394 0 L
.27536 0 L
.27658 0 L
.27791 0 L
.27915 0 L
.28032 0 L
.28252 0 L
.28376 0 L
.28489 0 L
.28622 0 L
.28746 0 L
.28952 0 L
.29061 0 L
.29179 0 L
.29301 0 L
.29418 0 L
.29637 0 L
Mistroke
.29761 0 L
.29896 0 L
.30014 0 L
.3014 0 L
.30253 0 L
.30377 0 L
.30596 0 L
.30729 0 L
.30851 0 L
.30982 0 L
.31124 0 L
.31256 0 L
.31378 0 L
.31493 0 L
.31618 0 L
.31837 0 L
.32042 0 L
.32161 0 L
.32286 0 L
.3251 0 L
.32744 0 L
.32962 0 L
.33201 0 L
.33335 0 L
.33457 0 L
.33688 0 L
.33942 1e-005 L
.3407 1e-005 L
.34207 1e-005 L
.34455 1e-005 L
.34702 2e-005 L
.34936 3e-005 L
.35147 4e-005 L
.35376 5e-005 L
.3565 7e-005 L
.35899 .0001 L
.36185 .00014 L
.36455 .00019 L
.36706 .00025 L
.36936 .00033 L
.37189 .00044 L
.37456 .0006 L
.37711 .00079 L
.37953 .00103 L
.38406 .00165 L
.3866 .00213 L
.38894 .00268 L
.39168 .0035 L
.39424 .00445 L
.39848 .00656 L
Mistroke
.40072 .00801 L
.40314 .00987 L
.40807 .01488 L
.41259 .02126 L
.41735 .03038 L
.42242 .04349 L
.42721 .05974 L
.43156 .07831 L
.44222 .14178 L
.45227 .22633 L
.47063 .42251 L
.47566 .47597 L
.48106 .5276 L
.48572 .5649 L
.48818 .58113 L
.4908 .59539 L
.49212 .60133 L
.49358 .60689 L
.49492 .61103 L
.49615 .614 L
.4974 .6162 L
.49806 .61701 L
.49876 .61762 L
.49993 .61803 L
.50122 .61763 L
.50246 .61638 L
.50359 .61452 L
.5049 .61152 L
.50614 .60785 L
.50834 .59938 L
.51072 .5875 L
.51604 .55176 L
.52167 .50241 L
.53178 .39592 L
.54192 .28473 L
.55156 .19139 L
.56021 .12496 L
.56964 .07281 L
.57452 .05339 L
.57972 .03748 L
.58462 .02627 L
.58907 .01869 L
.59424 .0123 L
.59715 .00962 L
.59983 .00763 L
.60475 .00489 L
.60723 .00388 L
.60996 .00299 L
.61247 .00234 L
.6152 .00177 L
Mistroke
.61779 .00136 L
.62017 .00106 L
.62469 .00065 L
.62697 .00051 L
.62949 .00038 L
.6322 .00028 L
.63468 .00021 L
.63741 .00015 L
.64028 .00011 L
.64279 8e-005 L
.64512 6e-005 L
.64768 4e-005 L
.65041 3e-005 L
.653 2e-005 L
.65575 1e-005 L
.65809 1e-005 L
.66066 1e-005 L
.66211 1e-005 L
.66343 0 L
.66486 0 L
.66641 0 L
.66784 0 L
.66916 0 L
.67177 0 L
.67305 0 L
.67442 0 L
.67563 0 L
.6769 0 L
.67806 0 L
.67932 0 L
.68154 0 L
.6829 0 L
.68414 0 L
.68547 0 L
.68692 0 L
.68826 0 L
.6895 0 L
.69075 0 L
.69193 0 L
.6931 0 L
.69436 0 L
.69659 0 L
.69785 0 L
.69919 0 L
.7016 0 L
.70277 0 L
.70404 0 L
.70516 0 L
.70635 0 L
.70742 0 L
Mistroke
.70859 0 L
.71065 0 L
.71204 0 L
.71335 0 L
.71454 0 L
.7158 0 L
.71717 0 L
.71844 0 L
.71981 0 L
.72132 0 L
.72261 0 L
.72379 0 L
.72509 0 L
.72646 0 L
.72765 0 L
.72876 0 L
.72996 0 L
.73128 0 L
.73255 0 L
.7339 0 L
.73516 0 L
.73633 0 L
.7377 0 L
.73896 0 L
.74042 0 L
.7418 0 L
.74299 0 L
.74426 0 L
.74546 0 L
.74655 0 L
.74783 0 L
.74922 0 L
.75053 0 L
.75173 0 L
.75281 0 L
.75396 0 L
.75496 0 L
.75605 0 L
.75732 0 L
.75852 0 L
.75969 0 L
.76078 0 L
.76191 0 L
.76298 0 L
.76415 0 L
.76541 0 L
.76666 0 L
.76797 0 L
.76909 0 L
.77032 0 L
Mistroke
.77164 0 L
.77286 0 L
.7742 0 L
.77562 0 L
.77685 0 L
.778 0 L
.77926 0 L
.78062 0 L
.78182 0 L
.78313 0 L
.78436 0 L
.78551 0 L
.78653 0 L
.78767 0 L
.78885 0 L
.78996 0 L
.79119 0 L
.79252 0 L
.79392 0 L
.79522 0 L
.79644 0 L
.79755 0 L
.79884 0 L
.80005 0 L
.80137 0 L
.80203 0 L
.80276 0 L
.80405 0 L
.80527 0 L
.806 0 L
.80669 0 L
.80799 0 L
.80872 0 L
.8094 0 L
.81013 0 L
.81093 0 L
.81221 0 L
.81292 0 L
.81357 0 L
.81475 0 L
.81601 0 L
.81672 0 L
.81749 0 L
.81816 0 L
.81888 0 L
.81953 0 L
.82024 0 L
.8215 0 L
.82279 0 L
.82398 0 L
Mistroke
.82527 0 L
.82593 0 L
.82664 0 L
.82785 0 L
.82914 0 L
.83036 0 L
.83146 0 L
.83262 0 L
.83385 0 L
.8349 0 L
.83606 0 L
.8373 0 L
.83799 0 L
.83863 0 L
.83986 0 L
.84104 0 L
.84212 0 L
.84328 0 L
.84437 0 L
.84536 0 L
.84653 0 L
.84779 0 L
.84898 0 L
.85007 0 L
.85134 0 L
.85254 0 L
.85362 0 L
.85479 0 L
.85607 0 L
.85671 0 L
.85742 0 L
.85867 0 L
.85984 0 L
.86102 0 L
.86213 0 L
.86313 0 L
.86423 0 L
.86541 0 L
.86667 0 L
.86787 0 L
.86895 0 L
.87024 0 L
.87089 0 L
.87161 0 L
.87288 0 L
.87406 0 L
.87478 0 L
.87546 0 L
.87673 0 L
.87744 0 L
Mistroke
.8781 0 L
.87882 0 L
.87959 0 L
.88079 0 L
.8819 0 L
.88255 0 L
.88324 0 L
.88446 0 L
.88574 0 L
.88693 0 L
.88823 0 L
.88896 0 L
.88963 0 L
.89082 0 L
.89193 0 L
.89316 0 L
.89447 0 L
.89513 0 L
.89585 0 L
.89715 0 L
.89842 0 L
.8996 0 L
.9008 0 L
.90194 0 L
.90296 0 L
.90406 0 L
.90526 0 L
.90653 0 L
.90761 0 L
.9088 0 L
.90947 0 L
.9102 0 L
.91152 0 L
.9128 0 L
.91399 0 L
.91528 0 L
.91601 0 L
.91669 0 L
.91741 0 L
.91807 0 L
.9188 0 L
.91956 0 L
.92076 0 L
.92204 0 L
.92325 0 L
.92435 0 L
.92565 0 L
.92638 0 L
.92705 0 L
.92829 0 L
Mistroke
.92959 0 L
.93081 0 L
.93213 0 L
.93338 0 L
.93453 0 L
.93557 0 L
.93672 0 L
.93792 0 L
.93905 0 L
.94028 0 L
.94159 0 L
.94271 0 L
.94393 0 L
.94524 0 L
.94598 0 L
.94665 0 L
.94796 0 L
.94919 0 L
.95025 0 L
.95141 0 L
.95262 0 L
.95376 0 L
.95482 0 L
.95579 0 L
.95691 0 L
.95798 0 L
.95912 0 L
.96034 0 L
.96149 0 L
.96254 0 L
.96377 0 L
.96446 0 L
.9651 0 L
.96627 0 L
.96751 0 L
.96865 0 L
.96968 0 L
.97087 0 L
.972 0 L
.97304 0 L
.97401 0 L
.97507 0 L
.97619 0 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00OFgoo00<007ooOol0
=Goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0;goo00<007ooOol027oo00<007ooOol0
;goo00<007ooOol017oo00<007ooOol00Woo00<007ooOol017oo001KOol00`00Oomoo`0eOol00`00
Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0_Ool00`00Oomoo`08Ool00`00Oomoo`0`Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool005Ioo`D003Qoo`03001oogoo00=oo`03001o
ogoo009oo`03001oogoo02moo`03001oogoo00=oo`D003Aoo`03001oogoo009oo`03001oogoo009o
o`03001oogoo00Aoo`00EWoo00<007ooOol0>Woo00<007ooOol00goo00<007ooOol00Woo00<007oo
Ool0;goo00<007ooOol00goo00<007ooOol0=goo00D007ooOomoo`0000Aoo`03001oogoo00Aoo`00
EWoo00<007ooOol0>Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0;goo00<007ooOol0
0goo00<007ooOol0=goo00D007ooOomoo`0000Aoo`03001oogoo00Aoo`00EWoo00<007ooOol0>7oo
0`001Goo00<007ooOol00Woo00<007ooOol0;Goo0`001Goo00<007ooOol0<Woo00<007ooOol00Woo
00D007ooOomoo`0000Aoo`03001oogoo00Aoo`00EWoo1P00=goo00<007ooOol017oo1000<Woo00<0
07ooOol00goo1P00<7oo10001Goo10001goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol0
0?moob5oo`005Gooo`001@001goo000KOol00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`05
Ool20002Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00
Oomoo`020008Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0;Ool001]oo`03001oogoo
05ioo`80039oo`8006ioo`006goo00<007ooOol0H7oo00<007ooOol0;Woo00<007ooOol0KWoo000K
Ool00`00Oomoo`1QOol00`00Oomoo`0/Ool00`00Oomoo`1_Ool001]oo`03001oogoo069oo`03001o
ogoo02]oo`03001oogoo06moo`006goo00<007ooOol0HWoo00<007ooOol0:Woo00<007ooOol0L7oo
000KOol00`00Oomoo`1SOol00`00Oomoo`0XOol00`00Oomoo`1aOol001]oo`8006Aoo`03001oogoo
02Qoo`03001oogoo075oo`006goo00<007ooOol0Hgoo00<007ooOol09goo00<007ooOol0LWoo000K
Ool00`00Oomoo`1TOol00`00Oomoo`0VOol00`00Oomoo`1bOol001]oo`03001oogoo06Aoo`03001o
ogoo02Ioo`03001oogoo079oo`006goo00<007ooOol0IGoo00<007ooOol097oo00<007ooOol0Lgoo
000KOol00`00Oomoo`1UOol00`00Oomoo`0TOol00`00Oomoo`1cOol001]oo`03001oogoo06Ioo`03
001oogoo02=oo`03001oogoo07=oo`006goo00<007ooOol0IWoo00<007ooOol08goo00<007ooOol0
Lgoo000KOol2001WOol00`00Oomoo`0SOol00`00Oomoo`1cOol001]oo`03001oogoo06Ioo`03001o
ogoo029oo`03001oogoo07Aoo`006goo00<007ooOol0Igoo00<007ooOol08Goo00<007ooOol0M7oo
000KOol00`00Oomoo`1WOol00`00Oomoo`0QOol00`00Oomoo`1dOol001]oo`03001oogoo06Moo`03
001oogoo025oo`03001oogoo07Aoo`006goo00<007ooOol0Igoo00<007ooOol08Goo00<007ooOol0
M7oo000KOol00`00Oomoo`1WOol00`00Oomoo`0POol00`00Oomoo`1eOol001]oo`03001oogoo06Qo
o`03001oogoo01moo`03001oogoo07Eoo`006goo0P00JGoo00<007ooOol07goo00<007ooOol0MGoo
000KOol00`00Oomoo`1XOol00`00Oomoo`0OOol00`00Oomoo`1eOol001]oo`03001oogoo06Qoo`03
001oogoo01ioo`03001oogoo07Ioo`006goo00<007ooOol0J7oo00<007ooOol07Woo00<007ooOol0
MWoo00040006Ool20005Ool60004Ool00`00Oomoo`1XOol00`00Oomoo`0NOol00`00Oomoo`1fOol0
00Aoo`03001oogoo00=oo`8000Eoo`03001oogoo00Moo`03001oogoo06Uoo`03001oogoo01eoo`03
001oogoo07Ioo`0017oo00<007ooOol02goo00<007ooOol01Woo00<007ooOol0JGoo00<007ooOol0
77oo00<007ooOol0Mgoo0004Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool00`00Oomoo`1YOol00`00
Oomoo`0LOol00`00Oomoo`1gOol000Aoo`03001oogoo00eoo`03001oogoo00Aoo`<006Uoo`03001o
ogoo01aoo`03001oogoo07Moo`0017oo00<007ooOol03Woo00<007ooOol00goo00<007ooOol0JGoo
00<007ooOol077oo00<007ooOol0Mgoo0004Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool00`00Oomo
o`1YOol00`00Oomoo`0LOol00`00Oomoo`1gOol000Aoo`03001oogoo00moo`03001oogoo009oo`03
001oogoo06Yoo`03001oogoo01]oo`03001oogoo07Moo`0017oo00<007ooOol02Woo00<007ooOol0
0Woo00<007ooOol00Woo00<007ooOol0JWoo00<007ooOol06goo00<007ooOol0Mgoo0004000>Ool4
0005Ool00`00Oomoo`1ZOol00`00Oomoo`0JOol00`00Oomoo`1hOol001]oo`03001oogoo06Yoo`03
001oogoo01Yoo`03001oogoo07Qoo`006goo00<007ooOol0JWoo00<007ooOol06Woo00<007ooOol0
N7oo000KOol2001[Ool00`00Oomoo`0JOol00`00Oomoo`1hOol001]oo`03001oogoo06Yoo`03001o
ogoo01Yoo`03001oogoo07Qoo`006goo00<007ooOol0JWoo00<007ooOol06Woo00<007ooOol0N7oo
000KOol00`00Oomoo`1[Ool00`00Oomoo`0IOol00`00Oomoo`1hOol001]oo`03001oogoo06]oo`03
001oogoo01Uoo`03001oogoo07Qoo`006goo00<007ooOol0Jgoo00<007ooOol067oo00<007ooOol0
NGoo000KOol00`00Oomoo`1[Ool00`00Oomoo`0HOol00`00Oomoo`1iOol001]oo`03001oogoo06]o
o`03001oogoo01Qoo`03001oogoo07Uoo`006goo0P00K7oo00<007ooOol067oo00<007ooOol0NGoo
000KOol00`00Oomoo`1[Ool00`00Oomoo`0HOol00`00Oomoo`1iOol001]oo`03001oogoo06]oo`03
001oogoo01Qoo`03001oogoo07Uoo`006goo00<007ooOol0Jgoo00<007ooOol067oo00<007ooOol0
NGoo000KOol00`00Oomoo`1[Ool00`00Oomoo`0HOol00`00Oomoo`1iOol001]oo`03001oogoo06ao
o`03001oogoo01Moo`03001oogoo07Uoo`006goo00<007ooOol0K7oo00<007ooOol05Woo00<007oo
Ool0NWoo000KOol00`00Oomoo`1/Ool00`00Oomoo`0FOol00`00Oomoo`1jOol001]oo`8006eoo`03
001oogoo01Ioo`03001oogoo07Yoo`006goo00<007ooOol0K7oo00<007ooOol05Woo00<007ooOol0
NWoo000KOol00`00Oomoo`1/Ool00`00Oomoo`0FOol00`00Oomoo`1jOol001]oo`03001oogoo06ao
o`03001oogoo01Ioo`03001oogoo07Yoo`0010001Woo0P0027oo0`0017oo00<007ooOol0K7oo00<0
07ooOol05Woo00<007ooOol0NWoo0004Ool00`00Oomoo`03Ool20009Ool00`00Oomoo`03Ool00`00
Oomoo`1/Ool00`00Oomoo`0FOol00`00Oomoo`1jOol000Aoo`03001oogoo00ioo`03001oogoo00=o
o`03001oogoo06aoo`03001oogoo01Eoo`03001oogoo07]oo`0017oo00<007ooOol02Woo1P0017oo
00<007ooOol0K7oo00<007ooOol05Goo00<007ooOol0Ngoo0004Ool00`00Oomoo`0:Ool01@00Oomo
ogoo00001Goo0`00KGoo00<007ooOol057oo00<007ooOol0Ngoo0004Ool00`00Oomoo`0;Ool01000
Oomoo`001Goo00<007ooOol0KGoo00<007ooOol057oo00<007ooOol0Ngoo0004Ool00`00Oomoo`0<
Ool00`00Ool00005Ool00`00Oomoo`1]Ool00`00Oomoo`0DOol00`00Oomoo`1kOol000Aoo`03001o
ogoo00aoo`03001oo`0000Eoo`03001oogoo06eoo`03001oogoo01Aoo`03001oogoo07]oo`0017oo
00<007ooOol03Goo0P001Goo00<007ooOol0KGoo00<007ooOol057oo00<007ooOol0Ngoo0004000A
Ool00`00Oomoo`03Ool00`00Oomoo`1]Ool00`00Oomoo`0DOol00`00Oomoo`1kOol001]oo`03001o
ogoo06eoo`03001oogoo01=oo`03001oogoo07aoo`006goo00<007ooOol0KGoo00<007ooOol04goo
00<007ooOol0O7oo000KOol2001^Ool00`00Oomoo`0COol00`00Oomoo`1lOol001]oo`03001oogoo
06eoo`03001oogoo01=oo`03001oogoo07aoo`006goo00<007ooOol0KWoo00<007ooOol04Woo00<0
07ooOol0O7oo000KOol00`00Oomoo`1^Ool00`00Oomoo`0BOol00`00Oomoo`1lOol001]oo`03001o
ogoo06ioo`03001oogoo019oo`03001oogoo07aoo`006goo00<007ooOol0KWoo00<007ooOol04Woo
00<007ooOol0O7oo000KOol00`00Oomoo`1^Ool00`00Oomoo`0BOol00`00Oomoo`1lOol001]oo`03
001oogoo06ioo`03001oogoo019oo`03001oogoo07aoo`006goo0P00Kgoo00<007ooOol04Woo00<0
07ooOol0O7oo000KOol00`00Oomoo`1^Ool00`00Oomoo`0AOol00`00Oomoo`1mOol001]oo`03001o
ogoo06ioo`03001oogoo015oo`03001oogoo07eoo`006goo00<007ooOol0KWoo00<007ooOol04Goo
00<007ooOol0OGoo000KOol00`00Oomoo`1_Ool00`00Oomoo`0@Ool00`00Oomoo`1mOol001]oo`03
001oogoo06moo`03001oogoo011oo`03001oogoo07eoo`006goo00<007ooOol0Kgoo00<007ooOol0
47oo00<007ooOol0OGoo000KOol00`00Oomoo`1_Ool00`00Oomoo`0@Ool00`00Oomoo`1mOol001]o
o`80071oo`03001oogoo011oo`03001oogoo07eoo`006goo00<007ooOol0Kgoo00<007ooOol047oo
00<007ooOol0OGoo000KOol00`00Oomoo`1_Ool00`00Oomoo`0@Ool00`00Oomoo`1mOol001]oo`03
001oogoo06moo`03001oogoo011oo`03001oogoo07eoo`0010001Woo0P001Woo10001Goo00<007oo
Ool0Kgoo00<007ooOol047oo00<007ooOol0OGoo0004Ool00`00Oomoo`03Ool20005Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`1_Ool00`00Oomoo`0@Ool00`00Oomoo`1mOol000Aoo`03
001oogoo00Yoo`03001oogoo009oo`03001oogoo009oo`03001oogoo071oo`03001oogoo00moo`03
001oogoo07eoo`0017oo00<007ooOol02Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
L7oo00<007ooOol03Woo00<007ooOol0OWoo0004Ool00`00Oomoo`0:Ool20003Ool00`00Oomoo`02
Ool3001`Ool00`00Oomoo`0>Ool00`00Oomoo`1nOol000Aoo`03001oogoo00Yoo`03001oo`000080
00Eoo`03001oogoo071oo`03001oogoo00ioo`03001oogoo07ioo`0017oo00<007ooOol02Woo00<0
07ooOol01goo00<007ooOol0L7oo00<007ooOol03Woo00<007ooOol0OWoo0004Ool00`00Oomoo`0:
Ool00`00Oomoo`07Ool00`00Oomoo`1`Ool00`00Oomoo`0>Ool00`00Oomoo`1nOol000Aoo`03001o
ogoo00]oo`03001oogoo00Ioo`03001oogoo071oo`03001oogoo00ioo`03001oogoo07ioo`001000
3goo0`001Goo00<007ooOol0L7oo00<007ooOol03Woo00<007ooOol0OWoo000KOol00`00Oomoo`1`
Ool00`00Oomoo`0>Ool00`00Oomoo`1nOol001]oo`03001oogoo071oo`03001oogoo00ioo`03001o
ogoo07ioo`006goo0P00LWoo00<007ooOol03Goo00<007ooOol0OWoo000KOol00`00Oomoo`1aOol0
0`00Oomoo`0=Ool00`00Oomoo`1nOol001]oo`03001oogoo075oo`03001oogoo00eoo`03001oogoo
07ioo`006goo00<007ooOol0LGoo00<007ooOol037oo00<007ooOol0Ogoo000KOol00`00Oomoo`1a
Ool00`00Oomoo`0<Ool00`00Oomoo`1oOol001]oo`03001oogoo075oo`03001oogoo00aoo`03001o
ogoo07moo`006goo00<007ooOol0LGoo00<007ooOol037oo00<007ooOol0Ogoo000KOol00`00Oomo
o`1aOol00`00Oomoo`0<Ool00`00Oomoo`1oOol001]oo`80079oo`03001oogoo00aoo`03001oogoo
07moo`006goo00<007ooOol0LGoo00<007ooOol037oo00<007ooOol0Ogoo000KOol00`00Oomoo`1a
Ool00`00Oomoo`0<Ool00`00Oomoo`1oOol001]oo`03001oogoo075oo`03001oogoo00aoo`03001o
ogoo07moo`006goo00<007ooOol0LWoo00<007ooOol02Woo00<007ooOol0P7oo000KOol00`00Oomo
o`1bOol00`00Oomoo`0:Ool00`00Oomoo`20Ool001]oo`03001oogoo079oo`03001oogoo00Yoo`03
001oogoo081oo`006goo00<007ooOol0LWoo00<007ooOol02Woo00<007ooOol0P7oo000KOol2001c
Ool00`00Oomoo`0:Ool00`00Oomoo`20Ool001]oo`03001oogoo079oo`03001oogoo00Yoo`03001o
ogoo081oo`006goo00<007ooOol0LWoo00<007ooOol02Woo00<007ooOol0P7oo000KOol00`00Oomo
o`1bOol00`00Oomoo`0:Ool00`00Oomoo`20Ool000@000Ioo`8000Ioo`@000Eoo`03001oogoo079o
o`03001oogoo00Yoo`03001oogoo081oo`0017oo00<007ooOol00goo0P001Goo00<007ooOol00Woo
00<007ooOol00Woo00<007ooOol0LWoo00<007ooOol02Woo00<007ooOol0P7oo0004Ool00`00Oomo
o`0:Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1bOol00`00Oomoo`09Ool00`00Oomo
o`21Ool000Aoo`03001oogoo00Yoo`03001oogoo009oo`03001oogoo009oo`03001oogoo07=oo`03
001oogoo00Qoo`03001oogoo085oo`0017oo00<007ooOol02Woo00<007ooOol00Woo00<007ooOol0
0Woo0`00Lgoo00<007ooOol027oo00<007ooOol0PGoo0004Ool00`00Oomoo`0;Ool40005Ool00`00
Oomoo`1cOol00`00Oomoo`08Ool00`00Oomoo`21Ool000Aoo`03001oogoo00Yoo`03001oogoo009o
o`03001oogoo009oo`03001oogoo07=oo`03001oogoo00Qoo`03001oogoo085oo`0017oo00<007oo
Ool02Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0Lgoo00<007ooOol027oo00<007oo
Ool0PGoo0004Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`1cOol0
0`00Oomoo`08Ool00`00Oomoo`21Ool000@000ioo`@000Eoo`03001oogoo07=oo`03001oogoo00Qo
o`03001oogoo085oo`006goo00<007ooOol0M7oo00<007ooOol01goo00<007ooOol0PGoo000KOol0
0`00Oomoo`1dOol00`00Oomoo`07Ool00`00Oomoo`21Ool001]oo`8007Eoo`03001oogoo00Moo`03
001oogoo085oo`006goo00<007ooOol0M7oo00<007ooOol01Woo00<007ooOol0PWoo000KOol00`00
Oomoo`1dOol00`00Oomoo`06Ool00`00Oomoo`22Ool001]oo`03001oogoo07Aoo`03001oogoo00Io
o`03001oogoo089oo`006goo00<007ooOol0M7oo00<007ooOol01Woo00<007ooOol0PWoo000KOol0
0`00Oomoo`1dOol00`00Oomoo`06Ool00`00Oomoo`22Ool001]oo`03001oogoo07Eoo`03001oogoo
00Eoo`03001oogoo089oo`006goo00<007ooOol0MGoo00<007ooOol01Goo00<007ooOol0PWoo000K
Ool2001fOol00`00Oomoo`05Ool00`00Oomoo`22Ool001]oo`03001oogoo07Eoo`03001oogoo00Eo
o`03001oogoo089oo`006goo00<007ooOol0MGoo00<007ooOol017oo00<007ooOol0Pgoo000KOol0
0`00Oomoo`1eOol00`00Oomoo`04Ool00`00Oomoo`23Ool001]oo`03001oogoo07Eoo`03001oogoo
00Aoo`03001oogoo08=oo`006goo00<007ooOol0MGoo00<007ooOol017oo00<007ooOol0Pgoo000K
Ool00`00Oomoo`1eOol00`00Oomoo`03Ool00`00Oomoo`24Ool001]oo`03001oogoo07Eoo`03001o
ogoo00=oo`03001oogoo08Aoo`006goo0P00Mgoo00<007ooOol00Woo00<007ooOol0Q7oo000KOol0
0`00Oomoo`1fOol00`00Oomoo`02Ool00`00Oomoo`24Ool001]oo`03001oogoo07Ioo`03001oogoo
009oo`03001oogoo08Aoo`006goo00<007ooOol0MWoo00<007ooOol00Woo00<007ooOol0Q7oo000B
Ool50004Ool00`00Oomoo`1fOol01@00Oomoogoo0000Qgoo000DOol00`00Oomoo`04Ool00`00Oomo
o`1gOol01000Oomoo`00Qgoo000DOol00`00Oomoo`04Ool00`00Oomoo`1gOol01000Oomoo`00Qgoo
000DOol00`00Oomoo`04Ool00`00Oomoo`1hOol20028Ool001Aoo`03001oogoo00Aoo`<007Qoo`80
08Qoo`0057oo00<007ooOol0ogoo2Woo000DOol00`00Oomoo`3oOol:Ool001Aoo`03001oogoo0?mo
o`Yoo`004Woo0`00ogoo37oo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-2.23638, -0.0764114, 
  0.0810174, 0.00624232}}]
}, Open  ]],

Cell[BoxData[
    \(nr = 30; k1 = k0 - 3*dk; k2 = k0 + 3*dk; ks = \((k2 - k1)\)\/nr; \n
    s1[x_, t_] = 
      \(1\/nr\) 
        Sum[g[k] If[k >= \@\(2\ v0\) /. const, p11[x, k, t], p12[x, k, t]], {
            k, k1, k2, ks}]; \n
    s2[x_, t_] = 
      \(1\/nr\) 
        Sum[g[k] If[k >= \@\(2\ v0\) /. const, p21[x, k, t], p22[x, k, t]], {
            k, k1, k2, ks}]; \n
    s3[x_, t_] = 
      \(1\/nr\) 
        Sum[g[k] If[k >= \@\(2\ v0\) /. const, p31[x, k, t], p32[x, k, t]], {
            k, k1, k2, ks}]; \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Do[\n
      plo1 = Plot[Abs[s1[x, \[Tau]]], {x, \(-12\), l1 /. const}, 
          DisplayFunction -> Identity]; \n
      plo2 = Plot[Abs[s2[x, \[Tau]]], {x, l1 /. const, l2 /. const}, 
          DisplayFunction -> Identity]; \n
      plo3 = Plot[Abs[s3[x, \[Tau]]], {x, l2 /. const, 18}, 
          DisplayFunction -> Identity]; \n
      Show[plo1, plo2, plo3, wall, DisplayFunction -> $DisplayFunction, 
        PlotRange -> {0, 10}], \n\t{\[Tau], \(-1\), 1.2, 0.1}]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .11065 m
.04184 .16807 L
.05122 .19799 L
.0615 .22567 L
.06612 .23563 L
.06734 .23898 L
.06866 .24207 L
.06927 .2432 L
.06991 .24419 L
.07106 .24554 L
.07573 .25073 L
.0779 .25414 L
.07897 .25556 L
.07997 .25655 L
.0805 .25694 L
.08107 .25725 L
.08139 .25739 L
.08169 .25749 L
.08226 .25762 L
.08279 .25769 L
.08327 .25772 L
.0838 .25774 L
.08436 .25775 L
.08492 .25777 L
.08553 .25781 L
.08609 .25789 L
.08661 .25798 L
.08722 .25813 L
.08788 .25832 L
.08909 .25871 L
.08958 .25885 L
.09011 .25897 L
.09069 .25904 L
.09124 .25903 L
.09182 .25892 L
.09243 .25867 L
.09295 .25835 L
.09352 .25789 L
.09455 .2568 L
.09565 .25541 L
.09763 .25305 L
.09995 .25144 L
.10056 .25115 L
.10122 .25079 L
.10184 .25036 L
.10241 .24983 L
.10306 .24902 L
.10369 .24803 L
.1051 .24508 L
.10759 .23904 L
Mistroke
.11699 .21965 L
.13484 .17198 L
.15383 .11441 L
.17212 .07125 L
.18213 .05408 L
.19155 .04139 L
.20014 .03043 L
.20501 .02512 L
.20624 .02334 L
.20739 .02191 L
.20843 .02094 L
.20902 .02052 L
.20956 .0202 L
.2117 .01929 L
.21292 .01875 L
.21406 .01808 L
.21519 .0172 L
.2164 .01602 L
.21888 .01319 L
.21951 .01252 L
.22018 .0119 L
.2208 .01143 L
.22139 .0111 L
.2217 .01097 L
.22205 .01087 L
.22264 .01076 L
.22299 .01074 L
.22336 .01074 L
.22367 .01075 L
.22402 .01077 L
.22463 .01081 L
.22519 .01081 L
.2255 .0108 L
.22584 .01075 L
.22645 .01061 L
.22702 .01038 L
.22763 .01004 L
.22872 .00917 L
.23084 .0069 L
.23136 .00636 L
.23191 .00586 L
.23252 .00545 L
.23308 .00524 L
.2334 .00521 L
.23375 .00523 L
.23407 .00532 L
.23437 .00543 L
.23494 .00574 L
.23554 .00613 L
.23663 .00685 L
Mistroke
.23723 .00717 L
.23779 .0074 L
.23832 .00753 L
.23889 .00758 L
.23941 .00752 L
.23989 .00739 L
.24039 .00717 L
.24084 .0069 L
.24185 .00611 L
.24296 .00507 L
.24354 .00453 L
.24415 .00409 L
.24469 .00386 L
.24528 .00386 L
.24582 .00409 L
.24632 .00446 L
.24746 .00556 L
.24866 .0067 L
.24929 .00715 L
.24965 .00734 L
.24998 .00748 L
.25057 .00762 L
.2509 .00763 L
.2512 .0076 L
.25176 .00745 L
.25228 .0072 L
.25285 .00682 L
.25346 .00632 L
.25459 .00525 L
.25519 .00474 L
.25552 .00451 L
.25583 .00435 L
.2564 .00421 L
.25671 .00422 L
.25704 .00431 L
.25763 .00462 L
.25816 .00502 L
.25922 .0059 L
.25977 .00631 L
.26037 .00668 L
.26094 .00693 L
.26146 .00706 L
.26199 .0071 L
.26248 .00704 L
.26298 .0069 L
.26345 .00669 L
.26395 .0064 L
.26449 .00604 L
.26568 .00512 L
.26627 .00468 L
Mistroke
.26681 .00434 L
.2673 .0041 L
.26783 .00396 L
.26835 .00393 L
.26893 .00401 L
.26954 .00421 L
.27011 .00444 L
.27072 .00471 L
.27138 .00497 L
.27199 .00518 L
.27256 .00531 L
.2731 .00538 L
.27368 .0054 L
.27426 .00535 L
.27479 .00525 L
.27537 .00508 L
.27599 .00485 L
.27817 .00372 L
.27911 .0032 L
.27962 .00294 L
.28011 .00273 L
.28069 .00256 L
.28121 .00249 L
.28171 .00251 L
.28224 .00261 L
.29128 .00307 L
.29249 .00221 L
.2931 .00184 L
.29344 .00169 L
.29376 .00162 L
.29411 .00165 L
.29443 .00176 L
.2948 .00197 L
.29515 .00224 L
.29643 .00341 L
.29756 .0044 L
.29818 .00484 L
.29875 .00516 L
.29905 .00528 L
.29938 .00539 L
.29973 .00546 L
.30006 .00548 L
.30036 .00547 L
.30068 .00542 L
.30127 .00523 L
.30187 .00491 L
.30251 .00443 L
.30368 .00332 L
.30424 .00278 L
.30482 .00231 L
Mistroke
.30532 .00212 L
.30587 .00223 L
.3062 .00246 L
.30651 .00274 L
.30709 .00338 L
.30841 .00488 L
.30896 .00541 L
.30954 .00586 L
.30984 .00605 L
.31018 .00621 L
.31077 .00637 L
.31133 .00638 L
.31191 .00624 L
.31241 .00599 L
.31296 .00562 L
.31418 .00444 L
.31477 .00379 L
.31532 .00321 L
.31584 .00279 L
.3164 .00257 L
.31691 .00266 L
.31738 .00295 L
.31789 .00342 L
.31845 .004 L
.31959 .00511 L
.32019 .00557 L
.32075 .00588 L
.32137 .00608 L
.32168 .00612 L
.32202 .00612 L
.3226 .00601 L
.32292 .00589 L
.32322 .00575 L
.32376 .00542 L
.32434 .00497 L
.32534 .00406 L
.32641 .00309 L
.32702 .00269 L
.32758 .00252 L
.32814 .00258 L
.32868 .0028 L
.32985 .00355 L
.33095 .00422 L
.3315 .00448 L
.33209 .00467 L
.33243 .00473 L
.33275 .00477 L
.33335 .00476 L
.33367 .00472 L
.33401 .00465 L
Mistroke
.33462 .00447 L
.33534 .00415 L
.33599 .0038 L
.33715 .00308 L
.33777 .00269 L
.33843 .0023 L
.33905 .00201 L
.33961 .00183 L
.34017 .00177 L
.34071 .00183 L
.3413 .00199 L
.34186 .0022 L
.34311 .00273 L
.34419 .00314 L
.34471 .0033 L
.3452 .00342 L
.3457 .00351 L
.34625 .00356 L
.34682 .00357 L
.34741 .00352 L
.34802 .00342 L
.34858 .00326 L
.34922 .00302 L
.34982 .00274 L
.35091 .0021 L
.35206 .00132 L
.35266 .00096 L
.353 .00083 L
.35332 .00081 L
.35389 .00102 L
.35449 .00145 L
.35577 .00254 L
.35647 .0031 L
.35713 .00358 L
.35775 .00395 L
.35808 .00411 L
.35842 .00425 L
.35903 .00443 L
.35959 .00449 L
.36015 .00445 L
.36067 .00433 L
.36125 .00409 L
.36186 .00371 L
.36253 .00318 L
.36325 .00248 L
.36388 .00181 L
.36423 .00145 L
.36456 .00116 L
.36517 .00098 L
.36549 .00115 L
Mistroke
.36584 .00148 L
.36702 .0029 L
.36822 .00423 L
.36889 .00482 L
.36922 .00505 L
.36953 .00523 L
.37013 .00547 L
.37068 .00555 L
.37127 .00549 L
.37161 .00539 L
.37191 .00526 L
.37245 .00493 L
.37295 .00452 L
.37409 .00329 L
.37521 .00193 L
.37577 .00142 L
.3761 .00132 L
.3764 .00141 L
.37698 .00192 L
.37761 .00269 L
.37873 .00403 L
.37937 .00467 L
.37973 .00496 L
.38005 .00518 L
.38063 .00547 L
.38094 .00557 L
.38127 .00562 L
.38187 .0056 L
.3822 .00552 L
.38251 .00541 L
.38308 .00509 L
.38369 .00463 L
.38475 .00358 L
.38533 .00291 L
.38589 .00229 L
.38642 .00178 L
.387 .00147 L
.38753 .00157 L
.38801 .00191 L
.38904 .00287 L
.39001 .00371 L
.39056 .00409 L
.39116 .0044 L
.3917 .00457 L
.3922 .00465 L
.39275 .00464 L
.39334 .00452 L
.39364 .00443 L
.39396 .00429 L
.39454 .00399 L
Mistroke
.39685 .00227 L
.39741 .00183 L
.39801 .00144 L
.39836 .00129 L
.39868 .00121 L
.39898 .00121 L
.3993 .00126 L
.39962 .00138 L
.39996 .00154 L
.40058 .00188 L
.4013 .00228 L
.40198 .00261 L
.40261 .00287 L
.40294 .00298 L
.40328 .00308 L
.4039 .00321 L
.40446 .00328 L
.40505 .0033 L
.40558 .00326 L
.40619 .00317 L
.40678 .00304 L
.40731 .00287 L
.40781 .00268 L
.40894 .00215 L
.41017 .00143 L
.41132 .00067 L
.41163 .00048 L
.41196 .00034 L
.41232 .00036 L
.41265 .00052 L
.41386 .00137 L
.41495 .00215 L
.41614 .0029 L
.41669 .00318 L
.41726 .00342 L
.41776 .00358 L
.4183 .0037 L
.41862 .00374 L
.41892 .00375 L
.41926 .00374 L
.41958 .0037 L
.42016 .00357 L
.42048 .00345 L
.42079 .00332 L
.42188 .00264 L
.42249 .00213 L
.42305 .00159 L
.42359 .00103 L
.42415 .00039 L
.42464 .00022 L
Mistroke
.42517 .00085 L
.42627 .00218 L
.42746 .00346 L
.42804 .00398 L
.42858 .00439 L
.42907 .00467 L
.42961 .00488 L
.43011 .00497 L
.43065 .00497 L
.43111 .00487 L
.43162 .00466 L
.43218 .0043 L
.43271 .00386 L
.43391 .00253 L
.43451 .00173 L
.43508 .00093 L
.43539 .00052 L
.43573 .00035 L
.43632 .00107 L
.43732 .00249 L
.43838 .00382 L
.43899 .00444 L
.43955 .00488 L
.44011 .0052 L
.44064 .00537 L
.44125 .00542 L
.44182 .00531 L
.44214 .00518 L
.44244 .00503 L
.4431 .00455 L
.44375 .00393 L
.44444 .00313 L
.44505 .00234 L
.44571 .00144 L
.44632 .0007 L
.44689 .0007 L
.44749 .00141 L
.44814 .00223 L
.4492 .00343 L
.44981 .00397 L
.45037 .00436 L
.45091 .00462 L
.45148 .00477 L
.4521 .0048 L
.45266 .0047 L
.45316 .00452 L
.45369 .00423 L
.45478 .00341 L
.45598 .00224 L
.45664 .00155 L
Mistroke
.45696 .00122 L
.45726 .00095 L
.45784 .00061 L
.45814 .00065 L
.45847 .00085 L
.45956 .00176 L
.46059 .00253 L
.46116 .00287 L
.4617 .00312 L
.4622 .0033 L
.46275 .00343 L
.46324 .00349 L
.4637 .0035 L
.46424 .00345 L
.46475 .00335 L
.46531 .00319 L
.46591 .00297 L
.46713 .00236 L
.46825 .00167 L
Mfstroke
.46825 .00167 m
.46864 .00144 L
.46906 .00122 L
.46946 .00104 L
.46984 .00089 L
.47024 .00075 L
.47063 .00064 L
.47105 .00054 L
.47145 .00046 L
.47183 .00039 L
.47224 .00032 L
.47263 .00027 L
.47301 .00023 L
.47341 .00019 L
.4738 .00016 L
.47421 .00013 L
.47461 .00011 L
.47499 9e-005 L
.4754 8e-005 L
.47579 6e-005 L
.47621 5e-005 L
.47661 5e-005 L
.47699 4e-005 L
.47719 4e-005 L
.47729 4e-005 L
.4774 4e-005 L
.4775 4e-005 L
.4776 4e-005 L
.47764 4e-005 L
.47769 3e-005 L
.47774 3e-005 L
.47778 3e-005 L
s
.47778 3e-005 m
.48762 .00015 L
.49263 .00021 L
.498 .00026 L
.50085 .00028 L
.50345 .00029 L
.5047 .00029 L
.50536 .0003 L
.50605 .0003 L
.50666 .0003 L
.50734 .0003 L
.50795 .0003 L
.50852 .0003 L
.50889 .0003 L
.50923 .0003 L
.50961 .0003 L
.51001 .0003 L
.51039 .0003 L
.51075 .0003 L
.51142 .0003 L
.51208 .0003 L
.5127 .00029 L
.51407 .00029 L
.51546 .00028 L
.51698 .00028 L
.52005 .00026 L
.52539 .00021 L
.53026 .00015 L
.53594 8e-005 L
.53844 5e-005 L
.53913 4e-005 L
.53987 3e-005 L
.54021 3e-005 L
.54056 3e-005 L
.5412 3e-005 L
.54178 3e-005 L
.5424 3e-005 L
.54299 3e-005 L
.54352 4e-005 L
.54605 7e-005 L
.55119 .00013 L
.55684 .00019 L
.55933 .00021 L
.56206 .00023 L
.56457 .00025 L
.56693 .00026 L
.56823 .00026 L
.56942 .00026 L
.57008 .00027 L
.57042 .00027 L
Mistroke
.57079 .00027 L
.57147 .00027 L
.5721 .00027 L
.57245 .00027 L
.57283 .00027 L
.57351 .00027 L
.57389 .00027 L
.57424 .00027 L
.57504 .00027 L
.57574 .00026 L
.57638 .00026 L
.57781 .00026 L
.57908 .00025 L
.58046 .00025 L
.58298 .00023 L
.58791 .0002 L
.59335 .00014 L
.59909 8e-005 L
.6016 5e-005 L
.60293 3e-005 L
.60366 3e-005 L
.60435 2e-005 L
.60499 2e-005 L
.60536 2e-005 L
.60569 2e-005 L
.60629 2e-005 L
.60691 3e-005 L
.60929 6e-005 L
.61449 .00011 L
.61976 .00017 L
.62266 .00019 L
.62542 .00021 L
.62799 .00022 L
.62934 .00023 L
.63078 .00023 L
.63199 .00024 L
.63263 .00024 L
.63333 .00024 L
.63396 .00024 L
.63454 .00024 L
.6351 .00024 L
.63568 .00024 L
.63628 .00024 L
.63683 .00024 L
.63746 .00024 L
.63805 .00024 L
.6386 .00024 L
.63911 .00024 L
.64026 .00024 L
.64142 .00024 L
Mistroke
.64269 .00023 L
.64527 .00022 L
.64799 .00021 L
.65058 .00019 L
.65544 .00015 L
.66073 9e-005 L
.66363 6e-005 L
.66506 5e-005 L
.66637 3e-005 L
.66764 2e-005 L
.66828 2e-005 L
.66864 1e-005 L
.66898 1e-005 L
.66935 1e-005 L
.66969 2e-005 L
.67034 2e-005 L
.67181 4e-005 L
.67674 9e-005 L
.68131 .00013 L
.68636 .00017 L
.6888 .00019 L
.69142 .0002 L
.69287 .00021 L
.69419 .00021 L
.69554 .00022 L
.69679 .00022 L
.69788 .00022 L
.69848 .00022 L
.69904 .00022 L
.69964 .00022 L
.7003 .00023 L
.70092 .00022 L
.70149 .00022 L
.70208 .00022 L
.70263 .00022 L
.70324 .00022 L
.70389 .00022 L
.70522 .00022 L
.70643 .00022 L
.70894 .00021 L
.7116 .00019 L
.7164 .00016 L
.72725 6e-005 L
.72988 3e-005 L
.73057 3e-005 L
.73132 2e-005 L
.73168 2e-005 L
.73202 1e-005 L
.73265 1e-005 L
.73302 1e-005 L
Mistroke
.73335 1e-005 L
.73372 1e-005 L
.7341 2e-005 L
.73569 3e-005 L
.73849 6e-005 L
.74358 .00011 L
.74905 .00015 L
.75179 .00017 L
.75439 .00019 L
.75672 .0002 L
.75806 .0002 L
.75927 .0002 L
.76051 .00021 L
.76167 .00021 L
.76231 .00021 L
.7629 .00021 L
.76355 .00021 L
.76423 .00021 L
.76478 .00021 L
.76537 .00021 L
.76593 .00021 L
.76643 .00021 L
.76702 .00021 L
.76767 .00021 L
.76884 .00021 L
.77006 .0002 L
.77138 .0002 L
.77376 .00019 L
.77919 .00016 L
.78492 .00011 L
.79018 7e-005 L
.79266 4e-005 L
.79402 3e-005 L
.79469 2e-005 L
.79531 2e-005 L
.79588 1e-005 L
.79651 1e-005 L
.79714 1e-005 L
.79781 1e-005 L
.80008 4e-005 L
.80574 9e-005 L
.81091 .00013 L
.81341 .00015 L
.81613 .00017 L
.81873 .00018 L
.82108 .00019 L
.8224 .00019 L
.82383 .0002 L
.82462 .0002 L
.82534 .0002 L
Mistroke
.82603 .0002 L
.82641 .0002 L
.82676 .0002 L
.82738 .0002 L
.82805 .0002 L
.82868 .0002 L
.82926 .0002 L
.82995 .0002 L
.83058 .0002 L
.83128 .0002 L
.83202 .0002 L
.83327 .0002 L
.83458 .00019 L
.83693 .00018 L
.83946 .00017 L
.84222 .00016 L
.85179 8e-005 L
.85433 6e-005 L
.85708 3e-005 L
.85834 2e-005 L
.85903 2e-005 L
.85968 1e-005 L
.86023 1e-005 L
.86082 1e-005 L
.86147 1e-005 L
.86207 2e-005 L
.86782 7e-005 L
.87304 .00011 L
.87787 .00015 L
.88052 .00016 L
.88301 .00017 L
.88569 .00018 L
.88711 .00019 L
.88785 .00019 L
.88865 .00019 L
.88929 .00019 L
.88997 .00019 L
.89035 .00019 L
.8907 .00019 L
.89137 .00019 L
.89199 .00019 L
.89266 .00019 L
.89329 .00019 L
.89387 .00019 L
.89452 .00019 L
.89514 .00019 L
.89631 .00019 L
.89756 .00019 L
.89893 .00018 L
.90139 .00018 L
Mistroke
.90367 .00017 L
.9089 .00013 L
.91447 9e-005 L
.91985 4e-005 L
.92133 3e-005 L
.92289 2e-005 L
.92353 1e-005 L
.92422 1e-005 L
.92461 0 L
.92497 1e-005 L
.92533 1e-005 L
.92568 1e-005 L
.93623 .0001 L
.94129 .00014 L
.94406 .00015 L
.94665 .00017 L
.94886 .00018 L
.95124 .00018 L
.95252 .00019 L
.95322 .00019 L
.95388 .00019 L
.95444 .00019 L
.95503 .00019 L
.95569 .00019 L
.9563 .00019 L
.95689 .00019 L
.95744 .00019 L
.95805 .00019 L
.95871 .00019 L
.95939 .00019 L
.96004 .00019 L
.96126 .00018 L
.96345 .00018 L
.96584 .00017 L
.96844 .00016 L
.97121 .00014 L
.97619 .00011 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0>1oo`800?Aoo`003gooo`00^00047oo000JOol00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomo
o`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool20003Ool0
0`00Oomoo`02Ool20003Ool90002Ool4000017oo000000000Woo0`0000=oo`0000001P0000=oo`00
00000P0000=oo`00Ool010000Woo0`0000Aoo`00001oo`@0009oo`@00004Ool00000Ool300000goo
00000002000017oo000007oo10000goo00<007ooOol01goo00<007ooOol02goo00<007ooOol02goo
00<007ooOol02goo00<007ooOol02goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol02goo
00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo
00<007ooOol02goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol06Goo000eOol00`00Oomo
o`0lOol30002Ool400000goo0000000200000goo000000040008Ool400000goo00000002000017oo
000000000Woo0`002Goo0P000Woo0`000Woo0`000Woo0`000goo00<007ooOol027oo0P000Woo0`00
0Woo0`001Goo00D007ooOomoo`0002Eoo`03001oogoo049oo`03001oogoo04=oo`03001oogoo049o
o`00M7oo00<007ooOol00`000Woo0`000Woo0`00?7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00L7oo1000C7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Kgoo0P00Cgoo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00KWoo00<007ooOol0Cgoo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00KGoo0P00DGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Jgoo0`00DWoo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00JWoo0P00E7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00JWoo00<007ooOol0Dgoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00JGoo00<007ooOol0
E7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00J7oo00<007ooOol0EGoo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00Igoo00<007ooOol0EWoo0`006Goo00D007ooOomoo`000?Eoo`00IWoo
00<007ooOol0Egoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00IGoo00<007ooOol0F7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00IGoo00<007ooOol0F7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00I7oo00<007ooOol0FGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Hgoo
00<007ooOol0FWoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00HWoo00<007ooOol0Fgoo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00HGoo00<007ooOol0G7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00HGoo00<007ooOol0G7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00H7oo
00<007ooOol0GGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Ggoo00<007ooOol0GWoo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00GWoo00<007ooOol0Ggoo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00GWoo00<007ooOol0Ggoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00GGoo
00<007ooOol0H7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00GGoo00<007ooOol0H7oo0`00
6Goo00D007ooOomoo`000?Eoo`00G7oo00<007ooOol0HGoo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00G7oo00<007ooOol0HGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Fgoo00<007oo
Ool0HWoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Fgoo00<007ooOol0HWoo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00Fgoo00<007ooOol0HWoo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00FWoo00<007ooOol0Hgoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00FWoo00<007oo
Ool0Hgoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00FGoo00<007ooOol0I7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00FGoo00<007ooOol0I7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00F7oo00<007ooOol0IGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00F7oo00<007oo
Ool0IGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00F7oo00<007ooOol0IGoo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00Egoo00<007ooOol0IWoo0`006Goo00D007ooOomoo`000?Eoo`00
Egoo00<007ooOol0IWoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00EWoo00<007ooOol0Igoo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00EWoo00<007ooOol0Igoo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00EWoo00<007ooOol0Igoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
EGoo00<007ooOol0J7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00EGoo00<007ooOol0J7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00E7oo00<007ooOol0JGoo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`006Woo00<007ooOol0=goo00<007ooOol0JGoo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`006Woo00<007ooOol0=Woo00<007ooOol0JWoo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`006goo00<007ooOol0=Goo00<007ooOol0GWoo1P001Woo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`006goo00<007ooOol0=Goo00<007ooOol0GWoo00<007ooOol02Goo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`006goo00<007ooOol0=7oo00<007ooOol0H7oo00<007ooOol027oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`0077oo00<007ooOol0<goo00<007ooOol0HGoo00<0
07ooOol01goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`0077oo00<007ooOol0<goo00<007oo
Ool0HWoo00<007ooOol01Woo100067oo00D007ooOomoo`000?Eoo`0077oo00<007ooOol0<Woo00<0
07ooOol0I7oo00<007ooOol01Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`007Goo00<007oo
Ool0<Goo00<007ooOol0IGoo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
7Goo00<007ooOol0<7oo00<007ooOol0IWoo00<007ooOol017oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`007Goo00<007ooOol0<7oo00<007ooOol0HGoo00<007ooOol00Woo00<007ooOol017oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`007Woo00<007ooOol0;goo00<007ooOol0HWoo1000
1goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`007Woo00<007ooOol0;Woo00<007ooOol0KWoo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`007Woo00<007ooOol0;Woo00<007ooOol0KWoo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`007Woo00<007ooOol0;Woo00<007ooOol0KWoo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`007goo00<007ooOol0;7oo00<007ooOol0Kgoo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`007goo00<007ooOol0;7oo00<007ooOol0Kgoo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`007goo00<007ooOol0;7oo00<007ooOol0Kgoo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`0087oo00<007ooOol0:Woo00<007ooOol0L7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`0087oo00<007ooOol0:Woo00<007ooOol0L7oo0`006Goo00D007ooOomoo`000?Eo
o`0087oo00<007ooOol0:Woo00<007ooOol0L7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
8Goo00<007ooOol0:7oo00<007ooOol0LGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`008Goo
00<007ooOol0:7oo00<007ooOol0LGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`008Goo00<0
07ooOol09goo00<007ooOol0LWoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`008Woo00<007oo
Ool09Woo00<007ooOol0LWoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`008Woo00<007ooOol0
9Woo00<007ooOol0LWoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`008Woo00<007ooOol09Goo
00<007ooOol0Lgoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`008goo00<007ooOol097oo00<0
07ooOol0Lgoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`008goo00<007ooOol097oo00<007oo
Ool0Lgoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`008goo00<007ooOol08goo00<007ooOol0
M7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`0097oo00<007ooOol08Woo00<007ooOol0M7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`0097oo00<007ooOol08Goo00<007ooOol0MGoo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`0097oo00<007ooOol08Goo00<007ooOol0MGoo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`0097oo00<007ooOol08Goo00<007ooOol0MGoo0`006Goo00D0
07ooOomoo`000?Eoo`009Goo00<007ooOol07goo00<007ooOol0MWoo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`009Goo00<007ooOol07goo00<007ooOol0MWoo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`009Goo00<007ooOol07goo00<007ooOol0MWoo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`009Woo00<007ooOol07Goo00<007ooOol0Mgoo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`009Woo00<007ooOol07Goo00<007ooOol0Mgoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
9Woo00<007ooOol077oo00<007ooOol0N7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`009goo
00<007ooOol06goo00<007ooOol0N7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`009goo00<0
07ooOol06goo00<007ooOol0N7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`009goo00<007oo
Ool06Woo00<007ooOol0NGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00:7oo00<007ooOol0
6Goo00<007ooOol0NGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00:7oo00<007ooOol06Goo
00<007ooOol0NGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00:7oo00<007ooOol067oo00<0
07ooOol0NWoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00:Goo00<007ooOol05goo00<007oo
Ool0NWoo0`006Goo00D007ooOomoo`000?Eoo`00:Goo00<007ooOol05Woo00<007ooOol0Ngoo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00:Goo00<007ooOol05Woo00<007ooOol0Ngoo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00:Woo00<007ooOol057oo00<007ooOol0O7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00:Woo00<007ooOol057oo00<007ooOol0O7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00:Woo00<007ooOol04goo00<007ooOol0OGoo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00:goo00<007ooOol04Woo00<007ooOol0OGoo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00:goo00<007ooOol04Goo00<007ooOol0OWoo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00;7oo00<007ooOol047oo00<007ooOol0OWoo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00;7oo00<007ooOol03goo00<007ooOol0Ogoo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00;Goo00<007ooOol03Woo00<007ooOol0MWoo0`001Woo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00;Goo00<007ooOol03Woo00<007ooOol0Mgoo00<007ooOol01Goo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00;Goo0P003Woo00<007ooOol0N7oo00<007ooOol01Goo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00;Woo00<007ooOol037oo00<007ooOol0M7oo1P001Woo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00;goo00<007ooOol02goo00<007ooOol0M7oo00D007ooOomoo`00
00Moo`@001Qoo`05001oogooOol0003eOol0031oo`03001oogoo00Uoo`03001oogoo07Ioo`04001o
ogoo0007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000aOol00`00Oomoo`06Ool2001jOol0
0`00Ool00007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000aOol20006Ool00`00Oomoo`1j
Ool00`00Ool00007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000bOol40002Ool2001mOol2
0007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000eOol4001oOol00`00Oomoo`05Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3
000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo002eOol40007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002d
Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol0
0`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00
Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol20003Ool0
0`00Oomoo`04Ool4000HOol01@00Oomoogoo0000mGoo002dOol00`00Ool000020007Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo002dOol00`00Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002eOol00`00
Oomoo`08Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002fOol30007Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo002eOol40007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomo
o`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02
Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool0
0`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00
Oomoo`04Ool4000HOol5003eOol00;Eoo`@000Moo`03001oogoo0?mooaAoo`00]7oo00<007ooOol0
0Woo00<007ooOol017oo00<007ooOol0ogoo57oo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool0
0`00Oomoo`3oOolDOol00;Aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0?mooaAoo`00
]Goo10001goo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mo
oaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mo
oaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool3003oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00[7oo1@0017oo1000
1goo00<007ooOol0ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool0
0`00Oomoo`3oOolDOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`03001o
ogoo0?mooaAoo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0
ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool4003oOolCOol00:io
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo0?mooa]oo`00[Woo00<007ooOol00goo00<0
07ooOol00Woo00<007ooOol0ogoo6goo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomo
o`3oOolKOol00:aoo`<000Eoo`03001oogoo009oo`03001oogoo0?mooa]oo`00\
\>"],
  ImageRangeCache->{{{0, 469}, {289.313, 0}} -> {-13.8869, -0.535215, 
  0.0720124, 0.03699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .03432 m
.03259 .04995 L
.04184 .07163 L
.0615 .1308 L
.07926 .18718 L
.08916 .21576 L
.09817 .23702 L
.10034 .24168 L
.10265 .2473 L
.10386 .24958 L
.10454 .25055 L
.10518 .25127 L
.10631 .25218 L
.10752 .25294 L
.11211 .25748 L
.11326 .25878 L
.11382 .25932 L
.11434 .25974 L
.1148 .26004 L
.11531 .2603 L
.11582 .26047 L
.11636 .26057 L
.11693 .26057 L
.11754 .26049 L
.11812 .26035 L
.11865 .26017 L
.11991 .25968 L
.12046 .25948 L
.12108 .25928 L
.12169 .25913 L
.12203 .25908 L
.12234 .25904 L
.12269 .25901 L
.12301 .259 L
.12335 .25899 L
.12372 .259 L
.12402 .25901 L
.12434 .25901 L
.12492 .25901 L
.12527 .25898 L
.1256 .25893 L
.1259 .25886 L
.12623 .25875 L
.12681 .25847 L
.12735 .25807 L
.12795 .2575 L
.12859 .25671 L
.1311 .25256 L
.13231 .25063 L
.13345 .24922 L
Mistroke
.13448 .24832 L
.1356 .24752 L
.13618 .24706 L
.1368 .24647 L
.13747 .24562 L
.13809 .24462 L
.1392 .24223 L
.14043 .23893 L
.1448 .22862 L
.15459 .20327 L
.17348 .14748 L
.19166 .09654 L
.20093 .07336 L
.21099 .05322 L
.21216 .05235 L
.21277 .052 L
.21341 .05158 L
.21398 .05111 L
.2146 .05044 L
.21569 .04877 L
.21691 .04617 L
.21805 .04339 L
.2194 .04032 L
.22006 .03911 L
.22067 .03824 L
.2212 .03767 L
.22176 .03725 L
.22232 .03697 L
.22294 .03677 L
.22349 .03663 L
.22401 .03646 L
.22448 .03627 L
.22499 .03596 L
.22559 .03547 L
.22614 .03486 L
.22738 .03303 L
.22961 .02886 L
.23066 .02714 L
.23123 .02639 L
.23177 .02584 L
.23235 .02538 L
.23265 .0252 L
.23298 .02503 L
.23356 .02482 L
.23409 .02467 L
.23513 .02438 L
.23572 .02416 L
.23626 .02388 L
.23725 .02316 L
.23831 .0221 L
Mistroke
.24792 .01419 L
.25231 .0113 L
.25347 .00999 L
.25474 .00858 L
.25532 .00803 L
.25593 .00756 L
.25651 .00726 L
.25704 .00711 L
.25762 .00707 L
.25815 .00714 L
.25873 .00729 L
.25934 .00748 L
.25984 .00763 L
.26037 .00777 L
.26096 .00786 L
.2615 .00788 L
.26203 .00782 L
.2626 .00766 L
.26314 .00743 L
.26364 .00714 L
.26458 .00642 L
.26558 .00547 L
.2667 .00433 L
.2673 .00376 L
.26787 .00334 L
.26835 .00312 L
.26887 .00308 L
.26944 .00326 L
.26996 .0036 L
.27222 .00563 L
.27284 .00611 L
.27318 .00632 L
.2735 .0065 L
.27406 .00672 L
.27468 .00684 L
.27524 .00682 L
.27578 .00669 L
.27627 .00648 L
.27679 .00616 L
.27797 .00515 L
.27854 .00459 L
.27907 .00406 L
.27957 .00363 L
.28012 .00333 L
.28062 .00326 L
.28107 .00341 L
.28157 .00375 L
.28211 .00428 L
.28321 .00549 L
.28378 .00608 L
Mistroke
.28439 .00662 L
.2847 .00685 L
.28505 .00705 L
.28567 .0073 L
.28624 .00737 L
.28657 .00735 L
.28687 .00729 L
.28744 .00707 L
.28799 .00674 L
.29009 .00482 L
.2907 .00429 L
.29127 .00393 L
.29178 .00378 L
.29234 .00384 L
.29295 .00413 L
.29326 .00433 L
.2936 .00459 L
.29476 .00551 L
.29532 .0059 L
.29592 .00622 L
.29649 .00643 L
.29701 .00652 L
.29732 .00653 L
.29766 .00651 L
.29826 .00637 L
.2986 .00625 L
.29891 .00611 L
.29963 .0057 L
.30091 .00477 L
.30154 .0043 L
.30211 .00391 L
.30262 .00362 L
.30317 .0034 L
.30375 .00329 L
.3043 .0033 L
.3049 .00342 L
.30521 .00352 L
.30554 .00364 L
.30669 .0041 L
.30731 .00433 L
.3079 .00451 L
.30822 .00459 L
.30857 .00466 L
.30919 .00473 L
.30977 .00474 L
.3101 .00473 L
.3104 .00469 L
.31098 .00459 L
.31152 .00444 L
.31202 .00426 L
Mistroke
.31257 .00402 L
.31368 .00343 L
.31472 .00279 L
.31567 .00222 L
.31625 .00194 L
.31679 .00178 L
.31737 .00177 L
.31769 .00183 L
.31799 .00194 L
.31849 .00218 L
.31904 .00251 L
.32016 .00324 L
.32135 .00395 L
.32193 .00422 L
.32246 .00441 L
.32302 .00455 L
.32361 .00461 L
.32392 .00461 L
.32426 .00458 L
.32488 .00444 L
.3254 .00425 L
.32597 .00394 L
.32713 .0031 L
.32819 .00215 L
.32871 .00173 L
.3292 .00149 L
.32981 .00156 L
.33013 .00176 L
.33047 .00206 L
.33163 .00335 L
.33227 .00407 L
.33297 .00477 L
.33358 .00528 L
.33392 .0055 L
.33423 .00568 L
.33479 .00589 L
.3354 .00598 L
.33591 .00593 L
.33647 .00574 L
.33679 .00558 L
.33713 .00535 L
.33776 .00482 L
.33894 .00354 L
.3395 .00288 L
.34003 .00234 L
.34065 .00203 L
.34121 .00219 L
.34174 .00267 L
.34223 .00327 L
.34334 .00467 L
Mistroke
.34398 .00537 L
.34458 .00591 L
.34511 .00626 L
.34569 .0065 L
.346 .00656 L
.34633 .00657 L
.34667 .00653 L
.347 .00644 L
.34758 .00616 L
.3479 .00594 L
.3482 .0057 L
.34937 .00448 L
.35061 .00303 L
.35092 .00273 L
.35126 .00249 L
.35163 .00235 L
.35198 .00237 L
.3523 .0025 L
.35263 .00275 L
.35324 .00333 L
.35434 .00448 L
.35495 .00502 L
.35552 .00543 L
.35584 .00561 L
.35619 .00575 L
.35681 .00589 L
.35711 .0059 L
.35743 .00588 L
.35801 .00573 L
.36028 .00414 L
.36148 .00302 L
.36182 .00273 L
.36215 .00249 L
.36275 .0022 L
.36334 .00215 L
.36388 .0023 L
.36447 .0026 L
.36509 .00299 L
.36613 .00362 L
.36671 .0039 L
.36725 .0041 L
.36778 .00423 L
.36834 .00431 L
.36886 .00432 L
.36934 .00427 L
.36979 .00419 L
.37028 .00405 L
.3708 .00386 L
.37128 .00365 L
.37359 .0023 L
Mistroke
.37411 .00196 L
.37468 .00163 L
.37521 .00136 L
.3757 .00121 L
.37625 .00118 L
.37677 .0013 L
.37733 .00154 L
.37794 .00188 L
.38007 .00305 L
.38068 .00332 L
.38126 .00352 L
.38186 .00367 L
.38218 .00372 L
.38252 .00376 L
.38312 .00377 L
.3837 .00371 L
.38421 .00359 L
.38477 .0034 L
.38723 .00178 L
.38782 .00124 L
.38814 .00095 L
.38847 .00068 L
.38884 .00051 L
.38917 .00061 L
.38949 .00087 L
.38984 .00122 L
.39209 .00359 L
.3927 .00411 L
.39335 .00456 L
.39391 .00485 L
.39452 .00503 L
.39514 .00508 L
.39548 .00505 L
.3958 .00497 L
.39641 .00471 L
.39699 .00433 L
.39756 .00383 L
.3981 .00327 L
.39931 .00176 L
.39988 .00106 L
.40042 .00078 L
.4009 .00117 L
.40142 .00187 L
.40258 .00349 L
.40367 .00476 L
.40424 .00526 L
.40485 .00566 L
.4052 .00581 L
.40553 .00589 L
.40582 .00593 L
Mistroke
.40614 .00592 L
.40646 .00586 L
.4068 .00575 L
.40716 .00556 L
.4075 .00534 L
.40811 .00481 L
.40876 .0041 L
.40995 .00251 L
.41026 .00207 L
.4106 .00163 L
.4112 .0011 L
.41176 .0013 L
.41227 .00189 L
.41344 .00344 L
.41452 .00463 L
.41513 .00512 L
.41571 .00544 L
.41631 .00562 L
.41686 .00564 L
.41717 .00559 L
.4175 .00549 L
.41811 .0052 L
.41867 .0048 L
.41919 .00434 L
.42034 .0031 L
.42134 .00192 L
.42185 .00143 L
.4224 .00116 L
.42272 .00121 L
.42305 .0014 L
.42366 .00193 L
.42481 .00301 L
.42551 .00355 L
.42585 .00377 L
.42617 .00395 L
.42676 .00419 L
.42708 .00427 L
.42741 .00433 L
.42796 .00436 L
.42856 .00429 L
.42913 .00413 L
.42965 .00392 L
.43025 .00361 L
.43091 .00319 L
.43211 .00231 L
.4333 .00139 L
.43363 .00116 L
.43397 .00095 L
.43459 .00074 L
.43517 .00084 L
Mistroke
.4357 .00111 L
.43693 .00186 L
.43801 .00245 L
.43903 .00289 L
.4396 .00307 L
.44021 .00322 L
.44077 .0033 L
.44129 .00333 L
.44185 .00331 L
.44245 .00324 L
.44302 .00312 L
.44355 .00296 L
.44413 .00273 L
.44476 .00242 L
.44604 .00162 L
.4473 .00062 L
.44766 .00033 L
.44801 .00017 L
.44831 .00035 L
.44865 .00065 L
.44982 .00174 L
.45108 .00286 L
.45215 .00365 L
.45266 .00395 L
.45313 .00417 L
.4536 .00433 L
.45412 .00443 L
.45457 .00446 L
.45505 .00441 L
.45562 .00425 L
.45623 .00395 L
.45681 .00355 L
.45734 .0031 L
.45842 .00193 L
.45894 .00127 L
.45942 .00065 L
.45993 .00025 L
.46041 .00083 L
.46147 .00232 L
.46264 .0038 L
.46315 .00434 L
.46372 .00484 L
.46426 .00521 L
.46477 .00545 L
.46531 .00557 L
.46589 .00556 L
.46649 .00538 L
.4668 .00522 L
.46713 .00501 L
.46771 .00451 L
Mistroke
.46825 .00393 L
Mfstroke
.46825 .00393 m
.46864 .00351 L
.46906 .0031 L
.46946 .00276 L
.46984 .00247 L
.47024 .00219 L
.47063 .00195 L
.47105 .00173 L
.47145 .00154 L
.47183 .00138 L
.47224 .00123 L
.47263 .0011 L
.47301 .00098 L
.47341 .00088 L
.4738 .00078 L
.47421 .0007 L
.47461 .00063 L
.47499 .00056 L
.4754 .00051 L
.47579 .00046 L
.47621 .00042 L
.47661 .00038 L
.47699 .00036 L
.47719 .00035 L
.47729 .00035 L
.4774 .00035 L
.4775 .00035 L
.4776 .00034 L
.47764 .00034 L
.47766 .00034 L
.47769 .00034 L
.47771 .00034 L
.47772 .00034 L
.47774 .00034 L
.47775 .00034 L
.47776 .00034 L
.47777 .00034 L
.47778 .00034 L
s
.47778 .00034 m
.47839 .00034 L
.47895 .00034 L
.4796 .00034 L
.48021 .00034 L
.4813 .00034 L
.48248 .00033 L
.48515 .00032 L
.48762 .0003 L
.49266 .00025 L
.498 .00018 L
.50305 .00011 L
.50584 7e-005 L
.50721 5e-005 L
.50788 4e-005 L
.50849 4e-005 L
.50886 3e-005 L
.50921 3e-005 L
.50958 3e-005 L
.50998 3e-005 L
.51039 3e-005 L
.51083 4e-005 L
.5112 4e-005 L
.51161 4e-005 L
.51446 8e-005 L
.52005 .00016 L
.52529 .00022 L
.53026 .00026 L
.533 .00028 L
.53455 .00029 L
.53598 .00029 L
.53719 .00029 L
.53787 .0003 L
.53851 .0003 L
.53919 .0003 L
.53981 .0003 L
.54049 .0003 L
.54083 .0003 L
.5412 .0003 L
.54189 .0003 L
.54253 .0003 L
.54323 .0003 L
.54397 .00029 L
.54521 .00029 L
.54658 .00029 L
.5491 .00027 L
.55147 .00026 L
.55675 .00021 L
.56243 .00015 L
.56773 8e-005 L
Mistroke
.57053 4e-005 L
.57134 3e-005 L
.57173 3e-005 L
.57209 3e-005 L
.57278 2e-005 L
.57313 2e-005 L
.57351 2e-005 L
.57416 3e-005 L
.57453 3e-005 L
.57486 3e-005 L
.57612 5e-005 L
.57897 8e-005 L
.58403 .00014 L
.58889 .00019 L
.59404 .00023 L
.59673 .00025 L
.59826 .00025 L
.59969 .00026 L
.60033 .00026 L
.601 .00026 L
.60158 .00026 L
.6022 .00027 L
.60287 .00027 L
.6035 .00027 L
.60388 .00027 L
.60424 .00027 L
.60491 .00027 L
.60552 .00027 L
.60617 .00027 L
.60678 .00026 L
.60734 .00026 L
.60871 .00026 L
.61001 .00026 L
.61259 .00024 L
.61541 .00023 L
.62042 .00019 L
.62507 .00014 L
.62976 9e-005 L
.63223 6e-005 L
.63482 3e-005 L
.63549 2e-005 L
.63586 2e-005 L
.63621 2e-005 L
.63662 2e-005 L
.63699 2e-005 L
.63734 2e-005 L
.63772 2e-005 L
.63839 3e-005 L
.6391 3e-005 L
.64038 5e-005 L
Mistroke
.6456 .00011 L
.65053 .00016 L
.65325 .00018 L
.65583 .0002 L
.65823 .00021 L
.66084 .00023 L
.66199 .00023 L
.66321 .00024 L
.66437 .00024 L
.66541 .00024 L
.66604 .00024 L
.66663 .00024 L
.66728 .00024 L
.66797 .00024 L
.66831 .00024 L
.66869 .00024 L
.66938 .00024 L
.67005 .00024 L
.67066 .00024 L
.67178 .00024 L
.67301 .00024 L
.67429 .00023 L
.67549 .00023 L
.67823 .00021 L
.68074 .0002 L
.68639 .00015 L
.69118 .00011 L
.6963 5e-005 L
.69782 3e-005 L
.69856 3e-005 L
.69924 2e-005 L
.69987 2e-005 L
.70053 1e-005 L
.70119 1e-005 L
.70156 2e-005 L
.70192 2e-005 L
.70714 7e-005 L
.71259 .00013 L
.71776 .00017 L
.72241 .0002 L
.72503 .00021 L
.72622 .00022 L
.72747 .00022 L
.72813 .00022 L
.72886 .00022 L
.72953 .00022 L
.73013 .00022 L
.73048 .00022 L
.73086 .00022 L
.73125 .00022 L
Mistroke
.73163 .00022 L
.73198 .00022 L
.73235 .00022 L
.73302 .00022 L
.73363 .00022 L
.7343 .00022 L
.73493 .00022 L
.7355 .00022 L
.7369 .00022 L
.73824 .00021 L
.74065 .00021 L
.74289 .00019 L
.74798 .00016 L
.75781 7e-005 L
.76051 4e-005 L
.76198 3e-005 L
.7627 2e-005 L
.76335 2e-005 L
.76396 1e-005 L
.76453 1e-005 L
.76513 1e-005 L
.76578 2e-005 L
.76845 4e-005 L
.77427 .0001 L
.77965 .00015 L
.78477 .00018 L
.78735 .00019 L
.78872 .0002 L
.79021 .0002 L
.79154 .00021 L
.79278 .00021 L
.79346 .00021 L
.79409 .00021 L
.79443 .00021 L
.79481 .00021 L
.79549 .00021 L
.79607 .00021 L
.79671 .00021 L
.79738 .00021 L
.79801 .00021 L
.79859 .00021 L
.79913 .00021 L
.80033 .00021 L
.80172 .0002 L
.80301 .0002 L
.80593 .00019 L
.8085 .00017 L
.81124 .00016 L
.82171 7e-005 L
.82458 4e-005 L
Mistroke
.82614 2e-005 L
.82691 2e-005 L
.82724 1e-005 L
.82761 1e-005 L
.82825 1e-005 L
.82885 1e-005 L
.82919 1e-005 L
.82955 1e-005 L
.83019 2e-005 L
.83302 5e-005 L
.83824 .0001 L
.84385 .00014 L
.84644 .00016 L
.84916 .00017 L
.8517 .00018 L
.85401 .00019 L
.85523 .0002 L
.85638 .0002 L
.85697 .0002 L
.8576 .0002 L
.85828 .0002 L
.85891 .0002 L
.85945 .0002 L
.86003 .0002 L
.86058 .0002 L
.86108 .0002 L
.86166 .0002 L
.8623 .0002 L
.8629 .0002 L
.86346 .0002 L
.86469 .0002 L
.86584 .00019 L
.86847 .00018 L
.87103 .00017 L
.87379 .00016 L
.88405 8e-005 L
.88687 5e-005 L
.88841 4e-005 L
.88988 2e-005 L
.89124 1e-005 L
.89161 1e-005 L
.892 1e-005 L
.89234 1e-005 L
.89271 1e-005 L
.89336 1e-005 L
.89405 2e-005 L
.8953 3e-005 L
.9052 .00012 L
.91081 .00015 L
.91349 .00017 L
Mistroke
.91601 .00018 L
.91736 .00018 L
.91882 .00019 L
.92014 .00019 L
.92136 .00019 L
.92205 .00019 L
.92269 .00019 L
.92306 .00019 L
.92339 .00019 L
.92378 .00019 L
.92414 .00019 L
.92449 .00019 L
.92487 .00019 L
.92555 .00019 L
.92592 .00019 L
.92627 .00019 L
.92707 .00019 L
.92836 .00019 L
.92971 .00019 L
.93213 .00018 L
.93474 .00017 L
.93759 .00015 L
.94331 .00011 L
.94871 7e-005 L
.95356 3e-005 L
.95489 1e-005 L
.95524 1e-005 L
.95562 1e-005 L
.9563 0 L
.95692 1e-005 L
.9575 1e-005 L
.95882 2e-005 L
.97619 .00016 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0?moomMoo`003gooo`00^00047oo000JOol00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`0;
Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`06
Ool20003Ool20004Ool01000Oomoogoo0`0000=oo`000000100000=oo`0000000P000Woo0P000goo
0P000Woo1`000Woo0`000Woo00@007oo001oo`800004Ool000000002Ool00`00Ool0000300000goo
000000030002Ool01000Ool007oo0P0000=oo`0000000Woo00<007ooOol01goo00<007ooOol02goo
00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02Woo00<007ooOol02goo
00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo
00<007ooOol02goo00<007ooOol02goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol06Goo
000eOol00`00Oomoo`13Ool00`00Oomoo`05Ool200000goo0000000200001Woo001oogoo001oo`@0
009oo`<000=oo`<0009oo`<00003Ool0000000800004Ool000000003Ool20009Ool30002Ool30002
Ool30002Ool2000:Ool20002Ool30003Ool00`00Oomoo`0SOol00`00Oomoo`12Ool00`00Oomoo`13
Ool00`00Oomoo`12Ool007moo`D000=oo`8000=oo`8000=oo`03001oogoo01=oo`03001oogoo01Io
o`03001oogoo01Uoo`05001oogooOol0003eOol007ioo`03001oogoo03moo`03001oogoo01Uoo`05
001oogooOol0003eOol007ioo`03001oogoo03moo`03001oogoo01Uoo`05001oogooOol0003eOol0
07aoo`80049oo`03001oogoo01Uoo`05001oogooOol0003eOol007]oo`03001oogoo049oo`03001o
ogoo01Uoo`05001oogooOol0003eOol007Uoo`8004Eoo`03001oogoo01Uoo`05001oogooOol0003e
Ool007Qoo`03001oogoo04Eoo`03001oogoo01Uoo`05001oogooOol0003eOol007Ioo`8004Qoo`03
001oogoo01Uoo`05001oogooOol0003eOol007Aoo`8004Yoo`03001oogoo01Uoo`05001oogooOol0
003eOol007Aoo`03001oogoo04Uoo`03001oogoo01Uoo`05001oogooOol0003eOol007=oo`03001o
ogoo04Yoo`<001Uoo`05001oogooOol0003eOol007=oo`03001oogoo04Yoo`03001oogoo01Uoo`05
001oogooOol0003eOol001Yoo`03001oogoo05Eoo`03001oogoo04]oo`03001oogoo01Uoo`05001o
ogooOol0003eOol001]oo`03001oogoo059oo`8004ioo`03001oogoo01Uoo`05001oogooOol0003e
Ool001]oo`03001oogoo055oo`8004moo`03001oogoo01Uoo`05001oogooOol0003eOol001aoo`03
001oogoo051oo`03001oogoo04ioo`03001oogoo01Uoo`05001oogooOol0003eOol001aoo`03001o
ogoo051oo`03001oogoo04ioo`03001oogoo01Uoo`05001oogooOol0003eOol001eoo`03001oogoo
04ioo`03001oogoo04moo`03001oogoo01Uoo`05001oogooOol0003eOol001eoo`03001oogoo04io
o`03001oogoo04moo`03001oogoo01Uoo`05001oogooOol0003eOol001ioo`03001oogoo04]oo`80
059oo`03001oogoo01Uoo`05001oogooOol0003eOol001ioo`03001oogoo04]oo`03001oogoo055o
o`03001oogoo01Uoo`05001oogooOol0003eOol001moo`03001oogoo04Uoo`03001oogoo059oo`03
001oogoo01Uoo`05001oogooOol0003eOol001moo`03001oogoo04Uoo`03001oogoo059oo`03001o
ogoo01Uoo`05001oogooOol0003eOol0021oo`03001oogoo04Moo`03001oogoo05=oo`03001oogoo
01Uoo`05001oogooOol0003eOol0021oo`03001oogoo04Moo`03001oogoo05=oo`<001Uoo`05001o
ogooOol0003eOol0025oo`03001oogoo04Eoo`03001oogoo05Aoo`03001oogoo01Uoo`05001oogoo
Ool0003eOol0025oo`03001oogoo04Eoo`03001oogoo05Aoo`03001oogoo01Uoo`05001oogooOol0
003eOol0029oo`03001oogoo04=oo`03001oogoo05Eoo`03001oogoo01Uoo`05001oogooOol0003e
Ool0029oo`03001oogoo04=oo`03001oogoo05Eoo`03001oogoo01Uoo`05001oogooOol0003eOol0
029oo`03001oogoo049oo`03001oogoo05Ioo`03001oogoo01Uoo`05001oogooOol0003eOol002=o
o`03001oogoo045oo`03001oogoo05Ioo`03001oogoo01Uoo`05001oogooOol0003eOol002=oo`03
001oogoo041oo`03001oogoo05Moo`03001oogoo01Uoo`05001oogooOol0003eOol002=oo`03001o
ogoo041oo`03001oogoo05Moo`03001oogoo01Uoo`05001oogooOol0003eOol002Aoo`03001oogoo
03ioo`03001oogoo05Qoo`03001oogoo01Uoo`05001oogooOol0003eOol002Aoo`03001oogoo03io
o`03001oogoo05Qoo`03001oogoo01Uoo`05001oogooOol0003eOol002Aoo`03001oogoo03ioo`03
001oogoo05Qoo`03001oogoo01Uoo`05001oogooOol0003eOol002Aoo`03001oogoo03eoo`03001o
ogoo05Uoo`03001oogoo01Uoo`05001oogooOol0003eOol002Eoo`03001oogoo03aoo`03001oogoo
05Uoo`<001Uoo`05001oogooOol0003eOol002Eoo`03001oogoo03]oo`03001oogoo05Yoo`03001o
ogoo01Uoo`05001oogooOol0003eOol002Eoo`03001oogoo03]oo`03001oogoo05Yoo`03001oogoo
01Uoo`05001oogooOol0003eOol002Ioo`03001oogoo03Yoo`03001oogoo05Yoo`03001oogoo01Uo
o`05001oogooOol0003eOol002Ioo`03001oogoo03Uoo`03001oogoo05]oo`03001oogoo01Uoo`05
001oogooOol0003eOol002Ioo`03001oogoo03Uoo`03001oogoo05]oo`03001oogoo01Uoo`05001o
ogooOol0003eOol002Moo`03001oogoo03Qoo`03001oogoo05]oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol002Moo`03001oogoo03Moo`03001oogoo05aoo`03001oogoo01Uoo`05001oogooOol0
003eOol002Moo`03001oogoo03Moo`03001oogoo05aoo`03001oogoo01Uoo`05001oogooOol0003e
Ool002Qoo`03001oogoo03Eoo`03001oogoo05eoo`03001oogoo01Uoo`05001oogooOol0003eOol0
02Qoo`03001oogoo03Eoo`03001oogoo055oo`H000Ioo`03001oogoo01Uoo`05001oogooOol0003e
Ool002Qoo`03001oogoo03Eoo`03001oogoo055oo`03001oogoo00Uoo`03001oogoo01Uoo`05001o
ogooOol0003eOol002Qoo`03001oogoo03Aoo`03001oogoo05=oo`03001oogoo00Qoo`03001oogoo
01Uoo`05001oogooOol0003eOol002Uoo`03001oogoo03=oo`03001oogoo05Aoo`03001oogoo00Mo
o`03001oogoo01Uoo`05001oogooOol0003eOol002Uoo`03001oogoo03=oo`03001oogoo05Eoo`03
001oogoo00Ioo`@001Qoo`05001oogooOol0003eOol002Uoo`03001oogoo039oo`03001oogoo05Mo
o`03001oogoo00Eoo`03001oogoo01Uoo`05001oogooOol0003eOol002Yoo`03001oogoo035oo`03
001oogoo05Qoo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol002Yoo`03001o
ogoo035oo`03001oogoo05Qoo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol0
02Yoo`03001oogoo031oo`03001oogoo05Aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo
01Uoo`05001oogooOol0003eOol002]oo`03001oogoo02moo`03001oogoo05Eoo`@000Moo`03001o
ogoo01Uoo`05001oogooOol0003eOol002]oo`03001oogoo02ioo`03001oogoo065oo`03001oogoo
01Uoo`05001oogooOol0003eOol002]oo`03001oogoo02ioo`03001oogoo065oo`03001oogoo01Uo
o`05001oogooOol0003eOol002aoo`03001oogoo02eoo`03001oogoo065oo`03001oogoo01Uoo`05
001oogooOol0003eOol002aoo`03001oogoo02aoo`03001oogoo069oo`03001oogoo01Uoo`05001o
ogooOol0003eOol002aoo`03001oogoo02aoo`03001oogoo069oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol002eoo`03001oogoo02]oo`03001oogoo069oo`03001oogoo01Uoo`05001oogooOol0
003eOol002eoo`03001oogoo02Yoo`03001oogoo06=oo`03001oogoo01Uoo`05001oogooOol0003e
Ool002eoo`03001oogoo02Yoo`03001oogoo06=oo`<001Uoo`05001oogooOol0003eOol002ioo`03
001oogoo02Uoo`03001oogoo06=oo`03001oogoo01Uoo`05001oogooOol0003eOol002ioo`03001o
ogoo02Qoo`03001oogoo06Aoo`03001oogoo01Uoo`05001oogooOol0003eOol002ioo`03001oogoo
02Qoo`03001oogoo06Aoo`03001oogoo01Uoo`05001oogooOol0003eOol002ioo`03001oogoo02Qo
o`03001oogoo06Aoo`03001oogoo01Uoo`05001oogooOol0003eOol002moo`03001oogoo02Ioo`03
001oogoo06Eoo`03001oogoo01Uoo`05001oogooOol0003eOol002moo`03001oogoo02Ioo`03001o
ogoo06Eoo`03001oogoo01Uoo`05001oogooOol0003eOol002moo`03001oogoo02Ioo`03001oogoo
06Eoo`03001oogoo01Uoo`05001oogooOol0003eOol0031oo`03001oogoo02Aoo`03001oogoo06Io
o`03001oogoo01Uoo`05001oogooOol0003eOol0031oo`03001oogoo02Aoo`03001oogoo06Ioo`03
001oogoo01Uoo`05001oogooOol0003eOol0031oo`03001oogoo02Aoo`03001oogoo06Ioo`03001o
ogoo01Uoo`05001oogooOol0003eOol0035oo`03001oogoo02=oo`03001oogoo06Ioo`03001oogoo
01Uoo`05001oogooOol0003eOol0035oo`03001oogoo029oo`03001oogoo06Moo`03001oogoo01Uo
o`05001oogooOol0003eOol0035oo`03001oogoo029oo`03001oogoo06Moo`03001oogoo01Uoo`05
001oogooOol0003eOol0039oo`03001oogoo025oo`03001oogoo06Moo`<001Uoo`05001oogooOol0
003eOol0039oo`03001oogoo021oo`03001oogoo06Qoo`03001oogoo01Uoo`05001oogooOol0003e
Ool0039oo`03001oogoo021oo`03001oogoo06Qoo`03001oogoo01Uoo`05001oogooOol0003eOol0
03=oo`03001oogoo01moo`03001oogoo06Qoo`03001oogoo01Uoo`05001oogooOol0003eOol003=o
o`03001oogoo01ioo`03001oogoo06Uoo`03001oogoo01Uoo`05001oogooOol0003eOol003=oo`03
001oogoo01ioo`03001oogoo06Uoo`03001oogoo01Uoo`05001oogooOol0003eOol003Aoo`03001o
ogoo01eoo`03001oogoo06Uoo`03001oogoo01Uoo`05001oogooOol0003eOol003Aoo`03001oogoo
01aoo`03001oogoo06Yoo`03001oogoo01Uoo`05001oogooOol0003eOol003Aoo`03001oogoo01ao
o`03001oogoo06Yoo`03001oogoo01Uoo`05001oogooOol0003eOol003Eoo`03001oogoo01]oo`03
001oogoo06Yoo`03001oogoo01Uoo`05001oogooOol0003eOol003Eoo`03001oogoo01Yoo`03001o
ogoo06]oo`03001oogoo01Uoo`05001oogooOol0003eOol003Eoo`03001oogoo01Yoo`03001oogoo
06]oo`03001oogoo01Uoo`05001oogooOol0003eOol003Ioo`03001oogoo01Uoo`03001oogoo06]o
o`03001oogoo01Uoo`05001oogooOol0003eOol003Ioo`03001oogoo01Qoo`03001oogoo06aoo`<0
01Uoo`05001oogooOol0003eOol003Ioo`03001oogoo01Qoo`03001oogoo06aoo`03001oogoo01Uo
o`05001oogooOol0003eOol003Moo`03001oogoo01Ioo`03001oogoo06eoo`03001oogoo01Uoo`05
001oogooOol0003eOol003Moo`03001oogoo01Ioo`03001oogoo06eoo`03001oogoo01Uoo`05001o
ogooOol0003eOol003Qoo`03001oogoo01Eoo`03001oogoo06eoo`03001oogoo01Uoo`05001oogoo
Ool0003eOol003Qoo`03001oogoo01Aoo`03001oogoo06ioo`03001oogoo01Uoo`05001oogooOol0
003eOol003Uoo`03001oogoo01=oo`03001oogoo06ioo`03001oogoo01Uoo`05001oogooOol0003e
Ool003Uoo`03001oogoo019oo`03001oogoo06moo`03001oogoo01Uoo`05001oogooOol0003eOol0
03Yoo`03001oogoo015oo`03001oogoo06moo`03001oogoo01Uoo`05001oogooOol0003eOol003Yo
o`03001oogoo011oo`03001oogoo071oo`03001oogoo01Uoo`05001oogooOol0003eOol003]oo`03
001oogoo00moo`03001oogoo06Moo`<000Ioo`03001oogoo01Uoo`05001oogooOol0003eOol003]o
o`03001oogoo00ioo`03001oogoo06Uoo`03001oogoo00Eoo`03001oogoo01Uoo`05001oogooOol0
003eOol003]oo`03001oogoo00ioo`03001oogoo06Uoo`03001oogoo00Eoo`03001oogoo01Uoo`05
001oogooOol0003eOol003aoo`03001oogoo00aoo`8006Moo`H000Ioo`03001oogoo01Uoo`05001o
ogooOol0003eOol003aoo`03001oogoo00]oo`8006Qoo`05001oogooOol00007Ool4000HOol01@00
Oomoogoo0000mGoo000mOol00`00Oomoo`09Ool2001ZOol01000Oomoo`001goo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00?Goo0P002Woo00<007ooOol0JWoo00<007oo00001goo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00?goo00<007ooOol01Woo00<007ooOol0Jgoo00<007oo00001goo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00@7oo00<007ooOol017oo0P00KWoo0P001goo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00@Goo1`00L7oo00<007ooOol01Goo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00@Woo0P00O7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00`7oo0`006Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo0`006Goo
00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo0`00
6Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00]Goo10001goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo
00<007ooOol00Woo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<0
07ooOol00Woo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007oo
Ool00Woo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo0P000goo00<0
07ooOol017oo100067oo00D007ooOomoo`000?Eoo`00]7oo00<007oo00000P001goo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol02Goo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00]7oo00<007ooOol02Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]Goo00<007oo
Ool027oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]Woo0`001goo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo0`006Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo0`006Goo00D007ooOomo
o`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo0`006Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00]Goo10001goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol0
0Woo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol00Woo
00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol00Woo00<0
07ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol00Woo00<007oo
Ool017oo100067oo1@00mGoo002eOol40007Ool00`00Oomoo`3oOolDOol00;Aoo`03001oogoo009o
o`03001oogoo00Aoo`03001oogoo0?mooaAoo`00]7oo00<007ooOol00Woo00<007ooOol017oo00<0
07ooOol0ogoo57oo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`3oOolDOol00;Eo
o`@000Moo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolD
Ool00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolD
Ool00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool3003oOolDOol00<1o
o`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1o
o`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1o
o`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1o
o`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1o
o`03001oogoo0?mooaAoo`00`7oo0`00ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001o
ogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001o
ogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001o
ogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001o
ogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool3003oOolDOol00<1oo`03001oogoo0?mo
oaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mo
oaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mo
oaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00:aoo`D000Aoo`@000Mo
o`03001oogoo0?mooaAoo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo00<0
07ooOol0ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomo
o`3oOolDOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0?mo
oaAoo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo1000ogoo4goo002^Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`3oOolKOol00:ioo`03001oogoo00=oo`03001o
ogoo009oo`03001oogoo0?mooa]oo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0
ogoo6goo002/Ool30005Ool00`00Oomoo`02Ool00`00Oomoo`3oOolKOol00001\
\>"],
  ImageRangeCache->{{{0, 469}, {289.313, 0}} -> {-13.8869, -0.535215, 
  0.0720124, 0.03699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01129 m
.03259 .0149 L
.04184 .01962 L
.04242 .0205 L
.04305 .02137 L
.0436 .02201 L
.04419 .02253 L
.04451 .02275 L
.04487 .02292 L
.0452 .02303 L
.0455 .02309 L
.04608 .02312 L
.0464 .02311 L
.0467 .02309 L
.04727 .02309 L
.04781 .02316 L
.04839 .02342 L
.04872 .02366 L
.04902 .02394 L
.04956 .02463 L
.05015 .0256 L
.05122 .0278 L
.0615 .0436 L
.07081 .06288 L
.08064 .08941 L
.09836 .14846 L
.10822 .18211 L
.11722 .21 L
.12169 .2198 L
.12404 .22535 L
.12655 .23343 L
.1276 .23649 L
.12873 .23907 L
.12937 .24019 L
.12997 .24103 L
.13113 .24234 L
.13538 .24894 L
.13759 .2536 L
.13823 .25468 L
.13883 .25553 L
.13938 .25616 L
.13995 .25668 L
.14046 .25702 L
.14102 .25731 L
.142 .25767 L
.14313 .25804 L
.14421 .25852 L
.14481 .25888 L
.14547 .25933 L
.14662 .26025 L
Mistroke
.14787 .26125 L
.14856 .26173 L
.14889 .26193 L
.1492 .26209 L
.14981 .26233 L
.15013 .26241 L
.15047 .26246 L
.15102 .26245 L
.15162 .26233 L
.15219 .26212 L
.15279 .26179 L
.15387 .26099 L
.15863 .25796 L
.15925 .25781 L
.15993 .25763 L
.16023 .25754 L
.16056 .25741 L
.16114 .2571 L
.16174 .25664 L
.16241 .25594 L
.16313 .25492 L
.1638 .25374 L
.16616 .24867 L
.16868 .2444 L
.17088 .24226 L
.17198 .24091 L
.17261 .23986 L
.1732 .23864 L
.17569 .23133 L
.17687 .22753 L
.17799 .2244 L
.1793 .22162 L
.18049 .21972 L
.18179 .21767 L
.18318 .21469 L
.18429 .21138 L
.18552 .2069 L
.18768 .19869 L
.19021 .19174 L
.19259 .18673 L
.19477 .18021 L
.19717 .17087 L
.20199 .15608 L
.21063 .12823 L
.22954 .07869 L
.24775 .04362 L
.25769 .02984 L
.25828 .02978 L
.25883 .02971 L
.25914 .02964 L
Mistroke
.25947 .02955 L
.26005 .02928 L
.26061 .0289 L
.2612 .02833 L
.26226 .02693 L
.26456 .02301 L
.26578 .02117 L
.26647 .02039 L
.26679 .02009 L
.2671 .01986 L
.26768 .01951 L
.26799 .01938 L
.26832 .01927 L
.26867 .01918 L
.269 .01911 L
.26962 .01901 L
.27017 .0189 L
.27075 .01876 L
.27106 .01866 L
.2714 .01852 L
.27199 .01822 L
.27256 .01784 L
.27309 .01742 L
.27428 .01625 L
.27642 .0137 L
.27739 .01258 L
.27843 .01157 L
.27902 .0111 L
.27956 .01077 L
.28011 .01053 L
.28062 .01037 L
.28115 .01027 L
.28172 .01021 L
.2822 .0102 L
.28274 .01019 L
.28331 .01017 L
.28392 .01011 L
.2845 .00999 L
.28503 .00982 L
.2897 .00566 L
.29035 .00497 L
.29069 .00465 L
.29104 .00435 L
.29136 .00415 L
.2917 .00398 L
.29231 .00386 L
.2929 .00395 L
.29323 .00407 L
.29353 .00421 L
.29467 .00487 L
Mistroke
.29573 .00547 L
.29627 .0057 L
.29687 .00589 L
.29718 .00595 L
.29751 .00599 L
.29811 .006 L
.29871 .00591 L
.29926 .00574 L
.29981 .0055 L
.30032 .0052 L
.30148 .0043 L
.30258 .00324 L
.30307 .00277 L
.3036 .00231 L
.30414 .00201 L
.30472 .00203 L
.30502 .00218 L
.30534 .00244 L
.30593 .00305 L
.30706 .00441 L
.30813 .00559 L
.30863 .00604 L
.30916 .00643 L
.30974 .00672 L
.31028 .00687 L
.31076 .00689 L
.31121 .00682 L
.3117 .00663 L
.31224 .00631 L
.31458 .00395 L
.31515 .0034 L
.31576 .00305 L
.31611 .00302 L
.31642 .00311 L
.31674 .0033 L
.31704 .00356 L
.31814 .00479 L
.31875 .00549 L
.31932 .00609 L
.31985 .00655 L
.32044 .00693 L
.32096 .00714 L
.32145 .00723 L
.322 .0072 L
.3225 .00705 L
.32307 .00675 L
.32361 .00636 L
.32485 .00519 L
.32539 .00463 L
.32599 .00406 L
Mistroke
.32657 .00363 L
.32711 .00342 L
.32768 .00342 L
.32829 .00366 L
.32862 .00385 L
.32897 .0041 L
.3296 .00459 L
.33021 .00504 L
.33079 .0054 L
.33129 .00565 L
.33182 .00585 L
.33241 .00596 L
.33296 .00597 L
.3335 .00589 L
.33408 .00571 L
.33469 .00544 L
.33526 .00511 L
.33631 .0044 L
.33742 .00359 L
.33836 .003 L
.3389 .00275 L
.3394 .00262 L
.33999 .00258 L
.34054 .00266 L
.34084 .00274 L
.34117 .00285 L
.34176 .0031 L
.343 .00365 L
.34368 .00393 L
.34432 .00413 L
.34487 .00427 L
.34546 .00436 L
.34578 .00438 L
.34612 .00438 L
.34673 .00434 L
.34728 .00424 L
.34779 .00409 L
.34836 .00388 L
.34896 .00359 L
.35008 .0029 L
.3513 .002 L
.35185 .0016 L
.35244 .00127 L
.35295 .00117 L
.3535 .00134 L
.35404 .0017 L
.35453 .00212 L
.35564 .00313 L
.35667 .00399 L
.35764 .00464 L
Mistroke
.3582 .00491 L
.3588 .00509 L
.35936 .00516 L
.35986 .00513 L
.36041 .005 L
.36102 .00473 L
.36132 .00454 L
.36165 .0043 L
.36223 .0038 L
.36338 .00257 L
.36394 .00193 L
.36447 .00145 L
.36494 .00132 L
.36544 .0016 L
.36594 .00217 L
.3665 .00291 L
.36767 .00447 L
.36831 .00519 L
.3689 .00574 L
.36924 .006 L
.36955 .00618 L
.36989 .00634 L
.37025 .00645 L
.37056 .00649 L
.37089 .00648 L
.37149 .00632 L
.37205 .00601 L
.37237 .00577 L
.37267 .0055 L
.37393 .00403 L
.37501 .00257 L
.37562 .00196 L
.37617 .00186 L
.37647 .00203 L
.37679 .00235 L
.37738 .0031 L
.3785 .00465 L
.37914 .00541 L
.37949 .00577 L
.37982 .00605 L
.3804 .00643 L
.3807 .00657 L
.38103 .00666 L
.38163 .00669 L
.38196 .00662 L
.38227 .00652 L
.38284 .0062 L
.38344 .00571 L
.38449 .00456 L
.38564 .0031 L
Mistroke
.38622 .00246 L
.38676 .00208 L
.38726 .00205 L
.38779 .00236 L
.38837 .00292 L
.38899 .00359 L
.39011 .00466 L
.39065 .00506 L
.39124 .00538 L
.39179 .00555 L
.3923 .00561 L
.39276 .00558 L
.39327 .00545 L
.3938 .00523 L
.39429 .00494 L
.39663 .00297 L
.39727 .0024 L
.39762 .00213 L
.39794 .00192 L
.39852 .00169 L
.39883 .00167 L
.39916 .00172 L
.39972 .00194 L
.40034 .0023 L
.40157 .00304 L
.40213 .00333 L
.40272 .00359 L
.40328 .00377 L
.40378 .00389 L
.40432 .00396 L
.40489 .00397 L
.40538 .00394 L
.40592 .00385 L
.40649 .00369 L
.40711 .00347 L
.40823 .00292 L
.41027 .00154 L
.41086 .0011 L
.41141 .00072 L
.4119 .00052 L
.41244 .00066 L
.41274 .00085 L
.41306 .0011 L
.41372 .00163 L
.41489 .00258 L
.41608 .00341 L
.4166 .00371 L
.41716 .00397 L
.4175 .0041 L
.41782 .0042 L
Mistroke
.41813 .00427 L
.41845 .00432 L
.41879 .00434 L
.4191 .00433 L
.41945 .00428 L
.41983 .00419 L
.42013 .00409 L
.42046 .00395 L
.42112 .00356 L
.42174 .00309 L
.42231 .00255 L
.4229 .00192 L
.42354 .00116 L
.42414 .0004 L
.42469 .00044 L
.42519 .00111 L
.42574 .00188 L
.42685 .00335 L
.42805 .00467 L
.4284 .00497 L
.42873 .00522 L
.42903 .0054 L
.42935 .00556 L
.42993 .00574 L
.43047 .00576 L
.4308 .00571 L
.43111 .00562 L
.43169 .00532 L
.43224 .0049 L
.43282 .00431 L
.43387 .00294 L
.43452 .00195 L
.43513 .00099 L
.43567 .00048 L
.43627 .00123 L
.43747 .00319 L
.43861 .00476 L
.43918 .00537 L
.43979 .00587 L
.44014 .00607 L
.44047 .00621 L
.44076 .00628 L
.44109 .00631 L
.44168 .00622 L
.44221 .00598 L
.44251 .00579 L
.44283 .00553 L
.44342 .00495 L
.44454 .00349 L
.44558 .00189 L
Mistroke
.44604 .0012 L
.44654 .00075 L
.44708 .00112 L
.44759 .00184 L
.4486 .00328 L
.44972 .00456 L
.45031 .00505 L
.45087 .00537 L
.45145 .00557 L
.45178 .00561 L
.45209 .0056 L
.4526 .0055 L
.45315 .00527 L
.45373 .00491 L
.45428 .00446 L
.45551 .00318 L
.45667 .00179 L
.45699 .00143 L
.45732 .00109 L
.45768 .00083 L
.45802 .00079 L
.4586 .00115 L
.45893 .00146 L
.45924 .00176 L
.4604 .00281 L
.46098 .00323 L
.46151 .00355 L
.46199 .00378 L
.4625 .00395 L
.46307 .00406 L
.46358 .00409 L
.46419 .00404 L
.46474 .00393 L
.46535 .00372 L
.46599 .00344 L
.46707 .00281 L
.46825 .00197 L
Mfstroke
.46825 .00197 m
.46864 .00169 L
.46906 .00143 L
.46946 .00122 L
.46984 .00105 L
.47024 .00089 L
.47063 .00076 L
.47105 .00064 L
.47145 .00054 L
.47183 .00046 L
.47224 .00039 L
.47263 .00032 L
.47301 .00027 L
.47341 .00023 L
.4738 .00019 L
.47421 .00016 L
.47461 .00013 L
.47499 .00011 L
.4754 9e-005 L
.47579 8e-005 L
.47621 6e-005 L
.47661 6e-005 L
.47699 5e-005 L
.47719 5e-005 L
.4774 4e-005 L
.4775 4e-005 L
.4776 4e-005 L
.47778 4e-005 L
s
.47778 4e-005 m
.48762 .00017 L
.49263 .00024 L
.498 .00029 L
.50085 .00032 L
.50345 .00033 L
.5047 .00034 L
.50536 .00034 L
.50605 .00034 L
.50666 .00034 L
.50734 .00034 L
.50795 .00034 L
.50852 .00034 L
.50889 .00034 L
.50923 .00034 L
.50961 .00034 L
.51001 .00034 L
.51039 .00034 L
.51075 .00034 L
.51142 .00034 L
.5127 .00034 L
.51407 .00033 L
.51559 .00032 L
.51719 .00031 L
.52005 .00029 L
.52501 .00024 L
.53032 .00017 L
.53531 .0001 L
.5375 7e-005 L
.53866 5e-005 L
.53992 4e-005 L
.54026 3e-005 L
.54061 3e-005 L
.54125 3e-005 L
.54185 3e-005 L
.5425 3e-005 L
.54319 4e-005 L
.54392 5e-005 L
.54524 7e-005 L
.55104 .00015 L
.55651 .00021 L
.56157 .00026 L
.56417 .00027 L
.5655 .00028 L
.56693 .00029 L
.56835 .00029 L
.56899 .00029 L
.56969 .0003 L
.57012 .0003 L
.57051 .0003 L
Mistroke
.57091 .0003 L
.57128 .0003 L
.57165 .0003 L
.57199 .0003 L
.57235 .0003 L
.57274 .0003 L
.5734 .0003 L
.57401 .0003 L
.57469 .0003 L
.57541 .00029 L
.57689 .00029 L
.57823 .00029 L
.58083 .00027 L
.58328 .00026 L
.58835 .00021 L
.59372 .00015 L
.59876 9e-005 L
.60096 6e-005 L
.60221 4e-005 L
.60337 3e-005 L
.60398 2e-005 L
.60453 2e-005 L
.60517 2e-005 L
.60577 2e-005 L
.6064 3e-005 L
.60698 3e-005 L
.60829 5e-005 L
.61358 .00012 L
.6182 .00017 L
.62315 .00021 L
.62581 .00023 L
.62824 .00025 L
.62941 .00025 L
.63068 .00026 L
.63187 .00026 L
.63299 .00026 L
.63361 .00026 L
.63428 .00027 L
.63465 .00027 L
.63503 .00027 L
.63571 .00027 L
.63606 .00027 L
.63643 .00027 L
.63709 .00027 L
.6375 .00027 L
.63788 .00027 L
.6386 .00026 L
.63923 .00026 L
.6399 .00026 L
.6411 .00026 L
Mistroke
.6438 .00025 L
.64638 .00023 L
.64873 .00022 L
.65403 .00017 L
.66361 6e-005 L
.66611 3e-005 L
.66683 3e-005 L
.6675 2e-005 L
.66811 2e-005 L
.66877 1e-005 L
.66935 2e-005 L
.66998 2e-005 L
.67126 4e-005 L
.67355 6e-005 L
.67923 .00013 L
.6844 .00017 L
.68692 .00019 L
.68965 .00021 L
.69223 .00023 L
.69462 .00023 L
.69592 .00024 L
.69714 .00024 L
.69784 .00024 L
.69849 .00024 L
.69882 .00024 L
.69919 .00024 L
.69957 .00024 L
.69993 .00024 L
.70028 .00024 L
.70067 .00024 L
.70103 .00024 L
.70136 .00024 L
.70199 .00024 L
.70266 .00024 L
.70404 .00024 L
.70557 .00023 L
.7083 .00022 L
.71089 .00021 L
.71575 .00017 L
.72105 .00012 L
.72669 7e-005 L
.7295 3e-005 L
.73017 3e-005 L
.73088 2e-005 L
.73148 1e-005 L
.73215 1e-005 L
.73274 1e-005 L
.73337 2e-005 L
.73397 2e-005 L
.73452 3e-005 L
Mistroke
.73708 5e-005 L
.74672 .00015 L
.74924 .00017 L
.75192 .00019 L
.75424 .0002 L
.75673 .00021 L
.75813 .00022 L
.7594 .00022 L
.76001 .00022 L
.76068 .00022 L
.76131 .00022 L
.7619 .00022 L
.76226 .00022 L
.76265 .00022 L
.76334 .00022 L
.76372 .00022 L
.76413 .00022 L
.76448 .00022 L
.76486 .00022 L
.76555 .00022 L
.76593 .00022 L
.76628 .00022 L
.76761 .00022 L
.7688 .00022 L
.77012 .00021 L
.77279 .0002 L
.77526 .00019 L
.77759 .00018 L
.78288 .00013 L
.78845 8e-005 L
.79349 3e-005 L
.79487 2e-005 L
.79527 1e-005 L
.79565 1e-005 L
.79598 1e-005 L
.79635 1e-005 L
.79702 1e-005 L
.79736 1e-005 L
.79773 2e-005 L
.79901 3e-005 L
.80869 .00012 L
.81401 .00016 L
.81653 .00018 L
.81886 .00019 L
.82155 .0002 L
.82296 .00021 L
.82369 .00021 L
.82447 .00021 L
.82522 .00021 L
.82591 .00021 L
Mistroke
.82657 .00021 L
.8269 .00021 L
.82727 .00021 L
.8279 .00021 L
.82857 .00021 L
.82921 .00021 L
.8298 .00021 L
.83041 .00021 L
.831 .00021 L
.83232 .00021 L
.83361 .0002 L
.83499 .0002 L
.8375 .00019 L
.8398 .00018 L
.8451 .00014 L
.85067 9e-005 L
.85567 5e-005 L
.85712 3e-005 L
.85847 2e-005 L
.85907 1e-005 L
.85969 1e-005 L
.86038 1e-005 L
.86102 1e-005 L
.87063 .0001 L
.87558 .00014 L
.87831 .00016 L
.88089 .00017 L
.88329 .00018 L
.88456 .00019 L
.88591 .00019 L
.88703 .0002 L
.88828 .0002 L
.88883 .0002 L
.88942 .0002 L
.88997 .0002 L
.89048 .0002 L
.89115 .0002 L
.89178 .0002 L
.89234 .0002 L
.89296 .0002 L
.89362 .0002 L
.89396 .0002 L
.89433 .0002 L
.8956 .0002 L
.89679 .0002 L
.89806 .00019 L
.90037 .00018 L
.90327 .00017 L
.90602 .00015 L
.9112 .00012 L
Mistroke
.91621 7e-005 L
.91897 5e-005 L
.92156 2e-005 L
.92274 1e-005 L
.92339 1e-005 L
.92399 0 L
.92464 1e-005 L
.92498 1e-005 L
.92535 1e-005 L
.92661 2e-005 L
.93119 7e-005 L
.93651 .00011 L
.93932 .00013 L
.94231 .00015 L
.94491 .00017 L
.94778 .00018 L
.94903 .00018 L
.95039 .00019 L
.95166 .00019 L
.95284 .00019 L
.95351 .00019 L
.95414 .00019 L
.9547 .00019 L
.95532 .00019 L
.95599 .00019 L
.95633 .00019 L
.9567 .00019 L
.95735 .00019 L
.95797 .00019 L
.95859 .00019 L
.95917 .00019 L
.96027 .00019 L
.96145 .00019 L
.96274 .00018 L
.96547 .00017 L
.96837 .00016 L
.97358 .00013 L
.97619 .00011 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0?moomMoo`003gooo`00^00047oo000JOol00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`0;
Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;
Ool00`00Oomoo`03Ool20003Ool200000goo001oo`020003Ool20003Ool90002Ool3000017oo0000
00000goo0P000goo1P000Woo100000Aoo`00Oomoo`<0009oo`03001oo`00009oo`03001oo`0000<0
00=oo`03001oogoo00Moo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo
00]oo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo
00]oo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo
00Yoo`03001oogoo00]oo`03001oogoo01Uoo`00=Goo00<007ooOol0@goo00<007ooOol047oo1P00
0Woo0`0000Aoo`00001oo`H000=oo`8000Aoo`80009oo`<0009oo`<0009oo`<000=oo`03001oogoo
00=oo`8000=oo`<00004Ool000000002Ool30005Ool01@00Oomoogoo00009Goo00<007ooOol0@Woo
00<007ooOol0@goo00<007ooOol0@Woo002=Ool00`00Oomoo`07Ool20002Ool3000HOol20008Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo002:Ool3000cOol00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo000JOol2001]Ool00`00Oomoo`0dOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000L
Ool3001YOol00`00Oomoo`0eOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000OOol2001VOol0
0`00Oomoo`0fOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000QOol2001QOol3000iOol00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo000ROol00`00Oomoo`1OOol00`00Oomoo`0iOol00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo000SOol3001MOol00`00Oomoo`0jOol00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo000UOol00`00Oomoo`1JOol00`00Oomoo`0kOol00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo000VOol00`00Oomoo`1HOol2000mOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
000WOol00`00Oomoo`1FOol2000nOol3000IOol01@00Oomoogoo0000mGoo000WOol00`00Oomoo`1E
Ool00`00Oomoo`0nOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000XOol00`00Oomoo`1DOol0
0`00Oomoo`0nOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000XOol00`00Oomoo`1COol00`00
Oomoo`0oOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000YOol00`00Oomoo`1AOol00`00Oomo
o`10Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000YOol00`00Oomoo`1AOol00`00Oomoo`10
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000ZOol00`00Oomoo`1?Ool00`00Oomoo`11Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo000[Ool00`00Oomoo`1=Ool00`00Oomoo`12Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo000[Ool00`00Oomoo`1=Ool00`00Oomoo`12Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo000/Ool00`00Oomoo`1;Ool00`00Oomoo`13Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo000/Ool00`00Oomoo`1;Ool00`00Oomoo`13Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo000]Ool00`00Oomoo`19Ool00`00Oomoo`14Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo000]Ool00`00Oomoo`19Ool00`00Oomoo`14Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo000^Ool00`00Oomoo`17Ool00`00Oomoo`15Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo000^Ool00`00Oomoo`17Ool00`00Oomoo`15Ool3000IOol01@00Oomoogoo0000mGoo000^
Ool00`00Oomoo`16Ool00`00Oomoo`16Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000_Ool0
0`00Oomoo`15Ool00`00Oomoo`16Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000_Ool00`00
Oomoo`14Ool00`00Oomoo`17Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000`Ool00`00Oomo
o`13Ool00`00Oomoo`17Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000`Ool00`00Oomoo`12
Ool00`00Oomoo`18Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000aOol00`00Oomoo`11Ool0
0`00Oomoo`18Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000aOol00`00Oomoo`10Ool00`00
Oomoo`19Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000aOol00`00Oomoo`10Ool00`00Oomo
o`19Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000bOol00`00Oomoo`0nOol00`00Oomoo`1:
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000bOol00`00Oomoo`0nOol00`00Oomoo`1:Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo000cOol00`00Oomoo`0lOol00`00Oomoo`1;Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo000cOol00`00Oomoo`0lOol00`00Oomoo`1;Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo000cOol00`00Oomoo`0lOol00`00Oomoo`1;Ool3000IOol01@00
Oomoogoo0000mGoo000dOol00`00Oomoo`0jOol00`00Oomoo`1<Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo000dOol00`00Oomoo`0jOol00`00Oomoo`1<Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo000dOol00`00Oomoo`0iOol00`00Oomoo`1=Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo000dOol00`00Oomoo`0iOol00`00Oomoo`1=Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
000eOol00`00Oomoo`0gOol00`00Oomoo`1>Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000e
Ool00`00Oomoo`0gOol00`00Oomoo`1>Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000eOol0
0`00Oomoo`0gOol00`00Oomoo`1>Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000eOol00`00
Oomoo`0fOol00`00Oomoo`1?Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000fOol00`00Oomo
o`0eOol00`00Oomoo`1?Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000fOol00`00Oomoo`0d
Ool00`00Oomoo`14Ool60006Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000fOol00`00Oomo
o`0dOol00`00Oomoo`14Ool00`00Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000g
Ool00`00Oomoo`0cOol00`00Oomoo`15Ool00`00Oomoo`08Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo000gOol00`00Oomoo`0bOol00`00Oomoo`17Ool00`00Oomoo`07Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo000gOol00`00Oomoo`0bOol00`00Oomoo`18Ool00`00Oomoo`06Ool4000H
Ool01@00Oomoogoo0000mGoo000gOol00`00Oomoo`0aOol00`00Oomoo`1:Ool00`00Oomoo`05Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo000hOol00`00Oomoo`0`Ool00`00Oomoo`1;Ool00`00
Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000hOol00`00Oomoo`0`Ool00`00Oomo
o`1;Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000hOol00`00Oomoo`0_
Ool00`00Oomoo`17Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo000hOol00`00Oomoo`0_Ool00`00Oomoo`18Ool40007Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo000iOol00`00Oomoo`0^Ool00`00Oomoo`1COol00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo000iOol00`00Oomoo`0^Ool00`00Oomoo`1COol00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo000iOol00`00Oomoo`0]Ool00`00Oomoo`1DOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
000iOol00`00Oomoo`0]Ool00`00Oomoo`1DOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000j
Ool00`00Oomoo`0/Ool00`00Oomoo`1DOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000jOol0
0`00Oomoo`0/Ool00`00Oomoo`1DOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000jOol00`00
Oomoo`0[Ool00`00Oomoo`1EOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000kOol00`00Oomo
o`0ZOol00`00Oomoo`1EOol3000IOol01@00Oomoogoo0000mGoo000kOol00`00Oomoo`0ZOol00`00
Oomoo`1EOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000kOol00`00Oomoo`0ZOol00`00Oomo
o`1EOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000lOol00`00Oomoo`0XOol00`00Oomoo`1F
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo000lOol00`00Oomoo`0XOol00`00Oomoo`1FOol0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo000mOol00`00Oomoo`0WOol00`00Oomoo`1FOol00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo000mOol00`00Oomoo`0VOol00`00Oomoo`1GOol00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo000mOol00`00Oomoo`0VOol00`00Oomoo`1GOol00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo000nOol00`00Oomoo`0TOol00`00Oomoo`1HOol00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo000nOol00`00Oomoo`0TOol00`00Oomoo`1HOol00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo000nOol00`00Oomoo`0SOol00`00Oomoo`1IOol00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo000oOol00`00Oomoo`0ROol00`00Oomoo`1IOol00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo000oOol00`00Oomoo`0ROol00`00Oomoo`1IOol00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo000oOol00`00Oomoo`0ROol00`00Oomoo`1IOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0010Ool00`00Oomoo`0QOol00`00Oomoo`1IOol3000IOol01@00Oomoogoo0000mGoo0010Ool00`00
Oomoo`0POol00`00Oomoo`1JOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0010Ool00`00Oomo
o`0POol00`00Oomoo`1JOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0011Ool00`00Oomoo`0N
Ool00`00Oomoo`1KOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0011Ool00`00Oomoo`0NOol0
0`00Oomoo`1KOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0011Ool00`00Oomoo`0MOol00`00
Oomoo`1LOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0011Ool00`00Oomoo`0MOol00`00Oomo
o`1LOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0012Ool00`00Oomoo`0LOol00`00Oomoo`1L
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0012Ool00`00Oomoo`0KOol00`00Oomoo`1MOol0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0012Ool00`00Oomoo`0KOol00`00Oomoo`1MOol00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0013Ool00`00Oomoo`0JOol00`00Oomoo`1MOol00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0013Ool00`00Oomoo`0JOol00`00Oomoo`1MOol00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0014Ool00`00Oomoo`0HOol00`00Oomoo`1NOol00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0014Ool00`00Oomoo`0HOol00`00Oomoo`1NOol3000IOol01@00Oomoogoo
0000mGoo0015Ool00`00Oomoo`0GOol00`00Oomoo`1NOol00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0015Ool00`00Oomoo`0FOol00`00Oomoo`1OOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0016Ool00`00Oomoo`0EOol00`00Oomoo`1OOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0016
Ool00`00Oomoo`0DOol00`00Oomoo`1POol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0016Ool0
0`00Oomoo`0DOol00`00Oomoo`1POol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0017Ool00`00
Oomoo`0BOol00`00Oomoo`1QOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0017Ool00`00Oomo
o`0BOol00`00Oomoo`1QOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0017Ool00`00Oomoo`0B
Ool00`00Oomoo`1QOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0017Ool00`00Oomoo`0AOol0
0`00Oomoo`1ROol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0018Ool00`00Oomoo`0@Ool00`00
Oomoo`1IOol30006Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0018Ool00`00Oomoo`0@Ool0
0`00Oomoo`1JOol00`00Oomoo`05Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0019Ool00`00
Oomoo`0>Ool00`00Oomoo`1KOol00`00Oomoo`05Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
001:Ool00`00Oomoo`0<Ool00`00Oomoo`1HOol60006Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo001:Ool00`00Oomoo`0;Ool00`00Oomoo`1IOol01@00Oomoogoo00001goo100067oo00D007oo
Oomoo`000?Eoo`00Bgoo00<007ooOol02Woo00<007ooOol0FWoo00@007ooOol000Moo`03001oogoo
01Uoo`05001oogooOol0003eOol004]oo`03001oogoo00Uoo`03001oogoo05aoo`03001oo`0000Mo
o`03001oogoo01Uoo`05001oogooOol0003eOol004]oo`8000Yoo`03001oogoo05aoo`03001oo`00
00Moo`03001oogoo01Uoo`05001oogooOol0003eOol004aoo`8000Moo`80061oo`8000Moo`03001o
ogoo01Uoo`05001oogooOol0003eOol004ioo`8000Aoo`03001oogoo065oo`03001oogoo00Eoo`03
001oogoo01Uoo`05001oogooOol0003eOol0051oo`@006aoo`03001oogoo01Uoo`05001oogooOol0
003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uo
o`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001o
ogoo01Uoo`05001oogooOol0003eOol00<1oo`<001Uoo`05001oogooOol0003eOol00<1oo`03001o
ogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1o
o`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03
001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol0
0<1oo`<001Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol0
0<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0
003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uo
o`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001o
ogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1o
o`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`<001Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03
001oogoo01Uoo`05001oogooOol0003eOol00;Eoo`@000Moo`03001oogoo01Uoo`05001oogooOol0
003eOol00;Aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003e
Ool00;Aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol0
0;Aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Ao
o`8000=oo`03001oogoo00Aoo`@001Qoo`05001oogooOol0003eOol00;Aoo`03001oo`00008000Mo
o`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001oogoo00Uoo`03001oogoo01Uoo`05
001oogooOol0003eOol00;Aoo`03001oogoo00Uoo`03001oogoo01Uoo`05001oogooOol0003eOol0
0;Eoo`03001oogoo00Qoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Ioo`<000Moo`03001o
ogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1o
o`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`<001Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03
001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol0
0<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0
003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uo
o`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`<001Uo
o`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001o
ogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1o
o`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`<0
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03
001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol0
0<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0
003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uo
o`05001oogooOol0003eOol00;Eoo`@000Moo`03001oogoo01Uoo`05001oogooOol0003eOol00;Ao
o`03001oogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03
001oogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001o
ogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001oogoo
009oo`03001oogoo00Aoo`@001Qoo`D00?Eoo`00]Goo10001goo00<007ooOol0ogoo57oo002dOol0
0`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`3oOolDOol00;Aoo`03001oogoo009oo`03001o
ogoo00Aoo`03001oogoo0?mooaAoo`00]7oo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0
ogoo57oo002eOol40007Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo0`00
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00`7oo00<007ooOol0ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo0`00ogoo57oo0030Ool0
0`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool0
0`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool0
0`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo002/Ool5
0004Ool40007Ool00`00Oomoo`3oOolDOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo00Aoo`03001oogoo0?mooaAoo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0
17oo00<007ooOol0ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool0
0`00Oomoo`3oOolDOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`@00?mo
oa=oo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0ogoo6goo002^Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool00`00Oomoo`3oOolKOol00:ioo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo0?mooa]oo`00[7oo0`001Goo00<007ooOol00Woo00<007ooOol0ogoo6goo0000\
\>"],
  ImageRangeCache->{{{0, 469}, {289.313, 0}} -> {-13.8869, -0.535215, 
  0.0720124, 0.03699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .00518 m
.02598 .00375 L
.02702 .00284 L
.02753 .00242 L
.028 .00212 L
.02855 .00193 L
.02916 .00199 L
.02967 .00224 L
.03022 .00263 L
.03136 .00357 L
.03199 .00406 L
.03259 .00447 L
.03315 .00479 L
.03345 .00493 L
.03377 .00506 L
.03434 .00521 L
.03486 .00528 L
.03543 .00528 L
.03598 .00519 L
.03646 .00506 L
.03699 .00486 L
.03822 .00427 L
.03854 .00411 L
.03889 .00396 L
.03921 .00384 L
.03952 .00376 L
.04009 .00371 L
.04062 .0038 L
.04121 .00405 L
.04153 .00425 L
.04184 .00447 L
.04402 .00626 L
.04462 .00668 L
.04525 .00705 L
.04578 .00729 L
.04637 .00746 L
.04671 .00753 L
.04702 .00757 L
.04737 .00758 L
.04771 .00758 L
.0483 .00752 L
.04864 .00748 L
.04895 .00742 L
.04956 .00732 L
.05013 .00724 L
.05072 .00719 L
.05104 .00719 L
.05137 .00722 L
.0517 .00727 L
.05205 .00736 L
Mistroke
.05238 .00746 L
.05267 .00758 L
.0534 .00796 L
.05409 .00839 L
.05543 .00936 L
.05667 .01019 L
.05725 .01051 L
.0578 .01075 L
.05837 .01093 L
.05867 .011 L
.05899 .01104 L
.05931 .01107 L
.05967 .01106 L
.06 .01104 L
.06031 .011 L
.06089 .0109 L
.0615 .01078 L
.06204 .0107 L
.06262 .01067 L
.06323 .01075 L
.06379 .01095 L
.06432 .01127 L
.06481 .01165 L
.06589 .01275 L
.06705 .01405 L
.06767 .01465 L
.068 .01493 L
.06832 .01515 L
.06888 .01546 L
.06919 .01557 L
.06951 .01565 L
.07008 .01568 L
.07061 .01562 L
.07114 .0155 L
.0717 .01535 L
.07218 .01526 L
.07271 .01525 L
.07327 .01539 L
.07388 .01578 L
.07446 .01638 L
.07499 .0171 L
.07914 .02321 L
.08871 .03578 L
.09762 .05235 L
.11539 .09853 L
.13359 .1612 L
.14288 .19295 L
.15295 .22283 L
.15538 .22741 L
.15657 .22915 L
Mistroke
.15765 .23112 L
.1588 .23387 L
.16003 .23747 L
.16138 .24161 L
.16264 .24491 L
.1637 .24696 L
.1643 .24781 L
.16484 .24842 L
.16599 .24941 L
.16723 .25041 L
.1684 .2517 L
.16947 .25331 L
.17159 .25713 L
.17272 .25895 L
.17327 .25968 L
.17378 .26023 L
.17437 .26073 L
.17468 .26093 L
.17501 .2611 L
.17555 .26129 L
.17614 .2614 L
.17669 .26143 L
.17719 .26143 L
.17774 .26141 L
.17833 .26141 L
.17883 .26142 L
.17931 .26147 L
.17983 .26156 L
.18038 .26169 L
.18163 .26215 L
.18298 .26273 L
.1836 .26296 L
.18391 .26305 L
.18426 .26313 L
.18487 .26319 L
.18543 .26315 L
.18603 .26298 L
.18659 .26269 L
.1871 .26233 L
.18765 .26183 L
.19003 .25886 L
.19123 .25735 L
.1925 .25614 L
.19316 .25569 L
.19389 .25531 L
.19456 .255 L
.19517 .2547 L
.19579 .25429 L
.19637 .25377 L
.19699 .25303 L
Mistroke
.19767 .25197 L
.19888 .24941 L
.2 .24652 L
.20903 .22911 L
.21791 .20579 L
.22732 .17603 L
.24497 .11797 L
.26377 .07028 L
.27241 .05234 L
.28185 .03596 L
.28247 .0359 L
.28281 .03586 L
.28313 .0358 L
.28371 .0356 L
.28433 .03521 L
.28467 .0349 L
.28499 .03455 L
.28571 .03353 L
.28697 .03111 L
.28824 .02826 L
.28887 .02693 L
.28945 .02584 L
.28996 .02503 L
.29053 .02434 L
.2911 .02387 L
.29171 .02359 L
.2923 .02349 L
.29284 .02349 L
.29342 .02352 L
.29372 .02352 L
.29405 .02351 L
.29459 .02344 L
.29518 .02323 L
.29573 .02291 L
.29624 .0225 L
.29686 .02184 L
.29743 .0211 L
.29873 .01912 L
.29996 .01719 L
.3005 .01643 L
.30109 .01571 L
.30167 .01513 L
.3022 .01472 L
.30272 .01444 L
.30327 .01424 L
.30357 .01417 L
.3039 .01412 L
.30449 .01406 L
.30503 .01402 L
.30561 .01397 L
Mistroke
.30616 .01389 L
.30668 .01377 L
.30723 .01358 L
.30781 .01331 L
.30887 .01261 L
.30984 .01175 L
.31221 .00911 L
.31346 .00776 L
.31414 .00716 L
.31448 .00693 L
.31479 .00675 L
.31534 .00652 L
.31594 .00641 L
.31624 .0064 L
.31657 .00643 L
.31691 .00648 L
.31722 .00654 L
.31831 .00681 L
.31886 .00693 L
.31947 .00699 L
.31978 .00699 L
.3201 .00697 L
.3207 .00686 L
.32129 .00666 L
.32183 .00639 L
.32246 .00598 L
.32314 .00543 L
.32439 .00422 L
.32556 .00295 L
.3262 .00227 L
.3268 .00172 L
.32731 .00139 L
.32786 .00132 L
.32847 .0016 L
.32903 .00205 L
.33122 .00406 L
.33228 .00488 L
.33275 .00516 L
.33326 .00542 L
.33378 .00561 L
.33428 .00571 L
.33485 .00573 L
.33538 .00565 L
.33592 .00546 L
.33651 .00513 L
.33713 .00465 L
.33771 .00409 L
.33883 .0028 L
.33945 .00213 L
.34003 .00176 L
Mistroke
.34036 .00177 L
.34071 .00199 L
.34104 .00232 L
.34134 .00269 L
.34255 .00443 L
.34311 .00519 L
.34371 .00592 L
.34427 .00647 L
.34479 .00687 L
.34538 .00716 L
.34592 .00727 L
.34652 .00722 L
.34685 .00711 L
.34716 .00695 L
.34766 .00662 L
.34819 .00613 L
.34915 .00502 L
.3502 .0037 L
.3508 .00311 L
.35135 .00286 L
.3519 .00297 L
.35248 .00345 L
.35311 .00416 L
.35368 .00486 L
.35421 .00548 L
.35478 .00606 L
.3553 .0065 L
.35581 .00681 L
.35637 .00702 L
.35688 .00708 L
.35745 .00701 L
.35777 .00691 L
.35807 .00677 L
.35868 .00639 L
.35923 .00594 L
.36047 .00469 L
.36153 .00362 L
.36213 .00318 L
.36268 .00297 L
.36316 .00297 L
.36369 .00314 L
.36425 .00346 L
.36476 .00382 L
.36537 .00426 L
.36602 .00469 L
.3666 .00499 L
.36722 .00524 L
.36777 .00537 L
.36838 .00542 L
.36893 .00539 L
Mistroke
.36945 .00528 L
.36976 .00519 L
.3701 .00506 L
.37071 .00478 L
.37187 .00407 L
.37312 .00316 L
.37377 .00267 L
.37447 .00221 L
.37508 .0019 L
.37543 .0018 L
.37576 .00176 L
.37633 .00183 L
.37694 .00207 L
.37757 .00242 L
.37816 .0028 L
.37928 .00348 L
.3798 .00376 L
.38036 .00402 L
.38084 .0042 L
.38137 .00435 L
.38192 .00445 L
.38245 .00448 L
.38275 .00447 L
.38307 .00443 L
.38364 .00431 L
.38425 .00409 L
.38481 .00382 L
.38606 .00293 L
.38723 .00183 L
.38775 .00131 L
.38831 .00082 L
.38892 .00079 L
.38926 .00107 L
.38957 .00141 L
.39094 .00307 L
.39223 .00449 L
.39286 .00505 L
.39342 .00545 L
.394 .00573 L
.39455 .00588 L
.39512 .0059 L
.39545 .00585 L
.39574 .00575 L
.39633 .00545 L
.39666 .00522 L
.39698 .00495 L
.39827 .00345 L
.39882 .00267 L
.39942 .00181 L
.39998 .00116 L
Mistroke
.4005 .00117 L
.4011 .00192 L
.40175 .00295 L
.40288 .00471 L
.4039 .00597 L
.40448 .00648 L
.405 .0068 L
.40547 .00697 L
.40597 .00701 L
.4065 .00689 L
.40699 .00665 L
.40759 .00619 L
.40814 .0056 L
.40919 .00416 L
.40977 .00324 L
.4104 .00227 L
.41099 .0016 L
.41153 .0016 L
.41206 .00217 L
.41264 .00303 L
.41369 .00461 L
.41429 .00537 L
.41493 .00601 L
.41553 .00645 L
.41607 .00668 L
.41638 .00674 L
.41669 .00676 L
.41726 .00665 L
.41788 .00635 L
.41823 .0061 L
.41855 .00583 L
.41968 .00458 L
.42088 .00297 L
.42142 .00229 L
.42199 .00175 L
.42229 .00163 L
.42262 .00166 L
.4232 .00204 L
.42374 .0026 L
.42433 .00324 L
.42539 .00426 L
.42592 .00465 L
.42649 .00497 L
.42703 .00517 L
.42753 .00525 L
.42803 .00525 L
.42848 .00518 L
.429 .00502 L
.42949 .0048 L
.43004 .00448 L
Mistroke
.43062 .00407 L
.43167 .0032 L
.43281 .00215 L
.43341 .00164 L
.43374 .00139 L
.43405 .0012 L
.43437 .00108 L
.43472 .00105 L
.43502 .00112 L
.43534 .00126 L
.43598 .00167 L
.43657 .00208 L
.43776 .00287 L
.43834 .00319 L
.43886 .00345 L
.43933 .00363 L
.43983 .00379 L
.44036 .00391 L
.44087 .00397 L
.44142 .00398 L
.44201 .00393 L
.44251 .00383 L
.44306 .00367 L
.44364 .00343 L
.44416 .00317 L
.44535 .00238 L
.44645 .00145 L
.44699 .00094 L
.44748 .00046 L
.44805 .00026 L
.44865 .00086 L
.44971 .00202 L
.45085 .0032 L
.45145 .00376 L
.45209 .00428 L
.45265 .00466 L
.45316 .00493 L
.45368 .00512 L
.45417 .00521 L
.45471 .00521 L
.45522 .00511 L
.45577 .00488 L
.45636 .00451 L
.45857 .002 L
.45918 .00109 L
.45951 .0006 L
.45982 .0003 L
.46037 .00095 L
.46096 .00193 L
.46223 .00391 L
Mistroke
.46292 .00485 L
.46358 .00557 L
.4642 .00609 L
.46455 .0063 L
.46487 .00645 L
.46543 .00656 L
.46604 .0065 L
.46659 .00626 L
.46718 .00583 L
.46774 .00526 L
.46825 .00462 L
Mfstroke
.46825 .00462 m
.46864 .00412 L
.46906 .00364 L
.46946 .00324 L
.46984 .00289 L
.47024 .00257 L
.47063 .00229 L
.47105 .00203 L
.47145 .00181 L
.47183 .00162 L
.47224 .00144 L
.47263 .00129 L
.47301 .00115 L
.47341 .00103 L
.4738 .00092 L
.47421 .00082 L
.47461 .00073 L
.47499 .00066 L
.4754 .00059 L
.47579 .00054 L
.47621 .00049 L
.47661 .00045 L
.47699 .00043 L
.47719 .00042 L
.47729 .00041 L
.4774 .00041 L
.4775 .00041 L
.4776 .00041 L
.47764 .0004 L
.47766 .0004 L
.47769 .0004 L
.47771 .0004 L
.47772 .0004 L
.47774 .0004 L
.47775 .0004 L
.47776 .0004 L
.47777 .0004 L
.47778 .0004 L
s
.47778 .0004 m
.47839 .0004 L
.47895 .0004 L
.4796 .0004 L
.48021 .0004 L
.4813 .0004 L
.48248 .00039 L
.48515 .00037 L
.48762 .00035 L
.49266 .0003 L
.498 .00022 L
.50305 .00013 L
.50584 8e-005 L
.50721 6e-005 L
.50788 5e-005 L
.50849 4e-005 L
.50884 4e-005 L
.50921 4e-005 L
.50961 4e-005 L
.50998 3e-005 L
.51039 4e-005 L
.51083 4e-005 L
.5112 4e-005 L
.51161 5e-005 L
.51446 9e-005 L
.52005 .00018 L
.52529 .00025 L
.53026 .0003 L
.533 .00032 L
.53455 .00033 L
.53598 .00033 L
.53719 .00034 L
.53787 .00034 L
.53851 .00034 L
.53919 .00034 L
.53981 .00034 L
.54049 .00034 L
.54083 .00034 L
.5412 .00034 L
.54189 .00034 L
.54253 .00034 L
.54323 .00034 L
.54397 .00034 L
.54521 .00033 L
.54658 .00033 L
.5491 .00031 L
.55147 .00029 L
.55675 .00024 L
.56243 .00017 L
.56773 9e-005 L
Mistroke
.57053 5e-005 L
.57134 4e-005 L
.57173 3e-005 L
.57209 3e-005 L
.57278 2e-005 L
.57313 2e-005 L
.57351 2e-005 L
.57416 3e-005 L
.57453 3e-005 L
.57486 4e-005 L
.57612 5e-005 L
.57897 9e-005 L
.58403 .00016 L
.58889 .00022 L
.59404 .00026 L
.59673 .00028 L
.59826 .00029 L
.59969 .00029 L
.60033 .00029 L
.601 .00029 L
.60158 .0003 L
.6022 .0003 L
.60287 .0003 L
.6035 .0003 L
.60388 .0003 L
.60424 .0003 L
.60491 .0003 L
.60552 .0003 L
.60617 .0003 L
.60678 .00029 L
.60734 .00029 L
.60871 .00029 L
.61001 .00028 L
.61259 .00027 L
.61541 .00025 L
.62042 .00021 L
.62507 .00016 L
.62976 .0001 L
.63223 6e-005 L
.63357 5e-005 L
.63482 3e-005 L
.6352 3e-005 L
.63555 2e-005 L
.63621 2e-005 L
.63656 2e-005 L
.63694 2e-005 L
.63735 2e-005 L
.63772 2e-005 L
.63901 4e-005 L
.64038 5e-005 L
Mistroke
.6456 .00012 L
.65053 .00017 L
.65325 .0002 L
.65583 .00022 L
.65823 .00024 L
.66084 .00025 L
.66199 .00025 L
.66321 .00026 L
.66437 .00026 L
.66541 .00026 L
.66604 .00026 L
.66663 .00027 L
.66728 .00027 L
.66797 .00027 L
.66831 .00027 L
.66869 .00027 L
.66938 .00026 L
.67005 .00026 L
.67066 .00026 L
.67178 .00026 L
.67301 .00026 L
.67549 .00025 L
.6782 .00023 L
.68111 .00021 L
.68639 .00016 L
.69183 .0001 L
.69689 4e-005 L
.6982 3e-005 L
.69884 2e-005 L
.69944 2e-005 L
.70012 1e-005 L
.70048 1e-005 L
.70087 1e-005 L
.70148 2e-005 L
.70216 3e-005 L
.70793 9e-005 L
.71316 .00015 L
.71812 .00019 L
.72085 .00021 L
.72383 .00022 L
.72515 .00023 L
.72654 .00023 L
.72786 .00024 L
.72905 .00024 L
.72969 .00024 L
.73028 .00024 L
.73092 .00024 L
.73129 .00024 L
.73162 .00024 L
.73228 .00024 L
Mistroke
.73266 .00024 L
.733 .00024 L
.73364 .00024 L
.73432 .00024 L
.73551 .00024 L
.73662 .00023 L
.73915 .00023 L
.7419 .00021 L
.74441 .0002 L
.75006 .00015 L
.75486 .0001 L
.75999 5e-005 L
.76151 3e-005 L
.76225 2e-005 L
.76294 2e-005 L
.76356 1e-005 L
.76422 1e-005 L
.76488 1e-005 L
.76526 2e-005 L
.76561 2e-005 L
.77083 8e-005 L
.7763 .00013 L
.78148 .00017 L
.78613 .0002 L
.7874 .00021 L
.78876 .00021 L
.78992 .00022 L
.79119 .00022 L
.79243 .00022 L
.79311 .00022 L
.79374 .00022 L
.79434 .00022 L
.79488 .00022 L
.7955 .00022 L
.79609 .00022 L
.79673 .00022 L
.79741 .00022 L
.79799 .00022 L
.79862 .00022 L
.80004 .00022 L
.80137 .00022 L
.80378 .00021 L
.80598 .0002 L
.81094 .00016 L
.81616 .00012 L
.82173 7e-005 L
.82444 4e-005 L
.82576 2e-005 L
.82634 2e-005 L
.82698 1e-005 L
Mistroke
.82756 1e-005 L
.8281 1e-005 L
.82866 1e-005 L
.82927 2e-005 L
.83174 4e-005 L
.84133 .00013 L
.84396 .00015 L
.84674 .00017 L
.84915 .00018 L
.85175 .0002 L
.85317 .0002 L
.85448 .0002 L
.85573 .00021 L
.85642 .00021 L
.85704 .00021 L
.85774 .00021 L
.85813 .00021 L
.85849 .00021 L
.85913 .00021 L
.8595 .00021 L
.85983 .00021 L
.8602 .00021 L
.86054 .00021 L
.86091 .00021 L
.86131 .00021 L
.86213 .00021 L
.86288 .00021 L
.86422 .00021 L
.86547 .0002 L
.86829 .00019 L
.87077 .00018 L
.87342 .00016 L
.8837 8e-005 L
.88821 4e-005 L
.88945 3e-005 L
.89013 2e-005 L
.89077 1e-005 L
.89137 1e-005 L
.89201 1e-005 L
.8926 1e-005 L
.89315 1e-005 L
.89807 6e-005 L
.90326 .00011 L
.90889 .00015 L
.91164 .00017 L
.91416 .00018 L
.91659 .00019 L
.9177 .00019 L
.91889 .0002 L
.91955 .0002 L
Mistroke
.92015 .0002 L
.92076 .0002 L
.92132 .0002 L
.92197 .0002 L
.92232 .0002 L
.92268 .0002 L
.92329 .0002 L
.92397 .0002 L
.92431 .0002 L
.92469 .0002 L
.92538 .0002 L
.92604 .0002 L
.92666 .0002 L
.92806 .0002 L
.92955 .00019 L
.93203 .00018 L
.93476 .00017 L
.94005 .00014 L
.94489 .0001 L
.95054 5e-005 L
.9533 2e-005 L
.9545 1e-005 L
.95514 1e-005 L
.95581 0 L
.95641 1e-005 L
.95707 1e-005 L
.95823 2e-005 L
.96051 4e-005 L
.96554 9e-005 L
.97619 .00016 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0?moomMoo`003gooo`00^00047oo000JOol40002Ool20006Ool00`00Oomoo`0:Ool00`00Oomoo`0;
Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;
Ool00`00Oomoo`0;Ool00`00Oomoo`04Ool30002Ool30002Ool30002Ool30002Ool700000goo001o
o`02Ool3000017oo000000000Woo0`000Woo1`0000=oo`0000000Woo0P000Woo0P000Woo00<007oo
Ool01goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007oo
Ool02Woo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007oo
Ool02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02Woo00<007oo
Ool02goo00<007ooOol06Goo000JOol01000Oomoogoo1P004Goo00<007ooOol0@goo00<007ooOol0
6goo0P0000=oo`0000000goo0`0000Ioo`00001oo`00Ool4000017oo0000000017oo0P000goo0`00
0Woo00@007oo001oo`@00004Ool000000009Ool30002Ool30003Ool00`00Oomoo`0SOol00`00Oomo
o`12Ool00`00Oomoo`13Ool00`00Oomoo`12Ool002=oo`D0071oo`D000Uoo`8000=oo`8001=oo`80
00=oo`8001Aoo`8000=oo`03001oogoo0?=oo`00:7oo1000K7oo00<007ooOol09Goo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00:goo0P00JGoo0P00:7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00;Goo0`00Hgoo1000:Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00;Woo00<007oo
0000HGoo0P00;7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00<Goo00<007ooOol0GWoo00<0
07ooOol0:goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00<Goo00<007ooOol0GGoo00<007oo
Ool0;7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00<Woo00<007ooOol0FGoo1000;Woo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00<goo00<007ooOol0F7oo00<007ooOol0;goo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00=7oo00<007ooOol0EWoo00<007ooOol0<7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00=7oo00<007ooOol0EWoo00<007ooOol0<7oo0`006Goo00D007oo
Oomoo`000?Eoo`00=Goo00<007ooOol0E7oo00<007ooOol0<Goo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00=Woo00<007ooOol0DWoo0P00<goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
=goo00<007ooOol0D7oo00<007ooOol0<goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00=goo
00<007ooOol0D7oo00<007ooOol0<goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00>7oo00<0
07ooOol0CWoo00<007ooOol0=7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00>7oo00<007oo
Ool0CGoo00<007ooOol0=Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00>Goo00<007ooOol0
C7oo00<007ooOol0=Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00>Goo00<007ooOol0Bgoo
00<007ooOol0=Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00>Woo00<007ooOol0BWoo00<0
07ooOol0=Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00>Woo00<007ooOol0BGoo00<007oo
Ool0=goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00>Woo00<007ooOol0BGoo00<007ooOol0
=goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00>goo00<007ooOol0Agoo00<007ooOol0>7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00>goo00<007ooOol0Agoo00<007ooOol0>7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00?7oo00<007ooOol0AGoo00<007ooOol0>Goo0`006Goo
00D007ooOomoo`000?Eoo`00?7oo00<007ooOol0AGoo00<007ooOol0>Goo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00?7oo00<007ooOol0A7oo00<007ooOol0>Woo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00?Goo00<007ooOol0@goo00<007ooOol0>Woo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00?Goo00<007ooOol0@goo00<007ooOol0>Woo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00?Woo00<007ooOol0@Goo00<007ooOol0>goo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00?Woo00<007ooOol0@Goo00<007ooOol0>goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
?Woo00<007ooOol0@7oo00<007ooOol0?7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00?goo
00<007ooOol0?goo00<007ooOol0?7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00?goo00<0
07ooOol0?Woo00<007ooOol0?Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00@7oo00<007oo
Ool0?Goo00<007ooOol0?Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00@7oo00<007ooOol0
?Goo00<007ooOol0?Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00@7oo00<007ooOol0?7oo
00<007ooOol0?Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00@Goo00<007ooOol0>goo00<0
07ooOol0?Woo0`006Goo00D007ooOomoo`000?Eoo`00@Goo00<007ooOol0>Woo00<007ooOol0?goo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00@Woo00<007ooOol0>Goo00<007ooOol0?goo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00@Woo00<007ooOol0>7oo00<007ooOol0@7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00@Woo00<007ooOol0>7oo00<007ooOol0@7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00@goo00<007ooOol0=goo00<007ooOol0@7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00@goo00<007ooOol0=Woo00<007ooOol0@Goo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00@goo00<007ooOol0=Woo00<007ooOol0@Goo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00@goo00<007ooOol0=Goo00<007ooOol0@Woo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00A7oo00<007ooOol0=7oo00<007ooOol0@Woo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00A7oo00<007ooOol0<goo00<007ooOol0=goo1P001Woo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00A7oo00<007ooOol0<goo00<007ooOol0=goo00<007ooOol02Goo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00AGoo00<007ooOol0<Woo00<007ooOol0>7oo00<007ooOol027oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00AGoo00<007ooOol0<Goo00<007ooOol0>Woo00<007oo
Ool01goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00AGoo00<007ooOol0<Goo00<007ooOol0
>goo00<007ooOol01Woo100067oo00D007ooOomoo`000?Eoo`00AWoo00<007ooOol0<7oo00<007oo
Ool0?7oo00<007ooOol01Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00AWoo00<007ooOol0
<7oo00<007ooOol0?Goo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00AWoo
00<007ooOol0;goo00<007ooOol0?Woo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00AWoo00<007ooOol0;goo00<007ooOol0>Goo00<007ooOol00Woo00<007ooOol017oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00Agoo00<007ooOol0;Woo00<007ooOol0>Woo10001goo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Agoo00<007ooOol0;Woo00<007ooOol0AGoo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00Agoo00<007ooOol0;Goo00<007ooOol0AWoo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00B7oo00<007ooOol0;7oo00<007ooOol0AWoo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00B7oo00<007ooOol0;7oo00<007ooOol0AWoo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00B7oo00<007ooOol0:goo00<007ooOol0Agoo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00BGoo00<007ooOol0:Woo00<007ooOol0Agoo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00BGoo00<007ooOol0:Woo00<007ooOol0Agoo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00BGoo00<007ooOol0:Woo00<007ooOol0Agoo0`006Goo00D007ooOomoo`000?Eoo`00
BGoo00<007ooOol0:Goo00<007ooOol0B7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00BWoo
00<007ooOol0:7oo00<007ooOol0B7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00BWoo00<0
07ooOol0:7oo00<007ooOol0B7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00BWoo00<007oo
Ool0:7oo00<007ooOol0B7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Bgoo00<007ooOol0
9Woo00<007ooOol0BGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Bgoo00<007ooOol09Woo
00<007ooOol0BGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Bgoo00<007ooOol09Woo00<0
07ooOol0BGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Bgoo00<007ooOol09Woo00<007oo
Ool0BGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00C7oo00<007ooOol097oo00<007ooOol0
BWoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00C7oo00<007ooOol097oo00<007ooOol0BWoo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00C7oo00<007ooOol097oo00<007ooOol0BWoo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00CGoo00<007ooOol08Woo00<007ooOol0Bgoo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00CGoo00<007ooOol08Woo00<007ooOol0Bgoo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00CGoo00<007ooOol08Woo00<007ooOol0Bgoo0`006Goo00D007oo
Oomoo`000?Eoo`00CGoo00<007ooOol08Goo00<007ooOol0C7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00CWoo00<007ooOol087oo00<007ooOol0C7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00CWoo00<007ooOol087oo00<007ooOol0C7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00CWoo00<007ooOol087oo00<007ooOol0C7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
Cgoo00<007ooOol07Woo00<007ooOol0CGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Cgoo
00<007ooOol07Woo00<007ooOol0CGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Cgoo00<0
07ooOol07Woo00<007ooOol0CGoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00D7oo00<007oo
Ool077oo00<007ooOol0CWoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00D7oo00<007ooOol0
77oo00<007ooOol0CWoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00D7oo00<007ooOol077oo
00<007ooOol0CWoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00D7oo00<007ooOol06goo00<0
07ooOol0Cgoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00DGoo00<007ooOol06Woo00<007oo
Ool0Cgoo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00DGoo00<007ooOol06Goo00<007ooOol0
D7oo0`006Goo00D007ooOomoo`000?Eoo`00DGoo00<007ooOol06Goo00<007ooOol0D7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00DWoo00<007ooOol067oo00<007ooOol0D7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00DWoo00<007ooOol05goo00<007ooOol0DGoo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00Dgoo00<007ooOol05Woo00<007ooOol0DGoo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00Dgoo00<007ooOol05Goo00<007ooOol0DWoo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00E7oo00<007ooOol057oo00<007ooOol0DWoo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00E7oo00<007ooOol04goo00<007ooOol0Dgoo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00EGoo00<007ooOol04Woo00<007ooOol0Dgoo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00EGoo00<007ooOol04Goo00<007ooOol0E7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
EGoo00<007ooOol04Goo00<007ooOol0Bgoo0`001Woo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00EWoo00<007ooOol03goo00<007ooOol0CGoo00<007ooOol01Goo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00EWoo00<007ooOol03goo00<007ooOol0CGoo00<007ooOol01Goo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00EWoo00<007ooOol03Woo00<007ooOol0BWoo1P001Woo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00Egoo00<007ooOol037oo00<007ooOol0Bgoo00D007ooOomo
o`0000Moo`@001Qoo`05001oogooOol0003eOol005Qoo`03001oogoo00]oo`03001oogoo04aoo`04
001oogoo0007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001IOol00`00Oomoo`09Ool2001?
Ool00`00Ool00007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001JOol00`00Oomoo`07Ool2
001@Ool00`00Ool00007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001JOol00`00Oomoo`06
Ool2001BOol20007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001KOol00`00Oomoo`04Ool0
0`00Oomoo`1COol00`00Oomoo`05Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001LOol40000
0goo001oo`1MOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001OOol3001NOol00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo002eOol40007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02
Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool0
0`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00
Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol20003Ool00`00Oomoo`04Ool4
000HOol01@00Oomoogoo0000mGoo002dOol00`00Ool000020007Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo002dOol00`00Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol0
0`00Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002eOol00`00Oomoo`08Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo002fOol30007Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3
000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002e
Ool40007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00Oomo
o`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00Oomoo`04
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool4000H
Ool5003eOol00;Eoo`@000Moo`03001oogoo0?mooaAoo`00]7oo00<007ooOol00Woo00<007ooOol0
17oo00<007ooOol0ogoo57oo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`3oOolD
Ool00;Aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0?mooaAoo`00]Goo10001goo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool3003oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool0
0`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool0
0`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool0
0`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00[7oo1@0017oo10001goo00<007ooOol0
ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`3oOolD
Ool00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0?mooaAoo`00
[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0ogoo57oo002^Ool0
0`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool4003oOolCOol00:ioo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo0?mooa]oo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<0
07ooOol0ogoo6goo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`3oOolKOol00:ao
o`<000Eoo`03001oogoo009oo`03001oogoo0?mooa]oo`00\
\>"],
  ImageRangeCache->{{{0, 469}, {289.313, 0}} -> {-13.8869, -0.535215, 
  0.0720124, 0.03699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .00403 m
.02436 .00412 L
.02486 .00417 L
.02543 .00418 L
.02598 .00414 L
.02648 .00405 L
.02695 .00395 L
.028 .00362 L
.02855 .00343 L
.02915 .00325 L
.02971 .00313 L
.03023 .0031 L
.0308 .00317 L
.03135 .00335 L
.03194 .00364 L
.03259 .00405 L
.03378 .00484 L
.03437 .00519 L
.03491 .00545 L
.03521 .00556 L
.03553 .00566 L
.03585 .00573 L
.03621 .00576 L
.03682 .00573 L
.03738 .00559 L
.03796 .00535 L
.03851 .00504 L
.03953 .00431 L
.04007 .00391 L
.04064 .00354 L
.04093 .0034 L
.04126 .00329 L
.04184 .00327 L
.04243 .00347 L
.04277 .00368 L
.04308 .0039 L
.04439 .00499 L
.04497 .00543 L
.04551 .00578 L
.04582 .00592 L
.04615 .00605 L
.04672 .00617 L
.04705 .00618 L
.04735 .00615 L
.04769 .00608 L
.04805 .00595 L
.04843 .00576 L
.04879 .00553 L
.04946 .00501 L
.05068 .00382 L
Mistroke
.05135 .00317 L
.05168 .00291 L
.05198 .00272 L
.05258 .00254 L
.05289 .00258 L
.05322 .0027 L
.05376 .00305 L
.05434 .00354 L
.05549 .00452 L
.05599 .00488 L
.05654 .0052 L
.05687 .00535 L
.05717 .00545 L
.05778 .00556 L
.05808 .00556 L
.05842 .00553 L
.05878 .00546 L
.05911 .00535 L
.05971 .00508 L
.06026 .00473 L
.0615 .00374 L
.06205 .00326 L
.06264 .00277 L
.06321 .0024 L
.06372 .00222 L
.06432 .00227 L
.06463 .0024 L
.06496 .00259 L
.06609 .0035 L
.06715 .0044 L
.06774 .00482 L
.06829 .00516 L
.06881 .0054 L
.06937 .00558 L
.06988 .00566 L
.07035 .00567 L
.0709 .00561 L
.0715 .00545 L
.07206 .00523 L
.07258 .00499 L
.07375 .00441 L
.07407 .00428 L
.07442 .00417 L
.07474 .0041 L
.07504 .00407 L
.07563 .00413 L
.07597 .00424 L
.07628 .00437 L
.07686 .00471 L
.07746 .00514 L
Mistroke
.07877 .00613 L
.07942 .00657 L
.08002 .00691 L
.08055 .00715 L
.08112 .00733 L
.08144 .00741 L
.08174 .00745 L
.08231 .00749 L
.08284 .00746 L
.08332 .0074 L
.08385 .0073 L
.08441 .00718 L
.08498 .00705 L
.08558 .00693 L
.08615 .00687 L
.08667 .00687 L
.08728 .00696 L
.08762 .00705 L
.08794 .00716 L
.08852 .00744 L
.08914 .00782 L
.0911 .00924 L
.09163 .0096 L
.0922 .00991 L
.09268 .01013 L
.0932 .01029 L
.09378 .01038 L
.09411 .01038 L
.0944 .01036 L
.09497 .01026 L
.09551 .01011 L
.09605 .00993 L
.09664 .00976 L
.09718 .00965 L
.09768 .00965 L
.09821 .00979 L
.09879 .01011 L
.09934 .01057 L
.09985 .01112 L
.1011 .01272 L
.10222 .01408 L
.1028 .01463 L
.10311 .01485 L
.10342 .01505 L
.10401 .01527 L
.10455 .01535 L
.10516 .01529 L
.10574 .01517 L
.10606 .01509 L
.10636 .01503 L
Mistroke
.10671 .01498 L
.10703 .01498 L
.10753 .01509 L
.10807 .01541 L
.10864 .01599 L
.10918 .01675 L
.11116 .02066 L
.11227 .02276 L
.11281 .02358 L
.11332 .0242 L
.1139 .02472 L
.11421 .02492 L
.11453 .02509 L
.11512 .02529 L
.11564 .02541 L
.1162 .02555 L
.11673 .02577 L
.1173 .02617 L
.11792 .02687 L
.11823 .02733 L
.11856 .02793 L
.11917 .02924 L
.12032 .03224 L
.12462 .04139 L
.13434 .06365 L
.15336 .12037 L
.17168 .18125 L
.18087 .21067 L
.18489 .22268 L
.18599 .22683 L
.18717 .23067 L
.18774 .23219 L
.18828 .23339 L
.18929 .2351 L
.1904 .23647 L
.19158 .23789 L
.19258 .2395 L
.19369 .24189 L
.19591 .24798 L
.19714 .25109 L
.19775 .25233 L
.19832 .25327 L
.19892 .25406 L
.19958 .25468 L
.20014 .25506 L
.20074 .25538 L
.20138 .25568 L
.20208 .25604 L
.20274 .25648 L
.20334 .257 L
Mistroke
.20454 .25838 L
.20581 .26018 L
.20688 .2617 L
.20805 .26304 L
.20835 .26331 L
.20867 .26356 L
.20924 .26389 L
.20978 .26408 L
.21037 .26416 L
.21089 .26412 L
.21146 .264 L
.21199 .26383 L
.21248 .26363 L
.21368 .26312 L
.21426 .26289 L
.21479 .26273 L
.21535 .2626 L
.21596 .26252 L
.21627 .26251 L
.21661 .26251 L
.21723 .26254 L
.21777 .2626 L
.21834 .26266 L
.21889 .26269 L
.21939 .26268 L
.21995 .26258 L
.22048 .26239 L
.22106 .26206 L
.22138 .2618 L
.22168 .26152 L
.22263 .26037 L
.22367 .25867 L
.22579 .2548 L
.23556 .23858 L
.24453 .2186 L
.26256 .16346 L
.28103 .10218 L
.29879 .06026 L
.30869 .04263 L
.3177 .0288 L
.32219 .02427 L
.32341 .02167 L
.32455 .01955 L
.32513 .01875 L
.32545 .01841 L
.32574 .01815 L
.32607 .01795 L
.32642 .0178 L
.32675 .01772 L
.32706 .0177 L
Mistroke
.32766 .01775 L
.32823 .01786 L
.32874 .01796 L
.32928 .01801 L
.32988 .01797 L
.33042 .01783 L
.33101 .01753 L
.33135 .0173 L
.33166 .01705 L
.33273 .01589 L
.33371 .01458 L
.3359 .01154 L
.33641 .01097 L
.33697 .01047 L
.33758 .01005 L
.33815 .0098 L
.33875 .00966 L
.33906 .00962 L
.33939 .00961 L
.33998 .00963 L
.34053 .00968 L
.34109 .00972 L
.34161 .00973 L
.34209 .00971 L
.3426 .00964 L
.34316 .00949 L
.34375 .00926 L
.34425 .00899 L
.34481 .00862 L
.34607 .00749 L
.34722 .0062 L
.34846 .00471 L
.34912 .00398 L
.34948 .00364 L
.34982 .00336 L
.35013 .00316 L
.35047 .00302 L
.35106 .00295 L
.35167 .0031 L
.35222 .00337 L
.35341 .00405 L
.35398 .00434 L
.3545 .00456 L
.35504 .00473 L
.35563 .00485 L
.35615 .00489 L
.3567 .00488 L
.35728 .00481 L
.35782 .0047 L
.35842 .00452 L
Mistroke
.35906 .00427 L
.36019 .00368 L
.36127 .00293 L
.36234 .00198 L
.3633 .00095 L
.3639 .00028 L
.36446 .00057 L
.36505 .00135 L
.3657 .00224 L
.36675 .00369 L
.36792 .0051 L
.36853 .0057 L
.36919 .00619 L
.36956 .00638 L
.36989 .00651 L
.37022 .00658 L
.37054 .0066 L
.37114 .0065 L
.3717 .00625 L
.37231 .00579 L
.37295 .00511 L
.37406 .00361 L
.37467 .00272 L
.37523 .00202 L
.37571 .00176 L
.37623 .00203 L
.3768 .00279 L
.37732 .00363 L
.37848 .00547 L
.3791 .00629 L
.37974 .00697 L
.38031 .00739 L
.38063 .00756 L
.38093 .00765 L
.38146 .0077 L
.38203 .00756 L
.3826 .00725 L
.38313 .00681 L
.3837 .00619 L
.38432 .0054 L
.38544 .00382 L
.38598 .00313 L
.38649 .00271 L
.38699 .00262 L
.38751 .0029 L
.38804 .00343 L
.38862 .00415 L
.38963 .00536 L
.39007 .00581 L
.39056 .00622 L
Mistroke
.39113 .00658 L
.39173 .0068 L
.39205 .00685 L
.39239 .00685 L
.39271 .0068 L
.39301 .00672 L
.39355 .00648 L
.39414 .0061 L
.39533 .00503 L
.39642 .00388 L
.39702 .00327 L
.39758 .00279 L
.39811 .00249 L
.39868 .00239 L
.3992 .00251 L
.39967 .00275 L
.40086 .00355 L
.40151 .00398 L
.40213 .00434 L
.4027 .00461 L
.403 .00473 L
.40332 .00483 L
.40389 .00494 L
.40442 .00499 L
.40473 .00498 L
.40507 .00495 L
.40567 .00483 L
.40627 .00463 L
.40681 .00438 L
.40809 .00359 L
.40944 .0025 L
.41001 .00198 L
.41063 .00143 L
.41122 .00099 L
.41176 .00082 L
.41225 .00099 L
.41279 .00141 L
.41388 .00242 L
.41506 .00347 L
.41571 .00398 L
.41633 .00439 L
.41691 .0047 L
.41721 .00483 L
.41753 .00495 L
.4181 .00508 L
.41863 .00511 L
.41921 .00505 L
.41974 .00489 L
.42033 .00461 L
.42062 .00442 L
Mistroke
.42094 .00418 L
.42207 .00309 L
.42312 .00174 L
.42365 .00098 L
.42415 .00028 L
.4246 .00058 L
.42509 .00136 L
.4272 .00458 L
.42828 .00584 L
.4289 .00635 L
.42946 .00666 L
.42995 .0068 L
.43049 .00681 L
.43106 .00664 L
.43158 .00633 L
.43188 .00609 L
.43221 .00576 L
.43281 .00505 L
.43392 .0033 L
.43455 .00215 L
.4349 .00151 L
.43522 .00095 L
.43579 .0008 L
.4361 .00129 L
.43642 .0019 L
.43768 .00428 L
.43834 .00537 L
.43905 .00632 L
.4394 .0067 L
.43973 .007 L
.44034 .00739 L
.44092 .00754 L
.44125 .00753 L
.44154 .00747 L
.44211 .00721 L
.44263 .00679 L
.44321 .00616 L
.44382 .00532 L
.44496 .00339 L
.44561 .0022 L
.44622 .00126 L
.4468 .00117 L
.44713 .00157 L
.44742 .00204 L
.4487 .00416 L
.44981 .00563 L
.45037 .00615 L
.45098 .00654 L
.45133 .00667 L
.45166 .00674 L
Mistroke
.45228 .00671 L
.45263 .00661 L
.45294 .00647 L
.45329 .00625 L
.45366 .00597 L
.45485 .00472 L
.45615 .00296 L
.45678 .00209 L
.45738 .00139 L
.45791 .00111 L
.4585 .00141 L
.4588 .0017 L
.45913 .00206 L
.4598 .00281 L
.46043 .00344 L
.46101 .00394 L
.46155 .00432 L
.46214 .00463 L
.46273 .00484 L
.46305 .00491 L
.46335 .00495 L
.46391 .00494 L
.46441 .00486 L
.465 .00468 L
.46555 .00444 L
.46623 .00405 L
.46696 .00353 L
.46825 .00243 L
Mfstroke
.46825 .00243 m
.46864 .00209 L
.46906 .00178 L
.46946 .00152 L
.46984 .00131 L
.47024 .00112 L
.47063 .00095 L
.47105 .00081 L
.47145 .00069 L
.47183 .00059 L
.47224 .00049 L
.47263 .00042 L
.47301 .00036 L
.47341 .0003 L
.4738 .00025 L
.47421 .00021 L
.47461 .00018 L
.47499 .00015 L
.4754 .00013 L
.47579 .00011 L
.47621 9e-005 L
.47661 8e-005 L
.47699 7e-005 L
.47719 6e-005 L
.4774 6e-005 L
.47778 5e-005 L
s
.47778 5e-005 m
.48762 .00019 L
.49263 .00027 L
.498 .00034 L
.50085 .00037 L
.50345 .00039 L
.5047 .00039 L
.50536 .0004 L
.50605 .0004 L
.50666 .0004 L
.50734 .0004 L
.50795 .0004 L
.50852 .0004 L
.50889 .0004 L
.50923 .0004 L
.50961 .0004 L
.51001 .0004 L
.51039 .0004 L
.51075 .0004 L
.51142 .0004 L
.51208 .0004 L
.5127 .0004 L
.51407 .00039 L
.51546 .00038 L
.51698 .00037 L
.52005 .00035 L
.52539 .00028 L
.53026 .00021 L
.53594 .00011 L
.53844 7e-005 L
.53977 5e-005 L
.54014 4e-005 L
.54052 4e-005 L
.5412 3e-005 L
.54182 3e-005 L
.5424 3e-005 L
.54303 4e-005 L
.5437 5e-005 L
.54605 8e-005 L
.55119 .00017 L
.55684 .00024 L
.56206 .0003 L
.56466 .00032 L
.56599 .00032 L
.56742 .00033 L
.56816 .00033 L
.56885 .00034 L
.56954 .00034 L
.57018 .00034 L
.57057 .00034 L
Mistroke
.57093 .00034 L
.57132 .00034 L
.57174 .00034 L
.57211 .00034 L
.57251 .00034 L
.57288 .00034 L
.57323 .00034 L
.57384 .00034 L
.57449 .00034 L
.57511 .00034 L
.57567 .00034 L
.57705 .00033 L
.57836 .00033 L
.58095 .00031 L
.58377 .00029 L
.5887 .00024 L
.59414 .00017 L
.59988 8e-005 L
.6024 4e-005 L
.60309 4e-005 L
.60346 3e-005 L
.60382 3e-005 L
.60415 2e-005 L
.60451 2e-005 L
.60514 2e-005 L
.60574 2e-005 L
.60639 3e-005 L
.60772 5e-005 L
.61009 8e-005 L
.61529 .00015 L
.621 .00022 L
.6237 .00024 L
.62621 .00026 L
.62872 .00028 L
.63004 .00029 L
.63144 .00029 L
.63203 .00029 L
.63266 .00029 L
.63321 .00029 L
.6338 .0003 L
.63446 .0003 L
.63482 .0003 L
.63516 .0003 L
.63576 .0003 L
.63641 .0003 L
.63676 .0003 L
.63714 .0003 L
.63782 .0003 L
.63855 .00029 L
.63935 .00029 L
Mistroke
.64079 .00029 L
.64214 .00028 L
.64465 .00027 L
.64735 .00025 L
.65264 .0002 L
.65842 .00014 L
.66393 6e-005 L
.6652 5e-005 L
.66654 3e-005 L
.66709 2e-005 L
.66768 2e-005 L
.66833 1e-005 L
.66893 2e-005 L
.66962 2e-005 L
.67027 3e-005 L
.67148 4e-005 L
.67424 8e-005 L
.67924 .00014 L
.68456 .0002 L
.68748 .00022 L
.69021 .00024 L
.6926 .00025 L
.69394 .00026 L
.69517 .00026 L
.69644 .00026 L
.69717 .00026 L
.69784 .00026 L
.6982 .00026 L
.69855 .00027 L
.69919 .00027 L
.69955 .00027 L
.69989 .00027 L
.70025 .00027 L
.70064 .00027 L
.70124 .00026 L
.70179 .00026 L
.70242 .00026 L
.70301 .00026 L
.70408 .00026 L
.70523 .00026 L
.70785 .00024 L
.71028 .00023 L
.71583 .00019 L
.72105 .00013 L
.7257 8e-005 L
.72817 5e-005 L
.72952 3e-005 L
.7308 2e-005 L
.73147 1e-005 L
.73184 1e-005 L
Mistroke
.73219 1e-005 L
.7328 1e-005 L
.73345 2e-005 L
.73593 5e-005 L
.74134 .00011 L
.74639 .00016 L
.75101 .0002 L
.75353 .00021 L
.75593 .00023 L
.75716 .00023 L
.75847 .00023 L
.75922 .00024 L
.7599 .00024 L
.76055 .00024 L
.76123 .00024 L
.76182 .00024 L
.76246 .00024 L
.76305 .00024 L
.7636 .00024 L
.76424 .00024 L
.76483 .00024 L
.76551 .00024 L
.76616 .00024 L
.76732 .00024 L
.76838 .00023 L
.77081 .00023 L
.77323 .00021 L
.77584 .0002 L
.78057 .00016 L
.78572 .00011 L
.78844 8e-005 L
.79135 5e-005 L
.79281 4e-005 L
.79419 2e-005 L
.7948 1e-005 L
.79543 1e-005 L
.79577 1e-005 L
.79613 1e-005 L
.79678 1e-005 L
.79804 3e-005 L
.79939 4e-005 L
.80183 7e-005 L
.80756 .00013 L
.81287 .00017 L
.81565 .00019 L
.81817 .0002 L
.82097 .00021 L
.8225 .00022 L
.82319 .00022 L
.82395 .00022 L
Mistroke
.82457 .00022 L
.82523 .00022 L
.8256 .00022 L
.82593 .00022 L
.82658 .00022 L
.82718 .00022 L
.82783 .00022 L
.82844 .00022 L
.829 .00022 L
.82965 .00022 L
.83026 .00022 L
.83165 .00022 L
.83301 .00022 L
.83447 .00021 L
.83707 .0002 L
.83949 .00019 L
.84497 .00015 L
.85066 9e-005 L
.85345 7e-005 L
.85602 4e-005 L
.85731 3e-005 L
.85852 1e-005 L
.85913 1e-005 L
.85978 1e-005 L
.86015 1e-005 L
.8605 1e-005 L
.86117 2e-005 L
.86674 7e-005 L
.87136 .00012 L
.87647 .00016 L
.88151 .00019 L
.88284 .00019 L
.88428 .0002 L
.88552 .0002 L
.88687 .00021 L
.88749 .00021 L
.88814 .00021 L
.88871 .00021 L
.88932 .00021 L
.88968 .00021 L
.89001 .00021 L
.89067 .00021 L
.89127 .00021 L
.8919 .00021 L
.89244 .00021 L
.89303 .00021 L
.89358 .00021 L
.89409 .00021 L
.89533 .00021 L
.89651 .0002 L
Mistroke
.89914 .0002 L
.90153 .00018 L
.90688 .00015 L
.9165 7e-005 L
.91905 5e-005 L
.92045 3e-005 L
.92175 2e-005 L
.92286 1e-005 L
.92348 0 L
.92405 1e-005 L
.92467 1e-005 L
.92535 2e-005 L
.92658 3e-005 L
.93176 8e-005 L
.93747 .00013 L
.94004 .00015 L
.94281 .00016 L
.94521 .00018 L
.94782 .00019 L
.94927 .00019 L
.95062 .0002 L
.95204 .0002 L
.95284 .0002 L
.95319 .0002 L
.95356 .0002 L
.95424 .0002 L
.95486 .0002 L
.95553 .0002 L
.95591 .0002 L
.95627 .0002 L
.95691 .0002 L
.9575 .0002 L
.95817 .0002 L
.95882 .0002 L
.96 .0002 L
.96111 .00019 L
.96319 .00019 L
.96542 .00018 L
.96783 .00016 L
.97619 .00011 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0?moomMoo`003gooo`00^00047oo000JOol50002Ool20002Ool4000017oo000000000goo00<007oo
Ool00Woo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007oo
Ool02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol00`000Woo1000
00Aoo`00000000=oo`8000=oo`@00003Ool0000000800005Ool00000Ool00002Ool30002Ool30002
Ool300000goo00000003Ool00`00Oomoo`07Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomo
o`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomo
o`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomo
o`0;Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0IOol001ioo`@00004Ool000000002
Ool30002Ool60002Ool00`00Oomoo`13Ool00`00Oomoo`0YOol2000017oo000000000goo0`000Woo
00<007oo00000Woo0`000Woo0`000goo0`000Woo100000Aoo`00Ool0009oo`<0009oo`@000=oo`03
001oogoo02=oo`03001oogoo049oo`03001oogoo04=oo`03001oogoo049oo`00<Woo1@00Kgoo0P00
2Goo00@007ooOomoo`<0009oo`8000Aoo`03001oogoo00Qoo`80009oo`<000=oo`03001oogoo00Ao
o`05001oogooOol0003eOol003Moo`D006Ioo`D001Uoo`03001oogoo01Uoo`05001oogooOol0003e
Ool003]oo`8006Eoo`03001oogoo01]oo`03001oogoo01Uoo`05001oogooOol0003eOol003aoo`@0
065oo`03001oogoo01aoo`03001oogoo01Uoo`05001oogooOol0003eOol003moo`03001oogoo05ao
o`@001ioo`03001oogoo01Uoo`05001oogooOol0003eOol0041oo`03001oogoo05Yoo`@001moo`03
001oogoo01Uoo`05001oogooOol0003eOol0041oo`03001oogoo05Yoo`03001oogoo021oo`03001o
ogoo01Uoo`05001oogooOol0003eOol0041oo`8005Yoo`03001oogoo025oo`03001oogoo01Uoo`05
001oogooOol0003eOol0045oo`<005Moo`03001oogoo029oo`03001oogoo01Uoo`05001oogooOol0
003eOol004=oo`03001oogoo05Aoo`03001oogoo02=oo`03001oogoo01Uoo`05001oogooOol0003e
Ool004Aoo`03001oogoo059oo`03001oogoo02Aoo`<001Uoo`05001oogooOol0003eOol004Aoo`03
001oogoo059oo`03001oogoo02Aoo`03001oogoo01Uoo`05001oogooOol0003eOol004Eoo`03001o
ogoo051oo`03001oogoo02Eoo`03001oogoo01Uoo`05001oogooOol0003eOol004Eoo`03001oogoo
04moo`03001oogoo02Ioo`03001oogoo01Uoo`05001oogooOol0003eOol004Ioo`03001oogoo04io
o`03001oogoo02Ioo`03001oogoo01Uoo`05001oogooOol0003eOol004Ioo`03001oogoo04eoo`03
001oogoo02Moo`03001oogoo01Uoo`05001oogooOol0003eOol004Ioo`03001oogoo04aoo`03001o
ogoo02Qoo`03001oogoo01Uoo`05001oogooOol0003eOol004Moo`03001oogoo04]oo`03001oogoo
02Qoo`03001oogoo01Uoo`05001oogooOol0003eOol004Moo`03001oogoo04Yoo`03001oogoo02Uo
o`03001oogoo01Uoo`05001oogooOol0003eOol004Qoo`03001oogoo04Uoo`03001oogoo02Uoo`03
001oogoo01Uoo`05001oogooOol0003eOol004Qoo`03001oogoo04Qoo`03001oogoo02Yoo`03001o
ogoo01Uoo`05001oogooOol0003eOol004Uoo`03001oogoo04Moo`03001oogoo02Yoo`03001oogoo
01Uoo`05001oogooOol0003eOol004Uoo`03001oogoo04Ioo`03001oogoo02]oo`03001oogoo01Uo
o`05001oogooOol0003eOol004Yoo`03001oogoo04Eoo`03001oogoo02]oo`03001oogoo01Uoo`05
001oogooOol0003eOol004Yoo`03001oogoo04Eoo`03001oogoo02]oo`<001Uoo`05001oogooOol0
003eOol004Yoo`03001oogoo04Aoo`03001oogoo02aoo`03001oogoo01Uoo`05001oogooOol0003e
Ool004]oo`03001oogoo04=oo`03001oogoo02aoo`03001oogoo01Uoo`05001oogooOol0003eOol0
04]oo`03001oogoo049oo`03001oogoo02eoo`03001oogoo01Uoo`05001oogooOol0003eOol004]o
o`03001oogoo049oo`03001oogoo02eoo`03001oogoo01Uoo`05001oogooOol0003eOol004aoo`03
001oogoo041oo`03001oogoo02ioo`03001oogoo01Uoo`05001oogooOol0003eOol004aoo`03001o
ogoo041oo`03001oogoo02ioo`03001oogoo01Uoo`05001oogooOol0003eOol004aoo`03001oogoo
03moo`03001oogoo02moo`03001oogoo01Uoo`05001oogooOol0003eOol004eoo`03001oogoo03io
o`03001oogoo02moo`03001oogoo01Uoo`05001oogooOol0003eOol004eoo`03001oogoo03ioo`03
001oogoo02moo`03001oogoo01Uoo`05001oogooOol0003eOol004eoo`03001oogoo03eoo`03001o
ogoo031oo`03001oogoo01Uoo`05001oogooOol0003eOol004ioo`03001oogoo03aoo`03001oogoo
031oo`03001oogoo01Uoo`05001oogooOol0003eOol004ioo`03001oogoo03]oo`03001oogoo035o
o`03001oogoo01Uoo`05001oogooOol0003eOol004ioo`03001oogoo03]oo`03001oogoo035oo`<0
01Uoo`05001oogooOol0003eOol004ioo`03001oogoo03Yoo`03001oogoo039oo`03001oogoo01Uo
o`05001oogooOol0003eOol004moo`03001oogoo03Uoo`03001oogoo039oo`03001oogoo01Uoo`05
001oogooOol0003eOol004moo`03001oogoo03Qoo`03001oogoo03=oo`03001oogoo01Uoo`05001o
ogooOol0003eOol004moo`03001oogoo03Qoo`03001oogoo03=oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol0051oo`03001oogoo03Moo`03001oogoo03=oo`03001oogoo01Uoo`05001oogooOol0
003eOol0051oo`03001oogoo03Ioo`03001oogoo03Aoo`03001oogoo01Uoo`05001oogooOol0003e
Ool0051oo`03001oogoo03Ioo`03001oogoo03Aoo`03001oogoo01Uoo`05001oogooOol0003eOol0
055oo`03001oogoo03Eoo`03001oogoo03Aoo`03001oogoo01Uoo`05001oogooOol0003eOol0055o
o`03001oogoo03Eoo`03001oogoo03Aoo`03001oogoo01Uoo`05001oogooOol0003eOol0055oo`03
001oogoo03Aoo`03001oogoo02Uoo`H000Ioo`03001oogoo01Uoo`05001oogooOol0003eOol0059o
o`03001oogoo03=oo`03001oogoo02Uoo`03001oogoo00Uoo`03001oogoo01Uoo`05001oogooOol0
003eOol0059oo`03001oogoo03=oo`03001oogoo02Yoo`03001oogoo00Qoo`03001oogoo01Uoo`05
001oogooOol0003eOol0059oo`03001oogoo039oo`03001oogoo02aoo`03001oogoo00Moo`03001o
ogoo01Uoo`05001oogooOol0003eOol005=oo`03001oogoo035oo`03001oogoo02eoo`03001oogoo
00Ioo`@001Qoo`05001oogooOol0003eOol005=oo`03001oogoo035oo`03001oogoo02ioo`03001o
ogoo00Eoo`03001oogoo01Uoo`05001oogooOol0003eOol005=oo`03001oogoo031oo`03001oogoo
031oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol005=oo`03001oogoo031o
o`03001oogoo031oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol005Aoo`03
001oogoo02moo`03001oogoo02]oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05
001oogooOol0003eOol005Aoo`03001oogoo02moo`03001oogoo02aoo`@000Moo`03001oogoo01Uo
o`05001oogooOol0003eOol005Aoo`03001oogoo02ioo`03001oogoo03Qoo`03001oogoo01Uoo`05
001oogooOol0003eOol005Eoo`03001oogoo02eoo`03001oogoo03Qoo`03001oogoo01Uoo`05001o
ogooOol0003eOol005Eoo`03001oogoo02eoo`03001oogoo03Qoo`03001oogoo01Uoo`05001oogoo
Ool0003eOol005Eoo`03001oogoo02aoo`03001oogoo03Uoo`03001oogoo01Uoo`05001oogooOol0
003eOol005Ioo`03001oogoo02]oo`03001oogoo03Uoo`03001oogoo01Uoo`05001oogooOol0003e
Ool005Ioo`03001oogoo02]oo`03001oogoo03Uoo`03001oogoo01Uoo`05001oogooOol0003eOol0
05Ioo`03001oogoo02Yoo`03001oogoo03Yoo`03001oogoo01Uoo`05001oogooOol0003eOol005Io
o`03001oogoo02Yoo`03001oogoo03Yoo`<001Uoo`05001oogooOol0003eOol005Moo`03001oogoo
02Uoo`03001oogoo03Yoo`03001oogoo01Uoo`05001oogooOol0003eOol005Moo`03001oogoo02Uo
o`03001oogoo03Yoo`03001oogoo01Uoo`05001oogooOol0003eOol005Moo`03001oogoo02Qoo`03
001oogoo03]oo`03001oogoo01Uoo`05001oogooOol0003eOol005Qoo`03001oogoo02Moo`03001o
ogoo03]oo`03001oogoo01Uoo`05001oogooOol0003eOol005Qoo`03001oogoo02Moo`03001oogoo
03]oo`03001oogoo01Uoo`05001oogooOol0003eOol005Qoo`03001oogoo02Ioo`03001oogoo03ao
o`03001oogoo01Uoo`05001oogooOol0003eOol005Uoo`03001oogoo02Eoo`03001oogoo03aoo`03
001oogoo01Uoo`05001oogooOol0003eOol005Uoo`03001oogoo02Eoo`03001oogoo03aoo`03001o
ogoo01Uoo`05001oogooOol0003eOol005Uoo`03001oogoo02Aoo`03001oogoo03eoo`03001oogoo
01Uoo`05001oogooOol0003eOol005Uoo`03001oogoo02Aoo`03001oogoo03eoo`03001oogoo01Uo
o`05001oogooOol0003eOol005Yoo`03001oogoo02=oo`03001oogoo03eoo`03001oogoo01Uoo`05
001oogooOol0003eOol005Yoo`03001oogoo029oo`03001oogoo03ioo`03001oogoo01Uoo`05001o
ogooOol0003eOol005Yoo`03001oogoo029oo`03001oogoo03ioo`03001oogoo01Uoo`05001oogoo
Ool0003eOol005]oo`03001oogoo025oo`03001oogoo03ioo`<001Uoo`05001oogooOol0003eOol0
05]oo`03001oogoo021oo`03001oogoo03moo`03001oogoo01Uoo`05001oogooOol0003eOol005]o
o`03001oogoo021oo`03001oogoo03moo`03001oogoo01Uoo`05001oogooOol0003eOol005aoo`03
001oogoo01moo`03001oogoo03moo`03001oogoo01Uoo`05001oogooOol0003eOol005aoo`03001o
ogoo01ioo`03001oogoo041oo`03001oogoo01Uoo`05001oogooOol0003eOol005aoo`03001oogoo
01ioo`03001oogoo041oo`03001oogoo01Uoo`05001oogooOol0003eOol005aoo`03001oogoo01io
o`03001oogoo041oo`03001oogoo01Uoo`05001oogooOol0003eOol005eoo`03001oogoo01aoo`03
001oogoo045oo`03001oogoo01Uoo`05001oogooOol0003eOol005eoo`03001oogoo01aoo`03001o
ogoo045oo`03001oogoo01Uoo`05001oogooOol0003eOol005eoo`03001oogoo01aoo`03001oogoo
045oo`03001oogoo01Uoo`05001oogooOol0003eOol005ioo`03001oogoo01Yoo`03001oogoo049o
o`03001oogoo01Uoo`05001oogooOol0003eOol005ioo`03001oogoo01Yoo`03001oogoo049oo`03
001oogoo01Uoo`05001oogooOol0003eOol005ioo`03001oogoo01Yoo`03001oogoo049oo`03001o
ogoo01Uoo`05001oogooOol0003eOol005moo`03001oogoo01Qoo`03001oogoo04=oo`<001Uoo`05
001oogooOol0003eOol005moo`03001oogoo01Qoo`03001oogoo04=oo`03001oogoo01Uoo`05001o
ogooOol0003eOol0061oo`03001oogoo01Moo`03001oogoo04=oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol0061oo`03001oogoo01Ioo`03001oogoo04Aoo`03001oogoo01Uoo`05001oogooOol0
003eOol0065oo`03001oogoo01Eoo`03001oogoo04Aoo`03001oogoo01Uoo`05001oogooOol0003e
Ool0065oo`03001oogoo01Aoo`03001oogoo04Eoo`03001oogoo01Uoo`05001oogooOol0003eOol0
065oo`03001oogoo01Aoo`03001oogoo04Eoo`03001oogoo01Uoo`05001oogooOol0003eOol0065o
o`03001oogoo01=oo`03001oogoo04Ioo`03001oogoo01Uoo`05001oogooOol0003eOol0069oo`03
001oogoo019oo`03001oogoo04Ioo`03001oogoo01Uoo`05001oogooOol0003eOol006=oo`03001o
ogoo011oo`03001oogoo04Moo`03001oogoo01Uoo`05001oogooOol0003eOol006=oo`80015oo`03
001oogoo03ioo`<000Ioo`03001oogoo01Uoo`05001oogooOol0003eOol006Aoo`03001oogoo00io
o`03001oogoo041oo`03001oogoo00Eoo`03001oogoo01Uoo`05001oogooOol0003eOol006Aoo`03
001oogoo00ioo`03001oogoo041oo`03001oogoo00Eoo`03001oogoo01Uoo`05001oogooOol0003e
Ool006Eoo`03001oogoo00aoo`03001oogoo03eoo`H000Ioo`03001oogoo01Uoo`05001oogooOol0
003eOol006Eoo`03001oogoo00aoo`03001oogoo03eoo`05001oogooOol00007Ool4000HOol01@00
Oomoogoo0000mGoo001VOol00`00Oomoo`0:Ool00`00Oomoo`0oOol01000Oomoo`001goo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00IWoo00<007ooOol02Woo00<007ooOol0@7oo00<007oo0000
1goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00IWoo0P002Woo00<007ooOol0@Goo00<007oo
00001goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00J7oo00<007ooOol01Woo00<007ooOol0
@goo0P001goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00JGoo00<007ooOol01Goo00<007oo
Ool0A7oo00<007ooOol01Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00JWoo00H007ooOomo
o`00Ool2001>Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001ZOol400000goo0000001?Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo002eOol40007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol0
0`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00
Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomo
o`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol20003Ool00`00
Oomoo`04Ool4000HOol01@00Oomoogoo0000mGoo002dOol00`00Ool000020007Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo002dOol00`00Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo002dOol00`00Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002eOol00`00Oomo
o`08Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002fOol30007Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo002eOol40007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02
Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool0
0`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00
Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00Oomo
o`04Ool4000HOol5003eOol00;Eoo`@000Moo`03001oogoo0?mooaAoo`00]7oo00<007ooOol00Woo
00<007ooOol017oo00<007ooOol0ogoo57oo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00
Oomoo`3oOolDOol00;Aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0?mooaAoo`00]Goo
10001goo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAo
o`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAo
o`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00`7oo
00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo
00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo
00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo
00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo
00<007ooOol0ogoo57oo0030Ool3003oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007oo
Ool0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007oo
Ool0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007oo
Ool0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007oo
Ool0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00`7oo00<007ooOol0ogoo
57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo
57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo
57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00[7oo1@0017oo10001goo
00<007ooOol0ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00
Oomoo`3oOolDOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo
0?mooaAoo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0ogoo
57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool4003oOolCOol00:ioo`03
001oogoo00=oo`03001oogoo009oo`03001oogoo0?mooa]oo`00[Woo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol0ogoo6goo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`3o
OolKOol00:aoo`<000Eoo`03001oogoo009oo`03001oogoo0?mooa]oo`00\
\>"],
  ImageRangeCache->{{{0, 469}, {289.313, 0}} -> {-13.8869, -0.535215, 
  0.0720124, 0.03699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .00457 m
.02598 .00272 L
.02648 .0022 L
.02702 .00166 L
.02753 .00126 L
.028 .00109 L
.02856 .00125 L
.02916 .00168 L
.03022 .00252 L
.03076 .00289 L
.03134 .00322 L
.03168 .00337 L
.03199 .00347 L
.03259 .00361 L
.03316 .00365 L
.03376 .0036 L
.03434 .00348 L
.03485 .00331 L
.03547 .00304 L
.03613 .00269 L
.03733 .00194 L
.03847 .00118 L
.0391 .00078 L
.03968 .00045 L
.04018 .00034 L
.04071 .00051 L
.0413 .00083 L
.04184 .00113 L
.04306 .00179 L
.04435 .00239 L
.04546 .00278 L
.04576 .00286 L
.04609 .00293 L
.04668 .00303 L
.04701 .00307 L
.04731 .00309 L
.04765 .0031 L
.04801 .00309 L
.04839 .00306 L
.04875 .00301 L
.04907 .00296 L
.04942 .00289 L
.05062 .00259 L
.05125 .00241 L
.0516 .00232 L
.05194 .00224 L
.05225 .00218 L
.05259 .00214 L
.05319 .00213 L
.05379 .00222 L
Mistroke
.05435 .00238 L
.05469 .00251 L
.055 .00265 L
.05559 .00295 L
.05691 .00367 L
.05799 .00422 L
.05857 .00447 L
.05912 .00466 L
.05971 .0048 L
.06003 .00485 L
.06036 .00488 L
.06096 .00487 L
.0615 .00479 L
.06205 .00465 L
.06257 .00446 L
.06375 .00392 L
.06431 .00366 L
.0649 .00344 L
.06521 .00337 L
.06555 .00333 L
.06614 .00339 L
.0667 .0036 L
.06722 .0039 L
.06836 .00476 L
.06937 .00549 L
.06991 .00582 L
.07043 .00605 L
.07102 .00621 L
.07134 .00624 L
.07167 .00624 L
.07227 .00612 L
.07282 .0059 L
.07315 .00572 L
.07346 .00552 L
.07415 .00498 L
.0748 .0044 L
.07542 .00386 L
.07594 .00348 L
.0765 .00323 L
.0768 .00319 L
.07712 .00323 L
.0777 .0035 L
.0783 .00396 L
.07885 .00448 L
.07947 .00505 L
.08012 .00559 L
.0807 .00598 L
.08103 .00615 L
.08134 .00627 L
.08189 .00638 L
Mistroke
.08247 .00636 L
.0828 .00629 L
.08316 .00616 L
.08349 .00599 L
.08381 .00579 L
.08502 .00473 L
.08618 .00349 L
.08675 .00294 L
.08727 .00258 L
.08787 .00244 L
.08819 .00251 L
.08852 .00268 L
.08906 .00309 L
.08966 .00364 L
.09077 .00464 L
.09132 .00504 L
.09182 .00534 L
.0924 .00557 L
.09271 .00564 L
.09304 .00569 L
.09356 .00568 L
.09414 .00555 L
.09468 .00534 L
.09518 .00506 L
.0963 .00422 L
.09734 .0033 L
.09786 .00289 L
.09833 .00258 L
.09888 .00238 L
.09949 .00243 L
.1 .00267 L
.10054 .00306 L
.10176 .00411 L
.10236 .00459 L
.10291 .00498 L
.10337 .00525 L
.10388 .00549 L
.10442 .00565 L
.10494 .00573 L
.1055 .00573 L
.10609 .00563 L
.10666 .00545 L
.10717 .00524 L
.10833 .00465 L
.10897 .00434 L
.10956 .00412 L
.10987 .00405 L
.1102 .00401 L
.11057 .00403 L
.11091 .00409 L
Mistroke
.11121 .00418 L
.11154 .00432 L
.11214 .00464 L
.11331 .00541 L
.11395 .00584 L
.11456 .0062 L
.11513 .00648 L
.11543 .0066 L
.11575 .00671 L
.11631 .00686 L
.11683 .00693 L
.1174 .00694 L
.11772 .00692 L
.11802 .00688 L
.11856 .00677 L
.11914 .00661 L
.12015 .00627 L
.1207 .0061 L
.12123 .00598 L
.12153 .00594 L
.12186 .00593 L
.12243 .00599 L
.12301 .00618 L
.12354 .00645 L
.12413 .00685 L
.12477 .00737 L
.12608 .00846 L
.1267 .0089 L
.12704 .0091 L
.12735 .00926 L
.12791 .00945 L
.12852 .00954 L
.12886 .00953 L
.12918 .00949 L
.12978 .00932 L
.13012 .0092 L
.13044 .00907 L
.13078 .00893 L
.13114 .00879 L
.13171 .00865 L
.13224 .00866 L
.13256 .00874 L
.13287 .00889 L
.13345 .00936 L
.13406 .01007 L
.13462 .01088 L
.13589 .01291 L
.13696 .01439 L
.13756 .015 L
.1381 .0154 L
Mistroke
.13861 .01563 L
.13916 .01573 L
.13969 .01572 L
.14017 .01565 L
.14066 .01558 L
.14121 .01555 L
.14178 .01568 L
.14232 .016 L
.14291 .01665 L
.14346 .0175 L
.14468 .02014 L
.14963 .02817 L
.15021 .02841 L
.15077 .02865 L
.15107 .02882 L
.1514 .02905 L
.15198 .02963 L
.15254 .03043 L
.15312 .03156 L
.15417 .03425 L
.1565 .04132 L
.15772 .04433 L
.15841 .04565 L
.15905 .04664 L
.16043 .04834 L
.1611 .04919 L
.16173 .05014 L
.1629 .05254 L
.16418 .05622 L
.16872 .07085 L
.1736 .08237 L
.18229 .11139 L
.1919 .14559 L
.20167 .18011 L
.21064 .20847 L
.21998 .23278 L
.22867 .24908 L
.23086 .25446 L
.23194 .25686 L
.23293 .25853 L
.23349 .25919 L
.23408 .25969 L
.23467 .26002 L
.235 .26014 L
.23532 .26022 L
.23636 .26038 L
.23691 .26047 L
.23749 .26063 L
.23783 .26075 L
.23814 .2609 L
Mistroke
.23873 .26126 L
.23992 .26226 L
.24214 .26452 L
.24274 .26502 L
.24338 .26542 L
.24371 .26558 L
.24408 .2657 L
.24441 .26576 L
.24472 .26578 L
.24533 .2657 L
.24589 .2655 L
.2462 .26534 L
.24653 .26513 L
.24714 .26468 L
.24944 .26263 L
.25006 .26213 L
.25072 .26169 L
.25129 .26141 L
.25191 .26118 L
.25302 .26097 L
.25356 .2609 L
.25407 .26082 L
.25465 .26066 L
.25495 .26053 L
.25528 .26036 L
.2558 .25998 L
.25637 .25939 L
.25698 .25856 L
.25762 .25743 L
.25879 .2549 L
.26104 .24963 L
.2617 .24838 L
.26241 .24729 L
.26309 .24651 L
.26372 .24595 L
.26435 .24548 L
.265 .24497 L
.26556 .24444 L
.26618 .24367 L
.26677 .24267 L
.26741 .24128 L
.26856 .23796 L
.26988 .23327 L
.27113 .22881 L
.27229 .22536 L
.27295 .22387 L
.27356 .22277 L
.2747 .22118 L
.27578 .21975 L
.27674 .218 L
Mistroke
.27729 .2167 L
.27778 .21527 L
.27999 .20664 L
.28447 .19152 L
.30299 .13078 L
.3208 .07948 L
.33074 .05514 L
.33543 .04621 L
.33643 .0429 L
.33749 .03965 L
.3381 .03815 L
.33866 .0371 L
.33922 .03638 L
.33975 .03598 L
.3403 .0358 L
.3408 .03578 L
.34136 .03583 L
.34195 .03587 L
.34252 .0358 L
.34305 .03557 L
.34363 .03509 L
.34396 .0347 L
.34427 .03426 L
.3454 .03201 L
.34664 .02874 L
.34796 .02521 L
.34853 .02393 L
.34883 .02336 L
.34915 .02284 L
.34974 .02216 L
.35029 .02184 L
.3508 .02177 L
.35137 .02189 L
.35196 .02213 L
.35228 .02227 L
.35259 .0224 L
.35319 .02258 L
.35373 .02261 L
.35425 .02248 L
.35479 .02217 L
.35531 .02169 L
.35578 .02112 L
.35692 .01923 L
.358 .01708 L
.35905 .01504 L
.35963 .0141 L
.36018 .01338 L
.36049 .01307 L
.36083 .01282 L
.36141 .01256 L
Mistroke
.36201 .01251 L
.36257 .01261 L
.36314 .01278 L
.36368 .01297 L
.36427 .01313 L
.3646 .01319 L
.3649 .01321 L
.36548 .01317 L
.36581 .0131 L
.36611 .01299 L
.36673 .01267 L
.36707 .01243 L
.36738 .01218 L
.37601 .00602 L
.37656 .00621 L
.37709 .00637 L
.3777 .00649 L
.37826 .00653 L
.37878 .00649 L
.37926 .00639 L
.3798 .0062 L
.38036 .00591 L
.38096 .00551 L
.38151 .00506 L
.38256 .00404 L
.38497 .00132 L
.38559 .00065 L
.3859 .00034 L
.38624 .00015 L
.38684 .00064 L
.3874 .00112 L
.39002 .00304 L
.39227 .00447 L
.39292 .00482 L
.39353 .00508 L
.39408 .00524 L
.39468 .00532 L
.39524 .00529 L
.39586 .00511 L
.39644 .00481 L
.39698 .0044 L
.39761 .00377 L
.39827 .00293 L
.39946 .00108 L
.40004 .00023 L
.40036 .00063 L
.40067 .00118 L
.4018 .00332 L
.40291 .0052 L
.40393 .00659 L
Mistroke
.40446 .00711 L
.40502 .0075 L
.40534 .00764 L
.40564 .00771 L
.4062 .0077 L
.4068 .00746 L
.40735 .00705 L
.40796 .00639 L
.4086 .00549 L
.40978 .00346 L
.4104 .00238 L
.41071 .00194 L
.41105 .00167 L
.41142 .00176 L
.41177 .00217 L
.4121 .00269 L
.41244 .00331 L
.41375 .00563 L
.41437 .00654 L
.41495 .00722 L
.41556 .00772 L
.41589 .00789 L
.41623 .00801 L
.41685 .00803 L
.41743 .00784 L
.41795 .0075 L
.41853 .00696 L
.41982 .00525 L
.42104 .00337 L
.42136 .00292 L
.42171 .00254 L
.42209 .00228 L
.42244 .00225 L
.42304 .00263 L
.42339 .003 L
.42371 .00339 L
.42492 .00488 L
.42551 .00549 L
.42606 .00594 L
.42636 .00613 L
.4267 .0063 L
.42703 .00643 L
.42738 .00651 L
.42768 .00653 L
.428 .00652 L
.42859 .00639 L
.42914 .00616 L
.42974 .00579 L
.43095 .00475 L
.43207 .00357 L
Mistroke
.43311 .00247 L
.43369 .00195 L
.4343 .00162 L
.43491 .00164 L
.43526 .00179 L
.43558 .002 L
.4368 .00298 L
.43792 .00384 L
.43843 .00418 L
.439 .00449 L
.43953 .00472 L
.44002 .00487 L
.44054 .00497 L
.44111 .005 L
.44171 .00494 L
.44228 .0048 L
.44285 .00458 L
.44347 .00425 L
.44473 .00331 L
.4459 .00217 L
.44698 .00093 L
.4473 .00056 L
.44764 .00028 L
.44797 .00046 L
.44827 .00081 L
.44944 .00232 L
.45081 .004 L
.45141 .00465 L
.45206 .00526 L
.45257 .00565 L
.45304 .00594 L
.4535 .00614 L
.45398 .00626 L
.45454 .00628 L
.45506 .00617 L
.45553 .00597 L
.45604 .00563 L
.45649 .00523 L
.45699 .0047 L
.45798 .00331 L
.4589 .00177 L
.45935 .00098 L
.45977 .00051 L
.4603 .00116 L
.46088 .00227 L
.46189 .00419 L
.46297 .00596 L
.46354 .00672 L
.46384 .00705 L
.46416 .00735 L
Mistroke
.46469 .00771 L
.46518 .0079 L
.46564 .00793 L
.46614 .00781 L
.46667 .0075 L
.46724 .00698 L
.46777 .00631 L
.46825 .00557 L
Mfstroke
.46825 .00557 m
.46864 .00497 L
.46906 .00439 L
.46946 .0039 L
.46984 .00349 L
.47024 .0031 L
.47063 .00277 L
.47105 .00245 L
.47145 .00219 L
.47183 .00196 L
.47224 .00174 L
.47263 .00155 L
.47301 .00139 L
.47341 .00124 L
.4738 .00111 L
.47421 .00099 L
.47461 .00089 L
.47499 .0008 L
.4754 .00072 L
.47579 .00065 L
.47621 .00059 L
.47661 .00055 L
.47699 .00052 L
.47719 .00051 L
.47729 .0005 L
.4774 .0005 L
.4775 .00049 L
.47758 .00049 L
.47763 .00049 L
.47766 .00049 L
.47768 .00049 L
.47771 .00049 L
.47772 .00049 L
.47773 .00049 L
.47774 .00049 L
.47775 .00049 L
.47777 .00049 L
.47778 .00049 L
s
.47778 .00049 m
.47839 .00049 L
.47895 .00049 L
.4796 .00049 L
.48021 .00049 L
.48077 .00049 L
.4813 .00049 L
.48248 .00048 L
.48366 .00047 L
.48497 .00046 L
.48762 .00044 L
.49298 .00037 L
.498 .00028 L
.50344 .00017 L
.50613 .00011 L
.50862 6e-005 L
.50933 5e-005 L
.51 4e-005 L
.51037 4e-005 L
.51077 4e-005 L
.51114 4e-005 L
.51147 4e-005 L
.51185 4e-005 L
.5122 5e-005 L
.51299 6e-005 L
.51459 9e-005 L
.52005 .0002 L
.52552 .00029 L
.52821 .00032 L
.5307 .00035 L
.53295 .00037 L
.53535 .00039 L
.53659 .00039 L
.53775 .0004 L
.53842 .0004 L
.53903 .0004 L
.5397 .0004 L
.54004 .0004 L
.54041 .0004 L
.5411 .0004 L
.54174 .0004 L
.54207 .0004 L
.54244 .0004 L
.54318 .0004 L
.54383 .0004 L
.54452 .00039 L
.54579 .00039 L
.54834 .00037 L
.55067 .00035 L
.5563 .00029 L
Mistroke
.56164 .00021 L
.56667 .00013 L
.56943 8e-005 L
.57078 5e-005 L
.57137 4e-005 L
.57202 4e-005 L
.57263 3e-005 L
.5732 2e-005 L
.57381 3e-005 L
.57445 3e-005 L
.57479 3e-005 L
.57516 4e-005 L
.57582 5e-005 L
.57708 7e-005 L
.58165 .00015 L
.587 .00022 L
.59202 .00028 L
.59454 .0003 L
.59725 .00032 L
.59872 .00033 L
.59952 .00033 L
.60026 .00033 L
.60096 .00034 L
.60158 .00034 L
.60228 .00034 L
.60266 .00034 L
.60302 .00034 L
.60363 .00034 L
.60428 .00034 L
.60489 .00034 L
.60545 .00034 L
.60611 .00034 L
.60682 .00034 L
.60812 .00033 L
.60948 .00033 L
.61092 .00032 L
.61352 .0003 L
.61811 .00026 L
.62318 .0002 L
.6281 .00013 L
.63329 6e-005 L
.6346 4e-005 L
.63533 3e-005 L
.63601 2e-005 L
.63639 2e-005 L
.63681 2e-005 L
.6372 2e-005 L
.63755 2e-005 L
.63824 3e-005 L
.63898 4e-005 L
Mistroke
.6442 .00012 L
.64913 .00018 L
.65443 .00024 L
.657 .00026 L
.65944 .00027 L
.66163 .00028 L
.66286 .00029 L
.66401 .00029 L
.66469 .00029 L
.6654 .0003 L
.66601 .0003 L
.66667 .0003 L
.66705 .0003 L
.66739 .0003 L
.66779 .0003 L
.66816 .0003 L
.66883 .0003 L
.6692 .0003 L
.66955 .0003 L
.67075 .00029 L
.67143 .00029 L
.67208 .00029 L
.67476 .00028 L
.67721 .00026 L
.67945 .00025 L
.6845 .0002 L
.69441 8e-005 L
.69713 4e-005 L
.69784 3e-005 L
.69862 2e-005 L
.69898 2e-005 L
.69935 2e-005 L
.70003 1e-005 L
.7007 1e-005 L
.70133 2e-005 L
.70276 4e-005 L
.70525 7e-005 L
.7107 .00014 L
.71587 .00019 L
.72052 .00023 L
.72314 .00024 L
.72558 .00025 L
.72697 .00026 L
.72825 .00026 L
.72891 .00026 L
.72965 .00026 L
.73002 .00026 L
.73041 .00026 L
.73079 .00027 L
.73113 .00027 L
Mistroke
.7318 .00027 L
.73241 .00026 L
.73309 .00026 L
.73343 .00026 L
.73381 .00026 L
.73512 .00026 L
.73635 .00026 L
.7388 .00025 L
.74104 .00024 L
.74609 .0002 L
.75131 .00015 L
.75686 9e-005 L
.75956 5e-005 L
.76089 4e-005 L
.76211 2e-005 L
.76268 2e-005 L
.76322 1e-005 L
.76378 1e-005 L
.76439 1e-005 L
.76502 2e-005 L
.76559 2e-005 L
.76687 4e-005 L
.7719 .0001 L
.77724 .00015 L
.78181 .00019 L
.78444 .00021 L
.78685 .00022 L
.78933 .00023 L
.79063 .00024 L
.79129 .00024 L
.792 .00024 L
.79262 .00024 L
.79319 .00024 L
.79376 .00024 L
.7943 .00024 L
.79494 .00024 L
.79552 .00024 L
.79616 .00024 L
.79683 .00024 L
.7975 .00024 L
.79812 .00024 L
.7995 .00024 L
.80079 .00023 L
.802 .00023 L
.80473 .00022 L
.80769 .0002 L
.81887 .0001 L
.82143 7e-005 L
.82414 4e-005 L
.82526 3e-005 L
Mistroke
.82645 1e-005 L
.82714 1e-005 L
.82776 1e-005 L
.82839 1e-005 L
.82899 2e-005 L
.83406 7e-005 L
.83955 .00013 L
.84427 .00017 L
.84696 .00019 L
.84948 .0002 L
.85192 .00021 L
.85318 .00021 L
.85455 .00022 L
.85591 .00022 L
.85666 .00022 L
.85702 .00022 L
.85735 .00022 L
.858 .00022 L
.85859 .00022 L
.85923 .00022 L
.85992 .00022 L
.86052 .00022 L
.86108 .00022 L
.8617 .00022 L
.86236 .00022 L
.86371 .00022 L
.86494 .00021 L
.86731 .00021 L
.86956 .0002 L
.87461 .00016 L
.87997 .00012 L
.88499 7e-005 L
.88719 5e-005 L
.88844 3e-005 L
.8896 2e-005 L
.89019 1e-005 L
.89075 1e-005 L
.8914 1e-005 L
.89198 1e-005 L
.89261 1e-005 L
.89319 2e-005 L
.89449 3e-005 L
.89977 9e-005 L
.90438 .00013 L
.90933 .00016 L
.91198 .00018 L
.91439 .00019 L
.91556 .0002 L
.91683 .0002 L
.91802 .0002 L
Mistroke
.91914 .00021 L
.91982 .00021 L
.92056 .00021 L
.92123 .00021 L
.92185 .00021 L
.92252 .00021 L
.9229 .00021 L
.92325 .00021 L
.92363 .00021 L
.92397 .00021 L
.92436 .00021 L
.92473 .00021 L
.92536 .00021 L
.92603 .00021 L
.92722 .00021 L
.92851 .0002 L
.92993 .0002 L
.93251 .00019 L
.93521 .00017 L
.94006 .00014 L
.94534 .0001 L
.94824 7e-005 L
.95097 4e-005 L
.95357 2e-005 L
.95429 1e-005 L
.95467 1e-005 L
.95504 1e-005 L
.95568 0 L
.95602 1e-005 L
.95639 1e-005 L
.96131 6e-005 L
.97092 .00014 L
.97619 .00017 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0?moomMoo`003gooo`00^00047oo000JOol200000goo000000020002Ool60002Ool30002Ool30002
Ool30002Ool30002Ool20002Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00
Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00
Oomoo`02Ool01000Oomoo`000Woo10000Woo0P000Woo0`000Woo10000Woo00<007oo00000goo0P00
0Woo0`0000=oo`00Ool027oo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007oo
Ool02goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007oo
Ool02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007oo
Ool02Woo00<007ooOol02goo00<007ooOol06Goo000JOol00`00Oomoo`0<Ool300000goo00000002
00000goo00000002000017oo000000000Woo1`0000=oo`000000=Goo00<007ooOol0=Woo0`0017oo
0`000Woo00D007oo001oo`00009oo`03001oo`0000<0009oo`<000=oo`<0009oo`03001oo`0000=o
o`03001oogoo02=oo`03001oogoo049oo`03001oogoo04=oo`03001oogoo049oo`00@Woo0P000Woo
00@007ooOol006Uoo`03001oo`0000Yoo`8000=oo`8000=oo`8000ioo`<000=oo`03001oogoo0?=o
o`00Agoo1000IWoo0P003Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Bgoo00<007ooOol0
Ggoo10003goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Bgoo0`00GWoo0P004Woo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00C7oo0`00GGoo00<007ooOol04Goo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00Cgoo00<007ooOol0FGoo00<007ooOol04Woo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00D7oo00<007ooOol0EGoo100057oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00D7oo00<007ooOol0EGoo00<007oo00005Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
DGoo00<007ooOol0Dgoo00<007ooOol05Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00DGoo
0P00E7oo00<007ooOol05Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00DWoo00<007ooOol0
DGoo00<007ooOol05goo0`006Goo00D007ooOomoo`000?Eoo`00Dgoo00<007ooOol0D7oo00<007oo
Ool05goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Dgoo00<007ooOol0CWoo0`006Goo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00Dgoo00<007ooOol0CGoo0P006goo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00E7oo00<007ooOol0C7oo00<007ooOol06Woo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00E7oo00<007ooOol0Bgoo00<007ooOol06goo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00E7oo00<007ooOol0Bgoo00<007ooOol06goo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00EGoo00<007ooOol0BWoo00<007ooOol06goo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00EGoo0P00BWoo00<007ooOol077oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00EWoo
00<007ooOol0B7oo00<007ooOol077oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Egoo00<0
07ooOol0AWoo00<007ooOol07Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Egoo00<007oo
Ool0AWoo00<007ooOol07Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Egoo00<007ooOol0
AWoo00<007ooOol07Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00F7oo00<007ooOol0A7oo
00<007ooOol07Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00F7oo00<007ooOol0A7oo00<0
07ooOol07Woo0`006Goo00D007ooOomoo`000?Eoo`00F7oo00<007ooOol0@goo00<007ooOol07goo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00F7oo00<007ooOol0@goo00<007ooOol07goo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00FGoo00<007ooOol0@Woo00<007ooOol07goo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00FGoo00<007ooOol0@Goo00<007ooOol087oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00FGoo00<007ooOol0@Goo00<007ooOol087oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00FWoo00<007ooOol0?goo00<007ooOol08Goo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00FWoo00<007ooOol0?goo00<007ooOol08Goo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00Fgoo00<007ooOol0?Woo00<007ooOol08Goo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00Fgoo00<007ooOol0?Goo00<007ooOol08Woo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00Fgoo00<007ooOol0?Goo00<007ooOol08Woo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00G7oo00<007ooOol0?7oo00<007ooOol08Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
G7oo00<007ooOol0>goo00<007ooOol08goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00G7oo
00<007ooOol0>goo00<007ooOol08goo0`006Goo00D007ooOomoo`000?Eoo`00GGoo00<007ooOol0
>Woo00<007ooOol08goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00GGoo00<007ooOol0>Goo
00<007ooOol097oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00GGoo00<007ooOol0>Goo00<0
07ooOol097oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00GWoo00<007ooOol0>7oo00<007oo
Ool097oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00GWoo00<007ooOol0=goo00<007ooOol0
9Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00GWoo00<007ooOol0=goo00<007ooOol09Goo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Ggoo00<007ooOol0=Goo00<007ooOol09Woo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00Ggoo00<007ooOol0=Goo00<007ooOol09Woo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00Ggoo00<007ooOol0=Goo00<007ooOol09Woo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00H7oo00<007ooOol0<goo00<007ooOol06goo1P001Woo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00H7oo00<007ooOol0<goo00<007ooOol06goo00<007ooOol0
2Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00H7oo00<007ooOol0<goo00<007ooOol077oo
00<007ooOol027oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00H7oo00<007ooOol0<Woo00<0
07ooOol07Woo00<007ooOol01goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00HGoo00<007oo
Ool0<Goo00<007ooOol07goo00<007ooOol01Woo100067oo00D007ooOomoo`000?Eoo`00HGoo00<0
07ooOol0<Goo00<007ooOol087oo00<007ooOol01Goo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00HGoo00<007ooOol0<7oo00<007ooOol08Woo00<007ooOol017oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00HGoo00<007ooOol0<7oo00<007ooOol08Woo00<007ooOol017oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00HWoo00<007ooOol0;goo00<007ooOol07Goo00<007ooOol00Woo
00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00HWoo00<007ooOol0;Woo00<0
07ooOol07goo10001goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00HWoo00<007ooOol0;Woo
00<007ooOol0:Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00HWoo00<007ooOol0;Woo00<0
07ooOol0:Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Hgoo00<007ooOol0;7oo00<007oo
Ool0:goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Hgoo00<007ooOol0;7oo00<007ooOol0
:goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Hgoo00<007ooOol0;7oo00<007ooOol0:goo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00I7oo00<007ooOol0:goo00<007ooOol0:goo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00I7oo00<007ooOol0:Woo00<007ooOol0;7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00I7oo00<007ooOol0:Woo00<007ooOol0;7oo0`006Goo00D0
07ooOomoo`000?Eoo`00IGoo00<007ooOol0:Goo00<007ooOol0;7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00IGoo00<007ooOol0:7oo00<007ooOol0;Goo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00IGoo00<007ooOol0:7oo00<007ooOol0;Goo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00IWoo00<007ooOol09goo00<007ooOol0;Goo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00IWoo00<007ooOol09Woo00<007ooOol0;Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
IWoo00<007ooOol09Woo00<007ooOol0;Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Igoo
00<007ooOol09Goo00<007ooOol0;Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Igoo00<0
07ooOol097oo00<007ooOol0;goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Igoo00<007oo
Ool097oo00<007ooOol0;goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00J7oo00<007ooOol0
8goo00<007ooOol0;goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00J7oo00<007ooOol08goo
00<007ooOol0;goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00J7oo00<007ooOol08Woo00<0
07ooOol0<7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00J7oo00<007ooOol08Woo00<007oo
Ool0<7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00JGoo00<007ooOol08Goo00<007ooOol0
<7oo0`006Goo00D007ooOomoo`000?Eoo`00JGoo00<007ooOol087oo00<007ooOol0<Goo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00JGoo00<007ooOol087oo00<007ooOol0<Goo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00JGoo00<007ooOol087oo00<007ooOol0<Goo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00JWoo00<007ooOol07Woo00<007ooOol0<Woo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00JWoo00<007ooOol07Woo00<007ooOol0<Woo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00JWoo00<007ooOol07Woo00<007ooOol0<Woo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00JWoo00<007ooOol07Woo00<007ooOol0<Woo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00Jgoo00<007ooOol077oo00<007ooOol0<goo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00Jgoo00<007ooOol077oo00<007ooOol0<goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
Jgoo00<007ooOol077oo00<007ooOol0<goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00K7oo
00<007ooOol06Woo00<007ooOol0=7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00K7oo00<0
07ooOol06Woo00<007ooOol0=7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00KGoo00<007oo
Ool06Goo00<007ooOol0=7oo0`006Goo00D007ooOomoo`000?Eoo`00KGoo00<007ooOol067oo00<0
07ooOol0=Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00KWoo00<007ooOol05Woo0P00=goo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00KWoo00<007ooOol05Woo00<007ooOol0=Woo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00Kgoo00<007ooOol057oo0P00>7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00Kgoo00<007ooOol057oo00<007ooOol0=goo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00L7oo00<007ooOol04goo00<007ooOol0=goo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00L7oo00<007ooOol04Woo00<007ooOol0>7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00L7oo00<007ooOol04Woo00<007ooOol0>7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00LGoo00<007ooOol04Goo00<007ooOol0>7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00LGoo00<007ooOol04Goo00<007ooOol0;goo0`001Woo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00LWoo00<007ooOol03goo00<007ooOol0<Goo00<007ooOol01Goo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00LWoo00<007ooOol03goo00<007ooOol0<Goo00<007ooOol01Goo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00LWoo00<007ooOol03Goo0P00<7oo1P001Woo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00Lgoo00<007ooOol037oo00<007ooOol0;goo00D007ooOomoo`00
00Moo`@001Qoo`05001oogooOol0003eOol007=oo`03001oogoo00]oo`03001oogoo035oo`04001o
ogoo0007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001dOol00`00Oomoo`09Ool00`00Oomo
o`0cOol00`00Ool00007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001dOol00`00Oomoo`09
Ool00`00Oomoo`0cOol00`00Ool00007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001eOol0
0`00Oomoo`08Ool00`00Oomoo`0dOol20007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001e
Ool20008Ool2000gOol00`00Oomoo`05Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001gOol2
0004Ool30010Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001iOol01000Ool00000@goo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00NGoo0`00A7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00`7oo0`006Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo0`00
6Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
0`006Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00]Goo10001goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
]7oo00<007ooOol00Woo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo
00<007ooOol00Woo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<0
07ooOol00Woo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo0P000goo
00<007ooOol017oo100067oo00D007ooOomoo`000?Eoo`00]7oo00<007oo00000P001goo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol02Goo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00]7oo00<007ooOol02Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]Goo00<0
07ooOol027oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]Woo0`001goo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00`7oo0`006Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo0`006Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo0`006Goo00D0
07ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00]Goo10001goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007oo
Ool00Woo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol0
0Woo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol00Woo
00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol00Woo00<0
07ooOol017oo100067oo1@00mGoo002eOol40007Ool00`00Oomoo`3oOolDOol00;Aoo`03001oogoo
009oo`03001oogoo00Aoo`03001oogoo0?mooaAoo`00]7oo00<007ooOol00Woo00<007ooOol017oo
00<007ooOol0ogoo57oo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`3oOolDOol0
0;Eoo`@000Moo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3o
OolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3o
OolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool3003oOolDOol0
0<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol0
0<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol0
0<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol0
0<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol0
0<1oo`03001oogoo0?mooaAoo`00`7oo0`00ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03
001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03
001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03
001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03
001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool3003oOolDOol00<1oo`03001oogoo
0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo
0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo
0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00:aoo`D000Aoo`@0
00Moo`03001oogoo0?mooaAoo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo
00<007ooOol0ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00
Oomoo`3oOolDOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo
0?mooaAoo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo1000ogoo4goo002^
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`3oOolKOol00:ioo`03001oogoo00=oo`03
001oogoo009oo`03001oogoo0?mooa]oo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007oo
Ool0ogoo6goo002/Ool30005Ool00`00Oomoo`02Ool00`00Oomoo`3oOolKOol00001\
\>"],
  ImageRangeCache->{{{0, 469}, {289.313, 0}} -> {-13.8869, -0.535215, 
  0.0720124, 0.03699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .00333 m
.02436 .00339 L
.02486 .00341 L
.02543 .00338 L
.02598 .00331 L
.02648 .0032 L
.02695 .00308 L
.028 .00272 L
.02851 .00252 L
.02906 .00234 L
.02966 .0022 L
.03023 .00218 L
.03053 .00221 L
.03086 .0023 L
.03146 .00255 L
.03204 .00289 L
.03259 .00325 L
.0338 .00405 L
.03439 .00438 L
.03494 .00462 L
.03543 .00478 L
.03596 .00487 L
.03649 .00488 L
.03706 .00479 L
.03739 .0047 L
.03769 .00458 L
.03826 .00428 L
.03953 .00337 L
.04007 .00295 L
.04064 .00257 L
.04093 .00243 L
.04126 .00233 L
.04184 .00237 L
.04243 .00267 L
.04277 .00292 L
.04308 .00318 L
.04439 .00435 L
.04497 .00479 L
.04551 .00512 L
.04582 .00526 L
.04615 .00537 L
.04672 .00547 L
.04705 .00546 L
.04735 .00542 L
.04769 .00533 L
.04805 .00518 L
.04843 .00497 L
.04879 .00473 L
.04946 .00416 L
.05068 .00289 L
Mistroke
.051 .00255 L
.05135 .00221 L
.05165 .00197 L
.05198 .00178 L
.0523 .00171 L
.05263 .00177 L
.05322 .00214 L
.0538 .00267 L
.05434 .0032 L
.05488 .00369 L
.05547 .00414 L
.05602 .00448 L
.05654 .00469 L
.05715 .00482 L
.05745 .00484 L
.05779 .00481 L
.05838 .00466 L
.05893 .00441 L
.05958 .004 L
.06017 .00352 L
.0615 .00222 L
.0621 .00159 L
.06267 .00105 L
.06317 .00072 L
.06372 .00077 L
.06432 .00119 L
.06495 .0017 L
.0655 .00211 L
.06609 .0025 L
.06664 .0028 L
.06714 .00301 L
.06764 .00317 L
.06812 .00326 L
.06867 .00332 L
.06919 .00331 L
.06975 .00325 L
.07035 .00313 L
.07095 .00296 L
.07149 .00277 L
.07272 .00222 L
.07387 .0016 L
.07494 .00102 L
.07551 .00077 L
.07612 .00068 L
.07647 .00074 L
.0768 .00087 L
.07741 .00119 L
.07876 .00202 L
.08002 .00273 L
.08106 .0032 L
Mistroke
.08164 .0034 L
.08217 .00354 L
.08276 .00364 L
.08309 .00368 L
.08339 .0037 L
.08395 .00369 L
.08455 .00364 L
.08487 .00359 L
.08517 .00353 L
.08584 .00337 L
.08706 .00303 L
.08764 .00287 L
.08817 .00276 L
.08873 .00271 L
.08935 .00275 L
.08988 .00287 L
.09046 .00309 L
.09101 .00337 L
.09152 .00367 L
.0935 .00488 L
.094 .00513 L
.09453 .00534 L
.09511 .0055 L
.09566 .00556 L
.09624 .00554 L
.09686 .00542 L
.09738 .00523 L
.09795 .00494 L
.09914 .0042 L
.09976 .00381 L
.1001 .00363 L
.10042 .00351 L
.101 .00342 L
.10131 .00346 L
.10164 .00356 L
.10222 .0039 L
.10275 .00432 L
.10382 .00527 L
.10439 .00574 L
.10499 .00616 L
.10557 .00646 L
.10609 .00662 L
.10662 .00667 L
.10711 .0066 L
.10768 .0064 L
.108 .00623 L
.10831 .00603 L
.10956 .0049 L
.11012 .00431 L
.11072 .0037 L
Mistroke
.11129 .00325 L
.11181 .00304 L
.11211 .00303 L
.11244 .00313 L
.11278 .00332 L
.1131 .00358 L
.11427 .00475 L
.11492 .00538 L
.11553 .00589 L
.11587 .00611 L
.11624 .0063 L
.11658 .00643 L
.11689 .0065 L
.11749 .00651 L
.11779 .00646 L
.11812 .00635 L
.11871 .00604 L
.11926 .00564 L
.12049 .00439 L
.12113 .00365 L
.12182 .00289 L
.12213 .00261 L
.12247 .00238 L
.12307 .00225 L
.12363 .00247 L
.12395 .00271 L
.12425 .00298 L
.12533 .00405 L
.12592 .00458 L
.12646 .005 L
.12697 .0053 L
.1275 .00553 L
.1281 .00567 L
.12864 .00567 L
.12914 .00558 L
.12967 .0054 L
.13018 .00513 L
.13064 .00483 L
.13185 .00383 L
.13244 .00329 L
.133 .00282 L
.13349 .00249 L
.13402 .00229 L
.13461 .00232 L
.13515 .00257 L
.13569 .00295 L
.13627 .00343 L
.13733 .00429 L
.13792 .0047 L
.13855 .00504 L
Mistroke
.13908 .00525 L
.13967 .00538 L
.14022 .00541 L
.14072 .00536 L
.14131 .00522 L
.14186 .00502 L
.1439 .00395 L
.1445 .00367 L
.14506 .0035 L
.14565 .00344 L
.14596 .00346 L
.1463 .00353 L
.14686 .00373 L
.14745 .00404 L
.14851 .00468 L
.14967 .00534 L
.15032 .00563 L
.15091 .00583 L
.15125 .00591 L
.15161 .00597 L
.15195 .00599 L
.15227 .00599 L
.15288 .00591 L
.15319 .00584 L
.15353 .00574 L
.1547 .00525 L
.15531 .00496 L
.15565 .00482 L
.15597 .00471 L
.15654 .00459 L
.15684 .00458 L
.15717 .00463 L
.15775 .00487 L
.15828 .00524 L
.16262 .00893 L
.16506 .0085 L
.1654 .00837 L
.16576 .00826 L
.16611 .00821 L
.16643 .00822 L
.16703 .00845 L
.16733 .00868 L
.16767 .00903 L
.16828 .00989 L
.16884 .01087 L
.1701 .01334 L
.17237 .01672 L
.18119 .02841 L
.19084 .04653 L
.20938 .09574 L
Mistroke
.2272 .15926 L
.23715 .19403 L
.24618 .2216 L
.25069 .23008 L
.25193 .23219 L
.25256 .23368 L
.25324 .23564 L
.25558 .24365 L
.25672 .24701 L
.25728 .2483 L
.25779 .24926 L
.25839 .25009 L
.2587 .25043 L
.25903 .25072 L
.25957 .25107 L
.26016 .25137 L
.26068 .25162 L
.26122 .25193 L
.26182 .2524 L
.26237 .25299 L
.26336 .25447 L
.26444 .25662 L
.26562 .25921 L
.26625 .26049 L
.26691 .26168 L
.26748 .26253 L
.26779 .2629 L
.26812 .26323 L
.2687 .26366 L
.26924 .26389 L
.2698 .26398 L
.2704 .26395 L
.27098 .26385 L
.27151 .26373 L
.27203 .26363 L
.27252 .26356 L
.27308 .26355 L
.27359 .26361 L
.27416 .26376 L
.27449 .26388 L
.27479 .26401 L
.27604 .26475 L
.2772 .26548 L
.27777 .26579 L
.27829 .266 L
.27891 .26613 L
.27923 .26614 L
.27958 .2661 L
.28013 .26593 L
.28075 .26558 L
Mistroke
.28109 .26531 L
.2814 .26501 L
.2821 .26421 L
.28337 .26242 L
.28802 .25778 L
.28861 .25762 L
.28924 .25744 L
.28957 .25731 L
.28993 .25711 L
.29026 .25689 L
.29057 .25662 L
.29117 .2559 L
.29173 .25502 L
.29297 .2522 L
.29537 .24511 L
.29595 .24357 L
.29655 .24215 L
.29712 .24108 L
.29765 .24028 L
.29811 .23973 L
.29861 .23926 L
.29968 .23843 L
.30024 .23792 L
.30083 .2372 L
.30134 .23638 L
.30189 .23521 L
.31112 .20949 L
.3197 .17943 L
.33791 .11851 L
.35727 .06602 L
.36697 .04537 L
.37591 .02814 L
.37645 .02844 L
.37703 .02869 L
.37757 .02877 L
.37808 .02866 L
.37867 .02826 L
.379 .02791 L
.3793 .0275 L
.37987 .02651 L
.38041 .02535 L
.38148 .02258 L
.38261 .01947 L
.38357 .01723 L
.38411 .01632 L
.38462 .01577 L
.38516 .01551 L
.38564 .01552 L
.3862 .01576 L
.38674 .01611 L
Mistroke
.38731 .01653 L
.38784 .01687 L
.3884 .01712 L
.38902 .0172 L
.3896 .01707 L
.38992 .0169 L
.39022 .01668 L
.39076 .01615 L
.39133 .01542 L
.39385 .01096 L
.39443 .00997 L
.39506 .00905 L
.39565 .00841 L
.39619 .00804 L
.39668 .00789 L
.39722 .00791 L
.39779 .00808 L
.39831 .00831 L
.39888 .00858 L
.39949 .00886 L
.40007 .00905 L
.40061 .00914 L
.40094 .00916 L
.40123 .00914 L
.40158 .00909 L
.4019 .009 L
.40246 .00876 L
.40308 .00839 L
.40522 .00626 L
.4064 .00473 L
.40751 .00325 L
.40802 .00266 L
.40855 .00216 L
.40914 .0019 L
.40968 .00197 L
.41016 .00224 L
.41062 .00259 L
.41165 .00341 L
.41222 .0038 L
.41277 .00411 L
.41326 .00432 L
.41379 .00447 L
.41437 .00455 L
.4147 .00456 L
.41499 .00455 L
.41556 .00449 L
.4161 .00439 L
.41864 .0038 L
.41976 .00357 L
.42035 .00341 L
Mistroke
.42098 .0032 L
.4216 .00292 L
.42217 .00261 L
.42328 .00189 L
.42388 .0016 L
.42421 .00155 L
.42453 .00162 L
.4251 .00201 L
.42571 .00269 L
.42701 .00443 L
.42772 .00535 L
.42838 .00609 L
.42894 .00661 L
.42954 .00701 L
.42989 .00715 L
.43021 .00723 L
.43082 .00721 L
.43135 .007 L
.43191 .0066 L
.43239 .0061 L
.43292 .0054 L
.43409 .00334 L
.43462 .00223 L
.43519 .00094 L
.4358 .00053 L
.43638 .0019 L
.43747 .00439 L
.43808 .00565 L
.43873 .00682 L
.43934 .0077 L
.43991 .00831 L
.44045 .00868 L
.44101 .00885 L
.44159 .00878 L
.44191 .00864 L
.44221 .00843 L
.44276 .0079 L
.44326 .00724 L
.44438 .00528 L
.44538 .00317 L
.44591 .00208 L
.44647 .00134 L
.44695 .00165 L
.44749 .00262 L
.44844 .00455 L
.44954 .00644 L
.45016 .00725 L
.45074 .00779 L
.45135 .00814 L
.45191 .00824 L
Mistroke
.45222 .00822 L
.45255 .00813 L
.45316 .00779 L
.45368 .00734 L
.45425 .0067 L
.45541 .00504 L
.45647 .00331 L
.457 .00251 L
.45748 .00194 L
.45809 .00171 L
.45841 .00187 L
.45875 .00219 L
.45991 .00364 L
.46056 .0044 L
.46125 .00511 L
.46191 .00562 L
.46252 .00596 L
.46303 .00615 L
.4636 .00624 L
.4642 .00621 L
.46475 .00607 L
.46507 .00595 L
.46538 .0058 L
.46594 .00545 L
.46722 .00435 L
.46825 .00321 L
Mfstroke
.46825 .00321 m
.46864 .00279 L
.46906 .00238 L
.46946 .00205 L
.46984 .00178 L
.47024 .00153 L
.47063 .00132 L
.47105 .00113 L
.47145 .00097 L
.47183 .00084 L
.47224 .00071 L
.47263 .00061 L
.47301 .00053 L
.47341 .00045 L
.4738 .00039 L
.47421 .00033 L
.47461 .00028 L
.47499 .00024 L
.4754 .00021 L
.47579 .00018 L
.47621 .00015 L
.47661 .00013 L
.47699 .00011 L
.4774 .0001 L
.47778 9e-005 L
s
.47778 9e-005 m
.47839 8e-005 L
.47895 6e-005 L
.4796 5e-005 L
.48021 5e-005 L
.48077 5e-005 L
.4813 5e-005 L
.48187 6e-005 L
.48248 7e-005 L
.48762 .00019 L
.49262 .00031 L
.498 .0004 L
.50083 .00044 L
.50341 .00046 L
.50466 .00047 L
.50602 .00048 L
.50664 .00048 L
.5073 .00049 L
.50792 .00049 L
.50849 .00049 L
.50884 .00049 L
.50921 .00049 L
.50961 .00049 L
.50998 .00049 L
.51064 .00049 L
.51101 .00049 L
.51135 .00049 L
.51174 .00049 L
.51211 .00049 L
.51294 .00048 L
.51367 .00048 L
.51444 .00048 L
.51711 .00046 L
.51862 .00044 L
.52005 .00043 L
.52519 .00036 L
.53061 .00026 L
.53568 .00015 L
.5379 .0001 L
.54029 6e-005 L
.54094 4e-005 L
.54163 3e-005 L
.54222 3e-005 L
.54286 3e-005 L
.54347 4e-005 L
.54412 5e-005 L
.54529 7e-005 L
.55063 .00017 L
.55561 .00026 L
.56024 .00033 L
Mistroke
.56281 .00035 L
.56554 .00038 L
.5671 .00039 L
.56787 .00039 L
.56857 .00039 L
.5692 .0004 L
.56989 .0004 L
.57059 .0004 L
.57097 .0004 L
.57132 .0004 L
.57197 .0004 L
.57234 .0004 L
.57269 .0004 L
.57331 .0004 L
.57398 .0004 L
.57457 .0004 L
.57513 .0004 L
.5764 .00039 L
.57777 .00039 L
.57902 .00038 L
.58184 .00036 L
.58433 .00033 L
.58698 .0003 L
.59176 .00024 L
.59741 .00014 L
.59988 .0001 L
.60129 7e-005 L
.6026 5e-005 L
.60386 3e-005 L
.60423 3e-005 L
.60457 2e-005 L
.60521 2e-005 L
.6059 2e-005 L
.60654 3e-005 L
.60798 5e-005 L
.61379 .00015 L
.61924 .00023 L
.6219 .00026 L
.62435 .00029 L
.62659 .0003 L
.62904 .00032 L
.63032 .00033 L
.63151 .00033 L
.63276 .00034 L
.63346 .00034 L
.6341 .00034 L
.63477 .00034 L
.63511 .00034 L
.63549 .00034 L
.63614 .00034 L
Mistroke
.63676 .00034 L
.63713 .00034 L
.63749 .00034 L
.63815 .00034 L
.63886 .00034 L
.63964 .00033 L
.64096 .00033 L
.64236 .00032 L
.64488 .00031 L
.64769 .00028 L
.65027 .00026 L
.65609 .00019 L
.66155 .00011 L
.66422 7e-005 L
.66665 3e-005 L
.66722 2e-005 L
.66782 2e-005 L
.66848 1e-005 L
.6691 2e-005 L
.66966 2e-005 L
.6702 3e-005 L
.67141 5e-005 L
.67651 .00012 L
.68178 .00019 L
.68465 .00022 L
.68733 .00025 L
.68997 .00027 L
.69238 .00028 L
.69375 .00029 L
.69505 .00029 L
.69571 .00029 L
.69641 .00029 L
.69678 .00029 L
.69719 .00029 L
.69753 .0003 L
.6979 .0003 L
.69854 .0003 L
.69916 .0003 L
.69976 .0003 L
.70031 .0003 L
.70097 .0003 L
.70157 .00029 L
.70226 .00029 L
.7029 .00029 L
.70408 .00029 L
.70515 .00028 L
.70758 .00027 L
.71005 .00026 L
.7127 .00023 L
.71746 .00019 L
Mistroke
.72309 .00012 L
.72829 5e-005 L
.72963 3e-005 L
.73088 2e-005 L
.73151 1e-005 L
.73219 1e-005 L
.73257 1e-005 L
.73294 2e-005 L
.73363 3e-005 L
.73943 .0001 L
.74453 .00016 L
.74733 .00019 L
.74997 .00021 L
.75258 .00023 L
.7554 .00025 L
.75665 .00025 L
.75797 .00026 L
.75909 .00026 L
.76033 .00026 L
.76097 .00026 L
.76159 .00026 L
.76213 .00026 L
.76273 .00026 L
.76338 .00026 L
.76407 .00026 L
.76466 .00026 L
.76531 .00026 L
.76591 .00026 L
.76646 .00026 L
.7677 .00026 L
.76995 .00025 L
.77243 .00024 L
.77508 .00022 L
.77985 .00018 L
.79068 6e-005 L
.79328 3e-005 L
.7946 1e-005 L
.79495 1e-005 L
.79534 1e-005 L
.79571 1e-005 L
.79604 1e-005 L
.79642 1e-005 L
.79678 2e-005 L
.79759 3e-005 L
.79906 4e-005 L
.80185 8e-005 L
.80692 .00013 L
.81239 .00018 L
.81528 .0002 L
.81793 .00022 L
Mistroke
.82047 .00023 L
.82175 .00023 L
.82247 .00024 L
.82315 .00024 L
.82376 .00024 L
.82442 .00024 L
.82503 .00024 L
.82558 .00024 L
.82618 .00024 L
.82685 .00024 L
.82718 .00024 L
.82754 .00024 L
.82819 .00024 L
.82876 .00024 L
.82939 .00024 L
.83004 .00024 L
.83064 .00024 L
.83289 .00023 L
.83427 .00023 L
.83554 .00022 L
.83841 .0002 L
.84361 .00017 L
.85335 7e-005 L
.8558 4e-005 L
.85715 3e-005 L
.85781 2e-005 L
.85843 1e-005 L
.85901 1e-005 L
.85962 1e-005 L
.86023 1e-005 L
.86091 2e-005 L
.86318 4e-005 L
.86882 .0001 L
.87399 .00015 L
.87891 .00019 L
.88138 .0002 L
.8841 .00021 L
.88552 .00022 L
.88682 .00022 L
.88754 .00022 L
.88832 .00022 L
.88868 .00022 L
.88906 .00022 L
.88974 .00022 L
.89037 .00022 L
.89104 .00022 L
.89167 .00022 L
.89225 .00022 L
.89292 .00022 L
.89366 .00022 L
Mistroke
.895 .00022 L
.89634 .00022 L
.89779 .00021 L
.90041 .0002 L
.9053 .00017 L
.91102 .00012 L
.91628 7e-005 L
.91874 5e-005 L
.92009 3e-005 L
.92138 2e-005 L
.92195 1e-005 L
.92257 1e-005 L
.92324 0 L
.92386 1e-005 L
.92442 1e-005 L
.92494 2e-005 L
.92613 3e-005 L
.9314 8e-005 L
.93695 .00013 L
.94199 .00017 L
.94485 .00019 L
.94751 .0002 L
.94878 .0002 L
.94997 .0002 L
.95104 .00021 L
.9522 .00021 L
.9528 .00021 L
.95346 .00021 L
.95415 .00021 L
.9548 .00021 L
.9554 .00021 L
.95596 .00021 L
.95659 .00021 L
.9572 .00021 L
.95782 .00021 L
.95849 .00021 L
.9597 .0002 L
.96197 .0002 L
.96462 .00019 L
.96705 .00017 L
.97619 .00011 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0?moomMoo`003gooo`00^00047oo000JOol50002Ool20002Ool600000goo000000020002Ool60003
Ool20003Ool200000goo000000020002Ool30002Ool4000=Ool00`00Oomoo`0;Ool00`00Oomoo`0;
Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`0;
Ool00`00Ool0000200000goo000000030002Ool30002Ool20003Ool20003Ool20002Ool00`00Oomo
o`07Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomo
o`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomo
o`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomo
o`0;Ool00`00Oomoo`0IOol001ioo`<0009oo`<0009oo`8000]oo`03001oogoo00<00003Ool00000
00800003Ool0000000800004Ool000000002Ool30002Ool6000UOol00`00Oomoo`12Ool20002Ool2
0004Ool4000017oo001oogoo0`0000Aoo`00Oomoo`@000=oo`03001oogoo02=oo`03001oogoo049o
o`03001oogoo04=oo`03001oogoo049oo`00?Woo00<007ooOol00Woo00<007ooOol047oo0`00Hgoo
1@002Woo0P000Woo0`000Woo0`001Goo00D007ooOomoo`000?Eoo`00EWoo00@007ooOol0069oo`03
001oo`00008000moo`03001oogoo00Uoo`05001oogooOol0003eOol005Yoo`03001oogoo05ioo`03
001oogoo009oo`03001oogoo01Uoo`05001oogooOol0003eOol005]oo`03001oogoo05Yoo`03001o
o`0000Eoo`03001oogoo01Uoo`05001oogooOol0003eOol005]oo`03001oogoo05Uoo`@000Eoo`03
001oogoo01Uoo`05001oogooOol0003eOol005aoo`03001oogoo05Qoo`03001oogoo00Ioo`03001o
ogoo01Uoo`05001oogooOol0003eOol005eoo`03001oogoo05Ioo`03001oogoo00Moo`03001oogoo
01Uoo`05001oogooOol0003eOol005eoo`03001oogoo05Ioo`03001oogoo00Moo`03001oogoo01Uo
o`05001oogooOol0003eOol005ioo`03001oogoo05Aoo`8000Uoo`03001oogoo01Uoo`05001oogoo
Ool0003eOol005moo`03001oogoo059oo`8000Yoo`03001oogoo01Uoo`05001oogooOol0003eOol0
061oo`03001oogoo051oo`03001oogoo00Yoo`<001Uoo`05001oogooOol0003eOol0061oo`03001o
ogoo051oo`03001oogoo00Yoo`03001oogoo01Uoo`05001oogooOol0003eOol0065oo`03001oogoo
04ioo`03001oogoo00]oo`03001oogoo01Uoo`05001oogooOol0003eOol0065oo`03001oogoo04io
o`03001oogoo00]oo`03001oogoo01Uoo`05001oogooOol0003eOol0069oo`03001oogoo04aoo`03
001oogoo00aoo`03001oogoo01Uoo`05001oogooOol0003eOol0069oo`03001oogoo04aoo`03001o
ogoo00aoo`03001oogoo01Uoo`05001oogooOol0003eOol006=oo`03001oogoo04Yoo`03001oogoo
00eoo`03001oogoo01Uoo`05001oogooOol0003eOol006=oo`03001oogoo04Yoo`03001oogoo00eo
o`03001oogoo01Uoo`05001oogooOol0003eOol006=oo`03001oogoo04Yoo`03001oogoo00eoo`03
001oogoo01Uoo`05001oogooOol0003eOol006Aoo`03001oogoo04Qoo`03001oogoo00ioo`03001o
ogoo01Uoo`05001oogooOol0003eOol006Aoo`03001oogoo04Qoo`03001oogoo00ioo`03001oogoo
01Uoo`05001oogooOol0003eOol006Aoo`03001oogoo04Moo`03001oogoo00moo`03001oogoo01Uo
o`05001oogooOol0003eOol006Eoo`03001oogoo04Ioo`03001oogoo00moo`03001oogoo01Uoo`05
001oogooOol0003eOol006Eoo`03001oogoo04Eoo`03001oogoo011oo`03001oogoo01Uoo`05001o
ogooOol0003eOol006Ioo`03001oogoo04Aoo`03001oogoo011oo`<001Uoo`05001oogooOol0003e
Ool006Ioo`03001oogoo04=oo`03001oogoo015oo`03001oogoo01Uoo`05001oogooOol0003eOol0
06Ioo`03001oogoo04=oo`03001oogoo015oo`03001oogoo01Uoo`05001oogooOol0003eOol006Mo
o`03001oogoo049oo`03001oogoo015oo`03001oogoo01Uoo`05001oogooOol0003eOol006Moo`03
001oogoo045oo`03001oogoo019oo`03001oogoo01Uoo`05001oogooOol0003eOol006Moo`03001o
ogoo045oo`03001oogoo019oo`03001oogoo01Uoo`05001oogooOol0003eOol006Qoo`03001oogoo
03moo`03001oogoo01=oo`03001oogoo01Uoo`05001oogooOol0003eOol006Qoo`03001oogoo03mo
o`03001oogoo01=oo`03001oogoo01Uoo`05001oogooOol0003eOol006Qoo`03001oogoo03moo`03
001oogoo01=oo`03001oogoo01Uoo`05001oogooOol0003eOol006Uoo`03001oogoo03eoo`03001o
ogoo01Aoo`03001oogoo01Uoo`05001oogooOol0003eOol006Uoo`03001oogoo03eoo`03001oogoo
01Aoo`03001oogoo01Uoo`05001oogooOol0003eOol006Yoo`03001oogoo03]oo`03001oogoo01Eo
o`03001oogoo01Uoo`05001oogooOol0003eOol006Yoo`03001oogoo03]oo`03001oogoo01Eoo`03
001oogoo01Uoo`05001oogooOol0003eOol006Yoo`03001oogoo03Yoo`03001oogoo01Ioo`<001Uo
o`05001oogooOol0003eOol006]oo`03001oogoo03Uoo`03001oogoo01Ioo`03001oogoo01Uoo`05
001oogooOol0003eOol006]oo`03001oogoo03Uoo`03001oogoo01Ioo`03001oogoo01Uoo`05001o
ogooOol0003eOol006]oo`03001oogoo03Qoo`03001oogoo01Moo`03001oogoo01Uoo`05001oogoo
Ool0003eOol006aoo`03001oogoo03Moo`03001oogoo01Moo`03001oogoo01Uoo`05001oogooOol0
003eOol006aoo`03001oogoo03Ioo`03001oogoo01Qoo`03001oogoo01Uoo`05001oogooOol0003e
Ool006aoo`03001oogoo03Ioo`03001oogoo01Qoo`03001oogoo01Uoo`05001oogooOol0003eOol0
06aoo`03001oogoo03Ioo`03001oogoo01Qoo`03001oogoo01Uoo`05001oogooOol0003eOol006eo
o`03001oogoo03Aoo`03001oogoo01Uoo`03001oogoo01Uoo`05001oogooOol0003eOol006eoo`03
001oogoo03Aoo`03001oogoo01Uoo`03001oogoo01Uoo`05001oogooOol0003eOol006eoo`03001o
ogoo03=oo`03001oogoo00ioo`H000Ioo`03001oogoo01Uoo`05001oogooOol0003eOol006ioo`03
001oogoo039oo`03001oogoo00ioo`03001oogoo00Uoo`03001oogoo01Uoo`05001oogooOol0003e
Ool006ioo`03001oogoo039oo`03001oogoo00moo`03001oogoo00Qoo`03001oogoo01Uoo`05001o
ogooOol0003eOol006ioo`03001oogoo035oo`03001oogoo015oo`03001oogoo00Moo`03001oogoo
01Uoo`05001oogooOol0003eOol006moo`03001oogoo031oo`03001oogoo019oo`03001oogoo00Io
o`@001Qoo`05001oogooOol0003eOol006moo`03001oogoo031oo`03001oogoo01=oo`03001oogoo
00Eoo`03001oogoo01Uoo`05001oogooOol0003eOol006moo`03001oogoo031oo`03001oogoo01Ao
o`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol006moo`03001oogoo02moo`03
001oogoo01Eoo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol0071oo`03001o
ogoo02ioo`03001oogoo011oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001o
ogooOol0003eOol0071oo`03001oogoo02ioo`03001oogoo015oo`@000Moo`03001oogoo01Uoo`05
001oogooOol0003eOol0071oo`03001oogoo02eoo`03001oogoo01eoo`03001oogoo01Uoo`05001o
ogooOol0003eOol0075oo`03001oogoo02aoo`03001oogoo01eoo`03001oogoo01Uoo`05001oogoo
Ool0003eOol0075oo`03001oogoo02aoo`03001oogoo01eoo`03001oogoo01Uoo`05001oogooOol0
003eOol0075oo`03001oogoo02]oo`03001oogoo01ioo`03001oogoo01Uoo`05001oogooOol0003e
Ool0079oo`03001oogoo02Yoo`03001oogoo01ioo`03001oogoo01Uoo`05001oogooOol0003eOol0
079oo`03001oogoo02Yoo`03001oogoo01ioo`03001oogoo01Uoo`05001oogooOol0003eOol0079o
o`03001oogoo02Yoo`03001oogoo01ioo`03001oogoo01Uoo`05001oogooOol0003eOol0079oo`03
001oogoo02Uoo`03001oogoo01moo`<001Uoo`05001oogooOol0003eOol007=oo`03001oogoo02Qo
o`03001oogoo01moo`03001oogoo01Uoo`05001oogooOol0003eOol007=oo`03001oogoo02Qoo`03
001oogoo01moo`03001oogoo01Uoo`05001oogooOol0003eOol007=oo`03001oogoo02Moo`03001o
ogoo021oo`03001oogoo01Uoo`05001oogooOol0003eOol007Aoo`03001oogoo02Ioo`03001oogoo
021oo`03001oogoo01Uoo`05001oogooOol0003eOol007Aoo`03001oogoo02Ioo`03001oogoo021o
o`03001oogoo01Uoo`05001oogooOol0003eOol007Aoo`03001oogoo02Eoo`03001oogoo025oo`03
001oogoo01Uoo`05001oogooOol0003eOol007Aoo`03001oogoo02Eoo`03001oogoo025oo`03001o
ogoo01Uoo`05001oogooOol0003eOol007Eoo`03001oogoo02Aoo`03001oogoo025oo`03001oogoo
01Uoo`05001oogooOol0003eOol007Eoo`03001oogoo02Aoo`03001oogoo025oo`03001oogoo01Uo
o`05001oogooOol0003eOol007Eoo`03001oogoo02=oo`03001oogoo029oo`03001oogoo01Uoo`05
001oogooOol0003eOol007Eoo`03001oogoo02=oo`03001oogoo029oo`03001oogoo01Uoo`05001o
ogooOol0003eOol007Ioo`03001oogoo029oo`03001oogoo029oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol007Ioo`03001oogoo025oo`03001oogoo02=oo`03001oogoo01Uoo`05001oogooOol0
003eOol007Ioo`03001oogoo025oo`03001oogoo02=oo`<001Uoo`05001oogooOol0003eOol007Io
o`03001oogoo025oo`03001oogoo02=oo`03001oogoo01Uoo`05001oogooOol0003eOol007Moo`03
001oogoo01moo`03001oogoo02Aoo`03001oogoo01Uoo`05001oogooOol0003eOol007Moo`03001o
ogoo01moo`03001oogoo02Aoo`03001oogoo01Uoo`05001oogooOol0003eOol007Moo`03001oogoo
01moo`03001oogoo02Aoo`03001oogoo01Uoo`05001oogooOol0003eOol007Moo`03001oogoo01mo
o`03001oogoo02Aoo`03001oogoo01Uoo`05001oogooOol0003eOol007Qoo`03001oogoo01eoo`03
001oogoo02Eoo`03001oogoo01Uoo`05001oogooOol0003eOol007Qoo`03001oogoo01eoo`03001o
ogoo02Eoo`03001oogoo01Uoo`05001oogooOol0003eOol007Qoo`03001oogoo01eoo`03001oogoo
02Eoo`03001oogoo01Uoo`05001oogooOol0003eOol007Uoo`03001oogoo01]oo`03001oogoo02Io
o`03001oogoo01Uoo`05001oogooOol0003eOol007Uoo`03001oogoo01]oo`03001oogoo02Ioo`03
001oogoo01Uoo`05001oogooOol0003eOol007Uoo`03001oogoo01]oo`03001oogoo02Ioo`03001o
ogoo01Uoo`05001oogooOol0003eOol007Yoo`03001oogoo01Uoo`03001oogoo02Moo`03001oogoo
01Uoo`05001oogooOol0003eOol007Yoo`03001oogoo01Uoo`03001oogoo02Moo`<001Uoo`05001o
ogooOol0003eOol007Yoo`03001oogoo01Uoo`03001oogoo02Moo`03001oogoo01Uoo`05001oogoo
Ool0003eOol007]oo`03001oogoo01Moo`03001oogoo02Qoo`03001oogoo01Uoo`05001oogooOol0
003eOol007]oo`03001oogoo01Moo`03001oogoo02Qoo`03001oogoo01Uoo`05001oogooOol0003e
Ool007aoo`03001oogoo01Ioo`03001oogoo02Qoo`03001oogoo01Uoo`05001oogooOol0003eOol0
07aoo`03001oogoo01Eoo`03001oogoo02Uoo`03001oogoo01Uoo`05001oogooOol0003eOol007eo
o`03001oogoo01Aoo`03001oogoo02Uoo`03001oogoo01Uoo`05001oogooOol0003eOol007eoo`03
001oogoo01Aoo`03001oogoo02Uoo`03001oogoo01Uoo`05001oogooOol0003eOol007ioo`03001o
ogoo019oo`03001oogoo02Yoo`03001oogoo01Uoo`05001oogooOol0003eOol007ioo`03001oogoo
019oo`03001oogoo02Yoo`03001oogoo01Uoo`05001oogooOol0003eOol007ioo`03001oogoo015o
o`8002=oo`<000Ioo`03001oogoo01Uoo`05001oogooOol0003eOol007moo`03001oogoo00moo`80
02Eoo`03001oogoo00Eoo`03001oogoo01Uoo`05001oogooOol0003eOol007moo`03001oogoo00mo
o`03001oogoo02Aoo`03001oogoo00Eoo`03001oogoo01Uoo`05001oogooOol0003eOol0081oo`03
001oogoo00eoo`03001oogoo025oo`H000Ioo`03001oogoo01Uoo`05001oogooOol0003eOol0081o
o`03001oogoo00eoo`03001oogoo025oo`05001oogooOol00007Ool4000HOol01@00Oomoogoo0000
mGoo0020Ool2000=Ool00`00Oomoo`0SOol01000Oomoo`001goo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00PGoo0P0037oo00<007ooOol097oo00<007oo00001goo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00PWoo00<007ooOol02Woo00<007ooOol097oo00<007oo00001goo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00Pgoo00<007ooOol01goo0`009goo0P001goo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00Pgoo00<007ooOol01Woo00<007ooOol0:Goo00<007ooOol01Goo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00Q7oo00<007ooOol017oo00<007ooOol0<Woo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00Q7oo1@000Woo00<007ooOol0<Woo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00RGoo0P00=Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo0`006Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo0`006Goo00D007ooOomo
o`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo0`006Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00]Goo10001goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol0
0Woo00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol00Woo
00<007ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol00Woo00<0
07ooOol017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo0P000goo00<007ooOol017oo
100067oo00D007ooOomoo`000?Eoo`00]7oo00<007oo00000P001goo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00]7oo00<007ooOol02Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo
00<007ooOol02Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]Goo00<007ooOol027oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00]Woo0`001goo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
0`006Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo0`006Goo00D007ooOomoo`000?Eoo`00
`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo0`006Goo00D007ooOomoo`000?Eo
o`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00`7oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
]Goo10001goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol00Woo00<007oo
Ool017oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol00Woo00<007ooOol0
17oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol00Woo00<007ooOol017oo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol00Woo00<007ooOol017oo1000
67oo1@00mGoo002eOol40007Ool00`00Oomoo`3oOolDOol00;Aoo`03001oogoo009oo`03001oogoo
00Aoo`03001oogoo0?mooaAoo`00]7oo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0ogoo
57oo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`3oOolDOol00;Eoo`@000Moo`03
001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03
001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03
001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool3003oOolDOol00<1oo`03001oogoo
0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo
0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo
0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo
0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo
0?mooaAoo`00`7oo0`00ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAo
o`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAo
o`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAo
o`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAo
o`00`7oo00<007ooOol0ogoo57oo0030Ool3003oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo
00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo
00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo
00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00:aoo`D000Aoo`@000Moo`03001oogoo
0?mooaAoo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0ogoo
57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`3oOolDOol0
0:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0?mooaAoo`00[Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo1000ogoo4goo002^Ool00`00Oomoo`03
Ool00`00Oomoo`02Ool00`00Oomoo`3oOolKOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03
001oogoo0?mooa]oo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0ogoo6goo002/
Ool30005Ool00`00Oomoo`02Ool00`00Oomoo`3oOolKOol00001\
\>"],
  ImageRangeCache->{{{0, 469}, {289.313, 0}} -> {-13.8869, -0.535215, 
  0.0720124, 0.03699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .00426 m
.02598 .00246 L
.02648 .00193 L
.02702 .00135 L
.02753 .00088 L
.028 .00068 L
.02856 .00094 L
.02916 .00147 L
.03022 .00239 L
.03076 .00279 L
.03134 .00314 L
.03168 .00329 L
.03199 .00341 L
.03259 .00356 L
.03316 .00361 L
.03376 .00356 L
.03434 .00343 L
.03485 .00325 L
.03547 .00297 L
.03613 .0026 L
.03733 .0018 L
.03847 .00097 L
.0391 .00052 L
.03968 .00014 L
.04018 .00028 L
.04071 .00062 L
.04184 .00129 L
.04307 .00189 L
.04374 .00216 L
.04437 .00236 L
.04505 .00253 L
.04541 .0026 L
.0458 .00266 L
.04613 .00269 L
.04649 .00271 L
.04679 .00272 L
.04712 .00271 L
.04746 .00269 L
.04778 .00266 L
.04837 .00256 L
.04871 .00249 L
.04902 .00241 L
.04971 .00221 L
.05096 .00178 L
.05157 .00158 L
.05212 .00144 L
.05266 .00136 L
.05317 .00137 L
.05371 .00147 L
.05429 .00167 L
Mistroke
.05489 .00194 L
.05553 .00226 L
.05668 .00287 L
.05731 .00318 L
.05798 .00348 L
.05858 .00369 L
.05891 .00379 L
.05921 .00386 L
.05978 .00396 L
.06008 .00398 L
.0604 .00399 L
.06098 .00395 L
.0615 .00386 L
.06205 .00369 L
.06257 .00349 L
.06375 .0029 L
.06431 .00262 L
.0649 .00238 L
.06521 .00231 L
.06555 .00228 L
.06614 .00238 L
.0667 .00264 L
.06722 .00299 L
.06836 .00389 L
.06937 .00462 L
.06987 .00491 L
.07043 .00514 L
.07074 .00523 L
.07107 .00529 L
.07167 .00529 L
.07227 .00516 L
.07282 .00493 L
.07315 .00474 L
.07346 .00453 L
.07415 .00397 L
.0748 .00336 L
.07542 .00278 L
.07594 .00237 L
.0765 .00212 L
.0768 .00212 L
.07712 .00222 L
.0777 .00261 L
.07894 .00384 L
.07956 .00442 L
.08012 .00487 L
.08066 .00522 L
.08124 .00545 L
.08182 .00556 L
.08214 .00555 L
.08245 .00551 L
Mistroke
.08298 .00533 L
.08347 .00507 L
.08403 .00465 L
.08457 .00416 L
.08567 .00294 L
.08627 .00222 L
.08684 .00164 L
.08717 .0014 L
.08752 .00131 L
.08813 .00157 L
.08843 .00183 L
.08875 .00215 L
.08932 .00273 L
.09034 .00367 L
.09091 .00407 L
.09144 .00434 L
.09192 .00451 L
.09245 .00459 L
.09295 .00458 L
.09341 .0045 L
.09394 .00431 L
.09444 .00405 L
.09558 .00324 L
.09678 .00215 L
.09736 .00158 L
.09789 .00106 L
.09844 .00057 L
.09895 .00033 L
.09949 .00064 L
.10008 .00111 L
.10123 .00194 L
.10188 .00233 L
.10248 .00263 L
.10307 .00286 L
.1037 .00306 L
.10405 .00313 L
.10438 .00319 L
.105 .00325 L
.10557 .00325 L
.10611 .00321 L
.10669 .00311 L
.10702 .00304 L
.10732 .00296 L
.10946 .00209 L
.11058 .00156 L
.11115 .00136 L
.11147 .0013 L
.11177 .00128 L
.11232 .00137 L
.11282 .00156 L
Mistroke
.1134 .00187 L
.11395 .0022 L
.11595 .00342 L
.11649 .00368 L
.11706 .00393 L
.11756 .00411 L
.1181 .00426 L
.11843 .00432 L
.11874 .00437 L
.11934 .00441 L
.11989 .00439 L
.12048 .00431 L
.1208 .00425 L
.1211 .00417 L
.12177 .00396 L
.12299 .00349 L
.12356 .00329 L
.1241 .00315 L
.12466 .0031 L
.12527 .00318 L
.1258 .00338 L
.12639 .0037 L
.12744 .00446 L
.12838 .00517 L
.12888 .0055 L
.12942 .00581 L
.13 .00605 L
.13054 .00619 L
.13085 .00622 L
.13116 .00622 L
.13173 .00613 L
.13226 .00594 L
.13276 .00568 L
.13387 .00484 L
.13502 .00387 L
.13559 .0035 L
.13592 .00339 L
.13623 .00335 L
.13656 .0034 L
.13687 .00353 L
.13722 .00376 L
.13756 .00404 L
.13878 .00528 L
.13986 .00628 L
.14046 .00668 L
.141 .00691 L
.14131 .00699 L
.14165 .00702 L
.14225 .00693 L
.14286 .00667 L
Mistroke
.14342 .00628 L
.14447 .00522 L
.1456 .00385 L
.14615 .00324 L
.14667 .00284 L
.14713 .00271 L
.14764 .00286 L
.14817 .00329 L
.14874 .00391 L
.14976 .00506 L
.15029 .00559 L
.15087 .00604 L
.1512 .00624 L
.1515 .00638 L
.15209 .00653 L
.15269 .00652 L
.15325 .00635 L
.15376 .00608 L
.15431 .00566 L
.15554 .00437 L
.15667 .00297 L
.15715 .00243 L
.15766 .00201 L
.15822 .00188 L
.15874 .00211 L
.15933 .00263 L
.15989 .00321 L
.16093 .00425 L
.16153 .00472 L
.1621 .00507 L
.16269 .00531 L
.163 .00538 L
.16334 .00542 L
.1639 .0054 L
.1645 .00524 L
.165 .00502 L
.16556 .00469 L
.1668 .00368 L
.16746 .00307 L
.16815 .00244 L
.16876 .00201 L
.1691 .00187 L
.16942 .00182 L
.16999 .00195 L
.1706 .00231 L
.17188 .0033 L
.17251 .00375 L
.1731 .0041 L
.17363 .00434 L
.17419 .00452 L
Mistroke
.17451 .00458 L
.17482 .00462 L
.17538 .00461 L
.17591 .00452 L
.17647 .00436 L
.17695 .00416 L
.17747 .0039 L
.17864 .0032 L
.17921 .00286 L
.17974 .00257 L
.18035 .00234 L
.18067 .00228 L
.18101 .00227 L
.18156 .00238 L
.18218 .00265 L
.18343 .00344 L
.18409 .00387 L
.18479 .00428 L
.1854 .00456 L
.18574 .00468 L
.18606 .00477 L
.18662 .00485 L
.18722 .00484 L
.18784 .00472 L
.18842 .00451 L
.18894 .00426 L
.18951 .00394 L
.19007 .00363 L
.19061 .00343 L
.1909 .00338 L
.19123 .0034 L
.19179 .00364 L
.19233 .0041 L
.1929 .00478 L
.19393 .00623 L
.19456 .00713 L
.19524 .00801 L
.19584 .00865 L
.19617 .00894 L
.19648 .00916 L
.19705 .00945 L
.19735 .00954 L
.19768 .00958 L
.19826 .00955 L
.19879 .00941 L
.1994 .0092 L
.19973 .00909 L
.20004 .00901 L
.2006 .009 L
.2012 .00927 L
Mistroke
.20154 .00957 L
.20187 .00995 L
.20247 .01094 L
.20383 .01395 L
.20494 .01654 L
.20554 .01779 L
.20611 .01878 L
.20644 .01926 L
.20679 .01969 L
.20741 .02024 L
.20771 .02042 L
.20803 .02055 L
.20861 .02067 L
.20917 .02069 L
.20947 .02069 L
.20979 .02072 L
.21038 .02086 L
.21092 .0212 L
.21143 .02178 L
.21192 .02256 L
.21245 .0237 L
.21302 .02521 L
.21776 .03742 L
.22631 .05654 L
.2455 .11149 L
.26398 .17616 L
.27329 .20833 L
.27526 .21126 L
.27626 .21328 L
.27682 .21482 L
.27735 .21653 L
.27964 .22597 L
.28072 .23034 L
.28175 .23363 L
.28232 .23497 L
.28294 .23606 L
.2835 .23677 L
.28402 .23725 L
.28468 .23774 L
.2853 .2382 L
.28585 .23874 L
.28646 .23953 L
.287 .2405 L
.28758 .24179 L
.28861 .24473 L
.2909 .2521 L
.2915 .25367 L
.29206 .25488 L
.29237 .25543 L
.29271 .25593 L
Mistroke
.29331 .25656 L
.29388 .25692 L
.29448 .25711 L
.29499 .25718 L
.29556 .25724 L
.29588 .25729 L
.29622 .25738 L
.29683 .25764 L
.29717 .25787 L
.29748 .25814 L
.2982 .25895 L
.29939 .26083 L
.30067 .26314 L
.30188 .26505 L
.30249 .26576 L
.30284 .26607 L
.30316 .2663 L
.30374 .26655 L
.30427 .26662 L
.30488 .26653 L
.30546 .26631 L
.30676 .26553 L
.30748 .26508 L
.30815 .26471 L
.30846 .26457 L
.30878 .26444 L
.30913 .26434 L
.30946 .26428 L
.31002 .26425 L
.31034 .26427 L
.31064 .26431 L
.31123 .26445 L
.31178 .26463 L
.31228 .26481 L
.31282 .26498 L
.3134 .26512 L
.31393 .26515 L
.31451 .26506 L
.31484 .26493 L
.31514 .26476 L
.31545 .26453 L
.31578 .26422 L
.31638 .26348 L
.31751 .26154 L
.32005 .25617 L
.33 .23894 L
.33902 .2187 L
.35727 .16172 L
.36701 .12669 L
.37597 .0952 L
Mistroke
.38472 .07075 L
.39396 .05146 L
.41168 .02209 L
.41223 .02248 L
.41276 .02264 L
.41331 .02256 L
.41391 .02213 L
.41452 .02135 L
.41486 .02077 L
.41518 .02015 L
.41635 .01731 L
.41747 .01421 L
.41851 .01165 L
.41903 .0107 L
.41959 .01005 L
.41991 .00987 L
.42021 .00982 L
.42078 .01 L
.42197 .01103 L
.42262 .01165 L
.42323 .01211 L
.42354 .01229 L
.42389 .01242 L
.42426 .01249 L
.42461 .01248 L
.42492 .01242 L
.42526 .01228 L
.42558 .01209 L
.42588 .01186 L
.42649 .01126 L
.42707 .01054 L
.42814 .00892 L
.42938 .00681 L
.42999 .00581 L
.43054 .00499 L
.43108 .00433 L
.43159 .0039 L
.43213 .00369 L
.43272 .00376 L
.43332 .00407 L
.43362 .00428 L
.43396 .00453 L
.4351 .0054 L
.43569 .00576 L
.4363 .00604 L
.43662 .00614 L
.43698 .00622 L
.43759 .00625 L
.43818 .00617 L
.4385 .00607 L
Mistroke
.4388 .00595 L
.43938 .00564 L
.43992 .00526 L
.44194 .00338 L
.44247 .00285 L
.44304 .00235 L
.44358 .002 L
.44407 .00182 L
.44464 .00184 L
.44518 .00202 L
.44576 .0023 L
.4464 .00262 L
.44855 .0034 L
.44958 .00371 L
.45009 .00391 L
.45066 .00418 L
.45184 .00492 L
.45293 .00566 L
.45355 .00602 L
.4539 .00618 L
.45422 .00631 L
.45452 .00639 L
.45485 .00643 L
.45542 .0064 L
.45601 .00621 L
.45631 .00604 L
.45664 .00581 L
.45722 .00526 L
.45777 .00461 L
.45837 .00375 L
.45903 .00273 L
.45933 .0023 L
.45965 .00193 L
.46023 .00181 L
.46084 .00255 L
.46141 .00362 L
.46249 .00574 L
.46311 .00685 L
.46376 .00784 L
.46432 .00849 L
.46493 .00897 L
.46527 .00912 L
.46559 .00918 L
.46595 .00915 L
.46629 .00903 L
.4669 .00858 L
.46725 .0082 L
.46756 .00777 L
.46825 .00661 L
Mfstroke
.46825 .00661 m
.46864 .00591 L
.46906 .00524 L
.46946 .00468 L
.46984 .0042 L
.47024 .00374 L
.47063 .00335 L
.47105 .00298 L
.47145 .00266 L
.47183 .00239 L
.47224 .00213 L
.47263 .00191 L
.47301 .00172 L
.47341 .00154 L
.4738 .00138 L
.47421 .00123 L
.47461 .00111 L
.47499 .001 L
.4754 .0009 L
.47579 .00082 L
.47621 .00075 L
.47661 .00069 L
.47699 .00065 L
.47719 .00064 L
.47729 .00063 L
.4774 .00063 L
.47745 .00063 L
.4775 .00062 L
.47754 .00062 L
.47758 .00062 L
.47761 .00062 L
.47763 .00062 L
.47766 .00062 L
.47768 .00062 L
.47769 .00062 L
.4777 .00062 L
.47771 .00062 L
.47772 .00062 L
.47773 .00062 L
.47774 .00062 L
.47775 .00062 L
.47777 .00062 L
.47778 .00062 L
s
.47778 .00062 m
.47839 .00062 L
.47895 .00062 L
.4796 .00062 L
.48021 .00062 L
.48077 .00062 L
.4813 .00062 L
.48187 .00062 L
.48248 .00062 L
.48374 .00061 L
.48492 .0006 L
.48762 .00058 L
.49023 .00054 L
.49262 .0005 L
.498 .00039 L
.5034 .00025 L
.50626 .00017 L
.50782 .00013 L
.5093 9e-005 L
.51071 6e-005 L
.51109 5e-005 L
.5115 4e-005 L
.51184 4e-005 L
.51222 4e-005 L
.51289 4e-005 L
.51326 5e-005 L
.51359 5e-005 L
.51487 8e-005 L
.52005 .00021 L
.52489 .00032 L
.53004 .0004 L
.53272 .00044 L
.53414 .00045 L
.53568 .00047 L
.53708 .00048 L
.5377 .00048 L
.53837 .00048 L
.53897 .00048 L
.5396 .00049 L
.54028 .00049 L
.5409 .00049 L
.54155 .00049 L
.54191 .00049 L
.54225 .00049 L
.54295 .00049 L
.54333 .00049 L
.54369 .00049 L
.54432 .00048 L
.54501 .00048 L
.54626 .00048 L
Mistroke
.54772 .00047 L
.54928 .00045 L
.55207 .00042 L
.55761 .00034 L
.56262 .00025 L
.56753 .00015 L
.57021 9e-005 L
.57152 6e-005 L
.57271 4e-005 L
.57338 3e-005 L
.57402 2e-005 L
.57469 2e-005 L
.57507 3e-005 L
.57542 4e-005 L
.57839 9e-005 L
.58361 .0002 L
.58833 .00028 L
.5934 .00034 L
.59631 .00037 L
.59758 .00038 L
.59897 .00039 L
.60029 .00039 L
.60151 .0004 L
.60219 .0004 L
.60281 .0004 L
.60315 .0004 L
.60352 .0004 L
.60419 .0004 L
.60484 .0004 L
.60543 .0004 L
.60611 .0004 L
.60676 .0004 L
.60791 .00039 L
.60916 .00039 L
.61053 .00038 L
.61199 .00037 L
.61461 .00035 L
.61985 .00029 L
.62563 .0002 L
.63055 .00012 L
.63324 7e-005 L
.63455 5e-005 L
.63574 3e-005 L
.63642 2e-005 L
.63706 1e-005 L
.63773 2e-005 L
.63811 3e-005 L
.63846 3e-005 L
.64143 8e-005 L
.64665 .00017 L
Mistroke
.65138 .00023 L
.65646 .00029 L
.65937 .00031 L
.66204 .00033 L
.66332 .00033 L
.66399 .00033 L
.66471 .00034 L
.66541 .00034 L
.66603 .00034 L
.66666 .00034 L
.66726 .00034 L
.66787 .00034 L
.66852 .00034 L
.66914 .00034 L
.6697 .00034 L
.67035 .00034 L
.67107 .00033 L
.67237 .00033 L
.67373 .00032 L
.67518 .00032 L
.67777 .0003 L
.68237 .00025 L
.68744 .00019 L
.69238 .00012 L
.69758 4e-005 L
.69889 2e-005 L
.69927 2e-005 L
.69963 1e-005 L
.7003 1e-005 L
.70068 1e-005 L
.70104 2e-005 L
.70184 3e-005 L
.70327 5e-005 L
.70849 .00013 L
.71323 .00019 L
.71832 .00024 L
.72124 .00026 L
.7239 .00028 L
.72519 .00028 L
.72658 .00029 L
.72722 .00029 L
.7279 .00029 L
.72853 .00029 L
.72912 .00029 L
.72978 .0003 L
.73012 .0003 L
.73049 .0003 L
.73088 .0003 L
.73125 .0003 L
.73194 .0003 L
Mistroke
.73258 .0003 L
.73318 .00029 L
.73383 .00029 L
.73453 .00029 L
.73596 .00029 L
.7373 .00028 L
.74036 .00027 L
.74302 .00025 L
.74545 .00023 L
.75092 .00017 L
.75573 .00011 L
.76085 4e-005 L
.76158 3e-005 L
.76237 2e-005 L
.76273 1e-005 L
.76312 1e-005 L
.7638 1e-005 L
.76446 1e-005 L
.76508 2e-005 L
.76648 4e-005 L
.7717 .00011 L
.77716 .00017 L
.77985 .0002 L
.78234 .00022 L
.78455 .00023 L
.78699 .00025 L
.78945 .00026 L
.79079 .00026 L
.79205 .00026 L
.79267 .00026 L
.79333 .00026 L
.79395 .00026 L
.79451 .00026 L
.79517 .00026 L
.79555 .00026 L
.79589 .00026 L
.79652 .00026 L
.7972 .00026 L
.79784 .00026 L
.79853 .00026 L
.79977 .00026 L
.80126 .00025 L
.80261 .00025 L
.80758 .00021 L
.81229 .00017 L
.81732 .00012 L
.82267 6e-005 L
.82393 4e-005 L
.82528 3e-005 L
.8259 2e-005 L
Mistroke
.82655 1e-005 L
.82711 1e-005 L
.82773 1e-005 L
.82832 1e-005 L
.82887 2e-005 L
.83009 4e-005 L
.8323 6e-005 L
.8423 .00017 L
.84505 .00019 L
.84795 .00021 L
.85044 .00022 L
.85175 .00023 L
.85318 .00023 L
.85451 .00024 L
.85575 .00024 L
.85644 .00024 L
.85707 .00024 L
.85741 .00024 L
.85779 .00024 L
.85847 .00024 L
.85905 .00024 L
.85969 .00024 L
.86036 .00024 L
.86099 .00024 L
.86211 .00024 L
.86332 .00024 L
.86472 .00023 L
.86625 .00022 L
.86902 .00021 L
.87424 .00017 L
.88436 8e-005 L
.88714 4e-005 L
.8886 3e-005 L
.88939 2e-005 L
.89013 1e-005 L
.89078 1e-005 L
.89115 0 L
.89148 1e-005 L
.89185 1e-005 L
.89224 1e-005 L
.89296 2e-005 L
.89555 5e-005 L
.90532 .00015 L
.908 .00017 L
.91088 .00019 L
.91337 .0002 L
.91608 .00021 L
.91752 .00022 L
.91823 .00022 L
.91886 .00022 L
Mistroke
.91948 .00022 L
.92014 .00022 L
.92051 .00022 L
.92084 .00022 L
.9215 .00022 L
.9221 .00022 L
.92265 .00022 L
.92326 .00022 L
.92392 .00022 L
.9246 .00022 L
.92525 .00022 L
.92647 .00022 L
.92779 .00022 L
.9292 .00021 L
.93174 .0002 L
.93446 .00019 L
.93747 .00017 L
.94282 .00012 L
.94845 7e-005 L
.95078 4e-005 L
.95326 2e-005 L
.95399 1e-005 L
.95435 1e-005 L
.95469 0 L
.95531 1e-005 L
.95598 1e-005 L
.95852 4e-005 L
.97619 .00018 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0?moomMoo`003gooo`00^00047oo000JOol2000017oo000000000Woo100000=oo`0000001@000Woo
0`0000=oo`0000000P0000Aoo`00001oo`@00003Ool0000000D0009oo`8000=oo`<0009oo`80009o
o`@00003Ool0000000800003Ool0000000Uoo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo
00]oo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00Uoo`<0009oo`@0
00=oo`80009oo`<00003Ool007oo00Qoo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]o
o`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]o
o`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]o
o`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo01Uoo`006Woo00<007ooOol04Goo0P000Woo
100000=oo`0000002Woo0P000Woo100000Aoo`00Ool0009oo`<0009oo`<0009oo`8000=oo`<00003
Ool007oo01Eoo`03001oogoo049oo`03001oogoo00Qoo`H000Aoo`@00003Ool007oo0080009oo`03
001oogoo02=oo`03001oogoo049oo`03001oogoo04=oo`03001oogoo049oo`00CGoo0P000goo00<0
07ooOol03goo0P00FWoo00<007ooOol027oo00<007ooOol037oo00<007oo00000goo00<007ooOol0
lgoo001UOol4001GOol00`00Oomoo`04Ool200000goo0000000?Ool20003Ool00`00Oomoo`3cOol0
06Qoo`03001oogoo05Eoo`03001oogoo00=oo`03001oo`000080015oo`05001oogooOol0003eOol0
06Qoo`03001oogoo05Eoo`03001oogoo00=oo`03001oogoo01=oo`05001oogooOol0003eOol006Uo
o`03001oogoo05Aoo`03001oogoo009oo`03001oogoo01Aoo`05001oogooOol0003eOol006Uoo`80
05Eoo`03001oogoo009oo`03001oogoo01Aoo`05001oogooOol0003eOol006Yoo`<005=oo`03001o
ogoo00<001Ioo`05001oogooOol0003eOol006aoo`03001oogoo055oo`05001oo`00Ool0000GOol0
1@00Oomoogoo0000mGoo001/Ool00`00Oomoo`1AOol00`00Ool0000IOol01@00Oomoogoo0000mGoo
001]Ool00`00Oomoo`1@Ool2000JOol01@00Oomoogoo0000mGoo001]Ool00`00Oomoo`1@Ool3000I
Ool01@00Oomoogoo0000mGoo001^Ool00`00Oomoo`1?Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo001^Ool00`00Oomoo`1?Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001_Ool00`00Oomo
o`1=Ool2000KOol01@00Oomoogoo0000mGoo001_Ool00`00Oomoo`1=Ool2000KOol01@00Oomoogoo
0000mGoo001`Ool00`00Oomoo`1;Ool00`00Ool0000KOol01@00Oomoogoo0000mGoo001`Ool00`00
Oomoo`1;Ool00`00Ool0000KOol01@00Oomoogoo0000mGoo001aOol00`00Oomoo`19Ool01000Oomo
o`006goo00D007ooOomoo`000?Eoo`00LGoo00<007ooOol0BGoo00@007ooOol001]oo`05001oogoo
Ool0003eOol0075oo`03001oogoo04Qoo`05001oogooOol0000KOol01@00Oomoogoo0000mGoo001b
Ool00`00Oomoo`17Ool01@00Oomoogoo00006goo00D007ooOomoo`000?Eoo`00LWoo00<007ooOol0
AWoo00<007ooOol00Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00LWoo00<007ooOol0AWoo
00<007ooOol00Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Lgoo00<007ooOol0A7oo00<0
07ooOol00goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Lgoo00<007ooOol0A7oo00<007oo
Ool00goo0`006Goo00D007ooOomoo`000?Eoo`00M7oo00<007ooOol0@Woo00<007ooOol017oo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00M7oo00<007ooOol0@Woo00<007ooOol017oo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00M7oo00<007ooOol0@Goo00<007ooOol01Goo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00MGoo00<007ooOol0@7oo00<007ooOol01Goo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00MGoo00<007ooOol0@7oo00<007ooOol01Goo00<007ooOol06Goo00D0
07ooOomoo`000?Eoo`00MGoo00<007ooOol0?goo00<007ooOol01Woo00<007ooOol06Goo00D007oo
Oomoo`000?Eoo`00MWoo00<007ooOol0?Woo00<007ooOol01Woo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00MWoo00<007ooOol0?Goo00<007ooOol01goo00<007ooOol06Goo00D007ooOomoo`00
0?Eoo`00Mgoo00<007ooOol0?7oo00<007ooOol01goo00<007ooOol06Goo00D007ooOomoo`000?Eo
o`00Mgoo00<007ooOol0?7oo00<007ooOol01goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
Mgoo00<007ooOol0>goo00<007ooOol027oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00N7oo
00<007ooOol0>Woo00<007ooOol027oo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00N7oo00<0
07ooOol0>Goo00<007ooOol02Goo0`006Goo00D007ooOomoo`000?Eoo`00N7oo00<007ooOol0>Goo
00<007ooOol02Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00NGoo00<007ooOol0>7oo00<0
07ooOol02Goo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00NGoo00<007ooOol0=goo00<007oo
Ool02Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00NWoo00<007ooOol0=Woo00<007ooOol0
2Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00NWoo00<007ooOol0=Woo00<007ooOol02Woo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00NWoo00<007ooOol0=Woo00<007ooOol02Woo00<0
07ooOol06Goo00D007ooOomoo`000?Eoo`00Ngoo00<007ooOol0=7oo00<007ooOol02goo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00Ngoo00<007ooOol0=7oo00<007ooOol02goo00<007ooOol0
6Goo00D007ooOomoo`000?Eoo`00Ngoo00<007ooOol0=7oo00<007ooOol02goo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00O7oo00<007ooOol0<Woo00<007ooOol01P001Woo00<007ooOol06Goo
00D007ooOomoo`000?Eoo`00O7oo00<007ooOol0<Woo00@007ooOol000]oo`03001oogoo01Uoo`05
001oogooOol0003eOol007aoo`03001oogoo039oo`05001oogooOol0000:Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo001lOol00`00Oomoo`0bOol00`00Oomoo`02Ool00`00Oomoo`07Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo001mOol00`00Oomoo`0`Ool00`00Oomoo`04Ool00`00Oomo
o`06Ool4000HOol01@00Oomoogoo0000mGoo001mOol00`00Oomoo`0`Ool00`00Oomoo`05Ool00`00
Oomoo`05Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001mOol00`00Oomoo`0`Ool00`00Oomo
o`06Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001mOol00`00Oomoo`0_
Ool00`00Oomoo`07Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo001nOol0
0`00Oomoo`0^Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo001nOol00`00Oomoo`0^Ool00`00Oomoo`03Ool40007Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo001nOol00`00Oomoo`0^Ool00`00Oomoo`0>Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo001oOol00`00Oomoo`0/Ool00`00Oomoo`0?Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo001oOol00`00Oomoo`0/Ool00`00Oomoo`0?Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo001oOol00`00Oomoo`0/Ool00`00Oomoo`0?Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo001oOol00`00Oomoo`0/Ool00`00Oomoo`0?Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0020Ool00`00Oomoo`0ZOol00`00Oomoo`0@Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0020Ool00`00Oomoo`0ZOol00`00Oomoo`0@Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0020
Ool00`00Oomoo`0ZOol00`00Oomoo`0@Ool3000IOol01@00Oomoogoo0000mGoo0021Ool00`00Oomo
o`0YOol00`00Oomoo`0@Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0021Ool00`00Oomoo`0X
Ool00`00Oomoo`0AOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0021Ool00`00Oomoo`0XOol0
0`00Oomoo`0AOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0021Ool00`00Oomoo`0XOol00`00
Oomoo`0AOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0022Ool00`00Oomoo`0VOol00`00Oomo
o`0BOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0022Ool00`00Oomoo`0VOol00`00Oomoo`0B
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0022Ool00`00Oomoo`0VOol00`00Oomoo`0BOol0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0022Ool00`00Oomoo`0UOol00`00Oomoo`0COol00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0023Ool00`00Oomoo`0TOol00`00Oomoo`0COol00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0023Ool00`00Oomoo`0TOol00`00Oomoo`0COol00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0023Ool00`00Oomoo`0SOol00`00Oomoo`0DOol00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0024Ool00`00Oomoo`0ROol00`00Oomoo`0DOol00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0024Ool00`00Oomoo`0ROol00`00Oomoo`0DOol00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0024Ool00`00Oomoo`0QOol00`00Oomoo`0EOol3000IOol01@00Oomoogoo0000mGoo
0024Ool00`00Oomoo`0QOol00`00Oomoo`0EOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0025
Ool00`00Oomoo`0POol00`00Oomoo`0EOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0025Ool0
0`00Oomoo`0POol00`00Oomoo`0EOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0025Ool00`00
Oomoo`0OOol00`00Oomoo`0FOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0026Ool00`00Oomo
o`0NOol00`00Oomoo`0FOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0026Ool00`00Oomoo`0N
Ool00`00Oomoo`0FOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0026Ool00`00Oomoo`0MOol0
0`00Oomoo`0GOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0026Ool00`00Oomoo`0MOol00`00
Oomoo`0GOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0027Ool00`00Oomoo`0LOol00`00Oomo
o`0GOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0027Ool00`00Oomoo`0KOol00`00Oomoo`0H
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0028Ool00`00Oomoo`0JOol00`00Oomoo`0HOol0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0028Ool00`00Oomoo`0JOol00`00Oomoo`0HOol00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0028Ool2000JOol00`00Oomoo`0IOol3000IOol01@00Oomo
ogoo0000mGoo0029Ool00`00Oomoo`0HOol00`00Oomoo`0IOol00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo002:Ool00`00Oomoo`0GOol00`00Oomoo`0IOol00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo002:Ool00`00Oomoo`0FOol00`00Oomoo`0JOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
002:Ool00`00Oomoo`0FOol00`00Oomoo`0JOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002:
Ool00`00Oomoo`0EOol00`00Oomoo`0KOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002:Ool0
0`00Oomoo`0EOol00`00Oomoo`0KOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002;Ool00`00
Oomoo`0COol00`00Oomoo`0LOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002;Ool00`00Oomo
o`0COol00`00Oomoo`0LOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002;Ool2000COol00`00
Oomoo`0MOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002<Ool2000BOol00`00Oomoo`0DOol3
0006Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002=Ool00`00Oomoo`0?Ool00`00Oomoo`0F
Ool00`00Oomoo`05Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002>Ool00`00Oomoo`0>Ool0
0`00Oomoo`0FOol00`00Oomoo`05Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002>Ool00`00
Oomoo`0=Ool00`00Oomoo`0COol60006Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002>Ool0
0`00Oomoo`0<Ool00`00Oomoo`0DOol01@00Oomoogoo00001goo100067oo00D007ooOomoo`000?Eo
o`00Sgoo00<007ooOol02goo00<007ooOol05Goo00@007ooOol000Moo`03001oogoo01Uoo`05001o
ogooOol0003eOol008moo`03001oogoo00Yoo`03001oogoo01Moo`03001oo`0000Moo`03001oogoo
01Uoo`05001oogooOol0003eOol008moo`03001oogoo00Yoo`03001oogoo01Moo`03001oo`0000Mo
o`03001oogoo01Uoo`05001oogooOol0003eOol008moo`<000Uoo`03001oogoo01Uoo`8000Moo`03
001oogoo01Uoo`05001oogooOol0003eOol0095oo`8000Moo`03001oogoo01]oo`03001oogoo00Eo
o`03001oogoo01Uoo`05001oogooOol0003eOol0099oo`03001oogoo00Eoo`03001oogoo02=oo`03
001oogoo01Uoo`05001oogooOol0003eOol009=oo`03001oogoo00D002Eoo`03001oogoo01Uoo`05
001oogooOol0003eOol009=oo`@00003Ool0000002Ioo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`<001Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03
001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol0
0<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0
003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uo
o`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`<001Uo
o`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001o
ogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1o
o`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`<0
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03
001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol0
0<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0
003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uo
o`05001oogooOol0003eOol00;Eoo`@000Moo`03001oogoo01Uoo`05001oogooOol0003eOol00;Ao
o`03001oogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03
001oogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001o
ogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`8000=oo`03
001oogoo00Aoo`@001Qoo`05001oogooOol0003eOol00;Aoo`03001oo`00008000Moo`03001oogoo
01Uoo`05001oogooOol0003eOol00;Aoo`03001oogoo00Uoo`03001oogoo01Uoo`05001oogooOol0
003eOol00;Aoo`03001oogoo00Uoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Eoo`03001o
ogoo00Qoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Ioo`<000Moo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03
001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol0
0<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0
003eOol00<1oo`<001Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0
003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uo
o`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001o
ogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1o
o`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`<001Uoo`05001oogoo
Ool0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03
001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol0
0<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0
003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`<001Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uo
o`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001o
ogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1o
o`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00;Eoo`@000Moo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001oogoo
009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001oogoo009o
o`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001oogoo009oo`03
001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001oogoo009oo`03001o
ogoo00Aoo`@001Qoo`D00?Eoo`00]Goo10001goo00<007ooOol0ogoo57oo002dOol00`00Oomoo`02
Ool00`00Oomoo`04Ool00`00Oomoo`3oOolDOol00;Aoo`03001oogoo009oo`03001oogoo00Aoo`03
001oogoo0?mooaAoo`00]7oo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0ogoo57oo002e
Ool40007Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo
57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo
57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo0`00ogoo57oo0030
Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030
Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030
Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030
Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030
Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00
Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00
Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00
Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00
Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo0`00ogoo57oo0030Ool00`00Oomoo`3o
OolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3o
OolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3o
OolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo002/Ool50004Ool40007
Ool00`00Oomoo`3oOolDOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`03
001oogoo0?mooaAoo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo00<007oo
Ool0ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`3o
OolDOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`@00?mooa=oo`00[Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0ogoo6goo002^Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool00`00Oomoo`3oOolKOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo
0?mooa]oo`00[7oo0`001Goo00<007ooOol00Woo00<007ooOol0ogoo6goo0000\
\>"],
  ImageRangeCache->{{{0, 469}, {289.313, 0}} -> {-13.8869, -0.535215, 
  0.0720124, 0.03699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .00292 m
.02436 .00296 L
.02486 .00295 L
.02543 .0029 L
.02598 .00281 L
.02648 .00269 L
.02695 .00255 L
.028 .00215 L
.02855 .00192 L
.02915 .00171 L
.02971 .00157 L
.03023 .00156 L
.0308 .00169 L
.03135 .00194 L
.03259 .00273 L
.0337 .00346 L
.03431 .00379 L
.03488 .00404 L
.03542 .00421 L
.036 .0043 L
.03653 .0043 L
.03701 .00422 L
.03759 .00403 L
.03813 .00377 L
.03872 .00339 L
.03936 .0029 L
.04002 .00235 L
.04035 .00208 L
.04066 .00186 L
.04122 .0016 L
.04184 .00165 L
.04243 .00202 L
.04296 .0025 L
.04418 .00365 L
.04473 .0041 L
.04525 .00446 L
.04578 .00473 L
.04637 .00492 L
.04668 .00496 L
.04702 .00497 L
.04764 .00486 L
.04824 .00461 L
.04879 .00426 L
.04939 .00378 L
.05004 .00313 L
.05073 .00237 L
.05137 .00166 L
.05168 .00136 L
.052 .00114 L
.05236 .00108 L
Mistroke
.05269 .00121 L
.05302 .00146 L
.05332 .00177 L
.0539 .00238 L
.05458 .00308 L
.05531 .00372 L
.05593 .00414 L
.05628 .00432 L
.05661 .00444 L
.0572 .00457 L
.05774 .00457 L
.05804 .00453 L
.05837 .00444 L
.05896 .00418 L
.05926 .00401 L
.0596 .00378 L
.06028 .00324 L
.0615 .00203 L
.0626 .00084 L
.0629 .00054 L
.06323 .00033 L
.0638 .00064 L
.06412 .00093 L
.06446 .00125 L
.06507 .00179 L
.06562 .00222 L
.06622 .00262 L
.06679 .00292 L
.06732 .00312 L
.06788 .00327 L
.06848 .00334 L
.06903 .00333 L
.06956 .00327 L
.07003 .00316 L
.07055 .00301 L
.07171 .00251 L
.073 .0018 L
.07425 .00101 L
.07491 .00059 L
.07527 .00038 L
.07561 .00024 L
.07621 .0004 L
.07652 .00058 L
.07686 .00079 L
.07802 .00149 L
.0791 .00207 L
.08029 .00258 L
.08091 .00278 L
.08149 .00293 L
.08211 .00303 L
Mistroke
.08245 .00306 L
.08277 .00308 L
.08333 .00307 L
.08394 .00302 L
.08452 .00292 L
.08506 .0028 L
.08635 .00239 L
.08698 .00217 L
.08757 .00198 L
.08789 .00189 L
.08824 .00182 L
.08859 .00178 L
.08897 .00178 L
.08929 .00182 L
.08962 .00189 L
.09024 .00213 L
.09145 .00281 L
.09276 .00362 L
.09337 .00395 L
.09401 .00424 L
.09455 .00443 L
.09516 .00456 L
.09574 .0046 L
.09627 .00455 L
.09685 .00441 L
.09747 .00416 L
.09801 .00386 L
.09851 .00354 L
.09964 .00273 L
.10024 .00239 L
.10054 .00228 L
.10087 .00223 L
.10145 .00236 L
.102 .00269 L
.10264 .00324 L
.10323 .0038 L
.10392 .00444 L
.10455 .00495 L
.10511 .0053 L
.10569 .00556 L
.10603 .00564 L
.10634 .00569 L
.10693 .00565 L
.1075 .00548 L
.10802 .0052 L
.10859 .00478 L
.10919 .00422 L
.11023 .00307 L
.1108 .00243 L
.11134 .00196 L
Mistroke
.11184 .00178 L
.11238 .00198 L
.11288 .00241 L
.11333 .00291 L
.11447 .00417 L
.11503 .00469 L
.11553 .00508 L
.11607 .00538 L
.11665 .00556 L
.11695 .0056 L
.11727 .00559 L
.11787 .00546 L
.12033 .00345 L
.12162 .00183 L
.12194 .00145 L
.12227 .00109 L
.12264 .00086 L
.12299 .0009 L
.12331 .00113 L
.12366 .00148 L
.1243 .00218 L
.1255 .00332 L
.12608 .00374 L
.1264 .00393 L
.1267 .00407 L
.12723 .00425 L
.12781 .00435 L
.12834 .00434 L
.12892 .00423 L
.12952 .00402 L
.13008 .00374 L
.13108 .0031 L
.13215 .00225 L
.13341 .00115 L
.13403 .00062 L
.1346 .00021 L
.13512 .00041 L
.13567 .00084 L
.13683 .00171 L
.13794 .00243 L
.139 .00297 L
.13958 .0032 L
.13988 .0033 L
.14021 .0034 L
.14079 .00351 L
.14132 .00357 L
.14187 .00358 L
.14246 .00353 L
.14301 .00342 L
.14353 .00329 L
Mistroke
.1445 .00294 L
.14552 .00249 L
.14611 .00225 L
.14666 .00207 L
.14697 .002 L
.1473 .00196 L
.14788 .00199 L
.14844 .00214 L
.14903 .00241 L
.15008 .00304 L
.15136 .00387 L
.15205 .00428 L
.15269 .00461 L
.15329 .00486 L
.15384 .00504 L
.15444 .00516 L
.15477 .00519 L
.15509 .00519 L
.15562 .00515 L
.15618 .00503 L
.15666 .00486 L
.15719 .00463 L
.15838 .00396 L
.1589 .00367 L
.15947 .0034 L
.16007 .00326 L
.16064 .00331 L
.16096 .00342 L
.1613 .00361 L
.16191 .00406 L
.163 .00506 L
.16358 .00559 L
.16419 .00608 L
.16471 .00642 L
.16528 .00669 L
.16579 .00682 L
.16628 .00684 L
.16677 .00676 L
.16723 .00658 L
.16775 .00627 L
.16824 .00588 L
.16928 .00481 L
.16985 .00417 L
.17039 .00361 L
.17097 .00319 L
.17127 .00309 L
.1716 .0031 L
.17219 .0034 L
.17272 .00392 L
.17387 .00531 L
Mistroke
.17495 .00645 L
.17554 .0069 L
.17588 .00708 L
.17619 .00719 L
.17674 .00727 L
.17732 .00718 L
.17783 .00695 L
.17837 .00656 L
.17888 .00607 L
.17935 .00553 L
.18043 .00404 L
.18103 .0032 L
.18158 .00254 L
.18217 .0022 L
.18248 .00223 L
.18282 .00243 L
.18342 .00305 L
.18396 .00375 L
.1852 .00522 L
.18554 .00554 L
.1859 .00583 L
.18621 .00604 L
.18655 .00621 L
.18687 .00632 L
.18717 .00638 L
.18775 .00637 L
.18828 .00622 L
.18884 .00591 L
.18944 .00545 L
.18999 .0049 L
.19126 .00334 L
.19184 .00255 L
.19216 .00214 L
.19246 .00178 L
.19305 .00131 L
.19358 .00134 L
.19389 .00156 L
.19422 .00187 L
.1948 .00251 L
.19543 .00318 L
.19611 .00381 L
.19671 .00425 L
.19725 .00455 L
.1978 .00475 L
.19831 .00483 L
.19892 .00481 L
.19947 .00468 L
.20008 .00443 L
.20039 .00426 L
.20073 .00404 L
Mistroke
.20288 .00216 L
.2035 .00158 L
.20408 .00112 L
.20461 .00093 L
.20519 .00108 L
.20574 .00144 L
.20624 .00181 L
.20736 .00258 L
.20786 .00286 L
.2084 .00309 L
.20891 .00325 L
.20938 .00334 L
.20992 .00337 L
.21051 .00332 L
.21081 .00327 L
.21114 .00318 L
.21174 .00296 L
.21229 .00268 L
.21289 .00233 L
.21397 .00155 L
.21463 .00106 L
.21495 .00085 L
.21531 .00072 L
.21562 .00073 L
.21595 .00088 L
.21655 .00134 L
.21777 .00247 L
.2189 .00342 L
.21945 .0038 L
.22005 .00413 L
.22065 .00435 L
.22098 .00443 L
.22129 .00446 L
.22186 .00443 L
.22239 .0043 L
.22299 .00406 L
.22356 .00377 L
.22407 .00352 L
.22461 .00334 L
.22512 .00335 L
.22558 .00357 L
.22613 .0041 L
.22672 .00494 L
.22779 .00682 L
.22883 .0087 L
.22993 .0104 L
.23026 .0108 L
.23057 .01112 L
.23115 .01159 L
.23169 .01185 L
Mistroke
.23228 .01194 L
.23285 .01186 L
.23317 .01177 L
.23348 .01167 L
.23409 .01146 L
.23443 .01138 L
.23474 .01136 L
.23527 .01151 L
.23585 .01198 L
.23646 .01287 L
.23702 .01403 L
.23913 .01976 L
.24017 .02233 L
.24062 .02325 L
.24112 .02408 L
.24166 .02474 L
.24222 .0252 L
.24284 .02546 L
.24342 .02553 L
.24394 .02554 L
.24442 .02558 L
.24498 .02574 L
.2455 .02611 L
.24609 .02685 L
.24642 .02744 L
.24672 .02809 L
.24786 .03138 L
.24999 .03885 L
.2511 .04203 L
.25173 .0434 L
.25232 .04438 L
.25294 .04513 L
.25351 .04564 L
.25412 .0461 L
.25477 .04662 L
.2553 .04716 L
.25587 .04798 L
.2564 .04898 L
.25689 .05017 L
.258 .05366 L
.25919 .05826 L
.26336 .07137 L
.2826 .13236 L
.30113 .19292 L
.31047 .22145 L
.31454 .23519 L
.31566 .23962 L
.31627 .24157 L
.31684 .243 L
.31732 .24393 L
Mistroke
.31784 .24463 L
.31842 .24511 L
.31895 .24534 L
.31951 .2455 L
.32011 .24566 L
.32042 .24579 L
.32077 .24599 L
.32137 .24657 L
.32195 .24739 L
.32256 .24862 L
.32367 .25158 L
.3258 .25794 L
.32638 .25934 L
.32701 .26051 L
.32759 .26129 L
.32813 .26174 L
.32874 .26197 L
.32909 .262 L
.32941 .26197 L
.32999 .26184 L
.33061 .26167 L
.33092 .2616 L
.33126 .26155 L
.33186 .26156 L
.33223 .26165 L
.33258 .26181 L
.33289 .262 L
.33323 .26226 L
.33385 .26288 L
.33441 .26356 L
.33566 .2653 L
.33622 .26606 L
.33683 .26679 L
.33739 .26734 L
.33791 .26772 L
.33848 .26796 L
.339 .26802 L
.33957 .26791 L
.3399 .26776 L
.3402 .26758 L
.34075 .26714 L
.34136 .26651 L
.3426 .265 L
.34367 .26372 L
.34424 .26316 L
.34483 .26269 L
.34535 .26242 L
.34591 .26226 L
.34643 .26224 L
.34691 .2623 L
Mistroke
.34752 .26246 L
.34784 .26256 L
.34818 .26266 L
.34848 .26273 L
.3488 .26277 L
.34938 .26273 L
.34994 .2625 L
.35053 .26198 L
.3511 .2612 L
.35161 .26024 L
.35663 .24765 L
.37521 .20189 L
.39308 .14647 L
.40211 .1132 L
.4121 .07948 L
.41431 .07685 L
.41484 .07626 L
.41542 .07543 L
.41605 .0742 L
.41663 .07268 L
.41797 .06783 L
.41919 .06215 L
.42041 .05639 L
.42094 .05421 L
.42153 .05225 L
.42208 .05092 L
.42259 .05013 L
.42314 .04973 L
.42372 .0497 L
.42402 .04979 L
.42436 .04993 L
.42496 .05019 L
.42555 .0503 L
.42609 .05013 L
.42666 .04959 L
.42719 .04867 L
.42766 .04751 L
.42818 .0459 L
.4304 .03608 L
.43151 .03133 L
.43183 .03026 L
.43213 .02942 L
.4327 .02833 L
.43323 .02793 L
.43372 .02801 L
.43427 .02849 L
.43484 .02924 L
.43542 .03001 L
.43572 .03037 L
.43604 .03067 L
Mistroke
.43662 .03098 L
.43716 .0309 L
.43746 .03068 L
.43779 .03031 L
.43838 .02928 L
.43874 .02842 L
.43908 .02748 L
.43971 .02539 L
.4409 .02081 L
.442 .01664 L
.44256 .01501 L
.44316 .01386 L
.4435 .01354 L
.44382 .01344 L
.44443 .01376 L
.44475 .01412 L
.44509 .01459 L
.4457 .01551 L
.44605 .01601 L
.44642 .01648 L
.44675 .01683 L
.44709 .0171 L
.44741 .01725 L
.44776 .01731 L
.44838 .01713 L
.44898 .0166 L
.44954 .01582 L
.45014 .01474 L
.45076 .01335 L
.45189 .01054 L
.45252 .00897 L
.45321 .00748 L
.45354 .0069 L
.45385 .00645 L
.45444 .00595 L
.45498 .00588 L
.45549 .00609 L
.45605 .00648 L
.45664 .00695 L
.45695 .00718 L
.45729 .0074 L
.45791 .00769 L
.45851 .00781 L
.45907 .00778 L
.45957 .00763 L
.4601 .00737 L
.46061 .00704 L
.46107 .00669 L
.46328 .00483 L
.46437 .00411 L
Mistroke
.46499 .00381 L
.46557 .00357 L
.46773 .00261 L
.46825 .00229 L
Mfstroke
.46825 .00229 m
.46864 .00205 L
.46906 .00182 L
.46946 .00163 L
.46984 .00148 L
.47024 .00133 L
.47063 .0012 L
.47105 .00108 L
.47145 .00097 L
.47183 .00088 L
.47224 .00079 L
.47263 .00072 L
.47301 .00065 L
.47341 .00059 L
.4738 .00053 L
.47421 .00048 L
.47461 .00043 L
.47499 .00039 L
.4754 .00035 L
.47579 .00031 L
.47621 .00028 L
.47661 .00026 L
.47699 .00024 L
.47719 .00023 L
.4774 .00022 L
.4775 .00022 L
.4776 .00022 L
.47769 .00022 L
.47778 .00022 L
s
.47778 .00022 m
.47839 .00021 L
.47895 .00021 L
.4796 .00021 L
.48021 .00021 L
.48077 .00021 L
.4813 .00021 L
.48187 .00022 L
.48248 .00022 L
.48374 .00023 L
.48492 .00025 L
.48762 .0003 L
.498 .00051 L
.50084 .00056 L
.50354 .00059 L
.50472 .00061 L
.50597 .00062 L
.50669 .00062 L
.50734 .00063 L
.50795 .00063 L
.50862 .00063 L
.50934 .00063 L
.50973 .00063 L
.51009 .00063 L
.51075 .00063 L
.51111 .00063 L
.51145 .00063 L
.51184 .00063 L
.5122 .00063 L
.5126 .00063 L
.51302 .00063 L
.51372 .00063 L
.5145 .00063 L
.51588 .00062 L
.51736 .0006 L
.52005 .00057 L
.52264 .00053 L
.52506 .00049 L
.53054 .00037 L
.53622 .00022 L
.53901 .00014 L
.54023 .00011 L
.54158 7e-005 L
.5422 6e-005 L
.54287 4e-005 L
.5435 3e-005 L
.54407 2e-005 L
.54472 3e-005 L
.54509 4e-005 L
.54543 5e-005 L
Mistroke
.54671 8e-005 L
.55228 .00022 L
.55696 .00032 L
.56201 .00041 L
.5649 .00044 L
.56617 .00045 L
.56756 .00047 L
.56887 .00047 L
.57009 .00048 L
.57077 .00048 L
.57139 .00049 L
.57173 .00049 L
.5721 .00049 L
.57277 .00049 L
.57338 .00049 L
.57394 .00049 L
.57456 .00049 L
.57523 .00049 L
.57589 .00048 L
.57659 .00048 L
.57784 .00048 L
.579 .00047 L
.58007 .00046 L
.58252 .00044 L
.58517 .00041 L
.58804 .00036 L
.59324 .00027 L
.59828 .00017 L
.60298 7e-005 L
.60421 4e-005 L
.60481 3e-005 L
.60537 2e-005 L
.60602 1e-005 L
.60636 2e-005 L
.60672 2e-005 L
.60794 5e-005 L
.6134 .00016 L
.6187 .00025 L
.62148 .0003 L
.62442 .00033 L
.62695 .00036 L
.62829 .00037 L
.62973 .00038 L
.63105 .00039 L
.63225 .00039 L
.63283 .00039 L
.63346 .0004 L
.63405 .0004 L
.6346 .0004 L
.63515 .0004 L
Mistroke
.63574 .0004 L
.6363 .0004 L
.63681 .0004 L
.6374 .0004 L
.63805 .0004 L
.63867 .0004 L
.63924 .00039 L
.64049 .00039 L
.64162 .00038 L
.64416 .00037 L
.64671 .00034 L
.64941 .00032 L
.65424 .00025 L
.6595 .00017 L
.66239 .00011 L
.66514 6e-005 L
.66639 4e-005 L
.66771 2e-005 L
.66805 1e-005 L
.66841 1e-005 L
.6688 1e-005 L
.66917 1e-005 L
.66951 2e-005 L
.66987 2e-005 L
.67052 4e-005 L
.67542 .00012 L
.68045 .0002 L
.68502 .00026 L
.68742 .00028 L
.69002 .0003 L
.69145 .00031 L
.69277 .00032 L
.69411 .00033 L
.69536 .00033 L
.69643 .00034 L
.69703 .00034 L
.69758 .00034 L
.69818 .00034 L
.69884 .00034 L
.69946 .00034 L
.70003 .00034 L
.70068 .00034 L
.70129 .00034 L
.70183 .00034 L
.70242 .00033 L
.70375 .00033 L
.70497 .00033 L
.70744 .00031 L
.71009 .00029 L
.71485 .00024 L
Mistroke
.72568 .0001 L
.72827 6e-005 L
.72969 3e-005 L
.73102 1e-005 L
.73171 1e-005 L
.7321 1e-005 L
.73245 1e-005 L
.73403 3e-005 L
.73682 8e-005 L
.74228 .00015 L
.74736 .00021 L
.75216 .00026 L
.75485 .00027 L
.75729 .00029 L
.75869 .00029 L
.75997 .00029 L
.76064 .00029 L
.76103 .00029 L
.76138 .0003 L
.76175 .0003 L
.76215 .0003 L
.76252 .0003 L
.76287 .0003 L
.76351 .0003 L
.76418 .0003 L
.76476 .00029 L
.76539 .00029 L
.76607 .00029 L
.76681 .00029 L
.76813 .00029 L
.77073 .00027 L
.77314 .00026 L
.77862 .00021 L
.78429 .00015 L
.78966 8e-005 L
.79215 4e-005 L
.79351 3e-005 L
.79418 2e-005 L
.79479 1e-005 L
.79546 1e-005 L
.79582 1e-005 L
.79617 1e-005 L
.79769 3e-005 L
.80036 7e-005 L
.81008 .00018 L
.81511 .00022 L
.81792 .00024 L
.81925 .00025 L
.82046 .00025 L
.8216 .00026 L
Mistroke
.82285 .00026 L
.82345 .00026 L
.8241 .00026 L
.82479 .00026 L
.82542 .00026 L
.82603 .00026 L
.82668 .00026 L
.8273 .00026 L
.82787 .00026 L
.82838 .00026 L
.82895 .00026 L
.83009 .00026 L
.83133 .00026 L
.83267 .00025 L
.83539 .00024 L
.8379 .00022 L
.84023 .00021 L
.84585 .00016 L
.85115 .0001 L
.8563 3e-005 L
.85771 2e-005 L
.85842 1e-005 L
.85883 0 L
.8592 0 L
.85988 1e-005 L
.86049 2e-005 L
.86188 4e-005 L
.87161 .00014 L
.87678 .00019 L
.87926 .00021 L
.88158 .00022 L
.88408 .00023 L
.88541 .00023 L
.88609 .00024 L
.88684 .00024 L
.88753 .00024 L
.88826 .00024 L
.88867 .00024 L
.88904 .00024 L
.88941 .00024 L
.88976 .00024 L
.89043 .00024 L
.89104 .00024 L
.89172 .00024 L
.89206 .00024 L
.89244 .00024 L
.89311 .00024 L
.89374 .00024 L
.89516 .00023 L
.89641 .00023 L
Mistroke
.89774 .00023 L
.9026 .0002 L
.90555 .00018 L
.90833 .00015 L
.91352 .0001 L
.91864 5e-005 L
.92121 2e-005 L
.92192 1e-005 L
.9223 1e-005 L
.92267 0 L
.92301 0 L
.92338 1e-005 L
.92404 1e-005 L
.9337 .00012 L
.93904 .00016 L
.94405 .0002 L
.94657 .00021 L
.94787 .00021 L
.94928 .00022 L
.95075 .00022 L
.95155 .00022 L
.95193 .00022 L
.95229 .00022 L
.95263 .00022 L
.95299 .00022 L
.95363 .00022 L
.95399 .00022 L
.95437 .00022 L
.95505 .00022 L
.95568 .00022 L
.95637 .00022 L
.95703 .00022 L
.95763 .00022 L
.95877 .00022 L
.95999 .00022 L
.96278 .0002 L
.9653 .00019 L
.97024 .00016 L
.97488 .00012 L
.97619 .00011 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0?moomMoo`003gooo`00^00047oo000JOol:00000goo001oo`0400000goo000000020002Ool70000
17oo000000000goo0P0000Aoo`00001oo`@0009oo`H000=oo`8000=oo`80009oo`<0009oo`<00004
Ool00000Ool400000goo000000020008Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;
Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool30003Ool00`00
Oomoo`07Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00
Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00
Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00
Oomoo`0;Ool00`00Oomoo`0IOol001moo`04001oogooOol30002Ool2000;Ool00`00Oomoo`030002
Ool30002Ool20003Ool20009Ool30002Ool01000Ool007oo0P0000=oo`00Ool00`000Woo0`0027oo
0`0027oo00<007ooOol0@Woo00<007ooOol04goo0P000Woo00<007oo00000goo00<007ooOol08goo
00<007ooOol0@Woo00<007ooOol0@goo00<007ooOol0@Woo001HOol01000Oomoogoo0P005Goo00<0
07ooOol0BWoo00<007ooOol04goo10000Woo00D007ooOomoo`000?Eoo`00M7oo00<007ooOol0BGoo
00<007ooOol04Woo00<007ooOol017oo00D007ooOomoo`000?Eoo`00M7oo1000B7oo00<007ooOol0
4Goo00<007ooOol01Goo00D007ooOomoo`000?Eoo`00Mgoo00<007ooOol0AWoo00<007ooOol03Woo
0P0000=oo`00Ool01Woo00D007ooOomoo`000?Eoo`00N7oo00<007ooOol0AGoo00<007ooOol03Woo
10001goo00D007ooOomoo`000?Eoo`00N7oo00<007ooOol0AGoo00<007ooOol03Goo00<007ooOol0
2Goo00D007ooOomoo`000?Eoo`00N7oo00<007ooOol0AGoo00<007ooOol03Goo00<007ooOol02Goo
00D007ooOomoo`000?Eoo`00NGoo00<007ooOol0A7oo00<007ooOol03Goo00<007ooOol02Goo00D0
07ooOomoo`000?Eoo`00NGoo0`00A7oo00<007ooOol03Goo00<007ooOol02Goo00D007ooOomoo`00
0?Eoo`00Ngoo00<007ooOol0@Woo00<007ooOol02Woo00<007oo000037oo00D007ooOomoo`000?Eo
o`00O7oo00<007ooOol0@Goo0`002Goo00@007oo000000aoo`05001oogooOol0003eOol007aoo`03
001oogoo045oo`03001oogoo00Uoo`03001oogoo00eoo`05001oogooOol0003eOol007eoo`03001o
ogoo041oo`03001oogoo00Uoo`03001oogoo00eoo`05001oogooOol0003eOol007eoo`03001oogoo
041oo`03001oogoo00Uoo`03001oogoo00eoo`05001oogooOol0003eOol007eoo`03001oogoo041o
o`03001oogoo00Uoo`03001oogoo00eoo`05001oogooOol0003eOol007eoo`03001oogoo041oo`03
001oogoo00Qoo`03001oogoo00ioo`05001oogooOol0003eOol007eoo`80045oo`03001oogoo00Qo
o`03001oogoo00ioo`05001oogooOol0003eOol007ioo`80041oo`03001oogoo00Moo`80011oo`05
001oogooOol0003eOol007moo`03001oogoo03ioo`03001oogoo00Eoo`<0015oo`05001oogooOol0
003eOol0081oo`03001oogoo03eoo`03001oogoo00Eoo`<0015oo`05001oogooOol0003eOol0081o
o`03001oogoo03eoo`03001oogoo00Aoo`8001=oo`05001oogooOol0003eOol0085oo`03001oogoo
03aoo`03001oogoo00Aoo`03001oogoo019oo`05001oogooOol0003eOol0085oo`03001oogoo03ao
o`03001oogoo00Aoo`03001oogoo019oo`05001oogooOol0003eOol0085oo`03001oogoo03aoo`03
001oogoo00Aoo`03001oogoo019oo`05001oogooOol0003eOol0085oo`03001oogoo03aoo`<000Ao
o`03001oogoo019oo`05001oogooOol0003eOol0089oo`03001oogoo03]oo`03001oogoo00=oo`03
001oogoo01=oo`05001oogooOol0003eOol0089oo`03001oogoo03]oo`03001oogoo00=oo`03001o
ogoo01=oo`05001oogooOol0003eOol0089oo`03001oogoo03]oo`03001oogoo00=oo`03001oogoo
01=oo`05001oogooOol0003eOol0089oo`03001oogoo03]oo`03001oogoo00=oo`03001oogoo01=o
o`05001oogooOol0003eOol0089oo`03001oogoo03]oo`03001oogoo009oo`03001oogoo01Aoo`05
001oogooOol0003eOol008=oo`03001oogoo03Yoo`03001oogoo009oo`03001oogoo01Aoo`05001o
ogooOol0003eOol008=oo`03001oogoo03Yoo`05001oogooOol0000GOol01@00Oomoogoo0000mGoo
0023Ool00`00Oomoo`0jOol01@00Oomoogoo00005goo00D007ooOomoo`000?Eoo`00Q7oo00<007oo
Ool0>Goo00@007ooOol001Qoo`05001oogooOol0003eOol008Aoo`03001oogoo03Uoo`04001oogoo
000HOol01@00Oomoogoo0000mGoo0024Ool00`00Oomoo`0iOol01000Oomoo`0067oo00D007ooOomo
o`000?Eoo`00QGoo00<007ooOol0>7oo00<007oo00006Goo00D007ooOomoo`000?Eoo`00QGoo00<0
07ooOol0>7oo0`006Goo00D007ooOomoo`000?Eoo`00QGoo00<007ooOol0>7oo00<007oo00006Goo
00D007ooOomoo`000?Eoo`00QWoo00<007ooOol0=goo0P006Woo00D007ooOomoo`000?Eoo`00QWoo
00<007ooOol0=goo0P006Woo00D007ooOomoo`000?Eoo`00QWoo00<007ooOol0=goo0P006Woo00D0
07ooOomoo`000?Eoo`00Qgoo00<007ooOol0=Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00
Qgoo00<007ooOol0=Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00Qgoo00<007ooOol0=Woo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00R7oo00<007ooOol0=7oo0P006goo00D007ooOomo
o`000?Eoo`00R7oo00<007ooOol0=7oo0P006goo00D007ooOomoo`000?Eoo`00R7oo00<007ooOol0
:Goo1P001Goo0P006goo00D007ooOomoo`000?Eoo`00RGoo00<007ooOol0:7oo00<007ooOol01goo
00<007oo00006goo00D007ooOomoo`000?Eoo`00RGoo00<007ooOol0:Goo00<007ooOol01Woo00<0
07oo00006goo00D007ooOomoo`000?Eoo`00RGoo00<007ooOol0:Woo00<007ooOol01Goo00<007oo
00006goo00D007ooOomoo`000?Eoo`00RWoo00<007ooOol0:Woo00<007ooOol017oo00<007oo0000
0`0067oo00D007ooOomoo`000?Eoo`00RWoo00<007ooOol0:goo00<007ooOol00Woo00@007ooOol0
01]oo`05001oogooOol0003eOol008Yoo`03001oogoo02aoo`05001oogooOol00002Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo002;Ool00`00Oomoo`0[Ool01@00Oomoogoo00000Woo00<007oo
Ool06Goo00D007ooOomoo`000?Eoo`00Rgoo00<007ooOol09Woo00<007ooOol00Woo00D007ooOomo
o`00009oo`03001oogoo01Uoo`05001oogooOol0003eOol008]oo`03001oogoo02Moo`@000=oo`05
001oogooOol0000KOol01@00Oomoogoo0000mGoo002<Ool00`00Oomoo`0]Ool01@00Oomoogoo0000
6goo00D007ooOomoo`000?Eoo`00S7oo00<007ooOol0;Goo00D007ooOomoo`0001]oo`05001oogoo
Ool0003eOol008aoo`03001oogoo02eoo`05001oogooOol0000KOol01@00Oomoogoo0000mGoo002=
Ool00`00Oomoo`0[Ool00`00Oomoo`02Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002=Ool0
0`00Oomoo`0[Ool00`00Oomoo`02Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002=Ool00`00
Oomoo`0[Ool00`00Oomoo`02Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002=Ool00`00Oomo
o`0ZOol00`00Oomoo`03Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002>Ool00`00Oomoo`0Y
Ool00`00Oomoo`03Ool3000IOol01@00Oomoogoo0000mGoo002>Ool00`00Oomoo`0YOol00`00Oomo
o`03Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002>Ool00`00Oomoo`0XOol00`00Oomoo`04
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002?Ool00`00Oomoo`0WOol00`00Oomoo`04Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo002?Ool00`00Oomoo`0WOol00`00Oomoo`04Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo002?Ool00`00Oomoo`0VOol00`00Oomoo`05Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo002@Ool00`00Oomoo`0UOol00`00Oomoo`05Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo002@Ool00`00Oomoo`0UOol00`00Oomoo`05Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo002@Ool00`00Oomoo`0TOol00`00Oomoo`06Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo002AOol00`00Oomoo`0SOol00`00Oomoo`06Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo002AOol00`00Oomoo`0SOol00`00Oomoo`06Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo002AOol00`00Oomoo`0ROol00`00Oomoo`07Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo002AOol00`00Oomoo`0ROol00`00Oomoo`07Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
002BOol00`00Oomoo`0QOol00`00Oomoo`07Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002B
Ool00`00Oomoo`0POol00`00Oomoo`08Ool3000IOol01@00Oomoogoo0000mGoo002BOol00`00Oomo
o`0POol00`00Oomoo`08Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002COol00`00Oomoo`0O
Ool00`00Oomoo`08Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002COol00`00Oomoo`0NOol0
0`00Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002COol00`00Oomoo`0NOol00`00
Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002DOol00`00Oomoo`0MOol00`00Oomo
o`09Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002DOol00`00Oomoo`0LOol00`00Oomoo`0:
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002DOol00`00Oomoo`0LOol00`00Oomoo`0:Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo002EOol00`00Oomoo`0KOol00`00Oomoo`0:Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo002EOol00`00Oomoo`0JOol00`00Oomoo`0;Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo002EOol00`00Oomoo`0JOol00`00Oomoo`0;Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo002EOol00`00Oomoo`0IOol00`00Oomoo`0<Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo002FOol00`00Oomoo`0HOol00`00Oomoo`0<Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo002FOol00`00Oomoo`0HOol00`00Oomoo`0<Ool3000IOol01@00Oomoogoo0000
mGoo002FOol00`00Oomoo`0GOol00`00Oomoo`0=Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
002GOol00`00Oomoo`0FOol00`00Oomoo`0=Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002G
Ool00`00Oomoo`0EOol00`00Oomoo`0>Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002GOol0
0`00Oomoo`0EOol00`00Oomoo`0>Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002HOol00`00
Oomoo`0DOol00`00Oomoo`0>Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002HOol00`00Oomo
o`0COol00`00Oomoo`0?Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002HOol00`00Oomoo`0C
Ool00`00Oomoo`0?Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002IOol00`00Oomoo`0AOol0
0`00Oomoo`0@Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002IOol00`00Oomoo`0AOol00`00
Oomoo`0@Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002IOol00`00Oomoo`0AOol00`00Oomo
o`07Ool30006Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002JOol00`00Oomoo`0?Ool00`00
Oomoo`09Ool00`00Oomoo`05Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002JOol00`00Oomo
o`0?Ool00`00Oomoo`09Ool00`00Oomoo`05Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002J
Ool3000>Ool00`00Oomoo`06Ool60006Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002LOol0
0`00Oomoo`0<Ool00`00Oomoo`06Ool01@00Oomoogoo00001goo100067oo00D007ooOomoo`000?Eo
o`00WGoo00<007ooOol02goo00<007ooOol01goo00@007ooOol000Moo`03001oogoo01Uoo`05001o
ogooOol0003eOol009eoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oo`0000Moo`03001oogoo
01Uoo`05001oogooOol0003eOol009ioo`03001oogoo00Uoo`03001oogoo00Uoo`03001oo`0000Mo
o`03001oogoo01Uoo`05001oogooOol0003eOol009ioo`03001oogoo00Qoo`03001oogoo00]oo`80
00Moo`03001oogoo01Uoo`05001oogooOol0003eOol009ioo`03001oogoo00Qoo`03001oogoo00ao
o`03001oogoo00Eoo`03001oogoo01Uoo`05001oogooOol0003eOol009ioo`@000Aoo`@001Ioo`03
001oogoo01Uoo`05001oogooOol0003eOol00:5oo`8000=oo`<001Moo`03001oogoo01Uoo`05001o
ogooOol0003eOol00:9oo`800003Ool007oo01Uoo`03001oogoo01Uoo`05001oogooOol0003eOol0
0:=oo`8001]oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uo
o`05001oogooOol0003eOol00<1oo`<001Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uo
o`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001o
ogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1o
o`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`<0
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03
001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol0
0<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0
003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uo
o`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001o
ogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1o
o`<001Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1o
o`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo
01Uoo`05001oogooOol0003eOol00;Eoo`@000Moo`03001oogoo01Uoo`05001oogooOol0003eOol0
0;Aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Ao
o`03001oogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03
001oogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`8000=o
o`03001oogoo00Aoo`@001Qoo`05001oogooOol0003eOol00;Aoo`03001oo`00008000Moo`03001o
ogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001oogoo00Uoo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00;Aoo`03001oogoo00Uoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Eoo`03
001oogoo00Qoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Ioo`<000Moo`03001oogoo01Uo
o`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001o
ogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1o
o`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00<1oo`<001Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03
001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol0
0<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0
003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`<001Uoo`05001o
ogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uo
o`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001o
ogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1o
o`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogoo
Ool0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`<001Uoo`05
001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo
01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03
001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol0
0<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0
003eOol00<1oo`03001oogoo01Uoo`05001oogooOol0003eOol00<1oo`03001oogoo01Uoo`05001o
ogooOol0003eOol00;Eoo`@000Moo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001o
ogoo009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001oogoo
009oo`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001oogoo009o
o`03001oogoo00Aoo`03001oogoo01Uoo`05001oogooOol0003eOol00;Aoo`03001oogoo009oo`03
001oogoo00Aoo`@001Qoo`D00?Eoo`00]Goo10001goo00<007ooOol0ogoo57oo002dOol00`00Oomo
o`02Ool00`00Oomoo`04Ool00`00Oomoo`3oOolDOol00;Aoo`03001oogoo009oo`03001oogoo00Ao
o`03001oogoo0?mooaAoo`00]7oo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0ogoo57oo
002eOol40007Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo0`00ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo
0030Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool0
0`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool0
0`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool0
0`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool0
0`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo0`00ogoo57oo0030Ool00`00Oomo
o`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomo
o`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomo
o`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo002/Ool50004Ool4
0007Ool00`00Oomoo`3oOolDOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Ao
o`03001oogoo0?mooaAoo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo00<0
07ooOol0ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomo
o`3oOolDOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`@00?mooa=oo`00
[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0ogoo6goo002^Ool00`00Oomoo`03Ool0
0`00Oomoo`02Ool00`00Oomoo`3oOolKOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001o
ogoo0?mooa]oo`00[7oo0`001Goo00<007ooOol00Woo00<007ooOol0ogoo6goo0000\
\>"],
  ImageRangeCache->{{{0, 469}, {289.313, 0}} -> {-13.8869, -0.535215, 
  0.0720124, 0.03699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .00404 m
.02598 .00228 L
.02702 .00114 L
.02753 .00057 L
.028 .00025 L
.02855 .0007 L
.02916 .00133 L
.03022 .00229 L
.03081 .00273 L
.03137 .00306 L
.03195 .00332 L
.03226 .00341 L
.03259 .00348 L
.0332 .00354 L
.03377 .0035 L
.0341 .00344 L
.0344 .00336 L
.03506 .00311 L
.03565 .00282 L
.03628 .00245 L
.03742 .00167 L
.03854 .00085 L
.03915 .0004 L
.03972 .00015 L
.04021 .0004 L
.04073 .00073 L
.04184 .00138 L
.04248 .00169 L
.04315 .00198 L
.04374 .00218 L
.04437 .00236 L
.04472 .00243 L
.04504 .00249 L
.04535 .00253 L
.04568 .00256 L
.04603 .00258 L
.04637 .00258 L
.04673 .00257 L
.04712 .00254 L
.04746 .00249 L
.04777 .00244 L
.04847 .00229 L
.04909 .00211 L
.04974 .00188 L
.05089 .00142 L
.05152 .00117 L
.05212 .00098 L
.0527 .00089 L
.05303 .0009 L
.05333 .00094 L
Mistroke
.05386 .00111 L
.05443 .00135 L
.05659 .00246 L
.05723 .00276 L
.05792 .00304 L
.05857 .00325 L
.05917 .00339 L
.05971 .00346 L
.0603 .00349 L
.0606 .00347 L
.06092 .00343 L
.0615 .00332 L
.06207 .00313 L
.0627 .00286 L
.06398 .00216 L
.06454 .00185 L
.06516 .00161 L
.06573 .00159 L
.06626 .00176 L
.06656 .00193 L
.06689 .00215 L
.06747 .00261 L
.06878 .00368 L
.0695 .00416 L
.06985 .00436 L
.07017 .0045 L
.07078 .00469 L
.0711 .00474 L
.07143 .00476 L
.07202 .00469 L
.07255 .00451 L
.07316 .00419 L
.07375 .00377 L
.0748 .00279 L
.07537 .00219 L
.07591 .00168 L
.07649 .00135 L
.0768 .00135 L
.07713 .00151 L
.07772 .00203 L
.07826 .00262 L
.07896 .00338 L
.07961 .00402 L
.08024 .00453 L
.08083 .00487 L
.08134 .00507 L
.08189 .00515 L
.08243 .00511 L
.08304 .00492 L
.08362 .0046 L
Mistroke
.08425 .0041 L
.0854 .0029 L
.08594 .00223 L
.08653 .00149 L
.0871 .00087 L
.08762 .00072 L
.08813 .00115 L
.0886 .00168 L
.08965 .00285 L
.09025 .00342 L
.09089 .0039 L
.09144 .0042 L
.09204 .0044 L
.09238 .00446 L
.09268 .00447 L
.09304 .00445 L
.09337 .00439 L
.09397 .00418 L
.09431 .00401 L
.09462 .00383 L
.09688 .00191 L
.09749 .00127 L
.09814 .0006 L
.0987 4e-005 L
.0993 .00055 L
.10043 .00153 L
.10105 .00199 L
.10163 .00235 L
.10218 .00263 L
.10277 .00287 L
.10331 .00303 L
.1038 .00313 L
.10431 .00318 L
.10478 .00319 L
.1053 .00315 L
.10585 .00307 L
.10643 .00293 L
.10699 .00276 L
.10802 .00233 L
.11025 .00111 L
.11056 .00094 L
.11089 .00077 L
.1115 .00061 L
.11208 .00072 L
.11262 .00098 L
.11389 .00176 L
.11523 .00254 L
.11638 .00307 L
.11703 .0033 L
.11764 .00346 L
Mistroke
.11823 .00356 L
.11853 .00359 L
.11886 .00361 L
.11944 .00359 L
.11999 .00353 L
.12031 .00347 L
.12063 .0034 L
.12121 .00322 L
.12253 .00267 L
.12308 .00242 L
.1236 .0022 L
.1242 .00203 L
.12475 .002 L
.12535 .00213 L
.12569 .00228 L
.126 .00246 L
.12716 .0033 L
.12813 .00405 L
.12917 .00472 L
.12977 .005 L
.13031 .00515 L
.13086 .00522 L
.13138 .00518 L
.13191 .00504 L
.13248 .00478 L
.13297 .00447 L
.13351 .00405 L
.13462 .00301 L
.1352 .00247 L
.13553 .00223 L
.13583 .00208 L
.13644 .00206 L
.13702 .00242 L
.13755 .00295 L
.13812 .0036 L
.13929 .00486 L
.13989 .00537 L
.14023 .0056 L
.14054 .00578 L
.1411 .00598 L
.1417 .00605 L
.14225 .00595 L
.14278 .00572 L
.1433 .00538 L
.14377 .00496 L
.14485 .00372 L
.14547 .0029 L
.14613 .00202 L
.14643 .00167 L
.14675 .00141 L
Mistroke
.14733 .00141 L
.14788 .00193 L
.14839 .00258 L
.14957 .00403 L
.15022 .00468 L
.15083 .00515 L
.15139 .00543 L
.15199 .00559 L
.1523 .0056 L
.15264 .00557 L
.153 .00547 L
.15334 .00534 L
.15394 .00498 L
.15459 .00444 L
.15675 .00188 L
.15737 .00106 L
.15796 .0004 L
.15849 .0006 L
.15906 .00126 L
.16038 .00266 L
.16096 .00314 L
.1616 .00357 L
.16219 .00386 L
.16274 .00405 L
.16332 .00415 L
.16365 .00416 L
.16395 .00415 L
.16456 .00407 L
.16487 .00399 L
.16521 .00388 L
.16581 .00363 L
.16637 .00334 L
.16775 .00244 L
.16901 .00145 L
.16959 .00098 L
.17013 .00059 L
.17069 .00043 L
.17099 .00056 L
.17131 .00078 L
.17252 .00175 L
.1738 .00272 L
.17498 .00343 L
.17565 .00374 L
.17598 .00385 L
.17628 .00395 L
.17686 .00407 L
.17739 .00413 L
.17795 .00413 L
.17827 .00411 L
.17857 .00406 L
Mistroke
.1789 .004 L
.17925 .00392 L
.17989 .00371 L
.18108 .00322 L
.18175 .00293 L
.18212 .00279 L
.18247 .00267 L
.18308 .00254 L
.1834 .00252 L
.18375 .00255 L
.18405 .00261 L
.18438 .00271 L
.18496 .003 L
.18558 .0034 L
.18627 .00392 L
.18742 .00479 L
.18803 .0052 L
.18866 .00557 L
.18924 .00582 L
.18957 .00592 L
.18987 .00598 L
.19041 .00603 L
.19098 .00597 L
.19156 .00579 L
.19211 .00552 L
.19261 .0052 L
.19315 .00478 L
.19425 .00382 L
.19456 .00357 L
.19487 .00337 L
.19543 .00315 L
.19596 .00319 L
.19645 .00346 L
.19699 .00394 L
.19757 .00458 L
.19888 .00609 L
.19952 .00669 L
.20012 .00711 L
.20066 .00734 L
.20123 .00743 L
.2018 .00735 L
.20212 .00723 L
.20243 .00706 L
.20304 .00658 L
.2037 .00586 L
.20491 .0042 L
.20548 .00341 L
.20608 .00275 L
.2066 .00254 L
.20717 .00282 L
Mistroke
.20751 .00318 L
.20783 .00359 L
.20843 .00446 L
.20914 .00546 L
.20979 .00626 L
.21036 .00681 L
.21096 .00721 L
.21131 .00734 L
.21164 .00741 L
.21225 .00736 L
.21279 .00714 L
.21337 .00671 L
.21391 .00615 L
.21441 .00552 L
.21565 .00362 L
.2162 .00272 L
.2168 .00183 L
.21737 .00141 L
.21798 .00179 L
.2183 .0022 L
.21864 .00269 L
.21927 .00359 L
.21986 .00436 L
.22049 .00505 L
.22102 .0055 L
.22161 .00583 L
.22219 .006 L
.22274 .006 L
.22323 .00588 L
.22376 .00563 L
.22435 .00521 L
.22496 .00464 L
.22607 .00333 L
.22702 .00204 L
.22755 .00131 L
.22805 .00065 L
.22864 .00041 L
.22917 .001 L
.23022 .00217 L
.23081 .00271 L
.23144 .00318 L
.23203 .00351 L
.23258 .00371 L
.23307 .00381 L
.23361 .00383 L
.23418 .00376 L
.2347 .00361 L
.235 .00349 L
.23532 .00335 L
.23591 .00302 L
Mistroke
.23701 .00226 L
.23818 .00135 L
.23881 .00088 L
.23916 .00067 L
.23948 .00053 L
.24002 .00056 L
.24059 .00083 L
.24164 .00139 L
.24217 .00163 L
.24274 .00183 L
.24306 .00192 L
.24336 .00198 L
.24394 .00205 L
.24447 .00205 L
.24496 .00199 L
.24549 .00187 L
.24606 .00167 L
.24655 .00144 L
.24701 .00117 L
.24756 .0008 L
.24806 .00041 L
.24865 .00014 L
.24897 .00044 L
.24927 .00074 L
.25039 .00197 L
.25171 .00349 L
.25292 .00476 L
.25348 .00526 L
.254 .00564 L
.25455 .00595 L
.25514 .00616 L
.25575 .00622 L
.2563 .00615 L
.25661 .00607 L
.25694 .00594 L
.25754 .00563 L
.25804 .00536 L
.25858 .00513 L
.25917 .00507 L
.25972 .00531 L
.26002 .00558 L
.26034 .00598 L
.26093 .00695 L
.26204 .00932 L
.26619 .01603 L
.27614 .03084 L
.28516 .04816 L
.30342 .09469 L
.32211 .16171 L
.33069 .19346 L
Mistroke
.3401 .22212 L
.3494 .24313 L
.35001 .24564 L
.35066 .24804 L
.35128 .24985 L
.35186 .25109 L
.35217 .25159 L
.35252 .25199 L
.35289 .25226 L
.35323 .2524 L
.35384 .25242 L
.35417 .25236 L
.35449 .25228 L
.35506 .25217 L
.35559 .25217 L
.35617 .25239 L
.3565 .25264 L
.3568 .25296 L
.3574 .25386 L
.35805 .25519 L
.35923 .25828 L
.36033 .26131 L
.36094 .26278 L
.36151 .26395 L
.36205 .26479 L
.36263 .26543 L
.36316 .26574 L
.36365 .26584 L
.36395 .26581 L
.36428 .26572 L
.36488 .26543 L
.366 .2647 L
.36664 .26431 L
.36696 .26416 L
.36731 .26403 L
.36761 .26396 L
.36793 .26393 L
.36851 .264 L
.36883 .26411 L
.36916 .26428 L
.36977 .2647 L
.37115 .26605 L
.37177 .26672 L
.37244 .26738 L
.37274 .26763 L
.37307 .26786 L
.37365 .26812 L
.3742 .26818 L
.37471 .26803 L
.37527 .26762 L
Mistroke
.37587 .26692 L
.37653 .26585 L
.37716 .26461 L
.37833 .26201 L
.37937 .25988 L
.37996 .25896 L
.38049 .25837 L
.38079 .25815 L
.38112 .25801 L
.38172 .25798 L
.38232 .25819 L
.38287 .25853 L
.38341 .25889 L
.38398 .25918 L
.38431 .25926 L
.38461 .25925 L
.3852 .25895 L
.38578 .25824 L
.38611 .25763 L
.38641 .25693 L
.38702 .25514 L
.38768 .25277 L
.38879 .24812 L
.38938 .24569 L
.39 .24336 L
.39054 .24168 L
.39114 .24031 L
.39169 .23953 L
.39219 .23919 L
.39272 .23915 L
.39323 .23932 L
.39368 .23956 L
.39417 .23978 L
.3947 .23986 L
.39519 .23966 L
.39577 .23897 L
.3963 .23784 L
.40529 .2115 L
.415 .17777 L
.43415 .10944 L
.44368 .08179 L
.45258 .05849 L
.46825 .02847 L
Mfstroke
.46825 .02847 m
.46864 .02522 L
.46906 .02209 L
.46946 .0195 L
.46984 .0173 L
.47024 .01523 L
.47063 .01347 L
.47105 .01182 L
.47145 .01041 L
.47183 .00922 L
.47224 .0081 L
.47263 .00714 L
.47301 .00633 L
.47341 .00556 L
.4738 .00491 L
.47421 .0043 L
.47461 .00379 L
.47499 .00335 L
.4754 .00295 L
.47579 .00262 L
.47621 .00233 L
.47661 .0021 L
.47699 .00192 L
.47719 .00185 L
.4774 .00179 L
.4776 .00175 L
.47778 .00172 L
s
.47778 .00172 m
.48248 .00115 L
.48762 .0007 L
.49022 .00054 L
.49299 .00041 L
.49561 .00032 L
.498 .00026 L
.49937 .00023 L
.50082 .00021 L
.50208 .0002 L
.50343 .00018 L
.50419 .00017 L
.50488 .00017 L
.50558 .00017 L
.50624 .00016 L
.50661 .00016 L
.50701 .00016 L
.50738 .00016 L
.50772 .00016 L
.50812 .00016 L
.50855 .00016 L
.50896 .00016 L
.50933 .00017 L
.50995 .00017 L
.51062 .00017 L
.51182 .00019 L
.51324 .00021 L
.51454 .00023 L
.52005 .00034 L
.5253 .00045 L
.52818 .0005 L
.53088 .00055 L
.53336 .00058 L
.53564 .00061 L
.53685 .00062 L
.53817 .00063 L
.5395 .00064 L
.54023 .00064 L
.5409 .00064 L
.54155 .00064 L
.54215 .00064 L
.54281 .00064 L
.54315 .00064 L
.54351 .00064 L
.54413 .00064 L
.54479 .00064 L
.54541 .00063 L
.54598 .00063 L
.54711 .00062 L
.54835 .00061 L
Mistroke
.5506 .00059 L
.5532 .00056 L
.55597 .00051 L
.56096 .0004 L
.56636 .00026 L
.56919 .00019 L
.57219 .0001 L
.57345 7e-005 L
.57481 3e-005 L
.57521 2e-005 L
.57559 1e-005 L
.57593 1e-005 L
.5763 2e-005 L
.57702 4e-005 L
.57769 6e-005 L
.58275 .00019 L
.58746 .00029 L
.59254 .00039 L
.59544 .00043 L
.59671 .00044 L
.5981 .00046 L
.59933 .00047 L
.60065 .00047 L
.60138 .00048 L
.60204 .00048 L
.6027 .00048 L
.60332 .00048 L
.60391 .00049 L
.60454 .00049 L
.6049 .00049 L
.60523 .00049 L
.60587 .00049 L
.60654 .00049 L
.60716 .00048 L
.60784 .00048 L
.60856 .00048 L
.60974 .00047 L
.61085 .00047 L
.61338 .00045 L
.61612 .00042 L
.61862 .00038 L
.62428 .00028 L
.62906 .00019 L
.63417 8e-005 L
.63568 4e-005 L
.63642 3e-005 L
.6371 1e-005 L
.63773 1e-005 L
.63838 2e-005 L
.63977 5e-005 L
Mistroke
.645 .00016 L
.64993 .00024 L
.65264 .00029 L
.65523 .00032 L
.65762 .00035 L
.66023 .00037 L
.66138 .00038 L
.6626 .00039 L
.66365 .00039 L
.66481 .00039 L
.66551 .0004 L
.66617 .0004 L
.66654 .0004 L
.66687 .0004 L
.66725 .0004 L
.66761 .0004 L
.66826 .0004 L
.66885 .0004 L
.6695 .0004 L
.66983 .0004 L
.67019 .0004 L
.67164 .00039 L
.67245 .00039 L
.6732 .00038 L
.67602 .00037 L
.67848 .00034 L
.68116 .00032 L
.68658 .00024 L
.69186 .00015 L
.69685 6e-005 L
.69819 4e-005 L
.69961 1e-005 L
.69996 1e-005 L
.70035 0 L
.70077 1e-005 L
.70116 2e-005 L
.7026 4e-005 L
.70782 .00013 L
.71312 .00021 L
.71592 .00025 L
.7189 .00028 L
.72177 .0003 L
.72437 .00032 L
.72562 .00033 L
.72697 .00033 L
.7276 .00033 L
.72825 .00034 L
.72881 .00034 L
.72943 .00034 L
.73011 .00034 L
Mistroke
.73075 .00034 L
.73108 .00034 L
.73144 .00034 L
.73183 .00034 L
.73218 .00034 L
.73284 .00034 L
.73344 .00034 L
.73413 .00033 L
.73479 .00033 L
.73712 .00032 L
.73844 .00032 L
.73967 .00031 L
.74497 .00026 L
.75062 .00019 L
.756 .00012 L
.75883 7e-005 L
.76038 5e-005 L
.76182 3e-005 L
.76247 2e-005 L
.76308 1e-005 L
.76342 0 L
.76379 0 L
.76444 1e-005 L
.76732 6e-005 L
.77238 .00013 L
.77771 .0002 L
.78272 .00025 L
.78523 .00026 L
.78794 .00028 L
.78941 .00029 L
.79021 .00029 L
.79095 .00029 L
.79164 .00029 L
.79227 .00029 L
.79297 .00029 L
.79335 .0003 L
.79371 .0003 L
.79431 .0003 L
.79496 .0003 L
.79557 .0003 L
.79613 .00029 L
.79679 .00029 L
.7975 .00029 L
.7988 .00029 L
.80015 .00028 L
.80159 .00028 L
.80418 .00026 L
.80925 .00022 L
.81384 .00017 L
.81874 .00011 L
Mistroke
.82392 4e-005 L
.82523 3e-005 L
.82595 2e-005 L
.82663 1e-005 L
.82702 0 L
.82744 1e-005 L
.82782 1e-005 L
.82817 1e-005 L
.8296 3e-005 L
.83482 .0001 L
.83953 .00016 L
.84461 .00021 L
.84751 .00023 L
.85017 .00024 L
.85272 .00025 L
.854 .00026 L
.85472 .00026 L
.85539 .00026 L
.85604 .00026 L
.85673 .00026 L
.85741 .00026 L
.8578 .00026 L
.85817 .00026 L
.85883 .00026 L
.85943 .00026 L
.85976 .00026 L
.86012 .00026 L
.86078 .00026 L
.86137 .00026 L
.86201 .00026 L
.86332 .00026 L
.86567 .00025 L
.86839 .00023 L
.87133 .00021 L
.87664 .00017 L
.88206 .00011 L
.88711 5e-005 L
.88842 3e-005 L
.88966 1e-005 L
.89034 1e-005 L
.89073 0 L
.89108 0 L
.89171 1e-005 L
.89238 2e-005 L
.89815 9e-005 L
.90308 .00014 L
.90838 .00019 L
.91094 .00021 L
.91338 .00022 L
.91557 .00023 L
Mistroke
.91681 .00023 L
.91795 .00024 L
.91929 .00024 L
.91999 .00024 L
.92035 .00024 L
.92074 .00024 L
.92138 .00024 L
.92198 .00024 L
.92235 .00024 L
.9227 .00024 L
.92336 .00024 L
.92395 .00024 L
.92457 .00024 L
.9257 .00024 L
.92691 .00023 L
.92825 .00023 L
.93098 .00022 L
.93391 .0002 L
.93923 .00016 L
.94972 5e-005 L
.95227 3e-005 L
.953 2e-005 L
.9537 1e-005 L
.95432 0 L
.95499 1e-005 L
.95535 1e-005 L
.95575 1e-005 L
.95655 2e-005 L
.95798 4e-005 L
.96076 7e-005 L
.97619 .0002 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0?moomMoo`003gooo`00^00047oo000JOol2000017oo000000000Woo10000Woo100000=oo`000000
100000Aoo`00001oo`<00003Ool0000000<0009oo`H0009oo`<0009oo`<00003Ool007oo00D00003
Ool0000000D0009oo`8000=oo`80009oo`<0009oo`H0009oo`800003Ool007oo00Yoo`03001oogoo
00]oo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo
00]oo`03001oogoo008000Uoo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`03001o
ogoo00]oo`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`03001o
ogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`03001o
ogoo00Yoo`03001oogoo00]oo`03001oogoo01Uoo`00;Woo0P000Woo10000Woo00<007ooOol03Goo
0P000Woo0`000Woo0`003Goo100000Eoo`00Ool007oo00800003Ool007oo00@000Qoo`03001oogoo
00@003ioo`03001oogoo01Uoo`03001oo`00008002Eoo`03001oogoo049oo`03001oogoo04=oo`03
001oogoo049oo`00Igoo0P000Woo0`004goo00<007ooOol0?7oo00<007ooOol06Goo00D007oo001o
o`000?Eoo`00PWoo00<007ooOol0>goo00<007ooOol06Goo00D007oo001oo`000?Eoo`00Pgoo00<0
07ooOol0>Woo00<007ooOol06Goo0P000Woo00<007ooOol0lgoo0023Ool00`00Oomoo`0jOol00`00
Oomoo`0IOol20002Ool00`00Oomoo`3cOol008Aoo`03001oogoo03Uoo`03001oogoo01Uoo`80009o
o`03001oogoo0?=oo`00QGoo00<007ooOol0>7oo00<007ooOol06Goo0P000Woo00<007ooOol0lgoo
0025Ool00`00Oomoo`0hOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0026Ool00`00Oomoo`0g
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0027Ool00`00Oomoo`0fOol00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0027Ool00`00Oomoo`0fOol00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0028Ool00`00Oomoo`0eOol3000HOol20003Ool00`00Oomoo`3cOol008Uoo`03001oogoo03Aoo`03
001oogoo01Qoo`8000=oo`03001oogoo0?=oo`00RGoo00<007ooOol0=7oo00<007ooOol05goo00<0
07oo00000goo00<007ooOol0lgoo002:Ool00`00Oomoo`0cOol00`00Oomoo`0GOol00`00Ool00003
Ool00`00Oomoo`3cOol008Yoo`03001oogoo03=oo`03001oogoo01Ioo`04001oogoo0003Ool00`00
Oomoo`3cOol008]oo`03001oogoo039oo`03001oogoo01Ioo`04001oogoo0003Ool00`00Oomoo`3c
Ool008]oo`03001oogoo039oo`03001oogoo01Eoo`05001oogooOol00003Ool00`00Oomoo`3cOol0
08aoo`03001oogoo035oo`03001oogoo01Eoo`05001oogooOol00003Ool00`00Oomoo`3cOol008ao
o`03001oogoo035oo`03001oogoo01Aoo`03001oogoo009oo`05001oogooOol0003eOol008aoo`03
001oogoo035oo`03001oogoo01Aoo`03001oogoo009oo`05001oogooOol0003eOol008eoo`03001o
ogoo031oo`03001oogoo01=oo`03001oogoo00=oo`05001oogooOol0003eOol008eoo`03001oogoo
031oo`03001oogoo01=oo`03001oogoo00=oo`05001oogooOol0003eOol008ioo`03001oogoo02mo
o`03001oogoo019oo`03001oogoo00Aoo`05001oogooOol0003eOol008ioo`03001oogoo02moo`03
001oogoo019oo`03001oogoo00Aoo`05001oogooOol0003eOol008ioo`03001oogoo02moo`<0015o
o`03001oogoo00Eoo`05001oogooOol0003eOol008moo`03001oogoo02ioo`03001oogoo015oo`03
001oogoo00Eoo`05001oogooOol0003eOol008moo`03001oogoo02ioo`03001oogoo011oo`03001o
ogoo00Ioo`05001oogooOol0003eOol0091oo`03001oogoo02eoo`03001oogoo011oo`03001oogoo
00Ioo`05001oogooOol0003eOol0091oo`03001oogoo02eoo`03001oogoo011oo`03001oogoo00Io
o`05001oogooOol0003eOol0091oo`03001oogoo02eoo`03001oogoo00moo`03001oogoo00Moo`05
001oogooOol0003eOol0095oo`03001oogoo02aoo`03001oogoo00moo`03001oogoo00Moo`05001o
ogooOol0003eOol0095oo`03001oogoo02aoo`03001oogoo00ioo`03001oogoo00Qoo`05001oogoo
Ool0003eOol0099oo`03001oogoo02]oo`03001oogoo00ioo`03001oogoo00Qoo`05001oogooOol0
003eOol0099oo`03001oogoo02]oo`03001oogoo00ioo`03001oogoo00Qoo`05001oogooOol0003e
Ool0099oo`03001oogoo02]oo`03001oogoo00eoo`03001oogoo00Uoo`05001oogooOol0003eOol0
09=oo`03001oogoo02Yoo`03001oogoo00eoo`03001oogoo00Uoo`05001oogooOol0003eOol009=o
o`03001oogoo02Yoo`03001oogoo00eoo`03001oogoo00Uoo`05001oogooOol0003eOol009Aoo`03
001oogoo02Uoo`<000aoo`03001oogoo00Yoo`05001oogooOol0003eOol009Aoo`03001oogoo02Uo
o`03001oogoo00aoo`03001oogoo00Yoo`05001oogooOol0003eOol009Aoo`03001oogoo02Uoo`03
001oogoo00aoo`03001oogoo00Yoo`05001oogooOol0003eOol009Eoo`03001oogoo02Qoo`03001o
ogoo00aoo`03001oogoo00Yoo`05001oogooOol0003eOol009Eoo`03001oogoo02Qoo`03001oogoo
00]oo`03001oogoo00]oo`05001oogooOol0003eOol009Eoo`03001oogoo02Qoo`03001oogoo00]o
o`03001oogoo00]oo`05001oogooOol0003eOol009Eoo`03001oogoo02Qoo`03001oogoo00]oo`03
001oogoo00]oo`05001oogooOol0003eOol009Ioo`03001oogoo02Moo`03001oogoo00Yoo`03001o
ogoo00aoo`05001oogooOol0003eOol009Ioo`03001oogoo02Moo`03001oogoo00Yoo`03001oogoo
00aoo`05001oogooOol0003eOol009Ioo`03001oogoo02Moo`03001oogoo00Yoo`03001oogoo00ao
o`05001oogooOol0003eOol009Ioo`03001oogoo01]oo`H000Ioo`03001oogoo00Uoo`03001oogoo
00eoo`05001oogooOol0003eOol009Moo`03001oogoo01Yoo`03001oogoo00Uoo`03001oogoo00Uo
o`03001oogoo00eoo`05001oogooOol0003eOol009Moo`03001oogoo01]oo`03001oogoo00Qoo`03
001oogoo00Uoo`03001oogoo00eoo`05001oogooOol0003eOol009Moo`03001oogoo01aoo`03001o
ogoo00Moo`03001oogoo00Uoo`03001oogoo00eoo`05001oogooOol0003eOol009Qoo`03001oogoo
01aoo`03001oogoo00Ioo`@000Moo`03001oogoo00ioo`05001oogooOol0003eOol009Qoo`03001o
ogoo01eoo`03001oogoo00Eoo`03001oogoo00Qoo`03001oogoo00ioo`05001oogooOol0003eOol0
09Qoo`03001oogoo01ioo`03001oogoo00Aoo`03001oogoo00Qoo`03001oogoo00ioo`05001oogoo
Ool0003eOol009Qoo`03001oogoo01ioo`03001oogoo00Aoo`03001oogoo00Qoo`03001oogoo00io
o`05001oogooOol0003eOol009Uoo`03001oogoo01Qoo`03001oogoo009oo`03001oogoo00Aoo`03
001oogoo00Moo`03001oogoo00moo`05001oogooOol0003eOol009Uoo`03001oogoo01Uoo`@000Mo
o`03001oogoo00Moo`03001oogoo00moo`05001oogooOol0003eOol009Uoo`03001oogoo02Aoo`03
001oogoo00Moo`03001oogoo00moo`05001oogooOol0003eOol009Yoo`03001oogoo02=oo`03001o
ogoo00Ioo`03001oogoo011oo`05001oogooOol0003eOol009Yoo`03001oogoo02=oo`03001oogoo
00Ioo`03001oogoo011oo`05001oogooOol0003eOol009Yoo`03001oogoo02=oo`03001oogoo00Io
o`03001oogoo011oo`05001oogooOol0003eOol009Yoo`03001oogoo02=oo`03001oogoo00Ioo`03
001oogoo011oo`05001oogooOol0003eOol009]oo`03001oogoo029oo`03001oogoo00Eoo`03001o
ogoo015oo`05001oogooOol0003eOol009]oo`03001oogoo029oo`03001oogoo00Eoo`03001oogoo
015oo`05001oogooOol0003eOol009]oo`03001oogoo029oo`<000Eoo`03001oogoo015oo`05001o
ogooOol0003eOol009]oo`03001oogoo029oo`03001oogoo00Aoo`03001oogoo019oo`05001oogoo
Ool0003eOol009aoo`03001oogoo025oo`03001oogoo00Aoo`03001oogoo019oo`05001oogooOol0
003eOol009aoo`03001oogoo025oo`03001oogoo00Aoo`03001oogoo019oo`05001oogooOol0003e
Ool009aoo`03001oogoo025oo`03001oogoo00Aoo`03001oogoo019oo`05001oogooOol0003eOol0
09eoo`03001oogoo021oo`03001oogoo00=oo`03001oogoo01=oo`05001oogooOol0003eOol009eo
o`03001oogoo021oo`03001oogoo00=oo`03001oogoo01=oo`05001oogooOol0003eOol009eoo`03
001oogoo021oo`03001oogoo00=oo`03001oogoo01=oo`05001oogooOol0003eOol009eoo`03001o
ogoo021oo`03001oogoo00=oo`03001oogoo01=oo`05001oogooOol0003eOol009ioo`03001oogoo
01moo`03001oogoo009oo`03001oogoo01Aoo`05001oogooOol0003eOol009ioo`03001oogoo01mo
o`03001oogoo009oo`03001oogoo01Aoo`05001oogooOol0003eOol009ioo`03001oogoo01moo`03
001oogoo009oo`03001oogoo01Aoo`05001oogooOol0003eOol009moo`03001oogoo01ioo`05001o
ogooOol0000GOol01@00Oomoogoo0000mGoo002OOol00`00Oomoo`0NOol01@00Oomoogoo00005goo
00D007ooOomoo`000?Eoo`00Wgoo00<007ooOol07Woo0`0000=oo`00Ool05Woo00D007ooOomoo`00
0?Eoo`00Wgoo00<007ooOol07Woo00D007ooOomoo`0001Moo`05001oogooOol0003eOol00:1oo`03
001oogoo01eoo`04001oogoo000HOol01@00Oomoogoo0000mGoo002POol00`00Oomoo`0MOol01000
Oomoo`0067oo00D007ooOomoo`000?Eoo`00X7oo00<007ooOol07Goo00@007ooOol001Qoo`05001o
ogooOol0003eOol00:5oo`03001oogoo01aoo`04001oogoo000HOol01@00Oomoogoo0000mGoo002Q
Ool00`00Oomoo`0LOol00`00Ool0000IOol01@00Oomoogoo0000mGoo002QOol00`00Oomoo`0LOol0
0`00Ool0000IOol01@00Oomoogoo0000mGoo002ROol00`00Oomoo`0KOol00`00Ool0000IOol01@00
Oomoogoo0000mGoo002ROol00`00Oomoo`0KOol00`00Ool0000IOol01@00Oomoogoo0000mGoo002R
Ool00`00Oomoo`0KOol2000JOol01@00Oomoogoo0000mGoo002ROol00`00Oomoo`0KOol2000JOol0
1@00Oomoogoo0000mGoo002SOol00`00Oomoo`0JOol2000JOol01@00Oomoogoo0000mGoo002SOol0
0`00Oomoo`0JOol3000IOol01@00Oomoogoo0000mGoo002SOol00`00Oomoo`0JOol00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo002TOol00`00Oomoo`0IOol00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo002TOol00`00Oomoo`0HOol2000KOol01@00Oomoogoo0000mGoo002TOol00`00Oomoo`0HOol2
000KOol01@00Oomoogoo0000mGoo002UOol00`00Oomoo`0GOol2000KOol01@00Oomoogoo0000mGoo
002UOol00`00Oomoo`0FOol00`00Ool0000KOol01@00Oomoogoo0000mGoo002VOol00`00Oomoo`0E
Ool00`00Ool0000KOol01@00Oomoogoo0000mGoo002VOol00`00Oomoo`0EOol00`00Ool0000KOol0
1@00Oomoogoo0000mGoo002WOol00`00Oomoo`0COol01000Oomoo`006goo00D007ooOomoo`000?Eo
o`00Ygoo00<007ooOol03Goo0`0000Aoo`000000009oo`03001oogoo01Uoo`05001oogooOol0003e
Ool00:Qoo`03001oogoo00eoo`05001oo`00Ool00003Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo002XOol00`00Oomoo`0=Ool00`00Ool00005Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
002XOol00`00Oomoo`09Ool70005Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002YOol00`00
Oomoo`08Ool01000Oomoogoo0P001Woo100067oo00D007ooOomoo`000?Eoo`00ZGoo00<007ooOol0
2Goo00<007ooOol00P001Woo00<007ooOol06Goo00D007ooOomoo`000?Eoo`00ZGoo0`002Woo00@0
07oo000000Ioo`03001oogoo01Uoo`05001oogooOol0003eOol00:aoo`03001oogoo00Moo`04001o
o`000006Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002/Ool00`00Oomoo`08Ool20007Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo002/Ool00`00Oomoo`06Ool40007Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo002]Ool00`00Oomoo`05Ool00`00Oomoo`08Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo002]Ool50002Ool00`00Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo002^Ool20002Ool00`00Ool0000;Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002b
Ool2000<Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3
000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo002eOol40007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002d
Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol0
0`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00
Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol20003Ool0
0`00Oomoo`04Ool4000HOol01@00Oomoogoo0000mGoo002dOol00`00Ool000020007Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo002dOol00`00Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002eOol00`00
Oomoo`08Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002fOol30007Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo002eOol40007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomo
o`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02
Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool0
0`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00
Oomoo`04Ool4000HOol5003eOol00;Eoo`@000Moo`03001oogoo0?mooaAoo`00]7oo00<007ooOol0
0Woo00<007ooOol017oo00<007ooOol0ogoo57oo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool0
0`00Oomoo`3oOolDOol00;Aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0?mooaAoo`00
]Goo10001goo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mo
oaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mo
oaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool3003oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00[7oo1@0017oo1000
1goo00<007ooOol0ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool0
0`00Oomoo`3oOolDOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`03001o
ogoo0?mooaAoo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0
ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool4003oOolCOol00:io
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo0?mooa]oo`00[Woo00<007ooOol00goo00<0
07ooOol00Woo00<007ooOol0ogoo6goo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomo
o`3oOolKOol00:aoo`<000Eoo`03001oogoo009oo`03001oogoo0?mooa]oo`00\
\>"],
  ImageRangeCache->{{{0, 469}, {289.313, 0}} -> {-13.8869, -0.535215, 
  0.0720124, 0.03699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .0027 m
.02436 .00271 L
.02486 .00269 L
.02543 .00263 L
.02598 .00252 L
.02648 .00239 L
.02695 .00223 L
.028 .00181 L
.02855 .00155 L
.02915 .00131 L
.02971 .00115 L
.03023 .00113 L
.0308 .0013 L
.03135 .00158 L
.03259 .00241 L
.0337 .00314 L
.03431 .00347 L
.03488 .00372 L
.03542 .00388 L
.036 .00396 L
.03653 .00395 L
.03701 .00387 L
.03759 .00368 L
.03813 .00342 L
.03872 .00303 L
.03936 .00253 L
.04056 .00146 L
.04117 .00106 L
.04151 .00101 L
.04184 .00112 L
.04217 .00136 L
.04247 .00163 L
.04315 .00233 L
.04437 .0035 L
.04501 .004 L
.04538 .00423 L
.04571 .0044 L
.04606 .00454 L
.04644 .00463 L
.04679 .00467 L
.04712 .00467 L
.04773 .00454 L
.04803 .00443 L
.04837 .00426 L
.04897 .00386 L
.04952 .00339 L
.05086 .00193 L
.05151 .00113 L
.05212 .00054 L
.05267 .00074 L
Mistroke
.05325 .0014 L
.05449 .00279 L
.05507 .00334 L
.05562 .00376 L
.05611 .00406 L
.05665 .00429 L
.05723 .00441 L
.05757 .00443 L
.05788 .0044 L
.05821 .00434 L
.0585 .00425 L
.05885 .0041 L
.05918 .00393 L
.06029 .00312 L
.0615 .00193 L
.0626 .00074 L
.06321 .0001 L
.06377 .00056 L
.06488 .00163 L
.0659 .00243 L
.06645 .00276 L
.06703 .00303 L
.06736 .00315 L
.06768 .00323 L
.06826 .00333 L
.06857 .00334 L
.06888 .00334 L
.06946 .00328 L
.07007 .00313 L
.07042 .00302 L
.07075 .0029 L
.07202 .00228 L
.07322 .00156 L
.07432 .00084 L
.07492 .00044 L
.07548 .00011 L
.07608 .00035 L
.0764 .00055 L
.07674 .00077 L
.07791 .00145 L
.07919 .00207 L
.07989 .00234 L
.08056 .00254 L
.08114 .00267 L
.08147 .00273 L
.08177 .00276 L
.0823 .0028 L
.08287 .0028 L
.0834 .00276 L
.08389 .00269 L
Mistroke
.08443 .00257 L
.08502 .00241 L
.08615 .00201 L
.08735 .00153 L
.08771 .0014 L
.08805 .0013 L
.08835 .00123 L
.08867 .0012 L
.08898 .00121 L
.08931 .00126 L
.0899 .00147 L
.09021 .00162 L
.09055 .0018 L
.09116 .00217 L
.09254 .00303 L
.09321 .0034 L
.09385 .00369 L
.09442 .0039 L
.09474 .00398 L
.09504 .00403 L
.0956 .00408 L
.09612 .00404 L
.0967 .00392 L
.09702 .00381 L
.09732 .00368 L
.09788 .00338 L
.0985 .00296 L
.09915 .00245 L
.09974 .00197 L
.10032 .00159 L
.10093 .00143 L
.10154 .00167 L
.10189 .00194 L
.10221 .00224 L
.10343 .00347 L
.10396 .00397 L
.10454 .00445 L
.1051 .00481 L
.10562 .00505 L
.10612 .00518 L
.10664 .00521 L
.10725 .0051 L
.10783 .00485 L
.10834 .00451 L
.1089 .00404 L
.11018 .0026 L
.11081 .0018 L
.11138 .00117 L
.11198 .001 L
.11232 .00124 L
Mistroke
.11263 .00158 L
.114 .0033 L
.11456 .00393 L
.11516 .00449 L
.11568 .00486 L
.11624 .00515 L
.11685 .0053 L
.11719 .00532 L
.1175 .00528 L
.1181 .0051 L
.11868 .00478 L
.11926 .00433 L
.11989 .00371 L
.12102 .00234 L
.12156 .00161 L
.12213 .00083 L
.12262 .00026 L
.12315 .00067 L
.12433 .00214 L
.12545 .00327 L
.12607 .00373 L
.12639 .00392 L
.12674 .00409 L
.12735 .00428 L
.12792 .00434 L
.12844 .00431 L
.12901 .00417 L
.12954 .00396 L
.13003 .00371 L
.13116 .00292 L
.13235 .0019 L
.13331 .00102 L
.13384 .00056 L
.13433 .00023 L
.13492 .0005 L
.13545 .00092 L
.1365 .00169 L
.13754 .00233 L
.13811 .00261 L
.13866 .00284 L
.13896 .00294 L
.1393 .00304 L
.13988 .00317 L
.14048 .00325 L
.14103 .00326 L
.14133 .00325 L
.14166 .00322 L
.14225 .00312 L
.14283 .00297 L
.14336 .00279 L
Mistroke
.14456 .00226 L
.14583 .0016 L
.14636 .00134 L
.14686 .00116 L
.14743 .00109 L
.14796 .00117 L
.14845 .00137 L
.14891 .00162 L
.14994 .00226 L
.151 .00293 L
.15211 .00355 L
.15269 .00382 L
.153 .00394 L
.15333 .00405 L
.1539 .0042 L
.15444 .00427 L
.15503 .00428 L
.15535 .00425 L
.15566 .00421 L
.15621 .00406 L
.1568 .00382 L
.15782 .00324 L
.15841 .00284 L
.15894 .00248 L
.15948 .00216 L
.16 .00199 L
.16054 .00201 L
.16113 .00231 L
.16164 .00273 L
.16219 .00325 L
.16317 .00424 L
.16372 .00475 L
.1643 .00521 L
.1646 .0054 L
.16494 .00559 L
.16552 .0058 L
.16608 .00588 L
.16667 .00581 L
.16723 .0056 L
.16774 .00529 L
.17019 .00259 L
.17078 .00191 L
.17112 .00167 L
.17142 .00161 L
.17178 .00176 L
.17213 .00208 L
.17279 .00292 L
.17386 .00439 L
.17445 .00508 L
.17501 .00563 L
Mistroke
.17532 .00588 L
.17567 .0061 L
.17627 .00634 L
.17687 .0064 L
.17743 .00628 L
.17795 .00603 L
.17843 .00567 L
.17895 .00516 L
.17952 .00449 L
.18066 .00282 L
.18117 .00202 L
.18172 .00118 L
.18233 .00075 L
.18266 .00103 L
.18297 .00144 L
.18433 .0034 L
.18491 .0041 L
.18552 .00471 L
.18584 .00497 L
.18618 .0052 L
.1868 .00548 L
.1874 .00559 L
.18796 .00555 L
.18826 .00547 L
.18859 .00534 L
.18919 .00499 L
.18976 .00456 L
.19035 .00399 L
.19142 .00279 L
.1926 .0013 L
.19319 .00056 L
.19373 .00017 L
.19421 .00072 L
.19473 .00131 L
.19583 .00241 L
.19644 .00292 L
.19711 .00337 L
.19774 .00371 L
.19831 .00394 L
.19883 .00408 L
.19941 .00416 L
.2 .00416 L
.20056 .00409 L
.20105 .00398 L
.20159 .0038 L
.20255 .00334 L
.20355 .00271 L
.20466 .00189 L
.20528 .00142 L
.20586 .00107 L
Mistroke
.20639 .00095 L
.20697 .00113 L
.20751 .00148 L
.20808 .00194 L
.20911 .00279 L
.21043 .00375 L
.21108 .00414 L
.21167 .00442 L
.21222 .00463 L
.21279 .00478 L
.21337 .00486 L
.21369 .00487 L
.214 .00486 L
.2146 .00479 L
.21517 .00465 L
.21568 .00447 L
.21623 .00422 L
.21737 .00358 L
.21797 .00322 L
.21829 .00306 L
.21863 .00291 L
.21921 .00276 L
.21975 .0028 L
.22026 .00301 L
.22081 .00339 L
.22193 .00445 L
.22313 .00564 L
.22371 .00613 L
.22426 .0065 L
.22475 .00675 L
.22528 .0069 L
.22579 .00693 L
.22633 .00683 L
.22679 .00664 L
.22729 .00631 L
.22845 .00516 L
.22907 .00439 L
.22972 .00355 L
.23004 .00318 L
.23035 .0029 L
.23092 .00267 L
.23145 .0029 L
.23203 .00353 L
.23303 .005 L
.23409 .0065 L
.23471 .00718 L
.23527 .00764 L
.23583 .00791 L
.23636 .008 L
.23697 .00788 L
Mistroke
.23754 .00755 L
.23784 .0073 L
.23817 .00696 L
.23883 .0061 L
.24008 .00399 L
.24074 .00279 L
.2411 .00221 L
.24144 .00181 L
.24204 .00181 L
.24236 .00217 L
.24269 .0027 L
.24385 .00469 L
.24446 .00563 L
.24503 .00636 L
.24555 .00686 L
.24611 .00723 L
.24668 .00741 L
.24721 .00739 L
.24782 .00716 L
.24839 .00673 L
.24892 .00618 L
.24941 .00555 L
.25053 .00378 L
.25111 .00273 L
.25174 .00156 L
.25234 .0005 L
.25288 .00069 L
.25319 .0012 L
.25353 .00177 L
.2542 .00282 L
.25477 .00359 L
.25539 .00429 L
.25573 .0046 L
.25605 .00484 L
.25635 .00502 L
.25668 .00517 L
.25725 .00532 L
.25785 .00531 L
.25819 .00524 L
.2585 .00513 L
.25886 .00495 L
.2592 .00474 L
.26048 .00369 L
.26157 .00256 L
.26217 .00195 L
.26274 .00143 L
.26306 .0012 L
.26341 .00104 L
.26402 .00104 L
.26433 .00115 L
Mistroke
.26464 .00131 L
.26521 .00163 L
.26578 .00191 L
.26608 .00204 L
.2664 .00216 L
.26699 .00231 L
.26753 .00239 L
.26804 .0024 L
.26853 .00236 L
.26906 .00227 L
.26964 .00213 L
.27026 .00197 L
.27084 .00182 L
.27145 .00171 L
.27177 .00169 L
.27211 .00169 L
.27272 .00177 L
.2733 .00193 L
.27438 .00234 L
.27541 .00276 L
.27598 .00296 L
.27651 .00311 L
.27696 .00321 L
.27745 .00327 L
.27799 .0033 L
.27848 .00327 L
.27905 .00317 L
.27957 .00301 L
.28015 .00277 L
.28076 .00245 L
.28135 .00212 L
.2819 .00185 L
.2824 .00175 L
.28293 .0019 L
.28351 .00237 L
.28404 .00301 L
.28523 .00481 L
.28738 .00814 L
.28796 .00887 L
.28858 .00948 L
.2889 .00973 L
.28926 .00994 L
.28958 .01007 L
.28988 .01013 L
.29048 .01011 L
.29102 .00991 L
.29162 .00954 L
.29225 .00903 L
.29286 .00855 L
.29343 .00825 L
Mistroke
.29375 .00821 L
.29409 .0083 L
.29469 .00885 L
.29526 .00983 L
.29587 .01125 L
.29695 .01434 L
.29813 .01769 L
.29878 .01926 L
.2994 .02045 L
.29975 .02097 L
.30013 .02141 L
.30047 .02169 L
.30079 .02185 L
.30109 .02191 L
.30142 .02188 L
.30177 .02177 L
.30209 .02159 L
.30315 .02078 L
.30374 .02042 L
.30428 .02034 L
.30458 .02045 L
.30491 .02074 L
.30551 .0217 L
.30611 .02323 L
.30667 .02505 L
.31149 .0392 L
.32013 .05786 L
.3385 .10676 L
.35616 .1733 L
.36598 .20744 L
.36654 .20871 L
.36715 .2095 L
.36772 .20982 L
.36824 .20987 L
.36885 .20986 L
.36916 .2099 L
.3695 .21003 L
.37009 .21058 L
.37064 .21158 L
.3712 .21316 L
.37174 .21519 L
.37273 .22014 L
.37389 .2268 L
.37497 .23241 L
.3755 .23462 L
.376 .23623 L
.37652 .23742 L
.37709 .23817 L
.37768 .2384 L
.37821 .23827 L
Mistroke
.37879 .23794 L
.37941 .23759 L
.37999 .23748 L
.38031 .23758 L
.38061 .23779 L
.38118 .2386 L
.38172 .23986 L
.38235 .24191 L
.38293 .24423 L
.38425 .25015 L
.38523 .25414 L
.38579 .25589 L
.38629 .25709 L
.38689 .258 L
.38745 .25838 L
.38797 .25837 L
.38853 .25807 L
.38967 .25712 L
.39 .25689 L
.39031 .25673 L
.39089 .25666 L
.39143 .25691 L
.39194 .25744 L
.39249 .25833 L
.39307 .25956 L
.39416 .26236 L
.39474 .26385 L
.39535 .26527 L
.39588 .2663 L
.39647 .26712 L
.39701 .26757 L
.39751 .26774 L
.39783 .26772 L
.39813 .26763 L
.39871 .2673 L
.39932 .26678 L
.39999 .26614 L
.40056 .26564 L
.40117 .26523 L
.40174 .26498 L
.40226 .2649 L
.40279 .26496 L
.40336 .26513 L
.40384 .26534 L
.40437 .2656 L
.40495 .26586 L
.40556 .26605 L
.40614 .26611 L
.40667 .26604 L
.4072 .26584 L
Mistroke
.40769 .26555 L
.40823 .26512 L
.4088 .26459 L
.41082 .26252 L
.41295 .26074 L
.41351 .26025 L
.41411 .25963 L
.41519 .25811 L
.4158 .25698 L
.41636 .25577 L
.41765 .25259 L
.4199 .2477 L
.42843 .22608 L
.42903 .22273 L
.4296 .22023 L
.42992 .21923 L
.43026 .21847 L
.43086 .21805 L
.43144 .21866 L
.43205 .22017 L
.43314 .22386 L
.43345 .22481 L
.43378 .22563 L
.43439 .22637 L
.43498 .22583 L
.43552 .22401 L
.43612 .22035 L
.43647 .21752 L
.43679 .21444 L
.43813 .19836 L
.43869 .19135 L
.43929 .18464 L
.43986 .17994 L
.44039 .17757 L
.44087 .17728 L
.44139 .17897 L
.44194 .18266 L
.44245 .18737 L
.44354 .1983 L
.44408 .20275 L
.44468 .20576 L
.44499 .20634 L
.44533 .2061 L
.44593 .20323 L
.44653 .19719 L
.44708 .18908 L
.44819 .16664 L
.44923 .14365 L
.44976 .13423 L
.45032 .12777 L
Mistroke
.45064 .12631 L
.45094 .12654 L
.45151 .13107 L
.45181 .13531 L
.45213 .14086 L
.45271 .15244 L
.45338 .16641 L
.45401 .17785 L
.45454 .18497 L
.45511 .18939 L
.45541 .19017 L
.45574 .18968 L
.45631 .18536 L
.45686 .17724 L
.45735 .16658 L
.45847 .13317 L
.45951 .09591 L
.45997 .08132 L
.46047 .07038 L
.46102 .06873 L
.46159 .07917 L
.4619 .08806 L
.46222 .09899 L
.46281 .11992 L
.46387 .15373 L
.46447 .16781 L
.46502 .17649 L
.46544 .17995 L
.46582 .18066 L
.46626 .17852 L
.46668 .17361 L
.46707 .1664 L
.46744 .15764 L
.46825 .13095 L
Mfstroke
.46825 .13095 m
.46864 .11705 L
.46906 .10357 L
.46946 .09232 L
.46984 .08266 L
.47024 .07347 L
.47063 .06558 L
.47105 .05812 L
.47145 .05172 L
.47183 .04622 L
.47224 .041 L
.47263 .03652 L
.47301 .03266 L
.47341 .029 L
.4738 .02585 L
.47421 .02289 L
.47461 .02036 L
.47499 .01822 L
.4754 .01623 L
.47579 .01458 L
.47621 .0131 L
.47661 .01196 L
.47699 .01112 L
.47719 .01079 L
.4774 .01052 L
.4775 .01043 L
.4776 .01035 L
.47769 .01029 L
.47778 .01025 L
s
.47778 .01025 m
.48762 .0067 L
.498 .00381 L
.50345 .00266 L
.50852 .00181 L
.51409 .0011 L
.51721 .0008 L
.52005 .00058 L
.52258 .00042 L
.52526 .0003 L
.52755 .00022 L
.52885 .00018 L
.53007 .00016 L
.53074 .00015 L
.53147 .00014 L
.53212 .00013 L
.5328 .00012 L
.53348 .00012 L
.5341 .00011 L
.53472 .00011 L
.53531 .00011 L
.53599 .00011 L
.53634 .00011 L
.53672 .00011 L
.53739 .00011 L
.53802 .00012 L
.53875 .00012 L
.53943 .00013 L
.54094 .00014 L
.54346 .00018 L
.54613 .00023 L
.55093 .00032 L
.55616 .00044 L
.5618 .00054 L
.56439 .00058 L
.56711 .00061 L
.56824 .00062 L
.56944 .00063 L
.57013 .00063 L
.57076 .00064 L
.57134 .00064 L
.57199 .00064 L
.57258 .00064 L
.57321 .00064 L
.5738 .00064 L
.57435 .00064 L
.57499 .00064 L
.57558 .00064 L
.57626 .00064 L
.57691 .00064 L
Mistroke
.57806 .00063 L
.57913 .00062 L
.58155 .0006 L
.58422 .00057 L
.5871 .00052 L
.59231 .00041 L
.60206 .00015 L
.60447 9e-005 L
.60579 5e-005 L
.60644 3e-005 L
.60705 1e-005 L
.60739 0 L
.60776 1e-005 L
.60812 2e-005 L
.60853 3e-005 L
.60987 7e-005 L
.61251 .00014 L
.61827 .00027 L
.62354 .00038 L
.62611 .00041 L
.62849 .00044 L
.63097 .00046 L
.63229 .00047 L
.63369 .00048 L
.63443 .00048 L
.6351 .00048 L
.63546 .00049 L
.63585 .00049 L
.63626 .00049 L
.63664 .00049 L
.637 .00049 L
.63734 .00049 L
.63798 .00049 L
.63866 .00048 L
.63905 .00048 L
.63941 .00048 L
.64061 .00048 L
.64193 .00047 L
.64331 .00046 L
.64461 .00045 L
.64975 .00039 L
.65516 .0003 L
.66484 .0001 L
.66607 7e-005 L
.6674 4e-005 L
.66802 3e-005 L
.66866 2e-005 L
.66922 0 L
.66983 1e-005 L
.67019 2e-005 L
Mistroke
.67052 3e-005 L
.67127 4e-005 L
.67262 7e-005 L
.67516 .00012 L
.67981 .00021 L
.68477 .00029 L
.68747 .00033 L
.68992 .00035 L
.69239 .00037 L
.6935 .00038 L
.69471 .00039 L
.69603 .00039 L
.69675 .0004 L
.69743 .0004 L
.69806 .0004 L
.69863 .0004 L
.69929 .0004 L
.69992 .0004 L
.7006 .0004 L
.70095 .0004 L
.70133 .0004 L
.70199 .0004 L
.70262 .00039 L
.70404 .00039 L
.70556 .00038 L
.70816 .00036 L
.71057 .00034 L
.71605 .00027 L
.72174 .00019 L
.7271 9e-005 L
.7296 5e-005 L
.73096 2e-005 L
.73163 1e-005 L
.73224 0 L
.73291 1e-005 L
.73362 3e-005 L
.73514 5e-005 L
.73781 .0001 L
.74253 .00018 L
.74754 .00024 L
.75026 .00027 L
.75271 .0003 L
.75518 .00031 L
.75751 .00033 L
.75883 .00033 L
.7595 .00033 L
.76023 .00034 L
.76085 .00034 L
.76152 .00034 L
.76215 .00034 L
Mistroke
.76273 .00034 L
.76308 .00034 L
.76345 .00034 L
.76411 .00034 L
.76448 .00034 L
.76483 .00034 L
.76562 .00034 L
.76694 .00033 L
.76836 .00033 L
.7711 .00031 L
.77365 .00029 L
.77942 .00023 L
.78993 8e-005 L
.79258 4e-005 L
.79398 2e-005 L
.79435 2e-005 L
.79474 1e-005 L
.79512 0 L
.79546 0 L
.79612 1e-005 L
.79675 2e-005 L
.79817 4e-005 L
.80066 8e-005 L
.8104 .00021 L
.81545 .00025 L
.818 .00027 L
.81947 .00028 L
.82081 .00029 L
.82198 .00029 L
.82321 .00029 L
.82384 .00029 L
.82444 .00029 L
.82509 .0003 L
.82545 .0003 L
.82578 .0003 L
.82638 .0003 L
.82694 .0003 L
.82754 .0003 L
.82819 .00029 L
.82874 .00029 L
.82926 .00029 L
.83045 .00029 L
.8318 .00028 L
.83306 .00028 L
.8359 .00026 L
.8384 .00025 L
.84106 .00022 L
.85076 .00011 L
.85616 4e-005 L
.85763 2e-005 L
Mistroke
.85838 1e-005 L
.8588 0 L
.85919 0 L
.86199 4e-005 L
.87255 .00017 L
.87517 .0002 L
.87803 .00022 L
.88054 .00024 L
.88192 .00024 L
.88321 .00025 L
.88447 .00025 L
.88561 .00026 L
.88689 .00026 L
.88756 .00026 L
.88793 .00026 L
.88826 .00026 L
.88882 .00026 L
.88942 .00026 L
.88997 .00026 L
.89049 .00026 L
.8911 .00026 L
.89166 .00026 L
.89228 .00026 L
.89293 .00026 L
.89426 .00026 L
.89552 .00025 L
.89788 .00025 L
.90042 .00023 L
.90319 .00021 L
.91278 .00012 L
.9181 5e-005 L
.91937 4e-005 L
.92071 2e-005 L
.92186 1e-005 L
.92251 0 L
.92311 1e-005 L
.92562 4e-005 L
.92833 7e-005 L
.9341 .00013 L
.93959 .00018 L
.94229 .0002 L
.94479 .00022 L
.94705 .00023 L
.9482 .00023 L
.94945 .00024 L
.9501 .00024 L
.95069 .00024 L
.9513 .00024 L
.95186 .00024 L
.95251 .00024 L
Mistroke
.95285 .00024 L
.95322 .00024 L
.95389 .00024 L
.95451 .00024 L
.95514 .00024 L
.95572 .00024 L
.95637 .00024 L
.95706 .00024 L
.95847 .00024 L
.95976 .00023 L
.96223 .00022 L
.96458 .00021 L
.9698 .00017 L
.97548 .00012 L
.97619 .00011 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0?moomMoo`003gooo`00^00047oo000JOol20002Ool600000goo001oo`0400000goo000000020002
Ool400000goo0000000500001Goo001oo`00Ool00P0000=oo`0000000P0000=oo`0000000`0000=o
o`00000010000goo0P000Woo0`000Woo00<007oo00000`0000=oo`0000001@000goo0P000Woo0P00
00=oo`00Ool00`0000Aoo`00001oo`T000Yoo`03001oogoo00]oo`03001oogoo00Yoo`03001oogoo
00]oo`03001oogoo00]oo`03001oogoo00]oo`05001oogooOol00008Ool5000:Ool00`00Oomoo`0;
Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0;
Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`0;
Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0IOol002=oo`8000=o
o`8000]oo`03001oogoo00Eoo`<0009oo`8000=oo`03001oogoo00Uoo`04001oogooOol300000goo
00000002000017oo000000002Goo0`0000Ioo`00001oo`00Ool200000goo001oo`030002Ool3000:
Ool00`00Oomoo`0aOol00`00Oomoo`0IOol01@00Oomoogoo00001Woo0P007Goo00<007ooOol0@Woo
00<007ooOol0@goo00<007ooOol0@Woo001bOol01000Oomoogoo0P000goo0P0047oo00@007oo0000
02moo`03001oogoo01Uoo`05001oogooOol00002Ool4003_Ool008eoo`@002moo`03001oogoo01Uo
o`04001oogooOol3003cOol0095oo`03001oogoo02aoo`03001oogoo01Uoo`05001oogooOol0003e
Ool0095oo`03001oogoo02aoo`03001oogoo01Uoo`03001oogoo00800?Eoo`00TWoo00<007ooOol0
:goo00<007ooOol06Goo00<007ooOol00P00mGoo002BOol00`00Oomoo`0[Ool00`00Oomoo`0IOol0
0`00Oomoo`02003eOol0099oo`@002Yoo`03001oogoo01Uoo`03001oogoo00800?Eoo`00UGoo00<0
07ooOol0:7oo00<007ooOol06Goo00<007ooOol00P00mGoo002EOol00`00Oomoo`0XOol00`00Oomo
o`0IOol00`00Oomoo`02003eOol009Ioo`03001oogoo02Moo`03001oogoo01Uoo`05001oo`00Ool0
003eOol009Ioo`03001oogoo02Moo`<001Uoo`05001oo`00Ool0003eOol009Moo`03001oogoo02Io
o`03001oogoo01Uoo`05001oo`00Ool0003eOol009Moo`03001oogoo02Ioo`03001oogoo01Uoo`05
001oo`00Ool0003eOol009Qoo`03001oogoo02Eoo`03001oogoo01Uoo`05001oo`00Ool0003eOol0
09Qoo`03001oogoo02Eoo`03001oogoo01Uoo`05001oo`00Ool0003eOol009Qoo`03001oogoo02Eo
o`03001oogoo01Uoo`05001oo`00Ool0003eOol009Uoo`03001oogoo02Aoo`03001oogoo01Uoo`05
001oo`00Ool0003eOol009Uoo`03001oogoo02Aoo`03001oogoo01Uoo`05001oo`00Ool0003eOol0
09Yoo`03001oogoo02=oo`03001oogoo01Uoo`05001oo`00Ool0003eOol009Yoo`03001oogoo02=o
o`03001oogoo01Uoo`05001oo`00Ool0003eOol009Yoo`03001oogoo02=oo`03001oogoo01Uoo`05
001oo`00Ool0003eOol009]oo`03001oogoo029oo`03001oogoo01Uoo`80009oo`03001oogoo0?=o
o`00Vgoo00<007ooOol08Woo00<007ooOol06Goo0P000Woo00<007ooOol0lgoo002KOol00`00Oomo
o`0ROol00`00Oomoo`0IOol20002Ool00`00Oomoo`3cOol009aoo`03001oogoo025oo`<001Uoo`80
009oo`03001oogoo0?=oo`00W7oo00<007ooOol08Goo00<007ooOol06Goo0P000Woo00<007ooOol0
lgoo002MOol00`00Oomoo`0POol00`00Oomoo`0IOol20002Ool00`00Oomoo`3cOol009eoo`03001o
ogoo021oo`03001oogoo01Ioo`03001oogoo0080009oo`03001oogoo0?=oo`00WGoo00<007ooOol0
87oo00<007ooOol05Woo00<007ooOol00P000Woo00<007ooOol0lgoo002NOol00`00Oomoo`0OOol0
0`00Oomoo`0FOol00`00Oomoo`020002Ool00`00Oomoo`3cOol009ioo`03001oogoo01moo`03001o
ogoo01Eoo`80009oo`80009oo`03001oogoo0?=oo`00WWoo00<007ooOol07goo00<007ooOol05Goo
0P000Woo0P000Woo00<007ooOol0lgoo002OOol00`00Oomoo`0NOol00`00Oomoo`0EOol20002Ool2
0002Ool00`00Oomoo`3cOol009moo`03001oogoo01ioo`03001oogoo01Eoo`80009oo`80009oo`03
001oogoo0?=oo`00X7oo00<007ooOol07Goo00<007ooOol05Goo0P000Woo0P000Woo00<007ooOol0
lgoo002POol00`00Oomoo`0MOol00`00Oomoo`0EOol20002Ool20002Ool00`00Oomoo`3cOol00:1o
o`03001oogoo01eoo`03001oogoo01Eoo`80009oo`80009oo`03001oogoo0?=oo`00XGoo00<007oo
Ool077oo0`005Goo0P000Woo0P000Woo00<007ooOol0lgoo002QOol00`00Oomoo`0LOol00`00Oomo
o`0EOol20002Ool20002Ool00`00Oomoo`3cOol00:5oo`03001oogoo01aoo`03001oogoo01Eoo`80
009oo`80009oo`03001oogoo0?=oo`00XWoo00<007ooOol06goo00<007ooOol05Goo0P000Woo00D0
07ooOomoo`000?Eoo`00XWoo00<007ooOol06goo00<007ooOol05Goo0P000Woo00D007ooOomoo`00
0?Eoo`00Xgoo00<007ooOol06Woo00<007ooOol05Goo0P000Woo00D007ooOomoo`000?Eoo`00Xgoo
00<007ooOol06Woo00<007ooOol05Goo0P000Woo00D007ooOomoo`000?Eoo`00Xgoo00<007ooOol0
6Woo00<007ooOol05Goo0P000Woo00D007ooOomoo`000?Eoo`00Y7oo00<007ooOol06Goo00<007oo
Ool05Goo00D007oo001oo`0000=oo`03001oogoo0?=oo`00Y7oo00<007ooOol06Goo00<007ooOol0
5Goo00D007oo001oo`0000=oo`03001oogoo0?=oo`00Y7oo00<007ooOol03Goo1P001Woo00<007oo
Ool05Goo00D007oo001oo`0000=oo`03001oogoo0?=oo`00Y7oo00<007ooOol03Goo00<007ooOol0
2Goo00<007ooOol05Goo00D007oo001oo`0000=oo`03001oogoo0?=oo`00YGoo00<007ooOol03Goo
00<007ooOol027oo00<007ooOol05Goo00D007oo001oo`0000=oo`03001oogoo0?=oo`00YGoo00<0
07ooOol03Woo00<007ooOol01goo00<007ooOol05Goo00D007oo001oo`0000=oo`03001oogoo0?=o
o`00YGoo00<007ooOol03goo00<007ooOol01Woo100057oo00D007oo001oo`0000=oo`03001oogoo
0?=oo`00YGoo00<007ooOol047oo00<007ooOol01Goo00<007ooOol04Goo0P000Woo00D007oo001o
o`0000=oo`03001oogoo0?=oo`00YWoo00<007ooOol047oo00<007ooOol017oo00<007ooOol04Goo
0P000Woo00D007oo001oo`0000=oo`03001oogoo0?=oo`00YWoo00<007ooOol047oo00<007ooOol0
17oo00<007ooOol04Goo0P000Woo00D007oo001oo`0000=oo`03001oogoo0?=oo`00YWoo00<007oo
Ool02goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol04Goo0P000Woo00D007oo001oo`00
00=oo`03001oogoo0?=oo`00Ygoo00<007ooOol02goo10001goo00<007ooOol04Goo0P000Woo00D0
07oo001oo`0000=oo`03001oogoo0?=oo`00Ygoo00<007ooOol05Woo00<007ooOol04Goo0P000Woo
00D007oo001oo`0000=oo`03001oogoo0?=oo`00Ygoo00<007ooOol05Woo00<007ooOol04Goo0P00
0Woo00D007oo001oo`0000=oo`03001oogoo0?=oo`00Ygoo00<007ooOol05Woo00<007ooOol04Goo
0P000Woo00D007oo001oo`0000=oo`03001oogoo0?=oo`00Z7oo00<007ooOol05Goo00<007ooOol0
4Goo0P000Woo00D007oo001oo`0000=oo`03001oogoo0?=oo`00Z7oo00<007ooOol05Goo00<007oo
Ool04Goo0P000Woo00D007oo001oo`0000=oo`03001oogoo0?=oo`00Z7oo00<007ooOol05Goo00<0
07ooOol04Goo0P000Woo00D007oo001oo`0000=oo`03001oogoo0?=oo`00ZGoo00<007ooOol057oo
00<007ooOol04Goo0P0000Moo`00Oomoo`00Ool00003Ool00`00Oomoo`3cOol00:Uoo`03001oogoo
01Aoo`<0015oo`800007Ool007ooOol007oo00000goo00<007ooOol0lgoo002YOol00`00Oomoo`0D
Ool00`00Oomoo`0@Ool01@00Ool007oo00000Woo00<007oo00000goo00<007ooOol0lgoo002YOol0
0`00Oomoo`0DOol00`00Oomoo`0@Ool00`00Oomoo`020002Ool00`00Ool00003Ool00`00Oomoo`3c
Ool00:Yoo`03001oogoo01=oo`03001oogoo011oo`03001oogoo0080009oo`03001oo`0000=oo`03
001oogoo0?=oo`00ZWoo00<007ooOol04goo00<007ooOol047oo00<007ooOol00P000Woo00<007oo
00000goo00<007ooOol0lgoo002ZOol00`00Oomoo`0COol00`00Oomoo`0@Ool00`00Oomoo`020002
Ool00`00Ool00003Ool00`00Oomoo`3cOol00:Yoo`03001oogoo01=oo`03001oogoo011oo`03001o
ogoo0080009oo`03001oo`0000=oo`03001oogoo0?=oo`00Zgoo00<007ooOol04Woo00<007ooOol0
47oo00<007ooOol00P000Woo0`000goo00<007ooOol0lgoo002[Ool00`00Oomoo`0BOol00`00Oomo
o`0@Ool00`00Oomoo`020003Ool20003Ool00`00Oomoo`3cOol00:]oo`03001oogoo019oo`03001o
ogoo011oo`03001oogoo008000=oo`8000=oo`03001oogoo0?=oo`00[7oo00<007ooOol04Goo00<0
07ooOol03Goo00@007ooOol0009oo`8000=oo`8000=oo`03001oogoo0?=oo`00[7oo00<007ooOol0
4Goo00<007ooOol03Goo00@007ooOol0009oo`8000=oo`8000=oo`03001oogoo0?=oo`00[7oo00<0
07ooOol04Goo00<007ooOol037oo00D007oo001oo`00009oo`8000=oo`8000=oo`03001oogoo0?=o
o`00[7oo00<007ooOol04Goo00<007ooOol037oo00D007oo001oo`00009oo`8000Aoo`05001oogoo
Ool0003eOol00:eoo`03001oogoo011oo`<000aoo`05001oo`00Ool00002Ool20004Ool01@00Oomo
ogoo0000mGoo002]Ool00`00Oomoo`0@Ool00`00Oomoo`0<Ool01@00Ool007oo00000Woo0P0017oo
00D007ooOomoo`000?Eoo`00[Goo00<007ooOol047oo00<007ooOol037oo00D007oo001oo`00009o
o`8000Aoo`05001oogooOol0003eOol00:eoo`03001oogoo011oo`03001oogoo00aoo`05001oo`00
Ool00008Ool01@00Oomoogoo0000mGoo002^Ool00`00Oomoo`0?Ool00`00Oomoo`0<Ool01@00Ool0
07oo000027oo00D007ooOomoo`000?Eoo`00[Woo00<007ooOol03goo00<007ooOol037oo00D007oo
001oo`0000Qoo`05001oogooOol0003eOol00:ioo`03001oogoo00moo`03001oogoo00aoo`03001o
ogoo008000Qoo`05001oogooOol0003eOol00:ioo`03001oogoo00moo`03001oogoo00aoo`04001o
ogoo0009Ool01@00Oomoogoo0000mGoo002_Ool00`00Oomoo`0>Ool00`00Oomoo`0<Ool01000Oomo
o`002Goo00D007ooOomoo`000?Eoo`00[goo00<007ooOol03Woo00<007ooOol02goo00D007ooOomo
o`0000Uoo`05001oogooOol0003eOol00;1oo`8000ioo`03001oogoo00]oo`03001oogoo00]oo`05
001oogooOol0003eOol00;5oo`03001oogoo00aoo`03001oogoo00]oo`03001oogoo00]oo`05001o
ogooOol0003eOol00;9oo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00]oo`05001oogoo
Ool0003eOol00;9oo`03001oogoo00]oo`<000]oo`03001oogoo00]oo`05001oogooOol0003eOol0
0;9oo`03001oogoo00]oo`03001oogoo00Qoo`800003Ool007oo00aoo`05001oogooOol0003eOol0
0;9oo`03001oogoo00]oo`03001oogoo00Qoo`800003Ool007oo00aoo`05001oogooOol0003eOol0
0;9oo`03001oogoo00]oo`03001oogoo00Qoo`04001oo`00000=Ool01@00Oomoogoo0000mGoo002c
Ool00`00Oomoo`0:Ool00`00Oomoo`08Ool01000Ool000003Goo00D007ooOomoo`000?Eoo`00/goo
00<007ooOol02Woo00<007ooOol027oo00<007oo00003Woo00D007ooOomoo`000?Eoo`00/goo00<0
07ooOol02Woo00<007ooOol027oo00<007ooOol03Woo00D007ooOomoo`000?Eoo`00/goo00<007oo
Ool02Woo00<007ooOol01goo00<007ooOol03goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol0
2Goo00<007ooOol01goo00<007ooOol03goo00D007ooOomoo`000?Eoo`00]7oo00<007ooOol02Goo
00<007ooOol01Woo00<007ooOol047oo00D007ooOomoo`000?Eoo`00]7oo1P001Woo00<007ooOol0
1Woo00<007ooOol047oo00D007ooOomoo`000?Eoo`00]Woo0`001goo00<007ooOol01Goo00<007oo
Ool04Goo00D007ooOomoo`000?Eoo`00]goo0P001goo00<007ooOol01Goo00<007ooOol04Goo00D0
07ooOomoo`000?Eoo`00]7oo1P001Woo00<007ooOol017oo00<007ooOol04Woo00D007ooOomoo`00
0?Eoo`00]7oo00<007ooOol00P001goo10000goo00<007ooOol04Woo00D007ooOomoo`000?Eoo`00
]Goo00@007oo000000Moo`03001oogoo00=oo`03001oogoo01=oo`05001oogooOol0003eOol00;Io
o`03001oo`0000Moo`03001oogoo00=oo`03001oogoo01=oo`05001oogooOol0003eOol00;Ioo`03
001oo`0000Moo`03001oogoo009oo`03001oogoo01Aoo`05001oogooOol0003eOol00;Moo`800003
Ool0000000Aoo`03001oogoo009oo`03001oogoo01Aoo`05001oogooOol0003eOol00;Qoo`800003
Ool007oo00=oo`04001oogooOol2000FOol01@00Oomoogoo0000mGoo002lOol01@00Oomoogoo0000
0Woo0P005goo00D007ooOomoo`000?Eoo`00_7oo00L007ooOomoo`00Ool0000IOol01@00Oomoogoo
0000mGoo002lOol7000IOol01@00Oomoogoo0000mGoo002mOol200000goo001oo`0JOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002eOol40007
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo002dOol20003Ool00`00Oomoo`04Ool4000HOol01@00Oomoogoo
0000mGoo002dOol00`00Ool000020007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol0
0`00Oomoo`09Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`09Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo002eOol00`00Oomoo`08Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo002fOol30007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002eOol40007Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool4000HOol5003eOol00;Eoo`@0
00Moo`03001oogoo0?mooaAoo`00]7oo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0ogoo
57oo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`3oOolDOol00;Aoo`03001oogoo
009oo`03001oogoo00Aoo`03001oogoo0?mooaAoo`00]Goo10001goo00<007ooOol0ogoo57oo0030
Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030
Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030
Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00
Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00
Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00
Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00
Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool3003o
OolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3o
OolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3o
OolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3o
OolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3o
OolDOol00<1oo`<00?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol0
0<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol0
0<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol0
0<1oo`03001oogoo0?mooaAoo`00[7oo1@0017oo10001goo00<007ooOol0ogoo57oo002^Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`3oOolDOol00:ioo`03001oogoo
00=oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0?mooaAoo`00[Woo00<007ooOol00goo
00<007ooOol00Woo00<007ooOol017oo00<007ooOol0ogoo57oo002^Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool00`00Oomoo`04Ool4003oOolCOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03
001oogoo0?mooa]oo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol0ogoo6goo002^
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`3oOolKOol00:aoo`<000Eoo`03001oogoo
009oo`03001oogoo0?mooa]oo`00\
\>"],
  ImageRangeCache->{{{0, 469}, {289.313, 0}} -> {-13.8869, -0.535215, 
  0.0720124, 0.03699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .00394 m
.02598 .00222 L
.02702 .00109 L
.02753 .00052 L
.028 .00018 L
.02855 .00068 L
.02916 .00131 L
.03022 .00227 L
.03081 .00271 L
.03137 .00304 L
.03195 .0033 L
.03226 .00339 L
.03259 .00347 L
.0332 .00352 L
.03377 .00349 L
.0341 .00343 L
.0344 .00335 L
.03506 .00311 L
.03565 .00283 L
.03628 .00246 L
.03742 .0017 L
.03854 .00091 L
.0391 .00057 L
.03942 .00045 L
.03972 .00042 L
.04026 .00061 L
.04074 .00087 L
.04184 .00146 L
.04306 .00199 L
.04367 .0022 L
.04403 .0023 L
.04435 .00237 L
.04493 .00247 L
.04523 .00251 L
.04555 .00253 L
.04609 .00254 L
.04668 .00251 L
.04703 .00248 L
.04737 .00243 L
.04799 .0023 L
.04867 .00211 L
.0494 .00185 L
.05061 .00134 L
.05125 .00104 L
.0516 .00089 L
.05194 .00075 L
.05225 .00064 L
.05259 .00057 L
.05319 .00061 L
.05379 .00083 L
Mistroke
.05435 .0011 L
.0557 .00181 L
.05691 .0024 L
.05746 .00264 L
.05806 .00285 L
.05862 .00301 L
.05914 .00312 L
.05969 .00319 L
.06029 .0032 L
.06059 .00318 L
.06092 .00314 L
.0615 .00301 L
.06207 .00282 L
.0627 .00254 L
.06398 .00177 L
.06454 .00141 L
.06516 .00111 L
.06573 .00107 L
.06626 .0013 L
.06656 .0015 L
.06689 .00176 L
.06747 .00227 L
.06878 .00338 L
.0695 .00386 L
.06985 .00406 L
.07017 .00421 L
.07078 .0044 L
.0711 .00445 L
.07143 .00446 L
.07202 .00439 L
.07255 .00422 L
.07316 .00389 L
.07375 .00347 L
.07478 .00247 L
.07591 .00119 L
.0765 .00071 L
.07683 .00075 L
.07715 .001 L
.07748 .00136 L
.07778 .00173 L
.07846 .00256 L
.0791 .00328 L
.0797 .00387 L
.08029 .00433 L
.08083 .00465 L
.08134 .00485 L
.08189 .00494 L
.08243 .00491 L
.08304 .00473 L
.08362 .00441 L
Mistroke
.08425 .00392 L
.0854 .00273 L
.08653 .00126 L
.0871 .00049 L
.08762 .00025 L
.08809 .00088 L
.08859 .00153 L
.08965 .00276 L
.09026 .00334 L
.0909 .00383 L
.09124 .00403 L
.09161 .0042 L
.09194 .00431 L
.09226 .00438 L
.09258 .00441 L
.09288 .00441 L
.09344 .00431 L
.09405 .0041 L
.0944 .00392 L
.09471 .00373 L
.09692 .00184 L
.09753 .00124 L
.09786 .00093 L
.09817 .00066 L
.09871 .00042 L
.0993 .00075 L
.10042 .00165 L
.10148 .00236 L
.10206 .00267 L
.10237 .0028 L
.1027 .00292 L
.10327 .00308 L
.1038 .00317 L
.1043 .0032 L
.10484 .00319 L
.10535 .00313 L
.10581 .00303 L
.10635 .00288 L
.10695 .00267 L
.10802 .00218 L
.10927 .00148 L
.11044 .00072 L
.11076 .00052 L
.11109 .00031 L
.11145 .00018 L
.11179 .00029 L
.11237 .00065 L
.11301 .00107 L
.11417 .00177 L
.11541 .00241 L
Mistroke
.11601 .00267 L
.11658 .00287 L
.11708 .00301 L
.11764 .00312 L
.11821 .0032 L
.11873 .00322 L
.11934 .0032 L
.11991 .00312 L
.12044 .003 L
.12093 .00286 L
.12204 .00239 L
.12325 .00176 L
.12384 .00148 L
.12439 .00131 L
.12469 .00129 L
.12502 .00134 L
.12534 .00146 L
.1257 .00166 L
.12689 .00257 L
.12815 .00358 L
.12877 .00401 L
.12934 .00433 L
.12965 .00447 L
.13 .0046 L
.13034 .00468 L
.13071 .00473 L
.13102 .00474 L
.13136 .00471 L
.13197 .00454 L
.13254 .00426 L
.13287 .00405 L
.13317 .00383 L
.13444 .0026 L
.135 .00197 L
.13553 .00142 L
.13615 .00111 L
.1367 .0014 L
.13724 .00199 L
.13782 .00273 L
.13886 .004 L
.1395 .00465 L
.1401 .00514 L
.14065 .00545 L
.14124 .00565 L
.14156 .00568 L
.14187 .00567 L
.14244 .00553 L
.14277 .00538 L
.14306 .00521 L
.14373 .00466 L
Mistroke
.14426 .0041 L
.14485 .00336 L
.14546 .0025 L
.14604 .00163 L
.14658 .00082 L
.14716 .00054 L
.1477 .00125 L
.14819 .00199 L
.14929 .00351 L
.14987 .00418 L
.15049 .00476 L
.15104 .00513 L
.15153 .00535 L
.15201 .00546 L
.15251 .00546 L
.15304 .00534 L
.15353 .00512 L
.15407 .00476 L
.15465 .00426 L
.15586 .00291 L
.15652 .00205 L
.15714 .00121 L
.15767 .00052 L
.15824 .00042 L
.15856 .00079 L
.15886 .00117 L
.15944 .00185 L
.16006 .00251 L
.16073 .00312 L
.1613 .00354 L
.16192 .00388 L
.16227 .00402 L
.16258 .00412 L
.16289 .00418 L
.16321 .00422 L
.16356 .00423 L
.16388 .0042 L
.16424 .00414 L
.16462 .00404 L
.16493 .00393 L
.16526 .0038 L
.16584 .0035 L
.16716 .00263 L
.16839 .00165 L
.169 .00114 L
.16955 .00067 L
.17008 .00026 L
.17058 .0003 L
.17111 .00071 L
.17168 .00116 L
Mistroke
.17291 .00205 L
.17403 .00272 L
.1746 .003 L
.17522 .00324 L
.17585 .00342 L
.17619 .00349 L
.17651 .00353 L
.1771 .00357 L
.17764 .00355 L
.17794 .00352 L
.17826 .00347 L
.17885 .00333 L
.17937 .00316 L
.17995 .00294 L
.18112 .00237 L
.18214 .00184 L
.18265 .00162 L
.18322 .00148 L
.18353 .00146 L
.18387 .00151 L
.18448 .00174 L
.18509 .00212 L
.18565 .00253 L
.1869 .00353 L
.18756 .00403 L
.18827 .00448 L
.18887 .00479 L
.18921 .00493 L
.18953 .00503 L
.1901 .00513 L
.1907 .00512 L
.19132 .00498 L
.19191 .00472 L
.19243 .00438 L
.193 .00392 L
.1942 .0027 L
.19483 .00207 L
.19515 .00182 L
.19549 .00167 L
.1958 .00168 L
.19612 .00185 L
.19671 .00243 L
.19783 .00391 L
.1984 .00463 L
.19901 .00534 L
.19955 .00585 L
.20012 .00627 L
.20064 .00651 L
.20121 .00662 L
.20172 .00657 L
Mistroke
.20221 .00639 L
.20281 .00599 L
.20315 .00568 L
.20347 .00534 L
.20467 .00369 L
.20523 .00278 L
.20583 .00177 L
.2064 .00104 L
.20692 .00118 L
.20722 .00159 L
.20755 .00212 L
.20821 .00325 L
.20938 .00504 L
.21003 .00581 L
.21039 .00615 L
.21073 .00641 L
.21105 .00659 L
.2114 .00672 L
.212 .0068 L
.21257 .00668 L
.21309 .00641 L
.21366 .00595 L
.21426 .00531 L
.21527 .00389 L
.21638 .00203 L
.217 .00092 L
.21759 .00014 L
.21792 .00071 L
.21827 .00131 L
.21889 .00231 L
.21947 .00316 L
.22009 .00396 L
.22067 .00457 L
.22122 .00502 L
.22184 .00537 L
.2224 .00556 L
.22272 .0056 L
.22302 .0056 L
.22335 .00556 L
.2237 .00547 L
.22404 .00534 L
.2244 .00515 L
.22507 .00471 L
.22632 .00357 L
.22751 .00225 L
.22816 .0015 L
.22877 .00081 L
.22929 .00038 L
.22984 .00064 L
.23046 .00125 L
Mistroke
.23102 .00182 L
.23218 .00286 L
.23327 .00362 L
.23381 .00392 L
.2344 .00417 L
.23472 .00427 L
.23505 .00435 L
.23565 .00443 L
.23617 .00443 L
.23671 .00437 L
.23723 .00425 L
.2377 .00409 L
.23825 .00384 L
.23885 .00351 L
.23994 .0028 L
.24055 .00237 L
.2412 .00194 L
.24152 .00178 L
.24182 .00166 L
.24239 .00158 L
.24298 .00173 L
.24331 .00191 L
.24362 .00212 L
.24498 .00325 L
.24614 .00424 L
.24723 .00504 L
.24784 .00539 L
.24815 .00554 L
.24849 .00567 L
.24908 .00584 L
.24963 .00589 L
.25016 .00585 L
.25072 .00571 L
.25102 .00559 L
.25134 .00542 L
.25191 .00504 L
.25302 .00404 L
.25356 .00349 L
.25407 .00299 L
.25437 .00275 L
.25469 .00255 L
.25527 .0025 L
.25559 .00265 L
.25594 .00295 L
.25626 .00331 L
.25656 .0037 L
.25774 .00538 L
.25825 .00609 L
.25882 .00677 L
.25932 .00727 L
Mistroke
.25985 .00766 L
.26041 .00792 L
.26094 .00799 L
.26155 .00785 L
.26214 .0075 L
.26266 .007 L
.26323 .00629 L
.26428 .00457 L
.26485 .0035 L
.26539 .00252 L
.26584 .00189 L
.26634 .00181 L
.26688 .00249 L
.26739 .00344 L
.26852 .00566 L
.26908 .00661 L
.2696 .00735 L
.27019 .008 L
.2705 .00825 L
.27083 .00844 L
.27137 .00858 L
.27196 .0085 L
.27251 .00819 L
.27302 .00772 L
.2736 .00696 L
.27416 .00607 L
.27524 .00392 L
.27621 .0017 L
.27681 .00046 L
.27738 .00117 L
.27797 .00247 L
.27861 .00378 L
.27918 .0048 L
.27977 .00571 L
.28028 .00634 L
.28084 .00684 L
.28117 .00705 L
.28149 .00718 L
.28209 .00725 L
.28243 .00719 L
.28274 .00707 L
.28308 .00688 L
.28344 .00661 L
.28404 .00602 L
.2846 .00534 L
.28587 .00345 L
.28643 .00258 L
.28701 .00173 L
.28757 .0012 L
.28807 .00122 L
Mistroke
.28867 .00174 L
.28931 .00244 L
.28991 .00304 L
.29047 .0035 L
.29106 .00386 L
.29137 .004 L
.2917 .0041 L
.29204 .00418 L
.29237 .0042 L
.29267 .0042 L
.29299 .00417 L
.29357 .00403 L
.29387 .00394 L
.29419 .00382 L
.29531 .00335 L
.29585 .00313 L
.29643 .00294 L
.29692 .00283 L
.29745 .00276 L
.29803 .00273 L
.29835 .00273 L
.29865 .00274 L
.29922 .00275 L
.29976 .00274 L
.30027 .0027 L
.30081 .00262 L
.30127 .0025 L
.30177 .00232 L
.30231 .00208 L
.3029 .00175 L
.30395 .00099 L
.30456 .00046 L
.30514 9e-005 L
.30545 .0004 L
.3058 .00075 L
.3064 .0014 L
.30867 .00394 L
.30997 .0053 L
.31069 .00593 L
.31135 .00642 L
.31192 .00674 L
.31253 .00696 L
.31287 .00702 L
.3132 .00703 L
.31382 .00694 L
.31436 .00673 L
.31495 .00635 L
.31557 .00583 L
.31615 .00527 L
.31666 .0048 L
Mistroke
.31719 .00443 L
.31778 .00434 L
.31831 .00469 L
.3189 .00553 L
.31952 .0068 L
.32064 .00952 L
.32188 .01247 L
.32256 .01382 L
.32289 .01438 L
.3232 .01481 L
.32377 .01544 L
.32438 .0158 L
.3247 .01584 L
.32505 .01579 L
.32538 .01563 L
.32568 .01541 L
.32627 .01479 L
.3268 .01407 L
.32737 .01321 L
.32798 .01244 L
.3283 .01216 L
.32865 .01204 L
.32926 .01237 L
.32961 .01291 L
.32998 .01374 L
.33065 .01579 L
.33196 .02077 L
.33316 .02513 L
.33375 .02682 L
.33438 .02817 L
.3347 .02867 L
.335 .02901 L
.33534 .02924 L
.33569 .02933 L
.336 .02927 L
.33633 .02909 L
.33694 .02848 L
.33754 .02767 L
.33809 .02692 L
.33867 .02632 L
.33921 .02615 L
.33979 .02658 L
.34011 .02713 L
.34041 .02784 L
.34091 .02942 L
.34146 .03163 L
.34257 .03687 L
.34374 .04224 L
.34436 .04456 L
.34469 .04562 L
Mistroke
.34501 .04647 L
.34558 .04761 L
.34589 .04801 L
.34621 .0483 L
.34679 .04848 L
.34733 .04834 L
.34785 .04803 L
.34834 .0477 L
.34887 .04745 L
.34944 .04749 L
.35004 .04803 L
.35061 .04914 L
.35112 .05063 L
.35167 .05274 L
.36143 .07933 L
.38051 .14502 L
.39889 .20112 L
.41657 .27148 L
.4264 .30529 L
.42865 .24499 L
.4293 .22453 L
.42992 .21048 L
.43046 .20541 L
.43106 .20989 L
.43158 .22196 L
.43215 .24159 L
.43331 .28846 L
.43383 .30757 L
.43438 .32419 L
.43491 .335 L
.43538 .34003 L
.43595 .33947 L
.43648 .33241 L
.43705 .31762 L
.43767 .29466 L
.43871 .24371 L
.43925 .21552 L
.43983 .19028 L
.44012 .18102 L
.44045 .17517 L
.44101 .17773 L
.44159 .19617 L
.44213 .22297 L
.44344 .29772 L
.44408 .32856 L
.44467 .34955 L
.44519 .36081 L
.44574 .36451 L
.4463 .35932 L
.44691 .34332 L
Mistroke
.44741 .32219 L
.44796 .29243 L
.44894 .22504 L
.44952 .18209 L
.44983 .1613 L
.45016 .14297 L
.45076 .12809 L
.45132 .14247 L
.45185 .17493 L
.45235 .21273 L
.45349 .29812 L
.45394 .32595 L
.45442 .35022 L
.45487 .3671 L
.45528 .37688 L
.45576 .38121 L
.45629 .37687 L
.45678 .36412 L
.45724 .34509 L
.45771 .31857 L
.45815 .28792 L
.45916 .2013 L
.45966 .15281 L
.46014 .10814 L
.46069 .07287 L
.46119 .0822 L
.46163 .11748 L
.46204 .15637 L
.46294 .2436 L
.46379 .31267 L
.46416 .33703 L
.46457 .35885 L
.46501 .37627 L
.46548 .38708 L
.46599 .38966 L
.46647 .3833 L
.46692 .36953 L
.46733 .35063 L
.4678 .32168 L
.46825 .28774 L
Mfstroke
.46825 .28774 m
.46864 .25776 L
.46906 .22861 L
.46946 .20423 L
.46984 .18324 L
.47024 .16326 L
.47063 .14607 L
.47105 .12976 L
.47145 .11576 L
.47183 .1037 L
.47224 .09223 L
.47263 .08237 L
.47301 .07388 L
.47341 .06579 L
.4738 .05884 L
.47421 .05228 L
.47461 .04668 L
.47499 .04193 L
.4754 .03751 L
.47579 .03385 L
.47621 .0306 L
.47661 .02811 L
.47699 .02631 L
.47719 .02563 L
.47729 .02535 L
.4774 .02509 L
.4775 .0249 L
.4776 .02477 L
.47764 .02472 L
.47769 .02467 L
.47774 .02464 L
.47778 .02462 L
s
.47778 .02462 m
.498 .0152 L
.50852 .01067 L
.52005 .00651 L
.52523 .00499 L
.53077 .00362 L
.53596 .00256 L
.54076 .00179 L
.5461 .00113 L
.54892 .00087 L
.55191 .00065 L
.5545 .0005 L
.55692 .00039 L
.55958 .00031 L
.56108 .00027 L
.56245 .00024 L
.56494 .0002 L
.56633 .00019 L
.5676 .00018 L
.56817 .00017 L
.56878 .00017 L
.56945 .00016 L
.57006 .00016 L
.57063 .00016 L
.57117 .00016 L
.57175 .00016 L
.57238 .00016 L
.57273 .00017 L
.57311 .00017 L
.57378 .00017 L
.5745 .00018 L
.5753 .00019 L
.57806 .00023 L
.58323 .00033 L
.58857 .00044 L
.5942 .00055 L
.59653 .00058 L
.59901 .00061 L
.60044 .00062 L
.60173 .00063 L
.60236 .00063 L
.60304 .00064 L
.60368 .00064 L
.60427 .00064 L
.60488 .00064 L
.60543 .00064 L
.60608 .00064 L
.60669 .00064 L
.60725 .00064 L
.60777 .00064 L
Mistroke
.60834 .00064 L
.60895 .00063 L
.61034 .00063 L
.61165 .00062 L
.6141 .00059 L
.61671 .00055 L
.61911 .00051 L
.62451 .0004 L
.63438 .00014 L
.63709 6e-005 L
.63787 4e-005 L
.63825 3e-005 L
.6386 2e-005 L
.63927 1e-005 L
.63962 2e-005 L
.63998 2e-005 L
.64521 .00016 L
.65012 .00028 L
.6527 .00033 L
.65542 .00038 L
.6578 .00041 L
.66041 .00044 L
.66156 .00046 L
.66279 .00047 L
.66384 .00047 L
.66499 .00048 L
.66569 .00048 L
.66635 .00048 L
.66704 .00049 L
.66743 .00049 L
.66779 .00049 L
.66842 .00049 L
.66911 .00049 L
.66976 .00049 L
.67036 .00049 L
.67105 .00048 L
.6717 .00048 L
.67318 .00047 L
.67463 .00047 L
.67618 .00045 L
.67886 .00042 L
.68168 .00039 L
.68673 .0003 L
.69172 .00021 L
.69446 .00015 L
.69705 9e-005 L
.69947 4e-005 L
.70013 2e-005 L
.70049 2e-005 L
.70083 1e-005 L
Mistroke
.70143 1e-005 L
.70208 2e-005 L
.70666 .00012 L
.7121 .00022 L
.71726 .0003 L
.71951 .00033 L
.7219 .00036 L
.72328 .00037 L
.72453 .00038 L
.72579 .00038 L
.72696 .00039 L
.72818 .00039 L
.72882 .0004 L
.72952 .0004 L
.72986 .0004 L
.73024 .0004 L
.73093 .0004 L
.73159 .0004 L
.73221 .0004 L
.73279 .0004 L
.73333 .0004 L
.73392 .0004 L
.73455 .00039 L
.73585 .00039 L
.73704 .00038 L
.73958 .00037 L
.74235 .00034 L
.74794 .00027 L
.75821 .0001 L
.76117 5e-005 L
.76262 2e-005 L
.76326 1e-005 L
.76362 1e-005 L
.76396 1e-005 L
.76454 1e-005 L
.76518 2e-005 L
.76646 5e-005 L
.76918 9e-005 L
.77448 .00018 L
.78027 .00026 L
.78291 .00028 L
.78573 .00031 L
.7871 .00032 L
.78838 .00032 L
.78955 .00033 L
.79079 .00033 L
.79145 .00033 L
.79206 .00034 L
.79266 .00034 L
.79324 .00034 L
Mistroke
.7939 .00034 L
.79452 .00034 L
.7952 .00034 L
.79554 .00034 L
.79592 .00034 L
.79628 .00034 L
.79662 .00034 L
.79726 .00034 L
.79871 .00033 L
.79996 .00033 L
.80133 .00032 L
.80375 .0003 L
.80634 .00028 L
.811 .00023 L
.81638 .00016 L
.8222 8e-005 L
.82487 3e-005 L
.82622 1e-005 L
.82659 1e-005 L
.82698 0 L
.82736 1e-005 L
.8277 1e-005 L
.83276 9e-005 L
.8376 .00015 L
.84274 .00021 L
.84542 .00024 L
.84838 .00026 L
.84968 .00027 L
.85107 .00028 L
.8524 .00028 L
.8536 .00029 L
.85486 .00029 L
.85555 .00029 L
.8562 .00029 L
.8568 .0003 L
.85735 .0003 L
.85796 .0003 L
.85861 .0003 L
.85926 .0003 L
.85962 .00029 L
.85996 .00029 L
.8606 .00029 L
.86122 .00029 L
.86259 .00029 L
.86409 .00028 L
.86686 .00027 L
.86981 .00025 L
.87513 .0002 L
.88052 .00014 L
.88336 .0001 L
Mistroke
.88635 6e-005 L
.88897 2e-005 L
.88969 1e-005 L
.89009 1e-005 L
.89046 0 L
.89081 0 L
.89119 1e-005 L
.89185 2e-005 L
.89691 8e-005 L
.90226 .00015 L
.90727 .0002 L
.91 .00022 L
.9125 .00024 L
.91528 .00025 L
.91674 .00026 L
.91747 .00026 L
.91827 .00026 L
.91897 .00026 L
.91962 .00026 L
.92024 .00026 L
.9209 .00026 L
.92148 .00026 L
.92203 .00026 L
.92263 .00026 L
.92328 .00026 L
.92396 .00026 L
.92471 .00026 L
.92607 .00026 L
.92739 .00025 L
.92862 .00025 L
.93083 .00024 L
.93328 .00022 L
.93824 .00018 L
.94357 .00013 L
.94919 6e-005 L
.95151 3e-005 L
.95279 2e-005 L
.95342 1e-005 L
.954 0 L
.95468 1e-005 L
.95504 1e-005 L
.95542 1e-005 L
.95672 3e-005 L
.95925 6e-005 L
.97619 .00022 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0?moomMoo`003gooo`00^00047oo000JOol2000017oo000000000Woo10000Woo100000=oo`000000
0P0000=oo`00Ool00P0000Aoo`000000009oo`@0009oo`@00003Ool0000000@00003Ool000000080
0003Ool0000000@0009oo`L0009oo`<0009oo`80009oo`@00004Ool00000Ool70002Ool30002Ool2
0003Ool20002Ool900000goo0000000=Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`0;
Ool00`00Oomoo`0;Ool01@00Oomoogoo00002Goo00<007ooOol02Woo1@002Woo00<007ooOol02goo
00<007ooOol02goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo
00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo
00<007ooOol02Woo00<007ooOol02goo00<007ooOol06Goo000^Ool20002Ool40002Ool00`00Oomo
o`0=Ool20002Ool30002Ool30003Ool00`00Oomoo`08Ool20002Ool30002Ool00`00Ool00002Ool3
0003Ool20003Ool30002Ool02@00Ool00000Ool007oo001oo`0200000goo001oo`09Ool00`00Ool0
0002000TOol00`00Oomoo`0IOol01@00Oomoogoo000057oo0P003goo00<007ooOol0@Woo00<007oo
Ool0@goo00<007ooOol0@Woo001WOol20003Ool00`00Oomoo`0BOol20002Ool30002Ool2000<Ool2
00000goo001oo`0SOol00`00Oomoo`0IOol01@00Oomoogoo000047oo1000hGoo002LOol00`00Oomo
o`0QOol00`00Oomoo`0IOol01@00Oomoogoo000037oo1000iGoo002LOol01000Ool0000087oo00<0
07ooOol06Goo00D007ooOomoo`0000Yoo`800>Uoo`00W7oo0`0000=oo`00Ool07Woo00<007ooOol0
6Goo00D007ooOomoo`0000Moo`<00>]oo`00WGoo00@007ooOol001moo`03001oogoo01Uoo`05001o
ogooOol00005Ool2003^Ool00:1oo`03001oogoo01eoo`03001oogoo01Uoo`05001oogooOol00003
Ool2003`Ool00:1oo`03001oogoo01eoo`03001oogoo01Uoo`06001oogooOol007oo0P00lWoo002Q
Ool00`00Oomoo`0LOol00`00Oomoo`0IOol01000Oomoogoo0P00m7oo002QOol01000Ool000006goo
00<007ooOol06Goo00D007ooOomoo`000?Eoo`00XWoo0`006goo00<007ooOol06Goo00D007ooOomo
o`000?Eoo`00Y7oo0P006Woo0`006Goo00D007ooOomoo`000?Eoo`00YGoo00<007ooOol067oo00<0
07ooOol06Goo00<007ooOol00P00mGoo002UOol00`00Oomoo`0HOol00`00Oomoo`0IOol00`00Oomo
o`02003eOol00:Eoo`03001oogoo01Qoo`03001oogoo01Uoo`03001oogoo00800?Eoo`00YWoo00<0
07ooOol05goo00<007ooOol06Goo00<007ooOol00P00mGoo002VOol00`00Oomoo`0GOol00`00Oomo
o`0IOol00`00Oomoo`02003eOol00:Ioo`03001oogoo01Moo`03001oogoo01Uoo`03001oogoo0080
0?Eoo`00YWoo00<007oo00005goo00<007ooOol06Goo00<007ooOol00P00mGoo002WOol3000FOol0
0`00Oomoo`0IOol00`00Oomoo`02003eOol00:Uoo`03001oogoo01Aoo`03001oogoo01Uoo`03001o
ogoo00800?Eoo`00ZGoo00<007ooOol057oo00<007ooOol06Goo00<007ooOol00P00mGoo002YOol0
0`00Oomoo`0DOol00`00Oomoo`0IOol00`00Oomoo`02003eOol00:Yoo`03001oogoo01=oo`03001o
ogoo01Uoo`03001oogoo00800?Eoo`00ZWoo00<007ooOol04goo00<007ooOol06Goo00<007ooOol0
0P00mGoo002ZOol00`00Oomoo`0COol3000IOol01@00Ool007oo0000mGoo002[Ool00`00Oomoo`0B
Ool00`00Oomoo`0IOol01@00Ool007oo0000mGoo002[Ool00`00Oomoo`0BOol00`00Oomoo`0IOol0
1@00Ool007oo0000mGoo002/Ool00`00Oomoo`0AOol00`00Oomoo`0IOol01@00Ool007oo0000mGoo
002/Ool00`00Oomoo`0AOol00`00Oomoo`0IOol01@00Ool007oo0000mGoo002/Ool00`00Oomoo`0A
Ool00`00Oomoo`0FOol02000Oomoo`00Ool007oo003eOol00:eoo`03001oogoo011oo`03001oogoo
01Ioo`08001oogoo001oo`00Ool00?Eoo`00[Goo00<007ooOol047oo00<007ooOol05Woo00P007oo
Ool007oo001oo`00mGoo002]Ool00`00Oomoo`0@Ool00`00Oomoo`0FOol02000Oomoo`00Ool007oo
003eOol00:ioo`03001oogoo00moo`03001oogoo01Ioo`08001oogoo001oo`00Ool00?Eoo`00[Woo
00<007ooOol03goo00<007ooOol05Woo00P007ooOol007oo001oo`00mGoo002^Ool00`00Oomoo`0?
Ool00`00Oomoo`0FOol02000Oomoo`00Ool007oo003eOol00:moo`03001oogoo00ioo`03001oogoo
01Ioo`08001oogoo001oo`00Ool00?Eoo`00[goo00<007ooOol03Woo0`005Woo00P007ooOol007oo
001oo`00mGoo002_Ool00`00Oomoo`0>Ool00`00Oomoo`0FOol02000Oomoo`00Ool007oo003eOol0
0:moo`03001oogoo00ioo`03001oogoo01Ioo`08001oogoo001oo`00Ool00?Eoo`00/7oo00<007oo
Ool03Goo00<007ooOol05Woo00P007ooOol007oo001oo`00mGoo002`Ool00`00Oomoo`0=Ool00`00
Oomoo`0FOol02000Oomoo`00Ool007oo003eOol00;1oo`03001oogoo00eoo`03001oogoo01Ioo`08
001oogoo001oo`00Ool00?Eoo`00/Goo00<007ooOol037oo00<007ooOol05Woo00P007ooOol007oo
001oo`00mGoo002aOol00`00Oomoo`0<Ool00`00Oomoo`0FOol02000Oomoo`00Ool007oo003eOol0
0;5oo`03001oogoo00aoo`03001oogoo01Ioo`08001oogoo001oo`00Ool00?Eoo`00/Woo00<007oo
Ool02goo00<007ooOol05Woo00P007ooOol007oo001oo`00mGoo002bOol00`00Ool000050006Ool0
0`00Oomoo`0FOol02000Oomoo`00Ool007oo003eOol00;9oo`03001oo`0000]oo`03001oogoo01Io
o`08001oogoo001oo`00Ool00?Eoo`00/goo00<007oo00002Woo00<007ooOol05Woo00P007ooOol0
07oo001oo`00mGoo002cOol01000Oomoo`002Goo00<007ooOol05Woo00<007ooOol00P000Woo00<0
07ooOol0lgoo002cOol01@00Oomoogoo000027oo10005Goo00<007ooOol00P000Woo00<007ooOol0
lgoo002dOol01@00Oomoogoo00001goo00<007ooOol05Woo00<007ooOol00P000Woo00<007ooOol0
lgoo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0AOol00`00Oomoo`02Ool00`00
Oomoo`020002Ool00`00Oomoo`3cOol00;Aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo
015oo`04001oogooOol20002Ool20002Ool00`00Oomoo`3cOol00;Aoo`03001oogoo009oo`03001o
ogoo00Aoo`03001oogoo015oo`04001oogooOol20002Ool20002Ool00`00Oomoo`3cOol00;Eoo`@0
00Moo`03001oogoo015oo`80009oo`80009oo`80009oo`03001oogoo0?=oo`00]Goo00<007ooOol0
27oo00<007ooOol04Goo0P000Woo0P000Woo0P000Woo00<007ooOol0lgoo002eOol00`00Oomoo`08
Ool00`00Oomoo`0AOol20002Ool20002Ool20002Ool00`00Oomoo`3cOol00;Ioo`03001oogoo00Mo
o`03001oogoo015oo`80009oo`80009oo`80009oo`03001oogoo0?=oo`00]Woo00<007ooOol01goo
00<007ooOol04Goo0P000Woo0P000Woo0P000Woo00<007ooOol0lgoo002fOol00`00Oomoo`07Ool0
0`00Oomoo`0AOol20002Ool20002Ool20002Ool00`00Oomoo`3cOol00;Moo`03001oogoo00Ioo`03
001oogoo015oo`80009oo`80009oo`80009oo`03001oogoo0?=oo`00]goo00<007ooOol01Woo00<0
07ooOol04Goo0P000Woo0P000Woo0P000Woo00<007ooOol0lgoo002gOol00`00Oomoo`06Ool3000A
Ool20002Ool20002Ool20002Ool00`00Oomoo`3cOol00;Qoo`03001oogoo00Eoo`03001oogoo015o
o`80009oo`80009oo`80009oo`03001oogoo0?=oo`00^7oo00<007ooOol01Goo00<007ooOol04Goo
0P000Woo0P000Woo0P000Woo00<007ooOol0lgoo002hOol00`00Oomoo`05Ool00`00Oomoo`0AOol2
0002Ool20002Ool20002Ool00`00Oomoo`3cOol00;Uoo`03001oogoo00Aoo`03001oogoo015oo`80
009oo`80009oo`80009oo`03001oogoo0?=oo`00^Goo00<007ooOol017oo00<007ooOol04Goo0P00
0Woo0P000Woo0P000Woo00<007ooOol0lgoo002iOol00`00Oomoo`04Ool00`00Oomoo`0AOol20002
Ool20002Ool20002Ool00`00Oomoo`3cOol00;Yoo`03001oogoo00=oo`03001oogoo015oo`80009o
o`80009oo`80009oo`03001oogoo0?=oo`00^Woo00<007ooOol00goo00<007ooOol04Goo0P000Woo
0P000Woo0P000Woo00<007ooOol0lgoo002jOol00`00Oomoo`03Ool00`00Oomoo`0=Ool01000Oomo
ogoo0P000Woo0P000Woo0P000Woo00<007ooOol0lgoo002jOol00`00Oomoo`03Ool00`00Oomoo`0=
Ool01000Oomoogoo0P000Woo0P000Woo0P000Woo00<007ooOol0lgoo002kOol00`00Oomoo`02Ool0
0`00Oomoo`0=Ool01000Oomoogoo0P000Woo0P000Woo0P000Woo00<007ooOol0lgoo002kOol00`00
Oomoo`02Ool00`00Oomoo`0=Ool01000Oomoogoo0P000Woo0P000Woo0P000Woo00<007ooOol0lgoo
002kOol00`00Oomoo`02Ool00`00Oomoo`0=Ool01000Oomoogoo0P000Woo0P000Woo0P000Woo00<0
07ooOol0lgoo002lOol01000Oomoogoo0`003Goo00@007ooOomoo`80009oo`80009oo`80009oo`03
001oogoo0?=oo`00_7oo00D007ooOomoo`0000moo`04001oogooOol20002Ool20002Ool20002Ool0
0`00Oomoo`3cOol00;aoo`05001oogooOol0000?Ool01000Oomoogoo0P000Woo0P000Woo0P000Woo
00<007ooOol0lgoo002mOol01000Oomoo`003goo00@007ooOomoo`80009oo`80009oo`80009oo`03
001oogoo0?=oo`00_Goo00@007ooOol000moo`04001oogooOol20002Ool20002Ool20002Ool00`00
Oomoo`3cOol00;eoo`04001oogoo000?Ool01000Oomoogoo0P000Woo0P000Woo0P000Woo00<007oo
Ool0lgoo002nOol00`00Ool0000?Ool01000Oomoogoo0P000Woo00@007oo001oo`80009oo`03001o
ogoo0?=oo`00_Woo00<007oo00003goo00@007ooOomoo`80009oo`04001oo`00Ool20002Ool00`00
Oomoo`3cOol00;ioo`03001oo`0000ioo`8000=oo`80009oo`04001oo`00Ool20002Ool00`00Oomo
o`3cOol00;moo`8000]oo`03001oogoo008000=oo`80009oo`04001oo`00Ool20002Ool00`00Oomo
o`3cOol00;moo`8000Yoo`80009oo`03001oo`00009oo`80009oo`04001oo`00Ool20002Ool00`00
Oomoo`3cOol00;moo`8000Yoo`80009oo`03001oo`00009oo`80009oo`04001oo`00Ool20002Ool0
0`00Oomoo`3cOol00;moo`8000Yoo`80009oo`03001oo`00009oo`80009oo`04001oo`00Ool20002
Ool00`00Oomoo`3cOol00<1oo`<000Qoo`80009oo`03001oo`00009oo`80009oo`04001oo`00Ool2
0002Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Qoo`80009oo`03001oo`00009oo`80009oo`05
001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Qoo`80009oo`03001oo`00009o
o`80009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Qoo`80009oo`03
001oo`00009oo`80009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`8000Uoo`80009o
o`03001oo`00009oo`80009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`8000Uoo`80
009oo`03001oo`00009oo`80009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`8000Uo
o`80009oo`03001oo`00009oo`80009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`80
00Uoo`80009oo`03001oo`00009oo`80009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1o
o`03001oo`0000Qoo`80009oo`03001oo`00009oo`80009oo`05001oo`00Ool00003Ool00`00Oomo
o`3cOol00<1oo`03001oo`0000Qoo`80009oo`03001oo`00009oo`80009oo`05001oo`00Ool00003
Ool00`00Oomoo`3cOol00;Moo`<000Ioo`03001oo`0000Qoo`80009oo`03001oo`00009oo`80009o
o`05001oo`00Ool00003Ool00`00Oomoo`3cOol00;Qoo`03001oogoo00Eoo`04001oogoo0007Ool2
0002Ool00`00Ool00002Ool20002Ool01@00Ool007oo00000goo00<007ooOol0lgoo002hOol00`00
Oomoo`05Ool01000Oomoo`001goo0P000Woo00<007oo00000Woo0P000Woo00D007oo001oo`0000=o
o`03001oogoo0?=oo`00]7oo1P001Woo00@007ooOol000Moo`80009oo`03001oo`00009oo`80009o
o`05001oo`00Ool00003Ool00`00Oomoo`3cOol00;Aoo`05001oogooOol00007Ool40007Ool20002
Ool00`00Ool00002Ool20002Ool01@00Ool007oo00000goo00<007ooOol0lgoo002eOol01000Oomo
o`001goo00D007ooOomoo`0000Ioo`80009oo`03001oo`00009oo`80009oo`05001oo`00Ool00003
Ool00`00Oomoo`3cOol00;Ioo`03001oo`0000Moo`05001oogooOol00006Ool20002Ool00`00Ool0
0002Ool20002Ool01@00Ool007oo00000goo00<007ooOol0lgoo002fOol00`00Ool00007Ool01@00
Oomoogoo00001Woo0P000Woo00<007oo00000Woo0P000Woo00D007oo001oo`0000=oo`03001oogoo
0?=oo`00]goo0P001goo00D007ooOomoo`0000Ioo`80009oo`03001oo`00009oo`09001oo`00Ool0
07oo001oo`0000=oo`03001oogoo0?=oo`00^7oo00<007ooOol01Goo00<007ooOol00Woo00<007oo
Ool00goo0P000Woo00D007oo001oo`00009oo`07001oo`00Ool007oo00000goo00<007ooOol0lgoo
0030Ool00`00Oomoo`02Ool00`00Oomoo`03Ool20002Ool01@00Ool007oo00000Woo00L007oo001o
o`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo009oo`03001oogoo00=oo`80009oo`05
001oo`00Ool00002Ool01`00Ool007oo001oo`0000=oo`03001oogoo0?=oo`00`7oo00<007ooOol0
0Woo00<007ooOol00goo00T007oo001oo`00Ool007oo00000Woo00L007oo001oo`00Ool00003Ool0
0`00Oomoo`3cOol00<1oo`03001oogoo00=oo`03001oogoo009oo`09001oo`00Ool007oo001oo`00
009oo`07001oo`00Ool007oo00000goo00<007ooOol0lgoo0030Ool00`00Oomoo`03Ool00`00Oomo
o`02Ool02@00Ool007oo001oo`00Ool00002Ool01`00Ool007oo001oo`0000=oo`03001oogoo0?=o
o`00`7oo00<007ooOol00goo00<007ooOol00Woo00T007oo001oo`00Ool007oo00000Woo00L007oo
001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Aoo`04001oogoo0002Ool01`00
Ool007oo001oo`00009oo`07001oo`00Ool007oo00000goo00<007ooOol0lgoo0030Ool30004Ool0
1000Oomoo`000Woo00L007oo001oo`00Ool00002Ool01`00Ool007oo001oo`0000=oo`03001oogoo
0?=oo`00`7oo00<007ooOol017oo00@007ooOol0009oo`07001oo`00Ool007oo00000Woo00L007oo
001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Aoo`04001oogoo0002Ool01`00
Ool007oo001oo`00009oo`07001oo`00Ool007oo00000goo00<007ooOol0lgoo0030Ool00`00Oomo
o`05Ool00`00Ool00002Ool01`00Ool007oo001oo`00009oo`07001oo`00Ool007oo00000goo00<0
07ooOol0lgoo0030Ool00`00Oomoo`05Ool00`00Ool00002Ool01`00Ool007oo001oo`00009oo`07
001oo`00Ool007oo00000goo00<007ooOol0lgoo0030Ool00`00Oomoo`05Ool00`00Ool00002Ool0
1`00Ool007oo001oo`00009oo`07001oo`00Ool007oo00000goo00<007ooOol0lgoo0030Ool00`00
Oomoo`05Ool00`00Ool00002Ool01`00Ool007oo001oo`00009oo`07001oo`00Ool007oo00000goo
00<007ooOol0lgoo0030Ool00`00Oomoo`06Ool20002Ool01`00Ool007oo001oo`00009oo`07001o
o`00Ool007oo00000goo00<007ooOol0lgoo0030Ool00`00Oomoo`06Ool20002Ool01`00Ool007oo
001oo`00009oo`07001oo`00Ool007oo00000goo00<007ooOol0lgoo0030Ool00`00Oomoo`06Ool2
0002Ool01`00Ool007oo001oo`00009oo`07001oo`00Ool007oo00000goo00<007ooOol0lgoo0030
Ool00`00Oomoo`06Ool20002Ool01`00Ool007oo001oo`00009oo`07001oo`00Ool007oo00000goo
00<007ooOol0lgoo0030Ool00`00Oomoo`07Ool02P00Oomoo`00Ool007oo001oo`000Woo00L007oo
001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Moo`0:001oogoo001oo`00Ool0
07oo0002Ool01`00Ool007oo001oo`0000=oo`03001oogoo0?=oo`00`7oo00<007ooOol02Woo0P00
0Woo00<007oo00000Woo00L007oo001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`<000Yoo`80
009oo`03001oo`00009oo`07001oo`00Ool007oo00000goo00<007ooOol0lgoo0030Ool00`00Oomo
o`0:Ool20002Ool00`00Ool00002Ool01`00Ool007oo001oo`0000=oo`03001oogoo0?=oo`00`7oo
00<007ooOol02Woo0P000goo0P000Woo00L007oo001oo`00Ool00003Ool00`00Oomoo`3cOol00<1o
o`03001oogoo00Yoo`8000=oo`80009oo`07001oo`00Ool007oo00000goo00<007ooOol0lgoo0030
Ool00`00Oomoo`0:Ool20003Ool20002Ool01`00Ool007oo001oo`0000=oo`03001oogoo0?=oo`00
`7oo00<007ooOol02Woo0P000goo0P000Woo00L007oo001oo`00Ool00003Ool00`00Oomoo`3cOol0
0<1oo`03001oogoo00Yoo`8000=oo`80009oo`07001oo`00Ool007oo00000goo00<007ooOol0lgoo
0030Ool00`00Oomoo`0:Ool20003Ool20002Ool01`00Ool007oo001oo`0000=oo`03001oogoo0?=o
o`00`7oo00<007ooOol02Woo0P000goo0P000Woo00L007oo001oo`00Ool00003Ool00`00Oomoo`3c
Ool00<1oo`03001oogoo00]oo`04001oogooOol20002Ool01`00Ool007oo001oo`0000=oo`03001o
ogoo0?=oo`00`7oo00<007ooOol02goo00@007ooOomoo`80009oo`80009oo`03001oo`0000=oo`03
001oogoo0?=oo`00`7oo00<007ooOol02goo00@007ooOomoo`80009oo`80009oo`03001oo`0000=o
o`03001oogoo0?=oo`00`7oo00<007ooOol02goo00@007ooOomoo`80009oo`80009oo`03001oo`00
00=oo`03001oogoo0?=oo`00`7oo0`002goo00@007ooOomoo`80009oo`80009oo`03001oo`0000=o
o`03001oogoo0?=oo`00`7oo00<007ooOol03goo0P000Woo0P000Woo00<007oo00000goo00<007oo
Ool0lgoo0030Ool00`00Oomoo`0?Ool20002Ool20002Ool00`00Ool00003Ool00`00Oomoo`3cOol0
0<1oo`03001oogoo00moo`80009oo`80009oo`03001oo`0000=oo`03001oogoo0?=oo`00`7oo00<0
07ooOol03goo0P000Woo0P000goo0P000goo00<007ooOol0lgoo0030Ool00`00Oomoo`0?Ool20002
Ool20003Ool20003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00moo`80009oo`8000=oo`8000=o
o`03001oogoo0?=oo`00`7oo00<007ooOol03goo0P000Woo0P000goo0P000goo00<007ooOol0lgoo
0030Ool00`00Oomoo`0?Ool20002Ool20003Ool20003Ool00`00Oomoo`3cOol00<1oo`03001oogoo
00moo`80009oo`8000=oo`8000=oo`03001oogoo0?=oo`00]Goo10001goo00<007ooOol03goo00@0
07ooOomoo`8000=oo`8000=oo`03001oogoo0?=oo`00]7oo00<007ooOol00Woo00<007ooOol017oo
00<007ooOol03goo00@007ooOomoo`8000=oo`8000=oo`03001oogoo0?=oo`00]7oo00<007ooOol0
0Woo00<007ooOol017oo00<007ooOol04goo0P000goo0P000goo00<007ooOol0lgoo002dOol00`00
Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0COol20003Ool20003Ool00`00Oomoo`3cOol00;Ao
o`8000=oo`03001oogoo00Aoo`@0019oo`8000=oo`8000=oo`03001oogoo0?=oo`00]7oo00<007oo
00000P001goo00<007ooOol04goo0P000goo0P000goo00<007ooOol0lgoo002dOol00`00Oomoo`09
Ool00`00Oomoo`0COol20003Ool20003Ool00`00Oomoo`3cOol00;Aoo`03001oogoo00Uoo`03001o
ogoo01=oo`8000=oo`8000=oo`03001oogoo0?=oo`00]Goo00<007ooOol027oo00<007ooOol057oo
00@007ooOomoo`8000=oo`03001oogoo0?=oo`00]Woo0`001goo00<007ooOol067oo0P000goo00<0
07ooOol0lgoo0030Ool00`00Oomoo`0HOol20003Ool00`00Oomoo`3cOol00<1oo`03001oogoo01Qo
o`8000=oo`03001oogoo0?=oo`00`7oo00<007ooOol067oo0P000goo00<007ooOol0lgoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool3000IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00Oomo
ogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol0
1@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomo
o`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool0
0`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo
0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo
0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool3000IOol01@00
Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0I
Ool01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00
Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030
Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000
mGoo0030Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo0030Ool00`00Oomoo`0IOol01@00Oomo
ogoo0000mGoo002eOol40007Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomo
o`02Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02
Ool00`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool0
0`00Oomoo`04Ool00`00Oomoo`0IOol01@00Oomoogoo0000mGoo002dOol00`00Oomoo`02Ool00`00
Oomoo`04Ool4000HOol5003eOol00;Eoo`@000Moo`03001oogoo0?mooaAoo`00]7oo00<007ooOol0
0Woo00<007ooOol017oo00<007ooOol0ogoo57oo002dOol00`00Oomoo`02Ool00`00Oomoo`04Ool0
0`00Oomoo`3oOolDOol00;Aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0?mooaAoo`00
]Goo10001goo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mo
oaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mo
oaAoo`00`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00
`7oo00<007ooOol0ogoo57oo0030Ool3003oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<0
07ooOol0ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`<00?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00`7oo00<007ooOol0
ogoo57oo0030Ool00`00Oomoo`3oOolDOol00<1oo`03001oogoo0?mooaAoo`00[7oo1@0017oo1000
1goo00<007ooOol0ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool0
0`00Oomoo`3oOolDOol00:ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo00Aoo`03001o
ogoo0?mooaAoo`00[Woo00<007ooOol00goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol0
ogoo57oo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`04Ool4003oOolCOol00:io
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo0?mooa]oo`00[Woo00<007ooOol00goo00<0
07ooOol00Woo00<007ooOol0ogoo6goo002^Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomo
o`3oOolKOol00:aoo`<000Eoo`03001oogoo009oo`03001oogoo0?mooa]oo`00\
\>"],
  ImageRangeCache->{{{0, 469}, {289.313, 0}} -> {-13.8869, -0.535215, 
  0.0720124, 0.03699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.404762 0.031746 0 0.0618034 [
[.0873 -0.0125 -9 -9 ]
[.0873 -0.0125 9 0 ]
[.24603 -0.0125 -6 -9 ]
[.24603 -0.0125 6 0 ]
[.56349 -0.0125 -3 -9 ]
[.56349 -0.0125 3 0 ]
[.72222 -0.0125 -6 -9 ]
[.72222 -0.0125 6 0 ]
[.88095 -0.0125 -6 -9 ]
[.88095 -0.0125 6 0 ]
[.39226 .12361 -6 -4.5 ]
[.39226 .12361 0 4.5 ]
[.39226 .24721 -6 -4.5 ]
[.39226 .24721 0 4.5 ]
[.39226 .37082 -6 -4.5 ]
[.39226 .37082 0 4.5 ]
[.39226 .49443 -6 -4.5 ]
[.39226 .49443 0 4.5 ]
[.39226 .61803 -12 -4.5 ]
[.39226 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.0873 0 m
.0873 .00625 L
s
[(-10)] .0873 -0.0125 0 1 Mshowa
.24603 0 m
.24603 .00625 L
s
[(-5)] .24603 -0.0125 0 1 Mshowa
.56349 0 m
.56349 .00625 L
s
[(5)] .56349 -0.0125 0 1 Mshowa
.72222 0 m
.72222 .00625 L
s
[(10)] .72222 -0.0125 0 1 Mshowa
.88095 0 m
.88095 .00625 L
s
[(15)] .88095 -0.0125 0 1 Mshowa
.125 Mabswid
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.18254 0 m
.18254 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.34127 0 m
.34127 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.5 0 m
.5 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.65873 0 m
.65873 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.81746 0 m
.81746 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.05556 0 m
.05556 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.40476 .12361 m
.41101 .12361 L
s
[(2)] .39226 .12361 1 0 Mshowa
.40476 .24721 m
.41101 .24721 L
s
[(4)] .39226 .24721 1 0 Mshowa
.40476 .37082 m
.41101 .37082 L
s
[(6)] .39226 .37082 1 0 Mshowa
.40476 .49443 m
.41101 .49443 L
s
[(8)] .39226 .49443 1 0 Mshowa
.40476 .61803 m
.41101 .61803 L
s
[(10)] .39226 .61803 1 0 Mshowa
.125 Mabswid
.40476 .0309 m
.40851 .0309 L
s
.40476 .0618 m
.40851 .0618 L
s
.40476 .09271 m
.40851 .09271 L
s
.40476 .15451 m
.40851 .15451 L
s
.40476 .18541 m
.40851 .18541 L
s
.40476 .21631 m
.40851 .21631 L
s
.40476 .27812 m
.40851 .27812 L
s
.40476 .30902 m
.40851 .30902 L
s
.40476 .33992 m
.40851 .33992 L
s
.40476 .40172 m
.40851 .40172 L
s
.40476 .43262 m
.40851 .43262 L
s
.40476 .46353 m
.40851 .46353 L
s
.40476 .52533 m
.40851 .52533 L
s
.40476 .55623 m
.40851 .55623 L
s
.40476 .58713 m
.40851 .58713 L
s
.25 Mabswid
.40476 0 m
.40476 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .00257 m
.02436 .00257 L
.02486 .00254 L
.02543 .00247 L
.02598 .00236 L
.02648 .00221 L
.02695 .00205 L
.028 .0016 L
.02855 .00132 L
.02915 .00103 L
.02971 .00083 L
.03023 .00081 L
.0308 .00101 L
.03135 .00133 L
.03259 .00222 L
.0337 .00296 L
.03431 .0033 L
.03488 .00354 L
.03542 .0037 L
.036 .00379 L
.03653 .00378 L
.03701 .0037 L
.03759 .00351 L
.03813 .00324 L
.03872 .00285 L
.03936 .00234 L
.04056 .00116 L
.04117 .00061 L
.04151 .00053 L
.04184 .00072 L
.04217 .00104 L
.04247 .00137 L
.04315 .00213 L
.04437 .00335 L
.04501 .00386 L
.04538 .00409 L
.04571 .00426 L
.04606 .0044 L
.04644 .0045 L
.04679 .00455 L
.04712 .00454 L
.04773 .00443 L
.04803 .00431 L
.04837 .00415 L
.04897 .00376 L
.04952 .00329 L
.05086 .00182 L
.05151 .00099 L
.05212 .00018 L
.05267 .00055 L
Mistroke
.05325 .00131 L
.05449 .00273 L
.05507 .00329 L
.05562 .00372 L
.05611 .00402 L
.05665 .00424 L
.05723 .00437 L
.05757 .00439 L
.05788 .00437 L
.05821 .00431 L
.0585 .00422 L
.05885 .00408 L
.05918 .00391 L
.06029 .00312 L
.0615 .00197 L
.06204 .00143 L
.0626 .00088 L
.06321 .00053 L
.06377 .00078 L
.0643 .00122 L
.06479 .00165 L
.0659 .00249 L
.06653 .00286 L
.06713 .00312 L
.06767 .00328 L
.06825 .00337 L
.06855 .00339 L
.06888 .00339 L
.06923 .00335 L
.06955 .0033 L
.07013 .00315 L
.07075 .00293 L
.07338 .00148 L
.07401 .00109 L
.07468 .00068 L
.07525 .00043 L
.07557 .0004 L
.07588 .00046 L
.07644 .00072 L
.07696 .001 L
.07812 .0016 L
.07931 .00211 L
.0799 .00232 L
.08022 .00241 L
.08056 .00249 L
.08117 .0026 L
.08174 .00266 L
.08235 .00268 L
.0827 .00267 L
.08302 .00265 L
Mistroke
.08361 .00257 L
.08414 .00246 L
.08476 .00229 L
.08535 .00209 L
.08745 .00118 L
.08806 .00094 L
.08863 .0008 L
.08914 .00083 L
.0897 .00102 L
.09031 .00135 L
.09096 .00176 L
.09212 .00251 L
.09321 .00314 L
.09381 .00342 L
.09437 .00362 L
.09469 .00371 L
.09503 .00377 L
.09563 .00382 L
.09624 .00376 L
.0968 .00362 L
.09742 .00336 L
.09777 .00317 L
.0981 .00296 L
.09947 .00181 L
.10002 .0013 L
.10061 .00086 L
.10116 .00086 L
.10167 .00127 L
.10291 .00264 L
.10406 .00381 L
.10464 .00428 L
.10526 .00466 L
.10587 .00491 L
.10622 .00498 L
.10655 .005 L
.10714 .00492 L
.10768 .00472 L
.10798 .00456 L
.10831 .00434 L
.1089 .00384 L
.11004 .00255 L
.11107 .00112 L
.11164 .00033 L
.11196 .00034 L
.11226 .00074 L
.11338 .00235 L
.11443 .00366 L
.11494 .00418 L
.1154 .00457 L
.11589 .00489 L
Mistroke
.11642 .00511 L
.11699 .00522 L
.11754 .00519 L
.11807 .00504 L
.11865 .00473 L
.11919 .00433 L
.11969 .00386 L
.12092 .00244 L
.12206 .00094 L
.12263 .00041 L
.12323 .00088 L
.12358 .00131 L
.1239 .00171 L
.12451 .00241 L
.12564 .00348 L
.12594 .0037 L
.12627 .00391 L
.12685 .00418 L
.12739 .00434 L
.12788 .00439 L
.12844 .00435 L
.12897 .00422 L
.12947 .00403 L
.12992 .0038 L
.13095 .0031 L
.13208 .00217 L
.13314 .00126 L
.13367 .00087 L
.13424 .00066 L
.13455 .00069 L
.13487 .00083 L
.13546 .00119 L
.13655 .00191 L
.13713 .00225 L
.13775 .00255 L
.13828 .00277 L
.13887 .00296 L
.13941 .00308 L
.13991 .00316 L
.14023 .00318 L
.14053 .00319 L
.14111 .00316 L
.14143 .00312 L
.14173 .00307 L
.14205 .003 L
.1424 .00291 L
.14359 .00247 L
.14466 .00193 L
.1457 .00133 L
.14626 .00099 L
Mistroke
.14679 .00072 L
.14736 .00056 L
.14766 .00059 L
.14798 .0007 L
.14856 .00102 L
.14908 .00135 L
.15106 .00261 L
.1521 .00318 L
.15265 .00342 L
.15323 .00363 L
.15384 .00378 L
.15439 .00386 L
.15491 .00388 L
.15548 .00383 L
.15608 .00368 L
.15642 .00356 L
.15672 .00343 L
.15787 .00273 L
.15893 .00187 L
.15949 .00142 L
.16007 .00111 L
.16059 .00117 L
.16116 .0016 L
.16167 .00214 L
.16215 .00268 L
.16341 .00404 L
.16403 .0046 L
.1646 .00501 L
.16512 .00529 L
.16567 .00547 L
.16622 .00552 L
.16683 .00541 L
.16715 .00529 L
.16748 .00511 L
.16807 .00467 L
.16871 .00403 L
.16942 .00315 L
.17003 .00227 L
.17068 .00128 L
.17124 .00059 L
.17185 .00102 L
.17246 .00198 L
.17303 .00289 L
.1737 .00389 L
.17431 .00468 L
.17484 .00526 L
.17543 .00575 L
.17575 .00595 L
.17604 .00609 L
.17663 .00622 L
Mistroke
.1772 .00618 L
.17774 .00598 L
.17822 .00568 L
.17874 .00522 L
.17991 .00379 L
.18098 .0021 L
.18155 .00114 L
.18216 .00022 L
.18273 .00096 L
.18325 .00182 L
.18454 .00371 L
.18511 .00437 L
.18574 .00495 L
.18633 .00535 L
.18666 .00549 L
.18697 .00559 L
.18731 .00564 L
.18762 .00564 L
.18796 .00559 L
.18831 .00549 L
.18892 .00519 L
.18948 .00479 L
.19075 .00354 L
.1919 .00217 L
.19253 .00142 L
.19311 .00087 L
.19342 .00075 L
.19375 .00084 L
.19411 .00112 L
.19444 .00143 L
.19567 .0026 L
.19681 .00344 L
.19712 .00362 L
.19745 .00378 L
.19805 .004 L
.19866 .00413 L
.19923 .00416 L
.19975 .00413 L
.2003 .00403 L
.20084 .00387 L
.20142 .00363 L
.20247 .00305 L
.20369 .0022 L
.20479 .0013 L
.20534 .00083 L
.20585 .00039 L
.20638 .0002 L
.20697 .00066 L
.20898 .00229 L
.21008 .00303 L
Mistroke
.21112 .00358 L
.2117 .00381 L
.212 .00391 L
.21233 .004 L
.2129 .00411 L
.21343 .00416 L
.21376 .00416 L
.21406 .00415 L
.21439 .00411 L
.21474 .00404 L
.21534 .00386 L
.21567 .00373 L
.21599 .00359 L
.2171 .00291 L
.21831 .002 L
.21862 .00177 L
.21896 .00156 L
.21957 .00142 L
.21991 .00151 L
.22022 .0017 L
.22057 .00199 L
.22095 .00237 L
.22216 .00377 L
.22283 .00451 L
.22345 .00512 L
.22406 .00561 L
.22462 .00595 L
.22494 .00609 L
.22524 .00618 L
.22555 .00623 L
.2259 .00623 L
.22646 .0061 L
.22706 .00579 L
.22758 .00539 L
.22814 .0048 L
.2293 .00318 L
.22992 .00218 L
.23025 .00164 L
.23057 .0012 L
.23087 .00097 L
.2312 .0011 L
.23177 .00193 L
.23288 .00394 L
.23398 .00569 L
.23453 .0064 L
.23513 .00699 L
.23565 .00733 L
.23621 .00751 L
.23673 .00751 L
.23721 .00735 L
Mistroke
.23781 .00694 L
.23812 .00664 L
.23846 .00626 L
.23961 .00451 L
.24086 .00203 L
.24121 .00129 L
.24157 .0005 L
.24188 .00019 L
.24222 .00092 L
.24348 .00353 L
.2441 .00463 L
.24466 .00549 L
.24519 .00617 L
.24577 .00673 L
.24638 .00711 L
.24696 .00726 L
.24753 .00721 L
.24806 .007 L
.24867 .00657 L
.24924 .00599 L
.25026 .00463 L
.25138 .00282 L
.25201 .00177 L
.2526 .00093 L
.25293 .00077 L
.25328 .00102 L
.25361 .00144 L
.2539 .00187 L
.25511 .00353 L
.2557 .0042 L
.25624 .0047 L
.25681 .00512 L
.25734 .0054 L
.25791 .00557 L
.25852 .00562 L
.25882 .0056 L
.25915 .00554 L
.2595 .00543 L
.25982 .0053 L
.2604 .005 L
.26102 .00457 L
.26229 .00346 L
.26364 .00202 L
.26429 .00127 L
.26461 .0009 L
.26491 .00056 L
.26546 .00021 L
.26606 .00082 L
.26831 .00308 L
.26893 .00358 L
Mistroke
.26959 .00404 L
.27016 .00437 L
.27078 .00464 L
.27113 .00476 L
.27145 .00484 L
.27176 .0049 L
.27209 .00494 L
.27265 .00495 L
.27298 .00492 L
.27328 .00487 L
.2736 .0048 L
.27394 .0047 L
.27455 .00446 L
.27521 .00411 L
.27593 .00364 L
.27713 .0027 L
.27773 .00224 L
.27827 .00192 L
.27858 .00182 L
.2789 .00181 L
.27923 .00192 L
.27959 .00215 L
.2802 .00275 L
.28078 .00345 L
.28192 .00489 L
.28254 .00564 L
.28313 .00626 L
.28367 .00675 L
.28427 .00714 L
.28481 .00736 L
.2853 .00743 L
.28584 .00736 L
.28643 .00709 L
.28705 .00659 L
.28762 .00593 L
.28885 .004 L
.28947 .00283 L
.2898 .00222 L
.29016 .00167 L
.29046 .00142 L
.2908 .00154 L
.2914 .00253 L
.29257 .00506 L
.29372 .00728 L
.29422 .00805 L
.29477 .00871 L
.29531 .00916 L
.29581 .00938 L
.29635 .00939 L
.29692 .00915 L
Mistroke
.29722 .00892 L
.29754 .00859 L
.29813 .00779 L
.29923 .00566 L
.30029 .00303 L
.30087 .00145 L
.30141 .00011 L
.30187 .00138 L
.30237 .00275 L
.30342 .0054 L
.30403 .00672 L
.30461 .00775 L
.30521 .00858 L
.30553 .00891 L
.30588 .00917 L
.30645 .00939 L
.30706 .00933 L
.30758 .00904 L
.30815 .00849 L
.31065 .00399 L
.31099 .00325 L
.31137 .0025 L
.31172 .00191 L
.31204 .00162 L
.31266 .00201 L
.31297 .0025 L
.31331 .00311 L
.31452 .00517 L
.3152 .00606 L
.31553 .0064 L
.31582 .00665 L
.3164 .00701 L
.3167 .00711 L
.31703 .00717 L
.31763 .00712 L
.31817 .00692 L
.31876 .00657 L
.31929 .00614 L
.32051 .00501 L
.3211 .00447 L
.32165 .00403 L
.32216 .00373 L
.3227 .00352 L
.32325 .00343 L
.32384 .00343 L
.32434 .00347 L
.3249 .00352 L
.32548 .00354 L
.32581 .00353 L
.32611 .00351 L
Mistroke
.32666 .00345 L
.32725 .00335 L
.32776 .00328 L
.3283 .00323 L
.32881 .00327 L
.32927 .00337 L
.32982 .00359 L
.33041 .00393 L
.33149 .00468 L
.33205 .00506 L
.33265 .00542 L
.333 .00559 L
.33331 .00571 L
.33393 .00584 L
.33426 .00585 L
.33456 .00582 L
.3349 .00575 L
.33525 .00561 L
.33559 .00543 L
.33591 .00521 L
.33651 .00469 L
.33767 .0033 L
.33822 .00255 L
.33873 .00191 L
.33929 .00158 L
.3399 .00202 L
.3405 .00296 L
.34114 .00414 L
.34234 .00638 L
.34299 .00747 L
.34361 .00835 L
.34418 .00899 L
.3447 .00943 L
.34528 .00974 L
.3456 .00982 L
.3459 .00984 L
.34622 .0098 L
.34652 .00971 L
.34686 .00956 L
.34718 .00936 L
.34837 .00837 L
.3487 .00809 L
.349 .00787 L
.34932 .0077 L
.34967 .0076 L
.35002 .00763 L
.3504 .00783 L
.35075 .00816 L
.35107 .00859 L
.35338 .01325 L
Mistroke
.35401 .01443 L
.35436 .01498 L
.35469 .01542 L
.35526 .01599 L
.35557 .01617 L
.3559 .01628 L
.35645 .01626 L
.35706 .01597 L
.35736 .01574 L
.35769 .01546 L
.35828 .01496 L
.35887 .01462 L
.35943 .01465 L
.35993 .0151 L
.36047 .01608 L
.36104 .01764 L
.36157 .01942 L
.36275 .02384 L
.36327 .02566 L
.36384 .02736 L
.36438 .02856 L
.36488 .02925 L
.36519 .02945 L
.36552 .02947 L
.36612 .02897 L
.3667 .02787 L
.36723 .02642 L
.36786 .02444 L
.36845 .02274 L
.36907 .02178 L
.36939 .02184 L
.36974 .02247 L
.37006 .02356 L
.3704 .02522 L
.371 .02925 L
.37238 .04051 L
.37295 .04499 L
.37357 .0491 L
.37392 .051 L
.37424 .05239 L
.37455 .05337 L
.37488 .05402 L
.37544 .05412 L
.37603 .05276 L
.3766 .0501 L
.37711 .04663 L
.37828 .03644 L
.3786 .0337 L
.37894 .03127 L
.37926 .0298 L
Mistroke
.37956 .02944 L
.38011 .0318 L
.38072 .03835 L
.38129 .04686 L
.38182 .05556 L
.38296 .07352 L
.38357 .08131 L
.38389 .08466 L
.38422 .08754 L
.38478 .09067 L
.3853 .09154 L
.38578 .0905 L
.38631 .08724 L
.38686 .0815 L
.38745 .07293 L
.38852 .05324 L
.38884 .04732 L
.38917 .04186 L
.38977 .03697 L
.39011 .03845 L
.39042 .04262 L
.39076 .04957 L
.39113 .05879 L
.3924 .09428 L
.39303 .11037 L
.39361 .123 L
.39416 .13238 L
.39476 .13879 L
.3951 .14061 L
.39542 .14102 L
.39602 .13829 L
.39657 .13169 L
.39708 .12225 L
.39764 .10846 L
.39823 .09065 L
.3988 .07162 L
.3991 .06169 L
.39942 .05227 L
.4 .04335 L
.40054 .05098 L
.40106 .06886 L
.40155 .08942 L
.40265 .13711 L
.40323 .15901 L
.40384 .17799 L
.40437 .19008 L
.40494 .19831 L
.40555 .20079 L
.4059 .19912 L
.40621 .19567 L
Mistroke
.40682 .18369 L
.4074 .16625 L
.40843 .12182 L
.409 .09275 L
.40953 .06605 L
.40998 .0499 L
.41047 .05117 L
.41101 .07462 L
.4115 .10393 L
.41259 .17107 L
.41317 .20248 L
.41378 .23043 L
.41437 .25063 L
.41491 .2624 L
.41545 .26742 L
.41595 .26558 L
.4165 .25634 L
.41708 .23822 L
.41763 .21369 L
.41813 .18569 L
.41873 .14608 L
.41937 .09973 L
.41992 .06279 L
.42052 .05094 L
.42113 .08702 L
.42171 .13383 L
.423 .23543 L
.42355 .27116 L
.42413 .30138 L
.42443 .31376 L
.42476 .32435 L
.42534 .33499 L
.42593 .33503 L
.42648 .32503 L
.42697 .30782 L
.42751 .28076 L
.42809 .24197 L
.42871 .19192 L
.42924 .14301 L
.42981 .08841 L
.43035 .0488 L
.43084 .06076 L
.43133 .1061 L
.43179 .15451 L
.43291 .26513 L
.43346 .31086 L
.43397 .34581 L
.43447 .37281 L
.435 .392 L
.43553 .40101 L
Mistroke
.43611 .3986 L
.4367 .38279 L
.43703 .36814 L
.43733 .35134 L
.43791 .30963 L
.43847 .26032 L
.43958 .13875 L
.44019 .06821 L
.44076 .0446 L
.44138 .10975 L
.44205 .19381 L
.44325 .3266 L
.44378 .37383 L
.44436 .41448 L
.4449 .44109 L
.44541 .45469 L
.44591 .45714 L
.44637 .44973 L
.44689 .42988 L
.44739 .40047 L
.44951 .17609 L
.45009 .09661 L
.45041 .05412 L
.45072 .03001 L
.45131 .09251 L
.45184 .16828 L
.45281 .2965 L
.45383 .40608 L
.45437 .44817 L
.45496 .48053 L
.4555 .49611 L
.456 .49821 L
.45654 .48695 L
.4571 .46028 L
.45759 .42602 L
.45811 .37736 L
.45929 .2331 L
.45982 .15694 L
.46039 .07019 L
.46093 .02426 L
.46142 .09641 L
.46238 .24174 L
.46332 .36335 L
.46419 .45026 L
.46465 .48273 L
.46513 .50696 L
.46567 .52027 L
.46617 .51961 L
.46668 .50593 L
.46724 .47634 L
Mistroke
.46777 .43507 L
.46825 .38626 L
Mfstroke
.46825 .38626 m
.46864 .34619 L
.46906 .30722 L
.46946 .27464 L
.46984 .24656 L
.47024 .21983 L
.47063 .19683 L
.47105 .17502 L
.47145 .15628 L
.47183 .14015 L
.47224 .1248 L
.47263 .1116 L
.47301 .10023 L
.47341 .08941 L
.4738 .08011 L
.47421 .07132 L
.47461 .06384 L
.47499 .05748 L
.4754 .05157 L
.47579 .0467 L
.47621 .04238 L
.47661 .0391 L
.47699 .03678 L
.47719 .03591 L
.47729 .03557 L
.4774 .03526 L
.4775 .03505 L
.4776 .0349 L
.47764 .03485 L
.47766 .03483 L
.47769 .03481 L
.47771 .0348 L
.47772 .03479 L
.47774 .03479 L
.47775 .03478 L
.47776 .03478 L
.47777 .03478 L
.47778 .03478 L
s
.47778 .03478 m
.48248 .03398 L
.48762 .03277 L
.498 .02941 L
.52005 .01974 L
.54125 .01033 L
.55103 .00684 L
.56165 .00392 L
.56745 .00274 L
.5728 .00189 L
.57792 .0013 L
.5805 .00106 L
.58334 .00086 L
.58606 .0007 L
.58865 .00059 L
.5935 .00043 L
.59872 .00031 L
.60168 .00026 L
.60311 .00024 L
.60374 .00023 L
.60443 .00022 L
.6051 .00022 L
.60572 .00021 L
.60638 .00021 L
.60675 .00021 L
.60708 .00021 L
.60745 .00021 L
.60779 .00021 L
.60816 .00021 L
.60856 .00021 L
.60922 .00022 L
.60996 .00023 L
.61125 .00024 L
.61264 .00026 L
.61517 .00031 L
.62491 .00051 L
.62733 .00055 L
.62991 .00059 L
.6314 .0006 L
.63275 .00061 L
.63411 .00062 L
.63477 .00063 L
.63539 .00063 L
.63603 .00063 L
.63637 .00063 L
.63673 .00063 L
.63711 .00063 L
.63747 .00063 L
.63815 .00063 L
.63878 .00063 L
Mistroke
.63937 .00063 L
.64001 .00063 L
.64069 .00063 L
.64144 .00063 L
.64224 .00062 L
.64371 .00061 L
.64643 .00058 L
.64902 .00054 L
.65142 .0005 L
.65689 .00038 L
.66256 .00024 L
.66535 .00016 L
.66792 9e-005 L
.6692 6e-005 L
.66983 4e-005 L
.6704 3e-005 L
.67101 2e-005 L
.67165 3e-005 L
.67233 4e-005 L
.67304 6e-005 L
.67859 .0002 L
.68369 .00032 L
.68831 .0004 L
.69089 .00043 L
.69332 .00046 L
.69465 .00047 L
.69588 .00047 L
.69723 .00048 L
.69791 .00048 L
.69827 .00048 L
.69866 .00049 L
.69931 .00049 L
.69992 .00049 L
.70051 .00049 L
.70106 .00049 L
.70165 .00049 L
.70231 .00049 L
.70299 .00048 L
.70363 .00048 L
.7048 .00048 L
.70587 .00047 L
.70828 .00045 L
.71076 .00042 L
.7134 .00039 L
.71817 .00031 L
.7238 .0002 L
.729 9e-005 L
.73034 6e-005 L
.7316 3e-005 L
.73223 2e-005 L
Mistroke
.73291 1e-005 L
.7333 2e-005 L
.73366 2e-005 L
.73435 4e-005 L
.74016 .00015 L
.74526 .00025 L
.7507 .00032 L
.7535 .00035 L
.75488 .00037 L
.75614 .00038 L
.75727 .00038 L
.75851 .00039 L
.75976 .00039 L
.76044 .0004 L
.76107 .0004 L
.76167 .0004 L
.76232 .0004 L
.76294 .0004 L
.7635 .0004 L
.76402 .0004 L
.76458 .0004 L
.76517 .0004 L
.76572 .0004 L
.76697 .00039 L
.76812 .00039 L
.7707 .00037 L
.77318 .00035 L
.77583 .00032 L
.78061 .00026 L
.78625 .00017 L
.79145 8e-005 L
.79405 3e-005 L
.79469 2e-005 L
.79537 1e-005 L
.79576 1e-005 L
.79611 1e-005 L
.79647 2e-005 L
.79681 2e-005 L
.80263 .00012 L
.80774 .0002 L
.81317 .00027 L
.81599 .0003 L
.81863 .00031 L
.821 .00033 L
.82234 .00033 L
.82293 .00033 L
.82357 .00034 L
.82417 .00034 L
.82473 .00034 L
.82528 .00034 L
Mistroke
.8258 .00034 L
.82642 .00034 L
.82698 .00034 L
.8276 .00034 L
.82826 .00034 L
.82884 .00034 L
.82947 .00033 L
.83061 .00033 L
.83196 .00033 L
.8332 .00032 L
.83569 .0003 L
.83835 .00028 L
.84313 .00023 L
.85397 8e-005 L
.85659 4e-005 L
.85791 2e-005 L
.85827 1e-005 L
.85865 1e-005 L
.85902 1e-005 L
.85935 1e-005 L
.85974 2e-005 L
.8601 2e-005 L
.86091 3e-005 L
.86238 6e-005 L
.86517 .0001 L
.87062 .00017 L
.87573 .00023 L
.87802 .00025 L
.88043 .00026 L
.88169 .00027 L
.88307 .00028 L
.88431 .00029 L
.88549 .00029 L
.88617 .00029 L
.88691 .00029 L
.88757 .00029 L
.88819 .0003 L
.88886 .0003 L
.88924 .0003 L
.88959 .0003 L
.88996 .0003 L
.89031 .0003 L
.8907 .0003 L
.89107 .0003 L
.8917 .00029 L
.89236 .00029 L
.89356 .00029 L
.89498 .00029 L
.89627 .00028 L
.89883 .00027 L
Mistroke
.90153 .00025 L
.90636 .0002 L
.91162 .00014 L
.91726 7e-005 L
.92003 3e-005 L
.92069 2e-005 L
.92139 1e-005 L
.92199 1e-005 L
.92265 1e-005 L
.92323 1e-005 L
.92386 2e-005 L
.925 4e-005 L
.92755 7e-005 L
.93715 .00018 L
.94217 .00022 L
.94501 .00024 L
.94766 .00025 L
.9491 .00026 L
.94981 .00026 L
.95046 .00026 L
.95104 .00026 L
.95168 .00026 L
.95232 .00026 L
.953 .00026 L
.95338 .00026 L
.95374 .00026 L
.95442 .00026 L
.9548 .00026 L
.95515 .00026 L
.95595 .00026 L
.95658 .00026 L
.95728 .00026 L
.9587 .00026 L
.96084 .00025 L
.96309 .00024 L
.96711 .00021 L
.97619 .00012 L
Mfstroke
.24603 0 m
.26202 0 L
.27945 0 L
.29583 0 L
.31158 0 L
.32834 0 L
.34447 0 L
.36162 0 L
.37815 0 L
.39404 0 L
.41095 0 L
.42723 0 L
.44289 0 L
.4516 0 L
.45956 0 L
.46349 0 L
.46557 0 L
.46671 0 L
.46727 0 L
.46779 0 L
.46828 .49443 L
.46881 .49443 L
.46991 .49443 L
.47184 .49443 L
.4756 .49443 L
.47666 .49443 L
.47718 .49443 L
.47766 .49443 L
.47809 0 L
.47855 0 L
.47953 0 L
.48373 0 L
.49132 0 L
.50694 0 L
.52357 0 L
.53958 0 L
.55661 0 L
.573 0 L
.58877 0 L
.60556 0 L
.62171 0 L
.63888 0 L
.65543 0 L
.67134 0 L
.68828 0 L
.70458 0 L
.72026 0 L
.72222 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{470, 290.313},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007F00018Q000`40O003h00O=Woo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0?Woo00<007ooOol0Pgoo00<007ooOol0?7oo00<007ooOol0
0goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0>goo000ZOol60006
Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0`Ool60008Ool00`00Oomoo`23Ool00`00
Oomoo`0lOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`08Ool00`00
Oomoo`0kOol003Ioo`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Uoo`D0085oo`D003mo
o`03001oogoo00=oo`03001oogoo009oo`03001oogoo03Qoo`03001oogoo00=oo`D003ioo`00=Woo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>Goo00<007ooOol0Pgoo00<007ooOol0@Goo
00<007ooOol00goo00<007ooOol00Woo00<007ooOol0>7oo00<007ooOol00goo00<007ooOol0@7oo
000fOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0iOol00`00Oomoo`23Ool00`00Oomo
o`11Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0hOol00`00Oomoo`03Ool00`00Oomo
o`10Ool003Aoo`<000Eoo`03001oogoo009oo`03001oogoo03Uoo`03001oogoo08=oo`03001oogoo
03moo`<000Eoo`03001oogoo009oo`03001oogoo03Ioo`<000Eoo`03001oogoo041oo`00=Woo00<0
07ooOol017oo1000?7oo1P00P7oo1P00?Woo00<007ooOol017oo1000>goo00<007ooOol00goo1P00
?Goo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol00?moomMoo`00ogooegoo003oOooGOol0
0?moomMoo`003gooo`00^00047oo000JOol20002Ool800000goo00000002000017oo000000000goo
10000Woo0`0000Ioo`00001oo`00Ool400000goo0000000200000goo000000020002Ool4000017oo
000007oo0`000Woo0`000Woo00<007oo00000`000Woo1P000goo0P000goo0`0000Aoo`00Ool0009o
o`800004Ool007ooOol30003Ool20003Ool20002Ool20003Ool50002Ool3000<Ool00`00Oomoo`0;
Ool00`00Oomoo`0;Ool00`00Oomoo`0;Ool01@00Oomoogoo00002Goo00<007ooOol02goo00<007oo
Ool02Goo1P002Woo00<007ooOol02goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol02goo
00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo00<007ooOol02goo
00<007ooOol02goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol06Goo000SOol20003Ool2
000;Ool00`00Oomoo`05Ool30002Ool20003Ool2000>Ool30002Ool20002Ool3000>Ool30002Ool0
1000Ool007oo100000Aoo`00000000=oo`<000=oo`05001oo`00Ool00002Ool01@00Ool007oo0000
0Woo00@007oo000000=oo`<0009oo`03001oogoo01Qoo`03001oogoo01Uoo`05001oogooOol0000Q
Ool20002Ool00`00Oomoo`12Ool00`00Oomoo`13Ool00`00Oomoo`12Ool007Ioo`8000=oo`8000io
o`<0009oo`<00004Ool000000002Ool30009Ool200000goo0000000FOol00`00Oomoo`0IOol01@00
Oomoogoo00007Woo0`00e7oo002@Ool20003Ool2000?Ool20002Ool00`00Oomoo`0COol00`00Oomo
o`0IOol01@00Oomoogoo00006Woo1000egoo002ZOol00`00Oomoo`0COol00`00Oomoo`0IOol01@00
Oomoogoo000067oo0P00fgoo002ZOol01000Ool000004Woo00<007ooOol06Goo00D007ooOomoo`00
01Ioo`800=eoo`00Zgoo0`004Woo00<007ooOol06Goo00D007ooOomoo`0001Aoo`800=moo`00[Goo
00<007ooOol047oo00<007ooOol06Goo00D007ooOomoo`00019oo`800>5oo`00[Woo00@007ooOol0
00ioo`03001oogoo01Uoo`05001oogooOol0000@Ool2003SOol00:ioo`04001oo`00000>Ool00`00
Oomoo`0FOol01000Oomoo`000goo00<007ooOol037oo0P00iGoo002^Ool01000Ool000003Woo00<0
07ooOol05Woo00@007ooOol000=oo`03001oogoo00Yoo`800>Moo`00[Woo0`0000=oo`00Ool037oo
00<007ooOol05Woo00@007ooOol000=oo`03001oogoo00Qoo`800>Uoo`00[goo00@007ooOol0009o
o`03001oogoo00Qoo`<0015oo`03001oogoo009oo`04001oogoo0003Ool00`00Oomoo`05Ool3003[
Ool00;9oo`03001oogoo008000Uoo`03001oogoo015oo`03001oogoo009oo`04001oogoo0003Ool0
1000Oomoogoo1000kWoo002bOol00`00Oomoo`020009Ool00`00Oomoo`0AOol00`00Oomoo`02Ool0
1000Oomoo`000goo1000lWoo002bOol00`00Oomoo`020003Ool00`00Oomoo`03Ool00`00Oomoo`0A
Ool00`00Oomoo`02Ool01000Oomoo`000goo00<007ooOol0lgoo002bOol00`00Oomoo`020003Ool0
0`00Oomoo`03Ool00`00Oomoo`0AOol00`00Oomoo`02Ool01000Oomoo`000goo00<007ooOol0lgoo
002bOol01@00Ool007oo00000goo00<007ooOol00goo00<007ooOol04Goo00<007ooOol00Woo00@0
07ooOol000=oo`03001oogoo0?=oo`00/Woo00D007oo001oo`00009oo`8000=oo`03001oo`0000mo
o`05001oogooOol00004Ool01000Oomoo`000Woo0P00mGoo002cOol2000017oo001oogoo0P000goo
00<007oo00003goo00D007ooOomoo`0000Aoo`04001oogoo0002Ool2003eOol00;=oo`800004Ool0
07ooOol20003Ool00`00Ool00002Ool00`00Oomoo`06Ool01@00Oomoogoo00000goo00<007ooOol0
0Woo00@007ooOol0009oo`800?Eoo`00/goo0P0000Aoo`00Oomoo`8000=oo`03001oo`00009oo`05
001oogooOol00004Ool01@00Oomoogoo00000goo00<007ooOol00Woo00@007ooOol0009oo`800?Eo
o`00/goo0P0000Aoo`00Oomoo`8000=oo`03001oo`00009oo`05001oogooOol00004Ool01@00Oomo
ogoo00000goo00<007ooOol00Woo00@007ooOol0009oo`800?Eoo`00]Woo00<007ooOol00P000goo
00<007oo00000Woo00D007ooOomoo`0000Aoo`05001oogooOol00003Ool00`00Oomoo`02Ool01000
Oomoo`000Woo0P00mGoo002fOol00`00Oomoo`020003Ool01000Ool007oo0P000goo00<007ooOol0
0Woo00D007ooOomoo`0000=oo`03001oogoo009oo`04001oogoo0002Ool2003eOol00;Ioo`03001o
ogoo008000=oo`<00003Ool0000000=oo`03001oogoo009oo`05001oogooOol00003Ool00`00Oomo
o`02Ool01000Oomoo`000Woo0P00mGoo002fOol00`00Oomoo`020003Ool60003Ool00`00Oomoo`02
Ool01@00Oomoogoo00000goo0P000goo00@007ooOol0009oo`800?Eoo`00]goo00@007oo000000=o
o`<00003Ool0000000=oo`03001oogoo009oo`05001oogooOol00003Ool20003Ool01000Oomoo`00
0Woo0P00mGoo002gOol01000Ool000000goo0`0000=oo`0000000goo00<007ooOol00Woo00D007oo
Oomoo`0000=oo`8000=oo`04001oogoo0002Ool2003eOol00;Moo`04001oo`000003Ool300000goo
00000003Ool20002Ool20003Ool01000Oomoogoo0P000goo00@007ooOol0009oo`800?Eoo`00]goo
00@007oo000000=oo`<00003Ool0000000=oo`80009oo`8000=oo`04001oogooOol20003Ool01000
Oomoo`000Woo0P00mGoo002gOol01000Ool000000goo0`0000=oo`0000000goo0P000Woo0P000goo
00@007ooOomoo`8000=oo`04001oogoo0002Ool2003eOol00;Moo`05001oo`00Ool00002Ool30000
0goo00000003Ool20002Ool20003Ool01000Oomoogoo0P000goo00@007ooOol0009oo`800?Eoo`00
]goo00D007oo001oo`00009oo`<00003Ool0000000=oo`80009oo`8000=oo`04001oogooOol20003
Ool01000Oomoo`000Woo0P00mGoo002gOol02000Ool007oo001oo`00Ool200000goo00000003Ool2
0002Ool20003Ool01000Oomoogoo0P000goo00@007ooOol0009oo`800?Eoo`00]goo00P007oo001o
o`00Ool007oo0P0000=oo`0000000goo0P000Woo0P000goo00@007ooOomoo`8000=oo`04001oogoo
0002Ool2003eOol00;Moo`80009oo`04001oo`00Ool200000goo00000003Ool20002Ool20003Ool0
1000Oomoogoo0P000goo00P007ooOol007oo001oo`00mGoo002gOol20002Ool01000Ool007oo0P00
00=oo`0000000goo0P000Woo0P000goo00@007ooOomoo`8000=oo`08001oogoo001oo`00Ool00?Eo
o`00^7oo00L007ooOol007oo001oo`0200000goo00000003Ool20002Ool20003Ool01000Oomoogoo
0P000goo00P007ooOol007oo001oo`00mGoo002hOol01`00Oomoo`00Ool007oo00D000=oo`80009o
o`8000=oo`04001oogooOol20003Ool02000Oomoo`00Ool007oo003eOol00;]oo`04001oo`00Ool2
00000goo00000003Ool20002Ool20003Ool01000Oomoogoo0P000goo00P007ooOol007oo001oo`00
mGoo002kOol01000Ool007oo0P0000=oo`0000000goo0P000Woo0P000goo00@007ooOomoo`8000=o
o`08001oogoo001oo`00Ool00?Eoo`00^goo00@007oo001oo`800003Ool0000000=oo`80009oo`80
00=oo`04001oogooOol20003Ool02000Oomoo`00Ool007oo003eOol00;]oo`04001oo`00Ool20000
0goo00000003Ool20002Ool20003Ool01000Oomoogoo0P000goo00P007ooOol007oo001oo`00mGoo
002kOol01000Ool007oo0P0000=oo`0000000goo0P000Woo0P000goo00@007ooOomoo`8000=oo`08
001oogoo001oo`00Ool00?Eoo`00^goo00@007oo001oo`800003Ool0000000=oo`80009oo`8000=o
o`04001oogooOol20003Ool02000Oomoo`00Ool007oo003eOol00;]oo`04001oo`00Ool200000goo
00000003Ool20002Ool20003Ool01000Oomoogoo0P000goo00P007ooOol007oo001oo`00mGoo002k
Ool01000Ool007oo0P0000=oo`0000000goo0P000Woo0P000goo00@007ooOomoo`8000=oo`08001o
ogoo001oo`00Ool00?Eoo`00^goo00@007oo001oo`800003Ool0000000=oo`80009oo`8000=oo`04
001oogooOol20002Ool20002Ool01@00Ool007oo0000mGoo002dOol600001Goo001oo`00Ool00P00
00=oo`0000000goo0P000Woo0P000goo00@007ooOomoo`80009oo`80009oo`05001oo`00Ool0003e
Ool00;Aoo`03001oogoo00Aoo`04001oo`00Ool200000goo00000003Ool20002Ool20003Ool01000
Oomoogoo0P000Woo0P000Woo00D007oo001oo`000?Eoo`00]Goo00<007ooOol00goo00@007oo001o
o`800003Ool0000000=oo`80009oo`8000=oo`04001oogooOol20002Ool20002Ool01@00Ool007oo
0000mGoo002fOol00`00Oomoo`02Ool01000Ool007oo0P0000=oo`0000000goo0P000Woo0P000goo
00@007ooOomoo`80009oo`80009oo`05001oo`00Ool0003eOol00;Moo`08001oogooOol007oo001o
o`D0009oo`03001oo`00009oo`8000=oo`04001oogooOol20002Ool20002Ool01@00Ool007oo0000
mGoo002hOol01`00Oomoo`00Ool007oo00800003Ool00000009oo`03001oo`00009oo`8000=oo`04
001oogooOol20002Ool20002Ool01@00Ool007oo0000mGoo002iOol00`00Oomoo`02000017oo0000
07oo0P000Woo00<007oo00000Woo0P000goo00@007ooOomoo`80009oo`80009oo`05001oo`00Ool0
003eOol00;Uoo`03001oogoo00800004Ool00000Ool20002Ool00`00Ool00002Ool20003Ool01000
Oomoogoo0P000Woo0P000Woo00D007oo001oo`000?Eoo`00]7oo00<007ooOol00Woo00<007ooOol0
0P0000Aoo`00001oo`80009oo`03001oo`00009oo`8000=oo`04001oogooOol20002Ool20002Ool0
1@00Ool007oo0000mGoo002eOol40003Ool2000017oo000007oo0P000Woo00<007oo00000Woo0P00
0goo00@007ooOomoo`80009oo`80009oo`05001oo`00Ool0003eOol00;aoo`80000;Ool00000Ool0
07oo001oo`00Ool00002Ool20003Ool01000Oomoogoo0P000Woo0P000Woo00D007oo001oo`000?Eo
o`00_7oo00<007ooOol00P0000Qoo`00Ool007oo001oo`000Woo0P000goo00@007ooOomoo`80009o
o`80009oo`05001oo`00Ool0003eOol00;moo`800008Ool007oo001oo`00Ool0009oo`8000=oo`04
001oogooOol20002Ool20002Ool01@00Ool007oo0000mGoo002oOol30002Ool01@00Ool007oo0000
0Woo0P000goo00@007ooOomoo`80009oo`80009oo`05001oo`00Ool0003eOol00;moo`<0009oo`05
001oo`00Ool00002Ool20003Ool01000Oomoogoo0P000Woo0P000Woo00D007oo001oo`000?Eoo`00
`7oo0P000Woo00D007oo001oo`00009oo`8000=oo`04001oogooOol20002Ool20002Ool01@00Ool0
07oo0000mGoo0030Ool20002Ool01@00Ool007oo00000Woo0P000goo0P000Woo0P000Woo0P000Woo
00D007oo001oo`000?Eoo`00`7oo0`0000Ioo`00Ool007oo0002Ool20003Ool20002Ool20002Ool2
0002Ool01@00Ool007oo0000mGoo0030Ool20002Ool01@00Ool007oo00000Woo0P000goo0P000Woo
0P000Woo0P000Woo00D007oo001oo`000?Eoo`00`7oo0P000Woo00D007oo001oo`00009oo`8000=o
o`80009oo`80009oo`80009oo`05001oo`00Ool0003eOol00<1oo`80009oo`05001oo`00Ool00002
Ool20003Ool20002Ool20002Ool20002Ool01@00Ool007oo0000mGoo0030Ool20002Ool01@00Ool0
07oo00000Woo0P000goo0P000Woo0P000Woo0P000Woo00D007oo001oo`000?Eoo`00`7oo0P000Woo
00D007oo001oo`00009oo`8000=oo`80009oo`80009oo`80009oo`80009oo`03001oogoo0?=oo`00
`7oo0P000Woo00D007oo001oo`00009oo`8000=oo`80009oo`80009oo`80009oo`80009oo`03001o
ogoo0?=oo`00`7oo0P000Woo00D007oo001oo`00009oo`8000=oo`80009oo`80009oo`04001oo`00
Ool20002Ool00`00Oomoo`3cOol00<1oo`80009oo`05001oo`00Ool00002Ool20003Ool20002Ool2
0002Ool01000Ool007oo0P000Woo00<007ooOol0lgoo0030Ool20002Ool01@00Ool007oo00000Woo
0P000goo0P000Woo0P000Woo00@007oo001oo`80009oo`03001oogoo0?=oo`00`7oo0P000Woo00D0
07oo001oo`00009oo`8000=oo`80009oo`80009oo`04001oo`00Ool20002Ool00`00Oomoo`3cOol0
0<1oo`80009oo`05001oo`00Ool00002Ool20003Ool20002Ool20002Ool01000Ool007oo0P000Woo
00<007ooOol0lgoo0030Ool20002Ool01@00Ool007oo00000Woo0P000goo0P000Woo0P000Woo00@0
07oo001oo`80009oo`03001oogoo0?=oo`00`7oo0P000Woo00D007oo001oo`00009oo`8000=oo`80
009oo`80009oo`04001oo`00Ool20002Ool00`00Oomoo`3cOol00<1oo`<00006Ool007oo001oo`00
0Woo0P000goo0P000Woo0P000Woo00@007oo001oo`80009oo`03001oogoo0?=oo`00`7oo0P000Woo
00D007oo001oo`00009oo`8000=oo`80009oo`80009oo`04001oo`00Ool20002Ool00`00Oomoo`3c
Ool00<1oo`80009oo`05001oo`00Ool00002Ool20003Ool20002Ool20002Ool01000Ool007oo0P00
0Woo00<007ooOol0lgoo0030Ool20002Ool01@00Ool007oo00000Woo0P000goo0P000Woo0P000Woo
00@007oo001oo`80009oo`03001oogoo0?=oo`00`7oo0P000Woo00D007oo001oo`00009oo`8000=o
o`80009oo`80009oo`04001oo`00Ool20002Ool00`00Oomoo`3cOol00<1oo`80009oo`05001oo`00
Ool00002Ool20003Ool20002Ool20002Ool01000Ool007oo0P000Woo00<007ooOol0lgoo0030Ool2
0002Ool01@00Ool007oo00000Woo0P000Woo00<007oo00000Woo0P000Woo00@007oo001oo`80009o
o`03001oogoo0?=oo`00`7oo00T007ooOomoo`00Ool007oo00000Woo0P000Woo00<007oo00000Woo
0P000Woo00@007oo001oo`80009oo`03001oogoo0?=oo`00`7oo00T007ooOomoo`00Ool007oo0000
0Woo0P000Woo00<007oo00000Woo0P000Woo00@007oo001oo`80009oo`03001oogoo0?=oo`00`7oo
00T007ooOomoo`00Ool007oo00000Woo0P000Woo00<007oo00000Woo0P000Woo00@007oo001oo`80
009oo`03001oogoo0?=oo`00`7oo00T007ooOomoo`00Ool007oo00000Woo0P000Woo00<007oo0000
0Woo0P000Woo00@007oo001oo`80009oo`03001oogoo0?=oo`00`7oo00T007ooOomoo`00Ool007oo
00000Woo00L007oo001oo`00Ool00002Ool20002Ool01000Ool007oo0P000Woo00<007ooOol0lgoo
0030Ool02@00Oomoogoo001oo`00Ool00002Ool01`00Ool007oo001oo`00009oo`80009oo`04001o
o`00Ool20002Ool00`00Oomoo`3cOol00<1oo`<00006Ool007oo001oo`000Woo00L007oo001oo`00
Ool00002Ool20002Ool01000Ool007oo0P000Woo00<007ooOol0lgoo0030Ool02@00Oomoogoo001o
o`00Ool00002Ool01`00Ool007oo001oo`00009oo`80009oo`04001oo`00Ool20002Ool00`00Oomo
o`3cOol00<1oo`09001oogooOol007oo001oo`00009oo`07001oo`00Ool007oo00000Woo0P000Woo
00@007oo001oo`80009oo`03001oogoo0?=oo`00`7oo00T007ooOomoo`00Ool007oo00000Woo00L0
07oo001oo`00Ool00002Ool20002Ool01000Ool007oo0P000Woo00<007ooOol0lgoo0030Ool02@00
Oomoogoo001oo`00Ool00002Ool01`00Ool007oo001oo`00009oo`80009oo`04001oo`00Ool20002
Ool00`00Oomoo`3cOol00<1oo`09001oogooOol007oo001oo`00009oo`07001oo`00Ool007oo0000
0Woo0P000Woo00@007oo001oo`80009oo`03001oogoo0?=oo`00`7oo00T007ooOomoo`00Ool007oo
00000Woo00L007oo001oo`00Ool00002Ool20002Ool01000Ool007oo0P000Woo00<007ooOol0lgoo
0030Ool02@00Oomoogoo001oo`00Ool00002Ool01`00Ool007oo001oo`00009oo`80009oo`04001o
o`00Ool20002Ool00`00Oomoo`3cOol00<1oo`09001oogooOol007oo001oo`00009oo`07001oo`00
Ool007oo00000Woo0P000Woo00@007oo001oo`80009oo`03001oogoo0?=oo`00`7oo00T007ooOomo
o`00Ool007oo00000Woo00L007oo001oo`00Ool00002Ool20002Ool01000Ool007oo0P000Woo00<0
07ooOol0lgoo002gOol30006Ool02@00Oomoogoo001oo`00Ool00002Ool01`00Ool007oo001oo`00
009oo`80009oo`04001oo`00Ool20002Ool00`00Oomoo`3cOol00;Qoo`03001oogoo00Eoo`03001o
ogoo009oo`80000;Ool007ooOol007oo001oo`00Ool00002Ool20002Ool01000Ool007oo0P000Woo
00<007ooOol0lgoo002hOol00`00Oomoo`05Ool00`00Oomoo`02Ool200002goo001oogoo001oo`00
Ool007oo00000Woo0P000Woo00@007oo001oo`80009oo`03001oogoo0?=oo`00]7oo1P001Woo00<0
07ooOol00Woo0P0000]oo`00Oomoo`00Ool007oo001oo`00009oo`80009oo`04001oo`00Ool20002
Ool00`00Oomoo`3cOol00;Aoo`05001oogooOol00007Ool400001Goo001oogoo00000Woo00L007oo
001oo`00Ool00002Ool20002Ool01000Ool007oo0P000Woo00<007ooOol0lgoo002eOol01000Oomo
o`001goo00<007ooOol00Woo00@007ooOol0009oo`07001oo`00Ool007oo00000Woo0P000Woo00@0
07oo001oo`80009oo`03001oogoo0?=oo`00]Woo00<007oo00001goo00<007ooOol00Woo00@007oo
Ool0009oo`07001oo`00Ool007oo00000Woo0P000Woo00@007oo001oo`80009oo`03001oogoo0?=o
o`00]Woo00<007oo00001goo00<007ooOol00Woo00d007ooOomoo`00Ool007oo001oo`00Ool00002
Ool20002Ool01000Ool007oo0P000Woo00<007ooOol0lgoo002gOol20007Ool00`00Oomoo`02Ool0
3@00Oomoogoo001oo`00Ool007oo001oo`00009oo`80009oo`04001oo`00Ool20002Ool00`00Oomo
o`3cOol00;Qoo`03001oogoo00Eoo`03001oogoo009oo`0=001oogooOol007oo001oo`00Ool007oo
00000Woo0P000Woo00@007oo001oo`80009oo`03001oogoo0?=oo`00`7oo00<007ooOol00Woo00@0
07ooOomoo`80009oo`05001oo`00Ool00002Ool20002Ool01000Ool007oo0P000Woo00<007ooOol0
lgoo0030Ool00`00Oomoo`02Ool01000Oomoogoo0P000Woo00D007oo001oo`00009oo`80009oo`04
001oo`00Ool20002Ool00`00Oomoo`3cOol00<1oo`03001oogoo009oo`04001oogooOol20002Ool0
1@00Ool007oo00000Woo0P000Woo00@007oo001oo`80009oo`03001oogoo0?=oo`00`7oo00<007oo
Ool00Woo00@007ooOomoo`80009oo`05001oo`00Ool00002Ool20002Ool01000Ool007oo0P000Woo
00<007ooOol0lgoo0030Ool00`00Oomoo`06Ool20002Ool01@00Ool007oo00000Woo0P000Woo00@0
07oo001oo`80009oo`03001oogoo0?=oo`00`7oo00<007ooOol01Woo0P000Woo00D007oo001oo`00
009oo`80009oo`04001oo`00Ool20002Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Ioo`80009o
o`05001oo`00Ool00002Ool20002Ool01000Ool007oo0P000Woo00<007ooOol0lgoo0030Ool30006
Ool20002Ool01@00Ool007oo00000Woo0P000Woo00@007oo001oo`80009oo`03001oogoo0?=oo`00
`7oo00<007ooOol01Woo0P000Woo00D007oo001oo`00009oo`80009oo`04001oo`00Ool20002Ool0
0`00Oomoo`3cOol00<1oo`03001oogoo00Ioo`80009oo`05001oo`00Ool00002Ool20002Ool01000
Ool007oo0P000Woo00<007ooOol0lgoo0030Ool00`00Oomoo`06Ool20002Ool01@00Ool007oo0000
0Woo0P000Woo00@007oo001oo`80009oo`03001oogoo0?=oo`00`7oo00<007ooOol01Woo0P000Woo
00D007oo001oo`00009oo`80009oo`04001oo`00Ool20002Ool00`00Oomoo`3cOol00<1oo`03001o
ogoo00Ioo`80009oo`09001oo`00Ool007oo001oo`00009oo`04001oo`00Ool20002Ool00`00Oomo
o`3cOol00<1oo`03001oogoo00Ioo`80009oo`09001oo`00Ool007oo001oo`00009oo`05001oo`00
Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Ioo`80009oo`09001oo`00Ool007oo001o
o`00009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Ioo`80009oo`09
001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001o
ogoo00Ioo`80009oo`09001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003Ool00`00Oomo
o`3cOol00<1oo`03001oogoo00Ioo`80009oo`09001oo`00Ool007oo001oo`00009oo`05001oo`00
Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Ioo`80009oo`09001oo`00Ool007oo001o
o`00009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Ioo`80009oo`09
001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001o
ogoo00Ioo`80009oo`09001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003Ool00`00Oomo
o`3cOol00<1oo`<000Ioo`80009oo`09001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003
Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Ioo`80009oo`09001oo`00Ool007oo001oo`00009o
o`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Ioo`80009oo`09001oo`00
Ool007oo001oo`00009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Io
o`80009oo`09001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol0
0<1oo`03001oogoo00Ioo`80009oo`09001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003
Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Ioo`80009oo`09001oo`00Ool007oo001oo`00009o
o`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Ioo`80009oo`09001oo`00
Ool007oo001oo`00009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Io
o`80009oo`09001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol0
0<1oo`03001oogoo00Ioo`80009oo`09001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003
Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Ioo`80009oo`09001oo`00Ool007oo001oo`00009o
o`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Ioo`80009oo`09001oo`00
Ool007oo001oo`00009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Io
o`80009oo`09001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol0
0<1oo`03001oogoo00Yoo`09001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003Ool00`00
Oomoo`3cOol00<1oo`<000Yoo`09001oo`00Ool007oo001oo`00009oo`05001oo`00Ool00003Ool0
0`00Oomoo`3cOol00<1oo`03001oogoo00Yoo`09001oo`00Ool007oo001oo`00009oo`05001oo`00
Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Yoo`09001oo`00Ool007oo001oo`00009o
o`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Yoo`09001oo`00Ool007oo
001oo`00009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Yoo`09001o
o`00Ool007oo001oo`00009oo`05001oo`00Ool00003Ool00`00Oomoo`3cOol00<1oo`03001oogoo
00Yoo`07001oo`00Ool007oo00000Woo00L007oo001oo`00Ool00003Ool00`00Oomoo`3cOol00<1o
o`03001oogoo00Yoo`07001oo`00Ool007oo00000Woo00L007oo001oo`00Ool00003Ool00`00Oomo
o`3cOol00<1oo`03001oogoo00Yoo`07001oo`00Ool007oo00000Woo00L007oo001oo`00Ool00003
Ool00`00Oomoo`3cOol00<1oo`03001oogoo00Yoo`07001oo`00Ool007oo00000Woo00L007oo001o
o`00Ool00003Ool00`00Oomoo`3cOol00