% Sonnenflecken

echo off

% Variablen freigeben


clear all

clc

% Dateien laden (Sonnenflecken, Kalziumdaten)


%load ca_index.dat

%load sunspot.dat



% Transformation des Datums (Jahr-Monat-Tag) in Tage 

% ab Beginn der Messung der Sonnenflecken

% Falls neue Berechnung notwengid :

%LoadValues;

% sonst Dateien laden

load ca_indexlindat; %        <ca_indexlindat>

load sunlindate;%          <sunlindate>

%Laden der geglaetteten Daten Sonnenflecken zur Beschleunigung des Programmes

% Falls neue Berechnung notwendig :

%GlaettValues;

% sonst Dateien laden

load sunGlaett;%       <sunGlaett>

load calciumGlaett;%  <calciumGlaett>



%Berechnung des Korreltionskoeffizienten der gegltteten Werte

%nach der ersten Periode (erste CA-Periode ist atypisch)

Korrel = corrcoef(sunGlaett(4000:8000,2),calciumGlaett(4000:8000,2));








% -------Plot--------


% erster plot: Sonnenflecken


figure(1)


subplot(2,2,1);


% R-Werte ber LinearZeit


sp=plot(sunlindate(:,1),sunlindate(:,2),'.');





% Achsen


axis([min(sunlindate(:,1))-1000 max(sunlindate(:,1))*1.05 0 400]);





set (sp,'markersize',1)


title(' Sonnenflecken von 1932 bis 1995')


xlabel(' Linearzeit ')


ylabel(' Sonnenfleckenrelativzahl R')


legend(sp,'SRZ')




% zweiter Plot: Calciumindex


subplot(2,2,2);


cap=plot(ca_indexlindat(:,1),ca_indexlindat(:,2),'.');


axis([min(sunlindate(:,1))-1000 max(sunlindate(:,1))*1.05 0 600]);


set (cap,'markersize',1)


title(' calciumindex von 1942 bis 1987')


xlabel(' Linearzeit ')


ylabel(' Intensitt')


legend(cap,'Aktivitt')


subplot(2,2,3);


plot(sunGlaett(:,1),sunGlaett(:,2),'g')


axis([min(sunlindate(:,1))-1000 max(sunlindate(:,1))*1.05 0 220]);





set (cap,'markersize',1)


title(' gleitendes Mittel von 365 Messwerten')


xlabel(' Linearzeit ')


ylabel(' Anzahl')


legend(cap,'Aktivitt')





subplot(2,2,4);


plot(calciumGlaett(:,1),calciumGlaett(:,2),'r')


axis([min(sunlindate(:,1))-1000 max(sunlindate(:,1))*1.05 0 220]);








set (cap,'markersize',1)


title(' gleitendes Mittel von 365 Messwerten')


xlabel(' Linearzeit ')


ylabel(' Intensitt')


legend(cap,'Aktivitt')





%--------------------Auswertung in einem Diagramm--------


figure(2)





subplot(2,1,1);


% R-Werte ber LinearZeit


sp=plot(sunlindate(:,1),sunlindate(:,2),'.');


% Achsen


% axis manual;


axis([min(sunlindate(:,1))-1000 max(sunlindate(:,1))*1.05 0 400]);


%axis 'auto y';


set (sp,'markersize',1)


title(' Sonnenflecken von 1932 bis 1995')


xlabel(' Linearzeit ')


ylabel(' Sonnenfleckenrelativzahl R')


legend(sp,'SRZ')


hold on


cap=plot(sunGlaett(:,1),sunGlaett(:,2),'g');


set(cap,'markersize',20)





% zweiter Plot: Calciumindex


subplot(2,1,2);


cap=plot(ca_indexlindat(:,1),ca_indexlindat(:,2),'.');


axis([min(sunlindate(:,1))-1000 max(sunlindate(:,1))*1.05 0 600]);


set (cap,'markersize',1)


title(' calciumindex von 1942 bis 1987')


xlabel(' Linearzeit ')


ylabel(' Intensitt')


legend(cap,'Aktivitt')


hold on


cap=plot(calciumGlaett(:,1),calciumGlaett(:,2),'r');


set(cap,'markersize',20)




%--------------------------------------------------------


nfft=2^14;




%FFT von Sunspots

figure(3)

FFT_sun = fft(sunGlaett(:,2),16384);



powersun=FFT_sun.*conj(FFT_sun)/16384;

t=(1:16384);

subplot(2,2,1)

plot(t,log(powersun(1:16384)))

title(' FFT von Sunspots (powerspektrum]')

xlabel('Linearzeit')

ylabel('Dichte')





%Finden der Dominanten Frequenz von Sunspots

fyf_sun=FFT_sun;

dom_swi = 1;

lowlim = 0.9;

power_sun = abs(FFT_sun).^2 / length(FFT_sun);

power_sun(1) = 0;

maxtest_sun = max(power_sun);

maxind_sun = find( power_sun>maxtest_sun*lowlim );

freq_sun = maxind_sun;

lfreq_sun = length(freq_sun);

ny_sun = (freq_sun(1:lfreq_sun)-1) / length(FFT_sun);



if dom_swi

   fyf_sun = zeros(size(FFT_sun)); 

   fyf_sun(maxind_sun) = FFT_sun(maxind_sun);

end

perioden_sun=1./ny_sun

%Darstellung der Inversen FFT



IFFT_sun=ifft(fyf_sun,length(FFT_sun));

subplot(2,2,2)

plot(t,real(IFFT_sun(1:nfft)),'g')

title('Inverse FFT')

xlabel(' Linearzeit ')

ylabel('Anzahl')

%-------------------------------------------------------------

%FFT von Calciumlinie



FFT_ca= fft(ca_indexlindat(:,2),16384);

powerca=FFT_ca.*conj(FFT_ca)/16384;

t=(1:16384);

subplot(2,2,3)

plot(t,log(powerca(1:16384)))

title('FFT von Calcium')

xlabel(' Linearzeit ')

ylabel(' Intensitt')



%Finden der Dominanten Frequenz von Calciumlinien

fyf_ca=FFT_ca;

dom_swi = 1;

lowlim = 0.9;

power_ca = abs(FFT_ca).^2 / length(FFT_ca);

power_ca(1) = 0;

maxtest_ca = max(power_ca);

maxind_ca = find( power_ca>maxtest_ca*lowlim );

freq_ca = maxind_ca;

lfreq_ca = length(freq_ca);

ny_ca = (freq_ca(1:lfreq_ca)-1) / length(FFT_ca);



if dom_swi

   fyf_ca = zeros(size(FFT_ca)); 

   fyf_ca(maxind_ca) = FFT_ca(maxind_ca);

end

perioden_ca=1./ny_ca

%Darstellung der Inversen FFT



IFFT_ca= real(ifft(fyf_ca,length(FFT_ca)));

subplot(2,2,4)

plot(t,IFFT_ca(1:nfft),'g')

%Vergleich zwischen IFFT Sun-CA

figure(4)

plot(t(1:nfft-299),real(IFFT_ca(300:nfft)),'g')

hold

plot(t,real(IFFT_sun(1:nfft)),'r')

hold

Korrel