% Subroutine fr Fractal 2.22
% written by Klaus Lichtenegger and Martin Maurer
%
% Zeichnen des gewnschten Fraktals

function fracdraw()

  global fr1 txtR tpar txtI tsch txtS rsch
  global FracMode ZoomMode Skala1 Funkt Param 
  global AXSkala AYSkala Movie OldSchritte
  global Z3  % for imwrite
  
  button(0);
  [X, Y] = meshgrid(AXSkala, AYSkala);
  Z = X + i*Y; Z3 = zeros(length(AXSkala), length(AYSkala));

  if sum(FracMode == [1 2 3 4])
    c = str2num(get(txtR,'String')) + i*str2num(get(txtI,'String'));
  else
    c = Z;
  end
  if ZoomMode == 0;
    OldSchritte = str2num(get(txtS,'String'));
  end
  Schritte=OldSchritte*(ZoomMode+1);
  set(rsch, 'String', Schritte);

  switch FracMode
  case 1
    for I=1:Schritte
      Z2 = Z; Z = fracfun(Z, c);
      set(txtS, 'String', I);
      Z3 = Z3 + ((abs(Z2) >= 10) & (Z3 == 0))*I;pause(0.001);
      if Movie
        pcolor(AXSkala, AYSkala, Z3); shading interp;
        axis off; drawnow;               
      end
    end
    pcolor(AXSkala, AYSkala, Z3); shading interp;
    axis off; drawnow;               

  case 2
    for I=1:Schritte
      Z = fracfun(Z, c);
      set(txtS, 'String', I);pause(0.001);
      if Movie
        Z2=(abs(Z)<1).*abs(Z);
        pcolor(AXSkala, AYSkala, Z2); shading interp;
        axis off; drawnow;               
      end
    end
    Z2=(abs(Z)<1).*abs(Z);
    pcolor(AXSkala, AYSkala, Z2); shading interp;
    axis off; drawnow;               

  case 3
    for I=1:Schritte
      Z2 = Z; Z = fracfun(Z, c);
      set(txtS, 'String', I);
      Z3 = Z3 + ((abs(Z2) >= 10) & (Z3 == 0))*I;
      Z2=Z3+(Z3==0)*max(max(Z3));pause(0.001);
      if Movie
        if max(max(Z2))~=0
          surf(AXSkala, AYSkala, Z2); shading interp;
          axis([min(AXSkala) max(AXSkala) min(AYSkala) max(AYSkala) 0 Schritte]);
          axis off; drawnow;
        end
      end
    end
    if ~Movie
      surf(AXSkala, AYSkala, Z2); shading interp;
      axis off; drawnow;
    end

  case 4
    for I=1:Schritte
      Z = fracfun(Z, c); Z2=(abs(Z)<1).*abs(Z);
      set(txtS, 'String', I);pause(0.001);
      if Movie
        if max(max(Z2))~=0
          surf(AXSkala, AYSkala, Z2); shading interp;
          axis([min(AXSkala) max(AXSkala) min(AYSkala) max(AYSkala) 0 2]);
          axis off; drawnow;
        end
      end
    end
    if ~Movie
      surf(AXSkala, AYSkala, Z2); shading interp;
      axis([min(AXSkala) max(AXSkala) min(AYSkala) max(AYSkala) 0 2]);
      axis off; drawnow;
    end

  case 5
    for I=1:Schritte
      Z2 = Z; Z = fracfun(Z, c);
      set(txtS, 'String', I);pause(0.001);
      Z3 = Z3 + ((abs(Z2) >= 10) & (Z3 == 0))*I;
      if Movie
        pcolor(AXSkala, AYSkala, Z3); shading interp;
        axis off; drawnow;               
      end
    end
    pcolor(AXSkala, AYSkala, Z3); shading interp;
    axis off; drawnow;
   
  case 6
    for I=1:Schritte
      Z = fracfun(Z, c);
      set(txtS, 'String', I);pause(0.001);
      if Movie
        Z2=(abs(Z)<1).*abs(Z);
        pcolor(AXSkala, AYSkala, Z2); shading interp;
        axis off; drawnow;               
      end
    end
    Z2=(abs(Z)<1).*abs(Z);
    pcolor(AXSkala, AYSkala, Z2); shading interp;
    axis off; drawnow;               

  case 7
    for I=1:Schritte
      Z2 = Z; Z = fracfun(Z, c);
      set(txtS, 'String', I);pause(0.001);
      Z3 = Z3 + ((abs(Z2) >= 10) & (Z3 == 0))*I;
      Z2=Z3+(Z3==0)*max(max(Z3));
      if Movie
        if max(max(Z2))~=0
          surf(AXSkala, AYSkala, Z2); shading interp;
          axis([min(AXSkala) max(AXSkala) min(AYSkala) max(AYSkala) 0 Schritte]);
          axis off; drawnow;
        end
      end
    end
    if ~Movie
      surf(AXSkala, AYSkala, Z2); shading interp;
      axis off; drawnow;
    end

  case 8
    for I=1:Schritte
      Z = fracfun(Z, c); Z2=(abs(Z)<1).*abs(Z);
      set(txtS, 'String', I);pause(0.001);
      if Movie
        if max(max(Z2))~=0
          surf(AXSkala, AYSkala, Z2); shading interp;
          axis([min(AXSkala) max(AXSkala) min(AYSkala) max(AYSkala) 0 2]);
          axis off; drawnow;
        end
      end
    end
    if ~Movie
      surf(AXSkala, AYSkala, Z2); shading interp;
      axis([min(AXSkala) max(AXSkala) min(AYSkala) max(AYSkala) 0 2]);
      axis off; drawnow;
    end

  end

  if ~ZoomMode
    button(1);
  else
    button(3);
  end
  set(txtS, 'String', Schritte); set(rsch, 'String', '');

  



