% Fractal 2.22
% written by Klaus Lichtenegger and Martin Maurer
%
% Interaktive Darstellung von Mandelbrot- und Juliamengen in 2D und 3D
% mit Zoom- bzw. Rotationsmglichkeiten
%
% Ausgelegt auf 800*600 Pixel mit min. 256 Farben
%
% Erfasste Funktionen:
% z:=z+c, z:=z+c, z:=exp(z)+c, z:=sinh(z)+c, z:=cosh(z)+c
% z:=z-c, z:=z-c, z:=exp(z)-c, z:=sinh(z)-c, z:=cosh(z)-c
% z:=z*c, z:=z*c, z:=exp(z)*c, z:=sinh(z)*c, z:=cosh(z)*c

function fractal()

  % Globale Variablen und Handles:

  global fig1 graph 
  global m1 m11 m12 m13 m14 m15
  global m2 m21 m22 m23
  global m3 m31 m32 m33 m34 m35
  global m4 m41 m42 m43
  global m5 m51 m52 m53 m54 m55 m56
  global m6 m61 m62 m63
  global fr1 txtR tpar txtI tsch txtS rsch
  global Bt1 Bt1M Bt2 Bt2M Bt3 Bt3M Bt4 Bt4M
  global Bt5 Bt5M Bt6 Bt6M Bt7 Bt7M Bt8 Bt8M
  global Zoom1 Zoom2 Rotat Coord ReDrw Ende
  global FracMode ZoomMode Skala1 Funkt Param Steps 
  global AXSkala AYSkala Movie OldSchritte R3D

  % Initialisierung:
  
  Steps = 125;
  echo off; colormap(jet);
  FracMode = 0; ZoomMode = 0; Movie=0;
  IStart = -2; IEnde = 2;
  Skala1=[IStart:(IEnde-IStart)/Steps:IEnde];
  AXSkala = Skala1; AYSkala = Skala1;
  Funkt = 1; Param = 1; R3D = 0;
  
  % Figure und Axes-Bereich:

  fig1 = figure(1); set(fig1, 'Name', 'Fraktale');
  set(fig1, 'Resize', 'Off', 'Position', [0 0 1 1]);
  graph = axes('Parent', fig1, 'Position', [0 0 1 1]);
  set(graph, 'Tag', 'graph'); axis off;
  
  % Funktionen-Menu:

  m1 = uimenu('Parent', fig1, 'Tag', 'm1', 'Label', 'Funktionen');
  m11 = uimenu('Parent', m1, 'Tag', 'm11', 'Label', 'Quadratisch: z');
  m12 = uimenu('Parent', m1, 'Tag', 'm12', 'Label', 'Kubisch: z');
  m13 = uimenu('Parent', m1, 'Tag', 'm13', 'Label', 'Exponentiell: exp(z)');
  m14 = uimenu('Parent', m1, 'Tag', 'm14', 'Label', 'hyp. Sinus: sinh(z)');
  m15 = uimenu('Parent', m1, 'Tag', 'm15', 'Label', 'hyp. Cosinus: cosh(z)');
  set(m11, 'Checked', 'on');

  % Parameter-Menu:

  m2 = uimenu('Parent', fig1, 'Tag', 'm2', 'Label', 'Parameter');
  m21 = uimenu('Parent', m2, 'Tag', 'm21', 'Label', 'Addition: +c');
  m22 = uimenu('Parent', m2, 'Tag', 'm22', 'Label', 'Subtraktion: -c');
  m23 = uimenu('Parent', m2, 'Tag', 'm23', 'Label', 'Multiplikation: *c');
  set(m21, 'Checked', 'on');

  % Farb-Menu:

  m3 = uimenu('Parent', fig1, 'Tag', 'm3', 'Label', 'Farbschemata');
  m31 = uimenu('Parent', m3, 'Tag', 'm31', 'Label', 'Jet');
  m32 = uimenu('Parent', m3, 'Tag', 'm32', 'Label', 'Hot');
  m33 = uimenu('Parent', m3, 'Tag', 'm33', 'Label', 'Green');
  m34 = uimenu('Parent', m3, 'Tag', 'm34', 'Label', 'Bone');
  m35 = uimenu('Parent', m3, 'Tag', 'm35', 'Label', 'Copper');
  set(m31, 'Checked', 'on');

  % Aufloesung
  
  m4 = uimenu('Parent',fig1,'Tag','m4','Label','Aufloesung');
  m41= uimenu('Parent',m4,'Tag','m41','Label','Hoch (500x500)');
  m42= uimenu('Parent',m4,'Tag','m42','Label','Mittel (250x250)');
  m43= uimenu('Parent',m4,'Tag','m43','Label','Nieder (125x125)');
  set(m43, 'Checked', 'on');
  
  % Beispiele-Menu:

  m5 = uimenu('Parent', fig1, 'Tag', 'm5', 'Label', 'Beispiele');
  m51 = uimenu('Parent', m5, 'Tag', 'm51', 'Label', 'San Marco');
  m52 = uimenu('Parent', m5, 'Tag', 'm52', 'Label', 'Dendrit');
  m53 = uimenu('Parent', m5, 'Tag', 'm53', 'Label', 'Julia-Drachen');
  m54 = uimenu('Parent', m5, 'Tag', 'm54', 'Label', 'Fatou-Staub');
  m55 = uimenu('Parent', m5, 'Tag', 'm55', 'Label', 'Doudays Kaninchen');
  m56 = uimenu('Parent', m5, 'Tag', 'm56', 'Label', 'Misiurewicz-Punkt');
  
  % Beispiel Movie
  
  
  m6 = uimenu('Parent',fig1,'Tag','m6','Label','Anzeige');
  m61= uimenu('Parent', m6,'Tag','m61','Label','1024*768');
  m62= uimenu('Parent', m6,'Tag','m62','Label','800*600');
  m63= uimenu('Parent', m6,'Tag','m63','Label','640*480');
  set(m63, 'Checked', 'on');
  
    
  % Text- und Editfelder:

  fr1 = uicontrol('Tag', 'fr1', 'Style', 'frame', 'Position', [600 530 200 70]);
  txtR = uicontrol('Tag', 'txtR', 'Style', 'edit', 'String', '0.360284');
    set(txtR, 'Position', [610 570 80 20]);
  tpar = uicontrol('Tag', 'tpar', 'Style', 'text', 'String', '+ i');
    set(tpar, 'Position', [690 570 20 20]);
  txtI = uicontrol('Tag', 'txtI', 'Style', 'edit', 'String', '0.1');
    set(txtI, 'Position', [710 570 80 20]);
  tsch = uicontrol('Tag', 'tsch', 'Style', 'text', 'String', 'Schritte:');
    set(tsch, 'Position', [620 540 50 20]);
  txtS = uicontrol('Tag', 'txtS', 'Style', 'edit', 'String', '20');
    set(txtS, 'Position', [680 540 40 20]);
  rsch = uicontrol('Tag', 'rsch', 'Style', 'text', 'String', '');
    set(rsch, 'Position', [740 540 40 20]);

  % Druckknpfe:

  Bt1 = uicontrol('Tag', 'Bt1', 'Style', 'pushbutton', 'String', 'klass. Juliamenge');
  Bt1M = uicontrol('Tag', 'Bt1M', 'Style', 'pushbutton', 'String', 'Movie');
  Bt2 = uicontrol('Tag', 'Bt2', 'Style', 'pushbutton', 'String', 'inv. Juliamenge');
  Bt2M = uicontrol('Tag', 'Bt2M', 'Style', 'pushbutton', 'String', 'Movie');
  Bt3 = uicontrol('Tag', 'Bt3', 'Style', 'pushbutton', 'String', 'klass. 3D-Julia');
  Bt3M = uicontrol('Tag', 'Bt3M', 'Style', 'pushbutton', 'String', 'Movie');
  Bt4 = uicontrol('Tag', 'Bt4', 'Style', 'pushbutton', 'String', 'inv. 3D-Julia');
  Bt4M = uicontrol('Tag', 'Bt4M', 'Style', 'pushbutton', 'String', 'Movie');
  Bt5 = uicontrol('Tag', 'Bt5', 'Style', 'pushbutton', 'String', 'klass. Mandelbrot');
  Bt5M = uicontrol('Tag', 'Bt5M', 'Style', 'pushbutton', 'String', 'Movie');
  Bt6 = uicontrol('Tag', 'Bt6', 'Style', 'pushbutton', 'String', 'inv. Mandelbrot');
  Bt6M = uicontrol('Tag', 'Bt6M', 'Style', 'pushbutton', 'String', 'Movie');
  Bt7 = uicontrol('Tag', 'Bt7', 'Style', 'pushbutton', 'String', 'klass. 3D-Mandel');
  Bt7M = uicontrol('Tag', 'Bt7M', 'Style', 'pushbutton', 'String', 'Movie');
  Bt8 = uicontrol('Tag', 'Bt8', 'Style', 'pushbutton', 'String', 'inv. 3D-Mandel');
  Bt8M = uicontrol('Tag', 'Bt8M', 'Style', 'pushbutton', 'String', 'Movie');
  Zoom1 = uicontrol('Tag', 'Zoom1', 'Style', 'pushbutton', 'String', 'Zoom');
  Zoom2 = uicontrol('Tag', 'Zoom2', 'Style', 'pushbutton', 'String', 'Unzoom');
  Rotat = uicontrol('Tag', 'Rotat', 'Style', 'pushbutton', 'String', 'Rotate');
  Coord = uicontrol('Tag', 'Coord', 'Style', 'pushbutton', 'String', 'Select Julia');
  ReDrw = uicontrol('Tag', 'ReDrw', 'Style', 'pushbutton', 'String', 'Redraw');   
  Ende = uicontrol('Tag', 'Ende', 'Style', 'pushbutton', 'String', 'Ende');
  set(Zoom1, 'Visible', 'Off'); set(Zoom2, 'Visible', 'Off');
  set(Rotat, 'Visible', 'Off'); set(Coord, 'Visible', 'Off');
  set(ReDrw, 'Visible', 'Off'); 

  setscr(3);
  
  % Callback-Routinen

  set(m11, 'Callback', 'handlesub m11');
  set(m12, 'Callback', 'handlesub m12');
  set(m13, 'Callback', 'handlesub m13');
  set(m14, 'Callback', 'handlesub m14');
  set(m15, 'Callback', 'handlesub m15');

  set(m21, 'Callback', 'handlesub m21');
  set(m22, 'Callback', 'handlesub m22');
  set(m23, 'Callback', 'handlesub m23');

  set(m31, 'Callback', 'handlesub m31');
  set(m32, 'Callback', 'handlesub m32');
  set(m33, 'Callback', 'handlesub m33');
  set(m34, 'Callback', 'handlesub m34');
  set(m35, 'Callback', 'handlesub m35');
  
  set(m41, 'Callback', 'handlesub m41');
  set(m42, 'Callback', 'handlesub m42');
  set(m43, 'Callback', 'handlesub m43');
    
  set(m51, 'Callback', 'handlesub m51');
  set(m52, 'Callback', 'handlesub m52');
  set(m53, 'Callback', 'handlesub m53');
  set(m54, 'Callback', 'handlesub m54');
  set(m55, 'Callback', 'handlesub m55');
  set(m56, 'Callback', 'handlesub m56');
  
  set(m61, 'Callback', 'handlesub m61');
  set(m62, 'Callback', 'handlesub m62');
  set(m63, 'Callback', 'handlesub m63');

  set(Bt1, 'Callback', 'handlesub Bt1');
  set(Bt1M, 'Callback', 'handlesub Bt1M');
  set(Bt2, 'Callback', 'handlesub Bt2');
  set(Bt2M, 'Callback', 'handlesub Bt2M');
  set(Bt3, 'Callback', 'handlesub Bt3');
  set(Bt3M, 'Callback', 'handlesub Bt3M');
  set(Bt4, 'Callback', 'handlesub Bt4');
  set(Bt4M, 'Callback', 'handlesub Bt4M');
  set(Bt5, 'Callback', 'handlesub Bt5');
  set(Bt5M, 'Callback', 'handlesub Bt5M');
  set(Bt6, 'Callback', 'handlesub Bt6');
  set(Bt6M, 'Callback', 'handlesub Bt6M');
  set(Bt7, 'Callback', 'handlesub Bt7');
  set(Bt7M, 'Callback', 'handlesub Bt7M');
  set(Bt8, 'Callback', 'handlesub Bt8');
  set(Bt8M, 'Callback', 'handlesub Bt8M');

  set(Zoom1, 'Callback', 'handlesub Zoom1');
  set(Zoom2, 'Callback', 'handlesub Zoom2');
  set(Rotat, 'Callback', 'handlesub Rotat');
  set(Coord, 'Callback', 'handlesub Coord');
  set(ReDrw, 'Callback', 'handlesub ReDrw');
  set (Ende, 'Callback', 'handlesub Ende');