% Subroutine fr Fractal 2.22
% written by Klaus Lichtenegger and Maurer Martin 
%
% Erfassen der Benutzeraktionen und Reaktion darauf

function handlesub(Ereignis)

  % Globale Variablen und Handles:

  global fig graph 
  global m1 m11 m12 m13 m14 m15
  global m2 m21 m22 m23
  global m3 m31 m32 m33 m34 m35
  global m4 m41 m42 m43 
  global m5 m51 m52 m53 m54 m55 m56
  global m6 m61 m62 m63
  global fr1 txtR tpar txtI tsch txtS rsch
  global Bt1 Bt1M Bt2 Bt2M Bt3 Bt3M Bt4 Bt4M
  global Bt5 Bt5M Bt6 Bt6M Bt7 Bt7M Bt8 Bt8M
  global Zoom1 Zoom2 Rotat Coord ReDrw Ende
  global FracMode ZoomMode Skala1 Funkt Param Steps
  global AXSkala AYSkala Movie OldSchritte R3D

switch Ereignis

% Funktionen:
case 'm11'   % z^2
  chkoff(1); set(m11, 'Checked', 'on');
  Funkt = 1;
case 'm12'   % z^3
  chkoff(1); set(m12, 'Checked', 'on');
  Funkt = 2;
case 'm13'   % exp(z)
  chkoff(1); set(m13, 'Checked', 'on');
  Funkt = 3;
case 'm14'   % sinh(z)
  chkoff(1); set(m14, 'Checked', 'on');
  Funkt = 4;
case 'm15'   % cosh(z)
  chkoff(1); set(m15, 'Checked', 'on');
  Funkt = 5;

% Parameter:
case 'm21'   % +c
  chkoff(2); set(m21, 'Checked', 'on');
  Param = 1;
case 'm22'   % -c
  chkoff(2); set(m22, 'Checked', 'on');
  Param = 2;
case 'm23'   % *c
  chkoff(2); set(m23, 'Checked', 'on');
  Param = 3;

%Farbschemata:
case 'm31'   % Jet (hot)
  chkoff(3); set(m31, 'Checked', 'on');
  colormap(jet);
case 'm32'   % Hot (hot)
  chkoff(3); set(m32, 'Checked', 'on');
  colormap(hot);
case 'm33'   % Green (summer)
  chkoff(3); set(m33, 'Checked', 'on');
  colormap(summer);
case 'm34'   % Bone (bone)
  chkoff(3); set(m34, 'Checked', 'on');
  colormap(bone);
case 'm35'   % Copper (copper)
  chkoff(3); set(m35, 'Checked', 'on');
  colormap(copper);
  
% Aufloesung
case 'm41'   % Hohe Aufloesung
  chkoff(4); set(m41, 'Checked', 'on');
  StepX(1);
  if FracMode>0; set(ReDrw, 'Visible', 'on'); end
case 'm42'   % Mittlere Aufloesung
  chkoff(4); set(m42, 'Checked', 'on');
  StepX(2); 
  if FracMode>0; set(ReDrw, 'Visible', 'on'); end
case 'm43'   % Niedere Aufloesung
  chkoff(4); set(m43, 'Checked', 'on');
  StepX(3);
  if FracMode>0; set(ReDrw, 'Visible', 'on'); end
  
% Beispiele:
case 'm51'   % San Marco
  set(txtR, 'String', '-1'); set(txtI, 'String', '0');
case 'm52'   % Dendrit
  set(txtR, 'String', '0'); set(txtI, 'String', '1');
case 'm53'   % Julia-Drachen
  set(txtR, 'String', '0.360284'); set(txtI, 'String', '0.1');
case 'm54'   % Fatou-Staub
  set(txtR, 'String', '0.11301'); set(txtI, 'String', '-0.67037');
case 'm55'   % Doudays Kaninchen
  set(txtR, 'String', '-0.122'); set(txtI, 'String', '0.745');
case 'm56'   % Misiurewicz-Punkt
  set(txtR, 'String', '-0.1011'); set(txtI, 'String', '0.9563');

% Bildschirmeinstellung  
case 'm61'
  setscr(1);
  chkoff(6); set(m61, 'Checked', 'on');  
case 'm62'  
  setscr(2);
  chkoff(6); set(m62, 'Checked', 'on');  
case 'm63'
  setscr(3);
  chkoff(6); set(m63, 'Checked', 'on');  
  
% Fraktale:
case 'Bt1'   % Julia, klassisch
  xfract(1,0);
case 'Bt1M'  % Movie
  xfract(1,1);
case 'Bt2'   % Julia, invers
  xfract(2,0);
case 'Bt2M'  % Movie
  xfract(2,1);
case 'Bt3'   % 3D-Julia, klassisch
  xfract(3,0);
case 'Bt3M'  % Movie
  xfract(3,1);
case 'Bt4'   % 3D-Julia, invers
  xfract(4,0);
case 'Bt4M'  % Movie
  xfract(4,1);
case 'Bt5'   % Mandelbrot, klassisch
  xfract(5,0);
case 'Bt5M'  % Movie
  xfract(5,1);
case 'Bt6'   % Mandelbrot, invers
  xfract(6,0);
case 'Bt6M'  % Movie
  xfract(6,1);
case 'Bt7'   % 3D-Mandelbrot, klassisch
  xfract(7,0);
case 'Bt7M'  % Movie
  xfract(7,1);
case 'Bt8'   % 3D-Mandelbrot, invers
  xfract(8,0);
case 'Bt8M'  % Movie
  xfract(8,1);

% Anderes:

case 'Zoom1' % Zoom
  set(m1, 'Enable', 'Off'); set(m2, 'Enable', 'Off'); set(m3, 'Enable', 'Off');    
  set(m4, 'Enable', 'Off'); set(m5, 'Enable', 'Off'); set(m6, 'Enable', 'Off');    
  button(0); ZoomMode = ZoomMode+1; Movie = 0;
  [x,y]=ginput(2);
  if x(1)>x(2)
    dummy = x(1); x(1) = x(2); x(2) = dummy;
  end
  if y(1)>y(2)
    dummy = y(1); y(1) = y(2); y(2) = dummy;
  end
  AXSkala = [x(1):(x(2)-x(1))/Steps:x(2)];
  AYSkala = [y(1):(y(2)-y(1))/Steps:y(2)];
  if ZoomMode == 1
    OldSchritte = str2num(get(txtS,'String'));
  end
  fracdraw;
  set(m3, 'Enable', 'On'); set(m4, 'Enable', 'On'); set(m6, 'Enable', 'On');

case 'Zoom2' % Unzoom
  ZoomMode = 0; AXSkala = Skala1; AYSkala = Skala1;
  set(txtS,'String', OldSchritte);
  fracdraw;
  set(m1, 'Enable', 'On'); set(m2, 'Enable', 'On'); set(m5, 'Enable', 'On');

case 'Rotat' % Rotate
  if ~R3D
    rotate3d on; R3D = 1;
    set(Rotat, 'String', 'Rotate OFF');
    button(0); button(4);
  else
    rotate3d off; R3D = 0;
    set(Rotat, 'String', 'Rotate');
    button(1);
  end    

case 'Coord' % Select Julia
  button(0);
  [x,y]=ginput(1);
  set(txtR, 'String', x);
  set(txtI, 'String', y);
  button(2);

case 'ReDrw'
  Movie=0;fracdraw
  
case 'Ende'
  close
 
end




















