function Sub(action,obj1,obj2)
% Processes all callbacks for CurveFitter

% Settings
global typelist matrix1 mat1fa mat1ffto mat1ffta calc disp

main=findobj('Tag','main');

% Switches
switch action
   
case 'Open'
   % Open Files
   hold on;
   [fname,pname] = uigetfile('*.dat','Open');
   matrix1=plateau(load (strcat(pname,fname)));
   matrix1d=plot(matrix1(:,1),matrix1(:,2),'b','Tag','matrix1d');
   SubSub('Display');
   
case 'Close';
   % Close Files
   
   clear matrix1 matrix2 mat1fa mat2fa mat1ffto mat1ffta mat2ffto mat2ffta;
   clc   
   
case 'Save';
   % Save Files
   
   [fname,pname] = uiputfile('*.dat','Save');
   
case 'FlotAvg';
   % Calculates the Floating Average for a Curve
   
   prompt = {'Enter average size:','Enter weighted average size:','Enter weight:'};
   title = 'Input for floating average';
   lines = 1;
   def = {'30','10','2'};
   answer = inputdlg(prompt,title,lines,def);
   mat1fa = filterung3(matrix1,str2num(answer{1}),str2num(answer{2}),str2num(answer{3}));
   calc(2,1)=1;
   mat1fad=plot(mat1fa(:,1),mat1fa(:,2),'magenta','Tag','mat1fad');
   SubSub('Display');
   
case 'FFTo1';   
   % Calculates the Fast Fourier Transformation for the Original Curve
   mat1ffto=SubSub('FFT',matrix1);
   figure(1);
   mat1fftod=plot(mat1ffto(:,1),mat1ffto(:,2),'red','Tag','mat1fftod');
   calc(3,1)=1;
   SubSub('Display');
   
case 'FFTa1';   
   % Calculates the Fast Fourier Transformation for the Averaged Curve
   mat1ffta=SubSub('FFT',mat1fa);
   figure(1);
   mat1fftad=plot(mat1ffta(:,1),mat1ffta(:,2),'green','Tag','mat1fftad');
   calc(4,1)=1;
	SubSub('Display');

case 'Help';   
   % Gives the Help-Window
   helpwin=figure('MenuBar','none','NumberTitle','off');
   helpwin=clf;
   set(helpwin,'Name','CurveFitter / Help');
   set(helpwin,'Resize','off');
   set(helpwin,'Position',[300 300 350 100]);
   
   textboxhelp1 = uicontrol('Parent',helpwin,'Units','normalized',...
   	'BackgroundColor',[0.8 0.8 0.8],'FontSize',9,...
   	'HorizontalAlignment','left','Position',[0.35 0.80 0.3 0.15],...
		'String','HELP US!!! PLEASE!','Style','text');
	textboxhelp2 = uicontrol('Parent',helpwin,'Units','normalized',...
   	'BackgroundColor',[0.8 0.8 0.8],'FontSize',9,...
   	'HorizontalAlignment','left','Position',[0.05 0.60 0.8 0.18],...
		'String','Please help poor, helpless, undernourished students!','Style','text');
	textboxhelp3 = uicontrol('Parent',helpwin,'Units','normalized',...
   	'BackgroundColor',[0.8 0.8 0.8],'FontSize',9,...
   	'HorizontalAlignment','left','Position',[0.05 0.4 0.3 0.18],...
		'String','Donations to :','Style','text');
	textboxhelpm = uicontrol('Parent',helpwin,'Units','normalized',...
   	'BackgroundColor',[0.8 0.8 0.8],'FontSize',9,...
   	'HorizontalAlignment','left','Position',[0.35 0.4 0.6 0.18],...
		'String',' "Erste Bank" account 41032233754 and','Style','text');
	textboxhelpb = uicontrol('Parent',helpwin,'Units','normalized',...
   	'BackgroundColor',[0.8 0.8 0.8],'FontSize',9,...
   	'HorizontalAlignment','left','Position',[0.35 0.2 0.6 0.18],...
      'String',' "CA" account 14888708600 and','Style','text');
   textboxhelpa = uicontrol('Parent',helpwin,'Units','normalized',...
   	'BackgroundColor',[0.8 0.8 0.8],'FontSize',9,...
   	'HorizontalAlignment','left','Position',[0.35 0.0 0.6 0.18],...
      'String',' "Bank Austria" account 76520746300','Style','text');
	%helpbutton = uicontrol('Parent',helpwin,'Units','normalized',...
   %   'BackgroundColor',[0.8 0.8 0.8],'Fontsize',9
   %   'HorizontalAlignment','left',

case 'DispMenu'
   % Shows the Menu to choose the displayed Data
   
   dispwin=figure('MenuBar','none','NumberTitle','off','Units','normalized');
   dispwin=clf;
   set(dispwin,'Name','CurveFitter / Display');
   set(dispwin,'Resize','off');
   set(dispwin,'Position',[0.60 0.60 0.3 0.3]);
   
   disptextbox = uicontrol('Parent',dispwin,'Units','normalized',...
   	'BackgroundColor',[0.8 0.8 0.8],'FontSize',9,...
   	'HorizontalAlignment','left','Position',[0.05 0.85 0.85 0.10],...
      'String','Pick Data to be Displayed :','Style','text');

   dispchboxorig = uicontrol('Parent',dispwin,'Units','normalized',...
   	'BackgroundColor',[0.8 0.8 0.8],'FontSize',9,...
   	'HorizontalAlignment','left','Position',[0.05 0.75 0.85 0.10],...
      'String','Original Data','Style','checkbox','Callback','SubSub AlterDisp 1',...
      'Tag','dispchboxorig');
	dispchboxfa = uicontrol('Parent',dispwin,'Units','normalized',...
   	'BackgroundColor',[0.8 0.8 0.8],'FontSize',9,...
   	'HorizontalAlignment','left','Position',[0.05 0.65 0.85 0.10],...
      'String','Averaged Data','Style','checkbox','Callback','SubSub AlterDisp 2',...
      'Tag','dispchboxfa');
	dispchboxffto = uicontrol('Parent',dispwin,'Units','normalized',...
   	'BackgroundColor',[0.8 0.8 0.8],'FontSize',9,...
   	'HorizontalAlignment','left','Position',[0.05 0.55 0.85 0.1],...
      'String','Fourier Backtransformed Data of Original Data','Style','checkbox',...
      'Callback','SubSub AlterDisp 3','Tag','dispchboxffto');
	dispchboxffto = uicontrol('Parent',dispwin,'Units','normalized',...
   	'BackgroundColor',[0.8 0.8 0.8],'FontSize',9,...
   	'HorizontalAlignment','left','Position',[0.05 0.45 0.85 0.1],...
      'String','Fourier Backtransformed Data of Averaged Data','Style','checkbox',...
      'Callback','SubSub AlterDisp 4','Tag','dispchboxffta');
   
   dispbutton = uicontrol('Parent',dispwin,'Units','normalized',...
   	'BackgroundColor',[0.8 0.8 0.8],'FontSize',9,...
   	'HorizontalAlignment','left','Position',[0.35 0.10 0.30 0.15],...
      'String','Display','Style','pushbutton','CallBack','SubSub Display');
   
   close(dispwin);
end   