function [out1,out2]=SubSub(action,in1,in2);
% Processes all callbacks for CurvFitter-Sub

% Settings
global matrix1 mat1fa mat1ffto mat1ffta calc disp

altdisp1 = findobj('Tag','dispchboxorig');
altdisp2 = findobj('Tag','dispchboxfa');
altdisp3 = findobj('Tag','dispchboxffto');
altdisp4 = findobj('Tag','dispchboxffta');

switch action
      
case 'FFT'      
   fftwin=figure('Name','Fast Fourier Transformation','NumberTitle','off',...
      'Units','normalized','Resize','off','Position',[0.15 0.15 0.80 0.75],...
      'MenuBar','none');
   
   subplot(2,2,1);
   plot(in1(:,1),in1(:,2),'blue');
   title('Original Data');
   
   numpts=length(in1);
	ts = min(in1(:,1)); te = max(in1(:,1)); td = (te-ts)/(numpts-1);
	t = ts:td:te;
	y=in1(:,2);yori=y;

	in1transf = fft(y);
	power = abs(in1transf(1:numpts/2)).^2/ numpts;

	%ny = [0:numpts/2-1]/te;
	ny = (1:numpts/2)/(numpts/2)*0.5;
   
   subplot(2,2,2);
	plot(ny(2:numpts/2),log(power(2:numpts/2)),'blue');
   set(gca,'XLim',[0 0.075]);
   %set(gca,'XLimMode','auto')
   title('Frequencies');
   
   hold on;
   
	% Cut-off for high frequencies
	cutoff_swi = 1;
	upperlim = 0.05;
	if cutoff_swi,
   	nullfil = find(ny>upperlim);
   	minnull = min(nullfil);
   	maxnull = max(nullfil);
   	maxnull = maxnull + (maxnull - minnull);
   	in1transf(minnull:maxnull) = 0;
	end
	fyf = in1transf;

	% Find dominant frequencies
	dom_swi = 0;
	lowlim = 0.005;

	power1 = abs(in1transf).^2 / numpts;
	power1(1) = 0;
	maxtest = max(power1);
	maxind = find( power1>maxtest*lowlim );

	freq = maxind;
	lfreq = length(freq);

	nyr = (freq(1:lfreq/2)-1) / te;

	if dom_swi
   	fyf = zeros(size(in1transf)); 
   	fyf(maxind) = in1transf(maxind);
	end
   
   plot(ny(2:numpts/2),log(fyf(2:numpts/2)),'red');
   hold off
   
   % FFT back transformation
	yf = ifft(fyf,numpts);
      
	subplot(2,2,3);
	% plot(t,y,'b',t,yf,'red')
	plot(t,yf(1:numpts),'red')
   abs(corrcoef(y,yf(1:numpts)));
   title('Backtransformed Data');
   
   resid = yori-yf(1:numpts);
   
   subplot(2,2,4);
   plot(t,real(resid),'green');
   title('Residue');
   
   out1=[in1(:,1),yf];
   
case 'Display'
   figure(1);
   clc;
   hold on;
   disp_swi=calc.*disp;
   if disp_swi(1,1);
      %plot(matrix1(:,1),matrix1(:,2),'Color','blue');
      set(altdisp1,'Visible','on');
   else
      set(altdisp1,'Visible','off');
   end;
   if disp_swi(2,1);
      %plot(mat1fa(:,1),mat1fa(:,2),'Color','magenta');
      set(altdisp2,'Visible','on');
   else
      set(altdisp2,'Visible','off');
   end;
   if disp_swi(3,1);
      %plot(mat1ffto(:,1),mat1ffto(:,2),'Color','red');
      set(altdisp3,'Visible','on');
   else
      set(altdisp3,'Visible','off');
   end;
   if disp_swi(4,1);
      %plot(mat1ffta(:,1),mat1ffta(:,2),'Color','green');
      set(altdisp4,'Visible','on');
   else
      set(altdisp4,'Visible','off');
   end;
   
   
case 'AlterDisp'
   if disp(str2num(in1),1)==1;
      disp(str2num(in1),1)=0;
      disp
   else;
      disp(str2num(in1),1)==0;
      disp(str2num(in1),1)=1;
      disp
   end;
   
   
end;  