function COUNTER=mandeldemo()
% Demoprogramm zur Visualisierung der Mandelbrotmenge
% ===================================================
% created by alex k. on 6.2.1999
% Files: mandeldemo.m, mandelbrot.m, mandelsub.m
%
% Theorie:
% Bilde die Folge c, c^2+c, (c^2+c)^2+c, ... fuer jeden Punkt eines Bereichs
% in der C-Ebene. Breche die Folge ab, wenn der Betrag des Folgengliedes >= 2,
% da in diesem Fall die Folge divergiert.
% Zaehle die Iterationsschritte bis dahin mit. -> Dieser Counter liefert 
% Information darueber, wie schnell die Folge divergiert.
% Die Mandelbrotmenge ist nun jener Bereich in der C-Ebene in dem die Folge
% konvergiert.
% 

% Workspace vorbereiten
clear all
close all
flops(0);

% Globale Variablen, da sie in Unterfunktionen sichtbar sein muessen
global COUNTER realmin realmax imagmin imagmax res accuracy

% Anfangsgrenzen ergeben sich
% durch die Konvergenzbedingungen fuer die Mandelbrotmenge
% aus der Theorie

realmin = -2.0;
realmax = 0.5;
imagmin = -1.25;
imagmax = 1.25;

% Anfangsaufloesung, der Bereich der C-Ebene wird in 100x100pixels
% zerlegt
res = 200;

% Anfangsrechengenauigkeit, Anzahl der Iterationsschritte
accuracy = 30;

% Window aufmachen
% Aktuelle Bildschirmaufloesung bestimmen
scrsz = get(0,'ScreenSize');

% Figure Einstellungen setzen
hparent = figure('Position',[scrsz(3)/8 scrsz(4)/8 scrsz(3)*3/4 scrsz(4)*3/4], ...
   'BackingStore','off', ... 
   'Color',[0.9 0.9 0.8], ...
   'HandleVisibility','callback', ...
   'MenuBar','figure', ...
   'Name','Fraktale - Die Mandelbrot-Menge', ...
   'NumberTitle','off', ...
   'Pointer','crosshair', ...
   'Tag','Fig');
hmenu = uimenu('Parent',hparent,'Label','Auflsung');
        uimenu(hmenu,'Label','100x100','Callback','mandelsub 100');
        uimenu(hmenu,'Label','200x200','Callback','mandelsub 200');
        uimenu(hmenu,'Label','400x400','Callback','mandelsub 400');
haxes = axes('Parent',hparent, ...
   'CLimMode','auto', ...
   'TickDir','out', ...
   'DataAspectRatio',[1 1 1], ...
   'Tag','MandelAxes');
drawnow;

% Mandelbrotmenge berechnen, Divergenzinformation ist im Feld
% COUNTER enthalten
mandelbrot;

% Mandelbrotmenge zeichnen
himage = image(flipud(COUNTER),'Parent',haxes, ...
   'CDataMapping','scaled', ...
   'Tag','MandelFig');
set(haxes, ...
   'CLimMode','auto', ...
   'TickDir','out', ...
   'DataAspectRatio',[1 1 1], ...
   'XTick',[realmin realmax], ...
   'XTickLabelMode','manual', ...
   'XTickLabel',[realmin;realmax], ...
   'YTick',[imagmin imagmax], ...
   'YTickLabelMode','manual', ...
   'YTickLabel',[imagmin;imagmax], ...
   'Tag','MandelAxes');

% Zoomfunktion ermoeglichen
set(himage,'ButtonDownFcn','mandelsub zoomin');

% shading interp;
% rotate3d on;
% axis off;
