function mandelsub(typ)

global COUNTER realmin realmax imagmin imagmax res accuracy

hfig = findobj('Tag','MandelFig');
hax  = findobj('Tag','MandelAxes');

switch typ
case 'zoomin'
   xy_left_top = fix(get(gca, 'CurrentPoint'));
   rbbox;
   xy_right_bottom = fix(get(gca, 'CurrentPoint'));
   
   rect(1) = realmin + abs((realmax - realmin)/res*xy_left_top(1,1));
   rect(2) = realmin + abs((realmax - realmin)/res*xy_right_bottom(1,1));
   rect(3) = imagmin + abs((imagmax - imagmin)/res*(res-abs(xy_right_bottom(1,2))));
   rect(4) = imagmin + abs((imagmax - imagmin)/res*(res-abs(xy_left_top(1,2))));
   
   FixRatio = max(rect(2)-rect(1), rect(4)-rect(3));
   
   realmin = rect(1)
   realmax = rect(1) + FixRatio
   imagmin = rect(3)
   imagmax = rect(3) + FixRatio
   
   mandelbrot;
   set(hax, ...
     'XTickLabel',[realmin;realmax], ...
     'YTickLabel',[imagmin;imagmax]);

   set(hfig,'CData', flipud(COUNTER), ...
     'CDataMapping','scaled');
   clear realmin realmax imagmin imagmax res accuracy
  
case '100'
   if (res ~= 100)
      res = 100;
      mandelbrot;
      set(hax, ...
         'CLimMode','auto', ...
         'XLimMode','auto', ...
         'YlimMode','auto', ...
         'XTickLabel',[realmin;realmax], ...
         'YTickLabel',[imagmin;imagmax]);

       set(hfig,'CData', flipud(COUNTER), ...
       'CDataMapping','scaled');
      clear realmin realmax imagmin imagmax res accuracy
    end
    
case '200'
   if (res ~= 200)
      res = 200;
      mandelbrot;
      set(hax, ...
         'CLimMode','auto', ...
         'XLimMode','auto', ...
         'YlimMode','auto', ...
         'XTickLabel',[realmin;realmax], ...
         'YTickLabel',[imagmin;imagmax]);

      set(hfig,'CData', flipud(COUNTER), ...
       'CDataMapping','scaled');
      clear realmin realmax imagmin imagmax res accuracy
    end
    
case '400'
   if (res ~= 400)
      res = 400;
      mandelbrot;
      set(hax, ...
         'CLimMode','auto', ...
         'XLimMode','auto', ...
         'YlimMode','auto', ...
         'XTickLabel',[realmin;realmax], ...
         'YTickLabel',[imagmin;imagmax]);

      set(hfig,'CData', flipud(COUNTER), ...
       'CDataMapping','scaled');
      clear realmin realmax imagmin imagmax res accuracy
   end
end
