%this script (part of thermend1) manages the input of the space geometry. 
%The main program uses vertices and faces to specify a certain geometry,
%if you choose to enter space geometry by entering the vertex matrix and the faces matrix,
%which is neccesary for any geometry that is not a cuboid, 
%it is important to know that results are only correct if the space is a closed convex room. 


xyz= zeros(1,3);
xyz=input('If you want to create a tetragonal room  enter dimensions [x y z], else  press return:  ');

 if isempty(xyz)
 vert=input('Enter vertices matrix (every triple represents a vertice [x1 y1 z1 ; x2 y2 z2; ...]): ');
 fac=input('Enter faces matrix (every triple represents 3 vertices (linenumber in vertices matrix = verticenumber):  '); 
 else
 [vert,fac]=quaddat(xyz); %calculates vertex and faces matrix for a cuboid with the dimensions x y z
 end

[a,b,c,v,w]=dreieckeabc(vert,fac); %given the Vertex and the Faces matrices this function calculates the points (a,b,c) of every triangle, representing one face v and w are the vectors pointing from a to b resp. from a to c.

klfl=input('Enter maximum size of the areas you want to use for approximating the surface integrals (default = 1): ');
 if isempty(klfl)
 klfl=1
 end
 

 [nmat,part]=nvec1(a,v,w,klfl); %calculates normal-vectors for every face pointing to the inside of the room, and the necessary partition of v and w (integer) to create sub-areas <= klf;
