function[nmat,part]=nvec1(a,v,w,klflaech)

%[nmat,part]=nvec1(a,v,w,klflaech)
%a: every line of this matrix represents one! point of a triangle (face) 
%The triangles are supposed to form a closed, convex space!!
%line number of a = number of faces of the given geometry
%v,w: starting in a these vectors (lines of v and w) specify the triangles (faces)
%klflaech: in the following it will be neccesary to partitionate the faces into small faces
%klflaech is an input variable specifying the maximumsize of these sub-faces
%nmat: (length(a))X3 matrix, 
%lines represent normal vectors to the faces represented by the lines of a,v,w pointing to the inside of the room. 

k=length(a);

     for m=1:k;                 %every face;

     vm=v(m,:);
     wm=w(m,:);
     am=a(m,:);
     n=cross(vm,wm);            %vm X wm
     pmitte=am+(vm/3.23+wm/4.77);      %point in triangle
     s=0;
     n1=(-1)*n;                 %koeff. in lin. equ.-system equating line and plane
     dist1=2;
     dist2=2;
     distn=2;
     pindr=0;                   %log. var. intersection inside triangle->pindr =1

      while pindr==0;       
   
       s=s+1;
       if s~=m
       v1=v(s,:);
       w1=w(s,:);
       as=a(s,:); 
       n2=cross(v1,w1);         %plane, to be equated with line
       orthotest=n1*n2';

        if orthotest~=0         %plane parallel to line? 
        koeffmat=cat(2,v1',w1',n1');
        inhom=pmitte-as;
        dist12n=inv(koeffmat)*inhom';
        dist1=dist12n(1,:);
        dist2=dist12n(2,:);
        distn=(dist12n(3,:));
        pindr=pin(as,v1,w1,dist1,dist2); 
        end
       end
      end

     part1=ceil(sqrt(norm(n)/klflaech));         
     n=n/norm(n);         
      if distn<0
       n=(-1)*n;
      end

      if m==1
      part=part1;
      nmat=n;
      else
      nmat=cat(1,nmat,n);
      part=cat(1,part,part1);
      end 
     
     end


function pindr=pin(as,v1,w1,dist1,dist2)

  dsprelzua=dist1*v1+dist2*w1;
             %durchstosspunkt der gerade durch ebene von a aus gesehen
  if dist1<=0 | dist1>=1| dist2<=0 | dist2>=1
  pindr=0;
  else
   long=w1;
   short=v1;
  
  u=long-short;                            %3. vector of triangle
  matri3=cat(2,short',u');

  matri=[matri3(1,:);matri3(2,:)]; 
  inho=[dsprelzua(:,1);dsprelzua(:,2)];     %generates inhomogenity 2X1-vector
   if det(matri)==0
   matri=[matri3(2,:);matri3(3,:)]; 
   inho=[dsprelzua(:,2);dsprelzua(:,3)];
    if det(matri)==0
    matri=[matri3(1,:);matri3(3,:)];
    inho=[dsprelzua(:,1);dsprelzua(:,3)];
    end
   end        
   %da das problem eben ist, und ich zur loesung eine quadrat. matrix brauche,
   %lasse ich eine koordinate (zeile) einfach weg, ohne dass dabei eine sing. koeffmat. entsteht. 
   %(dazu ist if abfrage gut)

  loes=inv(matri)*inho; 
           
  %loesung des glssystems das entsteht wenn man dsprelzua in der form 
  %dsprelzua=loes(1) * short + loes(2) * u darstellt

   if loes(1,:)<=1&loes(2,:)<=1
   pindr=1;
   else
   pindr=0;
   end
  end






