%calculates a test raster in the given space x and y values are calculated, z can be entered
%xvec,yvec,zmat: is the required data structure for the surface plot.
%rastpoint: this (number of rasterpoints)X3 matrix is the required data structure  
%representing the raster for the following calculations in "phiall"

xmin=min(vert(:,1));
ymin=min(vert(:,2));
zmin=min(vert(:,3));
xmax=max(vert(:,1));
ymax=max(vert(:,2));
zmax=max(vert(:,3));


deltax=abs(xmin-xmax);
deltay=abs(ymin-ymax);
deltaz=abs(zmin-zmax);
rastdiv=max(deltax,deltay)/30;
xrast=ceil(deltax/rastdiv);
yrast=ceil(deltay/rastdiv);

xvec=(xmin:deltax/xrast:xmax);
yvec=(ymin:deltay/yrast:ymax);


zok=0;

while zok==0
zrast=input('Enter hight of raster above the x-y plane:');
 if zrast<zmin |  zrast>zmax
  zrast=input('Raster not in defined space, press any key');
 else
  zok=1;
 end;
end; 

zmat=zrast*ones(length(yvec),length(xvec));

apr=[xmin ymin zrast];
vpr=[deltax/xrast 0 0];
wpr=[0 deltay/yrast 0];


rastpoint=apr;


wpr1=wpr;

  for l=1:xrast
      rastpoint=cat(1,rastpoint,apr+l*vpr);
      wpr=cat(1,wpr,wpr1);
  end
      an=rastpoint;
      
  for l=1:yrast
      an2=an+l*wpr;
      rastpoint=cat(1,rastpoint,an2);
  end

  







