function [emmstr,flhell,waermestr]=straustausch(Phi,eps,t)

%[emmstr,flhell,waermestr]=straustausch(Phi,eps,t):
%eps, t see "inputepstemp"
%phi is the corrected PHIKL-matrix for the planes
%emmstr: emissionstromdichte
%flhell: flaechenhelligkeiten
%waermestr: heat flux density


emmstr=eps.*5.6703e-8 .*(t+273.15).^4;				
epsmat=ones(length(eps));

for k=1:length(eps)
epsmat(k,:)=eps(k);
end

flhell=inv(eye(length(eps))-(1-epsmat).*Phi)*emmstr';

waermestr=emmstr'-eps'.*(Phi*flhell); 
