function pdemodel
[pde_fig,ax]=pdeinit;
pdetool('appl_cb',6);
set(ax,'DataAspectRatio',[1 1 2]);
set(ax,'PlotBoxAspectRatio',[1 1 1]);
set(ax,'XLimMode','auto');
set(ax,'YLimMode','auto');
set(ax,'XTick',[ 0,...
 0.10000000000000001,...
 0.20000000000000001,...
 0.30000000000000004,...
 0.40000000000000002,...
 0.5,...
 0.59999999999999998,...
 0.69999999999999996,...
 0.80000000000000004,...
 0.90000000000000002,...
 1,...
]);
set(ax,'YTick',[ 0,...
 0.10000000000000001,...
 0.20000000000000001,...
 0.30000000000000004,...
 0.40000000000000002,...
 0.5,...
 0.59999999999999998,...
 0.69999999999999996,...
 0.80000000000000004,...
 0.90000000000000002,...
 1,...
]);
pdetool('gridon','on');

% Geometry description:
pdeellip(0,0,1,1,...
0,'C1');
pdeellip(0,0,0.80000000000000004,0.80000000000000004,...
0,'C2');
pdeellip(0,0,0.59999999999999998,0.59999999999999998,...
0,'C3');
pdeellip(0,0,0.5,0.5,...
0,'C4');
pdeellip(0,0,0.40000000000000002,0.40000000000000002,...
0,'C5');
pderect([0 1 1 0],'SQ1');
pderect([-0.20000000000000001 0.20000000000000001 0.89999999999999991 0.20000000000000001],'R1');
pderect([-0.10000000000000001 0.10000000000000001 0.89999999999999991 0.20000000000000001],'R2');
set(findobj(get(pde_fig,'Children'),'Tag','PDEEval'),'String','(C1+C2+C3+C4+C5+R1+R2) * SQ1')

% Boundary conditions:
pdetool('changemode',0)
pdetool('removeb',[25 1 ]);
pdetool('removeb',[18 20 22 23 1 17 16 ]);
pdetool('removeb',[16 20 23 ]);
pdetool('removeb',[21 19 ]);
pdesetbd(16,...
'dir',...
1,...
'1',...
'0')
pdesetbd(12,...
'dir',...
1,...
'1',...
'0')
pdesetbd(11,...
'dir',...
1,...
'1',...
'0')
pdesetbd(10,...
'dir',...
1,...
'1',...
'0')
pdesetbd(9,...
'dir',...
1,...
'1',...
'0')
pdesetbd(8,...
'dir',...
1,...
'1',...
'0')
pdesetbd(7,...
'dir',...
1,...
'1',...
'0')
pdesetbd(6,...
'dir',...
1,...
'1',...
'0')
pdesetbd(5,...
'neu',...
1,...
'0',...
'0')
pdesetbd(4,...
'neu',...
1,...
'0',...
'0')
pdesetbd(3,...
'neu',...
1,...
'0',...
'0')
pdesetbd(2,...
'neu',...
1,...
'0',...
'0')
pdesetbd(1,...
'neu',...
1,...
'0',...
'0')

% Mesh generation:
setuprop(pde_fig,'Hgrad',1.3);
setuprop(pde_fig,'refinemethod','regular');
pdetool('initmesh')

% PDE coefficients:
pdeseteq(1,...
'1./(5000./(1+0.05*(ux.^2+uy.^2))+200)!1./(5000./(1+0.05*(ux.^2+uy.^2))+200)!1./(1.0)!1./(1.0)',...
'0.0!0.0!0.0!0.0',...
'0!0!0!1.0',...
'1.0!1.0!1.0!1.0',...
'0:10',...
'0.0',...
'0.0',...
'[0 100]')
setuprop(pde_fig,'currparam',...
['5000./(1+0.05*(ux.^2+uy.^2))+200!5000./(1+0.05*(ux.^2+uy.^2))+200!1.0!1.0';...
'0!0!0!1.0                                                                '])

% Solve parameters:
setuprop(pde_fig,'solveparam',...
str2mat('1','1797','10','pdeadworst',...
'0.5','longest','1','1e-4','','fixed','inf'))

% Plotflags and user data strings:
setuprop(pde_fig,'plotflags',[1 1 1 1 1 1 6 1 0 0 0 1 0 1 0 0 0 3]);
setuprop(pde_fig,'colstring','');
setuprop(pde_fig,'arrowstring','');
setuprop(pde_fig,'deformstring','');
setuprop(pde_fig,'heightstring','');

% Solve PDE:
pdetool('solve')
