function slide=slide4
% This is a slideshow file for use with playshow.m and makeshow.m
% To see it run, type 'playshow slide4', 

% Copyright (c) 1984-98 by The MathWorks, Inc.
if nargout<1,
  playshow slide4
else
  %========== Slide 1 ==========

slide(1).code={
   'load sunspot1.mat',
   'plot (time(:,1),ca)',
   'zoom xon',
   'title( ''Rohdaten des Ca-Index'')',
	'xlabel(''Jahr'')',
	'ylabel(''Ca-Index / r.E.'')'};
slide(1).text={
'Dies sind die tglich gemessenen Werte des Ca-Index zwischen 1945 und 1987.',
'Da nicht von jedem Tag Mewerte vorliegen, wurden die fehlenden Daten durch NaN (=not a number) ersetzt.',
'Dies strt zwar nicht Darstellung der Werte, macht aber eine mathematische Weiterbehandlung (z.B. Fourier-Analyse) der Mereihen unmglich,',
'da jede Rechnung, in der ein NaN-Ausdruck vorkommt als Ergebnis wieder einen NaN-Ausdruck erzeugt.',
'Die fehlenden Daten erkennt man in Vergrerung als Lcken im Graph.'
};

  %========== Slide 2 ==========
  
  slide(2).code={
  	'plot(vergl(:,1),anz);',
	'zoom xon',  
   'title( ''Hilfsvektor zur Eliminierung der NaN-Ausdrcke'')', 
   'xlabel( '' Jahr'')',
   'ylabel(''Gre der fehlenden Datenblcke'')'
	};
   slide(2).text={
      'Zur weiteren Verwendung der Mereihen mssen deren NaN-Ausdrcke durch geeignete Zahlenwerte ersetzt werden.',
      'Hierzu wurde alle NaNs eines fehlenden Datenblocks von der Funktion MITTEL durch den nchsten vorhandenen Mewert ersetzt.',
      'Dies ist kein sehr gutes Mittelungsverfahren, liefert aber Werte, die in einem plausiblen Bereich liegen.',
      'Der dargestellte Vektor gibt den Abstand jedes Datenpunktes im Mevektor zum nchsten regulren Wert an und wird von der Funktion MITTEL bentigt',
      'Der Maximalwert (=erster Wert) der Peaks gibt die gre des jeweiligen NaN-Blocks an.'         };

  %========== Slide 3 ==========

  slide(3).code={
   'plot (vergl(:,1),caind(:,1))',
   'zoom xon',
   'title( ''von NaN-Ausdrcken befreiter Ca-Index'')', 
   'xlabel(''Jahr'')',
	'ylabel(''Ca-Index / r.E.'')'};
slide(3).text={
   'Dies ist das Ergebins der ''Mittelung''. ',
   'Man beachte die Plateaus in der ersten Periode'
   
};
  
  %========== Slide 4 ==========

  slide(4).code={
   'plot (dssnr(:,1),sunny)',
   'zoom xon',
   'title( ''Anzahl der Sonnenflecken (tgliche Aufzeichnung)'')' ,
   'xlabel(''Jahr'')',
   'ylabel(''Anzahl der Sonnenflecken'')'
};
slide(4).text={
   'Tgliche Sonnenfleckendaten von 1818 bis 1998.',
 	'Diese wurden mit klarem Wasser schonend von NaN befreit, wobei das Aroma vollstndig erhalten blieb.',				  
   'Auch hier sind in Vergrerung Plateaus erkennbar' 
 };
  
  %========== Slide 5 ==========

  slide(5).code={
   'plot (vergl(:,1),vergl(:,2:3))',
   'title( ''Vergleich zwischen Anz. der Sonnenflecken und Ca-Index'')', 
   'xlabel(''Jahr'')',
	'ylabel(''Anz. der Sonnenflecken bzw. Ca-index (r.E.)'')',
   'text(1965,500,''grn: Ca-Index'')',
   'text(1965,450,''blau: Sonnenflecken'')'
};
slide(5).text={
   'In dieser Abbildung sind beide Kurven dargestellt, wobei der 11-Jahreszyklus bei beiden Gren klar erkennbar ist',
   'Bei starker Vergrerung lt sich ebenfalls ein schwacher 1-Monatszyklus erkennen.',
   'Zu beachten ist der erste Zyklus des Ca-index (um 1950), welcher im Vergleich zu den Monatsmittelwerten aus anderer Quelle (siehe Slide 7)',
   'zu stark bzw. zu frh erscheint'
};
  
  %========== Slide 6 ==========

slide(6).code={
   'load sunspot1.mat',
   'plot (monthssn(:,2),monthssn(:,3))',
   'title( ''Monatsmittel der Sonnenfleckenzahlen'')',
   'xlabel(''Jahr'')',
	'ylabel(''Anz. der Sonnenflecken'')'};
slide(6).text={
   'Monatsmittelwerte von Sonnenfleckendaten.',
   'Diese Daten wurden in dieser Form bereitgestellt und muten nicht mehr nachbearbeitet werden.'
};

  %========== Slide 7 ==========

  slide(7).code={
	'plot (mvergl(:,1),mvergl(:,2:3))',
   'title( ''Vergleich der Sonnenfleckendaten und Ca-Index (Monatsmittel)'')', 
   'zoom xon',
    'xlabel(''Jahr'')',
	'ylabel(''Anz. der Sonnenflecken bzw. Ca-Index'')'
};
  slide(7).text={
     'Hier sieht man die Monatsmittel von Ca-Index und Sonnenflecken im Vergleich.',
     'Auch hier ist der 11-Jahreszyklus deutlich erkennbar'
  };
  
   %========== Slide 8 ==========

slide(8).code={
   'plot(sun)',
	'title( ''Sonnenfleckendaten, fr FFT auf 2^1^6 Werte gekrzt'')', 
   'xlabel(''Tage(=Laufzahl)'')',
   'ylabel(''Sonnenfleckenzahl'')'
	};
   
     slide(8).text={
        'Hier sind wieder die tglichen Sonnenfleckendaten, welche zur schnellen Durchfhrung der FFT (Fast-Fourier-Transform)',
      	'auf 65536 (=2^16) Werte ''zurechtgeschnitten'' wurden. Die ursprngliche Datenanzahl betrug 66109.'  
     };

 %========== Slide 9 ==========

slide(9).code={
   'plot(sffp)',
   'title(''Abb.1: Fourierspektrum der Sonnenfeckendaten'')',
   'axis([0 65536 0 10^5])',
   'xlabel(''Frequenz / Gesamtdauer^-^1'')',
   'ylabel(''FT (Power-Darst.)'')',
   'pause',
   'plot(sny,sffp)',
   'title(''Abb.2: Auf Einheit Jahre^-^1 skaliertes Spektrum'')',
   'xlabel(''Frequenz /  Jahr^-^1'')',
   'ylabel(''FT (Power-Darst.)'')',
   'axis([0 183 0 10^5])',
   'pause',
   'grid on',
   'title(''Abb.3: Vergrerung: Peak des 11-Jahreszyklus'')',
   'axis([0 1 0 1.5*10^7])',
   'pause', 
   'title(''Abb.4: Peak krzerer Periode (~1 Monat)'')',
   'axis([0 50 0 10^5])'};
slide(9).text={
   'In diesem Slide sehen sie verschidene Abbildungen, welche sie durch Tastendruck umschalten knnen.',
   'Abb.1:'
   'Das Fourier-Spektrum der Daten in Power-Darstellung: abs(FT)^2/(Anz. der Daten):',
   'Hier erkennt man die Symmetrie der FT einer reelen Funktion (Sonnenflecken). Die Skalierung der Frequenzachse gibt an, wie oft die jeweilige Periode',
   'im gesamten X-Bereich (=65536 Tage) vorkommt.',
   'Abb.2:',
   'Hier wird nur die erste Hlfte des Spektrums dargestellt. Die Frequenz-Skalierung wurde auf ''pro Jahr'' umgerechnet.',
   'Abb.3:',
   'Dieser Peak ist bei 0.1, bzw. 0.09 pro Jahr lokalisiert. Dies entspricht einer Periode von 10-11 Jahren.',
   'Man beachte im Vergleich zur nchsten Abbildung die unterschiedliche Grenordnung der Peakhhen',
   'Abb.4:',
   'Dieser Peak befindet sich bei 13,5 pro Jahr und entspricht ungefhr einem 27 Tage-Zyklus. Mgliche Einflsse: Mond ??. '     
};
%---------------
slide(10).code={
     'plot(ruck)'
     'title(''Fourier-geglttete Tagesdaten der Sonnenflecken'')',
     'xlabel(''Tage (=Laufzahl)'')',
     'ylabel(''Sonnenflecken'')'
  };

slide(10).text={
   'Dies ist die Rcktransformierte eines Spektrums, dessen Frequenzen ber 0,5 pro Jahr weggeschnitten wurden,',
   'd.h. in dieser Abbildung existieren keine Frequenzen mit Periodendauern < 2 Jahre.' 
};
%---------------
slide(11).code={
   'plot(correl)'
   'title(''Korrelationsfunktion von Ca-Index und Sonnenflecken'')',
   'xlabel(''Laufzahl'')',
   'ylabel(''Korrelation'')'
};
slide(11).text={
   'Die numerische Kreuzkorrelation von Ca-Index und Sonnenflecken (jeweils Tagesdaten) erfolgte durch Umkehrung eines Datenvektors (Strzen der Indices)',
   'und Durchfhrung einer Faltung mittels des ''conv''-Befehls.',
   'Auch hier erkennt man das Auftreten zweier verschiedener Perioden in beiden Datenreihen'
};

end