% FINITE ELEMENTE BERECHNUNG IN DER EBENE MIT DREIECKSELEMENTEN
% Peter Mhlhans, Alexander Kollreider

% Applikationssoftware und Programmieren fr Fortgeschrittene
% Institut fr theoretische Physik, Prof. Kernbichler
% Sommersemester 2000



clear;

% PARAMETER-EINGABEROUTINE

% Figure initialisieren 
Scrz=get(0,'ScreenSize');   
figure_1 = figure('Position',[Scrz(1) Scrz(2) Scrz(3) Scrz(4)]);

% Axen initialisieren
axes_1=axes('Position',[.1 .3 .8 .6],'Parent',figure_1);
axis equal   

% Fenstertitel
uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[.4 .95 .2 .04],...
   'String','Matlab FE-Berechnung','FontSize',14);

uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[.4 .91 .2 .03],...
   'String','> Parameterdefinition <','FontSize',12);


pos1=[.1 .2]; 

% Steuerelemente zur Eingabe der Balken-Abmessungen initialisieren
lg_text_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos1(1) pos1(2) .08 .03],...
   'String','Balken-Lnge:','HorizontalAlignment','left');

lg_val_handle=uicontrol('Style','edit', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos1(1)+.08 pos1(2) .04 .03],...
   'TooltipString','Lnge des Balkens (Standardeinheit [cm])',...
   'String','100','HorizontalAlignment','left');

br_text_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos1(1) pos1(2)-.03 .08 .03],...
   'String','Balken-Breite:','HorizontalAlignment','left');

br_val_handle=uicontrol('Style','edit', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos1(1)+.08 pos1(2)-.03 .04 .03],...
   'TooltipString','Breite des Balkens (Standardeinheit [cm])',...
   'String','20','HorizontalAlignment','left');


% Steuerelemente zur Eingabe der Teilungen initialisieren
dl_text_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos1(1) pos1(2)-.07 .08 .03],...
   'String','Lngsteilung:','HorizontalAlignment','left');

dl_val_handle=uicontrol('Style','edit', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos1(1)+.08 pos1(2)-.07 .04 .03],...
   'TooltipString','Anzahl der Unterteilungen in x-Richtung',...
   'String','10','HorizontalAlignment','left');

db_text_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos1(1) pos1(2)-.1 .08 .03],...
   'String','Breitenteilung:','HorizontalAlignment','left');

db_val_handle=uicontrol('Style','edit', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos1(1)+.08 pos1(2)-.1 .04 .03],...
   'TooltipString','Anzahl der Unterteilungen in y-Richtung',...
   'String','5','HorizontalAlignment','left');


pos2=[.3 .2];

% Listenelement zur Anzeige der Einspannungen initialisieren
es_text_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos2(1) pos2(2) .08 .03],...
   'String','Einspannungen:','HorizontalAlignment','left');

es_list_handle=uicontrol('Style','listbox', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos2(1) pos2(2)-.1 .2 .09],...
   'HorizontalAlignment','left');


% Command-Button 'Einspannung lschen'
ed_command_handle=uicontrol('Style','pushbutton', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos2(1) pos2(2)-.15 .2 .03],...
   'String','Einspannung lschen','FontWeight','bold','HorizontalAlignment','center',...
   'TooltipString','Markierte Einspannung(en) lschen','Enable','off',...
   'Callback','[u,v,eitem]=fefdel(es_list_handle,ed_command_handle,u,v,eitem,1)');


% Listenelement zur Anzeige der Krfte initialisieren
fc_text_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos2(1)+.22 pos2(2) .08 .03],...
   'String','Krfte:','HorizontalAlignment','left');

fc_list_handle=uicontrol('Style','listbox', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos2(1)+.22 pos2(2)-.1 .2 .09],...
   'HorizontalAlignment','left');

% Command-Button 'Kraft lschen'
fd_command_handle=uicontrol('Style','pushbutton', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos2(1)+.22 pos2(2)-.15 .2 .03],...
   'String','Kraft lschen','FontWeight','bold','HorizontalAlignment','center',...
   'TooltipString','Markierte Kraft/Krfte lschen','Enable','off',...
   'Callback','[Fu,Fv,fitem]=fefdel(fc_list_handle,fd_command_handle,Fu,Fv,fitem,2)');


pos3=[.78 .2];

% Steuerelemente zur Eingabe der Materialkonstanten initialisieren
nu_text_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos3(1) pos3(2) .12 .03],...
   'String','Querkontraktionszahl:','HorizontalAlignment','left');

nu_val_handle=uicontrol('Style','edit', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos3(1)+.12 pos3(2) .04 .03],...
   'TooltipString','Querkontraktionszahl',...
   'String','0','HorizontalAlignment','left');

em_text_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos3(1) pos3(2)-.03 .12 .03],...
   'String','E-Modul:','HorizontalAlignment','left');

em_val_handle=uicontrol('Style','edit', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos3(1)+.12 pos3(2)-.03 .04 .03],...
   'TooltipString','E-Modul (Standardeinheit=[N/cm^2])',...
   'String','2000','HorizontalAlignment','left');


% Command-Button 'Neuzeichnen'
uicontrol('Style','pushbutton', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos1(1) pos1(2)-.15 .12 .03],...
   'String','Neuzeichnen','FontWeight','bold','HorizontalAlignment','center','TooltipString','Balken neuzeichnen',...
   'Callback','[L,B,dL,dB,AnzE,AnzK,Knoten,Elemente,patch_handle,k_handle,k_pos,u,v,Fu,Fv]=felb(lg_val_handle, br_val_handle,axes_1,figure_1,patch_handle,k_handle,dl_val_handle,db_val_handle,cm_handle)');



% Context-Menu definieren
cm_handle = uicontextmenu;

% Context-Menu Eintrge definieren
cm_item1 = uimenu(cm_handle, 'Label', 'Einspannung: dx=0  / dy<>0', 'Callback', '[u,v,eitem]=fecmcb(es_list_handle,ed_command_handle,node,u,v,eitem,1)');
cm_item2 = uimenu(cm_handle, 'Label', 'Einspannung: dx<>0 / dy=0', 'Callback', '[u,v,eitem]=fecmcb(es_list_handle,ed_command_handle,node,u,v,eitem,2)');
cm_item3 = uimenu(cm_handle, 'Label', 'Einspannung: dx=0  / dy=0', 'Callback', '[u,v,eitem]=fecmcb(es_list_handle,ed_command_handle,node,u,v,eitem,3)');
           uimenu(cm_handle, 'Label', '=========================');
cm_item4 = uimenu(cm_handle, 'Label', 'Kraft in x-Richtung', 'Callback', '[Fu,Fv,fitem]=fecmcb(fc_list_handle,fd_command_handle,node,Fu,Fv,fitem,4)');
cm_item5 = uimenu(cm_handle, 'Label', 'Kraft in y-Richtung', 'Callback', '[Fu,Fv,fitem]=fecmcb(fc_list_handle,fd_command_handle,node,Fu,Fv,fitem,5)');


% Command-Button 'Berechnung starten'
ok_com_handle=uicontrol('Style','pushbutton', 'Parent',figure_1, ...
   'Units','normalized','Position',[.78 .02 .19 .05],'TooltipString','FE-Berechnung des Balkens starten',...
   'String','Berechnung starten...','FontWeight','bold','FontSize',12,'HorizontalAlignment','center',...
   'Callback','[nue,E_modul]=feres(figure_1,nu_val_handle,em_val_handle,fc_list_handle,es_list_handle)');


% Programmausfhrung anhalten, bis 'Fertig' gedrckt wird
waitfor(figure_1);


%error('ende')

% Dicke des Balkens [cm]
H=10;

%Flche des Balkens 
A=L*B; 



% Festlegung der Elemente und deren Knoten
[Knoten,Elemente]= mesh(L,B,dL,dB);


% Anzahl der Elemente
[AnzE,q]=size(Elemente);

% Anzahl der Knoten
AnzK=length(Knoten);

for k=1:AnzE
  for l=1:3
    xv(l,k)=Knoten(Elemente(k,l),1);
    yv(l,k)=Knoten(Elemente(k,l),2);
  end
  xv(4,k)=Knoten(Elemente(k,1),1);
  yv(4,k)=Knoten(Elemente(k,1),2);  
  cv(:,k)=[1;1;1;1];
end


% Umordnungsmatrix
% Hilfsmatrix um die die Steifigkeitsmatrix im globalen Koordinatensystem zu bestimmen
Um=zeros(AnzE,AnzK);

for zeile=1:AnzE
  for spalte=1:3
    Um(zeile,Elemente(zeile,spalte))=spalte;
  end
end
  B=cell(3,6);
% Aufstellen der K-Matrix fr jedes Element
for k=1:AnzE
  b(1)=Knoten(Elemente(k,2),2)-Knoten(Elemente(k,3),2);
  b(2)=Knoten(Elemente(k,3),2)-Knoten(Elemente(k,1),2);
  b(3)=Knoten(Elemente(k,1),2)-Knoten(Elemente(k,2),2);
   
  c(1)=-Knoten(Elemente(k,2),1)+Knoten(Elemente(k,3),1);
  c(2)=-Knoten(Elemente(k,3),1)+Knoten(Elemente(k,1),1);
  c(3)=-Knoten(Elemente(k,1),1)+Knoten(Elemente(k,2),1);
  
  [K{1,1,k},K{1,2,k},K{1,3,k},K{2,1,k},K{2,2,k},K{2,3,k},K{3,1,k},K{3,2,k},K{3,3,k}]=kmatrix(b,c,nue,E_modul,H,AnzE,A);
   
  % B- Matrix zur Berechnung der Spannungen 
  B{k}=[b(1),0,b(2),0,b(3),0;0,c(1),0,c(2),0,c(3);c(1),b(1),c(2),b(2),c(3),b(3)]; 
  
  end
  
% Aufstellen der globalen Steifigkeitsmatrix
for zeile=1:AnzK
   for spalte=1:AnzK
      Ksum=zeros(2);
    for element=1:AnzE
       if (Um(element,zeile)==0)|(Um(element,spalte)==0)
       else
          Ksum=Ksum+K{Um(element,zeile) ,Um(element,spalte) ,element};          
       end
    end
    
    Kl(zeile*2-1, spalte*2-1)=Ksum(1, 1);
    Kl(zeile*2-1, spalte*2)=Ksum(1, 2);
    Kl(zeile*2, spalte*2-1)=Ksum(2, 1);
    Kl(zeile*2, spalte*2)=Ksum(2, 2);
    
    Kunt{zeile,spalte}=Ksum;
  end
end

% Bestimmung der Randbedingungen (Einspannungen)
%u=ones(AnzK,1);
%v=ones(AnzK,1);
%u(1)=0;
%u(11)=0;
%v(1)=0;
%v(11)=0;


% Festlegung der ueren Lasten
%Fu=zeros(AnzK,1);
%Fv=zeros(AnzK,1);

%Fv(57)=100;

% Aufstellen des Gleichungssystems SxV=F
V=[];
F=[];
for n=1:AnzK
   V=[V,u(n),v(n)];
   F=[F,Fu(n),Fv(n)];
 end
b=0;

% Eliminieren der berflssigen Gleichungen
for n=1:2*AnzK
   if V(n)==0
      Kl(n-b,:)=[];
      Kl(:,n-b)=[];
      F(:,n-b)=[];
      b=b+1;
   end 
end

% Auflsen des Gleichungssystems
V=Kl\F';

% Ergnzen der Einspannungen in Lsungsvektor
Vs=[];
count=0;
for n=1:AnzK 
  if u(n)==0 
    Vs(n,1)=0; 
  else    
    count=count+1;
    Vs(n,1)=V(count); 
  end 
  
  if v(n)==0  
     Vs(n,2)=0;
  else    
    count=count+1;
    Vs(n,2)=V(count);
  end  
end
 
TauMin=zeros(3); 
TauMax=zeros(3); 
 
% Berechnen der Verzerrungen und Spannungen im Element 
for k=1:AnzE 
  U_Vekt=[]; 
  for l=1:3
    uv(l,k)=Vs(Elemente(k,l),1);
    vv(l,k)=Vs(Elemente(k,l),2); 
    U_Vekt=[U_Vekt;uv(l,k);vv(l,k)];
  end
   
  % Verzerrungen 
  eps{k}=1/2*A/AnzE*B{k}*U_Vekt; 
   
  % Spannungen 
  Tau{k}=E_modul*[1-nue,nue,0;nue,1-nue,0;0,0,(1-2*nue)/2]*eps{k}; 
   
  for l=1:3 
    if Tau{k}(l)<TauMin(l) 
      TauMin(l)=Tau{k}(l); 
    end 
    if Tau{k}(l)>TauMax(l) 
      TauMax(l)=Tau{k}(l); 
    end 
    TauRange(l)=TauMax(l)-TauMin(l); 
  end 
end 
 
 
% Bestimmen der verschobenen Koordinaten 
Knoten_v=Knoten-Vs;
 
% Berechnen der Patch-Koordinaten
for k=1:AnzE
  for l=1:3
    xv(l,k)=Knoten_v(Elemente(k,l),1);
    yv(l,k)=Knoten_v(Elemente(k,l),2);
    
    % Berechnen der Spannungs-Farbskalen fr SigmaX, SigmaY, SigmaXY
    %Ecolor{k}(l)=round((Tau{k}(l)-TauMin(l))/TauRange(l)*64);
  end
  xv(4,k)=Knoten_v(Elemente(k,1),1);
  yv(4,k)=Knoten_v(Elemente(k,1),2);  
  % cv(:,k)=[Ecolor{k}(1);Ecolor{k}(1);Ecolor{k}(1);Ecolor{k}(1)];  
  %cv(:,k)=[Tau{k}(1);Tau{k}(1);Tau{k}(1);Tau{k}(1)];  
  cv(:,k)=[Tau{k}(1)];  
    
end

% Berechnen der maximalen Verschiebungen
[vmaxx,vmaxxi]=max(Vs(:,1));
[vminx,vminxi]=min(Vs(:,1));

[vmaxy,vmaxyi]=max(Vs(:,2));
[vminy,vminyi]=min(Vs(:,2));

if abs(vmaxx)<abs(vminx)
   vmaxx=vminx;
   vmaxxi=vminxi;
end
if abs(vmaxy)<abs(vminy)
   vmaxy=vminy;
   vmaxyi=vminyi;
end
   

% ERGEBNIS PLOTROUTINE
   
% Figure initialisieren 
Scrz=get(0,'ScreenSize')   
figure_1 = figure('Position',[Scrz(1) Scrz(2) Scrz(3) Scrz(4)]);

% Axen initialisieren
axes_1=axes('Position',[.1 .3 .7 .6],'Parent',figure_1);
axis equal   

% Fenstertitel
uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[.4 .95 .2 .04],...
   'String','Matlab FE-Berechnung','FontSize',14);

uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[.4 .91 .2 .03],...
   'String','> Berechnungsergebnis <','FontSize',12);



% Patch zeichnen
patch_handle=patch(xv,yv,cv,'Parent',axes_1,'EraseMode','normal');



% Slider zur Verformungsverstrkung initialisieren   
slider_handle= uicontrol('Style','slider', 'Parent',figure_1, ...
   'Min',1,'Max',100,'Value',1,'SliderStep',[.1 .2], ...
   'Units','normalized','Position',[.1 .2 .2 .03],'Callback',...
   '[xv,yv,Knoten_v]=fecbamp(patch_handle,slider_handle,slider_val_handle,rectx_handle,recty_handle,AnzE,Knoten,Elemente,Vs,cv,vmaxxi,vmaxyi)'); 

pos = get(slider_handle,'Position');

slider_text_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos(1) pos(2)-.04 pos(3)-.07 .03],...
   'String','Amplification:','HorizontalAlignment','left');

slider_val_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos(1)+pos(3)-.07 pos(2)-.04 .07 .03],...
   'HorizontalAlignment','left','String','1'); 


% Informationsfelder fr maximale Verschiebungen initialisieren
md1_text_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos(1) pos(2)-.08 pos(3)-.02 .03],...
   'String','Node-dx max [mm]:','HorizontalAlignment','left');

md2_text_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos(1) pos(2)-.12 pos(3)-.02 .03],...
   'String','Node-dy max [mm]:','HorizontalAlignment','left');


md1_val_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos(1)+pos(3)-.02 pos(2)-.08 .09 .03],...
   'String',vmaxx*10,'HorizontalAlignment','left');

md2_val_handle=uicontrol('Style','text', 'Parent',figure_1, ...
   'Units','normalized','Position',[pos(1)+pos(3)-.02 pos(2)-.12 .09 .03],...
   'String',vmaxy*10,'HorizontalAlignment','left');



% Toggle-Buttons zur Ansicht der maximal verschobenen Knoten definieren
mdt1_val_handle=uicontrol('Style','toggle', 'Parent',figure_1, ...
   'Min',0,'Max',1,'Value',0,'Units','normalized',...
   'Position',[pos(1)+pos(3)+.1 pos(2)-.08 .15 .03],...
   'Callback','[rectx_handle,recty_handle]=fecbndisp(mdt1_val_handle,mdt2_val_handle,rectx_handle,recty_handle,axes_1,Knoten_v,vmaxxi,vmaxyi)',...
   'String',strcat('on node: ',num2str(vmaxxi)),'HorizontalAlignment','left');

mdt2_val_handle=uicontrol('Style','toggle', 'Parent',figure_1, ...
   'Min',0,'Max',1,'Value',0,'Units','normalized',...
   'Position',[pos(1)+pos(3)+.1 pos(2)-.12 .15 .03],...
   'Callback','[rectx_handle,recty_handle]=fecbndisp(mdt1_val_handle,mdt2_val_handle,rectx_handle,recty_handle,axes_1,Knoten_v,vmaxxi,vmaxyi)',...
   'String',strcat('on node: ',num2str(vmaxyi)),'HorizontalAlignment','left');


% Radios zur Spannungswahl definieren
radio1_handle= uicontrol('Style','radio', 'Parent',figure_1, ...
   'String','SigmaX','Units','normalized','Position',[.5 .2 .12 .03],'Min',0,'Max',1,'Value',1,...
   'Callback','cv=fecbsig1(patch_handle,radio1_handle,radio2_handle,radio3_handle,AnzE,xv,yv,Tau)'); 

radio2_handle= uicontrol('Style','radio', 'Parent',figure_1, ...
   'String','SigmaY','Units','normalized','Position',[.65 .2 .12 .03],'Min',0,'Max',1,'Value',0,...
   'Callback','cv=fecbsig2(patch_handle,radio1_handle,radio2_handle,radio3_handle,AnzE,xv,yv,Tau)');

radio3_handle= uicontrol('Style','radio', 'Parent',figure_1, ...
   'String','SigmaXY','Units','normalized','Position',[.8 .2 .12 .03],'Min',0,'Max',1,'Value',0,...
   'Callback','cv=fecbsig3(patch_handle,radio1_handle,radio2_handle,radio3_handle,AnzE,xv,yv,Tau)');


% Marker zur Markierung der maximalen Knotenverschiebungen zeichnen
rectx_handle=rectangle('Position',[Knoten_v(vmaxxi,1)-1,Knoten_v(vmaxxi,2)-1,2,2],...
     'Parent',axes_1,'FaceColor','b','EraseMode','normal','Visible','off');
  
recty_handle=rectangle('Position',[Knoten_v(vmaxyi,1)-1,Knoten_v(vmaxyi,2)-1,2,2],...
     'Parent',axes_1,'FaceColor','r','EraseMode','normal','Visible','off');


% Colorbar zeichnen
colorbar; 








