function [L,B,dL,dB,AnzE,AnzK,Knoten,Elemente,patch_handle,k_handle,k_pos,u,v,Fu,Fv]=felb(lg_val_handle, br_val_handle,axes_1,figure_1,patch_handle,k_handle,dl_val_handle,db_val_handle,cm_handle);

er=0;

L=str2num(get(lg_val_handle,'String'));

if L<=0 | isempty(L)
   er=1;
   msgbox('Die eingegebene Balkenlnge ist ungltig!','Fehlerhafte Eingabe','error');
end

B=str2num(get(br_val_handle,'String'));

if B<=0 | isempty(B)
   er=1;
   msgbox('Die eingegebene Balkenbreite ist ungltig!','Fehlerhafte Eingabe','error');
end

dL=str2num(get(dl_val_handle,'String'));

if dL<=0 | isempty(dL)
   er=1;
   msgbox('Die eingegebene Lngenteilung ist ungltig!','Fehlerhafte Eingabe','error');
end

dB=str2num(get(db_val_handle,'String'));

if dB<=0 | isempty(dB)
   er=1;
   msgbox('Die eingegebene Breitenteilung ist ungltig!','Fehlerhafte Eingabe','error');
end


if er==0
  % Festlegung der Elemente und deren Knoten
  [Knoten,Elemente]= mesh(L,B,dL,dB);


  % Anzahl der Elemente
  [AnzE,q]=size(Elemente);

  % Anzahl der Knoten
  AnzK=length(Knoten);
  
  % Verschiebungen initialisieren
  u=ones(AnzK,1);
  v=ones(AnzK,1);
  
  % Krfte initialisieren
  Fu=zeros(AnzK,1);
  Fv=zeros(AnzK,1);
  
  for k=1:AnzE
    for l=1:3
      xv(l,k)=Knoten(Elemente(k,l),1);
      yv(l,k)=Knoten(Elemente(k,l),2);
    end
    xv(4,k)=Knoten(Elemente(k,1),1);
    yv(4,k)=Knoten(Elemente(k,1),2);  
    cv(:,k)=[1;1;1;1];
  end

  % Patch zeichnen
  if patch_handle > 0
     set (patch_handle,'XData',xv,'YData',yv,'CData',cv);
     delete(k_handle);
  else  
     patch_handle=patch(xv,yv,cv,'Parent',axes_1,'EraseMode','normal','FaceColor','none');
  end
    
  % Knotennumerierung darstellen
  k_pos=[];
  for k=1:AnzK
    k_handle(k)=text(Knoten(k,1),Knoten(k,2)-1,num2str(k),'Parent',axes_1,...
      'FontWeight','bold','Color','r','ButtonDownFcn','[node]=fenodsel(k_handle,axes_1,figure_1,k_pos)');
   
    set(k_handle(k),'Units','pixels');
    k_pos(k,:)=get(k_handle(k),'Position');
  end
  set(k_handle, 'UIContextMenu', cm_handle);
  
end

