MODULE matlab_interface

! *****************************************************************************
! interface for fliplr
!  defined for integer, single, double
!  flips contents of 2-d array left-right
  INTERFACE fliplr
     FUNCTION fliplr_i(a)
       USE types
       INTEGER,  DIMENSION(:,:), INTENT(IN), TARGET  :: a
       INTEGER,  DIMENSION(:,:),             POINTER :: fliplr_i
     END FUNCTION fliplr_i

     FUNCTION fliplr_s(a)
       USE types
       REAL(SP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
       REAL(SP), DIMENSION(:,:),             POINTER :: fliplr_s
     END FUNCTION fliplr_s

     FUNCTION fliplr_d(a)
       USE types
       REAL(DP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
       REAL(DP), DIMENSION(:,:),             POINTER :: fliplr_d
     END FUNCTION fliplr_d
  END INTERFACE

! *****************************************************************************
! interface for flipud
!  defined for integer, single, double
!  flips contents of 2-d array up-down
  INTERFACE flipud
     FUNCTION flipud_i(a)
       USE types
       INTEGER,  DIMENSION(:,:), INTENT(IN), TARGET  :: a
       INTEGER,  DIMENSION(:,:),             POINTER :: flipud_i
     END FUNCTION flipud_i

     FUNCTION flipud_s(a)
       USE types
       REAL(SP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
       REAL(SP), DIMENSION(:,:),             POINTER :: flipud_s
     END FUNCTION flipud_s

     FUNCTION flipud_d(a)
       USE types
       REAL(DP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
       REAL(DP), DIMENSION(:,:),             POINTER :: flipud_d
     END FUNCTION flipud_d
  END INTERFACE

! *****************************************************************************
! interface for swap
!  defined for integer, single, double
!  swaps contents of a and b
  INTERFACE swap
     SUBROUTINE swap_d(a,b,err)
       USE types
       REAL(DP), DIMENSION(:,:), INTENT(INOUT)       :: a,b
       INTEGER,                  INTENT(OUT)         :: err
     END SUBROUTINE swap_d
     SUBROUTINE swap_d1(a,b,err)
       USE types
       REAL(DP), DIMENSION(:),   INTENT(INOUT)       :: a,b
       INTEGER,                  INTENT(OUT)         :: err
     END SUBROUTINE swap_d1
  END INTERFACE


! *****************************************************************************
! Additional routines written by CHRISTIAN EHERER
! *****************************************************************************
! interface for diag
!  defined for integer, single, double 
!  one or two arguments, and types of result and argument
!
!  X = diag(v,k) when v is a vector of n components, returns a square 
!  matrix X of order n+abs(k), with the elements of v on the kth diagonal.
!  k = 0 represents the main diagonal, k > 0 above the main diagonal, 
!  and k < 0 below the main diagonal.
!
!  X = diag(v) puts v on the main diagonal, same as above with k = 0.
!
!  v = diag(X,k) for matrix X, returns a vector v formed from the 
!  elements of the kth diagonal of X. 
!
!  v = diag(X) returns the main diagonal of X, same as above WITH k = 0. 
!
! before calling the diag routine, the user has to do a size(diag(mat,k),1) or
! a shape(diag(vec,k)) to determine the dimensions of the result, so he 
! can allocate the matrix/vector of the right dimension or size


  INTERFACE diag

     ! two input arguments, one a vector, type real(dp)
     FUNCTION diag_2_vek_d(v,k) RESULT(res)
       USE types
       REAL(DP), DIMENSION(:),   INTENT(IN)          :: v
       INTEGER,                  INTENT(IN)          :: k
       REAL(DP), ALLOCATABLE,    DIMENSION(:,:)      :: res
     END FUNCTION diag_2_vek_d

     ! one input argument, a vector, type real(dp)
     FUNCTION diag_1_vek_d(v) RESULT(res)
       USE types
       REAL(DP), DIMENSION(:),   INTENT(IN)          :: v
       REAL(DP), ALLOCATABLE,    DIMENSION(:,:)      :: res
     END FUNCTION diag_1_vek_d
  
     ! two input arguments, one a matrix, type real(dp)
     ! if you use a k-value, so that the corresponding diagonal
     ! lies outside the specified matrix, a vector of length zero
     ! is returned
     FUNCTION diag_2_mat_d(mat,k) RESULT(res)
       USE types
       REAL(DP), DIMENSION(:,:), INTENT(IN)          :: mat
       INTEGER,                  INTENT(IN)          :: k
       REAL(DP), ALLOCATABLE,    DIMENSION(:)        :: res
     END FUNCTION diag_2_mat_d    

                  
     ! one input arguments, a matrix, type real(dp)
     ! if you use a k-value, so that the corresponding diagonal
     ! lies outside the specified matrix, a vector of length zero
     ! is returned
     FUNCTION diag_1_mat_d(mat) RESULT(res)
       USE types
       REAL(DP), DIMENSION(:,:), INTENT(IN)          :: mat
       REAL(DP), ALLOCATABLE,    DIMENSION(:)        :: res
     END FUNCTION diag_1_mat_d    
  END INTERFACE

  

END MODULE matlab_interface
  
