! matlab_routines

! *****************************************************************************
! function fliplr defined in matlab_interface
!  defined for integer, single, double
!  flips contents of 2-d array left-right
  FUNCTION fliplr_i(a)
    USE types
    INTEGER,  DIMENSION(:,:), INTENT(IN), TARGET  :: a
    INTEGER,  DIMENSION(:,:),             POINTER :: fliplr_i
    INTEGER,  DIMENSION(2)                        :: lb, ub
    lb = LBOUND(a)
    ub = UBOUND(a)
    fliplr_i => a(:,ub(2):lb(2):-1)
  END FUNCTION fliplr_i

  FUNCTION fliplr_s(a)
    USE types
    REAL(SP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
    REAL(SP), DIMENSION(:,:),             POINTER :: fliplr_s
    INTEGER,  DIMENSION(2)                        :: lb, ub
    lb = LBOUND(a)
    ub = UBOUND(a)
    fliplr_s => a(:,ub(2):lb(2):-1)
  END FUNCTION fliplr_s

  FUNCTION fliplr_d(a)
    USE types
    REAL(DP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
    REAL(DP), DIMENSION(:,:),             POINTER :: fliplr_d
    INTEGER,  DIMENSION(2)                        :: lb, ub
    lb = LBOUND(a)
    ub = UBOUND(a)
    fliplr_d => a(:,ub(2):lb(2):-1)
  END FUNCTION fliplr_d

! *****************************************************************************
! function flipud defined in matlab_interface
!  defined for integer, single, double
!  flips contents of 2-d array up-down
  FUNCTION flipud_i(a)
    USE types
    INTEGER,  DIMENSION(:,:), INTENT(IN), TARGET  :: a
    INTEGER,  DIMENSION(:,:),             POINTER :: flipud_i
    INTEGER,  DIMENSION(2)                        :: lb, ub
    lb = LBOUND(a)
    ub = UBOUND(a)
    flipud_i => a(ub(1):lb(1):-1,:)
  END FUNCTION flipud_i

  FUNCTION flipud_s(a)
    USE types
    REAL(SP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
    REAL(SP), DIMENSION(:,:),             POINTER :: flipud_s
    INTEGER,  DIMENSION(2)                        :: lb, ub
    lb = LBOUND(a)
    ub = UBOUND(a)
    flipud_s => a(ub(1):lb(1):-1,:)
  END FUNCTION flipud_s

  FUNCTION flipud_d(a)
    USE types
    REAL(DP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
    REAL(DP), DIMENSION(:,:),             POINTER :: flipud_d
    INTEGER,  DIMENSION(2)                        :: lb, ub
    lb = LBOUND(a)
    ub = UBOUND(a)
    flipud_d => a(ub(1):lb(1):-1,:)
  END FUNCTION flipud_d

  SUBROUTINE swap_d(a,b,err)
    USE types
    REAL(DP), DIMENSION(:,:), INTENT(INOUT)       :: a,b
    INTEGER,                  INTENT(OUT)         :: err
    REAL(DP), DIMENSION(:,:), ALLOCATABLE         :: atmp,btmp
    INTEGER,  DIMENSION(2)                        :: sa,sb
    err = 0
    sa = SHAPE(a)
    sb = SHAPE(b)
    IF (sa(1) == sb(1) .AND. sa(2) == sb(2)) THEN 
       ALLOCATE( atmp(sa(1),sa(2)) )
       ALLOCATE( btmp(sb(1),sb(2)) )
       atmp = a
       btmp = b
       a = btmp
       b = atmp
       DEALLOCATE( atmp )
       DEALLOCATE( btmp )
    ELSE
       err = 1
    END IF 
  END SUBROUTINE swap_d

  SUBROUTINE swap_d1(a,b,err)
    USE types
    REAL(DP), DIMENSION(:),   INTENT(INOUT)       :: a,b
    INTEGER,                  INTENT(OUT)         :: err
    REAL(DP), DIMENSION(:),   ALLOCATABLE         :: atmp,btmp
    INTEGER                                       :: sa,sb
    err = 0
    sa = SIZE(a)
    sb = SIZE(b)
    IF (sa == sb) THEN 
       ALLOCATE( atmp(sa) )
       ALLOCATE( btmp(sb) )
       atmp = a
       btmp = b
       a = btmp
       b = atmp
       DEALLOCATE( atmp )
       DEALLOCATE( btmp )
    ELSE
       err = 1
    END IF 
  END SUBROUTINE swap_d1


! *****************************************************************************
! CHRISTIAN EHERER
! *****************************************************************************
! function diag defined in matlab_interface
!
!  X = diag(v,k) when v is a vector of n components, returns a square 
!  matrix X of order n+abs(k), with the elements of v on the kth diagonal.
!  k = 0 represents the main diagonal, k > 0 above the main diagonal, 
!  and k < 0 below the main diagonal.
!
!  X = diag(v) puts v on the main diagonal, same as above with k = 0.
!
!  v = diag(X,k) for matrix X, returns a vector v formed from the 
!  elements of the kth diagonal of X. 
!
!  v = diag(X) returns the main diagonal of X, same as above WITH k = 0. 


  FUNCTION diag_2_vek_d(v,k) RESULT(res) 
    USE types
    IMPLICIT NONE
    REAL(DP), DIMENSION(:),   INTENT(IN)          :: v
    INTEGER,                  INTENT(IN)          :: k
    REAL(DP), ALLOCATABLE,    DIMENSION(:,:)      :: res
    ! local variables
    INTEGER                                       :: i
    INTEGER,  DIMENSION(2)                        :: ord
  
    ! initialize the resultmatrix and determine order
    ALLOCATE(res(SIZE(v)+ABS(k),SIZE(v)+ABS(k)))
    res = 0
    ord = SHAPE(res)
   
    DO i=1,ord(1)
       IF (i<=SIZE(v)) THEN
          res(i,i+ABS(k)) = v(i)     
       END IF
    END DO

    IF (k<0) THEN
       res = TRANSPOSE(res)
    END IF
    
  END FUNCTION diag_2_vek_d


  FUNCTION diag_1_vek_d(v) RESULT(res)
    USE types
    IMPLICIT NONE
    REAL(DP), DIMENSION(:),   INTENT(IN)          :: v
    REAL(DP), ALLOCATABLE,    DIMENSION(:,:)      :: res
    ! local variables
    INTEGER                                       :: i
    INTEGER,  DIMENSION(2)                        :: ord
  
    ! initialize the resultmatrix and determine order
    ALLOCATE(res(SIZE(v),SIZE(v)))
    res = 0
    ord = SHAPE(res)
   
    DO i=1,ord(1)
       res(i,i) = v(i)     
    END DO
   
  END FUNCTION diag_1_vek_d
 

  FUNCTION diag_2_mat_d(mat,k) RESULT(res)
    USE types
    IMPLICIT NONE
    REAL(DP), DIMENSION(:,:), INTENT(IN)          :: mat
    INTEGER,                  INTENT(IN)          :: k
    REAL(DP), ALLOCATABLE,    DIMENSION(:)        :: res
    ! local variables
    INTEGER                                       :: lv,length,i

    lv = MAX(MIN(MIN(MIN(SIZE(mat,1),SIZE(mat,2)),SIZE(mat,2)-k),&
            SIZE(mat,1)+k),0)
    ALLOCATE(res(lv))

    ! do the work only if there is an result of nonzero size
    IF (SIZE(res)>0) THEN
       ! initialize the resultvector and determine its size    
       res = 0
       length = SIZE(res)
       DO i=1,length
          IF (k>=0) THEN
             res(i) = mat(i,i+k)
          ELSE
             res(i) = mat(i+ABS(k),i)
          END IF
       END DO
    END IF

  END FUNCTION diag_2_mat_d


  FUNCTION diag_1_mat_d(mat) RESULT(res)
    USE types
    IMPLICIT NONE
    REAL(DP), DIMENSION(:,:), INTENT(IN)          :: mat
    REAL(DP), ALLOCATABLE,    DIMENSION(:)        :: res
    ! local variables
    INTEGER                                       :: lv,length,i

    lv = MAX(MIN(MIN(MIN(SIZE(mat,1),SIZE(mat,2)),SIZE(mat,2)),&
            SIZE(mat,1)),0)
    ALLOCATE(res(lv))

    ! do the work only if there is an result of nonzero size
    IF (SIZE(res)>0) THEN
       ! initialize the resultvector and determine its size    
       res = 0
       length = SIZE(res)
       DO i=1,length
          res(i) = mat(i,i)
       END DO
    END IF

  END FUNCTION diag_1_mat_d
 
!END matlab_routines

