PROGRAM mattest
! tests some matlab interface routines (fliplr, flipud)
! shows use of pointers
! shows use of where-statement

! *****************************************************************************
! interfaces
  USE types              ! types and parameters
  USE matlab_interface   ! interface to matlab routines

! *****************************************************************************
! local definitions
  IMPLICIT NONE
  REAL(DP), DIMENSION(12)                :: c
  REAL(DP), DIMENSION(4,3), TARGET       :: d  ! possible target for pointer
  REAL(DP), DIMENSION(4,3), TARGET       :: f
  REAL(DP), DIMENSION(:,:), ALLOCATABLE  :: e  ! must be allocated
  REAL(DP), DIMENSION(:,:), POINTER      :: pd ! pointer
  REAL(DP), DIMENSION(:,:), POINTER      :: pf1,pf2
  REAL(DP), DIMENSION(:),   POINTER      :: pd1 
  REAL(DP), DIMENSION(:),   POINTER      :: pf3,pf4
  REAL(DP), DIMENSION(3)                 :: vec
  REAL(DP), DIMENSION(:,:), ALLOCATABLE  :: mat,mat1
  INTEGER                                :: i,k,le
  INTEGER,  DIMENSION(4,3), TARGET       :: id 
  INTEGER,  DIMENSION(:,:), POINTER      :: pid
  INTEGER,  DIMENSION(2)                 :: sd,spd,l
  INTEGER                                :: err
  REAL(DP), DIMENSION(:),   ALLOCATABLE  :: v
  REAL(DP), DIMENSION(9)                 :: c1
  REAL(DP), DIMENSION(3,3)               :: m  
! *****************************************************************************
! initial settings
  c = DBLE( (/(i,i=1,12)/) )
  d = RESHAPE(c,(/4,3/))
  sd = SHAPE(d)
  f = d
! *****************************************************************************
! print original array
  PRINT *, ' ' 
  PRINT *, 'original d' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', d(i,:)
  END DO

! *****************************************************************************
! define pointers
  pd => d(2:4,2:3)
  spd = SHAPE(pd)

! *****************************************************************************
! allocate array e
  ALLOCATE( e(spd(1),spd(2)) )  

! *****************************************************************************
! flip left right
  e  = fliplr(flipud(pd))
  pd = fliplr(pd)
  
! *****************************************************************************
! print modified d
  PRINT *, ' ' 
  PRINT *, 'modified d' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', d(i,:)
  END DO
  
! *****************************************************************************
! print new e after flipud
  PRINT *, ' ' 
  PRINT *, 'new e after flipud' 
  DO i=1,spd(1)
     PRINT '(8(f6.2,1x))', e(i,:)
  END DO

! *****************************************************************************
! deallocate e
  DEALLOCATE(e)

! *****************************************************************************
! use of where
  WHERE (d > 6)
     id = 1
  ELSEWHERE
     id = 0
  END WHERE 
! print d after where
  PRINT *, ' ' 
  PRINT *, 'array id' 
  DO i=1,sd(1)
     PRINT '(8(i6,1x))', id(i,:)
  END DO

  pid => id
  pid = flipud(pid)
! print d after flipud
  PRINT *, ' ' 
  PRINT *, 'array id after flipud' 
  DO i=1,sd(1)
     PRINT '(8(i6,1x))', id(i,:)
  END DO

! *****************************************************************************
! Test of swap routine
! print f before swap
  PRINT *, ' ' 
  PRINT *, 'array f' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', f(i,:)
  END DO

  pf1 => f(1:4,1:2)
  pf2 => f(1:4,2:3)
!  CALL swap(pf1,pf2,err)

!  PRINT *, 'err = ',err
! print f after swap
  PRINT *, ' ' 
  PRINT *, 'array f after swap' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', f(i,:)
  END DO

!  IF ( ASSOCIATED(pd) )  NULLIFY(pd) 
!  IF ( ASSOCIATED(pf1) ) NULLIFY(pf1) 

  NULLIFY(pd) 
  NULLIFY(pf1) 


!  pd1 => d(1:4,1)
!  pf3 => f(1:4,2)
  pd1 => d(1,1:3)
  pf3 => f(2,1:3)
  PRINT *, pd1
  PRINT *, pf3
 
  CALL swap(pd1,pf3,err)

  PRINT *, pd1
  PRINT *, pf3

  PRINT *, 'err = ',err
! print f after swap
  PRINT *, ' ' 
  PRINT *, 'array f after swap with d' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', f(i,:)
  END DO

! *****************************************************************************
! Test of diag routine by Christian G. Eherer
! *****************************************************************************

  !----------------------------------------------------------------------------
  ! input vector, result matrix
  !----------------------------------------------------------------------------
  
  vec = DBLE( (/(i,i=1,3)/) )
  k = 0 !--------------------------------------------
  ! determine size of result
  l = SHAPE(diag(vec,k))
  ALLOCATE( mat(l(1),l(2)) )
  mat = diag(vec,k);
  
  PRINT *, ' ' 
  PRINT *, 'array mat generated by diag(v,0)' 
  sd = SHAPE(mat)
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', mat(i,:)
  END DO
    
  !-------------------------------------------------
  ! one input argument
  mat = diag(vec);
  
  PRINT *, ' ' 
  PRINT *, 'array mat generated by diag(v)' 
  sd = SHAPE(mat)
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', mat(i,:)
  END DO

  k = 1 !-------------------------------------------
  l = SHAPE(diag(vec,k))
  ALLOCATE( mat1(l(1),l(2)) )
  mat1 = diag(vec,k);

  PRINT *, ' ' 
  PRINT *, 'array mat generated by diag(v,1)' 
  sd = SHAPE(mat1)
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', mat1(i,:)
  END DO
    
  DEALLOCATE(mat1)
  k = -1 !------------------------------------------
  l = SHAPE(diag(vec,k))
  ALLOCATE( mat1(l(1),l(2)) )
  mat1 = diag(vec,k);

  PRINT *, ' ' 
  PRINT *, 'array mat generated by diag(v,-1)' 
  sd = SHAPE(mat1)
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', mat1(i,:)
  END DO
  
  DEALLOCATE(mat)
  DEALLOCATE(mat1)
 
  !----------------------------------------------------------------------------
  ! matrix as an argument (4x3), vector as result
  !----------------------------------------------------------------------------

  c1 = DBLE( (/(i,i=1,9)/) )
  m = RESHAPE(c,(/3,3/))
  sd = SHAPE(m)
  PRINT *, ' ' 
  PRINT *, 'array m ' 
  sd = SHAPE(m)
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', m(i,:)
  END DO

  ! before you call diag, you have to determine the proper length
  ! of the restultvector
  k=0 !---------------------------------------------------------
  l = SIZE(diag(m,k),1)
  ALLOCATE(v(l(1)))
  v = diag(m,k)
  PRINT *, ' ' 
  PRINT *, 'vector produced by diag(m,0) ' 
  DO i=1,SIZE(v)
     PRINT '(8(f6.2,1x))', v(i)
  END DO
  DEALLOCATE(v)

  !----------------------------------------------------------
  ! one input argument
  l = SIZE(diag(m),1)
  ALLOCATE(v(l(1)))
  v = diag(m)
  PRINT *, ' ' 
  PRINT *, 'vector produced by diag(m) ' 
  DO i=1,SIZE(v)
     PRINT '(8(f6.2,1x))', v(i)
  END DO
  DEALLOCATE(v)

 
  k=1 !-------------------------------------------------------
  ALLOCATE(v(SIZE(diag(m,k),1)))
  v = diag(m,k)
  PRINT *, ' ' 
  PRINT *, 'vector produced by diag(m,1) ' 
  DO i=1,SIZE(v)
     PRINT '(8(f6.2,1x))', v(i)
  END DO
  DEALLOCATE(v)

  k=2 !--------------------------------------------------------
  ALLOCATE(v(SIZE(diag(m,k),1)))
  v = diag(m,k)
  PRINT *, ' ' 
  PRINT *, 'vector produced by diag(m,2) ' 
  DO i=1,SIZE(v)
     PRINT '(8(f6.2,1x))', v(i)
  END DO
  DEALLOCATE(v)
 
  k=3 !--------------------------------------------------------
  ALLOCATE(v(SIZE(diag(m,k),1)))
  v = diag(m,k)
  PRINT *, ' ' 
  PRINT *, 'vector produced by diag(m,3) ' 
  DO i=1,SIZE(v)
     PRINT '(8(f6.2,1x))', v(i)
  END DO
  DEALLOCATE(v) 

  k=-1 !-------------------------------------------------------
  ALLOCATE(v(SIZE(diag(m,k),1)))
  v = diag(m,k)
  PRINT *, ' ' 
  PRINT *, 'vector produced by diag(m,-1) ' 
  DO i=1,SIZE(v)
     PRINT '(8(f6.2,1x))', v(i)
  END DO
  DEALLOCATE(v) 
  
  k=-2 !--------------------------------------------------------
  ALLOCATE(v(SIZE(diag(m,k),1)))
  v = diag(m,k)
  PRINT *, ' ' 
  PRINT *, 'vector produced by diag(m,-2) ' 
  DO i=1,SIZE(v)
     PRINT '(8(f6.2,1x))', v(i)
  END DO
  DEALLOCATE(v)
 
  k=-3 !-------------------------------------------------------
  ALLOCATE(v(SIZE(diag(m,k),1)))
  v = diag(m,k)
  PRINT *, ' ' 
  PRINT *, 'vector produced by diag(m,-3) ' 
  DO i=1,SIZE(v)
     PRINT '(8(f6.2,1x))', v(i)
  END DO
  DEALLOCATE(v)
 
END PROGRAM mattest






