!==============================================================================
! This programm tests the types poly and ratpoly and their operations
!==============================================================================
PROGRAM polytest

  USE polynom
  USE rationalpolynom

  IMPLICIT NONE

!------------------------------------------------------------------------------
! variables
!------------------------------------------------------------------------------

  TYPE(poly)                               :: p1
  TYPE(poly)                               :: p2
  TYPE(poly)                               :: ps
  TYPE(poly)                               :: res
  TYPE(poly)                               :: a
  TYPE(poly)                               :: b
  TYPE(poly)                               :: c

  TYPE(ratpoly)                            :: rp1
  TYPE(ratpoly)                            :: rp2
  TYPE(ratpoly)                            :: rre
  TYPE(ratpoly)                            :: po1
  TYPE(ratpoly)                            :: pol2
  TYPE(ratpoly)                            :: po2

  INTEGER                                  :: i


!------------------------------------------------------------------------------
! sum and difference of polynomials with integer coefficients
!------------------------------------------------------------------------------

  ps = poly( (/7/) )
  p1 = poly( (/ (i, i=1,6) /) )
  p2 = poly( (/ (i+3, i=1,4) /) )

  PRINT *, 'Sum of polynomials'
  PRINT *, ' ' 

  res = p1 + ps
  PRINT *, 'p1  = ', p1%c 
  PRINT *, 'ps  = ', ps%c 
  PRINT *, 'res = ', res%c
  PRINT *, ' ' 

  res = ps + p1
  PRINT *, 'ps  = ', ps%c 
  PRINT *, 'p1  = ', p1%c 
  PRINT *, 'res = ', res%c 
  PRINT *, ' ' 

  res = p1 + p2
  PRINT *, 'p1  = ', p1%c 
  PRINT *, 'p2  = ', p2%c 
  PRINT *, 'res = ', res%c 
  PRINT *, ' ' 

  res = p2 + p1
  PRINT *, 'p2  = ', p2%c 
  PRINT *, 'p1  = ', p1%c 
  PRINT *, 'res = ', res%c 
  PRINT *, ' ' 

  PRINT *, 'Difference of polynomials'
  PRINT *, ' ' 

  res = p1 - ps
  PRINT *, 'p1  = ', p1%c 
  PRINT *, 'ps  = ', ps%c 
  PRINT *, 'res = ', res%c
  PRINT *, ' ' 
 
  res = p1 - p2
  PRINT *, 'p1  = ', p1%c 
  PRINT *, 'p2  = ', p2%c 
  PRINT *, 'res = ', res%c 
  PRINT *, ' ' 


!------------------------------------------------------------------------------
! sum and difference of polynomials with rational coefficients
!------------------------------------------------------------------------------

  PRINT *, 'Sum of rational polynomials'
  PRINT *, ' ' 

  rp1 = pol((/ 1 /),&
            (/ 2 /))
 
  rp2 = pol((/ 2 /),&
            (/ 8 /)) 

  rre = rp1 + rp2
  PRINT *, 'rp1: ',rp1%n,'/',rp1%d
  PRINT *, 'rp2: ',rp2%n,'/',rp2%d
  PRINT *, 'rre: ',rre%n,'/',rre%d
  PRINT *, ' ' 

  po1 = pol((/ 1, 2, -4 /),&
            (/ 2, 3, 5 /))

  po2 = pol((/ 2, 7 /),&
            (/ 5, 8 /))

  rre = po1 + po2
  PRINT *, 'po1: ',po1%n(1),'/',po1%d(1),' ',po1%n(2),'/',po1%d(2) &
       ,' ',po1%n(3),'/',po1%d(3)
  PRINT *, 'po2: ',po2%n(1),'/',po2%d(1),' ',po2%n(2),'/',po2%d(2) 
  PRINT *, 'rre: ',rre%n(1),'/',rre%d(1),' ',rre%n(2),'/',rre%d(2) &
       ,' ',rre%n(3),'/',rre%d(3)
  PRINT *, ' ' 


  PRINT *, 'Difference  of rational polynomials'
  PRINT *, ' ' 

  rre = rp1 - rp2
  PRINT *, 'rp1: ',rp1%n,'/',rp1%d
  PRINT *, 'rp2: ',rp2%n,'/',rp2%d
  PRINT *, 'rre: ',rre%n,'/',rre%d
  PRINT *, ' ' 

  rre = po1 - po2
  PRINT *, 'po1: ',po1%n(1),'/',po1%d(1),' ',po1%n(2),'/',po1%d(2) &
       ,' ',po1%n(3),'/',po1%d(3)
  PRINT *, 'po2: ',po2%n(1),'/',po2%d(1),' ',po2%n(2),'/',po2%d(2) 
  PRINT *, 'rre: ',rre%n(1),'/',rre%d(1),' ',rre%n(2),'/',rre%d(2) &
       ,' ',rre%n(3),'/',rre%d(3)
  PRINT *, ' ' 


!------------------------------------------------------------------------------
! Product of polynomials with integer and rational coefficients
!------------------------------------------------------------------------------

  PRINT *, 'Product of polynomials'
  PRINT *, ' '

  a = poly( (/1, 2, 3/) )
  b = poly( (/-1, 5, -7/) ) 

  c = a * b
  PRINT *, 'a   = ', a%c
  PRINT *, 'b   = ', b%c
  PRINT *, 'a*b = ', c%c

  PRINT *, ' '
  PRINT *, 'Product of rational polynomials'
  PRINT *, ' '   

  po1 = pol((/ 1, 1, 1 /),&
            (/ 1, 1, 1 /))
  
  pol2 = pol((/ 1, 1, 1 /),&
             (/ 1, 1, 1 /))
 
  rre = po1 * pol2
  PRINT *, 'po1: ',po1%n(1),'/',po1%d(1),' ',po1%n(2),'/',po1%d(2) &
       ,' ',po1%n(3),'/',po1%d(3)
  PRINT *, 'pol2: ',pol2%n(1),'/',pol2%d(1),' ',pol2%n(2),'/',pol2%d(2) &
       ,' ',pol2%n(3),'/',pol2%d(3)
  PRINT *, 'rre: ',rre%n(1),'/',rre%d(1),' ',rre%n(2),'/',rre%d(2) &
       ,' ',rre%n(3),'/',rre%d(3),' ',rre%n(4),'/',rre%d(4) &
       ,' ',rre%n(5),'/',rre%d(5)
  PRINT *, ' ' 

  po1 = pol((/ 1, 2, 5 /),&
            (/ 3, 3, 6 /))
  po2 = pol((/ 1, 3 /),& 
            (/ 2, 4 /))
 
  rre = po1 * po2
  PRINT *, 'po1%n: ',po1%n
  PRINT *, 'po1%d: ',po1%d
  PRINT *, 'po2%n: ',po2%n
  PRINT *, 'po2%d: ',po2%d
  PRINT *, 'rre%n: ',rre%n
  PRINT *, 'rre%d: ',rre%d


!------------------------------------------------------------------------------
! Combination of operators
!------------------------------------------------------------------------------

  PRINT *, ' '
  PRINT *, 'Combination: (po1*po2 + po2*pol2)*po1'
  PRINT *, ' ' 

  rre = (po1*po2 + po2*pol2)*po1
  PRINT *, 'rre%n: ',rre%n
  PRINT *, 'rre%d: ',rre%d


!------------------------------------------------------------------------------
! Division of two polynoms with reational coefficients
!------------------------------------------------------------------------------
 
  PRINT *, ' '
  PRINT *, 'Division of rational polynomials (same order)'
  PRINT *, ' '   

  po1 = pol((/ 1, -3, -5 /),&
            (/ 2,  1,  4 /))

  po2 = pol((/ 2, 1, 1 /),&
            (/ 3, 5, 4 /))

  rre = po1/po2
  PRINT *, 'po1%n: ',po1%n
  PRINT *, 'po1%d: ',po1%d
  PRINT *, 'po2%n: ',po2%n
  PRINT *, 'po2%d: ',po2%d
  PRINT *, 'rre%n: ',rre%n
  PRINT *, 'rre%d: ',rre%d

  PRINT *, ' '
  PRINT *, 'Remainder'
  PRINT *, ' '   

  rre = po1 .mod. po2
  PRINT *, 'rre%n: ',rre%n
  PRINT *, 'rre%d: ',rre%d

  PRINT *, ' '
  PRINT *, 'Division of rational polynomials (O(po1)>O(po2))'
  PRINT *, ' '   

  po1 = pol((/ 1, -3, -5 /),&
            (/ 2,  1,  4 /))

  po2 = pol((/ 2, 1/),&
            (/ 3, 5/))

  rre = po1/po2
  PRINT *, 'po1%n: ',po1%n
  PRINT *, 'po1%d: ',po1%d
  PRINT *, 'po2%n: ',po2%n
  PRINT *, 'po2%d: ',po2%d
  PRINT *, 'rre%n: ',rre%n
  PRINT *, 'rre%d: ',rre%d

  PRINT *, ' '
  PRINT *, 'Remainder'
  PRINT *, ' '   

  rre = po1 .mod. po2
  PRINT *, 'rre%n: ',rre%n
  PRINT *, 'rre%d: ',rre%d

  PRINT *, ' '
  PRINT *, 'Division of rational polynomials (O(po1)<O(po2))'
  PRINT *, ' '   

  po1 = pol((/ 1, -3/),&
            (/ 2,  1/))

  po2 = pol((/ 2, 1, 1 /),&
            (/ 3, 5, 4 /))

  rre = po1/po2
  PRINT *, 'po1%n: ',po1%n
  PRINT *, 'po1%d: ',po1%d
  PRINT *, 'po2%n: ',po2%n
  PRINT *, 'po2%d: ',po2%d
  PRINT *, 'rre%n: ',rre%n
  PRINT *, 'rre%d: ',rre%d

  PRINT *, ' '
  PRINT *, 'Remainder'
  PRINT *, ' '   

  rre = po1 .mod. po2
  PRINT *, 'rre%n: ',rre%n
  PRINT *, 'rre%d: ',rre%d
END PROGRAM polytest
