MODULE matlab_interface

! *****************************************************************************
! interface for fliplr
!  defined for integer, single, double
!  flips contents of 2-d array left-right
  INTERFACE fliplr
     FUNCTION fliplr_i(a)
       USE types
       INTEGER,  DIMENSION(:,:), INTENT(IN), TARGET  :: a
       INTEGER,  DIMENSION(:,:),             POINTER :: fliplr_i
     END FUNCTION fliplr_i

     FUNCTION fliplr_s(a)
       USE types
       REAL(SP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
       REAL(SP), DIMENSION(:,:),             POINTER :: fliplr_s
     END FUNCTION fliplr_s

     FUNCTION fliplr_d(a)
       USE types
       REAL(DP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
       REAL(DP), DIMENSION(:,:),             POINTER :: fliplr_d
     END FUNCTION fliplr_d
  END INTERFACE

! *****************************************************************************
! interface for flipud
!  defined for integer, single, double
!  flips contents of 2-d array up-down
  INTERFACE flipud
     FUNCTION flipud_i(a)
       USE types
       INTEGER,  DIMENSION(:,:), INTENT(IN), TARGET  :: a
       INTEGER,  DIMENSION(:,:),             POINTER :: flipud_i
     END FUNCTION flipud_i

     FUNCTION flipud_s(a)
       USE types
       REAL(SP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
       REAL(SP), DIMENSION(:,:),             POINTER :: flipud_s
     END FUNCTION flipud_s

     FUNCTION flipud_d(a)
       USE types
       REAL(DP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
       REAL(DP), DIMENSION(:,:),             POINTER :: flipud_d
     END FUNCTION flipud_d
  END INTERFACE

! *****************************************************************************
! interface for swap
!  defined for integer, single, double
!  swaps contents of a and b
  INTERFACE swap
     SUBROUTINE swap_d(a,b,err)
       USE types
       REAL(DP), DIMENSION(:,:), INTENT(INOUT)       :: a,b
       INTEGER,                  INTENT(OUT)         :: err
     END SUBROUTINE swap_d
     SUBROUTINE swap_d1(a,b,err)
       USE types
       REAL(DP), DIMENSION(:),   INTENT(INOUT)       :: a,b
       INTEGER,                  INTENT(OUT)         :: err
     END SUBROUTINE swap_d1
  END INTERFACE

! *****************************************************************************
! interface for swap
!  defined for integer, single, double
!  swaps contents of a and b
  INTERFACE repmat
     FUNCTION repmat_d0(a,m,n)
       USE types
       REAL(DP),                 INTENT(IN)          :: a
       INTEGER,                  INTENT(IN)          :: m,n
       REAL(DP), DIMENSION(m,n)                      :: repmat_d0
     END FUNCTION repmat_d0
     FUNCTION repmat_d1(a,m,n)
       USE types
       REAL(DP), DIMENSION(:),   INTENT(IN)          :: a
       INTEGER,                  INTENT(IN)          :: m,n
       REAL(DP), DIMENSION(SIZE(a)*m,n)              :: repmat_d1
     END FUNCTION repmat_d1
     FUNCTION repmat_d2(a,m,n)
       USE types
       REAL(DP), DIMENSION(:,:), INTENT(IN)          :: a
       INTEGER,                  INTENT(IN)          :: m,n
       REAL(DP), DIMENSION(SIZE(a,1)*m,SIZE(a,2)*n)  :: repmat_d2
     END FUNCTION repmat_d2
  END INTERFACE

  INTERFACE eye
     FUNCTION eye_d(n)
       USE types
       INTEGER,  INTENT(IN)                   :: n
       REAL(DP), DIMENSION(n,n)               :: eye_d
     END FUNCTION eye_d
  END INTERFACE

! INTERFACE
!    SUBROUTINE seye(n,res)
!      USE types
!      INTEGER,  INTENT(IN)                   :: n
!      REAL(DP), ALLOCATABLE, DIMENSION(:,:), INTENT(OUT)  :: res
!    END SUBROUTINE seye
! END INTERFACE

END MODULE matlab_interface
  

