! matlab_routines

! *****************************************************************************
! function fliplr defined in matlab_interface
!  defined for integer, single, double
!  flips contents of 2-d array left-right
  FUNCTION fliplr_i(a)
    USE types
    INTEGER,  DIMENSION(:,:), INTENT(IN), TARGET  :: a
    INTEGER,  DIMENSION(:,:),             POINTER :: fliplr_i
    INTEGER,  DIMENSION(2)                        :: lb, ub
    lb = LBOUND(a)
    ub = UBOUND(a)
    fliplr_i => a(:,ub(2):lb(2):-1)
  END FUNCTION fliplr_i

  FUNCTION fliplr_s(a)
    USE types
    REAL(SP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
    REAL(SP), DIMENSION(:,:),             POINTER :: fliplr_s
    INTEGER,  DIMENSION(2)                        :: lb, ub
    lb = LBOUND(a)
    ub = UBOUND(a)
    fliplr_s => a(:,ub(2):lb(2):-1)
  END FUNCTION fliplr_s

  FUNCTION fliplr_d(a)
    USE types
    REAL(DP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
    REAL(DP), DIMENSION(:,:),             POINTER :: fliplr_d
    INTEGER,  DIMENSION(2)                        :: lb, ub
    lb = LBOUND(a)
    ub = UBOUND(a)
    fliplr_d => a(:,ub(2):lb(2):-1)
  END FUNCTION fliplr_d

! *****************************************************************************
! function flipud defined in matlab_interface
!  defined for integer, single, double
!  flips contents of 2-d array up-down
  FUNCTION flipud_i(a)
    USE types
    INTEGER,  DIMENSION(:,:), INTENT(IN), TARGET  :: a
    INTEGER,  DIMENSION(:,:),             POINTER :: flipud_i
    INTEGER,  DIMENSION(2)                        :: lb, ub
    lb = LBOUND(a)
    ub = UBOUND(a)
    flipud_i => a(ub(1):lb(1):-1,:)
  END FUNCTION flipud_i

  FUNCTION flipud_s(a)
    USE types
    REAL(SP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
    REAL(SP), DIMENSION(:,:),             POINTER :: flipud_s
    INTEGER,  DIMENSION(2)                        :: lb, ub
    lb = LBOUND(a)
    ub = UBOUND(a)
    flipud_s => a(ub(1):lb(1):-1,:)
  END FUNCTION flipud_s

  FUNCTION flipud_d(a)
    USE types
    REAL(DP), DIMENSION(:,:), INTENT(IN), TARGET  :: a
    REAL(DP), DIMENSION(:,:),             POINTER :: flipud_d
    INTEGER,  DIMENSION(2)                        :: lb, ub
    lb = LBOUND(a)
    ub = UBOUND(a)
    flipud_d => a(ub(1):lb(1):-1,:)
  END FUNCTION flipud_d

  SUBROUTINE swap_d(a,b,err)
    USE types
    REAL(DP), DIMENSION(:,:), INTENT(INOUT)       :: a,b
    INTEGER,                  INTENT(OUT)         :: err
    REAL(DP), DIMENSION(:,:), ALLOCATABLE         :: atmp,btmp
    INTEGER,  DIMENSION(2)                        :: sa,sb
    err = 0
    sa = SHAPE(a)
    sb = SHAPE(b)
    IF (sa(1) == sb(1) .AND. sa(2) == sb(2)) THEN 
       ALLOCATE( atmp(sa(1),sa(2)) )
       ALLOCATE( btmp(sb(1),sb(2)) )
       atmp = a
       btmp = b
       a = btmp
       b = atmp
       DEALLOCATE( atmp )
       DEALLOCATE( btmp )
    ELSE
       err = 1
    END IF 
  END SUBROUTINE swap_d

  SUBROUTINE swap_d1(a,b,err)
    USE types
    REAL(DP), DIMENSION(:),   INTENT(INOUT)       :: a,b
    INTEGER,                  INTENT(OUT)         :: err
    REAL(DP), DIMENSION(:),   ALLOCATABLE         :: atmp,btmp
    INTEGER                                       :: sa,sb
    err = 0
    sa = SIZE(a)
    sb = SIZE(b)
    IF (sa == sb) THEN 
       ALLOCATE( atmp(sa) )
       ALLOCATE( btmp(sb) )
       atmp = a
       btmp = b
       a = btmp
       b = atmp
       DEALLOCATE( atmp )
       DEALLOCATE( btmp )
    ELSE
       err = 1
    END IF 
  END SUBROUTINE swap_d1

  FUNCTION eye_d(n)
    USE types
    IMPLICIT NONE
    INTEGER,  INTENT(IN)                   :: n
    REAL(DP), DIMENSION(n,n)               :: eye_d
    INTEGER                                :: i
    eye_d = 0.0_dp
    DO i = 1,n
       eye_d(i,i) = float(n)
    END DO
  END FUNCTION eye_d


  FUNCTION repmat_d0(a,m,n)
    USE types
    REAL(DP),                 INTENT(IN)          :: a
    INTEGER,                  INTENT(IN)          :: m,n
    REAL(DP), DIMENSION(m,n)                      :: repmat_d0

    INTEGER i,j
    repmat_d0 = a

  END FUNCTION repmat_d0
  
  FUNCTION repmat_d1(a,m,n)
    USE types
    REAL(DP), DIMENSION(:),   INTENT(IN)          :: a
    INTEGER,                  INTENT(IN)          :: m,n
    REAL(DP), DIMENSION(SIZE(a)*m,n)              :: repmat_d1

    INTEGER                                       :: i,j
    INTEGER                                       :: s
    s = SIZE(a)
    DO i = 1,m
       DO j = 1,n
          repmat_d1((i-1)*s+1:i*s,j) = a
       END DO
    END DO

  END FUNCTION repmat_d1
  
  FUNCTION repmat_d2(a,m,n)
    USE types
    REAL(DP), DIMENSION(:,:), INTENT(IN)          :: a
    INTEGER,                  INTENT(IN)          :: m,n
    REAL(DP), DIMENSION(SIZE(a,1)*m,SIZE(a,2)*n)  :: repmat_d2

    INTEGER                                       :: i,j
    INTEGER,  DIMENSION(2)                        :: s
    s = SHAPE(a)
    DO i = 1,m
       DO j = 1,n
          repmat_d2((i-1)*s(1)+1:i*s(1),(j-1)*s(2)+1:j*s(2)) = a
       END DO
    END DO

  END FUNCTION repmat_d2


!  SUBROUTINE seye_d(n,res)
!    USE types
!    IMPLICIT NONE
!    INTEGER,  INTENT(IN)                   :: n
!    REAL(DP), DIMENSION(:,:)               :: res
!    REAL(DP), DIMENSION(:,:), ALLOCATABLE  :: res
!    INTEGER                                :: i
!    ALLOCATE (res(n,n) )
!    res = 0.0_dp
!    DO i = 1,n
!       res(i,i) = float(n)
!    END DO
!  END SUBROUTINE seye_d

!END matlab_routines
     
!  SUBROUTINE seye(n,res)
!    USE types
!    IMPLICIT NONE
!    INTEGER,  INTENT(IN)                   :: n
!    REAL(DP), ALLOCATABLE, DIMENSION(:,:), INTENT(OUT)  :: res
!    INTEGER                                :: i
!    IF (ALLOCATED(res)) DEALLOCATE(res)
!    ALLOCATE (res(n,n) )
!    res = 0.0_dp
!    DO i = 1,n
!       res(i,i) = float(n)
!    END DO
!  END SUBROUTINE seye







