PROGRAM mattest
! tests some matlab interface routines (fliplr, flipud)
! shows use of pointers
! shows use of where-statement

! *****************************************************************************
! interfaces
  USE types              ! types and parameters
  USE matlab_interface   ! interface to matlab routines

  IMPLICIT NONE

! *****************************************************************************
! local definitions
  REAL(DP), DIMENSION(12)                :: c
  REAL(DP), DIMENSION(4,3), TARGET       :: d  ! possible target for pointer
  REAL(DP), DIMENSION(4,3), TARGET       :: f
  REAL(DP), DIMENSION(:,:), ALLOCATABLE  :: e  ! must be allocated
  REAL(DP), DIMENSION(:,:), POINTER      :: pd ! pointer
  REAL(DP), DIMENSION(:,:), POINTER      :: pf1,pf2
  REAL(DP), DIMENSION(:),   POINTER      :: pd1 
  REAL(DP), DIMENSION(:),   POINTER      :: pf3,pf4
  INTEGER                                :: i,j
  INTEGER,  DIMENSION(4,3), TARGET       :: id 
  INTEGER,  DIMENSION(:,:), POINTER      :: pid
  INTEGER,  DIMENSION(2)                 :: sd,spd
  INTEGER                                :: err
  INTEGER                                :: n
  REAL(DP), DIMENSION(:,:), ALLOCATABLE  :: ey  
  REAL(DP), DIMENSION(:,:), POINTER      :: pey1, pey2

  REAL(DP)                               :: rep0
  REAL(DP), DIMENSION(:)  , ALLOCATABLE  :: rep1
  REAL(DP), DIMENSION(:,:), ALLOCATABLE  :: rep2, repres
  INTEGER                                :: mr,nr

! *****************************************************************************
! initial settings
  c = DBLE( (/(i,i=1,12)/) )
  d = RESHAPE(c,(/4,3/))
  sd = SHAPE(d)
  f = d
! *****************************************************************************
! print original array
  PRINT *, ' ' 
  PRINT *, 'original d' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', d(i,:)
  END DO

! *****************************************************************************
! define pointers
  pd => d(2:4,2:3)
  spd = SHAPE(pd)

! *****************************************************************************
! allocate array e
  ALLOCATE( e(spd(1),spd(2)) )  

! *****************************************************************************
! flip left right
  e  = flipud(fliplr(fliplr(flipud(pd))))
  pd = fliplr(pd)

! *****************************************************************************
! print modified d
  PRINT *, ' ' 
  PRINT *, 'modified d' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', d(i,:)
  END DO

! *****************************************************************************
! print new e after flipud
  PRINT *, ' ' 
  PRINT *, 'new e after fliplr(flipud(pd))' 
  DO i=1,spd(1)
     PRINT '(8(f6.2,1x))', e(i,:)
  END DO

! *****************************************************************************
! deallocate e
  DEALLOCATE(e)

! *****************************************************************************
! use of where
  WHERE (d > 6)
     id = 1
  ELSEWHERE
     id = 0
  END WHERE 
! print d after where
  PRINT *, ' ' 
  PRINT *, 'array id' 
  DO i=1,sd(1)
     PRINT '(8(i6,1x))', id(i,:)
  END DO

  pid => id
  pid = flipud(pid)
! print d after flipud
  PRINT *, ' ' 
  PRINT *, 'array id after flipud' 
  DO i=1,sd(1)
     PRINT '(8(i6,1x))', id(i,:)
  END DO

! Test of swap routine
! print f before swap
  PRINT *, ' ' 
  PRINT *, 'array f' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', f(i,:)
  END DO

  pf1 => f(1:4,1:2)
  pf2 => f(1:4,2:3)
!  CALL swap(pf1,pf2,err)

!  PRINT *, 'err = ',err
! print f after swap
  PRINT *, ' ' 
  PRINT *, 'array f after swap' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', f(i,:)
  END DO

!  IF ( ASSOCIATED(pd) )  NULLIFY(pd) 
!  IF ( ASSOCIATED(pf1) ) NULLIFY(pf1) 

  NULLIFY(pd) 
  NULLIFY(pf1) 


!  pd1 => d(1:4,1)
!  pf3 => f(1:4,2)
  pd1 => d(1,1:3)
  pf3 => f(2,1:3)
  PRINT *, pd1
  PRINT *, pf3
 
  CALL swap(pd1,pf3,err)

  PRINT *, pd1
  PRINT *, pf3

  PRINT *, 'err = ',err
! print f after swap
  PRINT *, ' ' 
  PRINT *, 'array f after swap with d' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', f(i,:)
  END DO
!
  n = 3
  ALLOCATE ( ey(n,n) )
  PRINT *, eye(n)
  ey = eye(n)
  PRINT *, ' ' 
  PRINT *, 'eye, n = ',n 
  DO i=1,n
     PRINT '(8(f6.2,1x))', ey(i,:)
  END DO
  DEALLOCATE (ey)

  n = 4
  ALLOCATE ( ey(n,n) )
  ey = flipud(fliplr(flipud(eye(n))))
  PRINT *, ' ' 
  PRINT *, 'ey, n = ',n 
  DO i=1,n
     PRINT '(8(f6.2,1x))', ey(i,:)
  END DO
  DEALLOCATE (ey)

! n = 5
!  ALLOCATE ( ey(n,n) )
! CALL seye(n,ey)
! PRINT *, ' ' 
! PRINT *, 'eye, n = ',n 
! DO i=1,n
!    PRINT '(8(f6.2,1x))', ey(i,:)
! END DO
!  DEALLOCATE (ey)

! Test of repmat

  mr = 1
  nr = 1
  rep0 = 5
  ALLOCATE( repres(mr,nr) )
  repres = repmat(rep0,mr,nr)
  PRINT *, ' ' 
  PRINT *, 'mr, nr = ',mr,nr 
  DO i=1,mr
     PRINT '(10(f6.2,1x))', repres(i,:)
  END DO
  ! rep0 = repres(1,1)
  DEALLOCATE ( repres )

  mr = 2
  nr = 3
  ALLOCATE ( rep1(3) )
  rep1 = DBLE( (/(i,i=1,3)/) )
  ALLOCATE( repres(SIZE(rep1)*mr,nr) )
  repres = repmat(rep1,mr,nr)
  PRINT *, ' ' 
  PRINT *, 'mr, nr = ',mr,nr 
  DO i=1,SIZE(rep1)*mr
     PRINT '(10(f6.2,1x))', repres(i,:)
  END DO
!  rep1 = repres(1:3,1)
!  rep1 = repres(1,1:3)
  DEALLOCATE ( repres )
  DEALLOCATE ( rep1 )

  mr = 2
  nr = 3
  ALLOCATE ( rep2(3,2) )
  rep2 = DBLE( RESHAPE ( (/((10*i+j,i=1,3),j=1,2)/), (/3,2/) ) )
  ALLOCATE( repres(SIZE(rep2,1)*mr,SIZE(rep2,2)*nr) )
  repres = repmat(rep2,mr,nr)
  PRINT *, ' ' 
  PRINT *, 'mr, nr = ',mr,nr 
  DO i=1,SIZE(rep2,1)*mr
     PRINT '(10(f6.2,1x))', repres(i,:)
  END DO
  DEALLOCATE ( repres )
  DEALLOCATE ( rep2 )

  mr = 2
  nr = 2
  ALLOCATE ( rep2(1,1) )
  rep2 = 3
  ALLOCATE( repres(SIZE(rep2,1)*mr,SIZE(rep2,2)*nr) )
  repres = repmat(rep2,mr,nr)
  PRINT *, ' ' 
  PRINT *, 'mr, nr = ',mr,nr 
  DO i=1,SIZE(rep2,1)*mr
     PRINT '(10(f6.2,1x))', repres(i,:)
  END DO
  DEALLOCATE ( repres )
  DEALLOCATE ( rep2 )

!  DO n = 2,400,10
!     PRINT *, n
!     pey2 => eye(n)
!  END DO
!  PAUSE
!  DO n = 400,2,-10
!     PRINT *, n
!     pey2 => eye(n)
!  END DO
!  PAUSE

!
!  FUNCTION eye(n)
!    USE types             
!    IMPLICIT NONE
!    INTEGER,  INTENT(IN)                   :: n
!    REAL(DP), DIMENSION(:,:), POINTER      :: eye
!    REAL(DP), DIMENSION(:,:), TARGET, ALLOCATABLE  :: tmp
!
!    ALLOCATE ( tmp(n,n) )
!    tmp = 0.0_dp
!    DO i = 1,n
!       eye(i,i) = 1.0_dp
!       tmp(i,i) = float(n)
!    END DO
!    eye => tmp
!  END FUNCTION eye
!
!  FUNCTION eyes(n)
!    USE types             
!    IMPLICIT NONE
!    INTEGER,  INTENT(IN)                   :: n
!    REAL(DP), DIMENSION(:,:), POINTER      :: eyes
!
!    ALLOCATE ( eyes(n,n) )
!    eyes = 0.0_dp
!    DO i = 1,n
!       eye(i,i) = 1.0_dp
!       eyes(i,i) = float(n)
!    END DO
!  END FUNCTION eyes

END PROGRAM mattest





