PROGRAM test
! tests some matlab interface routines (fliplr, flipud)
! shows use of pointers
! shows use of where-statement

! *****************************************************************************
! interfaces
  USE types              ! types and parameters
  USE matlab_interface   ! interface to matlab routines

! *****************************************************************************
! local definitions
  IMPLICIT NONE
  REAL(DP), DIMENSION(12)                :: c
  REAL(DP), DIMENSION(4,3), TARGET       :: d  ! possible target for pointer
  REAL(DP), DIMENSION(4,3), TARGET       :: f
  REAL(DP), DIMENSION(:,:), ALLOCATABLE  :: e  ! must be allocated
  REAL(DP), DIMENSION(:,:), POINTER      :: pd ! pointer
  REAL(DP), DIMENSION(:,:), POINTER      :: pf1,pf2
  REAL(DP), DIMENSION(:),   POINTER      :: pd1 
  REAL(DP), DIMENSION(:),   POINTER      :: pf3,pf4
  INTEGER                                :: i
  INTEGER,  DIMENSION(4,3), TARGET       :: id 
  INTEGER,  DIMENSION(:,:), POINTER      :: pid
  INTEGER,  DIMENSION(2)                 :: sd,spd
  INTEGER                                :: err
  REAL(DP), DIMENSION(:,:), ALLOCATABLE  :: ey  ! must be allocated

! *****************************************************************************
! initial settings
  c = DBLE( (/(i,i=1,12)/) )
  d = RESHAPE(c,(/4,3/))
  sd = SHAPE(d)
  f = d
! *****************************************************************************
! print original array
  PRINT *, ' ' 
  PRINT *, 'original d' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', d(i,:)
  END DO

! *****************************************************************************
! define pointers
  pd => d(2:4,2:3)
  spd = SHAPE(pd)

! *****************************************************************************
! allocate array e
  ALLOCATE( e(spd(1),spd(2)) )  

! *****************************************************************************
! flip left right
  e  = fliplr(flipud(pd))
  pd = fliplr(pd)

! *****************************************************************************
! print modified d
  PRINT *, ' ' 
  PRINT *, 'modified d' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', d(i,:)
  END DO

! *****************************************************************************
! print new e after flipud
  PRINT *, ' ' 
  PRINT *, 'new e after flipud' 
  DO i=1,spd(1)
     PRINT '(8(f6.2,1x))', e(i,:)
  END DO

! *****************************************************************************
! deallocate e
  DEALLOCATE(e)

! *****************************************************************************
! use of where
  WHERE (d > 6)
     id = 1
  ELSEWHERE
     id = 0
  END WHERE 
! print d after where
  PRINT *, ' ' 
  PRINT *, 'array id' 
  DO i=1,sd(1)
     PRINT '(8(i6,1x))', id(i,:)
  END DO

  pid => id
  pid = flipud(pid)
! print d after flipud
  PRINT *, ' ' 
  PRINT *, 'array id after flipud' 
  DO i=1,sd(1)
     PRINT '(8(i6,1x))', id(i,:)
  END DO

! Test of swap routine
! print f before swap
  PRINT *, ' ' 
  PRINT *, 'array f' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', f(i,:)
  END DO

  pf1 => f(1:4,1:2)
  pf2 => f(1:4,2:3)
!  CALL swap(pf1,pf2,err)

!  PRINT *, 'err = ',err
! print f after swap
  PRINT *, ' ' 
  PRINT *, 'array f after swap' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', f(i,:)
  END DO

!  IF ( ASSOCIATED(pd) )  NULLIFY(pd) 
!  IF ( ASSOCIATED(pf1) ) NULLIFY(pf1) 

  NULLIFY(pd) 
  NULLIFY(pf1) 


!  pd1 => d(1:4,1)
!  pf3 => f(1:4,2)
  pd1 => d(1,1:3)
  pf3 => f(2,1:3)
  PRINT *, pd1
  PRINT *, pf3
 
  CALL swap(pd1,pf3,err)

  PRINT *, pd1
  PRINT *, pf3

  PRINT *, 'err = ',err
! print f after swap
  PRINT *, ' ' 
  PRINT *, 'array f after swap with d' 
  DO i=1,sd(1)
     PRINT '(8(f6.2,1x))', f(i,:)
  END DO

  n = 3
  ALLOCATE ( ey(n) )
  ey = eye(n)
  PRINT *, ' ' 
  PRINT *, 'eye, n = ',n 
  DO i=1,n
     PRINT '(8(f6.2,1x))', ey(i,:)
  END DO
  DEALLOCATE (ey)

CONTAINS
  FUNCTION eye(n)
    IMPLICIT NONE
    INTEGER,  INTENT(IN)                   :: n
    REAL(DP), DIMENSION(:,:), POINTER      :: eye

    ALLOCATE eye(n,n)
    eye = 0.0_dp
    DO i = 1,n
       eye(i,i) = 1.0_dp
    END DO
  END FUNCTION eye
END PROGRAM mattest





