PROGRAM polytest
! Test of polynomial sum
  USE polynom
  USE rationalpolynom

  IMPLICIT NONE

  TYPE(poly)                               :: p1
  TYPE(poly)                               :: p2
  TYPE(poly)                               :: ps
  TYPE(poly)                               :: res

  TYPE(ratpoly), DIMENSION(1)              :: rp1
  TYPE(ratpoly), DIMENSION(1)              :: rp2
  TYPE(ratpoly), DIMENSION(:), ALLOCATABLE :: rre
  TYPE(poly)                               :: a,b
  TYPE(poly)                               :: c
  INTEGER                                  :: i
  TYPE(ratpoly), DIMENSION(3)              :: po1,pol2  
  TYPE(ratpoly), DIMENSION(2)              :: po2


  ps = poly( (/7/) )
  p1 = poly( (/ (i, i=1,6) /) )
  p2 = poly( (/ (i+3, i=1,4) /) )

  PRINT *, 'Sum of polynomials'
  PRINT *, ' ' 

  res = p1 + ps
  PRINT *, 'p1  = ', p1%c 
  PRINT *, 'ps  = ', ps%c 
  PRINT *, 'res = ', res%c
  PRINT *, ' ' 

  res = ps + p1
  PRINT *, 'ps  = ', ps%c 
  PRINT *, 'p1  = ', p1%c 
  PRINT *, 'res = ', res%c 
  PRINT *, ' ' 

  res = p1 + p2
  PRINT *, 'p1  = ', p1%c 
  PRINT *, 'p2  = ', p2%c 
  PRINT *, 'res = ', res%c 
  PRINT *, ' ' 

  res = p2 + p1
  PRINT *, 'p2  = ', p2%c 
  PRINT *, 'p1  = ', p1%c 
  PRINT *, 'res = ', res%c 
  PRINT *, ' ' 

  PRINT *, 'Sum of rational polynomials'
  PRINT *, ' ' 

  rp1%n = 1
  rp1%d = 2
  rp2%n = 2
  rp2%d = 8

  ALLOCATE(rre(addlr(rp1,rp2)))
  rre = rp1 + rp2
  PRINT *, 'rp1: ',rp1%n,'/',rp1%d
  PRINT *, 'rp2: ',rp2%n,'/',rp2%d
  PRINT *, 'rre: ',rre%n,'/',rre%d
  PRINT *, ' ' 
  DEALLOCATE(rre)

  po1(1)%n = 1
  po1(1)%d = 2
  po1(2)%n = 2
  po1(2)%d = 3
  po1(3)%n = -4
  po1(3)%d = 5
  po2(1)%n = 2
  po2(1)%d = 5
  po2(2)%n = 7 
  po2(2)%d = 8

  ALLOCATE(rre(addlr(po1,po2)))
  rre = po1 + po2
  PRINT *, 'po1: ',po1(1)%n,'/',po1(1)%d,' ',po1(2)%n,'/',po1(2)%d &
       ,' ',po1(3)%n,'/',po1(3)%d
  PRINT *, 'po2: ',po2(1)%n,'/',po2(1)%d,' ',po2(2)%n,'/',po2(2)%d 
  PRINT *, 'rre: ',rre(1)%n,'/',rre(1)%d,' ',rre(2)%n,'/',rre(2)%d &
       ,' ',rre(3)%n,'/',rre(3)%d
  PRINT *, ' ' 
  DEALLOCATE(rre)

  !----------------------------------------
  ! test of *-operator by Christian Eherer
  !----------------------------------------

  PRINT *, 'Product of polynomials'
  PRINT *, ' '

  a = poly( (/1, 2, 3/) )
  b = poly( (/-1, 5, -7/) ) 

  c = a * b
  PRINT *, 'a   = ', a%c
  PRINT *, 'b   = ', b%c
  PRINT *, 'a*b = ', c%c

  PRINT *, ' '
  PRINT *, 'Product of rational polynomials'
  PRINT *, ' '   

  po1(1)%n = 1
  po1(1)%d = 1
  po1(2)%n = 1
  po1(2)%d = 1
  po1(3)%n = 1
  po1(3)%d = 1
  pol2(1)%n = 1
  pol2(1)%d = 1
  pol2(2)%n = 1 
  pol2(2)%d = 1
  pol2(3)%n = 1
  pol2(3)%d = 1
 
  ALLOCATE(rre(multrl(po1,pol2)))
  rre = po1 * pol2
  PRINT *, 'po1: ',po1(1)%n,'/',po1(1)%d,' ',po1(2)%n,'/',po1(2)%d &
       ,' ',po1(3)%n,'/',po1(3)%d
  PRINT *, 'pol2: ',pol2(1)%n,'/',pol2(1)%d,' ',pol2(2)%n,'/',pol2(2)%d &
       ,' ',pol2(3)%n,'/',pol2(3)%d
  PRINT *, 'rre: ',rre(1)%n,'/',rre(1)%d,' ',rre(2)%n,'/',rre(2)%d &
       ,' ',rre(3)%n,'/',rre(3)%d,' ',rre(4)%n,'/',rre(4)%d &
       ,' ',rre(5)%n,'/',rre(5)%d
  PRINT *, ' ' 
  DEALLOCATE(rre)

  po1(1)%n = 1
  po1(1)%d = 3
  po1(2)%n = 2
  po1(2)%d = 3 
  po1(3)%n = 5
  po1(3)%d = 6
  po2(1)%n = 1
  po2(1)%d = 2
  po2(2)%n = 3 
  po2(2)%d = 4

  ALLOCATE(rre(multrl(po1,po2)))
  rre = po1 * po2
  PRINT *, 'po1: ',po1(1)%n,'/',po1(1)%d,' ',po1(2)%n,'/',po1(2)%d &
       ,' ',po1(3)%n,'/',po1(3)%d
  PRINT *, 'po2: ',po2(1)%n,'/',po2(1)%d,' ',po2(2)%n,'/',po2(2)%d 
  PRINT *, 'rre: ',rre(1)%n,'/',rre(1)%d,' ',rre(2)%n,'/',rre(2)%d &
       ,' ',rre(3)%n,'/',rre(3)%d,' ',rre(4)%n,'/',rre(4)%d
  PRINT *, ' ' 
  DEALLOCATE(rre)
 
  PRINT *, ' '
  PRINT *, 'Combination: (po1*po2 + po2*pol2)*po1'
  PRINT *, ' ' 

  !ALLOCATE(rre(multrl(po1,po2)))
  !ALLOCATE(rre1(multrl(po2,pol2)))
  !rre = po1*po2 
  !rre1 = po2*pol2
  !ALLOCATE(rre2(addlr(rre,rre1)))
  !rre2 = rre + rre1
  
 ALLOCATE(rre(multrl(po1*po2+po2*pol2,po1)))
 rre = (po1*po2 + po2*pol2)*po1
 PRINT *, 'rre: ',rre(1)%n,'/',rre(1)%d,' ',rre(2)%n,'/',rre(2)%d &
      ,' ',rre(3)%n,'/',rre(3)%d,' ',rre(4)%n,'/',rre(4)%d &
      ,' ',rre(5)%n,'/',rre(5)%d,' ',rre(6)%n,'/',rre(6)%d

END PROGRAM polytest

