! Skeleton module for polynomials
! At the moment only sums 
MODULE polynom
  TYPE poly
     INTEGER :: c
  END TYPE poly
  INTERFACE OPERATOR(+)
     MODULE PROCEDURE addp00, addp01, addp10, addp11
  END INTERFACE
CONTAINS

  FUNCTION addp00(a, b)
    IMPLICIT NONE
    TYPE(poly), INTENT(in)                     :: a, b
    TYPE(poly)                                 :: addp00
    addp00%c = a%c + b%c
  END FUNCTION addp00  

  FUNCTION addp01(a, b)
    IMPLICIT NONE
    TYPE(poly), INTENT(in)                     :: a
    TYPE(poly), INTENT(in), DIMENSION(:)       :: b
    TYPE(poly),             DIMENSION(SIZE(b)) :: addp01
    INTEGER                                    :: sb
    sb = SIZE(b)
    addp01%c = b%c
    addp01(sb)%c = b(sb)%c + a%c
  END FUNCTION addp01

  FUNCTION addp10(a, b)
    IMPLICIT NONE
    TYPE(poly), INTENT(in), DIMENSION(:)       :: a
    TYPE(poly), INTENT(in)                     :: b
    TYPE(poly),             DIMENSION(SIZE(a)) :: addp10
    INTEGER                                    :: sa
    sa = SIZE(a)
    addp10%c = a%c
    addp10(sa)%c = a(sa)%c + b%c
  END FUNCTION addp10

  FUNCTION addp11(a, b)
    IMPLICIT NONE
    TYPE(poly), INTENT(in), DIMENSION(:)       :: a
    TYPE(poly), INTENT(in), DIMENSION(:)       :: b
    TYPE(poly),             DIMENSION(MAX(SIZE(a),SIZE(b))) :: addp11
    INTEGER                                    :: sa
    INTEGER                                    :: sb
    sa = SIZE(a)
    sb = SIZE(b)
    IF (sa == sb) THEN
       addp11(:)%c = a(:)%c + b(:)%c
    ELSE IF (sa < sb) THEN
       addp11(1:sb-sa)%c = b(1:sb-sa)%c
       addp11(sb-sa+1:sb)%c = a(1:sa)%c + b(sb-sa+1:sb)%c
    ELSE IF (sa > sb) THEN
       addp11(1:sa-sb)%c = a(1:sa-sb)%c
       addp11(sa-sb+1:sa)%c = b(1:sb)%c + a(sa-sb+1:sa)%c
    END IF
  END FUNCTION addp11

END MODULE polynom

! Skeleton module for rational polynomials
! At the moment only sums of scalar values
MODULE rationalpolynom
  TYPE ratpoly
     INTEGER :: n
     INTEGER :: d
  END TYPE ratpoly
  INTERFACE OPERATOR(+)
     MODULE PROCEDURE addrp00
  END INTERFACE
CONTAINS

  FUNCTION addrp00(a, b)
    IMPLICIT NONE
    TYPE(ratpoly), INTENT(in)                     :: a, b
    TYPE(ratpoly)                                 :: addrp00
    INTEGER                                       :: dn
    dn = a%d * b%d
    addrp00%d = dn
    addrp00%n = a%n * dn / a%d + b%n * dn / b%d
  END FUNCTION addrp00  

END MODULE rationalpolynom










