MODULE simple_mod

  INTERFACE simple_s
     MODULE PROCEDURE simple_s1, simple_s2
  END INTERFACE

  INTERFACE simple_f
     MODULE PROCEDURE simple_f1, simple_f2
  END INTERFACE

  INTERFACE OPERATOR(.q.)
     MODULE PROCEDURE simple_q1, simple_q2
  END INTERFACE

CONTAINS

  SUBROUTINE simple_s1(x,z)
    USE types
    IMPLICIT NONE
    REAL(dp), DIMENSION(:,:),                 INTENT(in)      :: x
    REAL(dp), DIMENSION(SIZE(x,1),SIZE(x,2)), INTENT(out)     :: z
    z = x**2 + x**2
  END SUBROUTINE simple_s1

  SUBROUTINE simple_s2(x,y,z)
    USE types
    IMPLICIT NONE
    REAL(dp), DIMENSION(:,:),                 INTENT(in)      :: x, y
    REAL(dp), DIMENSION(SIZE(x,1),SIZE(x,2)), INTENT(out)     :: z
    z = x**2 + y**2
  END SUBROUTINE simple_s2

  FUNCTION simple_f1(x) RESULT(z)
    USE types
    IMPLICIT NONE
    REAL(dp), DIMENSION(:,:),                 INTENT(in)      :: x
    REAL(dp), DIMENSION(SIZE(x,1),SIZE(x,2))                  :: z
    z = 2.0_dp * x**2
  END FUNCTION simple_f1

  FUNCTION simple_f2(x,y) RESULT(z)
    USE types
    IMPLICIT NONE
    REAL(dp), DIMENSION(:,:),                 INTENT(in)      :: x, y
    REAL(dp), DIMENSION(SIZE(x,1),SIZE(x,2))                  :: z
    z = x**2 + y**2
  END FUNCTION simple_f2

  FUNCTION simple_q1(x) RESULT(z)
    USE types
    IMPLICIT NONE
    REAL(dp), DIMENSION(:,:),                 INTENT(in)      :: x
    REAL(dp), DIMENSION(SIZE(x,1),SIZE(x,2))                  :: z
    z = 2.0_dp * x**2
  END FUNCTION simple_q1

  FUNCTION simple_q2(x,y) RESULT(z)
    USE types
    IMPLICIT NONE
    REAL(dp), DIMENSION(:,:),                 INTENT(in)      :: x, y
    REAL(dp), DIMENSION(SIZE(x,1),SIZE(x,2))                  :: z
    z = x**2 + y**2
  END FUNCTION simple_q2

END MODULE simple_mod




