SUBROUTINE rk4_step(func,x,y,dx)
! *****************************************************************************
! Runge-Kutta routine for one step from x to x+dx
!  func in    : name of user defined function - func(x,y)
!  x    inout : x-value
!  y    inout : y-values (contains y, y', y'', y''', ...)
!  dx   in    : step in x
! *****************************************************************************
  USE types
! *****************************************************************************
  IMPLICIT NONE
! *****************************************************************************
! Interface for user defined function
  INTERFACE
     FUNCTION func(x,y)
       USE types
       REAL(DP),                     INTENT(in)      :: x
       REAL(DP), DIMENSION(:),       INTENT(in)      :: y
       REAL(DP), DIMENSION(SIZE(y))                  :: func
     END FUNCTION func
  END INTERFACE
! *****************************************************************************
  REAL(DP),                     INTENT(inout)   :: x
  REAL(DP), DIMENSION(:),       INTENT(inout)   :: y
  REAL(DP),                     INTENT(in)      :: dx
  REAL(DP), DIMENSION(SIZE(y))                  :: dydx, yt, dyt, dym
  REAL(DP)                                      :: hh 
  REAL(DP)                                      :: h6
  REAL(DP)                                      :: xh 
! *****************************************************************************
  hh = dx*0.5_dp  
  h6 = dx/6.0_dp
  xh = x + hh

  dydx = func(x,y)
  yt = y + hh*dydx
    
  dyt = func(xh,yt)
  yt = y + hh*dyt
    
  dym = func(xh,yt)
  yt = y + dx*dym
  dym = dyt + dym 

  x = x + dx
  dyt = func(x,yt)
  y = y + h6*(dydx + dyt + dym*2.0_dp)
! *****************************************************************************
  RETURN
END SUBROUTINE rk4_step

SUBROUTINE rk4_tot(func,xvec,yvec)
! *****************************************************************************
! Runge-Kutta routine for vector x
!  func in    : name of user defined function - func(x,y)
!  xvec in    : x-values
!  yvec inout : y-values; y(:,1) must contain start values
! *****************************************************************************
  USE types
  USE rk_interface, ONLY : rk4s
! *****************************************************************************
  IMPLICIT NONE
! Interface for user defined function
  INTERFACE
     FUNCTION func(x,y)
       USE types
       REAL(DP),                     INTENT(in)      :: x
       REAL(DP), DIMENSION(:),       INTENT(in)      :: y
       REAL(DP), DIMENSION(SIZE(y))                  :: func
     END FUNCTION func
  END INTERFACE
! *****************************************************************************
  REAL(DP), DIMENSION(:),       INTENT(in)      :: xvec
  REAL(DP), DIMENSION(:,:),     INTENT(inout)   :: yvec
  REAL(DP)                                      :: x, dx
  REAL(DP), DIMENSION(SIZE(yvec,1))             :: y
  INTEGER                                       :: i
! *****************************************************************************
  x = xvec(1)
  y(:) = yvec(:,1)
  DO i = 2, SIZE(xvec)
     dx = xvec(i) - xvec(i-1)
     CALL rk4s(func,x,y,dx)
     yvec(:,i) = y(:)
  END DO
END SUBROUTINE rk4_tot





