! *****************************************************************************
! Interfaces for for Runge-Kutta
MODULE rk_interface

  INTERFACE rk4s
     SUBROUTINE rk4_step(fun,x,y,h)
       USE types          
       INTERFACE
          FUNCTION fun (x,y)
            USE types
            REAL(DP),                     INTENT(in)      :: x
            REAL(DP), DIMENSION(:),       INTENT(in)      :: y
            REAL(DP), DIMENSION(SIZE(y))                  :: fun
          END FUNCTION fun
       END INTERFACE
       REAL(DP),                     INTENT(inout)   :: x
       REAL(DP), DIMENSION(:),       INTENT(out)     :: y
       REAL(DP),                     INTENT(in)      :: h
!      REAL(DP),                     INTENT(in)      :: fun
     END SUBROUTINE rk4_step
  END INTERFACE

  INTERFACE rk4t
     SUBROUTINE rk4_tot(fun,xvec,yvec)
       USE types          
       INTERFACE
          FUNCTION fun (x,y)
            USE types
            REAL(DP),                     INTENT(in)      :: x
            REAL(DP), DIMENSION(:),       INTENT(in)      :: y
            REAL(DP), DIMENSION(SIZE(y))                  :: fun
          END FUNCTION fun
       END INTERFACE
       REAL(DP), DIMENSION(:),            INTENT(inout)   :: xvec
       REAL(DP), DIMENSION(:,:),          INTENT(inout)   :: yvec
!      REAL(DP),                          INTENT(in)      :: fun
     END SUBROUTINE rk4_tot
  END INTERFACE

END MODULE rk_interface

