FUNCTION vdp(x,y)
! **************************************************************************** 
! Right Hand Side for Van der Pol Equation
!  y'' - mu*(1-y^2)*y' + y = 0
!
! Expressed as a system of first order differential equations
!  vdp(1):  y1' = y2
!  vdp(2):  y2' = mu*(1-y1^2)*y2 - y1
! *****************************************************************************
  USE types
  USE vdp_data ! contains mu
! *****************************************************************************
  IMPLICIT NONE
  REAL(dp),                     INTENT(in)      :: x
  REAL(dp), DIMENSION(:),       INTENT(in)      :: y
  REAL(dp), DIMENSION(SIZE(Y))                  :: vdp
! *****************************************************************************
  vdp(1) = y(2)
  vdp(2) = mu * (1.0_dp - y(1)**2) * y(2) - y(1)
END FUNCTION vdp



