PROGRAM vdpmain 
! *****************************************************************************
  USE types
  USE rk_interface
  USE vdp_interface
  USE vdp_data
! *****************************************************************************
  IMPLICIT NONE
  CHARACTER(20)                                 :: out_file
  REAL(DP)                                      :: xstart, xend, xdelta
  REAL(DP)                                      :: x
  INTEGER                                       :: numdat
  INTEGER                                       :: u1 = 1
  INTEGER                                       :: i
  REAL(DP), DIMENSION(2)                        :: ystart
  REAL(DP), DIMENSION(2)                        :: y
  REAL(DP), DIMENSION(:),   ALLOCATABLE         :: xvec
  REAL(DP), DIMENSION(:,:), ALLOCATABLE         :: yvec
! *****************************************************************************
! Read input file
  OPEN(unit=u1,file='vdp.in',status='old',form='formatted')
  READ (u1,*) out_file
  READ (u1,*) xstart
  READ (u1,*) xend
  READ (u1,*) numdat
  READ (u1,*) ystart(1)
  READ (u1,*) ystart(2)
  READ (u1,*) mu
  CLOSE(unit=u1)

  xdelta = (xend-xstart) / (numdat-1)
  x = xstart
  y = ystart
! *****************************************************************************
  OPEN(unit=u1,file=out_file,status='unknown',form='formatted')
! *****************************************************************************
! Loop for all x-values and output
! DO
!    WRITE (u1,*) x, y(1), y(2)
!    IF (x > xend) EXIT
!    CALL rk4s(vdp,x,y,xdelta)
! END DO
! *****************************************************************************
! Compute results for vector xvec 
  ALLOCATE ( xvec(numdat) )
  ALLOCATE ( yvec(SIZE(y),numdat) )

  xvec = (/ (xstart+(i-1)*xdelta, i=1,numdat) /)
  yvec(:,1) = ystart(:)
  CALL rk4t(vdp,xvec,yvec)
  DO i = 1,numdat
     WRITE(u1,*) xvec(i), yvec(1,i), yvec(2,i)
  END DO

  DEALLOCATE (xvec)
  DEALLOCATE (yvec)
! *****************************************************************************
! *****************************************************************************
  CLOSE(unit=u1)
END PROGRAM vdpmain






