(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7284,        246]*)
(*NotebookOutlinePosition[      8146,        276]*)
(*  CellTagsIndexPosition[      8102,        272]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\

(The functions used in this notebook require the C++ NCGB module.)\
\>", 
  "Text",
  Editable->False,
  FontSize->14],

Cell[CellGroupData[{

Cell["\<\

       The Partially Prescribed Inverse Problem
\
\>", "H2",
  Editable->False,
  CellFrame->{{0, 0}, {2, 0}},
  TextAlignment->Center,
  TextJustification->0.5],

Cell["\<\

This is a type of problem known as a matrix completion problem. This \
particular one was  suggested by Hugo Woerdeman.   We are grateful to him for \
discussions.
\
\>", "Text",
  Editable->False],

Cell["\<\
Problem:
     \tGiven matrices a, b, c,  and  d,    we  wish to determine under what \
conditions there exists matrices  x,  y,  z, and w such that the block \
matrices\
\>", "Text",
  Editable->False],

Cell[TextData[{
  "     \n     ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {"a", "x"},
              {"y", "b"}
              }], ")"}], TraditionalForm]]],
  "                       ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {"w", "c"},
              {"d", "z"}
              }], ")"}], TraditionalForm]]]
}], "Text",
  Editable->False,
  TextAlignment->Center],

Cell[TextData[{
  "\nare inverses of each other.     Also, we wish to find formulas for x,  \
y, z,  and  w.\n\n    This problem was solved in a paper by  W.W. Barrett, \
C.R. Johnson, M. E. Lundquist  and H. Woerderman  ",
  StyleBox["[BJLW]",
    FontWeight->"Bold"],
  " where  they showed it splits into several cases depending upon which of \
a, b, c and d are invertible. In our example, we assume that a, b, c and d  \
are invertible and discover the result which they obtain in this case."
}], "Text",
  Editable->False,
  CellFrame->{{0, 0}, {2, 0}}],

Cell["\<\
First we set all of our variables to be noncommutative and set up \
the relations which make matrices a, b, c, and d invertible.  (Inverses in \
this particular problem are taken to be two sided.)   Strong invertibility \
relations help when one is trying to get an idea of the solution of the \
problem.
\
\>", "Text",
  Editable->False,
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\n\ \ \ \ \ \ \ \ \ \ \ \ \ 
    SNC[a, b, c, d, w, x, y, z, \n\t\ Inv[a], \ \ Inv[b], \ Inv[c]\ , 
      Inv[d]\ \ ]\n\)\)], "Input"],

Cell[BoxData[
    \({False, False, False, False, False, False, False, False, False, False, 
      False, False}\)], "Output"]
}, Open  ]],

Cell["\<\
Then we define the relations we are interested in.   The  two \
relations below set our block matrices as inverses of each other.
\
\>", "Text",
  Editable->False,
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(first\  = \ {{a, x}, {y, b}}\), 
    \(second\  = \ {{w, c}, {d, z}}\)}], "Input"],

Cell[BoxData[
    \({{a, x}, {y, b}}\)], "Output"],

Cell[BoxData[
    \({{w, c}, {d, z}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\noneway\  = MatMult[first, second]\  - \ IdentityMatrix[2]\), 
    \(otherway\  = \ \n\ \ \ \ \ 
      MatMult[second, first] - \ \ IdentityMatrix[2]\)}], "Input"],

Cell[BoxData[
    \({{\(-1\) + a**w + x**d, a**c + x**z}, {b**d + y**w, 
        \(-1\) + b**z + y**c}}\)], "Output"],

Cell[BoxData[
    \({{\(-1\) + c**y + w**a, c**b + w**x}, {d**a + z**y, 
        \(-1\) + d**x + z**b}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\nstart\  = \ Flatten[{\ oneway, \ otherway\ \ }]\n\), 
    \(inverses\  = 
      \ {\(-1\)\  + \ a\ **\ Inv[a], \ \(-1\)\  + \ Inv[a]\ **\ a, \n\ \ \ \ 
        \(-1\)\  + \ b\ **\ Inv[b], \ \(-1\)\  + \ Inv[b]\ **\ b, \n\ \ \ \ 
        \(-1\)\  + \ c\ **\ Inv[c], \ \(-1\)\  + \ Inv[c]\ **\ c, \n\ \ \ \ \ 
        \(-1\)\  + \ d\ **\ Inv[d], \ \(-1\)\  + \ Inv[d]\ **\ d\ \n\t}\n\), 
    \(start = Join[start, inverses]\)}], "Input"],

Cell[BoxData[
    \({\(-1\) + a**w + x**d, a**c + x**z, b**d + y**w, \(-1\) + b**z + y**c, 
      \(-1\) + c**y + w**a, c**b + w**x, d**a + z**y, \(-1\) + d**x + z**b}
      \)], "Output"],

Cell[BoxData[
    \({\(-1\) + a**Inv[a], \(-1\) + Inv[a]**a, \(-1\) + b**Inv[b], 
      \(-1\) + Inv[b]**b, \(-1\) + c**Inv[c], \(-1\) + Inv[c]**c, 
      \(-1\) + d**Inv[d], \(-1\) + Inv[d]**d}\)], "Output"],

Cell[BoxData[
    \({\(-1\) + a**w + x**d, a**c + x**z, b**d + y**w, \(-1\) + b**z + y**c, 
      \(-1\) + c**y + w**a, c**b + w**x, d**a + z**y, \(-1\) + d**x + z**b, 
      \(-1\) + a**Inv[a], \(-1\) + Inv[a]**a, \(-1\) + b**Inv[b], 
      \(-1\) + Inv[b]**b, \(-1\) + c**Inv[c], \(-1\) + Inv[c]**c, 
      \(-1\) + d**Inv[d], \(-1\) + Inv[d]**d}\)], "Output"]
}, Open  ]],

Cell["\<\
Specify to NCAlgebra which variables are known and which are \
unknown.
\
\>", "Text",
  Editable->False,
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[BoxData[{
    \(\nSetKnowns[a, Inv[a], b, Inv[b], c, Inv[c], d, Inv[d]]\n\), 
    \(SetUnknowns[{z}, {x, y, w}]\n\)}], "Input"],

Cell["\<\
Tell NCAlgebra to solve for our unknown variables
\
\>", "Text",
  Editable->False,
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[BoxData[
    \(\(\n\ \ \n\(answer = NCProcess2[start, 4, \ "\<DemoGBMA\>"\ ]; \)\n\n
    \)\)], "Input"],

Cell["\<\

The spreadsheet which appears shows that, if a, b, c and d are invertible, \
then one can find x, y, z and w such that the matrices above are inverses of \
each other if and only if z b z = z + d a c.

The spreadsheet also gives formulas for x, y and w in terms of z.
\
\>", "Text",
  Editable->False]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{895, 832},
WindowMargins->{{142, Automatic}, {47, Automatic}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1},
StyleDefinitions -> "HTML.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 129, 6, 52, "Text"],

Cell[CellGroupData[{
Cell[1863, 59, 172, 8, 119, "H2"],
Cell[2038, 69, 208, 7, 106, "Text"],
Cell[2249, 78, 211, 6, 83, "Text"],
Cell[2463, 86, 433, 17, 80, "Text"],
Cell[2899, 105, 559, 11, 162, "Text"],
Cell[3461, 118, 402, 10, 122, "Text"],

Cell[CellGroupData[{
Cell[3888, 132, 156, 3, 101, "Input"],
Cell[4047, 137, 125, 2, 52, "Output"]
}, Open  ]],
Cell[4187, 142, 227, 7, 99, "Text"],

Cell[CellGroupData[{
Cell[4439, 153, 103, 2, 55, "Input"],
Cell[4545, 157, 50, 1, 31, "Output"],
Cell[4598, 160, 50, 1, 31, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4685, 166, 185, 3, 101, "Input"],
Cell[4873, 171, 117, 2, 31, "Output"],
Cell[4993, 175, 117, 2, 31, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5147, 182, 458, 7, 239, "Input"],
Cell[5608, 191, 188, 3, 52, "Output"],
Cell[5799, 196, 208, 3, 52, "Output"],
Cell[6010, 201, 362, 5, 94, "Output"]
}, Open  ]],
Cell[6387, 209, 169, 7, 76, "Text"],
Cell[6559, 218, 132, 2, 124, "Input"],
Cell[6694, 222, 147, 6, 76, "Text"],
Cell[6844, 230, 109, 2, 124, "Input"],
Cell[6956, 234, 312, 9, 152, "Text"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

