(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23328,        802]*)
(*NotebookOutlinePosition[     24133,        830]*)
(*  CellTagsIndexPosition[     24089,        826]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Examples", "Title"],

Cell["\<\
Now we do a couple of examples.  The first example illustrates \
basic 
techniques. The second example is more specialized. Many more examples
can be found in the file SYSDOC.doc.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Simplifying a Complicated Expression", "Section"],

Cell["\<\
The next example is one most people would be advised to work \
through.
Note that the output of In[1] below will change based upon
which version of NCAlgebra you have. We have not changed this
output each time we have a new release. If the example
does not work in any way, let us know.\
\>", "Text"],

Cell["NCAlgebra.m\t\t\t\t\tload NCAlgebra package", "Text",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell["<<NCAlgebra.m", "Input"],

Cell["\<\
You see a new window pop out and a long list of files which \
NCAlgebra.m is loading 
scroll by on the screen.

There may be a few changes to what is documented above.\
\>", "Text"],

Cell["\<\
NCMessyFunction.m \t\t\tcontains several grubby functions. The \
variable coexz1 was defined in the \t\t\t\t\t\tfile NCMessyFunction.m.
\t\t\t\t\t\tAlso, a lot of variables are defined to be noncommutative in that \
file. \
\>", "Text",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell["\<\
As an exercise let us simplify the expression named coexz1.  \
\>", 
  "Text"],

Cell["<<NCMessyFunction.m", "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["A first approch", "Section"],

Cell[CellGroupData[{

Cell["coexz1", "Input"],

Cell[BoxData[
    \(\(-tp[C1]**C1\) - X**B2**C1 - tp[C1]**tp[B2]**X - X**B2**tp[B2]**X - 
      X**inv[1 - Y**X]**B1**C2 + inv[Y]**inv[1 - Y**X]**B1**C2 - 
      X**inv[1 - Y**X]**B1**tp[B1]**X - X**inv[1 - Y**X]**Y**tp[C2]**C2 + 
      inv[Y]**inv[1 - Y**X]**B1**tp[B1]**X + 
      inv[Y]**inv[1 - Y**X]**Y**tp[C2]**C2 - 
      X**inv[1 - Y**X]**Y**tp[C2]**tp[B1]**X + 
      inv[Y]**inv[1 - Y**X]**Y**tp[C2]**tp[B1]**X\)], "Output"]
}, Open  ]],

Cell["\<\
NCForward[coexz1]\t\t\t\tApplies the basic rule     X**inv[1-Y**X] \
-> inv[1-X**Y]**Y\
\>", "Text",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[CellGroupData[{

Cell["NCForward[coexz1]  ", "Input"],

Cell[BoxData[
    \(\(-tp[C1]**C1\) - X**B2**C1 + inv[1 - X**Y]**tp[C2]**C2 - 
      tp[C1]**tp[B2]**X - X**B2**tp[B2]**X - inv[1 - X**Y]**X**B1**C2 + 
      inv[1 - X**Y]**inv[Y]**B1**C2 + inv[1 - X**Y]**tp[C2]**tp[B1]**X - 
      inv[1 - X**Y]**X**B1**tp[B1]**X - inv[1 - X**Y]**X**Y**tp[C2]**C2 + 
      inv[1 - X**Y]**inv[Y]**B1**tp[B1]**X - 
      inv[1 - X**Y]**X**Y**tp[C2]**tp[B1]**X\)], "Output"]
}, Open  ]],

Cell["\<\
NCCollect[ %, B1 ** C2 ]\t\t\tCollects the terms B1 ** C2 of the \
last expression.\
\>", "Text",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell["\<\
A glance at the last expression reveals that B1 ** C2 occurs on the \
outside of 
several terms. Let us Collect these terms.\
\>", "Text"],

Cell[CellGroupData[{

Cell["NCCollect[ %, B1 ** C2 ] ", "Input"],

Cell[BoxData[
    \(\(-tp[C1]**C1\) - X**B2**C1 + inv[1 - X**Y]**tp[C2]**C2 - 
      \((inv[1 - X**Y]**X - inv[1 - X**Y]**inv[Y])\)**B1**C2 - 
      tp[C1]**tp[B2]**X - X**B2**tp[B2]**X + 
      inv[1 - X**Y]**tp[C2]**tp[B1]**X - inv[1 - X**Y]**X**B1**tp[B1]**X - 
      inv[1 - X**Y]**X**Y**tp[C2]**C2 + 
      inv[1 - X**Y]**inv[Y]**B1**tp[B1]**X - 
      inv[1 - X**Y]**X**Y**tp[C2]**tp[B1]**X\)], "Output"]
}, Open  ]],

Cell[TextData[StyleBox[
"SetOutput[all -> True]\t\t\tDoes nothing but beautify the screen Output\n\t\t\
\t\t\t\t\t\tBe suspicious when working with parts of the \t\t\t\t\t\t\t\t\t\t\
output if you have used this. "]], "Text",
  CellFrame->True,
  FontFamily->"Courier",
  Background->GrayLevel[0.849989]],

Cell[TextData[StyleBox[" SetOutput[all->True]"]], "Input"],

Cell[TextData[StyleBox["NCC is an alias for NCCollect."]], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NCC[ %%, B1 ** tp[B1] ** X ]"]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"-", 
        RowBox[{
          TagBox[\(C1\^"T"\),
            HoldForm], ".", "C1"}]}], "-", \(X.B2.C1\), "-", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              TagBox[\(\((1 - X.Y)\)\^"-1"\),
                HoldForm], ".", "X"}], "-", 
            RowBox[{
              TagBox[\(\((1 - X.Y)\)\^"-1"\),
                HoldForm], ".", 
              TagBox[\(Y\^"-1"\),
                HoldForm]}]}], ")"}], ".", "B1", ".", "C2"}], "-", 
      RowBox[{
        TagBox[\(C1\^"T"\),
          HoldForm], ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(\((1 - X.Y)\)\^"-1"\),
          HoldForm], ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", "C2"}], "-", 
      RowBox[{"X", ".", "B2", ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "-", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              TagBox[\(\((1 - X.Y)\)\^"-1"\),
                HoldForm], ".", "X"}], "-", 
            RowBox[{
              TagBox[\(\((1 - X.Y)\)\^"-1"\),
                HoldForm], ".", 
              TagBox[\(Y\^"-1"\),
                HoldForm]}]}], ")"}], ".", "B1", ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(\((1 - X.Y)\)\^"-1"\),
          HoldForm], ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}], "-", 
      RowBox[{
        TagBox[\(\((1 - X.Y)\)\^"-1"\),
          HoldForm], ".", "X", ".", "Y", ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", "C2"}], "-", 
      RowBox[{
        TagBox[\(\((1 - X.Y)\)\^"-1"\),
          HoldForm], ".", "X", ".", "Y", ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}]}]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox[
"Substitute[expr,rules]\t\t\tReplace one symbol or sub-expression in the \t\t\
\t\t\t\t\t\t\t\texpression expr as specified by the rule. "]], "Text",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[StyleBox[
"Here we are using an approach that favors collecting pairs of terms that \n\
have similar leftmost inv[1-X**Y]'s and rightmost non-inv[1-X**Y] \nparts.  \
And now, we are substituting the identity:\n      inv[1-a**b]**b - \
inv[1-a**b]**inv[b] == -inv[b]"]], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"Substitute[%, inv[1-X**Y]**X - inv[1-X**Y]**inv[Y] -> -inv[Y]] "]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"-", 
        RowBox[{
          TagBox[\(C1\^"T"\),
            HoldForm], ".", "C1"}]}], "-", \(X.B2.C1\), "-", 
      RowBox[{
        TagBox[\(C1\^"T"\),
          HoldForm], ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", "C2"}], "+", 
      RowBox[{
        TagBox[\(\((1 - X.Y)\)\^"-1"\),
          HoldForm], ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", "C2"}], "-", 
      RowBox[{"X", ".", "B2", ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(\((1 - X.Y)\)\^"-1"\),
          HoldForm], ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}], "-", 
      RowBox[{
        TagBox[\(\((1 - X.Y)\)\^"-1"\),
          HoldForm], ".", "X", ".", "Y", ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", "C2"}], "-", 
      RowBox[{
        TagBox[\(\((1 - X.Y)\)\^"-1"\),
          HoldForm], ".", "X", ".", "Y", ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}]}]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox[
"NCBackward[coexz1]\t\t\tapplies the basic rule        X**inv[1-Y**X] <- \
inv[1-X**Y]**Y"]], "Text",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[StyleBox[
"NCBackward will cause the inv[1-X**Y] in the last two terms \nto hide behind \
the X**Y, so that when we collect on inv[1-X**Y] \nwe will be extracting \
inv[1-X**Y] and (1-X**Y) at the same time."]], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NCBackward[%]"]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"-", 
        RowBox[{
          TagBox[\(C1\^"T"\),
            HoldForm], ".", "C1"}]}], "-", \(X.B2.C1\), "-", 
      RowBox[{
        TagBox[\(C1\^"T"\),
          HoldForm], ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", "C2"}], "+", 
      RowBox[{
        TagBox[\(\((1 - X.Y)\)\^"-1"\),
          HoldForm], ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", "C2"}], "-", 
      RowBox[{"X", ".", "B2", ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(\((1 - X.Y)\)\^"-1"\),
          HoldForm], ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}], "-", 
      RowBox[{"X", ".", "Y", ".", 
        TagBox[\(\((1 - X.Y)\)\^"-1"\),
          HoldForm], ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", "C2"}], "-", 
      RowBox[{"X", ".", "Y", ".", 
        TagBox[\(\((1 - X.Y)\)\^"-1"\),
          HoldForm], ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}]}]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox["Finaly we collect on inv[1-X**Y]"]], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NCC[ %, inv[1-X**Y] ]"]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"-", 
        RowBox[{
          TagBox[\(C1\^"T"\),
            HoldForm], ".", "C1"}]}], "+", 
      RowBox[{
        TagBox[\(C2\^"T"\),
          HoldForm], ".", "C2"}], "-", \(X.B2.C1\), "-", 
      RowBox[{
        TagBox[\(C1\^"T"\),
          HoldForm], ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", "C2"}], "-", 
      RowBox[{"X", ".", "B2", ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}]}]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox[
"\nWe are FINISHED simplifying according to some tastes,\n because all \
inv[1-X**Y] terms are gone.\n There is ANOTHER WAY which works on some things \
but not others. "]], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["A second approch"]], "Section"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["coexz1"]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"-", 
        RowBox[{
          TagBox[\(C1\^"T"\),
            HoldForm], ".", "C1"}]}], "-", \(X.B2.C1\), "-", 
      RowBox[{
        TagBox[\(C1\^"T"\),
          HoldForm], ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "-", 
      RowBox[{"X", ".", "B2", ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "-", 
      RowBox[{"X", ".", 
        TagBox[\(\((1 - Y.X)\)\^"-1"\),
          HoldForm], ".", "B1", ".", "C2"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", 
        TagBox[\(\((1 - Y.X)\)\^"-1"\),
          HoldForm], ".", "B1", ".", "C2"}], "-", 
      RowBox[{"X", ".", 
        TagBox[\(\((1 - Y.X)\)\^"-1"\),
          HoldForm], ".", "B1", ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}], "-", 
      RowBox[{"X", ".", 
        TagBox[\(\((1 - Y.X)\)\^"-1"\),
          HoldForm], ".", "Y", ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", "C2"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", 
        TagBox[\(\((1 - Y.X)\)\^"-1"\),
          HoldForm], ".", "B1", ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", 
        TagBox[\(\((1 - Y.X)\)\^"-1"\),
          HoldForm], ".", "Y", ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", "C2"}], "-", 
      RowBox[{"X", ".", 
        TagBox[\(\((1 - Y.X)\)\^"-1"\),
          HoldForm], ".", "Y", ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", 
        TagBox[\(\((1 - Y.X)\)\^"-1"\),
          HoldForm], ".", "Y", ".", 
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}]}]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox[
" NCSimplifyRational[expr]\t\t\tis based on automatically applying a \
carefully chosen \n\t\t\t\t\t\tcollection of rules like NCBackward and \
subtitute repeatedly.\n \t\t\t\t\t\tRules can be added so it should get \
better and better \n\t\t\t\t\t\t(that is, work well on many expressions.)  \
"]], "Text",
  CellFrame->True,
  ShowSpecialCharacters->True,
  Background->GrayLevel[0.849989]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["result=NCSimplifyRational[coexz1]"]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"-", 
        RowBox[{
          TagBox[\(C1\^"T"\),
            HoldForm], ".", "C1"}]}], "+", 
      RowBox[{
        TagBox[\(C2\^"T"\),
          HoldForm], ".", "C2"}], "-", \(X.B2.C1\), "-", 
      RowBox[{
        TagBox[\(C1\^"T"\),
          HoldForm], ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", "C2"}], "-", 
      RowBox[{"X", ".", "B2", ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["WHAMMO!",
    FontSize->24],
  StyleBox[" We got the answer in one shot."]
}], "Text"],

Cell[TextData[StyleBox[
"We now turn to making the expression shorter by factoring. It is a good \
exercise."]], "Text",
  FontFamily->"Courier"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Condensing the expression"]], "Section"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NCC[result, tp[C2]] "]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"-", 
        RowBox[{
          TagBox[\(C1\^"T"\),
            HoldForm], ".", "C1"}]}], "+", 
      RowBox[{
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        RowBox[{"(", 
          RowBox[{"C2", "+", 
            RowBox[{
              TagBox[\(B1\^"T"\),
                HoldForm], ".", "X"}]}], ")"}]}], "-", \(X.B2.C1\), "-", 
      RowBox[{
        TagBox[\(C1\^"T"\),
          HoldForm], ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", "C2"}], "-", 
      RowBox[{"X", ".", "B2", ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", 
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NCC[ %, inv[Y] ** B1 ]"]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"-", 
        RowBox[{
          TagBox[\(C1\^"T"\),
            HoldForm], ".", "C1"}]}], "+", 
      RowBox[{
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        RowBox[{"(", 
          RowBox[{"C2", "+", 
            RowBox[{
              TagBox[\(B1\^"T"\),
                HoldForm], ".", "X"}]}], ")"}]}], "-", \(X.B2.C1\), "-", 
      RowBox[{
        TagBox[\(C1\^"T"\),
          HoldForm], ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", 
        RowBox[{"(", 
          RowBox[{"C2", "+", 
            RowBox[{
              TagBox[\(B1\^"T"\),
                HoldForm], ".", "X"}]}], ")"}]}], "-", 
      RowBox[{"X", ".", "B2", ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NCC[ %, C1 ]"]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{\(X.B2\), "+", 
              TagBox[\(C1\^"T"\),
                HoldForm]}], ")"}], ".", "C1"}]}], "+", 
      RowBox[{
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        RowBox[{"(", 
          RowBox[{"C2", "+", 
            RowBox[{
              TagBox[\(B1\^"T"\),
                HoldForm], ".", "X"}]}], ")"}]}], "-", 
      RowBox[{
        TagBox[\(C1\^"T"\),
          HoldForm], ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", 
        RowBox[{"(", 
          RowBox[{"C2", "+", 
            RowBox[{
              TagBox[\(B1\^"T"\),
                HoldForm], ".", "X"}]}], ")"}]}], "-", 
      RowBox[{"X", ".", "B2", ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NCC[%,tp[B2]**X]"]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{\(X.B2\), "+", 
              TagBox[\(C1\^"T"\),
                HoldForm]}], ")"}], ".", "C1"}]}], "+", 
      RowBox[{
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        RowBox[{"(", 
          RowBox[{"C2", "+", 
            RowBox[{
              TagBox[\(B1\^"T"\),
                HoldForm], ".", "X"}]}], ")"}]}], "-", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{\(X.B2\), "+", 
            TagBox[\(C1\^"T"\),
              HoldForm]}], ")"}], ".", 
        TagBox[\(B2\^"T"\),
          HoldForm], ".", "X"}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", 
        RowBox[{"(", 
          RowBox[{"C2", "+", 
            RowBox[{
              TagBox[\(B1\^"T"\),
                HoldForm], ".", "X"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox[
"This is standard Mathematica, picking a \"part\" of an expression."]], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["factor = %[[ 1,2,1 ]]"]], "Input"],

Cell[BoxData[
    \(General::"spell" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(factor\)\" is similar \
to existing symbols \!\({Factor, factors}\)."\)], "Message"],

Cell[BoxData[
    RowBox[{\(X.B2\), "+", 
      TagBox[\(C1\^"T"\),
        HoldForm]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NCC[ %%, factor ]"]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{\(X.B2\), "+", 
              TagBox[\(C1\^"T"\),
                HoldForm]}], ")"}], ".", 
          RowBox[{"(", 
            RowBox[{"C1", "+", 
              RowBox[{
                TagBox[\(B2\^"T"\),
                  HoldForm], ".", "X"}]}], ")"}]}]}], "+", 
      RowBox[{
        TagBox[\(C2\^"T"\),
          HoldForm], ".", 
        RowBox[{"(", 
          RowBox[{"C2", "+", 
            RowBox[{
              TagBox[\(B1\^"T"\),
                HoldForm], ".", "X"}]}], ")"}]}], "+", 
      RowBox[{
        TagBox[\(Y\^"-1"\),
          HoldForm], ".", "B1", ".", 
        RowBox[{"(", 
          RowBox[{"C2", "+", 
            RowBox[{
              TagBox[\(B1\^"T"\),
                HoldForm], ".", "X"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["factor = %[[2,2]]"]], "Input"],

Cell[BoxData[
    RowBox[{"C2", "+", 
      RowBox[{
        TagBox[\(B1\^"T"\),
          HoldForm], ".", "X"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NCC[ %%, factor ]"]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"-", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{\(X.B2\), "+", 
              TagBox[\(C1\^"T"\),
                HoldForm]}], ")"}], ".", 
          RowBox[{"(", 
            RowBox[{"C1", "+", 
              RowBox[{
                TagBox[\(B2\^"T"\),
                  HoldForm], ".", "X"}]}], ")"}]}]}], "+", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              TagBox[\(Y\^"-1"\),
                HoldForm], ".", "B1"}], "+", 
            TagBox[\(C2\^"T"\),
              HoldForm]}], ")"}], ".", 
        RowBox[{"(", 
          RowBox[{"C2", "+", 
            RowBox[{
              TagBox[\(B1\^"T"\),
                HoldForm], ".", "X"}]}], ")"}]}]}]], "Output"]
}, Open  ]],

Cell[TextData[StyleBox["\nThis is about as good as I can do."]], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->None,
WindowSize->{667, 646},
WindowMargins->{{Automatic, 292}, {114, Automatic}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 25, 0, 68, "Title"],
Cell[1759, 53, 203, 5, 47, "Text"],

Cell[CellGroupData[{
Cell[1987, 62, 55, 0, 42, "Section"],
Cell[2045, 64, 310, 7, 71, "Text"],
Cell[2358, 73, 113, 2, 40, "Text"],
Cell[2474, 77, 30, 0, 22, "Input"],
Cell[2507, 79, 191, 6, 59, "Text"],
Cell[2701, 87, 300, 7, 64, "Text"],
Cell[3004, 96, 88, 3, 24, "Text"],
Cell[3095, 101, 36, 0, 22, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3168, 106, 34, 0, 42, "Section"],

Cell[CellGroupData[{
Cell[3227, 110, 23, 0, 22, "Input"],
Cell[3253, 112, 434, 7, 66, "Output"]
}, Open  ]],
Cell[3702, 122, 164, 5, 40, "Text"],

Cell[CellGroupData[{
Cell[3891, 131, 36, 0, 22, "Input"],
Cell[3930, 133, 405, 6, 57, "Output"]
}, Open  ]],
Cell[4350, 142, 161, 5, 48, "Text"],
Cell[4514, 149, 148, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[4687, 157, 42, 0, 27, "Input"],
Cell[4732, 159, 410, 7, 91, "Output"]
}, Open  ]],
Cell[5157, 169, 304, 6, 81, "Text"],
Cell[5464, 177, 58, 0, 27, "Input"],
Cell[5525, 179, 66, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[5616, 183, 65, 0, 27, "Input"],
Cell[5684, 185, 1944, 61, 62, "Output"]
}, Open  ]],
Cell[7643, 249, 227, 4, 66, "Text"],
Cell[7873, 255, 291, 4, 86, "Text"],

Cell[CellGroupData[{
Cell[8189, 263, 101, 1, 27, "Input"],
Cell[8293, 266, 1392, 45, 62, "Output"]
}, Open  ]],
Cell[9700, 314, 179, 4, 48, "Text"],
Cell[9882, 320, 233, 3, 47, "Text"],

Cell[CellGroupData[{
Cell[10140, 327, 50, 0, 22, "Input"],
Cell[10193, 329, 1392, 45, 45, "Output"]
}, Open  ]],
Cell[11600, 377, 68, 0, 24, "Text"],

Cell[CellGroupData[{
Cell[11693, 381, 58, 0, 22, "Input"],
Cell[11754, 383, 864, 29, 31, "Output"]
}, Open  ]],
Cell[12633, 415, 205, 3, 59, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12875, 423, 55, 0, 42, "Section"],

Cell[CellGroupData[{
Cell[12955, 427, 43, 0, 22, "Input"],
Cell[13001, 429, 1942, 61, 79, "Output"]
}, Open  ]],
Cell[14958, 493, 416, 8, 102, "Text"],

Cell[CellGroupData[{
Cell[15399, 505, 70, 0, 27, "Input"],
Cell[15472, 507, 864, 29, 45, "Output"]
}, Open  ]],
Cell[16351, 539, 114, 4, 44, "Text"],
Cell[16468, 545, 145, 3, 31, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16650, 553, 64, 0, 52, "Section"],

Cell[CellGroupData[{
Cell[16739, 557, 57, 0, 27, "Input"],
Cell[16799, 559, 877, 29, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17713, 593, 59, 0, 27, "Input"],
Cell[17775, 595, 879, 29, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18691, 629, 49, 0, 27, "Input"],
Cell[18743, 631, 938, 31, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19718, 667, 53, 0, 27, "Input"],
Cell[19774, 669, 908, 30, 28, "Output"]
}, Open  ]],
Cell[20697, 702, 103, 1, 32, "Text"],

Cell[CellGroupData[{
Cell[20825, 707, 58, 0, 27, "Input"],
Cell[20886, 709, 186, 3, 24, "Message"],
Cell[21075, 714, 99, 3, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21211, 722, 54, 0, 22, "Input"],
Cell[21268, 724, 858, 28, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22163, 757, 54, 0, 22, "Input"],
Cell[22220, 759, 126, 4, 22, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22383, 768, 54, 0, 22, "Input"],
Cell[22440, 770, 773, 25, 22, "Output"]
}, Open  ]],
Cell[23228, 798, 72, 0, 35, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

