(* :Title: 	NCAlias.m // Mathematica 1.2 and 2.0 *)

(* :Author: 	David Hurst (dhurst). *)

(* :Context: 	$Pre` *)

(* :Summary: 	NCAlias[] is the value of $Pre which serves as aliasses
		on the Mathematica command line.
*)

(* :Warnings:   Use aliases only at the Mathematica prompt, not in files. *) 

(* :History: 
   :5/6/92	Created. (dhurst)
   :8/21/92  	Added usage statement, reformatted file. (dhurst)
   :5/2/95      Added Contexts.
*)

NCAlias ::usage = 
     "NCAlias[] is the value of $Pre (alias) for NCAlgebra."

NCAliasRule = {
               (* :NCCollect.m *)
                    NCDec -> NCCollect`NCDecompose,
                    NCCom -> NCCollect`NCCompose,
                    NCC -> NCCollect`NCCollect,
                    NCSC -> NCStrongCollect,
                    NCCSym -> NCCollect`NCCollectSymmetric,
                        
               (* :NCComplex.m: *)
                    CAR -> ComplexRules`ComplexAlgebraRules,
                    RCAR -> ComplexRules`ReverseComplexAlgebraRules,

               (* :NCDiff.m *)
                    DirD -> NCDiff`DirectionalD,
                    DirDP -> NCDiff`DirectionalDPolynomial,
                    Cri -> NCDiff`CriticalPoint,
                    Crit -> NCDiff`CriticalPoint,
                    GradPoly -> NCDiff`Grad,
                    
               (* :NCDoTeX.m: *)
                    ExprToTeXFile -> TeXStuff`ExpressionToTeXFile,

               (* :NCInverse.m *)
                    NCForward -> NonCommutativeMultiply`NCInverseForward,
                    NCBackward -> NonCommutativeMultiply`NCInverseBackward,
                    NCF -> NonCommutativeMultiply`NCInverseForward,
                    NCB -> NonCommutativeMultiply`NCInverseBackward,
                    NCEI -> NonCommutativeMultiply`NCExpandInverse,
                    NCETP -> NonCommutativeMultiply`NCExpandTranspose,

               (* :NCMatMult.m *)
                    MM -> NCMatMult`MatMult,
                    NCMTMM -> NCMatMult`NCMToMatMult,
                    tpM -> NCMatMult`tpMat,
                    GauE -> NCMatMult`GaussElimination,
                    
               (* :NCMultiplication.m  *)
                    NCExpand -> NonCommutativeMultiply`ExpandNonCommutativeMultiply,
                    ENCM -> NonCommutativeMultiply`ExpandNonCommutativeMultiply,
                    NCE -> NonCommutativeMultiply`ExpandNonCommutativeMultiply,

                    TTNCM -> NonCommutativeMultiply`TimesToNCM,
                    CE -> NonCommutativeMultiply`CommuteEverything,
                    CQ -> NonCommutativeMultiply`CommutativeQ,
                        
               (* :NC1SetCommands.m *)
                    SNC -> NonCommutativeMultiply`SetNonCommutative,
                    NCM -> System`NonCommutativeMultiply,
                    SetNC -> NonCommutativeMultiply`SetNonCommutative,
                        
               (* :NC( 012)SimplifyRational.m *)
                    NCSR -> NCSimplifyRational`NCSimplifyRational,
                    NCS1R -> NCSimplify1Rational`NCSimplify1Rational,
                    NCS2R -> NCSimplify2Rational`NCSimplify2Rational,
                    NCIE -> NCSimplify2Rational`NCInvExtractor,
                    MSR -> NCSimplify2Rational`MakeSimplifyingRule,

               (* :NCSolve.m *)
                    NCSolve -> NCSolveLinear1`NCSolveLinear1,

               (* :NCSubstitute.m *)
                    Sub -> NCSubstitute`Substitute,
                    SubR -> NCSubstitute`SubstituteReverse,
                    SubRev -> NCSubstitute`SubstituteReverse,
                    SubSym -> NCSubstitute`SubstituteSymmetric,
                    SubRSym -> NCSubstitute`SubstituteReverseSymmetric,
                    SubRevSym -> NCSubstitute`SubstituteReverseSymmetric,
                    SubSingleRep -> NCSubstitute`SubstituteSingleReplace,
                    SubAll -> NCSubstitute`SubstituteAll,
                    SaveR -> NCSubstitute`SaveRules,
                    SaveRQ -> NCSubstitute`SaveRulesQ,
                    FORules -> NCSubstitute`FunctionOnRules,

               (* :NCTools.m: *)
                    NCHDP -> NCTools`NCHighestDegreePosition,
                    NCHD -> NCTools`NCHighestDegree,
                    LPR -> NCTools`LeftPatternRule,
                         
               (* :SYSHinf1.m: *)
                    LinDGKF -> LinearDGKF
          };

NCAlias[expr_] := Identity[expr/.NCAliasRule];

$Pre =NCAlias;

Map[(#[[1]][x___] := #[[2]][x];)&,NCAliasRule];
