

(* ------------------------------------------------------------------ *)
(* NCSimplifyRational                                                 *)
(* ------------------------------------------------------------------ *)
(* 9/20/91                                                            *)
(* ------------------------------------------------------------------ *)
(*                         Prolog                                     *)
(*                                                                    *)
(*    Purpose:  Simplify expressions involving inv[]'s.               *)
(*                                                                    *)
(*    Alias:  NCSR                                                    *)
(*                                                                    *)
(*    Description:  NCSimplifyRational[ 'expression' ]                *)
(*                  applies NCSimplify2Rational and                   *)
(*                  NCSimplify1Rational to an expression in order     *)
(*                  to simplify the expression.                       *)
(*                                                                    *)
(*    Arguments:  algebraic expressions                               *)
(*                                                                    *)
(*    Comments/Limitations:                                           *)
(*                                                                    *)
(*    -  Can not do equations.                                        *)
(*                                                                    *)
(* ------------------------------------------------------------------ *)
(*                      Change Log                                    *)
(*   Date               ----------                          WHO       *)
(*   ----                                                   ---       *)
(*   9/12	Packaged.			            dhurst    *)
(*                                                                    *)
(* ------------------------------------------------------------------ *)



BeginPackage[ "NCSimplifyRational`",
"NonCommutativeMultiply`" ,
"NCSimplify1Rational`", "NCSimplify2Rational`"  ]
 

NCSimplifyRational::usage =
     "NCSimplifyRational[ 'expression' ] applies NCSimplify2Rational and 
     NCSimplify1Rational to an expression in order to simplify the expression." 

Begin["`Private`"]

NCSimplifyRational[ expr__ ] :=
     Block[{},
          ExpandNonCommutativeMultiply[
               NCSimplify1Rational[
                    NCSimplify2Rational[
                         ExpandNonCommutativeMultiply[
                              expr
                         ]
                    ]
               ]
          ]
     ]

End[ ]

EndPackage[ ]
