(*
  This file is loaded by SetNCPath.m and by SetNCDir.m.
  We recommend loading SetNCPath.m.
  SetNCDir.m is used only at the development site.
*)
If[Not[Head[$NCDir$]===String]
  , Print["The file NCPathCommonFile.m was loaded before the $NCDir$ variable was set."];
    If[Not[Head[$NC$Loaded$NCLoader$]===String]
      , Print["This file should only be read in via the file SetNCPath.m"];
        Print["You installation of NCAlgebra and/or NCGB was not performed"];
        Print["correctly or there is a problem with the distribution of"];
        Print["this code via the file ",$NC$Loaded$NCLoader$];
      , Print["This file was loaded after"];
        Print["$NC$Loaded$NCLoader$ was set to ",$NC$Loaded$NCLoader$];
        Print["This is very odd. Send e-mail to ncalg@osiris.ucsd.edu"];
        Print["with the aboves messages included."];
    ];
];
(**************************************************************)
(* THE BUSINESS PART OF THE FILE                              *)

AppendTo[$Path,StringJoin[$NCDir$,"NCGB/MmaSource"]];
AppendTo[$Path,StringJoin[$NCDir$,"NCGB/Testing"]];
AppendTo[$Path,StringJoin[$NCDir$,"NCAlgebra"]];
AppendTo[$Path,StringJoin[$NCDir$,"NCGB/Testing/C++TestFiles"]];
AppendTo[$Path,StringJoin[$NCDir$,"NCGB/Testing/MmaTestFiles"]];

(**************************************************************)

WhatNCDirectoriesDoIHave[] := 
Module[{len,temp},
  len = StringLength[$NCDir$];
  temp = FileNames["*",StringTake[$NCDir$,{1,len-1}],1];
  Print[ColumnForm[temp]];
  Return[temp];
];
